use warnings;
use strict;

use Scalar::String qw(sclstr_downgraded sclstr_upgraded);
use Test::More tests => 401;

BEGIN { use_ok "Authen::DecHpwd", qw(lgi_hpwd UAI_C_PURDY_V); }

while(<DATA>) {
	my($salt, $username, $password, $hash) = split;
	$username = pack("H*", $username) if $username =~ s/\A\*//;
	$password = pack("H*", $password) if $password =~ s/\A\*//;
	$hash = pack("H*", $hash);
	is lgi_hpwd(sclstr_downgraded($username), sclstr_downgraded($password),
			UAI_C_PURDY_V, $salt),
		$hash;
	is lgi_hpwd(sclstr_upgraded($username), sclstr_upgraded($password),
			UAI_C_PURDY_V, $salt),
		$hash;
}

1;

__DATA__
50917 unclasping eviscerate 21001389884c2012
50482 jams daylight be51b11ee79c3f3c
32451 regurgitation Portsmouth f650e53db17033d2
37825 Sukarno orthodoxes cfd81d5f0bd4793a
23197 cartridge spliced e54743a7367b75f8
59499 solubles assassinate a369920a93b1f42c
58414 upsurge Phoenix 1fd2bee0f8822b2d
59512 Casablanca emasculating 131f0c727cfb2047
26962 Yenisei growing 62ba5c2d11df14f8
3755 Avicenna demolishing b5ab4adb494ad548
10311 instantaneous prized 8dc8c5380ec55f94
41216 dreamer punchy 7f32ef23593829fa
40670 Barber dowelled da9b93d858d06a92
6353 unlearned eloping c80caad73e742f5d
54771 farm disturbingly 3db83db0fe6df9d6
43455 philosophizes paperback 166b7b2274cbb7c4
58091 caesareans Banjarmasin a01b2f058933cd62
41077 plaints conceited a239d812093a40ae
47365 debris drown 9b93dae818428250
10135 huffier uniforms 65293fb967a58cc2
23234 replying repatriate 42b55e6b5c38581f
11450 minimum exampled 1e23769d176b996f
28980 subtitle Edinburgh 7222a9271ba4f33d
10298 sailboats prying 68721f5b5237e833
48333 heterosexuals librettists b60a284245ddbfbb
54741 esters Annette ae5e0566fb86d63d
34699 catechism cable 1339591d681b73ee
12678 celebrities patientest a49aed074967dbc8
2480 autistics blockade 2bc959bf7b86ad9d
14234 Azazel uncorrelated 825f0845a9c69354
8583 pretender grows 27d64f0b3c6298f7
32132 Cinderellas Everest 4c7218fddcc58e92
43566 traded spectacles 8c2ca3768014de05
27717 elate spry 774f4210617bcc6b
33771 declined contumely 3d73997d8919d70c
45449 bewildered refed 6c9ef62b2f98a21c
48546 orchestra snitch 8efbb267a85117b4
65349 unashamed terror c438c8d25539ac6d
10783 squadding perspicacious 2fc1b409569dd729
23600 croaks righteous 9d7373796d7fb66c
24897 sunning budding 6277a750d13ba3f4
11302 fazing pinpricks 49d2f47ce9d70c20
59473 confluent enfolded 33f6cd877cfb27d1
5081 branches speechless 5ee953b1d7ef8c2d
43679 limpid redwood 652204a39d28deee
43103 legislation Acheson 96f9dddbe75a09bb
57810 candelabra certainest abbfbf8d9d40ba02
25919 xenon tonsillitis 87676ac1b454a341
49158 subpoenaed Yellowstone ce0329a13f30d075
15030 fleeter reconnoiters 0c79fea4003a29e3
12828 cerebellums payoffs 608e7272ec1c1141
30462 independents archers 2a474319d7af3e21
50444 nationalities telltale 597dddde8f89ce3a
37992 magnetized camper eddf9c6a9b8bf890
5249 Piedmont naiads 68433a546b98a7a0
29915 airways Mexicans baa8858ca4b6bdd9
4014 compelling snorkeled 6876069d85f8af53
7080 swindlers corporals 7c3240f87841ff4b
61910 build outriders 6f18b40c7f3e398a
49483 shanties tryouts 399ddb59c0a9cde2
48962 presets firestorms 169f6446ec092727
24032 clack Theresa 5dfcfe0cd513c153
49908 Afghans speckles 10914508aca3b16e
8309 Gila functional 4e57fdad3d061fc4
16585 localing innovative 2953830df2e9e206
53946 reapportioned spaniel 1dd238357e7576c1
29849 sequined corporations 38f52e181051d8c2
36043 misquote anniversaries 6a104352118268fa
58509 studded emulating 09aba88cc9b21b16
18025 unclasps Minolta 6bbb684193382f84
46623 upheld binging f24db918c180188e
62399 decompose sonatas 2c2efab308bdfe6a
61285 packet wan ef194fc7875d54c1
16030 heartaches maturation 8f3daf9f5b11c7ad
26741 banquets razed 35d6d76c33ce69e7
38398 caulked unassigned e07d59ddb0024a2b
53377 demagogs branding b7545de591b64ef9
32981 hydraulics fleshier 5718df3a778aa23c
18206 tourists anyhow b100d514d66841ac
52705 trickiness Poe 74613ddd2fdda465
63160 rig lactate 8513ae1109c34c51
4129 portability Kayla 6231086969e4905a
62274 laze dolloped 2b36aba82f6633c0
1222 palimony Nanchang eb34cffcc4905fa1
35741 chatters traumatizing db9b2a0378655ed8
48874 rugging Trujillo a8d99ee58439077b
56315 detoxing contour 88592091f7520443
65215 stridently swamping 52699cd7c15d30d8
51574 sensor tributes 5e65b05238b2c4b8
59724 insurgences swaddled ae4753084a3de474
25998 notations skillets eadab2bf320bd680
37111 rain Bridget 2b285818676d38b6
54267 burdening Salerno 5e088a891d979dd2
16499 Cerf revived 3123b4d0dd1124da
24056 stuffy bourgeois 26b2256c42f56a84
4479 stars creak 4e157644622cc0c6
3410 mushes westerners 7528734a877e5bab
59737 Chappaquiddick repudiated b01f3fa64b19b6ff
29704 ids clomped 7c04a09c1a2fd525
365 mullah drivel d4982b580c0c6bc4
1309 *7c5d15969f7568e89c49c58e00c342da43a7ab883b247051a1a3aa91 *39d833548294a077f4656d93b2206eb4 d4ff386b933e4793
2644 *a5ce954374c4e698d92d5a493adca9835da2a166ef484050119dda22ff00456ee74b1c8f27d4bb *f418127f4870a887c9106fc6782287a8f863c75b83117d5b7802c9e54aef0606f8492eb7312c 09b0b0927afdb5b1
63778 *52ec0f82328a66318e25 *b917c57e46455827e5264061e6 34c44393bb7fbe08
64825 *1f84af8a3310e3fbefef9c *677d4531d1483ff8d697e04b27c46b691dbd1cc5db4e25a920da541d27831b265d5704 faed9b158c19d39a
4008 *6f56e9f3e10351c24c0b83ce9a9d37696d68fffff1d1dda0630172b7727b9ead324c48 *4866ee9492fe0eacb57f21b6e0e75263679441751874c8c9019af9f010c59f1c056fe6fd923ede ad0f3d50ffe2e2eb
23588 *015cfcf26535 *92 cc8521fb65b3ba45
19274 *8a39cbd8349fac1e9b712d221c73845d33b983e290bd0a6d8d648409cd45070b16ffb54f *c8f4eb9a92a28443b9dacda925f1b7 56bc6f67561f97d7
14053 *9a3376f4bdb7b7e4ed7a2d2d7ac9cc70d9aed15dee6be59cdd *743a23c3beb32a8aefb417a42469300f85e809a5041bcf20ba478712bfdf3e09e1 c0a0547bf4e1aa45
2283 *8e7f2ee57118ebbb17583c6474da939f *8744dd2418200045101ab6f91f8bed7216310124388ad1 398347501ae8aa29
7490 *24351ed636f9eaed6ea6a726ce6501f44e1a5cafd092e25a0efe97 *d78488f97628ae748441 5181620430f4f428
1693 *8e *99c1435884e19ba407c1ae1f2947a91d76 c2ffba27a76e9b32
61321 *7ad867e760f8d001b7877dce54bc8a99666d73fd11991d09ac5fcb313fcdaedf *5ef0f75f375950e566f6d757e622b19443741db8f72bf7e986e42babc2175b465d134d1493 1cb26e1e3cbfb884
44456 *fb *a2817784c806e7006677078e0a48dd989cc0 47cfd5281ba0fede
39270 *945b7e9a34810c8bdb401dce909fb608f92f34af2ac9 *dd61d728b60730134e08dedf1ec6959fd207af840b 9a99da07e9686292
25617 *30c4bfd6a992 *887d62e9fd7b8ff6f7afa2c747b71ac521057e3beced0ce29fce7f13f134fa7e0394c3 ff1436d61609835a
25362 *87ef1991e36468e84798b9c086adc681813cd46a *39 b342221136386a59
41450 *1f90ac5ca0d77ef58964c543e8 *f7f4ea3fcd802c8df66bb1ea42b4807c 40aca4e1a2bd9d7d
62262 *a7fc2db715ff2104dedf89ee * 32975accf82f3671
5735 *f64881709c999604d3ea15fd69d98e8cfa5e72f3d1d1 *c7d86e a0c3a180d72a756c
28320 *b7a559b2033a3d097c1025bd92880e6459a2411323 *72c5844ef656 4fb460c6ecc7b6b1
24597 *edf57a35717fab9421 *36c8cba0a0bda1b7ff1890156e3c3c6a2f7ce0d78f93b1a9e4e7d332 0fc0ea4a85d7fd97
50069 *861af199434770e4 *ab2c86ea5e18 b1b48fd1ca9fce42
17152 *02633a819035813235df214b90e84794047a9544c75fad0b2f4e2ffbfea82ff02243930b927bcc *cca6a8b77a36a98867630dcfdd1df2bcbe54110b4a2f96a0dbc93813405f9d6162a10ca5f531b8 8ead56e81722abcd
27302 *8dd87c81e273ade84eb9f596448172b8900a3c12e8df402e421d9d466a7b262337e18f *c201da658943837370519fb8ecdac311df98e2083eb9efb24562e3b03fa5f0590fb20f95dc121a cead0bca10c14463
18241 *7574dc952049108be4a9f68c4c7269797d *33374b2bccb44f01a0c0807ca3c39430e7a9be182d133c0af30d478f80063c672f0a8efbc356d5 c2f3a6d8925d16cb
54687 *b743e02b25bb1e69690968b7f0dd211c6a80cd0eebc058ff9e7f3f362aa4a8c39e66 *dd132868486576706e2c6f95429f162abe2eb0d83bd7478c870444522a4c1ffb16 bf63e621a323a34c
27356 *2d509445f251f3408c1af500b7567d8a19d806c1 *a16e513770a3ba9337085e2f33afcc7d94576106a9aeef50ac190e16 d5713c92410d3b76
23623 *539c7aa99a3c63c41b423a02e3da617dd3672a98250bc71627fd7d *d26eb59a1370a55a369df40f62c1499f177ef38df2d2ff387d736b3a95f7156664 435508e8d4e0dbe1
40851 *cb3fd90c0bc545d776af70eac7bd96 *8883c4e7eb b4eb3d59d2a613a1
566 *c2729de86ca2b2c77d0c48e51f60e79d394b70ec5ea94aaa7796a10985402eb5 *a9e0678237db62bfb6920a6cd8adcc620a9c6a67858aa540a1 dcfe92e4332aa381
63818 *9a32036bf4afff24fcd600661f817485c2 * bcfa2b3e29fc6c00
49387 *68be012990bb2c0229478eace809f64417c462c0d752cefda5 *af89831b6dfc1679af af77874b929b915a
13315 *c9f785ea92f01d424ed69cb03648699cab6c21dac680 *b525c1faf2dbb8719d1b3516f1d6c2cc98ab69541a258649 f7e37dab91536a54
30206 *39 *49cd11d5fc6a2bdc68d3584a0e92cb78315bbe562a3cbab2 87ca9ea224a30884
45942 *23 *5c51e2d3 b13f6983b9494da2
22736 *ccc7d845466d61be9a5971e0a55de0b5b16e87ba121c6f44 *906bdcf51b6112dc1c05d5e6bb eab32422b300289f
62601 *33ddeda859 *3c68d76cb96b1738a948d8d60da98769f426b6d50f86ec 7d00609a637b337e
37938 *7e2d0b94b312ce476bd61331f810f5956bab1baeed13ac0d069ab8b56406e3 *bad377af15de12127d c87144e8b3c18e21
16581 *ac312bee0d3fd8814be16489a4931313be *05aa3f9fe0c399e14470f1f64887b51fa38f9f ac323f5161d4a1ed
15653 *0ce145500eae256a2c20ecbdbdf52b2a6b80e5737a670bb3d0839650910f9f1d20 *4c3ee52ebf1cd46848f77888f368b36c54b58742003b1047dd39656f07b42b680b1284b09dfa 49248fb1e191fc2a
6277 *c6893f277f8f0ca84913a1d4c3b8a63993c472ead14e73c093b2 *aad25c24c5fc679cf33ffaa1fbff3915bda977ecf0b3a76f28195f d3d836e7580aad61
7054 *407c804963b77c73f95fffc3a8062b56d923be0dd076a8667aebee294794d7 *715bda23f39964359bc0 fc67f429e6520e15
32870 *01f8df4d727b639bf4907cf0f1 *027d1ca4daf80d35461799f00972563b19b3689e1166a0121a9f0e0743bd0462 e0b763c039721bb8
56693 *842eaa9d85c6 *2d212d440015d1b9d95b7a8a153262dd5d80efcc 16636e9a208bd5bf
59726 *5e222dfa41 *91d25df8b529b0eefc2fd0f018dfed8589daba765b6f1f7d49e586c5b6c64719c1 14c191a47a2e45ee
38241 *e824d32fc615838ef51c4bc1aab3e325c649 *1c48cc9f476bd4874c229b110918bf939cd12bdf8da839a5d739b9e94b665badc8c8f0fabf1b 7c46db9d0ca32c50
18013 *5e *59522949fd17ef13aff50af1532f946a134deb919c 533395c2b611cbd2
44143 *891ce9077a607e28ac9adca4993b8c23ff5be604258ee674201bd6a498796ed3 *7cfa0088 e8cd4cfd45349b78
12822 *5ef8f765865e31a533b41670743fc83aabfa27f1e6159c23 *06d4d7161bff2d6fc498a9efbe5ce08b1e6c89470384d8bddfee 72a7b9cee593eedc
46758 *2dfcc3407bb658781dfcae9cbad6d89aa722c2 *0cdf55318582c20eef938ed223b0ba5c6e41 1627af68fd4e7822
10214 *04d03a53ef7cffff48 *f842595d c8bbcc90965f4c7a
28171 *5028f20bfbb87c *bf9606cea79b8e3df637b35d7f12e9e3 cdce3f0d4fdb1395
15346 *5f97f438c482cd73c50845e132ced839f46f6c2bc10619fe660fe5f8e612e59112163d07 *4ec58241e1ca3e80af25b65486e3746e8811acb3820f89958cb12c59f14e1dd02881b057c43e 93c2c109aa2aa592
53284 *39831a78c784063dd836b76ba5008f41 *e6cb8a2354674c53caef1a7afaca2c 6ca58fccf4dd6d34
15557 *38dd2066f930eb5d9de73a7e3a1ccfe2266eeabdfb46df74c248e240a7469d26 *7722c0bfde0a4b899062b0 bf81a783904d5333
26467 *6640456d6682921d20edafd0959f69 *703856c1e2cf746cdbf324df 7c5e11158247ab38
18831 *5c6cc0f0595b0936da9eae *de0c27052f7fceaa2ce94b5be3953370d6b3922c3d69bc98a4dba58b 96995b6237dc582c
17507 *08a87475a5d017645a8d8e5d6f5c71ef1524ef05c508d953bf9433b97ef2 *1e663a22b77d8d3a1afaf2fe7c7f3c603befe445fa0136be65543a161a69a4dfe0483b26 9bf4546763d54faf
9052 *0f11784ed432ff6133f146 *76a8125c0f011f78af6a1253d9179fc37942bbb7024f10543dcadbdd77a5ad40f5cd1a8f7b a63838230db84dcf
14899 *24ec2cb26dee05334b1ae7299487f3abd6f0a06e26fc679845ebf9e9276102624dff7ed6d929a5 *e36834b238c392a1a40f780df3fa0e7ad1888f7a9d651829f5d3f3dcc08b872bd3b3fa1023 f6aa74abe08ec21e
60053 * *a3023b5e194a59fd738651cc7d0d6ec0dfa6226da7 ecc307a37eefd23d
22976 *3ca18b18899b494cb435adeb59627fe5a3877cce4b61860512d9c9067c73a42d2d3c7ae5 *fa898d4b150018579aa0ad7d d4c5ce15ba15a793
54496 *7de90322ef4eb737b35866c11aa1838c963ec143f607 *294b c3bae9274b6cc531
52965 *25ffe151457ef83a7ce8f7118fa8b3ad2ccdb1ac *7e37d5fa79ca678951e54f1d30384cc2b954f50bd37c11 34fa6010f24f6d53
33116 *0f2492016ce746fb299fb026edbc *36c67ec91ce160605a2f0ecb859479d13adea777a46b3c31 fbbbc501557b427c
52698 *8eed6a1c5b1677767ba5a05e369e6794af6487c5a1ac67269bc3 *6fe97359fe6a0da4bcea8d 6f2f7affc3ffc1d3
34485 *4b745f538b *0dd33c806f0059a0c99b12016712855fe74b2535cf9c96e693ee a4a3bb1a4836a6f4
18911 *b002322c7428088dacf4b2b5429c74f2dcbbb476532c1c4b3ff2 *684363a440ffa019ba4f07574edcf3 5f31557083fa34ae
62230 *18df730441280bfa37d5cb00d6b584822849f7fc76ac16e10d4aca571f *981495f01747dc76b242962cb67de72b5b680613f21c25897642f91e7b08de87ff6084 139a347295c725de
7776 *69d695a0e1b2df4e022204 *302a916653e763b4e9cd08 37275ecd43513374
10162 *e5228563fc247919 * b3214dbe0313a9be
27782 *2651fa304fbd8a3d1d7d51d2cbe16a *d46040ed2bdedebfc16b0e66f5c29f7c8ac6e90d1a5ae5fc4210b80e917ef1aa34 46e05b4dd94fcb8b
58763 *81b580 *f79a6c07760f2e231a30a4a0b61263b461e35d91666f3a544da3ec62f2845d1c08 0c0782464f4a90fe
19530 *add4d92f2beaa0319d437d06c19784904adcb6adccfe97def2c11ca80d1f6ade5989d78b *114768d7144cf59fb6 1a0071472fb7ceb4
56592 *e8bbb3bd29c387ff2337bbeec8705715b6f3 *f6aa600e77fe99b846dd977eef6a0bf1172deb5b76c6 22ea8158208d18e5
43466 *81191387b4da8895 *63196f0c3dad77f9ae0bf92a5410ee258df74c1e3203d5829adc01c4db085f1d01db0a afc7506f98ef01bc
1553 *f99f7bb19eab125574b7c525 *a1623c4a5368fb1a922057 84d510a3bbd41f7d
23802 *86e5994768b64d557faee7f9e5271316225367074ebb04a9ab07 *4f2057e6d90cb73453381e80b6c13ac579609e725bc351 a879518abf1594f5
19605 *8acb008de1d5fbf4250a15337d0914fae5d1b898 *f150b5f67972880c5f1acc365056474da8f2151bd9c928b9092e03e87e2390e856d2eb 6aaa859238a91aac
23265 *c3c5dfd37c72545f099c518bc9a3936288a586fecc17449861ec2dcc5b19 *886f9dd491628ca77e56e0e2d31106a4745a284eef63346f13205f16667dbdb86d1887 69fa55f9cd163eae
12048 *3b2dcfdac267dca916aaccab4f67b2929547a4cca9c81dac927485f3059001b6a63dbfbe5e *49d7298fd23847 4bc648b97cbf242f
55316 *4f3217a4 *949bebdf86945c541f36f8d213d8ecb7aa4c178eeee5d570 2887fdf2d3150633
45626 *4c6778fd9519cce964c143d3 *85ae11168d33005c1e646e6db5a69392d76f03bdaa 88002731ab235121
27480 *5faac851a5a98807b5245d148a9a0b3ca9cef083f0 *538e81521f243409a220d6fab162c6451572a1157a289d78 8a43d995e2db3a6a
55366 *973b36254412ee469ec646fbca091cf1fd9daf0ca281923f55e39a *2e875b62b13509526e1d32cacd49b81296dc237fb6 6e619b1f8bd90f6f
43807 *bfab37ce52940dc483069b1ec45a0d1254df4a595c2df133ad0b00229f *c6658d06ccec 92d43756914340c2
51967 *ff233a3f6b3cb585999733788c4f31942b *7a4de9865f1af6facfaf7830107a0446e83b8c66af1cc104d2ad0e26c3dc5b db91f00960dfa6c2
57373 *39ba99dffb70bbc93e12522f6a2d5b42 * 73e0f2964e708f21
31665 *7bba2c155ac59470fe39d02ad88ef611c9c32ced62f64c9e2d90 *830925e2f3e9 3af9ad73bb252c63
30781 *43afdf60d4f7a31f03489d29a69f58517bf2914eaa1081d20a4efc4bc4bbb89272419507 *6bd448a0bec921cee8f171a796d1bcee1694296534253020cc3f4d835220 203d503e08499d05
50480 *bbb941b0a35c9c29f0ed6ee24d2efb28a4e8b58b3f6c6dcccb558a1c07 *cf4a131ac0cc4acb063088f2c891961d3b0882b647e5436e741317de e792e5017d57eb6f
32392 *556d187a7a698585de9a300151fd28df2d6c7fee3c421c43ea *da38f662c3798863aa5952a0bde5bdb412054e422eb9170d08240cda3d40013f8bcba414291fd6 121f040a1310c265
44001 *f12efacf73213f9615155f *0542418b3e21c0495de8339aa0807490b83d63d8d01d3d2e78e71eaf85192a94633b579188 86e615f7d0c20116
20767 *c09f94082dfa82592499c354051f02a0aa2157783169ce61a7c95cbfc4ce9595eeea92451577 *d4e8b12e7784b3a32ef2498a53f9854d cd53313f75f0db5c
45816 *8b9b255a04a950a58c23 *e003f14b5aae14161c271d1368c2b7e9c10c0ce65872f5 aa3b202bca5031f3
40573 *36ec723856946821242e33f0 *4db844e97166 f1a8c96e79a39433
62064 *b7e7ebbe01d95dc144b94aa186ef1f89efcb19f7184e7210cf4f94f6144133b6c73e1138a9f6f8 *7fbd7e67a04131ab0e75f00c56c4c5570f132096402498f300dfd12f85b2 d4c99c05c4cf11c9
19479 *3945dd7c00f94db5d75ebb1d94e45cd0da *3ce7d5ce8134f1949da3e51a0ca55435550c 1328cd487129e10e
56282 *99f450ef73aa38fb49ad74e49f0476b8566ac561e6664d2906528a64 *413422ea581df62334f0a2e8558c0c74fc887698a6dacb 2a3ae8d99171985f
6822 *cd9615d919ce8dd5 *9686bce6cc80 720175eb4205609d
