#include "EXTERN.h"
#include "perl.h"
#include "XSUB.h"

#if 1 /* bug #74006 not yet fixed */
# define lex_stuff_fixup() \
		SvCUR_set(PL_parser->linestr, \
			PL_parser->bufend - SvPVX(PL_parser->linestr))
# define lex_stuff_sv_(sv, flags) \
		(lex_stuff_sv((sv), (flags)), lex_stuff_fixup())
# define lex_stuff_pvn_(pv, len, flags) \
		(lex_stuff_pvn((pv), (len), (flags)), lex_stuff_fixup())
# define lex_stuff_pvs_(s, flags) \
		lex_stuff_pvn_((""s""), sizeof(""s"")-1, (flags))
#endif /* bug #74006 not yet fixed */

#define SVt_PADNAME SVt_PVMG

#ifndef COP_SEQ_RANGE_LOW_set
# define COP_SEQ_RANGE_LOW_set(sv,val) \
	do { ((XPVNV*)SvANY(sv))->xnv_u.xpad_cop_seq.xlow = val; } while(0)
# define COP_SEQ_RANGE_HIGH_set(sv,val) \
	do { ((XPVNV*)SvANY(sv))->xnv_u.xpad_cop_seq.xhigh = val; } while(0)
#endif /* !COP_SEQ_RANGE_LOW_set */

#ifndef PAD_MAX
# define PAD_MAX I32_MAX
#endif /* !PAD_MAX */

#define sv_is_string(sv) \
	(SvTYPE(sv) != SVt_PVGV && SvTYPE(sv) != SVt_REGEXP && \
	 (SvFLAGS(sv) & (SVf_IOK|SVf_NOK|SVf_POK|SVp_IOK|SVp_NOK|SVp_POK)))

/*
 * pad handling
 *
 * The public API for the pad system is lacking any way to add items to
 * the pad.  This is a minimal implementation of the necessary facilities.
 * It doesn't warn about shadowing.
 */

#define pad_add_my_scalar_pvn(namepv, namelen) \
		THX_pad_add_my_scalar_pvn(aTHX_ namepv, namelen)
static PADOFFSET THX_pad_add_my_scalar_pvn(pTHX_
	char const *namepv, STRLEN namelen)
{
	PADOFFSET offset;
	SV *namesv, *myvar;
	myvar = *av_fetch(PL_comppad, AvFILLp(PL_comppad) + 1, 1);
	offset = AvFILLp(PL_comppad);
	SvPADMY_on(myvar);
	PL_curpad = AvARRAY(PL_comppad);
	namesv = newSV_type(SVt_PADNAME);
	sv_setpvn(namesv, namepv, namelen);
	COP_SEQ_RANGE_LOW_set(namesv, PL_cop_seqmax);
	COP_SEQ_RANGE_HIGH_set(namesv, PAD_MAX);
	PL_cop_seqmax++;
	av_store(PL_comppad_name, offset, namesv);
	return offset;
}

#define pad_add_my_scalar_sv(namesv) THX_pad_add_my_scalar_sv(aTHX_ namesv)
static PADOFFSET THX_pad_add_my_scalar_sv(pTHX_ SV *namesv)
{
	char const *pv;
	STRLEN len;
	pv = SvPV(namesv, len);
	return pad_add_my_scalar_pvn(pv, len);
}

/*
 * parser pieces
 *
 * These functions reimplement fairly low-level parts of the Perl syntax,
 * using the character-level public lexer API.
 */

#define parse_idword(prefix) THX_parse_idword(aTHX_ prefix)
static SV *THX_parse_idword(pTHX_ char const *prefix)
{
	STRLEN prefixlen, idlen;
	SV *sv;
	char *start, *s, c;
	s = start = PL_parser->bufptr;
	c = *s;
	if(!isIDFIRST(c)) croak("syntax error");
	do {
		c = *++s;
	} while(isALNUM(c));
	lex_read_to(s);
	prefixlen = strlen(prefix);
	idlen = s-start;
	sv = sv_2mortal(newSV(prefixlen + idlen));
	Copy(prefix, SvPVX(sv), prefixlen, char);
	Copy(start, SvPVX(sv)+prefixlen, idlen, char);
	SvPVX(sv)[prefixlen + idlen] = 0;
	SvCUR_set(sv, prefixlen + idlen);
	SvPOK_on(sv);
	return sv;
}

#define parse_scalar_varname() THX_parse_scalar_varname(aTHX)
static SV *THX_parse_scalar_varname(pTHX)
{
	if(lex_peek_unichar(0) != '$') croak("syntax error");
	lex_read_unichar(0);
	lex_read_space(0);
	return parse_idword("$");
}

#define parse_quoted_string() THX_parse_quoted_string(aTHX)
static SV *THX_parse_quoted_string(pTHX)
{
	I32 delim;
	STRLEN len = 1;
	delim = lex_peek_unichar(0);
	if(delim != '"' && delim != '\'') croak("syntax error");
	while(1) {
		char *end = PL_parser->bufend;
		char *s = PL_parser->bufptr + len;
		while(s != end) {
			if(*s == '\\') {
				if(s+1 == end) break;
				s += 2;
			} else if(*s == delim) {
				SV *stringsv;
				s++;
				stringsv = newSVpvn(PL_parser->bufptr,
						s - PL_parser->bufptr);
				lex_read_to(s);
				return stringsv;
			} else {
				s++;
			}
		}
		len = s - PL_parser->bufptr;
		if(!lex_next_chunk(LEX_KEEP_PREVIOUS))
			croak("syntax error");
	}
}

/*
 * op generators
 *
 * Escape continuations are generated by a custom op implemented
 * in Scope::Escape.  The custom op is generated at op check time,
 * as a rewrite of a call to one of the pseudo-functions provided by
 * Scope::Escape.  gen_current_escape_continuation_op() here returns a
 * suitable custom op.  It works by building the required pseudo-function
 * call, which immediately gets rewritten before newUNOP() returns.
 *
 * Some of the keywords implemented by this module use a rewriting trick
 * where they return a constant-empty-string op after stuffing "->x("
 * and some more source into the input buffer, leading to an expression
 * ""->x(stuff...).  This pattern of method invocation, on the specific
 * empty string SV in use for this trick, then gets rewritten at op check
 * time to just the first parameter (the method call being thrown away).
 */

static SV *current_escape_function_rv, *current_escape_continuation_rv;

#define gen_current_escape_continuation_op(blessp) \
		THX_gen_current_escape_continuation_op(aTHX_ blessp)
static OP *THX_gen_current_escape_continuation_op(pTHX_ bool blessp)
{
	return newUNOP(OP_ENTERSUB, OPf_STACKED,
		newCVREF(0, newSVOP(OP_CONST, 0,
			blessp ? SvREFCNT_inc(current_escape_continuation_rv) :
				 SvREFCNT_inc(current_escape_function_rv))));
}

static SV *methodwrapper_sv;

#define gen_method_wrapper_op() THX_gen_method_wrapper_op(aTHX)
static OP *THX_gen_method_wrapper_op(pTHX)
{
	return newSVOP(OP_CONST, 0, SvREFCNT_inc(methodwrapper_sv));
}

#define ck_entersub_method_wrapper(entersubop) \
		THX_ck_entersub_method_wrapper(aTHX_ entersubop)
static OP *THX_ck_entersub_method_wrapper(pTHX_ OP *entersubop)
{
	OP *pushop, *mwop, *realop;
	pushop = cUNOPx(entersubop)->op_first;
	if(!pushop->op_sibling) pushop = cUNOPx(pushop)->op_first;
	mwop = pushop->op_sibling;
	realop = mwop->op_sibling;
	if(!realop) return entersubop;
	mwop->op_sibling = realop->op_sibling;
	realop->op_sibling = NULL;
	op_free(entersubop);
	return realop;
}

/*
 * with_escape_{function,continuation}
 *
 * The two keywords do the same things as each other.  The only difference
 * is in whether the reified continuation object is blessed.  The versions
 * of the keyword are handled thus:
 *
 * with_escape_function $e;
 *     Fully parsed, and ops generated directly.  The ops generated
 *     correspond precisely to those that would be generated by
 *        my $e = Scope::Escape::current_escape_function();
 *
 * with_escape_function $e { ... }
 *     Parsed up to the opening brace.  A null statement is generated,
 *     with the code rewritten to
 *         do { with_escape_function $e; ... };
 *     The final semicolon is actually injected via more code stuffing
 *     at the start of the block.  So the immediate rewrite is actually to
 *         do {
 *             BEGIN {
 *                 B::Hooks::EndOfScope::on_scope_end {
 *                     Scope::Escape::Sugar::_stuff(";");
 *                 }
 *             }
 *             with_escape_function $e;
 *             ...
 *         }
 *
 * with_escape_function($e { ... })
 *     Parsed up to the opening brace.  A constant-empty-string expression
 *     is generated, with the code rewritten to
 *         ->x(do { with_escape_function $e; ... })
 *     The existence of the mandatory closing parenthesis immediately
 *     following the closing brace (which is not mandatory in the Perl
 *     syntax of the rewritten code) is checked via more code stuffing
 *     at the start of the block.  So the immediate rewrite is actually to
 *         ->x(do {
 *             BEGIN {
 *                 B::Hooks::EndOfScope::on_scope_end {
 *                     Scope::Escape::Sugar::_expect_close_paren();
 *                 }
 *             }
 *             with_escape_function $e;
 *             ...
 *         })
 *     At op check time, the ops which look like
 *         ""->x(do { with_escape_function $e; ... })
 *     are recognised (by the "method wrapper" code above) and rewritten
 *     to
 *         do { with_escape_function $e; ... }
 */

#define parse_keyword_with_escape(op_ptr, blessp) \
		THX_parse_keyword_with_escape(aTHX_ op_ptr, blessp)
static int THX_parse_keyword_with_escape(pTHX_ OP **op_ptr, bool blessp)
{
	I32 c;
	SV *namesv;
	bool had_paren;
	lex_read_space(0);
	had_paren = lex_peek_unichar(0) == '('/*)*/;
	if(had_paren) {
		lex_read_unichar(0);
		lex_read_space(0);
	}
	namesv = parse_scalar_varname();
	lex_read_space(0);
	c = lex_peek_unichar(0);
	switch(c) {
		case ';': {
			lex_read_unichar(0);
		} /* fall through */
		case /*{*/'}': {
			OP *pvarop;
			if(had_paren) croak("syntax error");
			pvarop = newOP(OP_PADSV, (OPpLVAL_INTRO<<8));
			pvarop->op_targ = pad_add_my_scalar_sv(namesv);
			*op_ptr = newASSIGNOP(OPf_STACKED, pvarop, 0,
				gen_current_escape_continuation_op(blessp));
			return KEYWORD_PLUGIN_STMT;
		} break;
		case '{'/*}*/: {
			lex_read_unichar(0);
			lex_stuff_pvs_(";", 0);
			lex_stuff_sv_(namesv, 0);
			if(blessp) {
				lex_stuff_pvs_("with_escape_continuation", 0);
			} else {
				lex_stuff_pvs_("with_escape_function", 0);
			}
			lex_stuff_pvs_(/*{{*/"}}", 0);
			if(had_paren) {
				lex_stuff_pvs_(
					"Scope::Escape::Sugar::"
					"_expect_close_paren();",
					0);
			} else {
				lex_stuff_pvs_(
					"Scope::Escape::Sugar::_stuff(\";\");",
					0);
			}
			lex_stuff_pvs_(
				"do{"
				"BEGIN{B::Hooks::EndOfScope::on_scope_end{"
				/*}}}*/, 0);
			if(had_paren) lex_stuff_pvs_("->x("/*)*/, 0);
			if(had_paren) {
				*op_ptr = gen_method_wrapper_op();
				return KEYWORD_PLUGIN_EXPR;
			} else {
				*op_ptr = newOP(OP_NULL, 0);
				return KEYWORD_PLUGIN_STMT;
			}
		} break;
		default: {
			croak("syntax error");
		} break;
	}
}

/*
 * block and return_from
 *
 * The block escape functions are stored in the pad as lexical scalar
 * variables.  For a block named "foo", the scalar variable is named
 * "$Scope::Escape::Sugar::_block_foo".  The colons make this not a valid
 * name for a lexical scalar in normal Perl syntax, thus ensuring that
 * this can't clash with any ordinary lexicals.  The apparent package
 * qualifier here has nothing to do with the actual package, it's just
 * avoiding clashes with any other module that pulls the same trick.
 *
 * The versions of the "block" keyword are handled thus:
 *
 * block foo;
 *     Fully parsed, and ops generated directly.  The ops generated
 *     correspond precisely to those that would be generated by
 *        my $Scope::Escape::Sugar::_block_foo =
 *                Scope::Escape::current_escape_function();
 *     if that were a legal name for a lexical variable.
 *
 * block foo { ... }
 *     Parsed up to the opening brace.  A null statement is generated,
 *     with the code rewritten to
 *         do { block foo; ... };
 *     The rest is as for with_escape_function, as described above.
 *
 * block(foo { ... })
 *     Parsed up to the opening brace.  A constant-empty-string expression
 *     is generated, with the code rewritten to
 *         ->x(do { block foo; ... })
 *     The rest is as for with_escape_function, as described above.
 *
 * The versions of the "return_from" keyword are handled thus:
 *
 * return_from(foo ...)
 *     Parsed up to the end of the tag.  An expression referencing the
 *     escape function is generated, with the code rewritten to
 *         ->(...)
 *     So the overall result is ops that look like
 *         $Scope::Escape::Sugar::_block_foo->(...)
 *
 * return_from foo ...
 *     Parsed up to the end of the tag.  A null statement is generated,
 *     with the code rewritten to
 *         Scope::Escape::Sugar::_block_return_wrapper "foo", ...
 *     At op check time, the ops resulting from this are recognised and
 *     rewritten to
 *         $Scope::Escape::Sugar::_block_foo->(...)
 */

#define BLOCK_NAME_PREFIX "$Scope::Escape::Sugar::_block_"
#define BLOCK_NAME_PREFIX_LEN (sizeof(BLOCK_NAME_PREFIX)-1)

#define gen_block_returner_op(namesv) THX_gen_block_returner_op(aTHX_ namesv)
static OP *THX_gen_block_returner_op(pTHX_ SV *namesv)
{
	PADOFFSET offset;
	OP *op;
	offset = pad_findmy(SvPVX(namesv), SvCUR(namesv), 0);
	if(offset == NOT_IN_PAD)
		croak("no block named \"%s\" is visible",
			SvPVX(namesv)+BLOCK_NAME_PREFIX_LEN);
	op = newOP(OP_PADSV, 0);
	op->op_targ = offset;
	return op;
}

#define parse_keyword_block(op_ptr) THX_parse_keyword_block(aTHX_ op_ptr)
static int THX_parse_keyword_block(pTHX_ OP **op_ptr)
{
	I32 c;
	SV *namesv;
	bool had_paren;
	lex_read_space(0);
	had_paren = lex_peek_unichar(0) == '('/*)*/;
	if(had_paren) {
		lex_read_unichar(0);
		lex_read_space(0);
	}
	namesv = parse_idword(BLOCK_NAME_PREFIX);
	lex_read_space(0);
	c = lex_peek_unichar(0);
	switch(c) {
		case ';': {
			lex_read_unichar(0);
		} /* fall through */
		case /*{*/'}': {
			OP *pvarop;
			if(had_paren) croak("syntax error");
			pvarop = newOP(OP_PADSV, (OPpLVAL_INTRO<<8));
			pvarop->op_targ = pad_add_my_scalar_sv(namesv);
			*op_ptr = newASSIGNOP(OPf_STACKED, pvarop, 0,
				gen_current_escape_continuation_op(0));
			return KEYWORD_PLUGIN_STMT;
		} break;
		case '{'/*}*/: {
			lex_read_unichar(0);
			lex_stuff_pvs_(";", 0);
			lex_stuff_pvn_(SvPVX(namesv)+BLOCK_NAME_PREFIX_LEN,
				SvCUR(namesv)-BLOCK_NAME_PREFIX_LEN, 0);
			lex_stuff_pvs_("block ", 0);
			lex_stuff_pvs_(/*{{*/"}}", 0);
			if(had_paren) {
				lex_stuff_pvs_(
					"Scope::Escape::Sugar::"
					"_expect_close_paren();",
					0);
			} else {
				lex_stuff_pvs_(
					"Scope::Escape::Sugar::_stuff(\";\");",
					0);
			}
			lex_stuff_pvs_(
				"do{"
				"BEGIN{B::Hooks::EndOfScope::on_scope_end{"
				/*}}}*/, 0);
			if(had_paren) lex_stuff_pvs_("->x("/*)*/, 0);
			if(had_paren) {
				*op_ptr = gen_method_wrapper_op();
				return KEYWORD_PLUGIN_EXPR;
			} else {
				*op_ptr = newOP(OP_NULL, 0);
				return KEYWORD_PLUGIN_STMT;
			}
		} break;
		default: {
			croak("syntax error");
		} break;
	}
}

#if 0 /* this keyword is not available yet */
#define parse_keyword_block_returner(op_ptr) \
		THX_parse_keyword_block_returner(aTHX_ op_ptr)
static int THX_parse_keyword_block_returner(pTHX_ OP **op_ptr)
{
	SV *namesv;
	bool had_paren;
	lex_read_space(0);
	had_paren = lex_peek_unichar(0) == '('/*)*/;
	if(had_paren) {
		lex_read_unichar(0);
		lex_read_space(0);
	}
	namesv = parse_idword(BLOCK_NAME_PREFIX);
	if(had_paren) {
		lex_read_space(0);
		if(lex_peek_unichar(0) != /*(*/')') croak("syntax error");
		lex_read_unichar(0);
	}
	*op_ptr = gen_block_returner_op(namesv);
	return KEYWORD_PLUGIN_EXPR;
}
#endif /* this keyword is not available yet */

#define parse_keyword_return_from(op_ptr) \
		THX_parse_keyword_return_from(aTHX_ op_ptr)
static int THX_parse_keyword_return_from(pTHX_ OP **op_ptr)
{
	SV *namesv;
	bool had_paren;
	lex_read_space(0);
	had_paren = lex_peek_unichar(0) == '('/*)*/;
	if(had_paren) {
		lex_read_unichar(0);
		lex_read_space(0);
	}
	namesv = parse_idword(BLOCK_NAME_PREFIX);
	lex_read_space(0);
	if(lex_peek_unichar(0) == ',') croak("syntax error");
	if(had_paren) {
		lex_stuff_pvs_("->("/*)*/, 0);
		*op_ptr = gen_block_returner_op(namesv);
		return KEYWORD_PLUGIN_EXPR;
	} else {
		lex_stuff_pvs_("\",", 0);
		lex_stuff_pvn_(SvPVX(namesv)+BLOCK_NAME_PREFIX_LEN,
			SvCUR(namesv)-BLOCK_NAME_PREFIX_LEN, 0);
		lex_stuff_pvs_(
			"Scope::Escape::Sugar::_block_return_wrapper \"", 0);
		*op_ptr = newOP(OP_NULL, 0);
		return KEYWORD_PLUGIN_STMT;
	}
}

#define ck_entersub_block_return_wrapper(entersubop) \
		THX_ck_entersub_block_return_wrapper(aTHX_ entersubop)
static OP *THX_ck_entersub_block_return_wrapper(pTHX_ OP *entersubop)
{
	OP *pushop, *tagop, *cvop, *cvprevop;
	SV *tagsv, *namesv;
	pushop = cUNOPx(entersubop)->op_first;
	if(!pushop->op_sibling) pushop = cUNOPx(pushop)->op_first;
	tagop = pushop->op_sibling;
	if(!((tagop = pushop->op_sibling) && tagop->op_type == OP_CONST &&
			(tagsv = cSVOPx_sv(tagop)) && sv_is_string(tagsv)))
		return entersubop;
	pushop->op_sibling = tagop->op_sibling;
	namesv = sv_2mortal(newSVpvs(BLOCK_NAME_PREFIX));
	sv_catsv(namesv, tagsv);
	op_free(tagop);
	for(cvprevop = pushop; (cvop = cvprevop->op_sibling)->op_sibling;
			cvprevop = cvop) ;
	cvprevop->op_sibling = newCVREF(0, gen_block_returner_op(namesv));
	op_free(cvop);
	return PL_check[OP_ENTERSUB](aTHX_ entersubop);
}

/*
 * catch and throw
 *
 * The dynamically current catchers are registered in the hash
 * %Scope::Escape::Sugar::_catch (catcher_hv).  The hash is keyed by
 * catch tag, and the value for each tag is a reference to the unblessed
 * escape function for that catch block.
 *
 * The versions of the "catch" keyword are handled thus:
 *
 * catch "foo";
 *     Fully parsed.  A null statement is generated, with the code
 *     rewritten to
 *         local $Scope::Escape::Sugar::_catch{"foo"} =
 *                 Scope::Escape::current_escape_function();
 *
 * catch "foo" { ... }
 *     Parsed up to the opening brace.  A null statement is generated,
 *     with the code rewritten to
 *         do { catch "foo"; ... };
 *     The rest is as for with_escape_function, as described above.
 *
 * catch("foo" { ... })
 *     Parsed up to the opening brace.  A constant-empty-string expression
 *     is generated, with the code rewritten to
 *         ->x(do { catch "foo"; ... })
 *     The rest is as for with_escape_function, as described above.
 *
 * The "throw" function is a completely normal xsub.
 */

static HV *catcher_hv;

static SV *look_up_catcher(SV *tag)
{
	HE *he;
	if(!sv_is_string(tag)) croak("throw tag is not a string");
	he = hv_fetch_ent(catcher_hv, tag, 0, 0);
	if(!he) croak("no catcher named \"%s\" is visible", SvPV_nolen(tag));
	return HeVAL(he);
}

#define parse_keyword_catch(op_ptr) THX_parse_keyword_catch(aTHX_ op_ptr)
static int THX_parse_keyword_catch(pTHX_ OP **op_ptr)
{
	I32 c;
	SV *tagsv;
	bool had_paren;
	lex_read_space(0);
	had_paren = lex_peek_unichar(0) == '('/*)*/;
	if(had_paren) {
		lex_read_unichar(0);
		lex_read_space(0);
	}
	tagsv = parse_quoted_string();
	lex_read_space(0);
	c = lex_peek_unichar(0);
	switch(c) {
		case ';': {
			lex_read_unichar(0);
		} /* fall through */
		case /*{*/'}': {
			if(had_paren) croak("syntax error");
			lex_stuff_pvs_(
				/*{*/"}="
				"Scope::Escape::current_escape_function();",
				0);
			lex_stuff_sv_(tagsv, 0);
			lex_stuff_pvs_(
				"local$Scope::Escape::Sugar::_catch{"/*}*/,
				0);
			*op_ptr = newOP(OP_NULL, 0);
			return KEYWORD_PLUGIN_STMT;
		} break;
		case '{'/*}*/: {
			lex_read_unichar(0);
			lex_stuff_pvs_(";", 0);
			lex_stuff_sv_(tagsv, 0);
			lex_stuff_pvs_("catch", 0);
			lex_stuff_pvs_(/*{{*/"}}", 0);
			if(had_paren) {
				lex_stuff_pvs_(
					"Scope::Escape::Sugar::"
					"_expect_close_paren();",
					0);
			} else {
				lex_stuff_pvs_(
					"Scope::Escape::Sugar::_stuff(\";\");",
					0);
			}
			lex_stuff_pvs_(
				"do{"
				"BEGIN{B::Hooks::EndOfScope::on_scope_end{"
				/*}}}*/, 0);
			if(had_paren) lex_stuff_pvs_("->x("/*)*/, 0);
			if(had_paren) {
				*op_ptr = gen_method_wrapper_op();
				return KEYWORD_PLUGIN_EXPR;
			} else {
				*op_ptr = newOP(OP_NULL, 0);
				return KEYWORD_PLUGIN_STMT;
			}
		} break;
		default: {
			croak("syntax error");
		} break;
	}
}

/*
 * hooked entry points
 *
 * The code here handles dispatch to keyword-invoked parsers and to
 * op rewriters.
 */

#define rvop_cv(rvop) THX_rvop_cv(aTHX_ rvop)
static CV *THX_rvop_cv(pTHX_ OP *rvop)
{
	switch(rvop->op_type) {
		case OP_CONST: {
			SV *rv = cSVOPx_sv(rvop);
			return SvROK(rv) ? (CV*)SvRV(rv) : NULL;
		} break;
		case OP_GV: return GvCV(cGVOPx_gv(rvop));
		default: return NULL;
	}
}

static CV *blockreturnwrapper_cv;

static OP *(*nxck_entersub)(pTHX_ OP *o);

static OP *myck_entersub(pTHX_ OP *op)
{
	OP *pushop, *cvop;
	pushop = cUNOPx(op)->op_first;
	if(!pushop->op_sibling) pushop = cUNOPx(pushop)->op_first;
	if(pushop->op_sibling && pushop->op_sibling->op_type == OP_CONST &&
			cSVOPx_sv(pushop->op_sibling) == methodwrapper_sv) {
		return ck_entersub_method_wrapper(op);
	}
	for(cvop = pushop; cvop->op_sibling; cvop = cvop->op_sibling) ;
	if(cvop->op_type == OP_RV2CV &&
			!(cvop->op_private & OPpENTERSUB_AMPER)) {
		CV *cv = rvop_cv(cUNOPx(cvop)->op_first);
		if(cv == blockreturnwrapper_cv) {
			return ck_entersub_block_return_wrapper(op);
		}
	}
	return nxck_entersub(aTHX_ op);
}

#define keyword_active(hintkey_sv) THX_keyword_active(aTHX_ hintkey_sv)
static int THX_keyword_active(pTHX_ SV *hintkey_sv)
{
	HE *he;
	if(!GvHV(PL_hintgv)) return 0;
	he = hv_fetch_ent(GvHV(PL_hintgv), hintkey_sv, 0,
				SvSHARED_HASH(hintkey_sv));
	return he && SvTRUE(HeVAL(he));
}

static SV *hintkey_sv_with_escape_function;
static SV *hintkey_sv_with_escape_continuation;
static SV *hintkey_sv_block;
static SV *hintkey_sv_return_from;
static SV *hintkey_sv_catch;

static int (*next_keyword_plugin)(pTHX_ char *, STRLEN, OP **);

#define KEYWORD_IS(KW) \
		(keyword_len == sizeof(""KW"")-1 && \
	 	 memEQ(keyword_ptr, ""KW"", sizeof(""KW"")-1))

static int my_keyword_plugin(pTHX_
	char *keyword_ptr, STRLEN keyword_len, OP **op_ptr)
{
	if(KEYWORD_IS("with_escape_function") &&
			keyword_active(hintkey_sv_with_escape_function)) {
		return parse_keyword_with_escape(op_ptr, 0);
	} else if(KEYWORD_IS("with_escape_continuation") &&
			keyword_active(hintkey_sv_with_escape_continuation)) {
		return parse_keyword_with_escape(op_ptr, 1);
	} else if(KEYWORD_IS("block") && keyword_active(hintkey_sv_block)) {
		return parse_keyword_block(op_ptr);
	} else if(KEYWORD_IS("return_from") &&
			keyword_active(hintkey_sv_return_from)) {
		return parse_keyword_return_from(op_ptr);
	} else if(KEYWORD_IS("catch") && keyword_active(hintkey_sv_catch)) {
		return parse_keyword_catch(op_ptr);
	} else {
		return next_keyword_plugin(aTHX_
			keyword_ptr, keyword_len, op_ptr);
	}
}

MODULE = Scope::Escape::Sugar PACKAGE = Scope::Escape::Sugar

BOOT:
	current_escape_function_rv =
		newRV_inc((SV*)get_cv(
			"Scope::Escape::current_escape_function", 0));
	current_escape_continuation_rv =
		newRV_inc((SV*)get_cv(
			"Scope::Escape::current_escape_continuation", 0));
	methodwrapper_sv = newSVpvs("");
	blockreturnwrapper_cv =
		get_cv("Scope::Escape::Sugar::_block_return_wrapper", 0);
	catcher_hv = get_hv("Scope::Escape::Sugar::_catch", 1);
	nxck_entersub = PL_check[OP_ENTERSUB];
	PL_check[OP_ENTERSUB] = myck_entersub;
	hintkey_sv_with_escape_function =
		newSVpvs_share("Scope::Escape::Sugar/with_escape_function");
	hintkey_sv_with_escape_continuation =
		newSVpvs_share("Scope::Escape::Sugar/with_escape_continuation");
	hintkey_sv_block = newSVpvs_share("Scope::Escape::Sugar/block");
	hintkey_sv_return_from =
		newSVpvs_share("Scope::Escape::Sugar/return_from");
	hintkey_sv_catch = newSVpvs_share("Scope::Escape::Sugar/catch");
	next_keyword_plugin = PL_keyword_plugin;
	PL_keyword_plugin = my_keyword_plugin;

void
_stuff(SV *sv)
PROTOTYPE: $
CODE:
	lex_stuff_sv_(sv, 0);

void
_expect_close_paren()
PROTOTYPE:
CODE:
	lex_read_space(0);
	if(lex_peek_unichar(0) != /*(*/')') croak("syntax error");

void
_block_return_wrapper(...)
PROTOTYPE: $@
CODE:
	croak("_block_return_wrapper called as a function");

void
_throw(SV *tag, ...)
PROTOTYPE: $@
CODE:
	PUSHMARK(MARK+1);
	call_sv(look_up_catcher(tag), 0);
	croak("failed to transfer control to catcher");
