package Ubuntu::Releases;

use 5.010001;
use strict;
use warnings;

use Exporter 'import';
use Perinci::Sub::Gen::AccessTable qw(gen_read_table_func);

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2023-07-20'; # DATE
our $DIST = 'Ubuntu-Releases'; # DIST
our $VERSION = '20230720.0'; # VERSION

our @EXPORT_OK = qw(
                       list_ubuntu_releases
               );

our %SPEC;

our $meta = {
    summary => 'Ubuntu releases',
    fields => {
        version         => { pos => 0, schema => "str*", sortable => 1, summary => "Version", unique => 1 },
        code_name       => { pos => 1, schema => "str*", sortable => 1, summary => "Code name", unique => 1 },
        animal          => { pos => 2, schema => "str*", sortable => 1, summary => "Code name", unique => 1 },
        reldate         => { pos => 3, schema => "date*", sortable => 1, summary => "Release date" },
        eoldate         => { pos => 4, schema => "date*", sortable => 1, summary => "Supported until" },

        linux_version   => {pos=> 5, schema=>'str*'},

        mysql_version        => {pos=> 6, schema=>'str*'},
        mariadb_version      => {pos=> 7, schema=>'str*'},
        postgresql_version   => {pos=> 8, schema=>'str*'},
        apache_httpd_version => {pos=> 9, schema=>'str*'},
        nginx_version        => {pos=>10, schema=>'str*'},

        perl_version         => {pos=>11, schema=>'str*'},
        python_version       => {pos=>12, schema=>'str*'},
        php_version          => {pos=>13, schema=>'str*'},
        ruby_version         => {pos=>14, schema=>'str*'},
        bash_version         => {pos=>15, schema=>'str*'},
    },
    pk => "version",
};

our $data = do {
    no warnings 'void';

 [
   {
     animal               => "warthog",
     apache_httpd_version => "--",
     bash_version         => "2.05b",
     code_name            => "warty",
     eoldate              => undef,
     linux_version        => "2.6.8.1",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.4",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.3.4",
     reldate              => "2004-10-20",
     ruby_version         => undef,
     version              => "4.10",
   },
   {
     animal               => "hedgehog",
     apache_httpd_version => "--",
     bash_version         => "3.0",
     code_name            => "hoary",
     eoldate              => undef,
     linux_version        => "2.6.10",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.4",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.4.1",
     reldate              => "2005-04-08",
     ruby_version         => undef,
     version              => 5.04,
   },
   {
     animal               => "badger",
     apache_httpd_version => "--",
     bash_version         => "3.0",
     code_name            => "breezy",
     eoldate              => undef,
     linux_version        => "2.6.12",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.7",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.4.2",
     reldate              => "2005-10-13",
     ruby_version         => undef,
     version              => "5.10",
   },
   {
     animal               => "drake",
     apache_httpd_version => "--",
     bash_version         => 3.1,
     code_name            => "dapper",
     eoldate              => undef,
     linux_version        => "2.6.15",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.7",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.4.3",
     reldate              => "2006-06-01",
     ruby_version         => undef,
     version              => "6.06 LTS",
   },
   {
     animal               => "eft",
     apache_httpd_version => "--",
     bash_version         => 3.1,
     code_name            => "edgy",
     eoldate              => undef,
     linux_version        => "2.6.17",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.8",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.4.4",
     reldate              => "2006-10-26",
     ruby_version         => undef,
     version              => "6.10",
   },
   {
     animal               => "fawn",
     apache_httpd_version => "--",
     bash_version         => 3.2,
     code_name            => "feisty",
     eoldate              => undef,
     linux_version        => "2.6.20",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.8",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.5.1rc1",
     reldate              => "2007-04-19",
     ruby_version         => undef,
     version              => 7.04,
   },
   {
     animal               => "gibbon",
     apache_httpd_version => "--",
     bash_version         => 3.2,
     code_name            => "gutsy",
     eoldate              => undef,
     linux_version        => "2.6.22",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.8",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.5.1",
     reldate              => "2007-10-18",
     ruby_version         => undef,
     version              => "7.10",
   },
   {
     animal               => "heron",
     apache_httpd_version => "--",
     bash_version         => 3.2,
     code_name            => "hardy",
     eoldate              => undef,
     linux_version        => "2.6.24",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.8.8",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.5.2",
     reldate              => "2008-04-24",
     ruby_version         => undef,
     version              => "8.04 LTS",
   },
   {
     animal               => "ibex",
     apache_httpd_version => "--",
     bash_version         => 3.2,
     code_name            => "intrepid",
     eoldate              => undef,
     linux_version        => "2.6.27",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.10.0",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.5.2",
     reldate              => "2008-10-30",
     ruby_version         => undef,
     version              => "8.10",
   },
   {
     animal               => "jackalope",
     apache_httpd_version => "--",
     bash_version         => 3.2,
     code_name            => "jaunty",
     eoldate              => undef,
     linux_version        => "2.6.28",
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.10.0",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "2.6.2",
     reldate              => "2009-04-23",
     ruby_version         => undef,
     version              => 9.04,
   },
   {
     animal               => "koala",
     apache_httpd_version => "2.2.12",
     bash_version         => "4.0",
     code_name            => "karmic",
     eoldate              => undef,
     linux_version        => "2.6.31",
     mariadb_version      => "--",
     mysql_version        => "5.1.37",
     nginx_version        => undef,
     perl_version         => "5.10.0",
     php_version          => "5.2.10",
     postgresql_version   => "8.4.1",
     python_version       => "2.6.4rc2",
     reldate              => "2009-10-29",
     ruby_version         => undef,
     version              => "9.10",
   },
   {
     animal               => "lynx",
     apache_httpd_version => "2.2.14",
     bash_version         => 4.1,
     code_name            => "lucid",
     eoldate              => "2013-05",
     linux_version        => "2.6.32",
     mariadb_version      => "--",
     mysql_version        => "5.1.41",
     nginx_version        => undef,
     perl_version         => "5.10.1",
     php_version          => "5.3.2",
     postgresql_version   => "8.4.3",
     python_version       => "2.6.5",
     reldate              => "2010-04-29",
     ruby_version         => undef,
     version              => "10.04 LTS",
   },
   {
     animal               => "meerkat",
     apache_httpd_version => "2.2.16",
     bash_version         => 4.1,
     code_name            => "maverick",
     eoldate              => "2012-04",
     linux_version        => "2.6.35",
     mariadb_version      => "--",
     mysql_version        => "5.1.49",
     nginx_version        => undef,
     perl_version         => "5.10.1",
     php_version          => "5.3.3",
     postgresql_version   => "8.4.4",
     python_version       => "2.6.6",
     reldate              => "2010-10-10",
     ruby_version         => undef,
     version              => "10.10",
   },
   {
     animal               => "narwhal",
     apache_httpd_version => "2.2.17",
     bash_version         => 4.2,
     code_name            => "natty",
     eoldate              => "2012-10",
     linux_version        => "2.6.38",
     mariadb_version      => "--",
     mysql_version        => "5.1.54",
     nginx_version        => undef,
     perl_version         => "5.10.1",
     php_version          => "5.3.5",
     postgresql_version   => "8.4.8",
     python_version       => "2.7.1",
     reldate              => "2011-04-28",
     ruby_version         => undef,
     version              => 11.04,
   },
   {
     animal               => "ocelot",
     apache_httpd_version => "2.2.20",
     bash_version         => 4.2,
     code_name            => "oneiric",
     eoldate              => "2013-05",
     linux_version        => "3.0",
     mariadb_version      => "--",
     mysql_version        => "5.1.58",
     nginx_version        => undef,
     perl_version         => "5.12.4",
     php_version          => "5.3.6",
     postgresql_version   => "9.1.1",
     python_version       => "2.7.2",
     reldate              => "2011-10-13",
     ruby_version         => undef,
     version              => "11.10",
   },
   {
     animal               => "pangolin",
     apache_httpd_version => "2.2.22",
     bash_version         => 4.2,
     code_name            => "precise",
     eoldate              => "2017-04",
     linux_version        => 3.2,
     mariadb_version      => "--",
     mysql_version        => "5.5.22",
     nginx_version        => undef,
     perl_version         => "5.14.2",
     php_version          => "5.3.10",
     postgresql_version   => "9.1.3",
     python_version       => "2.7.3",
     reldate              => "2012-04-26",
     ruby_version         => undef,
     version              => "12.04 LTS",
   },
   {
     animal               => "quetzal",
     apache_httpd_version => "2.2.22",
     bash_version         => 4.2,
     code_name            => "quantal",
     eoldate              => "2014-05",
     linux_version        => 3.5,
     mariadb_version      => "--",
     mysql_version        => "5.5.27",
     nginx_version        => undef,
     perl_version         => "5.14.2",
     php_version          => "5.4.6",
     postgresql_version   => "9.1.6",
     python_version       => "2.7.3",
     reldate              => "2012-10-18",
     ruby_version         => undef,
     version              => "12.10",
   },
   {
     animal               => "ringtail",
     apache_httpd_version => "2.2.22",
     bash_version         => 4.2,
     code_name            => "raring",
     eoldate              => "2014-01",
     linux_version        => 3.8,
     mariadb_version      => "--",
     mysql_version        => "5.5.29",
     nginx_version        => undef,
     perl_version         => "5.14.2",
     php_version          => "5.4.9",
     postgresql_version   => "9.1.9",
     python_version       => "2.7.3",
     reldate              => "2013-04-25",
     ruby_version         => undef,
     version              => 13.04,
   },
   {
     animal               => "salamander",
     apache_httpd_version => "2.4.6",
     bash_version         => 4.2,
     code_name            => "saucy",
     eoldate              => "2014-07",
     linux_version        => 3.11,
     mariadb_version      => "--",
     mysql_version        => "5.5.32",
     nginx_version        => undef,
     perl_version         => "5.14.2",
     php_version          => "5.5.3",
     postgresql_version   => "9.1.10",
     python_version       => "2.7.4",
     reldate              => "2013-10-17",
     ruby_version         => undef,
     version              => "13.10",
   },
   {
     animal               => "tahr",
     apache_httpd_version => "2.4.7",
     bash_version         => 4.3,
     code_name            => "trusty",
     eoldate              => "2019-04",
     linux_version        => 3.13,
     mariadb_version      => "--",
     mysql_version        => "5.5.35",
     nginx_version        => undef,
     perl_version         => "5.18.2",
     php_version          => "5.5.9",
     postgresql_version   => "9.3.4",
     python_version       => "2.7.5",
     reldate              => "2014-04-17",
     ruby_version         => undef,
     version              => "14.04 LTS",
   },
   {
     animal               => "unicorn",
     apache_httpd_version => "2.4.10",
     bash_version         => 4.3,
     code_name            => "utopic",
     eoldate              => "2015-07",
     linux_version        => 3.16,
     mariadb_version      => "--",
     mysql_version        => "5.5.39",
     nginx_version        => undef,
     perl_version         => "5.20.0",
     php_version          => "5.5.12",
     postgresql_version   => "9.4beta2",
     python_version       => "2.7.6",
     reldate              => "2014-10-23",
     ruby_version         => undef,
     version              => "14.10",
   },
   {
     animal               => "vervet",
     apache_httpd_version => "2.4.10",
     bash_version         => 4.3,
     code_name            => "vivid",
     eoldate              => "2016-01",
     linux_version        => 3.19,
     mariadb_version      => "--",
     mysql_version        => "5.6.24",
     nginx_version        => undef,
     perl_version         => "5.20.2",
     php_version          => "5.6.4",
     postgresql_version   => "9.4.1",
     python_version       => "2.7.8",
     reldate              => "2015-04-23",
     ruby_version         => undef,
     version              => 15.04,
   },
   {
     animal               => "werewolf",
     apache_httpd_version => "2.4.12",
     bash_version         => 4.3,
     code_name            => "wily",
     eoldate              => "2016-07",
     linux_version        => 4.2,
     mariadb_version      => "--",
     mysql_version        => "5.6.25",
     nginx_version        => undef,
     perl_version         => "5.20.2",
     php_version          => "5.6.11",
     postgresql_version   => "9.4.5",
     python_version       => "2.7.9",
     reldate              => "2015-10-22",
     ruby_version         => undef,
     version              => "15.10",
   },
   {
     animal               => "xerus",
     apache_httpd_version => "2.4.18",
     bash_version         => 4.3,
     code_name            => "xenial",
     eoldate              => "2021-04",
     linux_version        => 4.4,
     mariadb_version      => "--",
     mysql_version        => "5.7.11",
     nginx_version        => undef,
     perl_version         => "5.22.1",
     php_version          => "7.0.4",
     postgresql_version   => "9.5.2",
     python_version       => "3.5.1",
     reldate              => "2016-04-21",
     ruby_version         => undef,
     version              => "16.04 LTS",
   },
   {
     animal               => "yak",
     apache_httpd_version => "2.4.18",
     bash_version         => 4.3,
     code_name            => "yakkety",
     eoldate              => "2017-07",
     linux_version        => 4.8,
     mariadb_version      => "--",
     mysql_version        => "5.7.15",
     nginx_version        => undef,
     perl_version         => "5.22.2",
     php_version          => "7.0.8",
     postgresql_version   => "9.5.4",
     python_version       => "2.7.11",
     reldate              => "2016-10-13",
     ruby_version         => undef,
     version              => "16.10",
   },
   {
     animal               => "zapus",
     apache_httpd_version => "2.4.25",
     bash_version         => 4.4,
     code_name            => "zesty",
     eoldate              => "2018-01",
     linux_version        => "4.10",
     mariadb_version      => "--",
     mysql_version        => "5.7.17",
     nginx_version        => undef,
     perl_version         => "5.24.1",
     php_version          => "7.0.15",
     postgresql_version   => "9.6.2",
     python_version       => "2.7.13",
     reldate              => "2017-04-13",
     ruby_version         => undef,
     version              => 17.04,
   },
   {
     animal               => "aardvark",
     apache_httpd_version => "2.4.27",
     bash_version         => 4.4,
     code_name            => "artful",
     eoldate              => "2018-07",
     linux_version        => 4.13,
     mariadb_version      => "--",
     mysql_version        => "5.7.19",
     nginx_version        => undef,
     perl_version         => "5.26.0",
     php_version          => "7.1.8",
     postgresql_version   => "9.6.5",
     python_version       => "2.7.14",
     reldate              => "2017-10-19",
     ruby_version         => undef,
     version              => "17.10",
   },
   {
     animal               => "beaver",
     apache_httpd_version => "2.4.29",
     bash_version         => "4.4.18",
     code_name            => "bionic",
     eoldate              => "2023-04",
     linux_version        => 4.15,
     mariadb_version      => "--",
     mysql_version        => "5.7.21",
     nginx_version        => undef,
     perl_version         => "5.26.1",
     php_version          => "7.2.3",
     postgresql_version   => 10.3,
     python_version       => "2.7.15rc1",
     reldate              => "2018-04-26",
     ruby_version         => undef,
     version              => "18.04 LTS",
   },
   {
     animal               => "cuttlefish",
     apache_httpd_version => "2.4.34",
     bash_version         => "4.4.18",
     code_name            => "cosmic",
     eoldate              => "2019-07",
     linux_version        => 4.18,
     mariadb_version      => "--",
     mysql_version        => "5.7.23",
     nginx_version        => undef,
     perl_version         => "5.26.2",
     php_version          => "7.2.10",
     postgresql_version   => 10.5,
     python_version       => "3.6.6",
     reldate              => "2018-10-18",
     ruby_version         => undef,
     version              => "18.10",
   },
   {
     animal               => "dingo",
     apache_httpd_version => "2.4.38",
     bash_version         => "5.0",
     code_name            => "disco",
     eoldate              => "2020-01",
     linux_version        => "5.0",
     mariadb_version      => "--",
     mysql_version        => "5.7.25",
     nginx_version        => undef,
     perl_version         => "5.28.1",
     php_version          => "7.2.15",
     postgresql_version   => 11.2,
     python_version       => "3.7.3",
     reldate              => "2019-04-18",
     ruby_version         => undef,
     version              => 19.04,
   },
   {
     animal               => "ermine",
     apache_httpd_version => "2.4.41",
     bash_version         => "5.0",
     code_name            => "eoan",
     eoldate              => "2020-07",
     linux_version        => 5.3,
     mariadb_version      => "--",
     mysql_version        => "8.0.17",
     nginx_version        => undef,
     perl_version         => "5.28.1",
     php_version          => "7.3.8",
     postgresql_version   => 11.5,
     python_version       => "3.7.5",
     reldate              => "2019-10-17",
     ruby_version         => undef,
     version              => "19.10",
   },
   {
     animal               => "fossa",
     apache_httpd_version => "2.4.41",
     bash_version         => "5.0",
     code_name            => "focal",
     eoldate              => "2025-04",
     linux_version        => 5.4,
     mariadb_version      => "--",
     mysql_version        => "8.0.19",
     nginx_version        => undef,
     perl_version         => "5.30.0",
     php_version          => "7.4.3",
     postgresql_version   => 12.2,
     python_version       => "3.8.2",
     reldate              => "2020-04-23",
     ruby_version         => undef,
     version              => "20.04 LTS",
   },
   {
     animal               => "gorilla",
     apache_httpd_version => "--",
     bash_version         => "5.0",
     code_name            => "groovy",
     eoldate              => "2021-07",
     linux_version        => 5.8,
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.30.3",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "3.8.6",
     reldate              => "2020-10-22",
     ruby_version         => undef,
     version              => "20.10",
   },
   {
     animal               => "hippo",
     apache_httpd_version => "--",
     bash_version         => 5.1,
     code_name            => "hirsute",
     eoldate              => "2022-01",
     linux_version        => 5.11,
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.32.1",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "3.9.4",
     reldate              => "2021-04-22",
     ruby_version         => undef,
     version              => 21.04,
   },
   {
     animal               => "indri",
     apache_httpd_version => "--",
     bash_version         => 5.1,
     code_name            => "impish",
     eoldate              => "2022-07",
     linux_version        => 5.13,
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.32.1",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "3.9.4",
     reldate              => "2021-10-14",
     ruby_version         => undef,
     version              => "21.10",
   },
   {
     animal               => "jellyfish",
     apache_httpd_version => "--",
     bash_version         => 5.1,
     code_name            => "jammy",
     eoldate              => "2027-04",
     linux_version        => 5.15,
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.34.0",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "3.10.4",
     reldate              => "2022-04-21",
     ruby_version         => undef,
     version              => "22.04 LTS",
   },
   {
     animal               => "kudu",
     apache_httpd_version => "--",
     bash_version         => 5.2,
     code_name            => "kinetic",
     eoldate              => "2023-07",
     linux_version        => 5.19,
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.34.0",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "3.10.6",
     reldate              => "2022-10-20",
     ruby_version         => undef,
     version              => "22.10",
   },
   {
     animal               => "lobster",
     apache_httpd_version => "--",
     bash_version         => "5.2.15",
     code_name            => "lunar",
     eoldate              => "2024-01",
     linux_version        => 6.2,
     mariadb_version      => "--",
     mysql_version        => "--",
     nginx_version        => undef,
     perl_version         => "5.36.0",
     php_version          => "--",
     postgresql_version   => "--",
     python_version       => "3.11.2",
     reldate              => "2023-04-20",
     ruby_version         => undef,
     version              => 23.04,
   },
 ]
};

my $res = gen_read_table_func(
    name => 'list_ubuntu_releases',
    table_data => $data,
    table_spec => $meta,
    #langs => ['en_US', 'id_ID'],
);
die "BUG: Can't generate func: $res->[0] - $res->[1]" unless $res->[0] == 200;

1;
# ABSTRACT: List Ubuntu releases

__END__

=pod

=encoding UTF-8

=head1 NAME

Ubuntu::Releases - List Ubuntu releases

=head1 VERSION

This document describes version 20230720.0 of Ubuntu::Releases (from Perl distribution Ubuntu-Releases), released on 2023-07-20.

=head1 SYNOPSIS

 use Ubuntu::Releases;
 my $res = list_ubuntu_releases(detail=>1);
 # raw data is in $Ubuntu::Releases::data;

=head1 DESCRIPTION

This module contains list of Ubuntu releases. Data source is currently at:
L<https://github.com/sharyanto/gudangdata-distrowatch> (table/ubuntu_release)
which in turn is retrieved from L<http://distrowatch.com>. Additional data
source: L<https://github.com/sharyanto/gudangdata>
(table/ubuntu_release_animal).

=head1 FUNCTIONS


=head2 list_ubuntu_releases

Usage:

 list_ubuntu_releases(%args) -> [$status_code, $reason, $payload, \%result_meta]

Ubuntu releases.

REPLACE ME

This function is not exported by default, but exportable.

Arguments ('*' denotes required arguments):

=over 4

=item * B<animal> => I<str>

Only return records where the 'animal' field equals specified value.

=item * B<animal.contains> => I<str>

Only return records where the 'animal' field contains specified text.

=item * B<animal.in> => I<array[str]>

Only return records where the 'animal' field is in the specified values.

=item * B<animal.is> => I<str>

Only return records where the 'animal' field equals specified value.

=item * B<animal.isnt> => I<str>

Only return records where the 'animal' field does not equal specified value.

=item * B<animal.max> => I<str>

Only return records where the 'animal' field is less than or equal to specified value.

=item * B<animal.min> => I<str>

Only return records where the 'animal' field is greater than or equal to specified value.

=item * B<animal.not_contains> => I<str>

Only return records where the 'animal' field does not contain specified text.

=item * B<animal.not_in> => I<array[str]>

Only return records where the 'animal' field is not in the specified values.

=item * B<animal.xmax> => I<str>

Only return records where the 'animal' field is less than specified value.

=item * B<animal.xmin> => I<str>

Only return records where the 'animal' field is greater than specified value.

=item * B<apache_httpd_version> => I<str>

Only return records where the 'apache_httpd_version' field equals specified value.

=item * B<apache_httpd_version.contains> => I<str>

Only return records where the 'apache_httpd_version' field contains specified text.

=item * B<apache_httpd_version.in> => I<array[str]>

Only return records where the 'apache_httpd_version' field is in the specified values.

=item * B<apache_httpd_version.is> => I<str>

Only return records where the 'apache_httpd_version' field equals specified value.

=item * B<apache_httpd_version.isnt> => I<str>

Only return records where the 'apache_httpd_version' field does not equal specified value.

=item * B<apache_httpd_version.max> => I<str>

Only return records where the 'apache_httpd_version' field is less than or equal to specified value.

=item * B<apache_httpd_version.min> => I<str>

Only return records where the 'apache_httpd_version' field is greater than or equal to specified value.

=item * B<apache_httpd_version.not_contains> => I<str>

Only return records where the 'apache_httpd_version' field does not contain specified text.

=item * B<apache_httpd_version.not_in> => I<array[str]>

Only return records where the 'apache_httpd_version' field is not in the specified values.

=item * B<apache_httpd_version.xmax> => I<str>

Only return records where the 'apache_httpd_version' field is less than specified value.

=item * B<apache_httpd_version.xmin> => I<str>

Only return records where the 'apache_httpd_version' field is greater than specified value.

=item * B<bash_version> => I<str>

Only return records where the 'bash_version' field equals specified value.

=item * B<bash_version.contains> => I<str>

Only return records where the 'bash_version' field contains specified text.

=item * B<bash_version.in> => I<array[str]>

Only return records where the 'bash_version' field is in the specified values.

=item * B<bash_version.is> => I<str>

Only return records where the 'bash_version' field equals specified value.

=item * B<bash_version.isnt> => I<str>

Only return records where the 'bash_version' field does not equal specified value.

=item * B<bash_version.max> => I<str>

Only return records where the 'bash_version' field is less than or equal to specified value.

=item * B<bash_version.min> => I<str>

Only return records where the 'bash_version' field is greater than or equal to specified value.

=item * B<bash_version.not_contains> => I<str>

Only return records where the 'bash_version' field does not contain specified text.

=item * B<bash_version.not_in> => I<array[str]>

Only return records where the 'bash_version' field is not in the specified values.

=item * B<bash_version.xmax> => I<str>

Only return records where the 'bash_version' field is less than specified value.

=item * B<bash_version.xmin> => I<str>

Only return records where the 'bash_version' field is greater than specified value.

=item * B<code_name> => I<str>

Only return records where the 'code_name' field equals specified value.

=item * B<code_name.contains> => I<str>

Only return records where the 'code_name' field contains specified text.

=item * B<code_name.in> => I<array[str]>

Only return records where the 'code_name' field is in the specified values.

=item * B<code_name.is> => I<str>

Only return records where the 'code_name' field equals specified value.

=item * B<code_name.isnt> => I<str>

Only return records where the 'code_name' field does not equal specified value.

=item * B<code_name.max> => I<str>

Only return records where the 'code_name' field is less than or equal to specified value.

=item * B<code_name.min> => I<str>

Only return records where the 'code_name' field is greater than or equal to specified value.

=item * B<code_name.not_contains> => I<str>

Only return records where the 'code_name' field does not contain specified text.

=item * B<code_name.not_in> => I<array[str]>

Only return records where the 'code_name' field is not in the specified values.

=item * B<code_name.xmax> => I<str>

Only return records where the 'code_name' field is less than specified value.

=item * B<code_name.xmin> => I<str>

Only return records where the 'code_name' field is greater than specified value.

=item * B<detail> => I<bool> (default: 0)

Return array of full records instead of just ID fields.

By default, only the key (ID) field is returned per result entry.

=item * B<eoldate> => I<date>

Only return records where the 'eoldate' field equals specified value.

=item * B<eoldate.in> => I<array[date]>

Only return records where the 'eoldate' field is in the specified values.

=item * B<eoldate.is> => I<date>

Only return records where the 'eoldate' field equals specified value.

=item * B<eoldate.isnt> => I<date>

Only return records where the 'eoldate' field does not equal specified value.

=item * B<eoldate.max> => I<date>

Only return records where the 'eoldate' field is less than or equal to specified value.

=item * B<eoldate.min> => I<date>

Only return records where the 'eoldate' field is greater than or equal to specified value.

=item * B<eoldate.not_in> => I<array[date]>

Only return records where the 'eoldate' field is not in the specified values.

=item * B<eoldate.xmax> => I<date>

Only return records where the 'eoldate' field is less than specified value.

=item * B<eoldate.xmin> => I<date>

Only return records where the 'eoldate' field is greater than specified value.

=item * B<exclude_fields> => I<array[str]>

Select fields to return.

=item * B<fields> => I<array[str]>

Select fields to return.

=item * B<linux_version> => I<str>

Only return records where the 'linux_version' field equals specified value.

=item * B<linux_version.contains> => I<str>

Only return records where the 'linux_version' field contains specified text.

=item * B<linux_version.in> => I<array[str]>

Only return records where the 'linux_version' field is in the specified values.

=item * B<linux_version.is> => I<str>

Only return records where the 'linux_version' field equals specified value.

=item * B<linux_version.isnt> => I<str>

Only return records where the 'linux_version' field does not equal specified value.

=item * B<linux_version.max> => I<str>

Only return records where the 'linux_version' field is less than or equal to specified value.

=item * B<linux_version.min> => I<str>

Only return records where the 'linux_version' field is greater than or equal to specified value.

=item * B<linux_version.not_contains> => I<str>

Only return records where the 'linux_version' field does not contain specified text.

=item * B<linux_version.not_in> => I<array[str]>

Only return records where the 'linux_version' field is not in the specified values.

=item * B<linux_version.xmax> => I<str>

Only return records where the 'linux_version' field is less than specified value.

=item * B<linux_version.xmin> => I<str>

Only return records where the 'linux_version' field is greater than specified value.

=item * B<mariadb_version> => I<str>

Only return records where the 'mariadb_version' field equals specified value.

=item * B<mariadb_version.contains> => I<str>

Only return records where the 'mariadb_version' field contains specified text.

=item * B<mariadb_version.in> => I<array[str]>

Only return records where the 'mariadb_version' field is in the specified values.

=item * B<mariadb_version.is> => I<str>

Only return records where the 'mariadb_version' field equals specified value.

=item * B<mariadb_version.isnt> => I<str>

Only return records where the 'mariadb_version' field does not equal specified value.

=item * B<mariadb_version.max> => I<str>

Only return records where the 'mariadb_version' field is less than or equal to specified value.

=item * B<mariadb_version.min> => I<str>

Only return records where the 'mariadb_version' field is greater than or equal to specified value.

=item * B<mariadb_version.not_contains> => I<str>

Only return records where the 'mariadb_version' field does not contain specified text.

=item * B<mariadb_version.not_in> => I<array[str]>

Only return records where the 'mariadb_version' field is not in the specified values.

=item * B<mariadb_version.xmax> => I<str>

Only return records where the 'mariadb_version' field is less than specified value.

=item * B<mariadb_version.xmin> => I<str>

Only return records where the 'mariadb_version' field is greater than specified value.

=item * B<mysql_version> => I<str>

Only return records where the 'mysql_version' field equals specified value.

=item * B<mysql_version.contains> => I<str>

Only return records where the 'mysql_version' field contains specified text.

=item * B<mysql_version.in> => I<array[str]>

Only return records where the 'mysql_version' field is in the specified values.

=item * B<mysql_version.is> => I<str>

Only return records where the 'mysql_version' field equals specified value.

=item * B<mysql_version.isnt> => I<str>

Only return records where the 'mysql_version' field does not equal specified value.

=item * B<mysql_version.max> => I<str>

Only return records where the 'mysql_version' field is less than or equal to specified value.

=item * B<mysql_version.min> => I<str>

Only return records where the 'mysql_version' field is greater than or equal to specified value.

=item * B<mysql_version.not_contains> => I<str>

Only return records where the 'mysql_version' field does not contain specified text.

=item * B<mysql_version.not_in> => I<array[str]>

Only return records where the 'mysql_version' field is not in the specified values.

=item * B<mysql_version.xmax> => I<str>

Only return records where the 'mysql_version' field is less than specified value.

=item * B<mysql_version.xmin> => I<str>

Only return records where the 'mysql_version' field is greater than specified value.

=item * B<nginx_version> => I<str>

Only return records where the 'nginx_version' field equals specified value.

=item * B<nginx_version.contains> => I<str>

Only return records where the 'nginx_version' field contains specified text.

=item * B<nginx_version.in> => I<array[str]>

Only return records where the 'nginx_version' field is in the specified values.

=item * B<nginx_version.is> => I<str>

Only return records where the 'nginx_version' field equals specified value.

=item * B<nginx_version.isnt> => I<str>

Only return records where the 'nginx_version' field does not equal specified value.

=item * B<nginx_version.max> => I<str>

Only return records where the 'nginx_version' field is less than or equal to specified value.

=item * B<nginx_version.min> => I<str>

Only return records where the 'nginx_version' field is greater than or equal to specified value.

=item * B<nginx_version.not_contains> => I<str>

Only return records where the 'nginx_version' field does not contain specified text.

=item * B<nginx_version.not_in> => I<array[str]>

Only return records where the 'nginx_version' field is not in the specified values.

=item * B<nginx_version.xmax> => I<str>

Only return records where the 'nginx_version' field is less than specified value.

=item * B<nginx_version.xmin> => I<str>

Only return records where the 'nginx_version' field is greater than specified value.

=item * B<perl_version> => I<str>

Only return records where the 'perl_version' field equals specified value.

=item * B<perl_version.contains> => I<str>

Only return records where the 'perl_version' field contains specified text.

=item * B<perl_version.in> => I<array[str]>

Only return records where the 'perl_version' field is in the specified values.

=item * B<perl_version.is> => I<str>

Only return records where the 'perl_version' field equals specified value.

=item * B<perl_version.isnt> => I<str>

Only return records where the 'perl_version' field does not equal specified value.

=item * B<perl_version.max> => I<str>

Only return records where the 'perl_version' field is less than or equal to specified value.

=item * B<perl_version.min> => I<str>

Only return records where the 'perl_version' field is greater than or equal to specified value.

=item * B<perl_version.not_contains> => I<str>

Only return records where the 'perl_version' field does not contain specified text.

=item * B<perl_version.not_in> => I<array[str]>

Only return records where the 'perl_version' field is not in the specified values.

=item * B<perl_version.xmax> => I<str>

Only return records where the 'perl_version' field is less than specified value.

=item * B<perl_version.xmin> => I<str>

Only return records where the 'perl_version' field is greater than specified value.

=item * B<php_version> => I<str>

Only return records where the 'php_version' field equals specified value.

=item * B<php_version.contains> => I<str>

Only return records where the 'php_version' field contains specified text.

=item * B<php_version.in> => I<array[str]>

Only return records where the 'php_version' field is in the specified values.

=item * B<php_version.is> => I<str>

Only return records where the 'php_version' field equals specified value.

=item * B<php_version.isnt> => I<str>

Only return records where the 'php_version' field does not equal specified value.

=item * B<php_version.max> => I<str>

Only return records where the 'php_version' field is less than or equal to specified value.

=item * B<php_version.min> => I<str>

Only return records where the 'php_version' field is greater than or equal to specified value.

=item * B<php_version.not_contains> => I<str>

Only return records where the 'php_version' field does not contain specified text.

=item * B<php_version.not_in> => I<array[str]>

Only return records where the 'php_version' field is not in the specified values.

=item * B<php_version.xmax> => I<str>

Only return records where the 'php_version' field is less than specified value.

=item * B<php_version.xmin> => I<str>

Only return records where the 'php_version' field is greater than specified value.

=item * B<postgresql_version> => I<str>

Only return records where the 'postgresql_version' field equals specified value.

=item * B<postgresql_version.contains> => I<str>

Only return records where the 'postgresql_version' field contains specified text.

=item * B<postgresql_version.in> => I<array[str]>

Only return records where the 'postgresql_version' field is in the specified values.

=item * B<postgresql_version.is> => I<str>

Only return records where the 'postgresql_version' field equals specified value.

=item * B<postgresql_version.isnt> => I<str>

Only return records where the 'postgresql_version' field does not equal specified value.

=item * B<postgresql_version.max> => I<str>

Only return records where the 'postgresql_version' field is less than or equal to specified value.

=item * B<postgresql_version.min> => I<str>

Only return records where the 'postgresql_version' field is greater than or equal to specified value.

=item * B<postgresql_version.not_contains> => I<str>

Only return records where the 'postgresql_version' field does not contain specified text.

=item * B<postgresql_version.not_in> => I<array[str]>

Only return records where the 'postgresql_version' field is not in the specified values.

=item * B<postgresql_version.xmax> => I<str>

Only return records where the 'postgresql_version' field is less than specified value.

=item * B<postgresql_version.xmin> => I<str>

Only return records where the 'postgresql_version' field is greater than specified value.

=item * B<python_version> => I<str>

Only return records where the 'python_version' field equals specified value.

=item * B<python_version.contains> => I<str>

Only return records where the 'python_version' field contains specified text.

=item * B<python_version.in> => I<array[str]>

Only return records where the 'python_version' field is in the specified values.

=item * B<python_version.is> => I<str>

Only return records where the 'python_version' field equals specified value.

=item * B<python_version.isnt> => I<str>

Only return records where the 'python_version' field does not equal specified value.

=item * B<python_version.max> => I<str>

Only return records where the 'python_version' field is less than or equal to specified value.

=item * B<python_version.min> => I<str>

Only return records where the 'python_version' field is greater than or equal to specified value.

=item * B<python_version.not_contains> => I<str>

Only return records where the 'python_version' field does not contain specified text.

=item * B<python_version.not_in> => I<array[str]>

Only return records where the 'python_version' field is not in the specified values.

=item * B<python_version.xmax> => I<str>

Only return records where the 'python_version' field is less than specified value.

=item * B<python_version.xmin> => I<str>

Only return records where the 'python_version' field is greater than specified value.

=item * B<queries> => I<array[str]>

Search.

This will search all searchable fields with one or more specified queries. Each
query can be in the form of C<-FOO> (dash prefix notation) to require that the
fields do not contain specified string, or C</FOO/> to use regular expression.
All queries must match if the C<query_boolean> option is set to C<and>; only one
query should match if the C<query_boolean> option is set to C<or>.

=item * B<query_boolean> => I<str> (default: "and")

Whether records must match all search queries ('and') or just one ('or').

If set to C<and>, all queries must match; if set to C<or>, only one query should
match. See the C<queries> option for more details on searching.

=item * B<random> => I<bool> (default: 0)

Return records in random order.

=item * B<reldate> => I<date>

Only return records where the 'reldate' field equals specified value.

=item * B<reldate.in> => I<array[date]>

Only return records where the 'reldate' field is in the specified values.

=item * B<reldate.is> => I<date>

Only return records where the 'reldate' field equals specified value.

=item * B<reldate.isnt> => I<date>

Only return records where the 'reldate' field does not equal specified value.

=item * B<reldate.max> => I<date>

Only return records where the 'reldate' field is less than or equal to specified value.

=item * B<reldate.min> => I<date>

Only return records where the 'reldate' field is greater than or equal to specified value.

=item * B<reldate.not_in> => I<array[date]>

Only return records where the 'reldate' field is not in the specified values.

=item * B<reldate.xmax> => I<date>

Only return records where the 'reldate' field is less than specified value.

=item * B<reldate.xmin> => I<date>

Only return records where the 'reldate' field is greater than specified value.

=item * B<result_limit> => I<int>

Only return a certain number of records.

=item * B<result_start> => I<int> (default: 1)

Only return starting from the n'th record.

=item * B<ruby_version> => I<str>

Only return records where the 'ruby_version' field equals specified value.

=item * B<ruby_version.contains> => I<str>

Only return records where the 'ruby_version' field contains specified text.

=item * B<ruby_version.in> => I<array[str]>

Only return records where the 'ruby_version' field is in the specified values.

=item * B<ruby_version.is> => I<str>

Only return records where the 'ruby_version' field equals specified value.

=item * B<ruby_version.isnt> => I<str>

Only return records where the 'ruby_version' field does not equal specified value.

=item * B<ruby_version.max> => I<str>

Only return records where the 'ruby_version' field is less than or equal to specified value.

=item * B<ruby_version.min> => I<str>

Only return records where the 'ruby_version' field is greater than or equal to specified value.

=item * B<ruby_version.not_contains> => I<str>

Only return records where the 'ruby_version' field does not contain specified text.

=item * B<ruby_version.not_in> => I<array[str]>

Only return records where the 'ruby_version' field is not in the specified values.

=item * B<ruby_version.xmax> => I<str>

Only return records where the 'ruby_version' field is less than specified value.

=item * B<ruby_version.xmin> => I<str>

Only return records where the 'ruby_version' field is greater than specified value.

=item * B<sort> => I<array[str]>

Order records according to certain field(s).

A list of field names separated by comma. Each field can be prefixed with '-' to
specify descending order instead of the default ascending.

=item * B<version> => I<str>

Only return records where the 'version' field equals specified value.

=item * B<version.contains> => I<str>

Only return records where the 'version' field contains specified text.

=item * B<version.in> => I<array[str]>

Only return records where the 'version' field is in the specified values.

=item * B<version.is> => I<str>

Only return records where the 'version' field equals specified value.

=item * B<version.isnt> => I<str>

Only return records where the 'version' field does not equal specified value.

=item * B<version.max> => I<str>

Only return records where the 'version' field is less than or equal to specified value.

=item * B<version.min> => I<str>

Only return records where the 'version' field is greater than or equal to specified value.

=item * B<version.not_contains> => I<str>

Only return records where the 'version' field does not contain specified text.

=item * B<version.not_in> => I<array[str]>

Only return records where the 'version' field is not in the specified values.

=item * B<version.xmax> => I<str>

Only return records where the 'version' field is less than specified value.

=item * B<version.xmin> => I<str>

Only return records where the 'version' field is greater than specified value.

=item * B<with_field_names> => I<bool>

Return field names in each record (as hashE<sol>associative array).

When enabled, function will return each record as hash/associative array
(field name => value pairs). Otherwise, function will return each record
as list/array (field value, field value, ...).


=back

Returns an enveloped result (an array).

First element ($status_code) is an integer containing HTTP-like status code
(200 means OK, 4xx caller error, 5xx function error). Second element
($reason) is a string containing error message, or something like "OK" if status is
200. Third element ($payload) is the actual result, but usually not present when enveloped result is an error response ($status_code is not 2xx). Fourth
element (%result_meta) is called result metadata and is optional, a hash
that contains extra information, much like how HTTP response headers provide additional metadata.

Return value:  (any)

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/Ubuntu-Releases>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-Ubuntu-Releases>.

=head1 SEE ALSO

L<Debian::Releases>

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTOR

=for stopwords Steven Haryanto

Steven Haryanto <stevenharyanto@gmail.com>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>,
L<Pod::Weaver::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla- and/or Pod::Weaver plugins. Any additional steps required beyond
that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2023, 2022, 2021, 2020, 2019, 2017, 2016, 2015, 2014 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=Ubuntu-Releases>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut
