package File::Fetch::Item;

use strict;
use base 'File::Fetch';

use Params::Check               qw[check];
use Locale::Maketext::Simple    Style => 'gettext';

$Params::Check::VERBOSE = 1;

### template for new() and autogenerated accessors ###
my $Tmpl = {
    scheme  => { default => 'http' },
    host    => { default => 'localhost' },
    path    => { default => '/' },
    file    => { required => 1 },
    uri     => { required => 1 },
};

for my $method ( keys %$Tmpl ) {
    no strict 'refs';
    *$method = sub {
                    my $self = shift;
                    $self->{$method} = $_[0] if @_;
                    return $self->{$method};
                }
}

sub new {
    my $class = shift;
    my %hash  = @_;
    
    my $args = check( $Tmpl, \%hash ) or return;
    
    bless $args, $class;

    if( lc($args->scheme) ne 'file' and not $args->host ) {
        warn "Hostname required when fetching from '".$args->scheme."'\n";
        return;
    }
    
    for (qw[path file]) {
        unless( $args->$_ ) {
            warn "No '$_' specified\n";
            return;
        }
    }
    
    return $args;
}    


1;
