package Devel::PatchPerl::Hints;
$Devel::PatchPerl::Hints::VERSION = '2.08';
#ABSTRACT: replacement 'hints' files

use strict;
use warnings;
use MIME::Base64 qw[decode_base64];
use File::Spec;

our @ISA            = qw[Exporter];
our @EXPORT_OK      = qw[hint_file hints];

my %hints = (
'bitrig' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'cygwin' =>
'IyEgL2Jpbi9zaAojIGN5Z3dpbi5zaCAtIGhpbnRzIGZvciBidWlsZGluZyBwZXJsIHVzaW5nIHRo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==',
'darwin' =>
'IyMKIyBEYXJ3aW4gKE1hYyBPUykgaGludHMKIyBXaWxmcmVkbyBTYW5jaGV6IDx3c2FuY2hlekB3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',
'dragonfly' =>
'IyBoaW50cy9kcmFnb25mbHkuc2gKIwojIFRoaXMgZmlsZSBpcyBtb3N0bHkgY29waWVkIGZyb20g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',
'freebsd' =>
'IyBPcmlnaW5hbCBiYXNlZCBvbiBpbmZvIGZyb20KIyBDYXJsIE0uIEZvbmdoZWlzZXIgPGNtZkBp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',
'gnu' =>
'IyBoaW50cy9nbnUuc2gKIyBPcmlnaW5hbGx5IGNvbnRyaWJ1dGVkIGJ5OiAgTWFyayBLZXR0ZW5p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=',
'gnukfreebsd' =>
'IyEgL2Jpbi9zaAoKIyBTdXBwb3J0IGZvciBEZWJpYW4gR05VL2tGcmVlQlNEIChrZnJlZWJzZC1n
bnUpCiMgQSBwb3J0IG9mIHRoZSBEZWJpYW4gR05VIHN5c3RlbSB1c2luZyB0aGUgRnJlZUJTRCBr
ZXJuZWwuCgouIC4vaGludHMvbGludXguc2gKCg==',
'hpux' =>
'IyEvdXNyL2Jpbi9zaAoKIyMjIFNZU1RFTSBBUkNISVRFQ1RVUkUKCiMgRGV0ZXJtaW5lIHRoZSBh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==',
'linux' =>
'IyBoaW50cy9saW51eC5zaAojIE9yaWdpbmFsIHZlcnNpb24gYnkgcnNhbmRlcnMKIyBBZGRpdGlv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',
'midnightbsd' =>
'dXNldmZvcms9J3RydWUnCmNhc2UgIiR1c2VteW1hbGxvYyIgaW4KICAgICIiKSB1c2VteW1hbGxv
Yz0nbicKICAgICAgICA7Owplc2FjCmxpYnN3YW50ZWQ9YGVjaG8gJGxpYnN3YW50ZWQgfCBzZWQg
J3MvIG1hbGxvYyAvIC8nYAoKb2JqZm9ybWF0PWAvdXNyL2Jpbi9vYmpmb3JtYXRgCmlmIFsgeCRv
Ympmb3JtYXQgPSB4YW91dCBdOyB0aGVuCiAgICBpZiBbIC1lIC91c3IvbGliL2FvdXQgXTsgdGhl
bgogICAgICAgIGxpYnB0aD0iL3Vzci9saWIvYW91dCAvdXNyL2xvY2FsL2xpYiAvdXNyL2xpYiIK
ICAgICAgICBnbGlicHRoPSIvdXNyL2xpYi9hb3V0IC91c3IvbG9jYWwvbGliIC91c3IvbGliIgog
ICAgZmkKICAgIGxkZGxmbGFncz0nLUJzaGFyZWFibGUnCmVsc2UKICAgIGxpYnB0aD0iL3Vzci9s
aWIgL3Vzci9sb2NhbC9saWIiCiAgICBnbGlicHRoPSIvdXNyL2xpYiAvdXNyL2xvY2FsL2xpYiIK
ICAgIGxkZmxhZ3M9Ii1XbCwtRSAiCiAgICBsZGRsZmxhZ3M9Ii1zaGFyZWQgIgpmaQpjY2NkbGZs
YWdzPSctRFBJQyAtZlBJQycKCmNjZmxhZ3M9IiR7Y2NmbGFnc30gLURIQVNfRlBTRVRNQVNLIC1E
SEFTX0ZMT0FUSU5HUE9JTlRfSCIKaWYgL3Vzci9iaW4vZmlsZSAtTCAvdXNyL2xpYi9saWJjLnNv
IHwgL3Vzci9iaW4vZ3JlcCAtdnEgIm5vdCBzdHJpcHBlZCIgOyB0aGVuCiAgICB1c2VubT1mYWxz
ZQpmaQoKc2lnbmFsX3Q9J3ZvaWQnCmRfdm9pZHNpZz0nZGVmaW5lJwoKIyBUaGlzIHNjcmlwdCBV
VS91c2V0aHJlYWRzLmNidSB3aWxsIGdldCAnY2FsbGVkLWJhY2snIGJ5IENvbmZpZ3VyZSAKIyBh
ZnRlciBpdCBoYXMgcHJvbXB0ZWQgdGhlIHVzZXIgZm9yIHdoZXRoZXIgdG8gdXNlIHRocmVhZHMu
CmNhdCA+IFVVL3VzZXRocmVhZHMuY2J1IDw8J0VPQ0JVJwpjYXNlICIkdXNldGhyZWFkcyIgaW4K
JGRlZmluZXx0cnVlfFt5WV0qKQoJbGRmbGFncz0iLXB0aHJlYWQgJGxkZmxhZ3MiCglzZXQgYGVj
aG8gWCAiJGxpYnN3YW50ZWQgInwgc2VkIC1lICdzLyBjIC8vJ2AKCXNoaWZ0CglsaWJzd2FudGVk
PSIkKiIKCSMgQ29uZmlndXJlIHdpbGwgcHJvYmFibHkgcGljayB0aGUgd3JvbmcgbGliYyB0byB1
c2UgZm9yIG5tIHNjYW4uCgkjIFRoZSBzYWZlc3QgcXVpY2stZml4IGlzIGp1c3QgdG8gbm90IHVz
ZSBubSBhdCBhbGwuLi4KCXVzZW5tPWZhbHNlCgogICAgICAgIHVuc2V0IGxjX3IKCgkjIEV2ZW4g
d2l0aCB0aGUgbWFsbG9jIG11dGV4ZXMgdGhlIFBlcmwgbWFsbG9jIGRvZXMgbm90CgkjIHNlZW0g
dG8gYmUgdGhyZWFkc2FmZSBpbiBNaWRuaWdodEJTRD8KCWNhc2UgIiR1c2VteW1hbGxvYyIgaW4K
CScnKSB1c2VteW1hbGxvYz1uIDs7Cgllc2FjCmVzYWMKRU9DQlUKCiMgbWFsbG9jIHdyYXAgd29y
a3MKY2FzZSAiJHVzZW1hbGxvY3dyYXAiIGluCicnKSB1c2VtYWxsb2N3cmFwPSdkZWZpbmUnIDs7
CmVzYWMK',
'netbsd' =>
'IyBoaW50cy9uZXRic2Quc2gKIwojIFBsZWFzZSBjaGVjayB3aXRoIHBhY2thZ2VzQG5ldGJzZC5v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',
'openbsd' =>
'IyBoaW50cy9vcGVuYnNkLnNoCiMKIyBoaW50cyBmaWxlIGZvciBPcGVuQlNEOyBUb2RkIE1pbGxl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',
'solaris' =>
'IyBoaW50cy9zb2xhcmlzXzIuc2gKIyBDb250cmlidXRpb25zIGJ5IChpbiBhbHBoYWJldGljYWwg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',
);

my %files = (
  'freebsd' => 'freebsd.sh',
  'netbsd'  => 'netbsd.sh',
  'openbsd' => 'openbsd.sh',
  'linux'   => 'linux.sh',
  'dragonfly' => 'dragonfly.sh',
  'darwin' => 'darwin.sh',
  'hpux' => 'hpux.sh',
  'cygwin' => 'cygwin.sh',
  'midnightbsd' => 'midnightbsd.sh',
  'gnukfreebsd' => 'gnukfreebsd.sh',
  'solaris' => 'solaris_2.sh',
  'bitrig' => 'bitrig.sh',
  'gnu' => 'gnu.sh',
);

sub hint_file {
  my $os = shift;
  $os = shift if eval { $os->isa(__PACKAGE__) };
  $os = $^O unless $os;
  return unless defined $hints{ $os };
  my $content = decode_base64( $hints{ $os } );
  return $content unless wantarray;
  return ( $files{ $os }, $content );
}

sub hints {
  return sort keys %hints;
}

qq'nudge nudge wink wink';

__END__

=pod

=encoding UTF-8

=head1 NAME

Devel::PatchPerl::Hints - replacement 'hints' files

=head1 VERSION

version 2.08

=head1 SYNOPSIS

  use Devel::PatchPerl::Hints;

  if ( my $content = Devel::PatchPerl::Hints->hint_file() ) {
    chmod 0644, 'hints/netbsd.sh' or die "$!";
    open my $hints, '>', 'hints/netbsd.sh' or die "$!";
    print $hints $content;
    close $hints;
  }

  # Get a list of OS for which we have hints

  my @os = Devel::PatchPerl::Hints->hints();

=head1 DESCRIPTION

Sometimes there is a problem with Perls C<hints> file for a particular
perl port. This module provides fixed C<hints> files encoded using
C<MIME::Base64>.

=head1 FUNCTION

The function is exported, but has to implicitly imported into the
requesting package.

  use Devel::PatchPerl::Hints qw[hint_file];

It may also be called as a class method:

  use Devel::PatchPerl::Hints;

  my $content = Devel::PatchPerl::Hints->hint_file();

=over

=item C<hint_file>

Takes an optional argument which is the OS name ( as would be returned by C<$^O> ).
By default it will use C<$^O>.

In a scalar context, Will return the decoded content of the C<hints> file suitable for writing straight to a
file handle or undef list if there isn't an applicable C<hints> file for the given or derived
OS.

If called in a list context, will return a list, the first item will be the name of the C<hints> file that
will need to be amended, the second item will be a string with the decoded content of the C<hints> file suitable
for writing straight to a file handle. Otherwise an empty list will be returned.

=item C<hints>

Takes no arguments, returns a list of OS names for which there are C<hints> files.

=back

=head1 AUTHOR

Chris Williams <chris@bingosnet.co.uk>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2021 by Chris Williams and Marcus Holland-Moritz.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
