# Generated by default/object.tt
package Paws::Macie2::IpAddressDetails;
  use Moose;
  has IpAddressV4 => (is => 'ro', isa => 'Str', request_name => 'ipAddressV4', traits => ['NameInRequest']);
  has IpCity => (is => 'ro', isa => 'Paws::Macie2::IpCity', request_name => 'ipCity', traits => ['NameInRequest']);
  has IpCountry => (is => 'ro', isa => 'Paws::Macie2::IpCountry', request_name => 'ipCountry', traits => ['NameInRequest']);
  has IpGeoLocation => (is => 'ro', isa => 'Paws::Macie2::IpGeoLocation', request_name => 'ipGeoLocation', traits => ['NameInRequest']);
  has IpOwner => (is => 'ro', isa => 'Paws::Macie2::IpOwner', request_name => 'ipOwner', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::IpAddressDetails

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::IpAddressDetails object:

  $service_obj->Method(Att1 => { IpAddressV4 => $value, ..., IpOwner => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::IpAddressDetails object:

  $result = $service_obj->Method(...);
  $result->Att1->IpAddressV4

=head1 DESCRIPTION

Provides information about the IP address of the device that an entity
used to perform an action on an affected resource.

=head1 ATTRIBUTES


=head2 IpAddressV4 => Str

The Internet Protocol version 4 (IPv4) address of the device.


=head2 IpCity => L<Paws::Macie2::IpCity>

The city that the IP address originated from.


=head2 IpCountry => L<Paws::Macie2::IpCountry>

The country that the IP address originated from.


=head2 IpGeoLocation => L<Paws::Macie2::IpGeoLocation>

The geographic coordinates of the location that the IP address
originated from.


=head2 IpOwner => L<Paws::Macie2::IpOwner>

The registered owner of the IP address.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

