# Generated by default/object.tt
package Paws::LookoutVision::ModelPerformance;
  use Moose;
  has F1Score => (is => 'ro', isa => 'Num');
  has Precision => (is => 'ro', isa => 'Num');
  has Recall => (is => 'ro', isa => 'Num');

1;

### main pod documentation begin ###

=head1 NAME

Paws::LookoutVision::ModelPerformance

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LookoutVision::ModelPerformance object:

  $service_obj->Method(Att1 => { F1Score => $value, ..., Recall => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LookoutVision::ModelPerformance object:

  $result = $service_obj->Method(...);
  $result->Att1->F1Score

=head1 DESCRIPTION

Information about the evaluation performance of a trained model.

=head1 ATTRIBUTES


=head2 F1Score => Num

The overall F1 score metric for the trained model.


=head2 Precision => Num

The overall precision metric value for the trained model.


=head2 Recall => Num

The overall recall metric value for the trained model.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LookoutVision>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

