# Generated by default/object.tt
package Paws::Lambda::CodeSigningPolicies;
  use Moose;
  has UntrustedArtifactOnDeployment => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lambda::CodeSigningPolicies

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lambda::CodeSigningPolicies object:

  $service_obj->Method(Att1 => { UntrustedArtifactOnDeployment => $value, ..., UntrustedArtifactOnDeployment => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lambda::CodeSigningPolicies object:

  $result = $service_obj->Method(...);
  $result->Att1->UntrustedArtifactOnDeployment

=head1 DESCRIPTION

Code signing configuration policies
(https://docs.aws.amazon.com/lambda/latest/dg/configuration-codesigning.html#config-codesigning-policies)
specify the validation failure action for signature mismatch or expiry.

=head1 ATTRIBUTES


=head2 UntrustedArtifactOnDeployment => Str

Code signing configuration policy for deployment validation failure. If
you set the policy to C<Enforce>, Lambda blocks the deployment request
if signature validation checks fail. If you set the policy to C<Warn>,
Lambda allows the deployment and creates a CloudWatch log.

Default value: C<Warn>



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lambda>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

