# Generated by default/object.tt
package Paws::WAFV2::RuleGroupReferenceStatement;
  use Moose;
  has ARN => (is => 'ro', isa => 'Str', required => 1);
  has ExcludedRules => (is => 'ro', isa => 'ArrayRef[Paws::WAFV2::ExcludedRule]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::WAFV2::RuleGroupReferenceStatement

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::WAFV2::RuleGroupReferenceStatement object:

  $service_obj->Method(Att1 => { ARN => $value, ..., ExcludedRules => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::WAFV2::RuleGroupReferenceStatement object:

  $result = $service_obj->Method(...);
  $result->Att1->ARN

=head1 DESCRIPTION

A rule statement used to run the rules that are defined in a RuleGroup.
To use this, create a rule group with your rules, then provide the ARN
of the rule group in this statement.

You cannot nest a C<RuleGroupReferenceStatement>, for example for use
inside a C<NotStatement> or C<OrStatement>. It can only be referenced
as a top-level statement within a rule.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ARN => Str

The Amazon Resource Name (ARN) of the entity.


=head2 ExcludedRules => ArrayRef[L<Paws::WAFV2::ExcludedRule>]

The names of rules that are in the referenced rule group, but that you
want WAF to exclude from processing for this rule statement.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::WAFV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

