# Generated by default/object.tt
package Paws::SSMIncidents::IncidentTemplate;
  use Moose;
  has DedupeString => (is => 'ro', isa => 'Str', request_name => 'dedupeString', traits => ['NameInRequest']);
  has Impact => (is => 'ro', isa => 'Int', request_name => 'impact', traits => ['NameInRequest'], required => 1);
  has NotificationTargets => (is => 'ro', isa => 'ArrayRef[Paws::SSMIncidents::NotificationTargetItem]', request_name => 'notificationTargets', traits => ['NameInRequest']);
  has Summary => (is => 'ro', isa => 'Str', request_name => 'summary', traits => ['NameInRequest']);
  has Title => (is => 'ro', isa => 'Str', request_name => 'title', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::SSMIncidents::IncidentTemplate

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SSMIncidents::IncidentTemplate object:

  $service_obj->Method(Att1 => { DedupeString => $value, ..., Title => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SSMIncidents::IncidentTemplate object:

  $result = $service_obj->Method(...);
  $result->Att1->DedupeString

=head1 DESCRIPTION

Basic details used in creating a response plan. The response plan is
then used to create an incident record.

=head1 ATTRIBUTES


=head2 DedupeString => Str

Used to stop Incident Manager from creating multiple incident records
for the same incident.


=head2 B<REQUIRED> Impact => Int

The impact of the incident on your customers and applications.


=head2 NotificationTargets => ArrayRef[L<Paws::SSMIncidents::NotificationTargetItem>]

The SNS targets that AWS Chatbot uses to notify the chat channel of
updates to an incident. You can also make updates to the incident
through the chat channel using the SNS topics.


=head2 Summary => Str

The summary of the incident. The summary is a brief synopsis of what
occurred, what's currently happening, and context.


=head2 B<REQUIRED> Title => Str

The title of the incident.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SSMIncidents>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

