# Generated by default/object.tt
package Paws::S3Control::ListStorageLensConfigurationEntry;
  use Moose;
  has HomeRegion => (is => 'ro', isa => 'Str', required => 1);
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has IsEnabled => (is => 'ro', isa => 'Bool');
  has StorageLensArn => (is => 'ro', isa => 'Str', required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::S3Control::ListStorageLensConfigurationEntry

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::S3Control::ListStorageLensConfigurationEntry object:

  $service_obj->Method(Att1 => { HomeRegion => $value, ..., StorageLensArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::S3Control::ListStorageLensConfigurationEntry object:

  $result = $service_obj->Method(...);
  $result->Att1->HomeRegion

=head1 DESCRIPTION

Part of C<ListStorageLensConfigurationResult>. Each entry includes the
description of the S3 Storage Lens configuration, its home Region,
whether it is enabled, its Amazon Resource Name (ARN), and config ID.

=head1 ATTRIBUTES


=head2 B<REQUIRED> HomeRegion => Str

A container for the S3 Storage Lens home Region. Your metrics data is
stored and retained in your designated S3 Storage Lens home Region.


=head2 B<REQUIRED> Id => Str

A container for the S3 Storage Lens configuration ID.


=head2 IsEnabled => Bool

A container for whether the S3 Storage Lens configuration is enabled.
This property is required.


=head2 B<REQUIRED> StorageLensArn => Str

The ARN of the S3 Storage Lens configuration. This property is
read-only.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::S3Control>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

