# Generated by default/object.tt
package Paws::MediaTailor::DashPlaylistSettings;
  use Moose;
  has ManifestWindowSeconds => (is => 'ro', isa => 'Int');
  has MinBufferTimeSeconds => (is => 'ro', isa => 'Int');
  has MinUpdatePeriodSeconds => (is => 'ro', isa => 'Int');
  has SuggestedPresentationDelaySeconds => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaTailor::DashPlaylistSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaTailor::DashPlaylistSettings object:

  $service_obj->Method(Att1 => { ManifestWindowSeconds => $value, ..., SuggestedPresentationDelaySeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaTailor::DashPlaylistSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->ManifestWindowSeconds

=head1 DESCRIPTION

Dash manifest configuration parameters.

=head1 ATTRIBUTES


=head2 ManifestWindowSeconds => Int

The total duration (in seconds) of each manifest. Minimum value: 30
seconds. Maximum value: 3600 seconds.


=head2 MinBufferTimeSeconds => Int

Minimum amount of content (measured in seconds) that a player must keep
available in the buffer. Minimum value: 2 seconds. Maximum value: 60
seconds.


=head2 MinUpdatePeriodSeconds => Int

Minimum amount of time (in seconds) that the player should wait before
requesting updates to the manifest. Minimum value: 2 seconds. Maximum
value: 60 seconds.


=head2 SuggestedPresentationDelaySeconds => Int

Amount of time (in seconds) that the player should be from the live
point at the end of the manifest. Minimum value: 2 seconds. Maximum
value: 60 seconds.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaTailor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

