use Test::More;

my $deep = { okay => 1 };
my $deeper = { okay => 2 };

$deep->{deeper} = $deeper;
$deep->{deep} = $deep;

$deeper->{deep} = $deep;

use Const::XS qw/all/;

ok(1);

eval {
	make_readonly($deeper);
};

like($@, qr/Looks like you are in deep recursion/);

eval {
	unmake_readonly($deeper);
};

like($@, qr/Looks like you are in deep recursion/);

my $hash = {};
my $copy = $hash;
for (0..5000) {
	$copy->{a} = {};
	$copy = $copy->{a};
}

make_readonly($hash);
is(is_readonly($hash), 1);

my $obj = bless { a => 1 }, 'Imaginary';

make_readonly($obj);
is(is_readonly($obj), 1);

eval {
	$obj->{b} = 2;
};

like($@, qr/Attempt to access disallowed key 'b' in a restricted hash/);

done_testing();
