# This Makefile.PL for Alien-CFITSIO was generated by
# Dist::Zilla::Plugin::MakeMaker::Awesome 0.49.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use ExtUtils::MakeMaker;

use Alien::Base::Wrapper qw( Alien::curl Alien::zlib !export );

my %WriteMakefileArgs = (
  "ABSTRACT" => "Build and Install the CFITSIO library",
  "AUTHOR" => "Diab Jerius <djerius\@cpan.org>",
  "BUILD_REQUIRES" => {
    "Alien::Build" => "0.32",
    "Alien::Build::MM" => "0.32",
    "Alien::patch" => "0.15",
    "ExtUtils::MakeMaker" => "6.52"
  },
  "CONFIGURE_REQUIRES" => {
    "Alien::Build" => "2.3901",
    "Alien::Build::MM" => "0.32",
    "Alien::Build::Plugin::PkgConfig::Negotiate" => "1.53",
    "Alien::curl" => 0,
    "Alien::zlib" => 0,
    "ExtUtils::MakeMaker" => "6.52",
    "Sort::Versions" => 0
  },
  "DISTNAME" => "Alien-CFITSIO",
  "LICENSE" => "gpl",
  "NAME" => "Alien::CFITSIO",
  "PREREQ_PM" => {
    "Alien::Base" => 0
  },
  "TEST_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.52",
    "File::Spec" => 0,
    "IO::Handle" => 0,
    "IPC::Open3" => 0,
    "Package::Stash" => "0.40",
    "Test2::V0" => 0,
    "Test::Alien" => "2.3901",
    "Test::More" => 0
  },
  "VERSION" => "v4.6.2.3",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

%WriteMakefileArgs = (
    %WriteMakefileArgs,
    Alien::Base::Wrapper->mm_args,
);

my %FallbackPrereqs = (
  "Alien::Base" => 0,
  "Alien::Build" => "0.32",
  "Alien::Build::MM" => "0.32",
  "Alien::patch" => "0.15",
  "ExtUtils::MakeMaker" => "6.52",
  "File::Spec" => 0,
  "IO::Handle" => 0,
  "IPC::Open3" => 0,
  "Package::Stash" => "0.40",
  "Test2::V0" => 0,
  "Test::Alien" => "2.3901",
  "Test::More" => 0
);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
use Alien::Build::MM;
my $abmm = Alien::Build::MM->new;
%WriteMakefileArgs = $abmm->mm_args(%WriteMakefileArgs);
# END code inserted by Dist::Zilla::Plugin::AlienBuild

unless ( eval { ExtUtils::MakeMaker->VERSION('6.63_03') } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

# BEGIN code inserted by Dist::Zilla::Plugin::AlienBuild
{ package
    MY;
  sub postamble {
    $abmm->mm_postamble(@_);
  }
  sub install {
    $abmm->can('mm_install')
      ? $abmm->mm_install(@_)
      : shift->SUPER::install(@_);
  }
}
# END code inserted by Dist::Zilla::Plugin::AlienBuild
