
BEGIN {
    unless ('A' eq pack('U', 0x41)) {
	print "1..0 # Unicode::Collate cannot pack a Unicode code point\n";
	exit 0;
    }
    unless (0x41 == unpack('U', 'A')) {
	print "1..0 # Unicode::Collate cannot get a Unicode code point\n";
	exit 0;
    }
    if ($ENV{PERL_CORE}) {
	chdir('t') if -d 't';
	@INC = $^O eq 'MacOS' ? qw(::lib) : qw(../lib);
    }
}

use strict;
use warnings;
BEGIN { $| = 1; print "1..759\n"; }
my $count = 0;
sub ok ($;$) {
    my $p = my $r = shift;
    if (@_) {
	my $x = shift;
	$p = !defined $x ? !defined $r : !defined $r ? 0 : $r eq $x;
    }
    print $p ? "ok" : "not ok", ' ', ++$count, "\n";
}

use Unicode::Collate::Locale;

ok(1);

#########################

my $objJa = Unicode::Collate::Locale->
    new(locale => 'JA', normalization => undef);

ok($objJa->getlocale, 'ja');

$objJa->change(level => 2);

ok($objJa->eq("\x{30A1}\x{30FD}", "\x{30A1}\x{30A2}"));
ok($objJa->eq("\x{30A2}\x{30FD}", "\x{30A2}\x{30A2}"));
ok($objJa->eq("\x{30A3}\x{30FD}", "\x{30A3}\x{30A4}"));
ok($objJa->eq("\x{30A4}\x{30FD}", "\x{30A4}\x{30A4}"));
ok($objJa->eq("\x{30A5}\x{30FD}", "\x{30A5}\x{30A6}"));
ok($objJa->eq("\x{30A6}\x{30FD}", "\x{30A6}\x{30A6}"));
ok($objJa->eq("\x{30A7}\x{30FD}", "\x{30A7}\x{30A8}"));
ok($objJa->eq("\x{30A8}\x{30FD}", "\x{30A8}\x{30A8}"));
ok($objJa->eq("\x{30A9}\x{30FD}", "\x{30A9}\x{30AA}"));
ok($objJa->eq("\x{30AA}\x{30FD}", "\x{30AA}\x{30AA}"));
ok($objJa->eq("\x{30AB}\x{30FD}", "\x{30AB}\x{30AB}"));
ok($objJa->eq("\x{30AC}\x{30FD}", "\x{30AC}\x{30AB}"));
ok($objJa->eq("\x{30AD}\x{30FD}", "\x{30AD}\x{30AD}"));
ok($objJa->eq("\x{30AE}\x{30FD}", "\x{30AE}\x{30AD}"));
ok($objJa->eq("\x{30AF}\x{30FD}", "\x{30AF}\x{30AF}"));
ok($objJa->eq("\x{30B0}\x{30FD}", "\x{30B0}\x{30AF}"));
ok($objJa->eq("\x{30B1}\x{30FD}", "\x{30B1}\x{30B1}"));
ok($objJa->eq("\x{30B2}\x{30FD}", "\x{30B2}\x{30B1}"));
ok($objJa->eq("\x{30B3}\x{30FD}", "\x{30B3}\x{30B3}"));
ok($objJa->eq("\x{30B4}\x{30FD}", "\x{30B4}\x{30B3}"));
ok($objJa->eq("\x{30B5}\x{30FD}", "\x{30B5}\x{30B5}"));
ok($objJa->eq("\x{30B6}\x{30FD}", "\x{30B6}\x{30B5}"));
ok($objJa->eq("\x{30B7}\x{30FD}", "\x{30B7}\x{30B7}"));
ok($objJa->eq("\x{30B8}\x{30FD}", "\x{30B8}\x{30B7}"));
ok($objJa->eq("\x{30B9}\x{30FD}", "\x{30B9}\x{30B9}"));
ok($objJa->eq("\x{30BA}\x{30FD}", "\x{30BA}\x{30B9}"));
ok($objJa->eq("\x{30BB}\x{30FD}", "\x{30BB}\x{30BB}"));
ok($objJa->eq("\x{30BC}\x{30FD}", "\x{30BC}\x{30BB}"));
ok($objJa->eq("\x{30BD}\x{30FD}", "\x{30BD}\x{30BD}"));
ok($objJa->eq("\x{30BE}\x{30FD}", "\x{30BE}\x{30BD}"));
ok($objJa->eq("\x{30BF}\x{30FD}", "\x{30BF}\x{30BF}"));
ok($objJa->eq("\x{30C0}\x{30FD}", "\x{30C0}\x{30BF}"));
ok($objJa->eq("\x{30C1}\x{30FD}", "\x{30C1}\x{30C1}"));
ok($objJa->eq("\x{30C2}\x{30FD}", "\x{30C2}\x{30C1}"));
ok($objJa->eq("\x{30C3}\x{30FD}", "\x{30C3}\x{30C4}"));
ok($objJa->eq("\x{30C4}\x{30FD}", "\x{30C4}\x{30C4}"));
ok($objJa->eq("\x{30C5}\x{30FD}", "\x{30C5}\x{30C4}"));
ok($objJa->eq("\x{30C6}\x{30FD}", "\x{30C6}\x{30C6}"));
ok($objJa->eq("\x{30C7}\x{30FD}", "\x{30C7}\x{30C6}"));
ok($objJa->eq("\x{30C8}\x{30FD}", "\x{30C8}\x{30C8}"));
ok($objJa->eq("\x{30C9}\x{30FD}", "\x{30C9}\x{30C8}"));
ok($objJa->eq("\x{30CA}\x{30FD}", "\x{30CA}\x{30CA}"));
ok($objJa->eq("\x{30CB}\x{30FD}", "\x{30CB}\x{30CB}"));
ok($objJa->eq("\x{30CC}\x{30FD}", "\x{30CC}\x{30CC}"));
ok($objJa->eq("\x{30CD}\x{30FD}", "\x{30CD}\x{30CD}"));
ok($objJa->eq("\x{30CE}\x{30FD}", "\x{30CE}\x{30CE}"));
ok($objJa->eq("\x{30CF}\x{30FD}", "\x{30CF}\x{30CF}"));
ok($objJa->eq("\x{30D0}\x{30FD}", "\x{30D0}\x{30CF}"));
ok($objJa->eq("\x{30D1}\x{30FD}", "\x{30D1}\x{30CF}"));
ok($objJa->eq("\x{30D2}\x{30FD}", "\x{30D2}\x{30D2}"));
ok($objJa->eq("\x{30D3}\x{30FD}", "\x{30D3}\x{30D2}"));
ok($objJa->eq("\x{30D4}\x{30FD}", "\x{30D4}\x{30D2}"));
ok($objJa->eq("\x{30D5}\x{30FD}", "\x{30D5}\x{30D5}"));
ok($objJa->eq("\x{30D6}\x{30FD}", "\x{30D6}\x{30D5}"));
ok($objJa->eq("\x{30D7}\x{30FD}", "\x{30D7}\x{30D5}"));
ok($objJa->eq("\x{30D8}\x{30FD}", "\x{30D8}\x{30D8}"));
ok($objJa->eq("\x{30D9}\x{30FD}", "\x{30D9}\x{30D8}"));
ok($objJa->eq("\x{30DA}\x{30FD}", "\x{30DA}\x{30D8}"));
ok($objJa->eq("\x{30DB}\x{30FD}", "\x{30DB}\x{30DB}"));
ok($objJa->eq("\x{30DC}\x{30FD}", "\x{30DC}\x{30DB}"));
ok($objJa->eq("\x{30DD}\x{30FD}", "\x{30DD}\x{30DB}"));
ok($objJa->eq("\x{30DE}\x{30FD}", "\x{30DE}\x{30DE}"));
ok($objJa->eq("\x{30DF}\x{30FD}", "\x{30DF}\x{30DF}"));
ok($objJa->eq("\x{30E0}\x{30FD}", "\x{30E0}\x{30E0}"));
ok($objJa->eq("\x{30E1}\x{30FD}", "\x{30E1}\x{30E1}"));
ok($objJa->eq("\x{30E2}\x{30FD}", "\x{30E2}\x{30E2}"));
ok($objJa->eq("\x{30E3}\x{30FD}", "\x{30E3}\x{30E4}"));
ok($objJa->eq("\x{30E4}\x{30FD}", "\x{30E4}\x{30E4}"));
ok($objJa->eq("\x{30E5}\x{30FD}", "\x{30E5}\x{30E6}"));
ok($objJa->eq("\x{30E6}\x{30FD}", "\x{30E6}\x{30E6}"));
ok($objJa->eq("\x{30E7}\x{30FD}", "\x{30E7}\x{30E8}"));
ok($objJa->eq("\x{30E8}\x{30FD}", "\x{30E8}\x{30E8}"));
ok($objJa->eq("\x{30E9}\x{30FD}", "\x{30E9}\x{30E9}"));
ok($objJa->eq("\x{30EA}\x{30FD}", "\x{30EA}\x{30EA}"));
ok($objJa->eq("\x{30EB}\x{30FD}", "\x{30EB}\x{30EB}"));
ok($objJa->eq("\x{30EC}\x{30FD}", "\x{30EC}\x{30EC}"));
ok($objJa->eq("\x{30ED}\x{30FD}", "\x{30ED}\x{30ED}"));
ok($objJa->eq("\x{30EE}\x{30FD}", "\x{30EE}\x{30EF}"));
ok($objJa->eq("\x{30EF}\x{30FD}", "\x{30EF}\x{30EF}"));
ok($objJa->eq("\x{30F0}\x{30FD}", "\x{30F0}\x{30F0}"));
ok($objJa->eq("\x{30F1}\x{30FD}", "\x{30F1}\x{30F1}"));
ok($objJa->eq("\x{30F2}\x{30FD}", "\x{30F2}\x{30F2}"));
ok($objJa->eq("\x{30F3}\x{30FD}", "\x{30F3}\x{30F3}"));
ok($objJa->eq("\x{30F4}\x{30FD}", "\x{30F4}\x{30A6}"));
ok($objJa->eq("\x{30F5}\x{30FD}", "\x{30F5}\x{30AB}"));
ok($objJa->eq("\x{30F6}\x{30FD}", "\x{30F6}\x{30B1}"));
ok($objJa->eq("\x{30F7}\x{30FD}", "\x{30F7}\x{30EF}"));
ok($objJa->eq("\x{30F8}\x{30FD}", "\x{30F8}\x{30F0}"));
ok($objJa->eq("\x{30F9}\x{30FD}", "\x{30F9}\x{30F1}"));
ok($objJa->eq("\x{30FA}\x{30FD}", "\x{30FA}\x{30F2}"));
ok($objJa->eq("\x{31F0}\x{30FD}", "\x{31F0}\x{30AF}"));
ok($objJa->eq("\x{31F1}\x{30FD}", "\x{31F1}\x{30B7}"));
ok($objJa->eq("\x{31F2}\x{30FD}", "\x{31F2}\x{30B9}"));
ok($objJa->eq("\x{31F3}\x{30FD}", "\x{31F3}\x{30C8}"));
ok($objJa->eq("\x{31F4}\x{30FD}", "\x{31F4}\x{30CC}"));
ok($objJa->eq("\x{31F5}\x{30FD}", "\x{31F5}\x{30CF}"));
ok($objJa->eq("\x{31F6}\x{30FD}", "\x{31F6}\x{30D2}"));
ok($objJa->eq("\x{31F7}\x{30FD}", "\x{31F7}\x{30D5}"));
ok($objJa->eq("\x{31F8}\x{30FD}", "\x{31F8}\x{30D8}"));
ok($objJa->eq("\x{31F9}\x{30FD}", "\x{31F9}\x{30DB}"));
ok($objJa->eq("\x{31FA}\x{30FD}", "\x{31FA}\x{30E0}"));
ok($objJa->eq("\x{31FB}\x{30FD}", "\x{31FB}\x{30E9}"));
ok($objJa->eq("\x{31FC}\x{30FD}", "\x{31FC}\x{30EA}"));
ok($objJa->eq("\x{31FD}\x{30FD}", "\x{31FD}\x{30EB}"));
ok($objJa->eq("\x{31FE}\x{30FD}", "\x{31FE}\x{30EC}"));
ok($objJa->eq("\x{31FF}\x{30FD}", "\x{31FF}\x{30ED}"));

# 108

$objJa->change(level => 3);

ok($objJa->lt("\x{30A1}\x{30FD}", "\x{30A1}\x{30A2}"));
ok($objJa->lt("\x{30A2}\x{30FD}", "\x{30A2}\x{30A2}"));
ok($objJa->lt("\x{30A3}\x{30FD}", "\x{30A3}\x{30A4}"));
ok($objJa->lt("\x{30A4}\x{30FD}", "\x{30A4}\x{30A4}"));
ok($objJa->lt("\x{30A5}\x{30FD}", "\x{30A5}\x{30A6}"));
ok($objJa->lt("\x{30A6}\x{30FD}", "\x{30A6}\x{30A6}"));
ok($objJa->lt("\x{30A7}\x{30FD}", "\x{30A7}\x{30A8}"));
ok($objJa->lt("\x{30A8}\x{30FD}", "\x{30A8}\x{30A8}"));
ok($objJa->lt("\x{30A9}\x{30FD}", "\x{30A9}\x{30AA}"));
ok($objJa->lt("\x{30AA}\x{30FD}", "\x{30AA}\x{30AA}"));
ok($objJa->lt("\x{30AB}\x{30FD}", "\x{30AB}\x{30AB}"));
ok($objJa->lt("\x{30AC}\x{30FD}", "\x{30AC}\x{30AB}"));
ok($objJa->lt("\x{30AD}\x{30FD}", "\x{30AD}\x{30AD}"));
ok($objJa->lt("\x{30AE}\x{30FD}", "\x{30AE}\x{30AD}"));
ok($objJa->lt("\x{30AF}\x{30FD}", "\x{30AF}\x{30AF}"));
ok($objJa->lt("\x{30B0}\x{30FD}", "\x{30B0}\x{30AF}"));
ok($objJa->lt("\x{30B1}\x{30FD}", "\x{30B1}\x{30B1}"));
ok($objJa->lt("\x{30B2}\x{30FD}", "\x{30B2}\x{30B1}"));
ok($objJa->lt("\x{30B3}\x{30FD}", "\x{30B3}\x{30B3}"));
ok($objJa->lt("\x{30B4}\x{30FD}", "\x{30B4}\x{30B3}"));
ok($objJa->lt("\x{30B5}\x{30FD}", "\x{30B5}\x{30B5}"));
ok($objJa->lt("\x{30B6}\x{30FD}", "\x{30B6}\x{30B5}"));
ok($objJa->lt("\x{30B7}\x{30FD}", "\x{30B7}\x{30B7}"));
ok($objJa->lt("\x{30B8}\x{30FD}", "\x{30B8}\x{30B7}"));
ok($objJa->lt("\x{30B9}\x{30FD}", "\x{30B9}\x{30B9}"));
ok($objJa->lt("\x{30BA}\x{30FD}", "\x{30BA}\x{30B9}"));
ok($objJa->lt("\x{30BB}\x{30FD}", "\x{30BB}\x{30BB}"));
ok($objJa->lt("\x{30BC}\x{30FD}", "\x{30BC}\x{30BB}"));
ok($objJa->lt("\x{30BD}\x{30FD}", "\x{30BD}\x{30BD}"));
ok($objJa->lt("\x{30BE}\x{30FD}", "\x{30BE}\x{30BD}"));
ok($objJa->lt("\x{30BF}\x{30FD}", "\x{30BF}\x{30BF}"));
ok($objJa->lt("\x{30C0}\x{30FD}", "\x{30C0}\x{30BF}"));
ok($objJa->lt("\x{30C1}\x{30FD}", "\x{30C1}\x{30C1}"));
ok($objJa->lt("\x{30C2}\x{30FD}", "\x{30C2}\x{30C1}"));
ok($objJa->lt("\x{30C3}\x{30FD}", "\x{30C3}\x{30C4}"));
ok($objJa->lt("\x{30C4}\x{30FD}", "\x{30C4}\x{30C4}"));
ok($objJa->lt("\x{30C5}\x{30FD}", "\x{30C5}\x{30C4}"));
ok($objJa->lt("\x{30C6}\x{30FD}", "\x{30C6}\x{30C6}"));
ok($objJa->lt("\x{30C7}\x{30FD}", "\x{30C7}\x{30C6}"));
ok($objJa->lt("\x{30C8}\x{30FD}", "\x{30C8}\x{30C8}"));
ok($objJa->lt("\x{30C9}\x{30FD}", "\x{30C9}\x{30C8}"));
ok($objJa->lt("\x{30CA}\x{30FD}", "\x{30CA}\x{30CA}"));
ok($objJa->lt("\x{30CB}\x{30FD}", "\x{30CB}\x{30CB}"));
ok($objJa->lt("\x{30CC}\x{30FD}", "\x{30CC}\x{30CC}"));
ok($objJa->lt("\x{30CD}\x{30FD}", "\x{30CD}\x{30CD}"));
ok($objJa->lt("\x{30CE}\x{30FD}", "\x{30CE}\x{30CE}"));
ok($objJa->lt("\x{30CF}\x{30FD}", "\x{30CF}\x{30CF}"));
ok($objJa->lt("\x{30D0}\x{30FD}", "\x{30D0}\x{30CF}"));
ok($objJa->lt("\x{30D1}\x{30FD}", "\x{30D1}\x{30CF}"));
ok($objJa->lt("\x{30D2}\x{30FD}", "\x{30D2}\x{30D2}"));
ok($objJa->lt("\x{30D3}\x{30FD}", "\x{30D3}\x{30D2}"));
ok($objJa->lt("\x{30D4}\x{30FD}", "\x{30D4}\x{30D2}"));
ok($objJa->lt("\x{30D5}\x{30FD}", "\x{30D5}\x{30D5}"));
ok($objJa->lt("\x{30D6}\x{30FD}", "\x{30D6}\x{30D5}"));
ok($objJa->lt("\x{30D7}\x{30FD}", "\x{30D7}\x{30D5}"));
ok($objJa->lt("\x{30D8}\x{30FD}", "\x{30D8}\x{30D8}"));
ok($objJa->lt("\x{30D9}\x{30FD}", "\x{30D9}\x{30D8}"));
ok($objJa->lt("\x{30DA}\x{30FD}", "\x{30DA}\x{30D8}"));
ok($objJa->lt("\x{30DB}\x{30FD}", "\x{30DB}\x{30DB}"));
ok($objJa->lt("\x{30DC}\x{30FD}", "\x{30DC}\x{30DB}"));
ok($objJa->lt("\x{30DD}\x{30FD}", "\x{30DD}\x{30DB}"));
ok($objJa->lt("\x{30DE}\x{30FD}", "\x{30DE}\x{30DE}"));
ok($objJa->lt("\x{30DF}\x{30FD}", "\x{30DF}\x{30DF}"));
ok($objJa->lt("\x{30E0}\x{30FD}", "\x{30E0}\x{30E0}"));
ok($objJa->lt("\x{30E1}\x{30FD}", "\x{30E1}\x{30E1}"));
ok($objJa->lt("\x{30E2}\x{30FD}", "\x{30E2}\x{30E2}"));
ok($objJa->lt("\x{30E3}\x{30FD}", "\x{30E3}\x{30E4}"));
ok($objJa->lt("\x{30E4}\x{30FD}", "\x{30E4}\x{30E4}"));
ok($objJa->lt("\x{30E5}\x{30FD}", "\x{30E5}\x{30E6}"));
ok($objJa->lt("\x{30E6}\x{30FD}", "\x{30E6}\x{30E6}"));
ok($objJa->lt("\x{30E7}\x{30FD}", "\x{30E7}\x{30E8}"));
ok($objJa->lt("\x{30E8}\x{30FD}", "\x{30E8}\x{30E8}"));
ok($objJa->lt("\x{30E9}\x{30FD}", "\x{30E9}\x{30E9}"));
ok($objJa->lt("\x{30EA}\x{30FD}", "\x{30EA}\x{30EA}"));
ok($objJa->lt("\x{30EB}\x{30FD}", "\x{30EB}\x{30EB}"));
ok($objJa->lt("\x{30EC}\x{30FD}", "\x{30EC}\x{30EC}"));
ok($objJa->lt("\x{30ED}\x{30FD}", "\x{30ED}\x{30ED}"));
ok($objJa->lt("\x{30EE}\x{30FD}", "\x{30EE}\x{30EF}"));
ok($objJa->lt("\x{30EF}\x{30FD}", "\x{30EF}\x{30EF}"));
ok($objJa->lt("\x{30F0}\x{30FD}", "\x{30F0}\x{30F0}"));
ok($objJa->lt("\x{30F1}\x{30FD}", "\x{30F1}\x{30F1}"));
ok($objJa->lt("\x{30F2}\x{30FD}", "\x{30F2}\x{30F2}"));
ok($objJa->lt("\x{30F3}\x{30FD}", "\x{30F3}\x{30F3}"));
ok($objJa->lt("\x{30F4}\x{30FD}", "\x{30F4}\x{30A6}"));
ok($objJa->lt("\x{30F5}\x{30FD}", "\x{30F5}\x{30AB}"));
ok($objJa->lt("\x{30F6}\x{30FD}", "\x{30F6}\x{30B1}"));
ok($objJa->lt("\x{30F7}\x{30FD}", "\x{30F7}\x{30EF}"));
ok($objJa->lt("\x{30F8}\x{30FD}", "\x{30F8}\x{30F0}"));
ok($objJa->lt("\x{30F9}\x{30FD}", "\x{30F9}\x{30F1}"));
ok($objJa->lt("\x{30FA}\x{30FD}", "\x{30FA}\x{30F2}"));
ok($objJa->lt("\x{31F0}\x{30FD}", "\x{31F0}\x{30AF}"));
ok($objJa->lt("\x{31F1}\x{30FD}", "\x{31F1}\x{30B7}"));
ok($objJa->lt("\x{31F2}\x{30FD}", "\x{31F2}\x{30B9}"));
ok($objJa->lt("\x{31F3}\x{30FD}", "\x{31F3}\x{30C8}"));
ok($objJa->lt("\x{31F4}\x{30FD}", "\x{31F4}\x{30CC}"));
ok($objJa->lt("\x{31F5}\x{30FD}", "\x{31F5}\x{30CF}"));
ok($objJa->lt("\x{31F6}\x{30FD}", "\x{31F6}\x{30D2}"));
ok($objJa->lt("\x{31F7}\x{30FD}", "\x{31F7}\x{30D5}"));
ok($objJa->lt("\x{31F8}\x{30FD}", "\x{31F8}\x{30D8}"));
ok($objJa->lt("\x{31F9}\x{30FD}", "\x{31F9}\x{30DB}"));
ok($objJa->lt("\x{31FA}\x{30FD}", "\x{31FA}\x{30E0}"));
ok($objJa->lt("\x{31FB}\x{30FD}", "\x{31FB}\x{30E9}"));
ok($objJa->lt("\x{31FC}\x{30FD}", "\x{31FC}\x{30EA}"));
ok($objJa->lt("\x{31FD}\x{30FD}", "\x{31FD}\x{30EB}"));
ok($objJa->lt("\x{31FE}\x{30FD}", "\x{31FE}\x{30EC}"));
ok($objJa->lt("\x{31FF}\x{30FD}", "\x{31FF}\x{30ED}"));

# 214

ok($objJa->eq("\x{3041}\x{309D}", "\x{30A1}\x{30FD}"));
ok($objJa->eq("\x{3042}\x{309D}", "\x{30A2}\x{30FD}"));
ok($objJa->eq("\x{3043}\x{309D}", "\x{30A3}\x{30FD}"));
ok($objJa->eq("\x{3044}\x{309D}", "\x{30A4}\x{30FD}"));
ok($objJa->eq("\x{3045}\x{309D}", "\x{30A5}\x{30FD}"));
ok($objJa->eq("\x{3046}\x{309D}", "\x{30A6}\x{30FD}"));
ok($objJa->eq("\x{3047}\x{309D}", "\x{30A7}\x{30FD}"));
ok($objJa->eq("\x{3048}\x{309D}", "\x{30A8}\x{30FD}"));
ok($objJa->eq("\x{3049}\x{309D}", "\x{30A9}\x{30FD}"));
ok($objJa->eq("\x{304A}\x{309D}", "\x{30AA}\x{30FD}"));
ok($objJa->eq("\x{304B}\x{309D}", "\x{30AB}\x{30FD}"));
ok($objJa->eq("\x{304C}\x{309D}", "\x{30AC}\x{30FD}"));
ok($objJa->eq("\x{304D}\x{309D}", "\x{30AD}\x{30FD}"));
ok($objJa->eq("\x{304E}\x{309D}", "\x{30AE}\x{30FD}"));
ok($objJa->eq("\x{304F}\x{309D}", "\x{30AF}\x{30FD}"));
ok($objJa->eq("\x{3050}\x{309D}", "\x{30B0}\x{30FD}"));
ok($objJa->eq("\x{3051}\x{309D}", "\x{30B1}\x{30FD}"));
ok($objJa->eq("\x{3052}\x{309D}", "\x{30B2}\x{30FD}"));
ok($objJa->eq("\x{3053}\x{309D}", "\x{30B3}\x{30FD}"));
ok($objJa->eq("\x{3054}\x{309D}", "\x{30B4}\x{30FD}"));
ok($objJa->eq("\x{3055}\x{309D}", "\x{30B5}\x{30FD}"));
ok($objJa->eq("\x{3056}\x{309D}", "\x{30B6}\x{30FD}"));
ok($objJa->eq("\x{3057}\x{309D}", "\x{30B7}\x{30FD}"));
ok($objJa->eq("\x{3058}\x{309D}", "\x{30B8}\x{30FD}"));
ok($objJa->eq("\x{3059}\x{309D}", "\x{30B9}\x{30FD}"));
ok($objJa->eq("\x{305A}\x{309D}", "\x{30BA}\x{30FD}"));
ok($objJa->eq("\x{305B}\x{309D}", "\x{30BB}\x{30FD}"));
ok($objJa->eq("\x{305C}\x{309D}", "\x{30BC}\x{30FD}"));
ok($objJa->eq("\x{305D}\x{309D}", "\x{30BD}\x{30FD}"));
ok($objJa->eq("\x{305E}\x{309D}", "\x{30BE}\x{30FD}"));
ok($objJa->eq("\x{305F}\x{309D}", "\x{30BF}\x{30FD}"));
ok($objJa->eq("\x{3060}\x{309D}", "\x{30C0}\x{30FD}"));
ok($objJa->eq("\x{3061}\x{309D}", "\x{30C1}\x{30FD}"));
ok($objJa->eq("\x{3062}\x{309D}", "\x{30C2}\x{30FD}"));
ok($objJa->eq("\x{3063}\x{309D}", "\x{30C3}\x{30FD}"));
ok($objJa->eq("\x{3064}\x{309D}", "\x{30C4}\x{30FD}"));
ok($objJa->eq("\x{3065}\x{309D}", "\x{30C5}\x{30FD}"));
ok($objJa->eq("\x{3066}\x{309D}", "\x{30C6}\x{30FD}"));
ok($objJa->eq("\x{3067}\x{309D}", "\x{30C7}\x{30FD}"));
ok($objJa->eq("\x{3068}\x{309D}", "\x{30C8}\x{30FD}"));
ok($objJa->eq("\x{3069}\x{309D}", "\x{30C9}\x{30FD}"));
ok($objJa->eq("\x{306A}\x{309D}", "\x{30CA}\x{30FD}"));
ok($objJa->eq("\x{306B}\x{309D}", "\x{30CB}\x{30FD}"));
ok($objJa->eq("\x{306C}\x{309D}", "\x{30CC}\x{30FD}"));
ok($objJa->eq("\x{306D}\x{309D}", "\x{30CD}\x{30FD}"));
ok($objJa->eq("\x{306E}\x{309D}", "\x{30CE}\x{30FD}"));
ok($objJa->eq("\x{306F}\x{309D}", "\x{30CF}\x{30FD}"));
ok($objJa->eq("\x{3070}\x{309D}", "\x{30D0}\x{30FD}"));
ok($objJa->eq("\x{3071}\x{309D}", "\x{30D1}\x{30FD}"));
ok($objJa->eq("\x{3072}\x{309D}", "\x{30D2}\x{30FD}"));
ok($objJa->eq("\x{3073}\x{309D}", "\x{30D3}\x{30FD}"));
ok($objJa->eq("\x{3074}\x{309D}", "\x{30D4}\x{30FD}"));
ok($objJa->eq("\x{3075}\x{309D}", "\x{30D5}\x{30FD}"));
ok($objJa->eq("\x{3076}\x{309D}", "\x{30D6}\x{30FD}"));
ok($objJa->eq("\x{3077}\x{309D}", "\x{30D7}\x{30FD}"));
ok($objJa->eq("\x{3078}\x{309D}", "\x{30D8}\x{30FD}"));
ok($objJa->eq("\x{3079}\x{309D}", "\x{30D9}\x{30FD}"));
ok($objJa->eq("\x{307A}\x{309D}", "\x{30DA}\x{30FD}"));
ok($objJa->eq("\x{307B}\x{309D}", "\x{30DB}\x{30FD}"));
ok($objJa->eq("\x{307C}\x{309D}", "\x{30DC}\x{30FD}"));
ok($objJa->eq("\x{307D}\x{309D}", "\x{30DD}\x{30FD}"));
ok($objJa->eq("\x{307E}\x{309D}", "\x{30DE}\x{30FD}"));
ok($objJa->eq("\x{307F}\x{309D}", "\x{30DF}\x{30FD}"));
ok($objJa->eq("\x{3080}\x{309D}", "\x{30E0}\x{30FD}"));
ok($objJa->eq("\x{3081}\x{309D}", "\x{30E1}\x{30FD}"));
ok($objJa->eq("\x{3082}\x{309D}", "\x{30E2}\x{30FD}"));
ok($objJa->eq("\x{3083}\x{309D}", "\x{30E3}\x{30FD}"));
ok($objJa->eq("\x{3084}\x{309D}", "\x{30E4}\x{30FD}"));
ok($objJa->eq("\x{3085}\x{309D}", "\x{30E5}\x{30FD}"));
ok($objJa->eq("\x{3086}\x{309D}", "\x{30E6}\x{30FD}"));
ok($objJa->eq("\x{3087}\x{309D}", "\x{30E7}\x{30FD}"));
ok($objJa->eq("\x{3088}\x{309D}", "\x{30E8}\x{30FD}"));
ok($objJa->eq("\x{3089}\x{309D}", "\x{30E9}\x{30FD}"));
ok($objJa->eq("\x{308A}\x{309D}", "\x{30EA}\x{30FD}"));
ok($objJa->eq("\x{308B}\x{309D}", "\x{30EB}\x{30FD}"));
ok($objJa->eq("\x{308C}\x{309D}", "\x{30EC}\x{30FD}"));
ok($objJa->eq("\x{308D}\x{309D}", "\x{30ED}\x{30FD}"));
ok($objJa->eq("\x{308E}\x{309D}", "\x{30EE}\x{30FD}"));
ok($objJa->eq("\x{308F}\x{309D}", "\x{30EF}\x{30FD}"));
ok($objJa->eq("\x{3090}\x{309D}", "\x{30F0}\x{30FD}"));
ok($objJa->eq("\x{3091}\x{309D}", "\x{30F1}\x{30FD}"));
ok($objJa->eq("\x{3092}\x{309D}", "\x{30F2}\x{30FD}"));
ok($objJa->eq("\x{3093}\x{309D}", "\x{30F3}\x{30FD}"));
ok($objJa->eq("\x{3094}\x{309D}", "\x{30F4}\x{30FD}"));
ok($objJa->eq("\x{3095}\x{309D}", "\x{30F5}\x{30FD}"));
ok($objJa->eq("\x{3096}\x{309D}", "\x{30F6}\x{30FD}"));

# 300

$objJa->change(level => 4);

$objJa->change(variable => 'Non-ignorable');

ok($objJa->lt("\x{3041}\x{309D}", "\x{30A1}\x{30FD}"));
ok($objJa->lt("\x{3042}\x{309D}", "\x{30A2}\x{30FD}"));
ok($objJa->lt("\x{3043}\x{309D}", "\x{30A3}\x{30FD}"));
ok($objJa->lt("\x{3044}\x{309D}", "\x{30A4}\x{30FD}"));
ok($objJa->lt("\x{3045}\x{309D}", "\x{30A5}\x{30FD}"));
ok($objJa->lt("\x{3046}\x{309D}", "\x{30A6}\x{30FD}"));
ok($objJa->lt("\x{3047}\x{309D}", "\x{30A7}\x{30FD}"));
ok($objJa->lt("\x{3048}\x{309D}", "\x{30A8}\x{30FD}"));
ok($objJa->lt("\x{3049}\x{309D}", "\x{30A9}\x{30FD}"));
ok($objJa->lt("\x{304A}\x{309D}", "\x{30AA}\x{30FD}"));
ok($objJa->lt("\x{304B}\x{309D}", "\x{30AB}\x{30FD}"));
ok($objJa->lt("\x{304C}\x{309D}", "\x{30AC}\x{30FD}"));
ok($objJa->lt("\x{304D}\x{309D}", "\x{30AD}\x{30FD}"));
ok($objJa->lt("\x{304E}\x{309D}", "\x{30AE}\x{30FD}"));
ok($objJa->lt("\x{304F}\x{309D}", "\x{30AF}\x{30FD}"));
ok($objJa->lt("\x{3050}\x{309D}", "\x{30B0}\x{30FD}"));
ok($objJa->lt("\x{3051}\x{309D}", "\x{30B1}\x{30FD}"));
ok($objJa->lt("\x{3052}\x{309D}", "\x{30B2}\x{30FD}"));
ok($objJa->lt("\x{3053}\x{309D}", "\x{30B3}\x{30FD}"));
ok($objJa->lt("\x{3054}\x{309D}", "\x{30B4}\x{30FD}"));
ok($objJa->lt("\x{3055}\x{309D}", "\x{30B5}\x{30FD}"));
ok($objJa->lt("\x{3056}\x{309D}", "\x{30B6}\x{30FD}"));
ok($objJa->lt("\x{3057}\x{309D}", "\x{30B7}\x{30FD}"));
ok($objJa->lt("\x{3058}\x{309D}", "\x{30B8}\x{30FD}"));
ok($objJa->lt("\x{3059}\x{309D}", "\x{30B9}\x{30FD}"));
ok($objJa->lt("\x{305A}\x{309D}", "\x{30BA}\x{30FD}"));
ok($objJa->lt("\x{305B}\x{309D}", "\x{30BB}\x{30FD}"));
ok($objJa->lt("\x{305C}\x{309D}", "\x{30BC}\x{30FD}"));
ok($objJa->lt("\x{305D}\x{309D}", "\x{30BD}\x{30FD}"));
ok($objJa->lt("\x{305E}\x{309D}", "\x{30BE}\x{30FD}"));
ok($objJa->lt("\x{305F}\x{309D}", "\x{30BF}\x{30FD}"));
ok($objJa->lt("\x{3060}\x{309D}", "\x{30C0}\x{30FD}"));
ok($objJa->lt("\x{3061}\x{309D}", "\x{30C1}\x{30FD}"));
ok($objJa->lt("\x{3062}\x{309D}", "\x{30C2}\x{30FD}"));
ok($objJa->lt("\x{3063}\x{309D}", "\x{30C3}\x{30FD}"));
ok($objJa->lt("\x{3064}\x{309D}", "\x{30C4}\x{30FD}"));
ok($objJa->lt("\x{3065}\x{309D}", "\x{30C5}\x{30FD}"));
ok($objJa->lt("\x{3066}\x{309D}", "\x{30C6}\x{30FD}"));
ok($objJa->lt("\x{3067}\x{309D}", "\x{30C7}\x{30FD}"));
ok($objJa->lt("\x{3068}\x{309D}", "\x{30C8}\x{30FD}"));
ok($objJa->lt("\x{3069}\x{309D}", "\x{30C9}\x{30FD}"));
ok($objJa->lt("\x{306A}\x{309D}", "\x{30CA}\x{30FD}"));
ok($objJa->lt("\x{306B}\x{309D}", "\x{30CB}\x{30FD}"));
ok($objJa->lt("\x{306C}\x{309D}", "\x{30CC}\x{30FD}"));
ok($objJa->lt("\x{306D}\x{309D}", "\x{30CD}\x{30FD}"));
ok($objJa->lt("\x{306E}\x{309D}", "\x{30CE}\x{30FD}"));
ok($objJa->lt("\x{306F}\x{309D}", "\x{30CF}\x{30FD}"));
ok($objJa->lt("\x{3070}\x{309D}", "\x{30D0}\x{30FD}"));
ok($objJa->lt("\x{3071}\x{309D}", "\x{30D1}\x{30FD}"));
ok($objJa->lt("\x{3072}\x{309D}", "\x{30D2}\x{30FD}"));
ok($objJa->lt("\x{3073}\x{309D}", "\x{30D3}\x{30FD}"));
ok($objJa->lt("\x{3074}\x{309D}", "\x{30D4}\x{30FD}"));
ok($objJa->lt("\x{3075}\x{309D}", "\x{30D5}\x{30FD}"));
ok($objJa->lt("\x{3076}\x{309D}", "\x{30D6}\x{30FD}"));
ok($objJa->lt("\x{3077}\x{309D}", "\x{30D7}\x{30FD}"));
ok($objJa->lt("\x{3078}\x{309D}", "\x{30D8}\x{30FD}"));
ok($objJa->lt("\x{3079}\x{309D}", "\x{30D9}\x{30FD}"));
ok($objJa->lt("\x{307A}\x{309D}", "\x{30DA}\x{30FD}"));
ok($objJa->lt("\x{307B}\x{309D}", "\x{30DB}\x{30FD}"));
ok($objJa->lt("\x{307C}\x{309D}", "\x{30DC}\x{30FD}"));
ok($objJa->lt("\x{307D}\x{309D}", "\x{30DD}\x{30FD}"));
ok($objJa->lt("\x{307E}\x{309D}", "\x{30DE}\x{30FD}"));
ok($objJa->lt("\x{307F}\x{309D}", "\x{30DF}\x{30FD}"));
ok($objJa->lt("\x{3080}\x{309D}", "\x{30E0}\x{30FD}"));
ok($objJa->lt("\x{3081}\x{309D}", "\x{30E1}\x{30FD}"));
ok($objJa->lt("\x{3082}\x{309D}", "\x{30E2}\x{30FD}"));
ok($objJa->lt("\x{3083}\x{309D}", "\x{30E3}\x{30FD}"));
ok($objJa->lt("\x{3084}\x{309D}", "\x{30E4}\x{30FD}"));
ok($objJa->lt("\x{3085}\x{309D}", "\x{30E5}\x{30FD}"));
ok($objJa->lt("\x{3086}\x{309D}", "\x{30E6}\x{30FD}"));
ok($objJa->lt("\x{3087}\x{309D}", "\x{30E7}\x{30FD}"));
ok($objJa->lt("\x{3088}\x{309D}", "\x{30E8}\x{30FD}"));
ok($objJa->lt("\x{3089}\x{309D}", "\x{30E9}\x{30FD}"));
ok($objJa->lt("\x{308A}\x{309D}", "\x{30EA}\x{30FD}"));
ok($objJa->lt("\x{308B}\x{309D}", "\x{30EB}\x{30FD}"));
ok($objJa->lt("\x{308C}\x{309D}", "\x{30EC}\x{30FD}"));
ok($objJa->lt("\x{308D}\x{309D}", "\x{30ED}\x{30FD}"));
ok($objJa->lt("\x{308E}\x{309D}", "\x{30EE}\x{30FD}"));
ok($objJa->lt("\x{308F}\x{309D}", "\x{30EF}\x{30FD}"));
ok($objJa->lt("\x{3090}\x{309D}", "\x{30F0}\x{30FD}"));
ok($objJa->lt("\x{3091}\x{309D}", "\x{30F1}\x{30FD}"));
ok($objJa->lt("\x{3092}\x{309D}", "\x{30F2}\x{30FD}"));
ok($objJa->lt("\x{3093}\x{309D}", "\x{30F3}\x{30FD}"));
ok($objJa->lt("\x{3094}\x{309D}", "\x{30F4}\x{30FD}"));
ok($objJa->lt("\x{3095}\x{309D}", "\x{30F5}\x{30FD}"));
ok($objJa->lt("\x{3096}\x{309D}", "\x{30F6}\x{30FD}"));

# 386

my $vs = "\x{3099}";

ok($objJa->eq("\x{30A1}\x{30FD}", "\x{FF67}\x{30FD}"));
ok($objJa->eq("\x{30A2}\x{30FD}", "\x{FF71}\x{30FD}"));
ok($objJa->eq("\x{30A3}\x{30FD}", "\x{FF68}\x{30FD}"));
ok($objJa->eq("\x{30A4}\x{30FD}", "\x{FF72}\x{30FD}"));
ok($objJa->eq("\x{30A5}\x{30FD}", "\x{FF69}\x{30FD}"));
ok($objJa->eq("\x{30A5}\x{30FE}", "\x{30A5}\x{30FD}".$vs));
ok($objJa->eq("\x{FF69}\x{30FE}", "\x{FF69}\x{30FD}".$vs));
ok($objJa->eq("\x{3045}\x{309E}", "\x{3045}\x{309D}".$vs));
ok($objJa->eq("\x{30A6}\x{30FD}", "\x{FF73}\x{30FD}"));
ok($objJa->eq("\x{30A6}\x{30FE}", "\x{30A6}\x{30FD}".$vs));
ok($objJa->eq("\x{FF73}\x{30FE}", "\x{FF73}\x{30FD}".$vs));
ok($objJa->eq("\x{3046}\x{309E}", "\x{3046}\x{309D}".$vs));
ok($objJa->eq("\x{30A7}\x{30FD}", "\x{FF6A}\x{30FD}"));
ok($objJa->eq("\x{30A8}\x{30FD}", "\x{FF74}\x{30FD}"));
ok($objJa->eq("\x{30A9}\x{30FD}", "\x{FF6B}\x{30FD}"));
ok($objJa->eq("\x{30AA}\x{30FD}", "\x{FF75}\x{30FD}"));
ok($objJa->eq("\x{30AB}\x{30FD}", "\x{FF76}\x{30FD}"));
ok($objJa->eq("\x{30AB}\x{30FE}", "\x{30AB}\x{30FD}".$vs));
ok($objJa->eq("\x{FF76}\x{30FE}", "\x{FF76}\x{30FD}".$vs));
ok($objJa->eq("\x{304B}\x{309E}", "\x{304B}\x{309D}".$vs));
ok($objJa->eq("\x{30AC}\x{30FD}", "\x{30AB}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30AC}\x{30FD}", "\x{FF76}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{304C}\x{309D}", "\x{304B}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30AC}\x{30FE}", "\x{30AC}\x{30FD}".$vs));
ok($objJa->eq("\x{30AB}\x{3099}\x{30FE}", "\x{30AB}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF76}\x{FF9E}\x{30FE}", "\x{FF76}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{304C}\x{309E}", "\x{304C}\x{309D}".$vs));
ok($objJa->eq("\x{304B}\x{3099}\x{309E}", "\x{304B}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30AD}\x{30FD}", "\x{FF77}\x{30FD}"));
ok($objJa->eq("\x{30AD}\x{30FE}", "\x{30AD}\x{30FD}".$vs));
ok($objJa->eq("\x{FF77}\x{30FE}", "\x{FF77}\x{30FD}".$vs));
ok($objJa->eq("\x{304D}\x{309E}", "\x{304D}\x{309D}".$vs));
ok($objJa->eq("\x{30AE}\x{30FD}", "\x{30AD}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30AE}\x{30FD}", "\x{FF77}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{304E}\x{309D}", "\x{304D}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30AE}\x{30FE}", "\x{30AE}\x{30FD}".$vs));
ok($objJa->eq("\x{30AD}\x{3099}\x{30FE}", "\x{30AD}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF77}\x{FF9E}\x{30FE}", "\x{FF77}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{304E}\x{309E}", "\x{304E}\x{309D}".$vs));
ok($objJa->eq("\x{304D}\x{3099}\x{309E}", "\x{304D}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30AF}\x{30FD}", "\x{FF78}\x{30FD}"));
ok($objJa->eq("\x{30AF}\x{30FE}", "\x{30AF}\x{30FD}".$vs));
ok($objJa->eq("\x{FF78}\x{30FE}", "\x{FF78}\x{30FD}".$vs));
ok($objJa->eq("\x{304F}\x{309E}", "\x{304F}\x{309D}".$vs));
ok($objJa->eq("\x{30B0}\x{30FD}", "\x{30AF}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30B0}\x{30FD}", "\x{FF78}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3050}\x{309D}", "\x{304F}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30B0}\x{30FE}", "\x{30B0}\x{30FD}".$vs));
ok($objJa->eq("\x{30AF}\x{3099}\x{30FE}", "\x{30AF}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF78}\x{FF9E}\x{30FE}", "\x{FF78}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3050}\x{309E}", "\x{3050}\x{309D}".$vs));
ok($objJa->eq("\x{304F}\x{3099}\x{309E}", "\x{304F}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30B1}\x{30FD}", "\x{FF79}\x{30FD}"));
ok($objJa->eq("\x{30B1}\x{30FE}", "\x{30B1}\x{30FD}".$vs));
ok($objJa->eq("\x{FF79}\x{30FE}", "\x{FF79}\x{30FD}".$vs));
ok($objJa->eq("\x{3051}\x{309E}", "\x{3051}\x{309D}".$vs));
ok($objJa->eq("\x{30B2}\x{30FD}", "\x{30B1}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30B2}\x{30FD}", "\x{FF79}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3052}\x{309D}", "\x{3051}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30B2}\x{30FE}", "\x{30B2}\x{30FD}".$vs));
ok($objJa->eq("\x{30B1}\x{3099}\x{30FE}", "\x{30B1}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF79}\x{FF9E}\x{30FE}", "\x{FF79}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3052}\x{309E}", "\x{3052}\x{309D}".$vs));
ok($objJa->eq("\x{3051}\x{3099}\x{309E}", "\x{3051}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30B3}\x{30FD}", "\x{FF7A}\x{30FD}"));
ok($objJa->eq("\x{30B3}\x{30FE}", "\x{30B3}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7A}\x{30FE}", "\x{FF7A}\x{30FD}".$vs));
ok($objJa->eq("\x{3053}\x{309E}", "\x{3053}\x{309D}".$vs));
ok($objJa->eq("\x{30B4}\x{30FD}", "\x{30B3}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30B4}\x{30FD}", "\x{FF7A}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3054}\x{309D}", "\x{3053}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30B4}\x{30FE}", "\x{30B4}\x{30FD}".$vs));
ok($objJa->eq("\x{30B3}\x{3099}\x{30FE}", "\x{30B3}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7A}\x{FF9E}\x{30FE}", "\x{FF7A}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3054}\x{309E}", "\x{3054}\x{309D}".$vs));
ok($objJa->eq("\x{3053}\x{3099}\x{309E}", "\x{3053}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30B5}\x{30FD}", "\x{FF7B}\x{30FD}"));
ok($objJa->eq("\x{30B5}\x{30FE}", "\x{30B5}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7B}\x{30FE}", "\x{FF7B}\x{30FD}".$vs));
ok($objJa->eq("\x{3055}\x{309E}", "\x{3055}\x{309D}".$vs));
ok($objJa->eq("\x{30B6}\x{30FD}", "\x{30B5}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30B6}\x{30FD}", "\x{FF7B}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3056}\x{309D}", "\x{3055}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30B6}\x{30FE}", "\x{30B6}\x{30FD}".$vs));
ok($objJa->eq("\x{30B5}\x{3099}\x{30FE}", "\x{30B5}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7B}\x{FF9E}\x{30FE}", "\x{FF7B}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3056}\x{309E}", "\x{3056}\x{309D}".$vs));
ok($objJa->eq("\x{3055}\x{3099}\x{309E}", "\x{3055}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30B7}\x{30FD}", "\x{FF7C}\x{30FD}"));
ok($objJa->eq("\x{30B7}\x{30FE}", "\x{30B7}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7C}\x{30FE}", "\x{FF7C}\x{30FD}".$vs));
ok($objJa->eq("\x{3057}\x{309E}", "\x{3057}\x{309D}".$vs));
ok($objJa->eq("\x{30B8}\x{30FD}", "\x{30B7}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30B8}\x{30FD}", "\x{FF7C}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3058}\x{309D}", "\x{3057}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30B8}\x{30FE}", "\x{30B8}\x{30FD}".$vs));
ok($objJa->eq("\x{30B7}\x{3099}\x{30FE}", "\x{30B7}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7C}\x{FF9E}\x{30FE}", "\x{FF7C}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3058}\x{309E}", "\x{3058}\x{309D}".$vs));
ok($objJa->eq("\x{3057}\x{3099}\x{309E}", "\x{3057}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30B9}\x{30FD}", "\x{FF7D}\x{30FD}"));
ok($objJa->eq("\x{30B9}\x{30FE}", "\x{30B9}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7D}\x{30FE}", "\x{FF7D}\x{30FD}".$vs));
ok($objJa->eq("\x{3059}\x{309E}", "\x{3059}\x{309D}".$vs));
ok($objJa->eq("\x{30BA}\x{30FD}", "\x{30B9}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30BA}\x{30FD}", "\x{FF7D}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{305A}\x{309D}", "\x{3059}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30BA}\x{30FE}", "\x{30BA}\x{30FD}".$vs));
ok($objJa->eq("\x{30B9}\x{3099}\x{30FE}", "\x{30B9}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7D}\x{FF9E}\x{30FE}", "\x{FF7D}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{305A}\x{309E}", "\x{305A}\x{309D}".$vs));
ok($objJa->eq("\x{3059}\x{3099}\x{309E}", "\x{3059}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30BB}\x{30FD}", "\x{FF7E}\x{30FD}"));
ok($objJa->eq("\x{30BB}\x{30FE}", "\x{30BB}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7E}\x{30FE}", "\x{FF7E}\x{30FD}".$vs));
ok($objJa->eq("\x{305B}\x{309E}", "\x{305B}\x{309D}".$vs));
ok($objJa->eq("\x{30BC}\x{30FD}", "\x{30BB}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30BC}\x{30FD}", "\x{FF7E}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{305C}\x{309D}", "\x{305B}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30BC}\x{30FE}", "\x{30BC}\x{30FD}".$vs));
ok($objJa->eq("\x{30BB}\x{3099}\x{30FE}", "\x{30BB}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7E}\x{FF9E}\x{30FE}", "\x{FF7E}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{305C}\x{309E}", "\x{305C}\x{309D}".$vs));
ok($objJa->eq("\x{305B}\x{3099}\x{309E}", "\x{305B}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30BD}\x{30FD}", "\x{FF7F}\x{30FD}"));
ok($objJa->eq("\x{30BD}\x{30FE}", "\x{30BD}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7F}\x{30FE}", "\x{FF7F}\x{30FD}".$vs));
ok($objJa->eq("\x{305D}\x{309E}", "\x{305D}\x{309D}".$vs));
ok($objJa->eq("\x{30BE}\x{30FD}", "\x{30BD}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30BE}\x{30FD}", "\x{FF7F}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{305E}\x{309D}", "\x{305D}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30BE}\x{30FE}", "\x{30BE}\x{30FD}".$vs));
ok($objJa->eq("\x{30BD}\x{3099}\x{30FE}", "\x{30BD}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF7F}\x{FF9E}\x{30FE}", "\x{FF7F}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{305E}\x{309E}", "\x{305E}\x{309D}".$vs));
ok($objJa->eq("\x{305D}\x{3099}\x{309E}", "\x{305D}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30BF}\x{30FD}", "\x{FF80}\x{30FD}"));
ok($objJa->eq("\x{30BF}\x{30FE}", "\x{30BF}\x{30FD}".$vs));
ok($objJa->eq("\x{FF80}\x{30FE}", "\x{FF80}\x{30FD}".$vs));
ok($objJa->eq("\x{305F}\x{309E}", "\x{305F}\x{309D}".$vs));
ok($objJa->eq("\x{30C0}\x{30FD}", "\x{30BF}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30C0}\x{30FD}", "\x{FF80}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3060}\x{309D}", "\x{305F}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30C0}\x{30FE}", "\x{30C0}\x{30FD}".$vs));
ok($objJa->eq("\x{30BF}\x{3099}\x{30FE}", "\x{30BF}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF80}\x{FF9E}\x{30FE}", "\x{FF80}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3060}\x{309E}", "\x{3060}\x{309D}".$vs));
ok($objJa->eq("\x{305F}\x{3099}\x{309E}", "\x{305F}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30C1}\x{30FD}", "\x{FF81}\x{30FD}"));
ok($objJa->eq("\x{30C1}\x{30FE}", "\x{30C1}\x{30FD}".$vs));
ok($objJa->eq("\x{FF81}\x{30FE}", "\x{FF81}\x{30FD}".$vs));
ok($objJa->eq("\x{3061}\x{309E}", "\x{3061}\x{309D}".$vs));
ok($objJa->eq("\x{30C2}\x{30FD}", "\x{30C1}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30C2}\x{30FD}", "\x{FF81}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3062}\x{309D}", "\x{3061}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30C2}\x{30FE}", "\x{30C2}\x{30FD}".$vs));
ok($objJa->eq("\x{30C1}\x{3099}\x{30FE}", "\x{30C1}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF81}\x{FF9E}\x{30FE}", "\x{FF81}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3062}\x{309E}", "\x{3062}\x{309D}".$vs));
ok($objJa->eq("\x{3061}\x{3099}\x{309E}", "\x{3061}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30C3}\x{30FD}", "\x{FF6F}\x{30FD}"));
ok($objJa->eq("\x{30C3}\x{30FE}", "\x{30C3}\x{30FD}".$vs));
ok($objJa->eq("\x{FF6F}\x{30FE}", "\x{FF6F}\x{30FD}".$vs));
ok($objJa->eq("\x{3063}\x{309E}", "\x{3063}\x{309D}".$vs));
ok($objJa->eq("\x{30C4}\x{30FD}", "\x{FF82}\x{30FD}"));
ok($objJa->eq("\x{30C4}\x{30FE}", "\x{30C4}\x{30FD}".$vs));
ok($objJa->eq("\x{FF82}\x{30FE}", "\x{FF82}\x{30FD}".$vs));
ok($objJa->eq("\x{3064}\x{309E}", "\x{3064}\x{309D}".$vs));
ok($objJa->eq("\x{30C5}\x{30FD}", "\x{30C4}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30C5}\x{30FD}", "\x{FF82}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3065}\x{309D}", "\x{3064}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30C5}\x{30FE}", "\x{30C5}\x{30FD}".$vs));
ok($objJa->eq("\x{30C4}\x{3099}\x{30FE}", "\x{30C4}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF82}\x{FF9E}\x{30FE}", "\x{FF82}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3065}\x{309E}", "\x{3065}\x{309D}".$vs));
ok($objJa->eq("\x{3064}\x{3099}\x{309E}", "\x{3064}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30C6}\x{30FD}", "\x{FF83}\x{30FD}"));
ok($objJa->eq("\x{30C6}\x{30FE}", "\x{30C6}\x{30FD}".$vs));
ok($objJa->eq("\x{FF83}\x{30FE}", "\x{FF83}\x{30FD}".$vs));
ok($objJa->eq("\x{3066}\x{309E}", "\x{3066}\x{309D}".$vs));
ok($objJa->eq("\x{30C7}\x{30FD}", "\x{30C6}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30C7}\x{30FD}", "\x{FF83}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3067}\x{309D}", "\x{3066}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30C7}\x{30FE}", "\x{30C7}\x{30FD}".$vs));
ok($objJa->eq("\x{30C6}\x{3099}\x{30FE}", "\x{30C6}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF83}\x{FF9E}\x{30FE}", "\x{FF83}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3067}\x{309E}", "\x{3067}\x{309D}".$vs));
ok($objJa->eq("\x{3066}\x{3099}\x{309E}", "\x{3066}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30C8}\x{30FD}", "\x{FF84}\x{30FD}"));
ok($objJa->eq("\x{30C8}\x{30FE}", "\x{30C8}\x{30FD}".$vs));
ok($objJa->eq("\x{FF84}\x{30FE}", "\x{FF84}\x{30FD}".$vs));
ok($objJa->eq("\x{3068}\x{309E}", "\x{3068}\x{309D}".$vs));
ok($objJa->eq("\x{30C9}\x{30FD}", "\x{30C8}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30C9}\x{30FD}", "\x{FF84}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3069}\x{309D}", "\x{3068}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30C9}\x{30FE}", "\x{30C9}\x{30FD}".$vs));
ok($objJa->eq("\x{30C8}\x{3099}\x{30FE}", "\x{30C8}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF84}\x{FF9E}\x{30FE}", "\x{FF84}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3069}\x{309E}", "\x{3069}\x{309D}".$vs));
ok($objJa->eq("\x{3068}\x{3099}\x{309E}", "\x{3068}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30CA}\x{30FD}", "\x{FF85}\x{30FD}"));
ok($objJa->eq("\x{30CB}\x{30FD}", "\x{FF86}\x{30FD}"));
ok($objJa->eq("\x{30CC}\x{30FD}", "\x{FF87}\x{30FD}"));
ok($objJa->eq("\x{30CD}\x{30FD}", "\x{FF88}\x{30FD}"));
ok($objJa->eq("\x{30CE}\x{30FD}", "\x{FF89}\x{30FD}"));
ok($objJa->eq("\x{30CF}\x{30FD}", "\x{FF8A}\x{30FD}"));
ok($objJa->eq("\x{30CF}\x{30FE}", "\x{30CF}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8A}\x{30FE}", "\x{FF8A}\x{30FD}".$vs));
ok($objJa->eq("\x{306F}\x{309E}", "\x{306F}\x{309D}".$vs));
ok($objJa->eq("\x{30D0}\x{30FD}", "\x{30CF}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30D0}\x{30FD}", "\x{FF8A}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3070}\x{309D}", "\x{306F}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30D0}\x{30FE}", "\x{30D0}\x{30FD}".$vs));
ok($objJa->eq("\x{30CF}\x{3099}\x{30FE}", "\x{30CF}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8A}\x{FF9E}\x{30FE}", "\x{FF8A}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3070}\x{309E}", "\x{3070}\x{309D}".$vs));
ok($objJa->eq("\x{306F}\x{3099}\x{309E}", "\x{306F}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30D1}\x{30FD}", "\x{30CF}\x{309A}\x{30FD}"));
ok($objJa->eq("\x{30D1}\x{30FD}", "\x{FF8A}\x{FF9F}\x{30FD}"));
ok($objJa->eq("\x{3071}\x{309D}", "\x{306F}\x{309A}\x{309D}"));
ok($objJa->eq("\x{30D1}\x{30FE}", "\x{30D1}\x{30FD}".$vs));
ok($objJa->eq("\x{30CF}\x{309A}\x{30FE}", "\x{30CF}\x{309A}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8A}\x{FF9F}\x{30FE}", "\x{FF8A}\x{FF9F}\x{30FD}".$vs));
ok($objJa->eq("\x{3071}\x{309E}", "\x{3071}\x{309D}".$vs));
ok($objJa->eq("\x{306F}\x{309A}\x{309E}", "\x{306F}\x{309A}\x{309D}".$vs));
ok($objJa->eq("\x{30D2}\x{30FD}", "\x{FF8B}\x{30FD}"));
ok($objJa->eq("\x{30D2}\x{30FE}", "\x{30D2}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8B}\x{30FE}", "\x{FF8B}\x{30FD}".$vs));
ok($objJa->eq("\x{3072}\x{309E}", "\x{3072}\x{309D}".$vs));
ok($objJa->eq("\x{30D3}\x{30FD}", "\x{30D2}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30D3}\x{30FD}", "\x{FF8B}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3073}\x{309D}", "\x{3072}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30D3}\x{30FE}", "\x{30D3}\x{30FD}".$vs));
ok($objJa->eq("\x{30D2}\x{3099}\x{30FE}", "\x{30D2}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8B}\x{FF9E}\x{30FE}", "\x{FF8B}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3073}\x{309E}", "\x{3073}\x{309D}".$vs));
ok($objJa->eq("\x{3072}\x{3099}\x{309E}", "\x{3072}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30D4}\x{30FD}", "\x{30D2}\x{309A}\x{30FD}"));
ok($objJa->eq("\x{30D4}\x{30FD}", "\x{FF8B}\x{FF9F}\x{30FD}"));
ok($objJa->eq("\x{3074}\x{309D}", "\x{3072}\x{309A}\x{309D}"));
ok($objJa->eq("\x{30D4}\x{30FE}", "\x{30D4}\x{30FD}".$vs));
ok($objJa->eq("\x{30D2}\x{309A}\x{30FE}", "\x{30D2}\x{309A}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8B}\x{FF9F}\x{30FE}", "\x{FF8B}\x{FF9F}\x{30FD}".$vs));
ok($objJa->eq("\x{3074}\x{309E}", "\x{3074}\x{309D}".$vs));
ok($objJa->eq("\x{3072}\x{309A}\x{309E}", "\x{3072}\x{309A}\x{309D}".$vs));
ok($objJa->eq("\x{30D5}\x{30FD}", "\x{FF8C}\x{30FD}"));
ok($objJa->eq("\x{30D5}\x{30FE}", "\x{30D5}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8C}\x{30FE}", "\x{FF8C}\x{30FD}".$vs));
ok($objJa->eq("\x{3075}\x{309E}", "\x{3075}\x{309D}".$vs));
ok($objJa->eq("\x{30D6}\x{30FD}", "\x{30D5}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30D6}\x{30FD}", "\x{FF8C}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3076}\x{309D}", "\x{3075}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30D6}\x{30FE}", "\x{30D6}\x{30FD}".$vs));
ok($objJa->eq("\x{30D5}\x{3099}\x{30FE}", "\x{30D5}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8C}\x{FF9E}\x{30FE}", "\x{FF8C}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3076}\x{309E}", "\x{3076}\x{309D}".$vs));
ok($objJa->eq("\x{3075}\x{3099}\x{309E}", "\x{3075}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30D7}\x{30FD}", "\x{30D5}\x{309A}\x{30FD}"));
ok($objJa->eq("\x{30D7}\x{30FD}", "\x{FF8C}\x{FF9F}\x{30FD}"));
ok($objJa->eq("\x{3077}\x{309D}", "\x{3075}\x{309A}\x{309D}"));
ok($objJa->eq("\x{30D7}\x{30FE}", "\x{30D7}\x{30FD}".$vs));
ok($objJa->eq("\x{30D5}\x{309A}\x{30FE}", "\x{30D5}\x{309A}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8C}\x{FF9F}\x{30FE}", "\x{FF8C}\x{FF9F}\x{30FD}".$vs));
ok($objJa->eq("\x{3077}\x{309E}", "\x{3077}\x{309D}".$vs));
ok($objJa->eq("\x{3075}\x{309A}\x{309E}", "\x{3075}\x{309A}\x{309D}".$vs));
ok($objJa->eq("\x{30D8}\x{30FD}", "\x{FF8D}\x{30FD}"));
ok($objJa->eq("\x{30D8}\x{30FE}", "\x{30D8}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8D}\x{30FE}", "\x{FF8D}\x{30FD}".$vs));
ok($objJa->eq("\x{3078}\x{309E}", "\x{3078}\x{309D}".$vs));
ok($objJa->eq("\x{30D9}\x{30FD}", "\x{30D8}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30D9}\x{30FD}", "\x{FF8D}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3079}\x{309D}", "\x{3078}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30D9}\x{30FE}", "\x{30D9}\x{30FD}".$vs));
ok($objJa->eq("\x{30D8}\x{3099}\x{30FE}", "\x{30D8}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8D}\x{FF9E}\x{30FE}", "\x{FF8D}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3079}\x{309E}", "\x{3079}\x{309D}".$vs));
ok($objJa->eq("\x{3078}\x{3099}\x{309E}", "\x{3078}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30DA}\x{30FD}", "\x{30D8}\x{309A}\x{30FD}"));
ok($objJa->eq("\x{30DA}\x{30FD}", "\x{FF8D}\x{FF9F}\x{30FD}"));
ok($objJa->eq("\x{307A}\x{309D}", "\x{3078}\x{309A}\x{309D}"));
ok($objJa->eq("\x{30DA}\x{30FE}", "\x{30DA}\x{30FD}".$vs));
ok($objJa->eq("\x{30D8}\x{309A}\x{30FE}", "\x{30D8}\x{309A}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8D}\x{FF9F}\x{30FE}", "\x{FF8D}\x{FF9F}\x{30FD}".$vs));
ok($objJa->eq("\x{307A}\x{309E}", "\x{307A}\x{309D}".$vs));
ok($objJa->eq("\x{3078}\x{309A}\x{309E}", "\x{3078}\x{309A}\x{309D}".$vs));
ok($objJa->eq("\x{30DB}\x{30FD}", "\x{FF8E}\x{30FD}"));
ok($objJa->eq("\x{30DB}\x{30FE}", "\x{30DB}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8E}\x{30FE}", "\x{FF8E}\x{30FD}".$vs));
ok($objJa->eq("\x{307B}\x{309E}", "\x{307B}\x{309D}".$vs));
ok($objJa->eq("\x{30DC}\x{30FD}", "\x{30DB}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30DC}\x{30FD}", "\x{FF8E}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{307C}\x{309D}", "\x{307B}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30DC}\x{30FE}", "\x{30DC}\x{30FD}".$vs));
ok($objJa->eq("\x{30DB}\x{3099}\x{30FE}", "\x{30DB}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8E}\x{FF9E}\x{30FE}", "\x{FF8E}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{307C}\x{309E}", "\x{307C}\x{309D}".$vs));
ok($objJa->eq("\x{307B}\x{3099}\x{309E}", "\x{307B}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30DD}\x{30FD}", "\x{30DB}\x{309A}\x{30FD}"));
ok($objJa->eq("\x{30DD}\x{30FD}", "\x{FF8E}\x{FF9F}\x{30FD}"));
ok($objJa->eq("\x{307D}\x{309D}", "\x{307B}\x{309A}\x{309D}"));
ok($objJa->eq("\x{30DD}\x{30FE}", "\x{30DD}\x{30FD}".$vs));
ok($objJa->eq("\x{30DB}\x{309A}\x{30FE}", "\x{30DB}\x{309A}\x{30FD}".$vs));
ok($objJa->eq("\x{FF8E}\x{FF9F}\x{30FE}", "\x{FF8E}\x{FF9F}\x{30FD}".$vs));
ok($objJa->eq("\x{307D}\x{309E}", "\x{307D}\x{309D}".$vs));
ok($objJa->eq("\x{307B}\x{309A}\x{309E}", "\x{307B}\x{309A}\x{309D}".$vs));
ok($objJa->eq("\x{30DE}\x{30FD}", "\x{FF8F}\x{30FD}"));
ok($objJa->eq("\x{30DF}\x{30FD}", "\x{FF90}\x{30FD}"));
ok($objJa->eq("\x{30E0}\x{30FD}", "\x{FF91}\x{30FD}"));
ok($objJa->eq("\x{30E1}\x{30FD}", "\x{FF92}\x{30FD}"));
ok($objJa->eq("\x{30E2}\x{30FD}", "\x{FF93}\x{30FD}"));
ok($objJa->eq("\x{30E3}\x{30FD}", "\x{FF6C}\x{30FD}"));
ok($objJa->eq("\x{30E4}\x{30FD}", "\x{FF94}\x{30FD}"));
ok($objJa->eq("\x{30E5}\x{30FD}", "\x{FF6D}\x{30FD}"));
ok($objJa->eq("\x{30E6}\x{30FD}", "\x{FF95}\x{30FD}"));
ok($objJa->eq("\x{30E7}\x{30FD}", "\x{FF6E}\x{30FD}"));
ok($objJa->eq("\x{30E8}\x{30FD}", "\x{FF96}\x{30FD}"));
ok($objJa->eq("\x{30E9}\x{30FD}", "\x{FF97}\x{30FD}"));
ok($objJa->eq("\x{30EA}\x{30FD}", "\x{FF98}\x{30FD}"));
ok($objJa->eq("\x{30EB}\x{30FD}", "\x{FF99}\x{30FD}"));
ok($objJa->eq("\x{30EC}\x{30FD}", "\x{FF9A}\x{30FD}"));
ok($objJa->eq("\x{30ED}\x{30FD}", "\x{FF9B}\x{30FD}"));
ok($objJa->eq("\x{30EE}\x{30FE}", "\x{30EE}\x{30FD}".$vs));
ok($objJa->eq("\x{308E}\x{309E}", "\x{308E}\x{309D}".$vs));
ok($objJa->eq("\x{30EF}\x{30FD}", "\x{FF9C}\x{30FD}"));
ok($objJa->eq("\x{30EF}\x{30FE}", "\x{30EF}\x{30FD}".$vs));
ok($objJa->eq("\x{FF9C}\x{30FE}", "\x{FF9C}\x{30FD}".$vs));
ok($objJa->eq("\x{308F}\x{309E}", "\x{308F}\x{309D}".$vs));
ok($objJa->eq("\x{30F0}\x{30FE}", "\x{30F0}\x{30FD}".$vs));
ok($objJa->eq("\x{3090}\x{309E}", "\x{3090}\x{309D}".$vs));
ok($objJa->eq("\x{30F1}\x{30FE}", "\x{30F1}\x{30FD}".$vs));
ok($objJa->eq("\x{3091}\x{309E}", "\x{3091}\x{309D}".$vs));
ok($objJa->eq("\x{30F2}\x{30FD}", "\x{FF66}\x{30FD}"));
ok($objJa->eq("\x{30F2}\x{30FE}", "\x{30F2}\x{30FD}".$vs));
ok($objJa->eq("\x{FF66}\x{30FE}", "\x{FF66}\x{30FD}".$vs));
ok($objJa->eq("\x{3092}\x{309E}", "\x{3092}\x{309D}".$vs));
ok($objJa->eq("\x{30F3}\x{30FD}", "\x{FF9D}\x{30FD}"));
ok($objJa->eq("\x{30F4}\x{30FD}", "\x{30A6}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30F4}\x{30FD}", "\x{FF73}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{3094}\x{309D}", "\x{3046}\x{3099}\x{309D}"));
ok($objJa->eq("\x{30F4}\x{30FE}", "\x{30F4}\x{30FD}".$vs));
ok($objJa->eq("\x{30A6}\x{3099}\x{30FE}", "\x{30A6}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF73}\x{FF9E}\x{30FE}", "\x{FF73}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{3094}\x{309E}", "\x{3094}\x{309D}".$vs));
ok($objJa->eq("\x{3046}\x{3099}\x{309E}", "\x{3046}\x{3099}\x{309D}".$vs));
ok($objJa->eq("\x{30F5}\x{30FE}", "\x{30F5}\x{30FD}".$vs));
ok($objJa->eq("\x{3095}\x{309E}", "\x{3095}\x{309D}".$vs));
ok($objJa->eq("\x{30F6}\x{30FE}", "\x{30F6}\x{30FD}".$vs));
ok($objJa->eq("\x{3096}\x{309E}", "\x{3096}\x{309D}".$vs));
ok($objJa->eq("\x{30F7}\x{30FD}", "\x{30EF}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30F7}\x{30FD}", "\x{FF9C}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{30F7}\x{30FE}", "\x{30F7}\x{30FD}".$vs));
ok($objJa->eq("\x{30EF}\x{3099}\x{30FE}", "\x{30EF}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF9C}\x{FF9E}\x{30FE}", "\x{FF9C}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{30F8}\x{30FD}", "\x{30F0}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30F8}\x{30FE}", "\x{30F8}\x{30FD}".$vs));
ok($objJa->eq("\x{30F0}\x{3099}\x{30FE}", "\x{30F0}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{30F9}\x{30FD}", "\x{30F1}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30F9}\x{30FE}", "\x{30F9}\x{30FD}".$vs));
ok($objJa->eq("\x{30F1}\x{3099}\x{30FE}", "\x{30F1}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{30FA}\x{30FD}", "\x{30F2}\x{3099}\x{30FD}"));
ok($objJa->eq("\x{30FA}\x{30FD}", "\x{FF66}\x{FF9E}\x{30FD}"));
ok($objJa->eq("\x{30FA}\x{30FE}", "\x{30FA}\x{30FD}".$vs));
ok($objJa->eq("\x{30F2}\x{3099}\x{30FE}", "\x{30F2}\x{3099}\x{30FD}".$vs));
ok($objJa->eq("\x{FF66}\x{FF9E}\x{30FE}", "\x{FF66}\x{FF9E}\x{30FD}".$vs));
ok($objJa->eq("\x{31F0}\x{30FE}", "\x{31F0}\x{30FD}".$vs));
ok($objJa->eq("\x{31F1}\x{30FE}", "\x{31F1}\x{30FD}".$vs));
ok($objJa->eq("\x{31F2}\x{30FE}", "\x{31F2}\x{30FD}".$vs));
ok($objJa->eq("\x{31F3}\x{30FE}", "\x{31F3}\x{30FD}".$vs));
ok($objJa->eq("\x{31F5}\x{30FE}", "\x{31F5}\x{30FD}".$vs));
ok($objJa->eq("\x{31F6}\x{30FE}", "\x{31F6}\x{30FD}".$vs));
ok($objJa->eq("\x{31F7}\x{30FE}", "\x{31F7}\x{30FD}".$vs));
ok($objJa->eq("\x{31F8}\x{30FE}", "\x{31F8}\x{30FD}".$vs));
ok($objJa->eq("\x{31F9}\x{30FE}", "\x{31F9}\x{30FD}".$vs));

# 759
