/*
 * Decompiled with CFR 0.152.
 */
package org.couchbase.mock;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.zip.CRC32;
import net.sf.json.JSONObject;
import org.couchbase.mock.Bucket;
import org.couchbase.mock.BucketConfiguration;
import org.couchbase.mock.CouchbaseMock;
import org.couchbase.mock.memcached.MemcachedServer;

public class CouchbaseBucket
extends Bucket {
    public CouchbaseBucket(CouchbaseMock cluster, BucketConfiguration config) throws IOException {
        super(cluster, config);
    }

    @Override
    public short getVbIndexForKey(String key) {
        CRC32 crc32 = new CRC32();
        crc32.update(key.getBytes());
        long digest = crc32.getValue() >> 16 & 0x7FFFL;
        long vbKey = digest & (long)(this.vbInfo.length - 1);
        return (short)vbKey;
    }

    @Override
    public String getJSON() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        List<MemcachedServer> active = this.activeServers();
        map.put("name", this.name);
        map.put("bucketType", "membase");
        map.put("authType", "sasl");
        map.put("saslPassword", this.getPassword());
        map.put("proxyPort", 0);
        map.put("uri", "/pools/default/buckets/" + this.name);
        map.put("streamingUri", "/pools/default/bucketsStreaming/" + this.name);
        map.put("flushCacheUri", "/pools/default/buckets/" + this.name + "/controller/doFlush");
        ArrayList<String> nodes = new ArrayList<String>();
        for (MemcachedServer server : active) {
            nodes.add(server.toString());
        }
        map.put("nodes", nodes);
        HashMap<String, String> stats = new HashMap<String, String>();
        stats.put("uri", "/pools/default/buckets/" + this.name + "/stats");
        map.put("stats", stats);
        map.put("nodeLocator", "vbucket");
        HashMap<String, Object> vbm = new HashMap<String, Object>();
        vbm.put("hashAlgorithm", "CRC");
        vbm.put("numReplicas", this.numReplicas);
        ArrayList<String> serverList = new ArrayList<String>();
        for (MemcachedServer server : active) {
            serverList.add(server.getSocketName());
        }
        vbm.put("serverList", serverList);
        ArrayList m = new ArrayList();
        for (int ii = 0; ii < this.numVBuckets; ii = (int)((short)(ii + 1))) {
            MemcachedServer master = this.vbInfo[ii].getOwner();
            List<MemcachedServer> replicas = this.vbInfo[ii].getReplicas();
            ArrayList<Integer> line = new ArrayList<Integer>();
            line.add(active.indexOf(master));
            for (MemcachedServer replica : replicas) {
                line.add(active.indexOf(replica));
            }
            while (line.size() - 1 < this.numReplicas) {
                line.add(-1);
            }
            m.add(line);
        }
        vbm.put("vBucketMap", m);
        map.put("vBucketServerMap", vbm);
        return JSONObject.fromObject(map).toString();
    }

    @Override
    public Bucket.BucketType getType() {
        return Bucket.BucketType.COUCHBASE;
    }
}

