package Locales::DB::Language::kea;

use strict;
use warnings;

# Auto generated from CLDR
use if $Locales::_UNICODE_STRINGS, 'utf8';

$Locales::DB::Language::kea::VERSION = '0.09';

$Locales::DB::Language::kea::cldr_version = '2.0';

%Locales::DB::Language::kea::misc_info = (
    'characters'   => { 'more_information' => "\?" },
    'cldr_formats' => {
        '_decimal_format_decimal' => "\,",
        '_decimal_format_group'   => "\.",
        '_percent_format_percent' => "\%",
        'decimal'                 => "\#\,\#\#0\.\#\#\#",
        'ellipsis'                => {
            'final'   => "\{0\}…",
            'initial' => "…\{0\}",
            'medial'  => "\{0\}…\{1\}"
        },
        'language' => "Lingua\:\ \{0\}",
        'list'     => {
            2        => "\{0\}\ y\ \{1\}",
            'end'    => "\{0\}\ y\ \{1\}",
            'middle' => "\{0\}\,\ \{1\}",
            'start'  => "\{0\}\,\ \{1\}"
        },
        'locale'    => "\{0\}\ \(\{1\}\)",
        'percent'   => "\#\,\#\#0\%",
        'territory' => "Rejiãu\:\ \{0\}"
    },
    'delimiters' => {
        'alternate_quotation_end'   => '»',
        'alternate_quotation_start' => '«',
        'quotation_end'             => '”',
        'quotation_start'           => '“'
    },
    'fallback'    => [],
    'orientation' => {
        'characters' => "left\-to\-right",
        'lines'      => "top\-to\-bottom"
    },
    'plural_forms' => {
        'category_list'  => ['other'],
        'category_rules' => {}
    },
    'posix' => {
        'nostr'  => "Nãu\:N",
        'yesstr' => "Sin\:S"
    },
);

%Locales::DB::Language::kea::code_to_name = (
    'aa'     => 'Afar',
    'ab'     => 'abkaziu',
    'ace'    => 'Achinese',
    'ach'    => 'Acoli',
    'ada'    => 'Adangme',
    'ady'    => 'Adyghe',
    'ae'     => 'Avestan',
    'af'     => 'afrikaner',
    'afa'    => "Afro\-Asiatic\ Language",
    'afh'    => 'Afrihili',
    'agq'    => 'Aghem',
    'ain'    => 'Ainu',
    'ak'     => 'akan',
    'akk'    => 'Akkadian',
    'ale'    => 'Aleut',
    'alg'    => "Algonquian\ Language",
    'alt'    => "Southern\ Altai",
    'am'     => 'amariku',
    'an'     => 'Aragonese',
    'ang'    => "Old\ English",
    'anp'    => 'Angika',
    'apa'    => "Apache\ Language",
    'ar'     => 'arabi',
    'arc'    => 'Aramaic',
    'arn'    => 'Araucanian',
    'arp'    => 'Arapaho',
    'art'    => "Artificial\ Language",
    'arw'    => 'Arawak',
    'as'     => 'asames',
    'asa'    => 'Asu',
    'ast'    => 'Asturian',
    'ath'    => "Athapascan\ Language",
    'aus'    => "Australian\ Language",
    'av'     => 'Avaric',
    'awa'    => 'Awadhi',
    'ay'     => 'aimara',
    'az'     => 'azerbaijanu',
    'ba'     => 'Bashkir',
    'bad'    => 'Banda',
    'bai'    => "Bamileke\ Language",
    'bal'    => 'Baluchi',
    'ban'    => 'Balinese',
    'bas'    => 'Basaa',
    'bat'    => "Baltic\ Language",
    'be'     => 'bielorusu',
    'bej'    => 'Beja',
    'bem'    => 'Bemba',
    'ber'    => 'Berber',
    'bez'    => 'Bena',
    'bg'     => 'bulgaru',
    'bh'     => 'Bihari',
    'bho'    => 'Bhojpuri',
    'bi'     => 'Bislama',
    'bik'    => 'Bikol',
    'bin'    => 'Bini',
    'bla'    => 'Siksika',
    'bm'     => 'Bambara',
    'bn'     => 'bengali',
    'bnt'    => 'Bantu',
    'bo'     => 'tibetanu',
    'br'     => 'Breton',
    'bra'    => 'Braj',
    'brx'    => 'Bodo',
    'bs'     => 'bosniu',
    'btk'    => 'Batak',
    'bua'    => 'Buriat',
    'bug'    => 'Buginese',
    'byn'    => 'Blin',
    'ca'     => 'katalãu',
    'cad'    => 'Caddo',
    'cai'    => "Central\ American\ Indian\ Language",
    'car'    => 'Carib',
    'cau'    => "Caucasian\ Language",
    'cay'    => 'Cayuga',
    'cch'    => 'Atsam',
    'ce'     => 'Chechen',
    'ceb'    => 'Cebuano',
    'cel'    => "Celtic\ Language",
    'cgg'    => 'Chiga',
    'ch'     => 'Chamorro',
    'chb'    => 'Chibcha',
    'chg'    => 'Chagatai',
    'chk'    => 'Chuukese',
    'chm'    => 'Mari',
    'chn'    => "Chinook\ Jargon",
    'cho'    => 'Choctaw',
    'chp'    => 'Chipewyan',
    'chr'    => 'Cherokee',
    'chy'    => 'Cheyenne',
    'cmc'    => "Chamic\ Language",
    'co'     => 'Corsican',
    'cop'    => 'Coptic',
    'cpe'    => "English\-based\ Creole\ or\ Pidgin",
    'cpf'    => "French\-based\ Creole\ or\ Pidgin",
    'cpp'    => "Portuguese\-based\ Creole\ or\ Pidgin",
    'cr'     => 'Cree',
    'crh'    => "Crimean\ Turkish",
    'crp'    => "Creole\ or\ Pidgin",
    'cs'     => 'txeku',
    'csb'    => 'Kashubian',
    'cu'     => "Church\ Slavic",
    'cus'    => "Cushitic\ Language",
    'cv'     => 'Chuvash',
    'cy'     => 'gales',
    'da'     => 'dinamarkes',
    'dak'    => 'Dakota',
    'dar'    => 'Dargwa',
    'dav'    => 'Taita',
    'day'    => 'Dayak',
    'de'     => 'alemãu',
    'de_at'  => "alimãu\ austriaku",
    'de_ch'  => "altu\ alimãu\ suisu",
    'del'    => 'Delaware',
    'den'    => 'Slave',
    'dgr'    => 'Dogrib',
    'din'    => 'Dinka',
    'dje'    => 'Zarma',
    'doi'    => 'Dogri',
    'dra'    => "Dravidian\ Language",
    'dsb'    => "Lower\ Sorbian",
    'dua'    => 'Duala',
    'dum'    => "Middle\ Dutch",
    'dv'     => 'Divehi',
    'dyo'    => "Jola\-Fonyi",
    'dyu'    => 'Dyula',
    'dz'     => 'Dzongkha',
    'ebu'    => 'Embu',
    'ee'     => 'Ewe',
    'efi'    => 'Efik',
    'egy'    => "Ancient\ Egyptian",
    'eka'    => 'Ekajuk',
    'el'     => 'gregu',
    'elx'    => 'Elamite',
    'en'     => 'ingles',
    'en_au'  => "ingles\ australianu",
    'en_ca'  => "ingles\ kanadianu",
    'en_gb'  => "ingles\ britanuku",
    'en_us'  => "ingles\ merkanu",
    'enm'    => "Middle\ English",
    'eo'     => 'Esperanto',
    'es'     => 'spanhol',
    'es_419' => "spanhol\ latinu\-merkanu",
    'es_es'  => "spanhol\ europeu",
    'et'     => 'Estonian',
    'eu'     => 'Basque',
    'ewo'    => 'Ewondo',
    'fa'     => 'persa',
    'fan'    => 'Fang',
    'fat'    => 'Fanti',
    'ff'     => 'Fulah',
    'fi'     => 'Finnish',
    'fil'    => 'Filipino',
    'fiu'    => "Finno\-Ugrian\ Language",
    'fj'     => 'Fijian',
    'fo'     => 'Faroese',
    'fon'    => 'Fon',
    'fr'     => 'franses',
    'fr_ca'  => "franses\ kanadianu",
    'fr_ch'  => "franses\ suisu",
    'frm'    => "Middle\ French",
    'fro'    => "Old\ French",
    'frr'    => "Northern\ Frisian",
    'frs'    => "Eastern\ Frisian",
    'fur'    => 'Friulian',
    'fy'     => "Western\ Frisian",
    'ga'     => 'Irish',
    'gaa'    => 'Ga',
    'gay'    => 'Gayo',
    'gba'    => 'Gbaya',
    'gd'     => "Scottish\ Gaelic",
    'gem'    => "Germanic\ Language",
    'gez'    => 'Geez',
    'gil'    => 'Gilbertese',
    'gl'     => 'Galician',
    'gmh'    => "Middle\ High\ German",
    'gn'     => 'Guarani',
    'goh'    => "Old\ High\ German",
    'gon'    => 'Gondi',
    'gor'    => 'Gorontalo',
    'got'    => 'Gothic',
    'grb'    => 'Grebo',
    'grc'    => "Ancient\ Greek",
    'gsw'    => "Swiss\ German",
    'gu'     => 'Gujarati',
    'guz'    => 'Gusii',
    'gv'     => 'Manx',
    'gwi'    => "Gwich\Ê\¼in",
    'ha'     => 'auza',
    'hai'    => 'Haida',
    'haw'    => 'Hawaiian',
    'he'     => 'Hebrew',
    'hi'     => 'indi',
    'hil'    => 'Hiligaynon',
    'him'    => 'Himachali',
    'hit'    => 'Hittite',
    'hmn'    => 'Hmong',
    'ho'     => "Hiri\ Motu",
    'hr'     => 'Croatian',
    'hsb'    => "Upper\ Sorbian",
    'ht'     => 'Haitian',
    'hu'     => 'ungaru',
    'hup'    => 'Hupa',
    'hy'     => 'Armenian',
    'hz'     => 'Herero',
    'ia'     => 'Interlingua',
    'iba'    => 'Iban',
    'id'     => 'indoneziu',
    'ie'     => 'Interlingue',
    'ig'     => 'ibo',
    'ii'     => "Sichuan\ Yi",
    'ijo'    => 'Ijo',
    'ik'     => 'Inupiaq',
    'ilo'    => 'Iloko',
    'inc'    => "Indic\ Language",
    'ine'    => "Indo\-European\ Language",
    'inh'    => 'Ingush',
    'io'     => 'Ido',
    'ira'    => "Iranian\ Language",
    'iro'    => "Iroquoian\ Language",
    'is'     => 'Icelandic',
    'it'     => 'italianu',
    'iu'     => 'Inuktitut',
    'ja'     => 'japones',
    'jbo'    => 'Lojban',
    'jmc'    => 'Machame',
    'jpr'    => "Judeo\-Persian",
    'jrb'    => "Judeo\-Arabic",
    'jv'     => 'javanes',
    'ka'     => 'Georgian',
    'kaa'    => "Kara\-Kalpak",
    'kab'    => 'Kabyle',
    'kac'    => 'Kachin',
    'kaj'    => 'Jju',
    'kam'    => 'Kamba',
    'kar'    => 'Karen',
    'kaw'    => 'Kawi',
    'kbd'    => 'Kabardian',
    'kcg'    => 'Tyap',
    'kde'    => 'Makonde',
    'kea'    => 'kabuverdianu',
    'kfo'    => 'Koro',
    'kg'     => 'Kongo',
    'kha'    => 'Khasi',
    'khi'    => "Khoisan\ Language",
    'kho'    => 'Khotanese',
    'khq'    => "Koyra\ Chiini",
    'ki'     => 'Kikuyu',
    'kj'     => 'Kuanyama',
    'kk'     => 'Kazakh',
    'kl'     => 'Kalaallisut',
    'kln'    => 'Kalenjin',
    'km'     => 'kmer',
    'kmb'    => 'Kimbundu',
    'kn'     => 'Kannada',
    'ko'     => 'kureanu',
    'kok'    => 'Konkani',
    'kos'    => 'Kosraean',
    'kpe'    => 'Kpelle',
    'kr'     => 'Kanuri',
    'krc'    => "Karachay\-Balkar",
    'krl'    => 'Karelian',
    'kro'    => 'Kru',
    'kru'    => 'Kurukh',
    'ks'     => 'Kashmiri',
    'ksb'    => 'Shambala',
    'ksf'    => 'Bafia',
    'ksh'    => 'Colognian',
    'ku'     => 'Kurdish',
    'kum'    => 'Kumyk',
    'kut'    => 'Kutenai',
    'kv'     => 'Komi',
    'kw'     => 'Cornish',
    'ky'     => 'Kirghiz',
    'la'     => 'Latin',
    'lad'    => 'Ladino',
    'lag'    => 'Langi',
    'lah'    => 'Lahnda',
    'lam'    => 'Lamba',
    'lb'     => 'Luxembourgish',
    'lez'    => 'Lezghian',
    'lg'     => 'Ganda',
    'li'     => 'Limburgish',
    'ln'     => 'Lingala',
    'lo'     => 'Lao',
    'lol'    => 'Mongo',
    'loz'    => 'Lozi',
    'lt'     => 'Lithuanian',
    'lu'     => "Luba\-Katanga",
    'lua'    => "Luba\-Lulua",
    'lui'    => 'Luiseno',
    'lun'    => 'Lunda',
    'luo'    => 'Luo',
    'lus'    => 'Lushai',
    'luy'    => 'Luyia',
    'lv'     => 'Latvian',
    'mad'    => 'Madurese',
    'mag'    => 'Magahi',
    'mai'    => 'Maithili',
    'mak'    => 'Makasar',
    'man'    => 'Mandingo',
    'map'    => "Austronesian\ Language",
    'mas'    => 'Masai',
    'mdf'    => 'Moksha',
    'mdr'    => 'Mandar',
    'men'    => 'Mende',
    'mer'    => 'Meru',
    'mfe'    => 'Morisyen',
    'mg'     => 'Malagasy',
    'mga'    => "Middle\ Irish",
    'mgh'    => "Makhuwa\-Meetto",
    'mh'     => 'Marshallese',
    'mi'     => 'Maori',
    'mic'    => 'Micmac',
    'min'    => 'Minangkabau',
    'mis'    => "Miscellaneous\ Language",
    'mk'     => 'Macedonian',
    'mkh'    => "Mon\-Khmer\ Language",
    'ml'     => 'Malayalam',
    'mn'     => 'Mongolian',
    'mnc'    => 'Manchu',
    'mni'    => 'Manipuri',
    'mno'    => "Manobo\ Language",
    'mo'     => 'Moldavian',
    'moh'    => 'Mohawk',
    'mos'    => 'Mossi',
    'mr'     => 'Marathi',
    'ms'     => 'malaiu',
    'mt'     => 'Maltese',
    'mua'    => 'Mundang',
    'mul'    => "Multiple\ Languages",
    'mun'    => "Munda\ Language",
    'mus'    => 'Creek',
    'mwl'    => 'Mirandese',
    'mwr'    => 'Marwari',
    'my'     => 'birmanes',
    'myn'    => "Mayan\ Language",
    'myv'    => 'Erzya',
    'na'     => 'Nauru',
    'nah'    => 'Nahuatl',
    'nai'    => "North\ American\ Indian\ Language",
    'nap'    => 'Neapolitan',
    'naq'    => 'Nama',
    'nb'     => "Norwegian\ Bokm\Ã\¥l",
    'nd'     => "North\ Ndebele",
    'nds'    => "Low\ German",
    'ne'     => 'nepales',
    'new'    => 'Newari',
    'ng'     => 'Ndonga',
    'nia'    => 'Nias',
    'nic'    => "Niger\-Kordofanian\ Language",
    'niu'    => 'Niuean',
    'nl'     => 'olandes',
    'nl_be'  => 'flamengu',
    'nmg'    => 'Kwasio',
    'nn'     => "Norwegian\ Nynorsk",
    'no'     => 'Norwegian',
    'nog'    => 'Nogai',
    'non'    => "Old\ Norse",
    'nqo'    => "N\â\\Ko",
    'nr'     => "South\ Ndebele",
    'nso'    => "Northern\ Sotho",
    'nub'    => "Nubian\ Language",
    'nus'    => 'Nuer',
    'nv'     => 'Navajo',
    'nwc'    => "Classical\ Newari",
    'ny'     => 'Nyanja',
    'nym'    => 'Nyamwezi',
    'nyn'    => 'Nyankole',
    'nyo'    => 'Nyoro',
    'nzi'    => 'Nzima',
    'oc'     => 'Occitan',
    'oj'     => 'Ojibwa',
    'om'     => 'Oromo',
    'or'     => 'Oriya',
    'os'     => 'Ossetic',
    'osa'    => 'Osage',
    'ota'    => "Ottoman\ Turkish",
    'oto'    => "Otomian\ Language",
    'pa'     => 'pandjabi',
    'paa'    => "Papuan\ Language",
    'pag'    => 'Pangasinan',
    'pal'    => 'Pahlavi',
    'pam'    => 'Pampanga',
    'pap'    => 'Papiamento',
    'pau'    => 'Palauan',
    'peo'    => "Old\ Persian",
    'phi'    => "Philippine\ Language",
    'phn'    => 'Phoenician',
    'pi'     => 'Pali',
    'pl'     => 'pulaku',
    'pon'    => 'Pohnpeian',
    'pra'    => "Prakrit\ Language",
    'pro'    => "Old\ Proven\Ã\§al",
    'ps'     => 'Pushto',
    'pt'     => 'purtuges',
    'pt_br'  => "purtuges\ brazileru",
    'pt_pt'  => "purtuges\ europeu",
    'qu'     => 'Quechua',
    'raj'    => 'Rajasthani',
    'rap'    => 'Rapanui',
    'rar'    => 'Rarotongan',
    'rm'     => 'Romansh',
    'rn'     => 'Rundi',
    'ro'     => 'rumenu',
    'roa'    => "Romance\ Language",
    'rof'    => 'Rombo',
    'rom'    => 'Romany',
    'ru'     => 'rusu',
    'rup'    => 'Aromanian',
    'rw'     => 'kiniaruanda',
    'rwk'    => 'Rwa',
    'sa'     => 'Sanskrit',
    'sad'    => 'Sandawe',
    'sah'    => 'Sakha',
    'sai'    => "South\ American\ Indian\ Language",
    'sal'    => "Salishan\ Language",
    'sam'    => "Samaritan\ Aramaic",
    'saq'    => 'Samburu',
    'sas'    => 'Sasak',
    'sat'    => 'Santali',
    'sbp'    => 'Sangu',
    'sc'     => 'Sardinian',
    'scn'    => 'Sicilian',
    'sco'    => 'Scots',
    'sd'     => 'Sindhi',
    'se'     => "Northern\ Sami",
    'see'    => 'Seneca',
    'seh'    => 'Sena',
    'sel'    => 'Selkup',
    'sem'    => "Semitic\ Language",
    'ses'    => "Koyraboro\ Senni",
    'sg'     => 'Sango',
    'sga'    => "Old\ Irish",
    'sgn'    => "Sign\ Language",
    'sh'     => "Serbo\-Croatian",
    'shi'    => 'Tachelhit',
    'shn'    => 'Shan',
    'si'     => 'Sinhala',
    'sid'    => 'Sidamo',
    'sio'    => "Siouan\ Language",
    'sit'    => "Sino\-Tibetan\ Language",
    'sk'     => 'Slovak',
    'sl'     => 'Slovenian',
    'sla'    => "Slavic\ Language",
    'sm'     => 'Samoan',
    'sma'    => "Southern\ Sami",
    'smi'    => "Sami\ Language",
    'smj'    => "Lule\ Sami",
    'smn'    => "Inari\ Sami",
    'sms'    => "Skolt\ Sami",
    'sn'     => 'Shona',
    'snk'    => 'Soninke',
    'so'     => 'somali',
    'sog'    => 'Sogdien',
    'son'    => 'Songhai',
    'sq'     => 'Albanian',
    'sr'     => 'Serbian',
    'srn'    => "Sranan\ Tongo",
    'srr'    => 'Serer',
    'ss'     => 'Swati',
    'ssa'    => "Nilo\-Saharan\ Language",
    'ssy'    => 'Saho',
    'st'     => "Southern\ Sotho",
    'su'     => 'Sundanese',
    'suk'    => 'Sukuma',
    'sus'    => 'Susu',
    'sux'    => 'Sumerian',
    'sv'     => 'sueku',
    'sw'     => 'Swahili',
    'swb'    => 'Comorian',
    'swc'    => "Congo\ Swahili",
    'syc'    => "Classical\ Syriac",
    'syr'    => 'Syriac',
    'ta'     => 'tamil',
    'tai'    => "Tai\ Language",
    'te'     => 'Telugu',
    'tem'    => 'Timne',
    'teo'    => 'Teso',
    'ter'    => 'Tereno',
    'tet'    => 'Tetum',
    'tg'     => 'Tajik',
    'th'     => 'tailandes',
    'ti'     => 'Tigrinya',
    'tig'    => 'Tigre',
    'tiv'    => 'Tiv',
    'tk'     => 'Turkmen',
    'tkl'    => 'Tokelau',
    'tl'     => 'Tagalog',
    'tlh'    => 'Klingon',
    'tli'    => 'Tlingit',
    'tmh'    => 'Tamashek',
    'tn'     => 'Tswana',
    'to'     => 'Tonga',
    'tog'    => "Nyasa\ Tonga",
    'tpi'    => "Tok\ Pisin",
    'tr'     => 'turku',
    'trv'    => 'Taroko',
    'ts'     => 'Tsonga',
    'tsi'    => 'Tsimshian',
    'tt'     => 'Tatar',
    'tum'    => 'Tumbuka',
    'tup'    => "Tupi\ Language",
    'tut'    => "Altaic\ Language",
    'tvl'    => 'Tuvalu',
    'tw'     => 'Twi',
    'twq'    => 'Tasawaq',
    'ty'     => 'Tahitian',
    'tyv'    => 'Tuvinian',
    'tzm'    => "Central\ Morocco\ Tamazight",
    'udm'    => 'Udmurt',
    'ug'     => 'Uyghur',
    'uga'    => 'Ugaritic',
    'uk'     => 'ukranianu',
    'umb'    => 'Umbundu',
    'und'    => "lingua\ diskonxedu",
    'ur'     => 'urdu',
    'uz'     => 'Uzbek',
    'vai'    => 'Vai',
    've'     => 'Venda',
    'vi'     => 'vietnamita',
    'vo'     => "Volap\Ã\¼k",
    'vot'    => 'Votic',
    'vun'    => 'Vunjo',
    'wa'     => 'Walloon',
    'wae'    => 'Walser',
    'wak'    => "Wakashan\ Language",
    'wal'    => 'Walamo',
    'war'    => 'Waray',
    'was'    => 'Washo',
    'wen'    => "Sorbian\ Language",
    'wo'     => 'Wolof',
    'xal'    => 'Kalmyk',
    'xh'     => 'Xhosa',
    'xog'    => 'Soga',
    'yao'    => 'Yao',
    'yap'    => 'Yapese',
    'yav'    => 'Yangben',
    'yi'     => 'Yiddish',
    'yo'     => 'ioruba',
    'ypk'    => "Yupik\ Language",
    'yue'    => 'Cantonese',
    'za'     => 'Zhuang',
    'zap'    => 'Zapotec',
    'zbl'    => 'Blissymbols',
    'zen'    => 'Zenaga',
    'zh'     => 'xines',
    'znd'    => 'Zande',
    'zu'     => 'zulu',
    'zun'    => 'Zuni',
    'zxx'    => "No\ linguistic\ content",
    'zza'    => 'Zaza',
);

%Locales::DB::Language::kea::name_to_code = (
    'abkaziu'                       => 'ab',
    'achinese'                      => 'ace',
    'acoli'                         => 'ach',
    'adangme'                       => 'ada',
    'adyghe'                        => 'ady',
    'afar'                          => 'aa',
    'afrihili'                      => 'afh',
    'afrikaner'                     => 'af',
    'afroasiaticlanguage'           => 'afa',
    'aghem'                         => 'agq',
    'aimara'                        => 'ay',
    'ainu'                          => 'ain',
    'akan'                          => 'ak',
    'akkadian'                      => 'akk',
    'albanian'                      => 'sq',
    'alemãu'                       => 'de',
    'aleut'                         => 'ale',
    'algonquianlanguage'            => 'alg',
    'alimãuaustriaku'              => 'de_at',
    'altaiclanguage'                => 'tut',
    'altualimãusuisu'              => 'de_ch',
    'amariku'                       => 'am',
    'ancientegyptian'               => 'egy',
    'ancientgreek'                  => 'grc',
    'angika'                        => 'anp',
    'apachelanguage'                => 'apa',
    'arabi'                         => 'ar',
    'aragonese'                     => 'an',
    'aramaic'                       => 'arc',
    'arapaho'                       => 'arp',
    'araucanian'                    => 'arn',
    'arawak'                        => 'arw',
    'armenian'                      => 'hy',
    'aromanian'                     => 'rup',
    'artificiallanguage'            => 'art',
    'asames'                        => 'as',
    'asturian'                      => 'ast',
    'asu'                           => 'asa',
    'athapascanlanguage'            => 'ath',
    'atsam'                         => 'cch',
    'australianlanguage'            => 'aus',
    'austronesianlanguage'          => 'map',
    'auza'                          => 'ha',
    'avaric'                        => 'av',
    'avestan'                       => 'ae',
    'awadhi'                        => 'awa',
    'azerbaijanu'                   => 'az',
    'bafia'                         => 'ksf',
    'balinese'                      => 'ban',
    'balticlanguage'                => 'bat',
    'baluchi'                       => 'bal',
    'bambara'                       => 'bm',
    'bamilekelanguage'              => 'bai',
    'banda'                         => 'bad',
    'bantu'                         => 'bnt',
    'basaa'                         => 'bas',
    'bashkir'                       => 'ba',
    'basque'                        => 'eu',
    'batak'                         => 'btk',
    'beja'                          => 'bej',
    'bemba'                         => 'bem',
    'bena'                          => 'bez',
    'bengali'                       => 'bn',
    'berber'                        => 'ber',
    'bhojpuri'                      => 'bho',
    'bielorusu'                     => 'be',
    'bihari'                        => 'bh',
    'bikol'                         => 'bik',
    'bini'                          => 'bin',
    'birmanes'                      => 'my',
    'bislama'                       => 'bi',
    'blin'                          => 'byn',
    'blissymbols'                   => 'zbl',
    'bodo'                          => 'brx',
    'bosniu'                        => 'bs',
    'braj'                          => 'bra',
    'breton'                        => 'br',
    'buginese'                      => 'bug',
    'bulgaru'                       => 'bg',
    'buriat'                        => 'bua',
    'caddo'                         => 'cad',
    'cantonese'                     => 'yue',
    'carib'                         => 'car',
    'caucasianlanguage'             => 'cau',
    'cayuga'                        => 'cay',
    'cebuano'                       => 'ceb',
    'celticlanguage'                => 'cel',
    'centralamericanindianlanguage' => 'cai',
    'centralmoroccotamazight'       => 'tzm',
    'chagatai'                      => 'chg',
    'chamiclanguage'                => 'cmc',
    'chamorro'                      => 'ch',
    'chechen'                       => 'ce',
    'cherokee'                      => 'chr',
    'cheyenne'                      => 'chy',
    'chibcha'                       => 'chb',
    'chiga'                         => 'cgg',
    'chinookjargon'                 => 'chn',
    'chipewyan'                     => 'chp',
    'choctaw'                       => 'cho',
    'churchslavic'                  => 'cu',
    'chuukese'                      => 'chk',
    'chuvash'                       => 'cv',
    'classicalnewari'               => 'nwc',
    'classicalsyriac'               => 'syc',
    'colognian'                     => 'ksh',
    'comorian'                      => 'swb',
    'congoswahili'                  => 'swc',
    'coptic'                        => 'cop',
    'cornish'                       => 'kw',
    'corsican'                      => 'co',
    'cree'                          => 'cr',
    'creek'                         => 'mus',
    'creoleorpidgin'                => 'crp',
    'crimeanturkish'                => 'crh',
    'croatian'                      => 'hr',
    'cushiticlanguage'              => 'cus',
    'dakota'                        => 'dak',
    'dargwa'                        => 'dar',
    'dayak'                         => 'day',
    'delaware'                      => 'del',
    'dinamarkes'                    => 'da',
    'dinka'                         => 'din',
    'divehi'                        => 'dv',
    'dogri'                         => 'doi',
    'dogrib'                        => 'dgr',
    'dravidianlanguage'             => 'dra',
    'duala'                         => 'dua',
    'dyula'                         => 'dyu',
    'dzongkha'                      => 'dz',
    'easternfrisian'                => 'frs',
    'efik'                          => 'efi',
    'ekajuk'                        => 'eka',
    'elamite'                       => 'elx',
    'embu'                          => 'ebu',
    'englishbasedcreoleorpidgin'    => 'cpe',
    'erzya'                         => 'myv',
    'esperanto'                     => 'eo',
    'estonian'                      => 'et',
    'ewe'                           => 'ee',
    'ewondo'                        => 'ewo',
    'fang'                          => 'fan',
    'fanti'                         => 'fat',
    'faroese'                       => 'fo',
    'fijian'                        => 'fj',
    'filipino'                      => 'fil',
    'finnish'                       => 'fi',
    'finnougrianlanguage'           => 'fiu',
    'flamengu'                      => 'nl_be',
    'fon'                           => 'fon',
    'franses'                       => 'fr',
    'franseskanadianu'              => 'fr_ca',
    'fransessuisu'                  => 'fr_ch',
    'frenchbasedcreoleorpidgin'     => 'cpf',
    'friulian'                      => 'fur',
    'fulah'                         => 'ff',
    'ga'                            => 'gaa',
    'gales'                         => 'cy',
    'galician'                      => 'gl',
    'ganda'                         => 'lg',
    'gayo'                          => 'gay',
    'gbaya'                         => 'gba',
    'geez'                          => 'gez',
    'georgian'                      => 'ka',
    'germaniclanguage'              => 'gem',
    'gilbertese'                    => 'gil',
    'gondi'                         => 'gon',
    'gorontalo'                     => 'gor',
    'gothic'                        => 'got',
    'grebo'                         => 'grb',
    'gregu'                         => 'el',
    'guarani'                       => 'gn',
    'gujarati'                      => 'gu',
    'gusii'                         => 'guz',
    "gwich\Ê\¼in"                 => 'gwi',
    'haida'                         => 'hai',
    'haitian'                       => 'ht',
    'hawaiian'                      => 'haw',
    'hebrew'                        => 'he',
    'herero'                        => 'hz',
    'hiligaynon'                    => 'hil',
    'himachali'                     => 'him',
    'hirimotu'                      => 'ho',
    'hittite'                       => 'hit',
    'hmong'                         => 'hmn',
    'hupa'                          => 'hup',
    'iban'                          => 'iba',
    'ibo'                           => 'ig',
    'icelandic'                     => 'is',
    'ido'                           => 'io',
    'ijo'                           => 'ijo',
    'iloko'                         => 'ilo',
    'inarisami'                     => 'smn',
    'indi'                          => 'hi',
    'indiclanguage'                 => 'inc',
    'indoeuropeanlanguage'          => 'ine',
    'indoneziu'                     => 'id',
    'ingles'                        => 'en',
    'inglesaustralianu'             => 'en_au',
    'inglesbritanuku'               => 'en_gb',
    'ingleskanadianu'               => 'en_ca',
    'inglesmerkanu'                 => 'en_us',
    'ingush'                        => 'inh',
    'interlingua'                   => 'ia',
    'interlingue'                   => 'ie',
    'inuktitut'                     => 'iu',
    'inupiaq'                       => 'ik',
    'ioruba'                        => 'yo',
    'iranianlanguage'               => 'ira',
    'irish'                         => 'ga',
    'iroquoianlanguage'             => 'iro',
    'italianu'                      => 'it',
    'japones'                       => 'ja',
    'javanes'                       => 'jv',
    'jju'                           => 'kaj',
    'jolafonyi'                     => 'dyo',
    'judeoarabic'                   => 'jrb',
    'judeopersian'                  => 'jpr',
    'kabardian'                     => 'kbd',
    'kabuverdianu'                  => 'kea',
    'kabyle'                        => 'kab',
    'kachin'                        => 'kac',
    'kalaallisut'                   => 'kl',
    'kalenjin'                      => 'kln',
    'kalmyk'                        => 'xal',
    'kamba'                         => 'kam',
    'kannada'                       => 'kn',
    'kanuri'                        => 'kr',
    'karachaybalkar'                => 'krc',
    'karakalpak'                    => 'kaa',
    'karelian'                      => 'krl',
    'karen'                         => 'kar',
    'kashmiri'                      => 'ks',
    'kashubian'                     => 'csb',
    'katalãu'                      => 'ca',
    'kawi'                          => 'kaw',
    'kazakh'                        => 'kk',
    'khasi'                         => 'kha',
    'khoisanlanguage'               => 'khi',
    'khotanese'                     => 'kho',
    'kikuyu'                        => 'ki',
    'kimbundu'                      => 'kmb',
    'kiniaruanda'                   => 'rw',
    'kirghiz'                       => 'ky',
    'klingon'                       => 'tlh',
    'kmer'                          => 'km',
    'komi'                          => 'kv',
    'kongo'                         => 'kg',
    'konkani'                       => 'kok',
    'koro'                          => 'kfo',
    'kosraean'                      => 'kos',
    'koyraborosenni'                => 'ses',
    'koyrachiini'                   => 'khq',
    'kpelle'                        => 'kpe',
    'kru'                           => 'kro',
    'kuanyama'                      => 'kj',
    'kumyk'                         => 'kum',
    'kurdish'                       => 'ku',
    'kureanu'                       => 'ko',
    'kurukh'                        => 'kru',
    'kutenai'                       => 'kut',
    'kwasio'                        => 'nmg',
    'ladino'                        => 'lad',
    'lahnda'                        => 'lah',
    'lamba'                         => 'lam',
    'langi'                         => 'lag',
    'lao'                           => 'lo',
    'latin'                         => 'la',
    'latvian'                       => 'lv',
    'lezghian'                      => 'lez',
    'limburgish'                    => 'li',
    'lingala'                       => 'ln',
    'linguadiskonxedu'              => 'und',
    'lithuanian'                    => 'lt',
    'lojban'                        => 'jbo',
    'lowersorbian'                  => 'dsb',
    'lowgerman'                     => 'nds',
    'lozi'                          => 'loz',
    'lubakatanga'                   => 'lu',
    'lubalulua'                     => 'lua',
    'luiseno'                       => 'lui',
    'lulesami'                      => 'smj',
    'lunda'                         => 'lun',
    'luo'                           => 'luo',
    'lushai'                        => 'lus',
    'luxembourgish'                 => 'lb',
    'luyia'                         => 'luy',
    'macedonian'                    => 'mk',
    'machame'                       => 'jmc',
    'madurese'                      => 'mad',
    'magahi'                        => 'mag',
    'maithili'                      => 'mai',
    'makasar'                       => 'mak',
    'makhuwameetto'                 => 'mgh',
    'makonde'                       => 'kde',
    'malagasy'                      => 'mg',
    'malaiu'                        => 'ms',
    'malayalam'                     => 'ml',
    'maltese'                       => 'mt',
    'manchu'                        => 'mnc',
    'mandar'                        => 'mdr',
    'mandingo'                      => 'man',
    'manipuri'                      => 'mni',
    'manobolanguage'                => 'mno',
    'manx'                          => 'gv',
    'maori'                         => 'mi',
    'marathi'                       => 'mr',
    'mari'                          => 'chm',
    'marshallese'                   => 'mh',
    'marwari'                       => 'mwr',
    'masai'                         => 'mas',
    'mayanlanguage'                 => 'myn',
    'mende'                         => 'men',
    'meru'                          => 'mer',
    'micmac'                        => 'mic',
    'middledutch'                   => 'dum',
    'middleenglish'                 => 'enm',
    'middlefrench'                  => 'frm',
    'middlehighgerman'              => 'gmh',
    'middleirish'                   => 'mga',
    'minangkabau'                   => 'min',
    'mirandese'                     => 'mwl',
    'miscellaneouslanguage'         => 'mis',
    'mohawk'                        => 'moh',
    'moksha'                        => 'mdf',
    'moldavian'                     => 'mo',
    'mongo'                         => 'lol',
    'mongolian'                     => 'mn',
    'monkhmerlanguage'              => 'mkh',
    'morisyen'                      => 'mfe',
    'mossi'                         => 'mos',
    'multiplelanguages'             => 'mul',
    'mundalanguage'                 => 'mun',
    'mundang'                       => 'mua',
    'nahuatl'                       => 'nah',
    'nama'                          => 'naq',
    'nauru'                         => 'na',
    'navajo'                        => 'nv',
    'ndonga'                        => 'ng',
    'neapolitan'                    => 'nap',
    'nepales'                       => 'ne',
    'newari'                        => 'new',
    'nias'                          => 'nia',
    'nigerkordofanianlanguage'      => 'nic',
    'nilosaharanlanguage'           => 'ssa',
    'niuean'                        => 'niu',
    'nogai'                         => 'nog',
    'nolinguisticcontent'           => 'zxx',
    'northamericanindianlanguage'   => 'nai',
    'northernfrisian'               => 'frr',
    'northernsami'                  => 'se',
    'northernsotho'                 => 'nso',
    'northndebele'                  => 'nd',
    'norwegian'                     => 'no',
    "norwegianbokm\Ã\¥l"          => 'nb',
    'norwegiannynorsk'              => 'nn',
    'nubianlanguage'                => 'nub',
    'nuer'                          => 'nus',
    'nyamwezi'                      => 'nym',
    'nyanja'                        => 'ny',
    'nyankole'                      => 'nyn',
    'nyasatonga'                    => 'tog',
    'nyoro'                         => 'nyo',
    'nzima'                         => 'nzi',
    "n\â\\ko"                  => 'nqo',
    'occitan'                       => 'oc',
    'ojibwa'                        => 'oj',
    'olandes'                       => 'nl',
    'oldenglish'                    => 'ang',
    'oldfrench'                     => 'fro',
    'oldhighgerman'                 => 'goh',
    'oldirish'                      => 'sga',
    'oldnorse'                      => 'non',
    'oldpersian'                    => 'peo',
    "oldproven\Ã\§al"             => 'pro',
    'oriya'                         => 'or',
    'oromo'                         => 'om',
    'osage'                         => 'osa',
    'ossetic'                       => 'os',
    'otomianlanguage'               => 'oto',
    'ottomanturkish'                => 'ota',
    'pahlavi'                       => 'pal',
    'palauan'                       => 'pau',
    'pali'                          => 'pi',
    'pampanga'                      => 'pam',
    'pandjabi'                      => 'pa',
    'pangasinan'                    => 'pag',
    'papiamento'                    => 'pap',
    'papuanlanguage'                => 'paa',
    'persa'                         => 'fa',
    'philippinelanguage'            => 'phi',
    'phoenician'                    => 'phn',
    'pohnpeian'                     => 'pon',
    'portuguesebasedcreoleorpidgin' => 'cpp',
    'prakritlanguage'               => 'pra',
    'pulaku'                        => 'pl',
    'purtuges'                      => 'pt',
    'purtugesbrazileru'             => 'pt_br',
    'purtugeseuropeu'               => 'pt_pt',
    'pushto'                        => 'ps',
    'quechua'                       => 'qu',
    'rajasthani'                    => 'raj',
    'rapanui'                       => 'rap',
    'rarotongan'                    => 'rar',
    'romancelanguage'               => 'roa',
    'romansh'                       => 'rm',
    'romany'                        => 'rom',
    'rombo'                         => 'rof',
    'rumenu'                        => 'ro',
    'rundi'                         => 'rn',
    'rusu'                          => 'ru',
    'rwa'                           => 'rwk',
    'saho'                          => 'ssy',
    'sakha'                         => 'sah',
    'salishanlanguage'              => 'sal',
    'samaritanaramaic'              => 'sam',
    'samburu'                       => 'saq',
    'samilanguage'                  => 'smi',
    'samoan'                        => 'sm',
    'sandawe'                       => 'sad',
    'sango'                         => 'sg',
    'sangu'                         => 'sbp',
    'sanskrit'                      => 'sa',
    'santali'                       => 'sat',
    'sardinian'                     => 'sc',
    'sasak'                         => 'sas',
    'scots'                         => 'sco',
    'scottishgaelic'                => 'gd',
    'selkup'                        => 'sel',
    'semiticlanguage'               => 'sem',
    'sena'                          => 'seh',
    'seneca'                        => 'see',
    'serbian'                       => 'sr',
    'serbocroatian'                 => 'sh',
    'serer'                         => 'srr',
    'shambala'                      => 'ksb',
    'shan'                          => 'shn',
    'shona'                         => 'sn',
    'sichuanyi'                     => 'ii',
    'sicilian'                      => 'scn',
    'sidamo'                        => 'sid',
    'signlanguage'                  => 'sgn',
    'siksika'                       => 'bla',
    'sindhi'                        => 'sd',
    'sinhala'                       => 'si',
    'sinotibetanlanguage'           => 'sit',
    'siouanlanguage'                => 'sio',
    'skoltsami'                     => 'sms',
    'slave'                         => 'den',
    'slaviclanguage'                => 'sla',
    'slovak'                        => 'sk',
    'slovenian'                     => 'sl',
    'soga'                          => 'xog',
    'sogdien'                       => 'sog',
    'somali'                        => 'so',
    'songhai'                       => 'son',
    'soninke'                       => 'snk',
    'sorbianlanguage'               => 'wen',
    'southamericanindianlanguage'   => 'sai',
    'southernaltai'                 => 'alt',
    'southernsami'                  => 'sma',
    'southernsotho'                 => 'st',
    'southndebele'                  => 'nr',
    'spanhol'                       => 'es',
    'spanholeuropeu'                => 'es_es',
    'spanhollatinumerkanu'          => 'es_419',
    'sranantongo'                   => 'srn',
    'sueku'                         => 'sv',
    'sukuma'                        => 'suk',
    'sumerian'                      => 'sux',
    'sundanese'                     => 'su',
    'susu'                          => 'sus',
    'swahili'                       => 'sw',
    'swati'                         => 'ss',
    'swissgerman'                   => 'gsw',
    'syriac'                        => 'syr',
    'tachelhit'                     => 'shi',
    'tagalog'                       => 'tl',
    'tahitian'                      => 'ty',
    'tailandes'                     => 'th',
    'tailanguage'                   => 'tai',
    'taita'                         => 'dav',
    'tajik'                         => 'tg',
    'tamashek'                      => 'tmh',
    'tamil'                         => 'ta',
    'taroko'                        => 'trv',
    'tasawaq'                       => 'twq',
    'tatar'                         => 'tt',
    'telugu'                        => 'te',
    'tereno'                        => 'ter',
    'teso'                          => 'teo',
    'tetum'                         => 'tet',
    'tibetanu'                      => 'bo',
    'tigre'                         => 'tig',
    'tigrinya'                      => 'ti',
    'timne'                         => 'tem',
    'tiv'                           => 'tiv',
    'tlingit'                       => 'tli',
    'tokelau'                       => 'tkl',
    'tokpisin'                      => 'tpi',
    'tonga'                         => 'to',
    'tsimshian'                     => 'tsi',
    'tsonga'                        => 'ts',
    'tswana'                        => 'tn',
    'tumbuka'                       => 'tum',
    'tupilanguage'                  => 'tup',
    'turkmen'                       => 'tk',
    'turku'                         => 'tr',
    'tuvalu'                        => 'tvl',
    'tuvinian'                      => 'tyv',
    'twi'                           => 'tw',
    'txeku'                         => 'cs',
    'tyap'                          => 'kcg',
    'udmurt'                        => 'udm',
    'ugaritic'                      => 'uga',
    'ukranianu'                     => 'uk',
    'umbundu'                       => 'umb',
    'ungaru'                        => 'hu',
    'uppersorbian'                  => 'hsb',
    'urdu'                          => 'ur',
    'uyghur'                        => 'ug',
    'uzbek'                         => 'uz',
    'vai'                           => 'vai',
    'venda'                         => 've',
    'vietnamita'                    => 'vi',
    "volap\Ã\¼k"                  => 'vo',
    'votic'                         => 'vot',
    'vunjo'                         => 'vun',
    'wakashanlanguage'              => 'wak',
    'walamo'                        => 'wal',
    'walloon'                       => 'wa',
    'walser'                        => 'wae',
    'waray'                         => 'war',
    'washo'                         => 'was',
    'westernfrisian'                => 'fy',
    'wolof'                         => 'wo',
    'xhosa'                         => 'xh',
    'xines'                         => 'zh',
    'yangben'                       => 'yav',
    'yao'                           => 'yao',
    'yapese'                        => 'yap',
    'yiddish'                       => 'yi',
    'yupiklanguage'                 => 'ypk',
    'zande'                         => 'znd',
    'zapotec'                       => 'zap',
    'zarma'                         => 'dje',
    'zaza'                          => 'zza',
    'zenaga'                        => 'zen',
    'zhuang'                        => 'za',
    'zulu'                          => 'zu',
    'zuni'                          => 'zun',
);

1;
