# NAME

Catmandu::PICA - Catmandu modules for working with PICA+ data

[![Unix Build Status](https://travis-ci.org/gbv/Catmandu-PICA.svg)](https://travis-ci.org/gbv/Catmandu-PICA)
[![Windows Build status](https://ci.appveyor.com/api/projects/status/myyyxpobr8kn6aby?svg=true)](https://ci.appveyor.com/project/nichtich/catmandu-pica)
[![Coverage Status](https://coveralls.io/repos/gbv/Catmandu-PICA/badge.svg?branch=master)](https://coveralls.io/r/gbv/Catmandu-PICA?branch=master)
[![Kwalitee Score](http://cpants.cpanauthors.org/dist/Catmandu-PICA.png)](http://cpants.cpanauthors.org/dist/Catmandu-PICA)

# DESCRIPTION

Catmandu::PICA provides methods to work with PICA data within the [Catmandu](https://metacpan.org/pod/Catmandu)
framework.  

See [PICA::Data](https://metacpan.org/pod/PICA::Data) for more information about PICA data format and record
structure.

See [Catmandu::Introduction](https://metacpan.org/pod/Catmandu::Introduction) and [http://librecat.org/Catmandu](http://librecat.org/Catmandu) for an
introduction into Catmandu.

# CATMANDU MODULES

- [Catmandu::Exporter::PICA](https://metacpan.org/pod/Catmandu::Exporter::PICA)
- [Catmandu::Fix::Bind::pica\_each](https://metacpan.org/pod/Catmandu::Fix::Bind::pica_each)
- [Catmandu::Fix::Condition::pica\_match](https://metacpan.org/pod/Catmandu::Fix::Condition::pica_match)
- [Catmandu::Fix::pica\_add](https://metacpan.org/pod/Catmandu::Fix::pica_add)
- [Catmandu::Fix::pica\_map](https://metacpan.org/pod/Catmandu::Fix::pica_map)
- [Catmandu::Fix::pica\_set](https://metacpan.org/pod/Catmandu::Fix::pica_set)
- [Catmandu::Importer::PICA](https://metacpan.org/pod/Catmandu::Importer::PICA)
- [Catmandu::Importer::SRU::Parser::picaxml](https://metacpan.org/pod/Catmandu::Importer::SRU::Parser::picaxml)
- [Catmandu::Importer::SRU::Parser::ppxml](https://metacpan.org/pod/Catmandu::Importer::SRU::Parser::ppxml)
- [Catmandu::Validator::PICA](https://metacpan.org/pod/Catmandu::Validator::PICA)

# CONTRIBUTORS

Johann Rolschewski <jorol@cpan.org>

Jakob Voß <voss@gbv.de>

Carsten Klee <klee@cpan.org>

# COPYRIGHT

Copyright 2014- Johann Rolschewski and Jakob Voss

# LICENSE

This library is free software; you can redistribute it and/or modify it under
the same terms as Perl itself.

# SEE ALSO

[PICA::Data](https://metacpan.org/pod/PICA::Data), [Catmandu](https://metacpan.org/pod/Catmandu)
