# This might look like shell script, but it's actually -*- perl -*-
use strict;
use lib 't/';

use TestUtils;
use Test::More qw(no_plan);
use Data::Dumper;

use html::dl;

my @items = 
  ('the pros' => 'never have to worry about service again',
   'the cons' => 'upfront extra charge on purchase',
   'our choice' => 'go with the extended service plan');

my $tree = html::dl->new;
$tree->service_plan(@items);
  
my $generated_html = ptree ($tree, html_dir . 'dl.gen');
is
  (
   $generated_html,
   File::Slurp::read_file(html_dir . 'dl.exp'),
   "dl list created correctly" 
  );


