
#line 1 "src/panda/uri/router/RegexpParse.rl"
#include "Regexp.h"
#include <limits.h>
#include <panda/from_chars.h>

namespace panda { namespace uri { namespace router {


#line 11 "src/panda/uri/router/RegexpParse.cc"
static const int regexp_parser_start = 43;
static const int regexp_parser_first_final = 43;
static const int regexp_parser_error = 0;

static const int regexp_parser_en_group_regexp = 16;
static const int regexp_parser_en_main = 43;


#line 119 "src/panda/uri/router/RegexpParse.rl"


static void assign_literal (string& dst, const char* p, const char* pe) {
    while (p < pe) {
        if (*p == '\\') {
            ++p;
            assert(p < pe);
            if (*p == 'x') {
                assert(p < pe - 2);
                int8_t c;
                auto res = from_chars(p+1, p+3, c, 16);
                assert(!res.ec);
                dst += (char)c;
                p += 3;
                continue;
            }
        }
        dst += *p++;
    }
}

static void maybe_join (std::vector<Regexp::Element>& v) {
    if (v.size() < 2) return;
    auto& e1 = v[v.size()-2];
    auto& e2 = v[v.size()-1];
    if (e1.token.type != Regexp::Token::Type::Literal || e1.token.type != e2.token.type) return;
    if (!e1.quant.is_default() || !e2.quant.is_default()) return;
    e1.token.literal += e2.token.literal;
    v.pop_back();
}

static bool symclass_from_escaped (char c, Regexp::Symclass& s) {
    switch (c) {
        case 'd':
            s.ranges.push_back({'0', '9'});
            return true;
        case 'D':
            s.ranges.push_back({CHAR_MIN, '0' - 1});
            s.ranges.push_back({'9' + 1, CHAR_MAX});
            return true;
        case 'w':
            s.ranges.push_back({'a', 'z'});
            s.ranges.push_back({'A', 'Z'});
            s.ranges.push_back({'0', '9'});
            s.chars += '_';
            return true;
        case 'W':
            s.ranges.push_back({CHAR_MIN, '0' - 1});
            s.ranges.push_back({'9' + 1, 'A' - 1});
            s.ranges.push_back({'Z' + 1, '_' - 1});
            s.ranges.push_back({'_' + 1, 'a' - 1});
            s.ranges.push_back({'z' + 1, CHAR_MAX});
            return true;
        case 't':
            s.chars += "\t\v";
            return true;
        case 'n':
            s.chars += "\n";
            return true;
        case 'r':
            s.chars += "\r";
            return true;
        case 's':
            s.chars += " \n\r\t\v";
            return true;
        case 'S':
            s.ranges.push_back({CHAR_MIN, '\t' - 1});
            s.ranges.push_back({'\n' + 1, '\r' - 1});
            s.ranges.push_back({'\r' + 1, ' ' - 1});
            s.ranges.push_back({' ' + 1, '\v' - 1});
            s.ranges.push_back({'\v' + 1, CHAR_MAX});
            return true;
    }
    return false;
}

static void parse_symclass (string_view str, Regexp::Symclass& s) {
    //printf("parse symclass: %s\n", string(str).c_str());
    auto p = str.data();
    auto pe = p + str.length();
    
    if (p != pe && *p == '^') {
        s.inverse = true;
        ++p;
    }

    if (p == pe) throw std::logic_error("empty symclass");

    bool has_char_after_range = false;
    while (p < pe) {
        if (*p == '-' && has_char_after_range && (p+1) < pe) {
            s.ranges.push_back({s.chars.back(), *++p});
            s.chars.pop_back();
            has_char_after_range = false;
        } else if (*p == '\\') {
            ++p;
            assert(p < pe);
            if (!symclass_from_escaped(*p, s)) {
                s.chars.push_back(*p);
                has_char_after_range = true;
            }
        } else {
            s.chars.push_back(*p);
            has_char_after_range = true;
        }
        ++p;
    }
}

RegexpPtr Regexp::parse (string_view str) {
    const char* ps  = str.data();
    const char* p   = ps;
    const char* pe  = p + str.length();
    const char* eof = pe;
    int         cs  = regexp_parser_start;
    int         top = 0;
    std::vector<int> stack;
    stack.resize(8);

    const char* mark = nullptr;
    int num[2];

    auto ret = std::make_unique<Regexp>();

    struct Data {
        Regexp*             re;
        Regexp::Expression* expression = nullptr;
        Regexp::Element*    element    = nullptr;
    };

    std::vector<Data> data_stack = {{ret.get()}};
    auto data = &data_stack.back();
    
    auto nsave = [&](int& dest) {
        auto res = from_chars(mark, p, dest);
        assert(!res.ec);
    };
    
    
#line 160 "src/panda/uri/router/RegexpParse.cc"
	{
	if ( p == pe )
		goto _test_eof;
	goto _resume;

_again:
	switch ( cs ) {
		case 43: goto st43;
		case 44: goto st44;
		case 45: goto st45;
		case 0: goto st0;
		case 46: goto st46;
		case 47: goto st47;
		case 48: goto st48;
		case 1: goto st1;
		case 2: goto st2;
		case 3: goto st3;
		case 4: goto st4;
		case 5: goto st5;
		case 6: goto st6;
		case 49: goto st49;
		case 50: goto st50;
		case 7: goto st7;
		case 8: goto st8;
		case 9: goto st9;
		case 10: goto st10;
		case 51: goto st51;
		case 11: goto st11;
		case 12: goto st12;
		case 13: goto st13;
		case 52: goto st52;
		case 53: goto st53;
		case 54: goto st54;
		case 14: goto st14;
		case 15: goto st15;
		case 16: goto st16;
		case 17: goto st17;
		case 18: goto st18;
		case 55: goto st55;
		case 19: goto st19;
		case 20: goto st20;
		case 21: goto st21;
		case 22: goto st22;
		case 23: goto st23;
		case 24: goto st24;
		case 25: goto st25;
		case 26: goto st26;
		case 27: goto st27;
		case 28: goto st28;
		case 29: goto st29;
		case 30: goto st30;
		case 31: goto st31;
		case 32: goto st32;
		case 33: goto st33;
		case 34: goto st34;
		case 35: goto st35;
		case 36: goto st36;
		case 37: goto st37;
		case 38: goto st38;
		case 39: goto st39;
		case 40: goto st40;
		case 41: goto st41;
		case 42: goto st42;
	default: break;
	}

	if ( ++p == pe )
		goto _test_eof;
_resume:
	switch ( cs )
	{
st43:
	if ( ++p == pe )
		goto _test_eof43;
case 43:
	switch( (*p) ) {
		case 40: goto tr12;
		case 46: goto tr13;
		case 63: goto st0;
		case 91: goto tr14;
		case 92: goto tr15;
		case 93: goto st0;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr11;
tr11:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr151:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr161:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr171:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr177:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr187:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr193:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr203:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr209:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr215:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr221:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
tr227:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st44;
st44:
	if ( ++p == pe )
		goto _test_eof44;
case 44:
#line 513 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr152;
		case 41: goto st0;
		case 42: goto tr153;
		case 43: goto tr154;
		case 46: goto tr155;
		case 63: goto tr156;
		case 91: goto tr157;
		case 92: goto tr158;
		case 93: goto st0;
		case 123: goto tr159;
		case 124: goto tr160;
		case 125: goto st0;
	}
	goto tr151;
tr5:
#line 38 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        parse_symclass(string_view(mark, p - mark), data->element->token.symclass);
    }
	goto st45;
tr12:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr152:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr162:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr172:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr178:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr188:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr194:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr204:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr210:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr216:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr222:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
tr228:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 45;goto st16;}
    }
	goto st45;
st45:
	if ( ++p == pe )
		goto _test_eof45;
case 45:
#line 919 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr162;
		case 41: goto st0;
		case 42: goto st46;
		case 43: goto st48;
		case 46: goto tr165;
		case 63: goto st50;
		case 91: goto tr167;
		case 92: goto tr168;
		case 93: goto st0;
		case 123: goto st8;
		case 124: goto tr170;
		case 125: goto st0;
	}
	goto tr161;
st0:
cs = 0;
	goto _out;
tr153:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st46;
tr179:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st46;
tr195:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st46;
st46:
	if ( ++p == pe )
		goto _test_eof46;
case 46:
#line 968 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr172;
		case 46: goto tr173;
		case 63: goto st0;
		case 91: goto tr174;
		case 92: goto tr175;
		case 93: goto st0;
		case 124: goto tr176;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr171;
tr13:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr155:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr165:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr173:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr181:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr189:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr197:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr205:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr211:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr217:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr223:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
tr229:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st47;
st47:
	if ( ++p == pe )
		goto _test_eof47;
case 47:
#line 1199 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr178;
		case 41: goto st0;
		case 42: goto tr179;
		case 43: goto tr180;
		case 46: goto tr181;
		case 63: goto tr182;
		case 91: goto tr183;
		case 92: goto tr184;
		case 93: goto st0;
		case 123: goto tr185;
		case 124: goto tr186;
		case 125: goto st0;
	}
	goto tr177;
tr154:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st48;
tr180:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st48;
tr196:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st48;
st48:
	if ( ++p == pe )
		goto _test_eof48;
case 48:
#line 1245 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr188;
		case 46: goto tr189;
		case 63: goto st0;
		case 91: goto tr190;
		case 92: goto tr191;
		case 93: goto st0;
		case 124: goto tr192;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr187;
tr14:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr157:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr167:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr174:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr183:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr190:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr199:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr206:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr212:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr218:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr224:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
tr230:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st1;
st1:
	if ( ++p == pe )
		goto _test_eof1;
case 1:
#line 1476 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 92: goto tr1;
		case 93: goto st0;
	}
	goto tr0;
tr0:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st2;
st2:
	if ( ++p == pe )
		goto _test_eof2;
case 2:
#line 1492 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 92: goto st3;
		case 93: goto tr5;
	}
	goto st2;
tr1:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st3;
st3:
	if ( ++p == pe )
		goto _test_eof3;
case 3:
#line 1508 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 120 )
		goto st4;
	goto st2;
st4:
	if ( ++p == pe )
		goto _test_eof4;
case 4:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st5;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st5;
	} else
		goto st5;
	goto st0;
st5:
	if ( ++p == pe )
		goto _test_eof5;
case 5:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st2;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st2;
	} else
		goto st2;
	goto st0;
tr15:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr158:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr168:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr175:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr184:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr191:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr200:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr207:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr213:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr219:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr225:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
tr231:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st6;
st6:
	if ( ++p == pe )
		goto _test_eof6;
case 6:
#line 1801 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 68: goto st49;
		case 83: goto st49;
		case 87: goto st49;
		case 100: goto st49;
		case 110: goto st49;
		case 119: goto st49;
		case 120: goto st14;
	}
	if ( 114 <= (*p) && (*p) <= 116 )
		goto st49;
	goto st44;
st49:
	if ( ++p == pe )
		goto _test_eof49;
case 49:
	switch( (*p) ) {
		case 40: goto tr194;
		case 41: goto st0;
		case 42: goto tr195;
		case 43: goto tr196;
		case 46: goto tr197;
		case 63: goto tr198;
		case 91: goto tr199;
		case 92: goto tr200;
		case 93: goto st0;
		case 123: goto tr201;
		case 124: goto tr202;
		case 125: goto st0;
	}
	goto tr193;
tr156:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st50;
tr182:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st50;
tr198:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st50;
st50:
	if ( ++p == pe )
		goto _test_eof50;
case 50:
#line 1863 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr204;
		case 46: goto tr205;
		case 63: goto st0;
		case 91: goto tr206;
		case 92: goto tr207;
		case 93: goto st0;
		case 124: goto tr208;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr203;
tr160:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr170:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr176:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr186:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr192:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr202:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr208:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr214:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr220:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr226:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
tr232:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st7;
st7:
	if ( ++p == pe )
		goto _test_eof7;
case 7:
#line 2071 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr12;
		case 46: goto tr13;
		case 63: goto st0;
		case 91: goto tr14;
		case 92: goto tr15;
		case 93: goto st0;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr11;
tr159:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st8;
tr185:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st8;
tr201:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st8;
st8:
	if ( ++p == pe )
		goto _test_eof8;
case 8:
#line 2116 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 44 )
		goto st9;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr17;
	goto st0;
st9:
	if ( ++p == pe )
		goto _test_eof9;
case 9:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr18;
	goto st0;
tr18:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st10;
st10:
	if ( ++p == pe )
		goto _test_eof10;
case 10:
#line 2139 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 125 )
		goto tr20;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st10;
	goto st0;
tr20:
#line 96 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[1]); }
	goto st51;
st51:
	if ( ++p == pe )
		goto _test_eof51;
case 51:
#line 2153 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr210;
		case 46: goto tr211;
		case 63: goto st0;
		case 91: goto tr212;
		case 92: goto tr213;
		case 93: goto st0;
		case 124: goto tr214;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr209;
tr17:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st11;
st11:
	if ( ++p == pe )
		goto _test_eof11;
case 11:
#line 2179 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 44: goto tr21;
		case 125: goto tr23;
	}
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st11;
	goto st0;
tr21:
#line 95 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[0]); }
	goto st12;
st12:
	if ( ++p == pe )
		goto _test_eof12;
case 12:
#line 2195 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 125 )
		goto st53;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr24;
	goto st0;
tr24:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st13;
st13:
	if ( ++p == pe )
		goto _test_eof13;
case 13:
#line 2211 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 125 )
		goto tr27;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st13;
	goto st0;
tr27:
#line 96 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[1]); }
	goto st52;
st52:
	if ( ++p == pe )
		goto _test_eof52;
case 52:
#line 2225 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr216;
		case 46: goto tr217;
		case 63: goto st0;
		case 91: goto tr218;
		case 92: goto tr219;
		case 93: goto st0;
		case 124: goto tr220;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr215;
st53:
	if ( ++p == pe )
		goto _test_eof53;
case 53:
	switch( (*p) ) {
		case 40: goto tr222;
		case 46: goto tr223;
		case 63: goto st0;
		case 91: goto tr224;
		case 92: goto tr225;
		case 93: goto st0;
		case 124: goto tr226;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr221;
tr23:
#line 95 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[0]); }
	goto st54;
st54:
	if ( ++p == pe )
		goto _test_eof54;
case 54:
#line 2268 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr228;
		case 46: goto tr229;
		case 63: goto st0;
		case 91: goto tr230;
		case 92: goto tr231;
		case 93: goto st0;
		case 124: goto tr232;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr227;
st14:
	if ( ++p == pe )
		goto _test_eof14;
case 14:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st15;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st15;
	} else
		goto st15;
	goto st0;
st15:
	if ( ++p == pe )
		goto _test_eof15;
case 15:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st44;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st44;
	} else
		goto st44;
	goto st0;
st16:
	if ( ++p == pe )
		goto _test_eof16;
case 16:
	switch( (*p) ) {
		case 40: goto tr30;
		case 41: goto tr31;
		case 46: goto tr32;
		case 63: goto st0;
		case 91: goto tr33;
		case 92: goto tr34;
		case 93: goto st0;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr29;
tr29:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr35:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr46:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr57:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr64:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr75:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr92:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr103:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr115:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr129:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr136:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
tr143:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st17;
st17:
	if ( ++p == pe )
		goto _test_eof17;
case 17:
#line 2592 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr36;
		case 41: goto tr37;
		case 42: goto tr38;
		case 43: goto tr39;
		case 46: goto tr40;
		case 63: goto tr41;
		case 91: goto tr42;
		case 92: goto tr43;
		case 93: goto st0;
		case 123: goto tr44;
		case 124: goto tr45;
		case 125: goto st0;
	}
	goto tr35;
tr86:
#line 38 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        parse_symclass(string_view(mark, p - mark), data->element->token.symclass);
    }
	goto st18;
tr30:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr36:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr47:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr58:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr65:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr76:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr93:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr104:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr116:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr130:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr137:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
tr144:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 58 "src/panda/uri/router/RegexpParse.rl"
	{
        if (p < pe-2 && p[1] == '?' && p[2] == ':') { 
            data->element->token.type = Regexp::Token::Type::Group;
            p += 2;
        } else {
            data->element->token.type = Regexp::Token::Type::Capture;
        }
        data->element->token.regexp = std::make_unique<Regexp>();
        data_stack.push_back({data->element->token.regexp.get()});
        data = &data_stack.back();
        stack.resize(top+1);
        {stack[top++] = 18;goto st16;}
    }
	goto st18;
st18:
	if ( ++p == pe )
		goto _test_eof18;
case 18:
#line 2998 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr47;
		case 41: goto tr48;
		case 42: goto st19;
		case 43: goto st21;
		case 46: goto tr51;
		case 63: goto st29;
		case 91: goto tr53;
		case 92: goto tr54;
		case 93: goto st0;
		case 123: goto st31;
		case 124: goto tr56;
		case 125: goto st0;
	}
	goto tr46;
tr31:
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr37:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr48:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr59:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr66:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr77:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr94:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr105:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr117:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr131:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr138:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
tr145:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
#line 72 "src/panda/uri/router/RegexpParse.rl"
	{
        data_stack.pop_back();
        data = &data_stack.back();
        stack.pop_back();
        {cs = stack[--top];goto _again;}
    }
	goto st55;
st55:
	if ( ++p == pe )
		goto _test_eof55;
case 55:
#line 3292 "src/panda/uri/router/RegexpParse.cc"
	goto st0;
tr38:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st19;
tr67:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st19;
tr95:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st19;
st19:
	if ( ++p == pe )
		goto _test_eof19;
case 19:
#line 3324 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr58;
		case 41: goto tr59;
		case 46: goto tr60;
		case 63: goto st0;
		case 91: goto tr61;
		case 92: goto tr62;
		case 93: goto st0;
		case 124: goto tr63;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr57;
tr32:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr40:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr51:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr60:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr69:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr78:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr97:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr106:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr118:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr132:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr139:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
tr146:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st20;
st20:
	if ( ++p == pe )
		goto _test_eof20;
case 20:
#line 3556 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr65;
		case 41: goto tr66;
		case 42: goto tr67;
		case 43: goto tr68;
		case 46: goto tr69;
		case 63: goto tr70;
		case 91: goto tr71;
		case 92: goto tr72;
		case 93: goto st0;
		case 123: goto tr73;
		case 124: goto tr74;
		case 125: goto st0;
	}
	goto tr64;
tr39:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st21;
tr68:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st21;
tr96:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st21;
st21:
	if ( ++p == pe )
		goto _test_eof21;
case 21:
#line 3602 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr76;
		case 41: goto tr77;
		case 46: goto tr78;
		case 63: goto st0;
		case 91: goto tr79;
		case 92: goto tr80;
		case 93: goto st0;
		case 124: goto tr81;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr75;
tr33:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr42:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr53:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr61:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr71:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr79:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr99:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr107:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr119:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr133:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr140:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
tr147:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
	goto st22;
st22:
	if ( ++p == pe )
		goto _test_eof22;
case 22:
#line 3834 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 92: goto tr83;
		case 93: goto st0;
	}
	goto tr82;
tr82:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st23;
st23:
	if ( ++p == pe )
		goto _test_eof23;
case 23:
#line 3850 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 92: goto st24;
		case 93: goto tr86;
	}
	goto st23;
tr83:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st24;
st24:
	if ( ++p == pe )
		goto _test_eof24;
case 24:
#line 3866 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 120 )
		goto st25;
	goto st23;
st25:
	if ( ++p == pe )
		goto _test_eof25;
case 25:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st26;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st26;
	} else
		goto st26;
	goto st0;
st26:
	if ( ++p == pe )
		goto _test_eof26;
case 26:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st23;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st23;
	} else
		goto st23;
	goto st0;
tr34:
#line 14 "src/panda/uri/router/RegexpParse.rl"
	{
        data->re->expressions.push_back({});
        data->expression = &data->re->expressions.back();
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr43:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr54:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr62:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr72:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr80:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr100:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr108:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr120:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr134:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr141:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
tr148:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 23 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression->elements.push_back({});
        data->element = &data->expression->elements.back();
    }
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st27;
st27:
	if ( ++p == pe )
		goto _test_eof27;
case 27:
#line 4159 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 68: goto st28;
		case 83: goto st28;
		case 87: goto st28;
		case 100: goto st28;
		case 110: goto st28;
		case 119: goto st28;
		case 120: goto st41;
	}
	if ( 114 <= (*p) && (*p) <= 116 )
		goto st28;
	goto st17;
st28:
	if ( ++p == pe )
		goto _test_eof28;
case 28:
	switch( (*p) ) {
		case 40: goto tr93;
		case 41: goto tr94;
		case 42: goto tr95;
		case 43: goto tr96;
		case 46: goto tr97;
		case 63: goto tr98;
		case 91: goto tr99;
		case 92: goto tr100;
		case 93: goto st0;
		case 123: goto tr101;
		case 124: goto tr102;
		case 125: goto st0;
	}
	goto tr92;
tr41:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st29;
tr70:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st29;
tr98:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st29;
st29:
	if ( ++p == pe )
		goto _test_eof29;
case 29:
#line 4221 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr104;
		case 41: goto tr105;
		case 46: goto tr106;
		case 63: goto st0;
		case 91: goto tr107;
		case 92: goto tr108;
		case 93: goto st0;
		case 124: goto tr109;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr103;
tr45:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr56:
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr63:
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr74:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr81:
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr102:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr109:
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr121:
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr135:
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr142:
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
tr149:
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	goto st30;
st30:
	if ( ++p == pe )
		goto _test_eof30;
case 30:
#line 4430 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr30;
		case 46: goto tr32;
		case 63: goto st0;
		case 91: goto tr33;
		case 92: goto tr34;
		case 93: goto st0;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 41 )
		goto st0;
	goto tr29;
tr44:
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
	goto st31;
tr73:
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
	goto st31;
tr101:
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
	goto st31;
st31:
	if ( ++p == pe )
		goto _test_eof31;
case 31:
#line 4475 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 44 )
		goto st32;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr111;
	goto st0;
st32:
	if ( ++p == pe )
		goto _test_eof32;
case 32:
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr112;
	goto st0;
tr112:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st33;
st33:
	if ( ++p == pe )
		goto _test_eof33;
case 33:
#line 4498 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 125 )
		goto tr114;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st33;
	goto st0;
tr114:
#line 96 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[1]); }
	goto st34;
st34:
	if ( ++p == pe )
		goto _test_eof34;
case 34:
#line 4512 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr116;
		case 41: goto tr117;
		case 46: goto tr118;
		case 63: goto st0;
		case 91: goto tr119;
		case 92: goto tr120;
		case 93: goto st0;
		case 124: goto tr121;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr115;
tr111:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st35;
st35:
	if ( ++p == pe )
		goto _test_eof35;
case 35:
#line 4539 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 44: goto tr122;
		case 125: goto tr124;
	}
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st35;
	goto st0;
tr122:
#line 95 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[0]); }
	goto st36;
st36:
	if ( ++p == pe )
		goto _test_eof36;
case 36:
#line 4555 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 125 )
		goto st39;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto tr125;
	goto st0;
tr125:
#line 10 "src/panda/uri/router/RegexpParse.rl"
	{
        mark = p;
    }
	goto st37;
st37:
	if ( ++p == pe )
		goto _test_eof37;
case 37:
#line 4571 "src/panda/uri/router/RegexpParse.cc"
	if ( (*p) == 125 )
		goto tr128;
	if ( 48 <= (*p) && (*p) <= 57 )
		goto st37;
	goto st0;
tr128:
#line 96 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[1]); }
	goto st38;
st38:
	if ( ++p == pe )
		goto _test_eof38;
case 38:
#line 4585 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr130;
		case 41: goto tr131;
		case 46: goto tr132;
		case 63: goto st0;
		case 91: goto tr133;
		case 92: goto tr134;
		case 93: goto st0;
		case 124: goto tr135;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr129;
st39:
	if ( ++p == pe )
		goto _test_eof39;
case 39:
	switch( (*p) ) {
		case 40: goto tr137;
		case 41: goto tr138;
		case 46: goto tr139;
		case 63: goto st0;
		case 91: goto tr140;
		case 92: goto tr141;
		case 93: goto st0;
		case 124: goto tr142;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr136;
tr124:
#line 95 "src/panda/uri/router/RegexpParse.rl"
	{ nsave(num[0]); }
	goto st40;
st40:
	if ( ++p == pe )
		goto _test_eof40;
case 40:
#line 4630 "src/panda/uri/router/RegexpParse.cc"
	switch( (*p) ) {
		case 40: goto tr144;
		case 41: goto tr145;
		case 46: goto tr146;
		case 63: goto st0;
		case 91: goto tr147;
		case 92: goto tr148;
		case 93: goto st0;
		case 124: goto tr149;
	}
	if ( (*p) > 43 ) {
		if ( 123 <= (*p) && (*p) <= 125 )
			goto st0;
	} else if ( (*p) >= 42 )
		goto st0;
	goto tr143;
st41:
	if ( ++p == pe )
		goto _test_eof41;
case 41:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st42;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st42;
	} else
		goto st42;
	goto st0;
st42:
	if ( ++p == pe )
		goto _test_eof42;
case 42:
	if ( (*p) < 65 ) {
		if ( 48 <= (*p) && (*p) <= 57 )
			goto st17;
	} else if ( (*p) > 70 ) {
		if ( 97 <= (*p) && (*p) <= 102 )
			goto st17;
	} else
		goto st17;
	goto st0;
	}
	_test_eof43: cs = 43; goto _test_eof; 
	_test_eof44: cs = 44; goto _test_eof; 
	_test_eof45: cs = 45; goto _test_eof; 
	_test_eof46: cs = 46; goto _test_eof; 
	_test_eof47: cs = 47; goto _test_eof; 
	_test_eof48: cs = 48; goto _test_eof; 
	_test_eof1: cs = 1; goto _test_eof; 
	_test_eof2: cs = 2; goto _test_eof; 
	_test_eof3: cs = 3; goto _test_eof; 
	_test_eof4: cs = 4; goto _test_eof; 
	_test_eof5: cs = 5; goto _test_eof; 
	_test_eof6: cs = 6; goto _test_eof; 
	_test_eof49: cs = 49; goto _test_eof; 
	_test_eof50: cs = 50; goto _test_eof; 
	_test_eof7: cs = 7; goto _test_eof; 
	_test_eof8: cs = 8; goto _test_eof; 
	_test_eof9: cs = 9; goto _test_eof; 
	_test_eof10: cs = 10; goto _test_eof; 
	_test_eof51: cs = 51; goto _test_eof; 
	_test_eof11: cs = 11; goto _test_eof; 
	_test_eof12: cs = 12; goto _test_eof; 
	_test_eof13: cs = 13; goto _test_eof; 
	_test_eof52: cs = 52; goto _test_eof; 
	_test_eof53: cs = 53; goto _test_eof; 
	_test_eof54: cs = 54; goto _test_eof; 
	_test_eof14: cs = 14; goto _test_eof; 
	_test_eof15: cs = 15; goto _test_eof; 
	_test_eof16: cs = 16; goto _test_eof; 
	_test_eof17: cs = 17; goto _test_eof; 
	_test_eof18: cs = 18; goto _test_eof; 
	_test_eof55: cs = 55; goto _test_eof; 
	_test_eof19: cs = 19; goto _test_eof; 
	_test_eof20: cs = 20; goto _test_eof; 
	_test_eof21: cs = 21; goto _test_eof; 
	_test_eof22: cs = 22; goto _test_eof; 
	_test_eof23: cs = 23; goto _test_eof; 
	_test_eof24: cs = 24; goto _test_eof; 
	_test_eof25: cs = 25; goto _test_eof; 
	_test_eof26: cs = 26; goto _test_eof; 
	_test_eof27: cs = 27; goto _test_eof; 
	_test_eof28: cs = 28; goto _test_eof; 
	_test_eof29: cs = 29; goto _test_eof; 
	_test_eof30: cs = 30; goto _test_eof; 
	_test_eof31: cs = 31; goto _test_eof; 
	_test_eof32: cs = 32; goto _test_eof; 
	_test_eof33: cs = 33; goto _test_eof; 
	_test_eof34: cs = 34; goto _test_eof; 
	_test_eof35: cs = 35; goto _test_eof; 
	_test_eof36: cs = 36; goto _test_eof; 
	_test_eof37: cs = 37; goto _test_eof; 
	_test_eof38: cs = 38; goto _test_eof; 
	_test_eof39: cs = 39; goto _test_eof; 
	_test_eof40: cs = 40; goto _test_eof; 
	_test_eof41: cs = 41; goto _test_eof; 
	_test_eof42: cs = 42; goto _test_eof; 

	_test_eof: {}
	if ( p == eof )
	{
	switch ( cs ) {
	case 45: 
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 44: 
#line 33 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Literal;
        assign_literal(data->element->token.literal, mark, p);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 47: 
#line 43 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        switch (*(p-1)) {
            case '.':
                data->element->token.symclass.ranges.push_back({CHAR_MIN, CHAR_MAX});
                break;
        }
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 49: 
#line 52 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->token.type = Regexp::Token::Type::Symclass;
        auto is_special = symclass_from_escaped(*(p-1), data->element->token.symclass);
        assert(is_special);
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 52: 
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 50: 
#line 92 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = 1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 46: 
#line 93 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 48: 
#line 94 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 1; num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 54: 
#line 97 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = num[0]; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 51: 
#line 98 "src/panda/uri/router/RegexpParse.rl"
	{ num[0] = 0; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
	case 53: 
#line 99 "src/panda/uri/router/RegexpParse.rl"
	{ num[1] = -1; }
#line 79 "src/panda/uri/router/RegexpParse.rl"
	{
        data->element->quant.min = num[0];
        data->element->quant.max = num[1];
    }
#line 28 "src/panda/uri/router/RegexpParse.rl"
	{
        maybe_join(data->expression->elements);
        data->element = nullptr;
    }
#line 19 "src/panda/uri/router/RegexpParse.rl"
	{
        data->expression = nullptr;
    }
	break;
#line 4922 "src/panda/uri/router/RegexpParse.cc"
	}
	}

	_out: {}
	}

#line 258 "src/panda/uri/router/RegexpParse.rl"
    
    if (cs < regexp_parser_first_final) {
        throw std::logic_error("bad regexp");
    }

    return ret;
}

}}}