package TableData::Software::License::FromRPL;

use strict;

use Role::Tiny::With;
with 'TableDataRole::Source::CSVInDATA';

our $AUTHORITY = 'cpan:PERLANCAR'; # AUTHORITY
our $DATE = '2022-07-27'; # DATE
our $DIST = 'TableDataBundle-Software-License'; # DIST
our $VERSION = '0.002'; # VERSION

1;
# ABSTRACT: List of software license from Regexp::Pattern::License

=pod

=encoding UTF-8

=head1 NAME

TableData::Software::License::FromRPL - List of software license from Regexp::Pattern::License

=head1 VERSION

This document describes version 0.002 of TableData::Software::License::FromRPL (from Perl distribution TableDataBundle-Software-License), released on 2022-07-27.

=head1 HOMEPAGE

Please visit the project's homepage at L<https://metacpan.org/release/TableDataBundle-Software-License>.

=head1 SOURCE

Source repository is at L<https://github.com/perlancar/perl-TableDataBundle-Software-License>.

=head1 SEE ALSO

=head1 AUTHOR

perlancar <perlancar@cpan.org>

=head1 CONTRIBUTING


To contribute, you can send patches by email/via RT, or send pull requests on
GitHub.

Most of the time, you don't need to build the distribution yourself. You can
simply modify the code, then test via:

 % prove -l

If you want to build the distribution (e.g. to try to install it locally on your
system), you can install L<Dist::Zilla>,
L<Dist::Zilla::PluginBundle::Author::PERLANCAR>, and sometimes one or two other
Dist::Zilla plugin and/or Pod::Weaver::Plugin. Any additional steps required
beyond that are considered a bug and can be reported to me.

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2022 by perlancar <perlancar@cpan.org>.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 BUGS

Please report any bugs or feature requests on the bugtracker website L<https://rt.cpan.org/Public/Dist/Display.html?Name=TableDataBundle-Software-License>

When submitting a bug or request, please include a test-file or a
patch to an existing test-file that illustrates the bug or desired
feature.

=cut

__DATA__
name,summary
"AAL","Attribution Assurance License"
"Abstyles","Abstyles License"
"Adobe-2006","Adobe Systems Incorporated Source Code License Agreement"
"Adobe-Glyph","Adobe Glyph List License"
"ADSL","Amazon Digital Services License"
"AFL","Academic Free License"
"AFL-1.1","Academic Free License Version v1.1"
"AFL-1.2","Academic Free License Version v1.2"
"AFL-2.0","Academic Free License Version v2.0"
"AFL-2.1","Academic Free License Version v2.1"
"AFL-3.0","Academic Free License version 3.0"
"Afmparse","Afmparse License"
"AGPL","GNU Affero General Public License"
"AGPLv1","Affero General Public License, Version 1"
"AGPL-1.0-only","Affero General Public License v1.0 only"
"AGPL-1.0-or-later","Affero General Public License v1.0 or later"
"AGPLv2","Affero General Public License, Version 2"
"AGPLv3","GNU Affero General Public License, Version 3"
"AGPL-3.0-only","GNU Affero General Public License v3.0 only"
"AGPL-3.0-or-later","GNU Affero General Public License v3.0 or later"
"Aladdin","Aladdin Free Public License"
"Aladdin-8","Aladdin Free Public License, Version 8"
"Aladdin-9","Aladdin Free Public License, Version 9"
"AMDPLPA","AMD's plpa_map.c License"
"AML","Apple MIT License"
"AMPAS","Academy of Motion Picture Arts and Sciences BSD"
"ANTAL-PD","ANTLR Software Rights Notice"
"Apache","Apache License"
"Apache-1.0","Apache License 1.0"
"Apache-1.1","Apache License 1.1"
"Apache-2.0","Apache License 2.0"
"APAFML","Adobe Postscript AFM License"
"APL","Adaptive Public License"
"APL-1.0","Adaptive Public License 1.0"
"APSL","Apple Public Source License"
"APSL-1.0","Apple Public Source License 1.0"
"APSL-1.1","Apple Public Source License 1.1"
"APSL-1.2","Apple Public Source License 1.2"
"APSL-2.0","Apple Public Source License 2.0"
"Artistic","Artistic License"
"Artistic-1.0","Artistic License, version 1.0"
"Artistic-1.0-clarified","Clarified Artistic License"
"Artistic-1.0-Perl","Artistic License 1.0 (Perl)"
"Artistic-2.0","Artistic License (v2.0)"
"Bahyph","Bahyph License"
"Barr","Barr License"
"Beerware","Beerware License"
"BitTorrent","BitTorrent Open Source License"
"BitTorrent-1.0","BitTorrent Open Source License v1.0"
"BitTorrent-1.1","BitTorrent Open Source License v1.1"
"Borceux","Borceux license"
"BSD","BSD license"
"0BSD","BSD (0 clause)"
"BSD-2-Clause","BSD (2 clause)"
"BSD-3-Clause","BSD (3 clause)"
"BSD-4-Clause","BSD (4 clause)"
"BSL","Boost Software License"
"BSL-1.0","Boost Software License 1.0"
"bzip2","bzip2 and libbzip2 License"
"bzip2-1.0.5","bzip2 and libbzip2 License v1.0.5"
"bzip2-1.0.6","bzip2 and libbzip2 License v1.0.6"
"CAL","Cryptographic Autonomy License"
"CAL-1.0","Cryptographic Autonomy License 1.0"
"Caldera","BSD Source Caldera License"
"CATOSL","Computer Associates Trusted Open Source License"
"CATOSL-1.1","Computer Associates Trusted Open Source License 1.1"
"CC-BY","Creative Commons Attribution Public License"
"CC-BY-1.0","Creative Commons Attribution 1.0 Generic License"
"CC-BY-2.0","Creative Commons Attribution 2.0 Generic License"
"CC-BY-2.5","Creative Commons Attribution 2.5 Generic License"
"CC-BY-3.0","Creative Commons Attribution 3.0 Unported License"
"CC-BY-4.0","Creative Commons Attribution 4.0 International License"
"CC-BY-NC","Creative Commons Attribution-NonCommercial Public License"
"CC-BY-NC-1.0","Creative Commons Attribution-NonCommercial 1.0 Generic License"
"CC-BY-NC-2.0","Creative Commons Attribution-NonCommercial 2.0 Generic License"
"CC-BY-NC-2.5","Creative Commons Attribution-NonCommercial 2.5 Generic License"
"CC-BY-NC-3.0","Creative Commons Attribution-NonCommercial 3.0 Unported License"
"CC-BY-NC-4.0","Creative Commons Attribution-NonCommercial 4.0 International License"
"CC-BY-NC-ND","Creative Commons Attribution-NonCommercial-NoDerivatives Public License"
"CC-BY-NC-ND-1.0","Creative Commons Attribution-NoDerivs-NonCommercial 1.0 Generic License"
"CC-BY-NC-ND-2.0","Creative Commons Attribution-NonCommercial-NoDerivs 2.0 Generic License"
"CC-BY-NC-ND-2.5","Creative Commons Attribution-NonCommercial-NoDerivs 2.5 Generic License"
"CC-BY-NC-ND-3.0","Creative Commons Attribution-NonCommercial-NoDerivs 3.0 Unported License"
"CC-BY-NC-ND-4.0","Creative Commons Attribution-NonCommercial-NoDerivatives 4.0 International License"
"CC-BY-NC-SA","Creative Commons Attribution-NonCommercial-ShareAlike Public License"
"CC-BY-NC-SA-1.0","Creative Commons Attribution-NonCommercial-ShareAlike 1.0 Generic License"
"CC-BY-NC-SA-2.0","Creative Commons Attribution-NonCommercial-ShareAlike 2.0 Generic License"
"CC-BY-NC-SA-2.5","Creative Commons Attribution-NonCommercial-ShareAlike 2.5 Generic License"
"CC-BY-NC-SA-3.0","Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License"
"CC-BY-NC-SA-4.0","Creative Commons Attribution-NonCommercial-ShareAlike 4.0 International License"
"CC-BY-ND","Creative Commons Attribution-NoDerivatives Public License"
"CC-BY-ND-1.0","Creative Commons Attribution-NoDerivs 1.0 Generic License"
"CC-BY-ND-2.0","Creative Commons Attribution-NoDerivs 2.0 Generic License"
"CC-BY-ND-2.5","Creative Commons Attribution-NoDerivs 2.5 Generic License"
"CC-BY-ND-3.0","Creative Commons Attribution-NoDerivs 3.0 Unported License"
"CC-BY-ND-4.0","Creative Commons Attribution-NoDerivatives 4.0 International License"
"CC-BY-SA","Creative Commons Attribution-ShareAlike Public License"
"CC-BY-SA-1.0","Creative Commons Attribution-ShareAlike 1.0 Generic License"
"CC-BY-SA-2.0","Creative Commons Attribution-ShareAlike 2.0 Generic License"
"CC-BY-SA-2.5","Creative Commons Attribution-ShareAlike 2.5 Generic License"
"CC-BY-SA-3.0","Creative Commons Attribution-ShareAlike 3.0 Unported License"
"CC-BY-SA-4.0","Creative Commons Attribution-ShareAlike 4.0 International License"
"CC0","Creative Commons CC0 Public License"
"CC0-1.0","Creative Commons CC0 Universal 1.0 Public Domain Dedication"
"CC-NC","Creative Commons NonCommercial Public License"
"CC-NC-1.0","Creative Commons NonCommercial 1.0 Generic License"
"CC-ND","Creative Commons NoDerivs Public License"
"CC-ND-1.0","Creative Commons NoDerivs 1.0 Generic License"
"CC-SA","Creative Commons ShareAlike Public License"
"CC-SA-1.0","Creative Commons ShareAlike 1.0 Generic License"
"Sampling+","Creative Commons Sampling Plus Public License"
"CDDL","Common Development and Distribution License"
"CDDL-1.0","Common Development and Distribution License 1.0"
"CDDL-1.1","Common Development and Distribution License 1.1"
"CECILL","CeCILL License"
"CECILL-1.0","CeCILL License 1.0"
"CECILL-1.1","CeCILL License 1.1"
"CECILL-2.0","CeCILL License 2.0"
"CECILL-2.1","CeCILL License 2.1"
"CECILL-B","CeCILL-B License"
"CECILL-B-1.0","CeCILL-B License 1.0"
"CECILL-C","CeCILL-C License"
"CECILL-C-1.0","CeCILL-C License 1.0"
"CNRI-Jython","CNRI Jython License"
"CNRI-Python","CNRI Python license"
"CNRI-Python-GPL-Compatible","CNRI Python Open Source GPL Compatible License Agreement"
"CPAL","Common Public Attribution License"
"CPAL-1.0","Common Public Attribution License 1.0"
"CPL","Common Public License"
"CPL-1.0","Common Public License 1.0"
"CPOL","The Code Project Open License"
"CPOL-1.02","The Code Project Open License 1.02"
"Cryptix","Cryptix Public License"
"CPAL","CUA Office Public License Version"
"CPAL-1.0","CUA Office Public License Version 1.0"
"Cube","Cube License"
"CVW","MITRE Collaborative Virtual Workspace License"
"DSDP","DSDP License"
"ECL","Educational Community License"
"ECL-1.0","Educational Community License, Version 1.0"
"ECL-2.0","Educational Community License, Version 2.0"
"EPL","Eclipse Public License"
"EPL-1.0","Eclipse Public License 1.0"
"EPL-2.0","Eclipse Public License 2.0"
"EUPL","European Union Public License"
"EUPL-1.0","European Union Public License, Version 1.0"
"EUPL-1.1","European Union Public License, Version 1.1"
"EUPL-1.2","European Union Public License, Version 1.2"
"Eurosym","Eurosym License"
"389-exception","389 Directory Server Exception"
"Autoconf-exception-2.0","Autoconf exception 2.0"
"Autoconf-exception-2.0~Archive","Autoconf exception 2.0 (Autoconf Archive)"
"Autoconf-exception-2.0~AutoTroll","Autoconf exception 2.0 (AutoTroll)"
"Autoconf-exception-2.0~g10","Autoconf exception 2.0 (g10 Code)"
"Autoconf-exception-3.0","Autoconf exception 3.0"
"Autoconf-data","Autoconf data exception"
"Bison-1.24","Bison exception 1.24"
"Bison-exception-2.2","Bison exception 2.2"
"Classpath-exception-2.0","Classpath exception 2.0"
"EPL-library","EPL-library exception"
"EPL-MPL-library","EPL-MPL-library exception"
"FAUST","FAUST exception"
"GStreamer","GStreamer exception"
"libtool-exception","Libtool Exception"
"mif-exception","Macros and Inline Functions Exception"
"OCaml-LGPL-linking-exception","OCaml LGPL Linking Exception"
"OpenSSL-exception","OpenSSL exception"
"OpenSSL~LGPL-exception","OpenSSL~LGPL exception"
"OpenSSL~s3-exception","OpenSSL~s3 exception"
"Proguard","Proguard exception"
"Qt-GPL-exception-1.0","Qt GPL exception 1.0"
"Qt-GPL-Eclipse","Qt GPL Eclipse exception"
"Qt-GPL-OpenSSL","Qt GPL OpenSSL exception"
"Qt-kernel","Qt-kernel exception"
"Qt-LGPL-exception-1.1","Qt LGPL exception 1.1"
"Qt-no-source","Qt-no-source exception"
"SDC","SDC exception"
"Sollya-exception-4.1","Sollya exception 4.1"
"Warzone","Warzone exception"
"Xerces-exception","Xerces exception"
"FSFAP","FSF All Permissive License"
"FSFUL","FSF Unlimited License"
"FSFULLR","FSF Unlimited License (with Retention)"
"FTL","FreeType License"
"generated","generated file"
"GFDL","GNU Free Documentation License"
"GFDL-1.1","GNU Free Documentation License, Version 1.1"
"GFDL-1.1-only","GNU Free Documentation License v1.1 only"
"GFDL-1.1-or-later","GNU Free Documentation License v1.1 or later"
"GFDL-1.2","GNU Free Documentation License, Version 1.2"
"GFDL-1.2-only","GNU Free Documentation License v1.2 only"
"GFDL-1.2-or-later","GNU Free Documentation License v1.2 or later"
"GFDL-1.3","GNU Free Documentation License, Version 1.3"
"GFDL-1.3-only","GNU Free Documentation License v1.3 only"
"GFDL-1.3-or-later","GNU Free Documentation License v1.3 or later"
"GFDL-NIV","GNU Free Documentation License (no invariant sections)"
"AGPL/GPL/LGPL","GNU license"
"GPL","GNU General Public License"
"GPL-1.0","GNU General Public License, Version 1"
"GPL-1.0-only","GNU General Public License v1.0 only"
"GPL-1.0-or-later","GNU General Public License v1.0 or later"
"GPL-2","GNU General Public License, Version 2"
"GPL-2.0-only","GNU General Public License v2.0 only"
"GPL-2.0-or-later","GNU General Public License v2.0 or later"
"GPL-3","GNU General Public License, Version 3"
"GPL-3.0-only","GNU General Public License v3.0 only"
"GPL-3.0-or-later","GNU General Public License v3.0 or later"
"ICU","ICU License"
"Intel","Intel Open Source License"
"IPL","IBM Public License"
"IPL-1.0","IBM Public License 1.0"
"ISC","ISC License"
"jabberpl","Jabber Open Source License"
"JSON","JSON License"
"Jython","Jython License"
"Kevlin-Henney","Kevlin Henney License"
"LGPL","GNU Lesser General Public License"
"LGPL-2","GNU Library General Public License, Version 2.0"
"LGPL-2.1","GNU Lesser General Public License, Version 2.1"
"LGPL-2.1-only","GNU Lesser General Public License v2.1 only"
"LGPL-2.1-or-later","GNU Lesser General Public License v2.1 or later"
"LGPL-2-only","GNU Library General Public License v2 only"
"LGPL-2-or-later","GNU Library General Public License v2 or later"
"LGPL-3","GNU Lesser General Public License, Version 3"
"LGPL-3.0-only","GNU Lesser General Public License v3.0 only"
"LGPL-3.0-or-later","GNU Lesser General Public License v3.0 or later"
"LGPL-bdwgc","GNU Lesser General Public License (modified-code-notice clause)"
"Libpng","Libpng License"
"LLGPL","Lisp Lesser General Public License"
"LPPL","LaTeX Project Public License"
"LPPL-1.0","LaTeX Project Public License 1"
"LPPL-1.1","LaTeX Project Public License 1.1"
"LPPL-1.2","LaTeX Project Public License 1.2"
"LPPL-1.3a","LaTeX Project Public License 1.3a"
"LPPL-1.3c","LaTeX Project Public License 1.3c"
"MIT","MIT license"
"MIT-advertising","Enlightenment License (e16)"
"MIT-CMU","CMU License"
"MIT-enna","enna License"
"MIT-feh","feh License"
"Khronos","Khronos License"
"Motosoto","Motosoto License"
"MPL","Mozilla Public License"
"MPL-1.0","Mozilla Public License 1.0"
"MPL-1.1","Mozilla Public License 1.1"
"MPL-2.0","Mozilla Public License 2.0"
"MS-PL","Microsoft Public License"
"MS-RL","Microsoft Reciprocal License"
"MulanPSL","Mulan Permissive Software License"
"MulanPSL-1","Mulan Permissive Software License, Version 1"
"MulanPSL-2","Mulan Permissive Software License, Version 2"
"NGPL","Nethack General Public License"
"NPL","Netscape Public License"
"NPL-1.0","Netscape Public License version 1.0"
"NPL-1.1","Netscape Public License version 1.1"
"NTP","NTP License"
"OCLC","OCLC Research Public License"
"OCLC-1.0","OCLC Research Public License 1.0"
"OCLC-2.0","OCLC Research Public License 2.0"
"OFL","SIL Open Font License"
"OFL-1.0","SIL Open Font License 1.0"
"OFL-1.1","SIL Open Font License 1.1"
"OFL-1.1-no-RFN","SIL Open Font License 1.1 with no Reserved Font Name"
"OFL-1.1-RFN","SIL Open Font License 1.1 with Reserved Font Name"
"OFL-1.0-no-RFN","SIL Open Font License 1.0 with no Reserved Font Name"
"OFL-1.0-RFN","SIL Open Font License 1.0 with Reserved Font Name"
"OGTSL","Open Group Test Suite License"
"OLDAP","Open LDAP Public License"
"OLDAP-1.1","Open LDAP Public License v1.1"
"OLDAP-1.2","Open LDAP Public License v1.2"
"OLDAP-1.3","Open LDAP Public License v1.3"
"OLDAP-1.4","Open LDAP Public License v1.4"
"OLDAP-2.0","Open LDAP Public License v2"
"OLDAP-2.0.1","Open LDAP Public License v2.0.1"
"OLDAP-2.1","Open LDAP Public License v2.1"
"OLDAP-2.2","Open LDAP Public License v2.2"
"OLDAP-2.2.1","Open LDAP Public License v2.2.1"
"OLDAP-2.2.2","Open LDAP Public License v2.2.2"
"OLDAP-2.3","Open LDAP Public License v2.3"
"OLDAP-2.4","Open LDAP Public License v2.4"
"OLDAP-2.5","Open LDAP Public License v2.5"
"OLDAP-2.6","Open LDAP Public License v2.6"
"OLDAP-2.7","Open LDAP Public License v2.7"
"OLDAP-2.8","Open LDAP Public License v2.8"
"OpenSSL","OpenSSL License"
"OSL","Open Software License"
"OSL-1.0","Open Software License 1.0"
"OSL-1.1","Open Software License 1.1"
"OSL-2.0","Open Software License 2.0"
"OSL-2.1","Open Software License 2.1"
"OSL-3.0","Open Software License 3.0"
"Perl","The Perl 5 License"
"PostgreSQL","PostgreSQL License"
"public-domain","Public domain"
"Python","Python Software Foundation License"
"Python-2","Python Software Foundation License version 2"
"QPL","Q Public License"
"QPL-1.0","Q Public License 1.0"
"RPL","Reciprocal Public License"
"RPL-1","Reciprocal Public License, Version 1.0"
"RPL-1.1","Reciprocal Public License, Version 1.1"
"RPL-1.3","Reciprocal Public License, Version 1.3"
"RPL-1.5","Reciprocal Public License, Version 1.5"
"RPSL","RealNetworks Public Source License"
"RPSL-1.0","RealNetworks Public Source License 1.0"
"RSCPL","Ricoh Source Code Public License"
"Ruby","Ruby License"
"SGI-B","SGI Free Software License B"
"SGI-B-1.0","SGI Free Software License B v1.0"
"SGI-B-1.1","SGI Free Software License B v1.1"
"SGI-B-2.0","SGI Free Software License B v2.0"
"SISSL","Sun Industry Standards Source License"
"SISSL-1.1","Sun Industry Standards Source License - Version 1.1"
"SISSL-1.2","SUN INDUSTRY STANDARDS SOURCE LICENSE Version 1.2"
"SPL","Sun Public License"
"SPL-1.0","Sun Public License 1.0"
"SugarCRM","SugarCRM Public License"
"SugarCRM-1.1.3","SugarCRM Public License v1.1.3"
"Unicode-strict","Unicode strict"
"Unicode-TOU","Unicode Terms of Use"
"Unlicense","the Unlicense"
"Watcom","Sybase Open Watcom Public License"
"Watcom-1.0","Sybase Open Watcom Public License 1.0"
"WTFNMFPL-1.0","Do What The Fuck You Want To But It's Not My Fault Public License v1"
"WTFPL","do What The Fuck you want to Public License"
"WTFPL-1.0","Do What The Fuck You Want To Public License, Version 1"
"WTFPL-2","Do What The Fuck You Want To Public License, Version 2"
"Zlib","zlib/libpng license"
"Nunit","Nunit License"
"ZPL","Zope Public License"
"ZPL-1.0","Zope Public License (ZPL) Version 1.0"
"ZPL-1.1","Zope Public License 1.1"
"ZPL-2.0","Zope Public License 2.0"
"ZPL-2.1","Zope Public License 2.1"
