#!/usr/bin/perl -w
# based on fl15.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 16) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer2, "frame is layer II");
	ok($frame->has_crc, "frame has CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 48000, "sample rate");
	ok($frame->stereo, "stereo");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
 e                    ,I . .~N~N,~,~LwLwsrsr,1},1}aҲ,aҲ,X3X3_,_,L3bL3beded̺h(jh(j揍U'揍U'k~k~ȺhK+hK+`%y2`%y2jxjx,}}Ȋ ,}}Ȋ _ _ ytyt>d
IK>d
IKLELE                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ( H$.
vo䶜%kZc|-`!̆cZRnu}E"yC#ͺkT%Uf.5W[.X:r!ϫ
*}_@QTPւFb&3!ۮo53sy3ts?^j7kW	kmd( H;!AAٿ+
m_WۭF>8wqüg%gju ;UScaNK+C
r_qZ#1A	U#:J9ТMWEZj*,!'23a%v{	+\6ql癳kT                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               f! "      "           $I$I?IIwRrK)iZCI-eyir5^Z\fThfd)^o9W׮5Oh֧*u˗z2oތV-mN]F[SJ͇Xoa8u^_'fWٸp$aFfAM㑺Sxnzժ}㣓rx܍1pL\=GV=ffهuhbuC
*[Oo[ 泈6^^Xo0ז:1>cvpR n
EuDh                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        b 3      3           $$I&Miw3\<fxQ40'_*a,NT9yYjrf1} W @ۋӷ/Z.I$Bt;Xw)4yVSth+&4^i¼:U}R>nI$gɲJϗd6rl!@7]aP1!*4UǪ
-+d %@Ke"aEPƋFX@b&A)۫Tb1*Op3g"݁4v9d|j D՘v01gR)&3D"fI*7UrW+                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              D      D           $$IKV4c}?GِZֵtJ{VaTffVVek!Ctݶ[a/wDU7tHSD%lcJ,4^u~X]usɐ`||hKRͳ)\YőyӤ:AQd?eg#vVr:XHe4B$Ɍ\&k+(K,bbȒL/4OXCOox}%XGڒUTJK}H˘\<%Ò-w@#^]pÑ |9fյ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          U      U           $I(K$NkZz6}ߨ>{b ؒv;Pj ]q
dD2"^Eiij5_xoN7jWx+<PYJh,=J^./C"Ts*Hr*viC'mlU܆*IT#231RӘ맶{fvgjc?M1%ru9NQ2k_DvUe^zp1%8=I$yקzwt~:yԋzEZ=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             Ǚ f      f           $I$J(~\r,8BЅ,;HUi\%Upc]ȵ]NBu9SMM7e6jliuiHQi!Ej)S;w&	ܚvם;X± T h1y 5䫗W/OF"N;H SPr0gFMH坢vU-Qqliű\r+%Kp8Hghm|+,]Yufe9M8r4='@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             z w      w            $	0{[kKqn"b`8-wm[;g|zNIPuѻtn՞W/7M@QPJ]+饺i!FtΑ^GшZW&IlMZW)J}r\IP)*̈#iZumyh^m+6bUFJ)r
\.FPY3RtfNL;>σ0u:Hr;'IC
aUVB֜jzX82;=I7[}ߜ8'                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              Pw w             ?  ZZ( 04J,:5VUVZW&TXrPcEPcE``s\s\_a
X4f?::zp1*p1-ؾؾ緂cx0VTVT1;1;Q4Q4||Xue`re`wŷ!7ŷ!7&&8<	dpIO:[ԋ[ԯ6
6
L[L[ezjezjnmsn>>}Xd>}XlSllSleLLm[iLjd@S:@S:KK~q~q)IO]Ւuu"6ye"6yg(7(9hh+VyZ6&ђVVZTJZTJWaWaMM\(2Ǵs&1£&1¡:6r8:6r8yXyX[^{K޲l`l`gZCgZCff[[S0[b8y59*8y59-|v |v                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       f f             6   I$K$(ʠ.U
U(Rnn+W+~V􍎤lw+XBgwBgw@ɵk`&	HɄɄ..x,YXj֔g=nnll5R<~0\b5b5ttE1sP6o!r]r]DD/|]cǥlPbyMRRı'ı'-mr͘cdk#||]] An~S:a6CiCiLoLoq	$RHͧm9G8b}Wb}W:Ft#IsaK	K
]yyTЛ&٭HjF+v+v`3`3Yfq                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               U U             -  
,I H0I I(zam-֚inx&I4W&,OE(+haUU|d+B0(FXy4HDV`*,K7'$a=׽yHFQvqbCH~qz˹Yw:v'ebuJR0+q^؛iy{~g;u'z4%zWh~߶:yTO*3I[i+~Wvl| scjumRXCKhifjx<V𕶥ըԺpƌh['=iq ##VVb("%( tR
Aviiv                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                D D             $  (I,I(_-i0Tu%r=lz(J>x'\}Mq42kʅ
`QHuE!#soqdɥ,&fyX"mx>DnܧiJ2(lX,9Z5n" (XR6uHG:~l0aCۉn& -jb>l|Edz
Y(UgiZI*U#&@{[tr\AJɥH_!~F&@WKRƎW20hz&a<d7
ȪT(cP[tlAӴngQ[                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                               	63 3      l         $I$$)EYe2Wk˵*zwo77Z{0
-=uRE$+Bwk;ʵшL#jVEDTÓa╡=J+`vtKxEּ%`	xFbivHtY5̍R~L+e\K'yPNa('0,\n |ľt\KN%ꈩYuU[9#n\RtIr,tI*TP'f3D\m^5㩪:fU |`p>0GQEY}s9n驓ͧ4ӐQ6                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                     " "      H       P$$$I$ISɬE_`jvlaٳ!%*RI$?{zwlKrķ)BӨ@$,EvxSYg7?Y;#ɜ'8d1Hsד8my1?'QC}Xd9B]nJ3/s:-~"ݗc DZ-P]xއNқ)
"FC$r2Nq$܇b	|/իלfuӂ5x(Wg-{6w׳RːshS+|ׇj]wNc!S*Ps?W8q(XJ1
GF#bb9-l(OfrpVc-fc1x4[GcEGxwdw                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      $       	
(L$I  I$kR֚U 4y\b\ӠO{wLuXd!]涵gPfhͻZ{wTͭ_f"t\9H`)jx?/ng:Z϶nݸAΓvE&D*zcJj>~ņR%:J1]V=R2hAJ+/#PUOթE)x),2X51z7kvTnר1·
[Z]DVĭKC0(V|lֵ)kt;J>rϝ;Ƶ8浭sub8.--i\ZZI)JӠ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ߉                  (H$$dvLdvLǱhh6(xc6(xc7v #7v ,MK̗MKSҗ6Sҗ6jTjTe$@]e$@]C谔
C谔lqؖlq<-<-=+@o=+@e<(?<(?tvygygse'Vse'Pf lf l$I$IufHlufHeYeYe
Fn*Fn+ \C[ \CV?&\f?&\i%iTzy%iTzr/*/Od/*/Odזyyme;me;ƚRƚTפeo$פeo$??a,Z+pa,Z+pJ=eJ=e"rG"rI[W%[W%
#%L
#%HKgBehKgBeg]g]jGQ
GQ
<Iy<Iy11$D$IaF yYaF yYx x (Hz,L(Hz,L[~zQ[~zQLKyLKyFPFP                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          
