#!/usr/bin/perl
# based on fl8.mpg
# http://bmrc.berkeley.edu/ftp/pub/multimedia/mpeg/mpeg2/conformance-bitstreams/audio/mpeg1/compliance/

use strict;
use integer;

my $n;
use Test::More tests => ($n = 49) * 8 + 2;
BEGIN { use_ok("MPEG::Audio::Frame") };

for (1 .. $n){
	isa_ok(my $frame = MPEG::Audio::Frame->read(*DATA), "MPEG::Audio::Frame", "frame $_");
	ok($frame->mpeg1, "frame is MPEG1");
	ok($frame->layer1, "frame is layer I");
	ok(!$frame->has_crc, "frame doesn't have CRC");
	ok(!$frame->broken, "frame isn't broken");
	is($frame->bitrate, 384, "bitrate");
	is($frame->sample, 44100, "sample rate");
	ok($frame->stereo, "stereo");
}
is(MPEG::Audio::Frame->read(*DATA), undef, "nothing else in the file");

__DATA__
ݙwwwffUfDU3D3""             <ں<q\}u8瞺ڗ}vU ?ڟ߿~߿{}wmX `~߷}vU
 (Bڂ|>_`ڿz@{}wmXڠt]gh\..-ÇڵfUڀ
 )ڂ`q#>r"Dsv"fmڵWBг
5{yhP;"$xډ.ڶڈO}e.I9Bw j(nۿǣ(*ڈ0FÎrY@RT?ڗv]""!Bt!{qwm[o]yy)'<xmBڜUڸFڃ|_ ڿ|^z!wmP fUUUUUDDDDD33#"            0ˮ߾ھھ֭ڭYѝ̏$ڪURֵke(t*#Gp]ڽzL9CVڹwڀQ}usB"!3j/X>;ڽ$K,QC01DݵWMNihڛn}k^9wfpکa0t4ڢ9$ڐ@ڍkڢ*m@]^eeysڧ71RS6WkwzU.=k[JB[U9|qڝipڕ*(ږ]vX:{چdͪ9sZU#ڑpP[/{4vd\ڟ8qa	IJX9fCjqHxGkm<{ڪ PfUUUUDDDDDD33""            0ھھ 4m ٲlTTڊ)$sڣchچWڶ?hڰ/^ڽÆQGmڷ΄-g9wws$fH}xd<aeyacکIȆfT$>8 Xag:1ffIOI-ZځdHڇm )G:R{dFWaNڗ xںvێ7ڭc'9͌mfͭzn	S&I(aus1sgvTgڙ3*duaښhAڔ2sUI%kWڲ`ɖWچ{ַsڔV%Hٖej ڊ&u9c!BsڈmFTڻwsڞxaqe9kcvdڛR5`ϡڟd:Dێ9eq9g:QwڙnEfUUUUDDDDDD33""             4Qھھ3eڄamukB"e&Rxڤ!%Daiڨ qIkVڸAkfڈEQsH"yys)Δڢ[mGڹsrڞyeYji{FZiZ
Xڱ'FLV$kW{!9ڼs~o1eu){
QfIG[`j~ڦY41{"J?KڕWU* qƚ%)Rڜ'vdRAdcږǎک}uv1ڌa!Fu&Lex'r۞vڎ9Jsڄ#wmڵ&Mg-xy^(isڭc$ItYh˧ڗN\UVuaڌ^:Rc%'xPfUUDDDDD3333""             <Mھھ+|ϙĩQuZAkwfmڻe
ڤd(YfisvfgvSڜ'8KډqMdtmQwڈfnEKVڗgPǰ&s80Yf%&ڶRkiGvhdW
ڮAڃ#w.VڮYj2fڙfJEvGڙ$IәeږZ׽Vچgx۩sDڎ1^f(Rڄ!ڌfm`%Z^Hڑ}U^sڄwxiY3sSڇPO'!ڨ{ֵwwڑ%t   KalFڤs!WuTFxڐ!i
"u:ڋUfښ{ںQf%Yڲ"EQ"Nڑe(ŭe&hUTP ̈fUUDDDDD333"""             m}ھھd%zڽVΌc)ڈwfIڶ֥zڕK.P"ځqa{*kYڛm~I+d"ڜc#ڧtmW^j_LjqWڢڄ!2!!	Xګ'?*M&ڌaڌUwwڒIXQu*ڸqǚg]RJ1RYmv
P)LJj0\qڶ%)ڭsvhI`t34| BsڽݙڴX(ࣼ.;13Zڵ1Z(AUfm6ڋ-,٥RڝHR1s"*mڵچ:ڟd&3$ڑڶRsvffI`8ڀf1ژ-hj)e29ݙݴPڙ݈UUUUDDDDDD33""             CMM?ھھյPjژbSiڶYUWڞi֌X9ffJ@M~z|}ڜyqaڌa1ڭkiHچfY.K9\ڮI%u׽{Қ1wEkd_/Hik\2ڜyږ5@5M'qehA)F2RwwIg- Zc2ڌ|]xx{kceVҧP뇛
ێ9eaڽ\kڈmcU:/4ڒ%'ڽ{fڨF$?O"x } iڭsDڑ`9ByڞWڄAviWKҗ	\%aߎ6ږWڄ%)JRffm%`_->Zc\qqڎ:%'9{vfP ڈ݈wfUDDDDD3333""             M4߾ھھ5otL0c#ڂ	RڭX9!!ڴk]ȹڜsPnjڌcffwm~ڿvZlڴ\ryɳhkcIZ"m[VwwJI#R1sچgxV[/&MlUb6hAs9!"Dw|FvvlRQfwڙI%t:/sqiť,YZڶRbdIR{rvǏڄww.i)I!	wxډW毭_[d-qHyRJc"!ڙVD3:g}
(t:XbfڙUUmڵ{4i?ff7c!AsڢmbGOڽfTکI)Hx ڈwffUUDDDDDD33""            4iھھ爐RG0ۆ@yیZBssWvU#ݧ<~~\u9sڧ61fm`08)iڧǾ#wvUf|ځ~ 	͌GffZM)2U秨Pڗ!uViURw8Sښ||ڇ
 i1AfnEe"?+Xѡ}ڄ'79ڭ#ڗvVg3G 9̂pÆڪ:sskfwEY,ڇ/BhEnܹڞxkT9ڌTڄUڄzڴڐ)eYg9k!	JRwwI`0ڸ|yړ&Luׄ!A'6hVVڂ5k1zI{wnE@fDUUUEDDDDD33""            0ھھzښځڂPbRS4*vvL*LdI#%7:scIݶTEX%IxAaZڊ @4Pvڠڳ0ڭJ\AmZ]bē2fsڇHE)=d֪ڳ6hГ	4iڵƹW\Q6ZAΔڝۑUWnv"ER]E&
kNȪ͛>6BRQo^ڌThچU"
2ڼWږyڥO{ZֹuTD*ھ}-JJږ=ǯ|0ڮ9"KT6~"E6
ADuڍڤ-o{j(@p|N8ڶ#Ōfm%PfUUUUEDDDDD33""            4QھھbXژ[nm rT܊ڥ,kzڐ,,ںQES{F1ZU[IU2efMRڛh[BmUX 2ړrMׯ^צL\ں/JRZ׾Um%Vlڍ+ޭڝujڪ9{,
ګDŮE:91k\Aeڶ]:ڪ^\6uiHĥ=s7"Ǐ{A_+$ڮ9xRUBQڔuڗ(n%3F/|c2܀BPSl<0֥ڞsIUګY`čWzqeq$srړ3mڪc$2ʢI$ڭX͌Um%P UE33UUUUUDDD33""            E?ھھﾂLڗ2.9-.t!*ڻڲYOUwmy}B1Rڝnڟ}ړ;&wڊxDDCM6Q.N6<{ȹrOٕdڑ祕稢ZhڄWڈV/ڬ_
s$8.9-k4Cm4uBJtBچhڙeڢ{ھ"!(Nڦ0aJ!3uڪ,,|k$ښLJ8ڔ|jeU(k':fڙnEqD"<0uSU622̲̳o{;I"uIUf}Y]xYiJs{YIa7793DA4﨤 B-ȭ#J~1ڟ}E$ڒ(sviPUwڈ33DUUEDDDD33"            ﾆmھھﾊ%v1wڙ{#BcڼCj<?l~z 
qÝsj8a]ک$Um]{cB,*#-n9PkaUXa*	VQ^IXBYbڱڵ6ګ.sڵ24Q5sڔgy]v.-;ڰzڣbĒiF+[ڬQMM@Z	h2sT ڲκڔ[U75kK/y<f{yeڞsҊSښKM4o|6b{ڈfJ ڻw痓UږY$ڱ R-ڪڜXڷx]	3Lڵ]o}R""EP Uwڻ3"3DUUDDDD33""            ڣM<ھھﾆIOJC=;ڶ-pڄc);ڪڸ# DGڏ.f\qARڕYm^y11"$PA;#ͻڽڍl1nڶEVh	ڻYږY1c#wvڇVI\N3q
lM4b1ڼr+ڮڷWAdFg:YekkZ9VUd$R}/R#ڼc]sMo{2Kro]
_UfڑxaژJUڙ%	"0v`3I2ڋ\ڳD6ڶ+,r[
ګdRn8RkYl պ6mں+;-p-@ڲڶ] If}Iڌ\ڛPUf3"DUUUUEDD33"            0ھ}>ڰ[{Uڦq[JLHѣWjcSD+pMA$bc-jv8߿ڎ#Wfc8Iڭ7ڊ)$-l!ڧQ,KڧN)ړ̞ڤQDښpA4ֹ"&[VXڟuH;aԗYVZ)1dDCk,R0ߛ
PR#T0:1ڈmkڻx:	pfڦ ڎ7};5ڬ-ڎ0a<yڎS*!RHڏ<ce%)h
ږ,gڄ$ڠ[k3DHAڏ#LAn[3+o{ڸ,!Zfgyښ_>|Uګ4
`IږWeڗ]jSޫU"3Fڒl\"ભڱƢڑsڝs]P UfU""3DUUUDD43""            0eھe._`xښmkq9JsVU6ڮڻO?ڰFO;9ڪRbyEOYjyڈkiE!Jc	H;.]ڬ
>mL(ڥ5ډVڥJڥUʫaڅ)7ڞ{ڛ*ڊQڱ0A ڂ@گ<qm%BڌB!i,ڂ89m'waeƵVڒK)RwVڥ#2$ PwIu,_ M8n"i ]yJښD6ں׳|	Յ.YmUTڒM3bڵZjڧ dSۈ{ځhڌ
ک$TÈ?bHm-k-QfPUf"""3UUUEDD33"            0Uھuٌvs(x$mU晦ڣS)L6 ŋ *UPڄ MI$QA!TiI>ڦmڣ.0\b$$nH ]y$kQډ"کPDzm$Q$ڔέb"W]njmM9ږeI٘ar25ڭk33jڽ1+ @
DBfI_~9"DNP\%
Fwچ)M)Z+mjX(ڌ~%$ڎ),ګQ*mژgvI^zbsڻH*~*|Tڅ"MSL2[{xKڥT
?9y[mڵV9猒ړ̪ڸڲY+~wďM3]jfR{  Uff"3DUUUDD33"           8Mھaڶڐ
"-Wv8JYXŚeVDCݥ<Sĕڦg:iڤeֶ!ڵX |=P6nڵZ9ڦfIEWlك	ښf?,|ڝUXAbUcB!ݵXa^ixHKtXڅ)e]ھ!EUUj۶ڃ-Xڒ)WzR(ڟ~I#J"!%X`<xVydˊڵY!AVEXajգH~ bF%Wx8n(Je%Xa`4gdڹyVg9bډڽUX	ڥKڛ	WxŶ}#2eڵYjÅ]WS.^Xz88A!%Vz"Y՝Y%WyuAVEPUUwݻD"""3UUUDD33"           M3Mھڞq(&ݷ(,Lgw u1kwfmV}t1ǳڮڑuUb1Uaۉ    {IfYcVdeڕ'' H׵YIފmڶd͵Z6fh(ڢHڴGڴu֚eڶRfmU$ڞ4Md,PE1m]uڕ"&[UXڕxww$I'z5ȄFaUUo[N\	UuڸU%Vqywv)ڭfqƚu9UwUڞz}4ڄӚyڦIaiڝvZۥevv	&ښڵWykiHtڕaYZ6ڍ0ImV(uݵP Ufwڈ݈""DUUDDD3"           ﾞseھZZ7ڿW}>Uq 1ݵV9)e~[ZkusژB"EY)w]ΧXjBUmڌyYڄƵښEXaڃځƗڈDU%mec#AEUhRQcڲXUn1mڹ$R%VYjw}iul[Umچ:eڵZijֹڮ^o=aڰUmڌ5ڥ9ݵZiڟ>::pڶaw;UIqڢZڽ%Wڞjrqf P!WUm}ke&1TdRQvOZڍjsڛUmkڎ8aUڵX xQT_ڷ"tUmڌGڥVEX ڍT 0:ڒ[UIeeka	IPUffw""3DUUDD3""           MI/ھߋ##6;cRe8G!ݻډ5ڬiP%T	$}ڒEl<I0H`(bUڸYfRZm`ځ۸fS)ID)I(UIڊ'^Y$\%o6[w{ڥ'9ڴ#Ǖ*3"
h֎@V#mڈmwc1ڃ`چ`U9ڦ^ڥ"m^z9ړ,41_"ھlr$Uqڄ!
ڤWx7YX-gvdwa!iڥˇ
oo)SںY7]xڭmmpv^^LmQIiiJXb1kYmav P'WS}FڏUke&fP Uffw3"3DDDDD3""           0ͶھڦdBچU[pӍ7t#JRڥ&fX TR,QxȆQ!	Ik^fX 6mj4ښ*(ѝ\grUU\J{VW`h	(Q#<WtڕYڽ^VSϝ:8}ڽ!2("bUf\k6W&u!VfbJsvWv8y=Tz:HAJ^Y	$ړ%xڄBZ,WڛyYQ΄f\&7SJ/ib1{7y
i:$Fe"\DjڤFYڡ	JڭXfV=;ڝ[ڽ]A)ڦV^ڥR:9cڼ[b%&ڵJs9$vfwwwf "3DUUD33"           ]0 ھﾆ"D$$$$TPc0G?~ڪۻ$J;Ȱڐ@ځGGڏdIL=0ϕRwc!ڧ7vfFڋ+*JR24
@_
s/{mںTCxڒڊhnڍ @UsڢXژAALLF<ڱbŋڧJDR/{4Cjh85uw\uFU(1U_}fڈ\WھN#ڜr$*A=1
,&&࠙Y`ڸڃYߊ'U%xw#fd`<xSڍ59$ڨwwڎڀ*ڀRwZa	fbdHHKګڹF(RԈڔ6ڒdNM_ք:<UmbP Uffwwfݻ""3DDDD33"           ڶ0QھHνFٵVZڥdX˘	<o`\ŵV)Fs[WlJ((*h5%"REV٣J1RURWڙ2TGEUUJ!ڵYڇ9{ٙ	$\))YXw	XEVڞ1{٢W*'''ڧ2VoY+Y/w9kZRXhDڧWVڙFe3:ETaڢYt˘ڈڏ2ڦiڵT'7:Y$h4gֆڈ  ͵VasYWvDgi)'wqkֽ Y"%)1ZbW]hEF+0E4Q	2kf]W]j4k/E^EVAkYPffwwڈfݻ3"3DDD33"           ھAM߾ھnF{{~~Xڬdڜ:{ھeUIUkmhvՓ(ڢbhh[Mp=}UdkZֵUݵ67wx((\.lӝvҽ+fUVڜwwmUګ"

rqLڦ`,0ڞUڷxŌZWݻyyssڦS#7߭ڌeUmڌZ؇tÆ͞ڞ,T$ڐڙU[wkiKY"Ef<vڗ\-2
,ٙUVٚ:Rwwm[E"!ڔʟ?\raUΌ]VǞRR{=ڷ3<hVeUIseV֝8[[iicڷ=1U[ڪڽڅ	'77}=o3UVٞAfڑYu:|~_iUxB1&U[P fgwwwUU "3DDDD3"           ھ]sڞھl$dcMh@	M瘝kZڿ~Qڞn3v+1YRwcm^=54/.ڧ>7ڲ;֪S"69sڍOOڤ%}VڼcY ::2X6`GAlkJQfѣښڤf0ݖ적UڸJRڕ$QRGSLMpێڪLlBK
j85yx |0Uk'8Eۻڄ54Ö]Q*)JLbĈnNMHHFURwka1I_~GF~q,ڪC)D6Ҧ]]ڊccښh/)EY"%(ŌsPffwwڈffڪ""3DDD3"           ھMM?ھp0kkv;>^ڿ~EZRsITRڨ(ڙLڄF IURfڌe&1U6gfVXZdʵD&HGۥٚ2Iejյڶ>>=t|
TU&iڌ[V,Z4ppyyzfLfΏ~0%ڰUmΔvՋT\W+ݻ\ڟmU[ڙ{ھ!tچ<xvzdUVֵ*R_>K%f44VFiΥڛX zzڮc1<zAB
%UIڙJc!f&&
څ_>>IURUcJ!ڃ'YTqz
bkUT͌wm^l^^ڑdsU(چkbP ffwwڈgf3 ""3333"           ھMAھﾟ=ړ(igӳ׸9:ʪک6ڼxu=<=ڟ>}j|'?c5UڈwfaBNڎ&V͟_R"mڻD"6>}[Z֟Oڤ?ڗ&TڲVD]X0dɦڢR`@ҥǓ3ڪLڮ,ĸnGڌ|ڈUm&ffgvngjڗf0چ;B#ګtٱ1/($IXrU[mݚ!x(&&(Mv0D*=zCD6
ک4IڨڙwڑbDfڪv[N2ډ;L̶CÈx-YHUVFYPvwwڈUUD  ""3333""          ھQ4ܲھﾘ32kͦ9$h+A="S.6e^^bH\.Gx#ڽ[Uֆڝ-,
8O9?5+rLBڅ}Nڨwڗ^ڟnHwxXhiIQQQhc$# ڗڜڊMM%%Pڨ`ځX%`d {$ڢ&b*ڛm[ѯڻڋM4[o$)2ڷ$˼˻r*ڂڸ"e${1wwDnEqp==@ڠDb*ګUPgC%*Jmڞ(%rsںUV :֨AdmU<=
x"ڷk{[,U;LyyM<d["UڷwxڤP fwwwwwU݈" ""333"          ھ0ھww'(HGڦa
nmVF&jUxwefG#g	IU&]UӨژڈGڸ2mUڴUXihaOEjٕYU	Y[{vVVژɦڇv	mUdV\ˋڅv;qi7I@ٝ[V7GFjky<ڹ]ڄmVF]ډV(XWWWژىf&3l*ڦdYګHFVZzzڂJ+^ڑUV$HXY&&ښhP(&YVxvקڦfh('~? GqlڹV4hXVGFڿP)BSmUYڢT vwwڈwUU"  ""33""          ھy4ھ\\ <_?6Hs1
ڌ[[`ڠX,e4D%9)ĔIUVDږ.,ceڌu8>I*lZ֒ڪMD7"ڂ`bq8XW]ڎ>;FڛZmڈW쌒7IںHڠڌJ%2j&&@%%"u-e/mimVV33EƣKڃڎߖڲ*3=6fg'$Uچ$kVwm%Rک;ڰBڴQH_XL(<(ڞyFL*fRmU"Uڭ<<O22A0QMG<ڬڒD3I"IچppzڽgGH pUUmWr[P fwwڈwUE3  ""33""          ھI#گھﾉbaK_aڸںmڻڟ)))9^R(ABFmZ||{=ڦHxx cڽ5x̪lڤVGBg1hCDڇ?ڔDUmڒ[Wndg'$v
jiڔ}kRګ3m}zE1Y=Udڒ!&l痖addu:KBZMnnک6jٴzuEM3Ѷڦ6:ڥV3DEn==ڱw;_dڑ$'/ *RLcc,Y=kdڿ%cVDf[IdqqnnWȢB14vڪNͶϷڨT-&ڒUJFXUIڧvPvwwڈfUڪf  """""          ھiM/ھsrڠDRndHڏ<g|r*ڔ6"ݎڔJeLڊhڃ_>UVmrkhU,O;Ii/ xJmڭ-ړڂAډLt tڏEڃU[mWLN'c)ږ,弙pˏ*ڪMk!ڽ+Qwځ콒ԖڥUnII]ڼLECbڡn=zHmCGGF3ܹI'Er)2UUnEڈ#Hŋ,`aC>x*ڍPaZ+2I >ڜUm;:ڲ)K˥$6
ڪi6ڒGځKh\.T~ڗ)Tm$P wwwڈUDfݻ"   """""          ھ3Eھif4ښa0vڻgѡr`BVm&>>ښfeDڞo7ڔvڄfcچ9$mQQzzڟAڎFMeOF""!m)$bTXڈD!ӎ7ZF-)mdmڛWGFVW''Kړs/neћVI)*:9ȈdK,G!Mdڹ	Jڛ``{{^Vk8
cN~ڥzڵm)ڑb"  ڪ}A˓O	i&ڒI[mڶW緶&'5]u taFRYm"!X^Hc!"zڕnEڧ`ڰ\wڨ>Nm&ۑb"%$i\ڭǊ&1XQOTIdmPfwwڈfDU3  """          ھQ4߾ھdڠП،GmoUU\ȴhN@@JRڵkZڸŵ|ڪITڧuvڻT{=UrHĉ766EbڪcVڰQ~ڷsڭYӡ!ڝoڔIT~iگ3UU$ڋ2cڛcdg=X+wk+YNꪹ_>}}ڊdG<xrګ^%q)UVr,/|ڦRtںu45N*ڪmڵ
nmڳګWՖ,}wuP[iHbP@@4J# Kڞ\cڻTګm76M&>sځNrfUTRHںth`cF{Ŗ)ڹP fwwڈwUUD   ""          ھ0ھݝڟi&YXUڇUdڑV4fچڛMXk5bafs2f1TU9yzaڰ,%']mڶ7q{UlXoossA&s7с]vWڿN
p^UڵX((n<V)ںssaڽ
NW9U[mU:ڇC'bڢeUe-NHEUUړ&څBrڹa@
8iڌUU&Z{{ooxڼUJڜNZYiVRڲUmX!'skڵډqx#n3u)UdmU۸xyx<^W^(pچ4RUVUpڝF hieH@uڨUUڴ__eezcnVUPBڕUnEPwwڈwD3fݪ   """          ھ0Ŗھڷz=ڭظ9bڷOU[mڈn7 P(Z]zzZBڅH"x/UVFIre2ڎitڷڶ}ڵTm%ڂts%Jڜr7ھUڶXڗghT*k5}>962f|FeaVJEooڂAڈ
SkYGvUډVfg'&
zRڞ/ֵUڌuU[ڄW"GSڐcڟ>h}1FUYig;w;ڍG:")q%SyU[I%GGcۭ׻zzc"ڿڙ!UWڇw3gg8_U[I%ڒllwژ̉ڄ&__1ph
&P fwwڈwUDU"             ھ<4ھ0ژ
3y翞ZktCmUUUZڣRE"ڂA'gcQDRY^BUUUjձڞM&Bp6&*op%Y*ĕUUZ{{bZhD"21ژ$ڐH@*EUUYӢڢ<ڂ]]qŮ8ړ̞IUUUjחhfUaWa]qGڅ-mUUUڳeڈD*ژeڌf:|LbdUUU*ڣggd2NڴRQe Aa3UZ!!ښxm֎ڎqm5IUUUrjhhgA m6ڞjy
47UUUv"!ɣQt<ڢsڹڢUUarriiڃA1S)I#P@$%ڵUUPwwxڈUDDD              ھEM_ھﾄڄccڈ_/ڷܲY(EڕQڌڄllڔlmtht8eږc0 0[*׽UU^"gpL	ڡQDڽ319ڽ
pWr3]wJ3ڌ30UUW89),B x*KmڽB
{'1ڊCEŬ,[Gڍk^{`{UUUU}~ڇ ډĂ@s;`s˛ڠ󓎎ڙ<
@1a	&̖^UUrrsslln{ڊt#ڠրZڪtrڊLIzdR(M7ھ(lھIGڽUUb"%"P8کk˥ͶPB^
ڪgڳQ'ڋچIx1UUP ڇwڈf33ڈ              ھﾂqھn
څO7.;\`-*.کT\Ug3"%>Zh;ڻtz:m4
Z3 P#Bڍ
}ڪi	\-r9'ڣTڧz5m9/UV/.d7[ڵ˝lڣچoϿ<ڨ5bYڳZڀbU
ڛmږnUUYDڛB!/x:
&K34*=pb~qqډD
A>wfdUU^O/ڏETGBծw2ˮJcQ_/`eUڠvڻ]UUx;ڼrts!ڐb@ڠFiV*ڪggK?ڍeXڇ/څUT wwwڈfDDU"               ھcM<ھ85/w;
چڴ tjpڻJX#c[n+[-ڍFڌa㇎͵UzzQQau:+ڥJsکVzyڍէSڼ^RS1LiNUWhi96'.^ږZj՚IUbbeeb"O%A k^]"7U}}yyhhtfS'[ڮ

kaڄB`FVFF&%EzE"<yIڭUZچgڞ)ډ'6Uccb"ZWګz]cמIy%EUڋ}}mmxiڔ{>i4ZRuڟF}8UڵAAB	ګW9}_YdUP wwڈwD3D3               ھ4rqX, p6ړJS)nnZڥ)C:ڈU[[ddXuby<ڎE%%ڭReK69ڱȅVVV}>v; idڱwwc&ZOڄ%wU`baڋڀ@l887:!0-feV
p8
yڄa>1wU^ޞڣ1Msڹ6ڈAk@2ڹηuVJJ1ډ,4Dllk]Ԣ:ڑKZZwU]ڝfcڑ#a0ڞu"1*qSuUյڵvڻdhڴYkkZښmUi_O'{VګWڽ)9	KXUUڱUUڪt:	ZZ{/	 HiZuy<6:QڙD@ ڇwڈwU33U               ھY0ڦsN6	$lG>37ೂ୺o7k6C"1Ygxڙ/Kڽ-e,dcm8ڜF#ډDV+cb
sO;者XV!s9l6FEUjڳ*Ĩ ^t42):d2y;ڣQ;ڻډ$ھZSڧKb1کWDfLrqqUړRGSڄ8OotP/X
6ڙi4ڞx$3WWaچf""DN*ګEU=="DP}6666rʣکڂ]~
rrqɖh 	<$EJ|:qU]\گ.]*fFFbG#|>"q6f_g}ڒIU@wwڈwUDDUݪ"                 ھ0UXX	mmKڞe+ڭ>[`ڡ
I$pڸeȢ)NڨfeehhApbډJBnH^kmڽ،GK%ڐaQLr}xo
'WXxyL~Lڛk5ڜAǴgaf&ڭYiihaV]Uڛ
p8(yڌ{
*bڜSrr5aڐɔڄm)uіXڶVXXVS)m6Q(4+Yd)#ޞOڍښs u||nn_/Sڨd1oss}7ڴPJma0d2IR}k5ھwڈf3"D"                 ھ4ڎ77#pڸIMl6#TdənڔaC	ڸ<ڞV{ڽ.T*	ڒXUmګ@2(hg~M!ڰbq8ڠ@mڭ%̗;XE$ړ!Sکs6+Yڜ`wnRڗSڝejeņÉڮXu.wn1Nm9ڽVEo7Fudy<ڬVڈI.ڎGWWsjڵOb
w;ڕ*Un1^z^u&kڶa0D%ڏGڙn1҇@ڇf3za0~?wkZjNvڸ+ڕL`0(Pwmڲڐ''*w[.	RڡwmJSOF{xix<$gSt:#FڈG_ں  wwڈf3"3D                 ھI#קڧ'%"ڒAiړIbXݷqm+i{$dcT)Wo<v:چڎmnnbbh4*Yڬ
n[De;)ڬ5gQQںݍMp8$Hnenڣ~,'ڸen$ړzݵY=w{ڛ;s9ۍŢѣGv؞-!jڑ|>O&k5ڶۉDڟowxyW9fڳiwFڞIF4Z684u:}rT"EW~;C
$(!֛N1}hvTڡ
.d&~~ڜ\xl6/pIU~w9ډڔJV+ψDڳUmU(کED fwwڈwfD33f݉                ھﾒCaڙ2NNjj3ږK
ڊNxA#׬Mq5?իkkc3X*ڰBڇwTWW	T}>ڜEveJB1
H)~5坰vWgaڡl:%ډDa[6YڝBg{==II;]z1Uڽ=@ֳ;s&ڎi`@~~ee`\/ڕ)ڈ~{`ڂpLڦ5ZڧӍ-,ڬUcEfv.-yymڶޯWC˘řڙR*ɔss}ڿG$htC3PYA"HhgWWlڶ|fړGggַwwm,XpmZ-ڄ@ 5O⣊(P wwڈxfD"3ݻ                ھMA}}?
q8ڥ"5ڭnN,zk+ڎC~m@< ]\ڵؔJG#z=kڣkk8_kH$Z-@eJcY%ZV(+Ɉz=%2ڴٹ;"ڻV!ڷ7EEIuںY ڀAڌӣU46a^]Qpڷs9Z[Oڞ$ڳNŜXOSکU(T,ڎń!ڵfjP kkkkN+t9uLڱ,FAڏ{{ssG#Wڅªڑ!nڦs5׈ڛ[Pڜ.^G#~ڿchښJS͕ڶ!ڷ2ڙA>|3KPfwwxڈwfD""33                ھ4|mmڍNPm=ڏ'CBr3x_˼(Llnڏ#RڜFڔmWSڞ]iipp>_.M^(ڄVRBʚU*F&Wgj4^3,}'w(  $ϧԂAڃ>>Oڟ)$ڛ?;ڱcړIviڪŉڴڷcTvyyvfdQ89\ګ^ڽڥ(g,ڙ44::CCM'[
}}Tmڷu,*Wfz56n{32dڋr*Ma[
BPNڲRY4ڙeڽsmo7*ڜ8yydd#iڴZZl
ڈRU2dڼ!ڊd2wڋ<YU 
