# Scripting

```
# Generated by documentation/scripting/multi_wirl.pl

.------.
| box1 |<-----------------------------------.
'------'                                    |
    |                                   .------.
    |                                   | box3 |
    |                                   '------'
    |                                       ^
    |                                       |
    |               .------.                |
    '-------------->| box2 |----------------'
                    '------'


     __________
     \         \
      \  line 1 \
       ) line 2  )
      /  line 3 /
     /_________/

```

## Asciio simplified interface

These examples show you the simplified scripting interface which hides some of the details for you. The full source code is at the bottom of this page and in the scripting directory in the documentation of the project.

## Create a new Perl script

Crate a file and add these lines

```perl
use strict; use warnings;

use App::Asciio::Scripting ;
```

This will set some sanity checks on your code and load the simplified scripting interface.

## Adding boxes

```perl

add 'box1', new_box(TEXT_ONLY =>'box1'),  0,  2 ;
add 'box2', new_box(TEXT_ONLY =>'box2'), 20, 10 ;
add 'box3', new_box(TEXT_ONLY =>'box3'), 40,  5 ;
```

The simplified scripting interface lets you name your object so you can later connect them together.

## Adding connections

```perl
connect_elements 'box1', 'box2', 'down' ;
connect_elements 'box2', 'box3' ;
connect_elements 'box3', 'box1', 'up' ;
```

You can hint Asciio about the direction of your arrows.

### Canonizing connections

Asciio tries to route the arrows properly, this is done automatically in the UIs but you need to do it manually in scripts.

```perl

optimize ;

```

## Printing and saving the result

```perl
save_to "from_script.asciio" ;

ascii_out ;
```

You can save your work to an asciio file or print it out

## Adding multi-wirl arrows

You can write more advanced script where you route multi sections arrows around your elements.

```
     |
     |
     |
     |
     |
     '----.
          |
          '----.
               |
               |
               |
               |
               |
               |
            <--'
```

You'll also need to use the right module; in fact you have access to everything that's in Asciio from your scrips, it's just a little bit more work than using the simplified interface.

```perl
# documentation/scripting/multi_wirl.pl

use strict; use warnings;

use App::Asciio::Scripting ;
use App::Asciio::stripes::section_wirl_arrow;

#-----------------------------------------------------------------------------

add 'multi_wirl',
	new App::Asciio::stripes::section_wirl_arrow
		({
		POINTS => [[5, 5, 'downright'], [10, 7, 'downright'], [7, 14, 'downleft'], ],
		DIRECTION => '',
		}),
	5, 5 ;

ascii_out ;
```

## Full example

You can find more examples in the *documentation/scripting/* library of the project.

```perl
#  documentation/scripting/multi_wirl.pl

use strict; use warnings;

use App::Asciio::Scripting ;
use App::Asciio::stripes::process_box ;

#-----------------------------------------------------------------------------

add 'box1', new_box(TEXT_ONLY =>'box1'),  0,  2 ;
add 'box2', new_box(TEXT_ONLY =>'box2'), 20, 10 ;
add 'box3', new_box(TEXT_ONLY =>'box3'), 40,  5 ;

connect_elements 'box1', 'box2', 'down' ;
connect_elements 'box2', 'box3' ;
connect_elements 'box3', 'box1', 'up' ;

my $process = add_type 'process', 'Asciio/Boxes/process', 5, 15 ;
$process->set_text("line 1\nline 2\nline 3") ;

optimize ;

save_to "from_script.asciio" ;

ascii_out ;
```


