use strict;
use warnings;

package Footprintless::Database::DatabasePlugin::Command::db;
$Footprintless::Database::DatabasePlugin::Command::db::VERSION = '0.01';
# ABSTRACT: Provides support for databases
# PODNAME: Footprintless::Database::DatabasePlugin::Command::db

use parent qw(Footprintless::App::ActionCommand);

my %actions = (
    'backup'  => 'Footprintless::Database::DatabasePlugin::Command::db::backup',
    'client'  => 'Footprintless::Database::DatabasePlugin::Command::db::client',
    'copy-to' => 'Footprintless::Database::DatabasePlugin::Command::db::copy_to',
    'restore' => 'Footprintless::Database::DatabasePlugin::Command::db::restore',
);

sub _action_implementation {
    my ( $self, $action ) = @_;
    return $actions{$action};
}

1;

__END__

=pod

=head1 NAME

Footprintless::Database::DatabasePlugin::Command::db - Provides support for databases

=head1 VERSION

version 0.01

=head1 SYNOPSIS

    fpl db asias.dev.liferay.db backup

=head1 DESCRIPTION

Performs actions on a database instance.  The available actions are:

    backup       creates a backup of the database
    client       start a command line client
    copy-to      copy's the database to the specified destination
    restore      restore a database from a backup

The currently availble providers are:

    CSV          experimental
    MySql        fully implemented
    PostgreSQL   experimental

=head1 AUTHOR

Lucas Theisen <lucastheisen@pastdev.com>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2016 by Lucas Theisen.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=head1 SEE ALSO

Please see those modules/websites for more information related to this module.

=over 4

=item *

L<Footprintless::Database::DatabasePlugin|Footprintless::Database::DatabasePlugin>

=back

=cut
