use Test::More;
use MooX::Purple;
use MooX::Purple::G;

{
	package Test::Role;
	use Moo::Role;
	has ten => is => 'ro', default => sub {return 'ten'};
}

role Before {
	private eight { return '8' }
};

role World with Test::Role allow qw/Hello/ with qw/Before/ {
	private four { return 'fourth' }
};

class Hello with World allow qw/main/ {
	use Types::Standard qw/Str HashRef ArrayRef Object/;

	attributes
		one => [{ okay => 'one'}],
		[qw/six seven/] => [rw, Str, { default => 'ruling the world' }];

	validate_subs
		two => {
			params => {
				message => [Str, sub {'Hello World'}]
			}
		};

	public two { return $_[1]->{message} }
	public three { return 'lost'; }
	private five { return $_[0]->four }
};

class Night is qw/Hello/ {
	public nine { return 'crazy' }
};

ok(1);
done_testing();

