use utf8;
use strict;

use open qw(:std :utf8);
use Test::More 'no_plan';
use lib 't/lib';

use TreePath;

#       /
#       |
#       A
#      / \
#     B   C1
#    /   / \
#   C   C2   E
#  / \
# D   E
#
# nodes type1 : /, A, B, C, D, E
# nodes type2 : C1, C2 (untyped), E (second E with another type)
#

my $simpletree = {
                  '1' => {
                          type => 'type1',
                          parent => '0',
                          name => '/'},
                  '2' => {
                          type => 'type1',
                          parent => '1',
                          name => 'A'},
                  '3' => {
                          type => 'type1',
                          parent => '2',
                          name => 'B'},
                  '4' => {
                          type => 'type1',
                          parent => '3',
                          name => 'C'},
                  '5' => {
                          type => 'type1',
                          parent => '4',
                          name => 'D',
                          position => 1},
                  '6' => {
                          type => 'type1',
                          parent => '4',
                          name => 'E'},
                  '7' => {
                          type => 'type2',
                          parent => '2',
                          name => 'C1'},
                  '8' => {
                          parent => '7',
                          name => 'C2',
                         },
                  '9' => {
                          type => 'type2',
                          parent => '7',
                          name => 'E'},
                 };


ok( my $tp = TreePath->new(  conf  => $simpletree  ),
    "New TreePath ( conf => $simpletree)");

my $tree = $tp->tree;
isa_ok($tree, 'HASH');

my $root = $tp->root;
is($root,$tree->{1}, 'retrieve root');
isa_ok($root, 'HASH', "root" );

# search --------------------------
ok( my $A = $tp->search( { name => 'A' } ), 'A found');
is($A->{type}, 'type1', 'type of A is type1');

is(@{$A->{children}}, 1, 'A has only one child with same type as him');

is(@{$A->{children_type2}}, 1, 'but  has also a son with type2');

ok( my $C1 = $tp->search( { name => 'C1' } ), 'C1 found');
is(@{$C1->{children}}, 2, 'C1 has two children');
my $C2 = @{$C1->{children}}[0];
is($C2->{type}, 'type2', 'first child (C2) has type2 type');

is(scalar @{$A->{children}}, 1, 'A has again 1 child');
is(scalar @{$A->{children_type2}}, 1, 'but it have also a children_type2');


# add -----------------------------
is(scalar @{$C1->{children}}, 2, 'C1 has 2 children');
my $C3 = { name => 'C3'}; # no type

ok( $C3 = $tp->add($C3, $C1), 'add C3 to C1, type2 -> type2 is ok' );
is( $C3->{parent}, $C1, 'C3 parent is C1');
is($C3->{type}, 'type2', 'C3 has type2 type');

my $C4 = { name => 'C4', type => 'type2'};
ok( $C4 = $tp->add($C4, $A), 'add C4 to A, type2 -> type1 is ok');


is(scalar @{$A->{children}}, 1, 'now A has again 1 child');
is(scalar @{$A->{children_type2}}, 2, 'but it have also two children_type2');


is(scalar @{$A->{children}}, 1, 'A has 1 child');
my $A2 = { name => 'A2', type => 'type1'};
ok( $A2 = $tp->add($A2, $A), 'add A2 to A, type1 -> type1 is ok');

is(scalar @{$A->{children}}, 2, 'now A has 2 children (B, A2)');

my $A3 = { name => 'A3', type => 'type1'};
ok( $A3 = $tp->add($A3, $C1), 'add A3 to C1, type1 -> type2 is also permit, there is no rules');

my $A4 = { name => 'A4', position => 2};
ok($A4 = $tp->add($A4, $A), 'A4 added as a child of A with position=2');
is(scalar @{$A->{children}}, 3, 'now A has 3 children (B, A2, A4)');

is($A2->{position}, 3, 'now A2 have a position');


is(scalar @{$A->{children_type2}}, 2, 'A have two children_type2');
my $C5 = { name => 'C5', type => 'type2', position => 2};
ok($C5 = $tp->add($C5, $A), 'C5 added as a child of A with position=2');
is(scalar @{$A->{children_type2}}, 3, 'now A has 3 children_type2 (C1, C5, C4)');
is($C4->{position}, 3, 'now C4 have a position');
