#!perl -w

use strict;
no strict "vars";

use Date::DateCalcLib qw( calendar );

# ======================================================================
#   $string = calendar($year,$month);
# ======================================================================

print "1..24\n";

$test[1] = <<"VERBATIM";
       January 1996
Mon Tue Wed Thu Fri Sat Sun
  1   2   3   4   5   6   7
  8   9  10  11  12  13  14
 15  16  17  18  19  20  21
 22  23  24  25  26  27  28
 29  30  31
VERBATIM

$test[2] = <<"VERBATIM";
       February 1996
Mon Tue Wed Thu Fri Sat Sun
              1   2   3   4
  5   6   7   8   9  10  11
 12  13  14  15  16  17  18
 19  20  21  22  23  24  25
 26  27  28  29
VERBATIM

$test[3] = <<"VERBATIM";
        March 1996
Mon Tue Wed Thu Fri Sat Sun
                  1   2   3
  4   5   6   7   8   9  10
 11  12  13  14  15  16  17
 18  19  20  21  22  23  24
 25  26  27  28  29  30  31
VERBATIM

$test[4] = <<"VERBATIM";
        April 1996
Mon Tue Wed Thu Fri Sat Sun
  1   2   3   4   5   6   7
  8   9  10  11  12  13  14
 15  16  17  18  19  20  21
 22  23  24  25  26  27  28
 29  30
VERBATIM

$test[5] = <<"VERBATIM";
         May 1996
Mon Tue Wed Thu Fri Sat Sun
          1   2   3   4   5
  6   7   8   9  10  11  12
 13  14  15  16  17  18  19
 20  21  22  23  24  25  26
 27  28  29  30  31
VERBATIM

$test[6] = <<"VERBATIM";
         June 1996
Mon Tue Wed Thu Fri Sat Sun
                      1   2
  3   4   5   6   7   8   9
 10  11  12  13  14  15  16
 17  18  19  20  21  22  23
 24  25  26  27  28  29  30
VERBATIM

$test[7] = <<"VERBATIM";
         July 1996
Mon Tue Wed Thu Fri Sat Sun
  1   2   3   4   5   6   7
  8   9  10  11  12  13  14
 15  16  17  18  19  20  21
 22  23  24  25  26  27  28
 29  30  31
VERBATIM

$test[8] = <<"VERBATIM";
        August 1996
Mon Tue Wed Thu Fri Sat Sun
              1   2   3   4
  5   6   7   8   9  10  11
 12  13  14  15  16  17  18
 19  20  21  22  23  24  25
 26  27  28  29  30  31
VERBATIM

$test[9] = <<"VERBATIM";
      September 1996
Mon Tue Wed Thu Fri Sat Sun
                          1
  2   3   4   5   6   7   8
  9  10  11  12  13  14  15
 16  17  18  19  20  21  22
 23  24  25  26  27  28  29
 30
VERBATIM

$test[10] = <<"VERBATIM";
       October 1996
Mon Tue Wed Thu Fri Sat Sun
      1   2   3   4   5   6
  7   8   9  10  11  12  13
 14  15  16  17  18  19  20
 21  22  23  24  25  26  27
 28  29  30  31
VERBATIM

$test[11] = <<"VERBATIM";
       November 1996
Mon Tue Wed Thu Fri Sat Sun
                  1   2   3
  4   5   6   7   8   9  10
 11  12  13  14  15  16  17
 18  19  20  21  22  23  24
 25  26  27  28  29  30
VERBATIM

$test[12] = <<"VERBATIM";
       December 1996
Mon Tue Wed Thu Fri Sat Sun
                          1
  2   3   4   5   6   7   8
  9  10  11  12  13  14  15
 16  17  18  19  20  21  22
 23  24  25  26  27  28  29
 30  31
VERBATIM

$test[13] = <<"VERBATIM";
       January 1997
Mon Tue Wed Thu Fri Sat Sun
          1   2   3   4   5
  6   7   8   9  10  11  12
 13  14  15  16  17  18  19
 20  21  22  23  24  25  26
 27  28  29  30  31
VERBATIM

$test[14] = <<"VERBATIM";
       February 1997
Mon Tue Wed Thu Fri Sat Sun
                      1   2
  3   4   5   6   7   8   9
 10  11  12  13  14  15  16
 17  18  19  20  21  22  23
 24  25  26  27  28
VERBATIM

$test[15] = <<"VERBATIM";
        March 1997
Mon Tue Wed Thu Fri Sat Sun
                      1   2
  3   4   5   6   7   8   9
 10  11  12  13  14  15  16
 17  18  19  20  21  22  23
 24  25  26  27  28  29  30
 31
VERBATIM

$test[16] = <<"VERBATIM";
        April 1997
Mon Tue Wed Thu Fri Sat Sun
      1   2   3   4   5   6
  7   8   9  10  11  12  13
 14  15  16  17  18  19  20
 21  22  23  24  25  26  27
 28  29  30
VERBATIM

$test[17] = <<"VERBATIM";
         May 1997
Mon Tue Wed Thu Fri Sat Sun
              1   2   3   4
  5   6   7   8   9  10  11
 12  13  14  15  16  17  18
 19  20  21  22  23  24  25
 26  27  28  29  30  31
VERBATIM

$test[18] = <<"VERBATIM";
         June 1997
Mon Tue Wed Thu Fri Sat Sun
                          1
  2   3   4   5   6   7   8
  9  10  11  12  13  14  15
 16  17  18  19  20  21  22
 23  24  25  26  27  28  29
 30
VERBATIM

$test[19] = <<"VERBATIM";
         July 1997
Mon Tue Wed Thu Fri Sat Sun
      1   2   3   4   5   6
  7   8   9  10  11  12  13
 14  15  16  17  18  19  20
 21  22  23  24  25  26  27
 28  29  30  31
VERBATIM

$test[20] = <<"VERBATIM";
        August 1997
Mon Tue Wed Thu Fri Sat Sun
                  1   2   3
  4   5   6   7   8   9  10
 11  12  13  14  15  16  17
 18  19  20  21  22  23  24
 25  26  27  28  29  30  31
VERBATIM

$test[21] = <<"VERBATIM";
      September 1997
Mon Tue Wed Thu Fri Sat Sun
  1   2   3   4   5   6   7
  8   9  10  11  12  13  14
 15  16  17  18  19  20  21
 22  23  24  25  26  27  28
 29  30
VERBATIM

$test[22] = <<"VERBATIM";
       October 1997
Mon Tue Wed Thu Fri Sat Sun
          1   2   3   4   5
  6   7   8   9  10  11  12
 13  14  15  16  17  18  19
 20  21  22  23  24  25  26
 27  28  29  30  31
VERBATIM

$test[23] = <<"VERBATIM";
       November 1997
Mon Tue Wed Thu Fri Sat Sun
                      1   2
  3   4   5   6   7   8   9
 10  11  12  13  14  15  16
 17  18  19  20  21  22  23
 24  25  26  27  28  29  30
VERBATIM

$test[24] = <<"VERBATIM";
       December 1997
Mon Tue Wed Thu Fri Sat Sun
  1   2   3   4   5   6   7
  8   9  10  11  12  13  14
 15  16  17  18  19  20  21
 22  23  24  25  26  27  28
 29  30  31
VERBATIM

$n = 1;

for ( $year = 1996; $year <= 1997; $year++ )
{
    for ( $month = 1; $month <= 12; $month++ )
    {
        $string = calendar($year,$month);
        $string =~ s![ \t]+\n!\n!g;

        if ($string eq $test[$n])
        {print "ok $n\n";} else {print "not ok $n\n";}
        $n++;
    }
}

__END__

