# Generated by default/object.tt
package Paws::LexModelsV2::S3BucketLogDestination;
  use Moose;
  has KmsKeyArn => (is => 'ro', isa => 'Str', request_name => 'kmsKeyArn', traits => ['NameInRequest']);
  has LogPrefix => (is => 'ro', isa => 'Str', request_name => 'logPrefix', traits => ['NameInRequest'], required => 1);
  has S3BucketArn => (is => 'ro', isa => 'Str', request_name => 's3BucketArn', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::LexModelsV2::S3BucketLogDestination

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::LexModelsV2::S3BucketLogDestination object:

  $service_obj->Method(Att1 => { KmsKeyArn => $value, ..., S3BucketArn => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::LexModelsV2::S3BucketLogDestination object:

  $result = $service_obj->Method(...);
  $result->Att1->KmsKeyArn

=head1 DESCRIPTION

Specifies an Amazon S3 bucket for logging audio conversations

=head1 ATTRIBUTES


=head2 KmsKeyArn => Str

The Amazon Resource Name (ARN) of an AWS Key Management Service (KMS)
key for encrypting audio log files stored in an S3 bucket.


=head2 B<REQUIRED> LogPrefix => Str

The S3 prefix to assign to audio log files.


=head2 B<REQUIRED> S3BucketArn => Str

The Amazon Resource Name (ARN) of an Amazon S3 bucket where audio log
files are stored.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::LexModelsV2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

