# Generated by default/object.tt
package Paws::GameLift::RuntimeConfiguration;
  use Moose;
  has GameSessionActivationTimeoutSeconds => (is => 'ro', isa => 'Int');
  has MaxConcurrentGameSessionActivations => (is => 'ro', isa => 'Int');
  has ServerProcesses => (is => 'ro', isa => 'ArrayRef[Paws::GameLift::ServerProcess]');

1;

### main pod documentation begin ###

=head1 NAME

Paws::GameLift::RuntimeConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GameLift::RuntimeConfiguration object:

  $service_obj->Method(Att1 => { GameSessionActivationTimeoutSeconds => $value, ..., ServerProcesses => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GameLift::RuntimeConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->GameSessionActivationTimeoutSeconds

=head1 DESCRIPTION

A collection of server process configurations that describe the set of
processes to run on each instance in a fleet. Server processes run
either an executable in a custom game build or a Realtime Servers
script. GameLift launches the configured processes, manages their life
cycle, and replaces them as needed. Each instance checks regularly for
an updated runtime configuration.

A GameLift instance is limited to 50 processes running concurrently. To
calculate the total number of processes in a runtime configuration, add
the values of the C<ConcurrentExecutions> parameter for each
ServerProcess. Learn more about Running Multiple Processes on a Fleet
(https://docs.aws.amazon.com/gamelift/latest/developerguide/fleets-multiprocess.html).

B<Related actions>

DescribeRuntimeConfiguration | UpdateRuntimeConfiguration

=head1 ATTRIBUTES


=head2 GameSessionActivationTimeoutSeconds => Int

The maximum amount of time (in seconds) allowed to launch a new game
session and have it report ready to host players. During this time, the
game session is in status C<ACTIVATING>. If the game session does not
become active before the timeout, it is ended and the game session
status is changed to C<TERMINATED>.


=head2 MaxConcurrentGameSessionActivations => Int

The number of game sessions in status C<ACTIVATING> to allow on an
instance. This setting limits the instance resources that can be used
for new game activations at any one time.


=head2 ServerProcesses => ArrayRef[L<Paws::GameLift::ServerProcess>]

A collection of server process configurations that identify what server
processes to run on each instance in a fleet.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GameLift>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

