# Generated by default/object.tt
package Paws::Lightsail::HeaderObject;
  use Moose;
  has HeadersAllowList => (is => 'ro', isa => 'ArrayRef[Str|Undef]', request_name => 'headersAllowList', traits => ['NameInRequest']);
  has Option => (is => 'ro', isa => 'Str', request_name => 'option', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Lightsail::HeaderObject

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Lightsail::HeaderObject object:

  $service_obj->Method(Att1 => { HeadersAllowList => $value, ..., Option => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Lightsail::HeaderObject object:

  $result = $service_obj->Method(...);
  $result->Att1->HeadersAllowList

=head1 DESCRIPTION

Describes the request headers that a Lightsail distribution bases
caching on.

For the headers that you specify, your distribution caches separate
versions of the specified content based on the header values in viewer
requests. For example, suppose viewer requests for C<logo.jpg> contain
a custom C<product> header that has a value of either C<acme> or
C<apex>, and you configure your distribution to cache your content
based on values in the C<product> header. Your distribution forwards
the C<product> header to the origin and caches the response from the
origin once for each header value.

=head1 ATTRIBUTES


=head2 HeadersAllowList => ArrayRef[Str|Undef]

The specific headers to forward to your distribution's origin.


=head2 Option => Str

The headers that you want your distribution to forward to your origin
and base caching on.

You can configure your distribution to do one of the following:

=over

=item *

B<C<all> > - Forward all headers to your origin.

=item *

B<C<none> > - Forward only the default headers.

=item *

B<C<allow-list> > - Forward only the headers you specify using the
C<headersAllowList> parameter.

=back




=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Lightsail>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

