# Generated by default/object.tt
package Paws::CodeGuruReviewer::Repository;
  use Moose;
  has Bitbucket => (is => 'ro', isa => 'Paws::CodeGuruReviewer::ThirdPartySourceRepository');
  has CodeCommit => (is => 'ro', isa => 'Paws::CodeGuruReviewer::CodeCommitRepository');
  has GitHubEnterpriseServer => (is => 'ro', isa => 'Paws::CodeGuruReviewer::ThirdPartySourceRepository');
  has S3Bucket => (is => 'ro', isa => 'Paws::CodeGuruReviewer::S3Repository');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CodeGuruReviewer::Repository

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CodeGuruReviewer::Repository object:

  $service_obj->Method(Att1 => { Bitbucket => $value, ..., S3Bucket => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CodeGuruReviewer::Repository object:

  $result = $service_obj->Method(...);
  $result->Att1->Bitbucket

=head1 DESCRIPTION

Information about an associated AWS CodeCommit repository or an
associated repository that is managed by AWS CodeStar Connections (for
example, Bitbucket). This C<Repository> object is not used if your
source code is in an associated GitHub repository.

=head1 ATTRIBUTES


=head2 Bitbucket => L<Paws::CodeGuruReviewer::ThirdPartySourceRepository>

Information about a Bitbucket repository.


=head2 CodeCommit => L<Paws::CodeGuruReviewer::CodeCommitRepository>

Information about an AWS CodeCommit repository.


=head2 GitHubEnterpriseServer => L<Paws::CodeGuruReviewer::ThirdPartySourceRepository>

Information about a GitHub Enterprise Server repository.


=head2 S3Bucket => L<Paws::CodeGuruReviewer::S3Repository>





=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CodeGuruReviewer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

