# Generated by default/object.tt
package Paws::Synthetics::CanaryRunConfigInput;
  use Moose;
  has ActiveTracing => (is => 'ro', isa => 'Bool');
  has EnvironmentVariables => (is => 'ro', isa => 'Paws::Synthetics::EnvironmentVariablesMap');
  has MemoryInMB => (is => 'ro', isa => 'Int');
  has TimeoutInSeconds => (is => 'ro', isa => 'Int');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Synthetics::CanaryRunConfigInput

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Synthetics::CanaryRunConfigInput object:

  $service_obj->Method(Att1 => { ActiveTracing => $value, ..., TimeoutInSeconds => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Synthetics::CanaryRunConfigInput object:

  $result = $service_obj->Method(...);
  $result->Att1->ActiveTracing

=head1 DESCRIPTION

A structure that contains input information for a canary run.

=head1 ATTRIBUTES


=head2 ActiveTracing => Bool

Specifies whether this canary is to use active AWS X-Ray tracing when
it runs. Active tracing enables this canary run to be displayed in the
ServiceLens and X-Ray service maps even if the canary does not hit an
endpoint that has X-ray tracing enabled. Using X-Ray tracing incurs
charges. For more information, see Canaries and X-Ray tracing
(https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch_Synthetics_Canaries_tracing.html).

You can enable active tracing only for canaries that use version
C<syn-nodejs-2.0> or later for their canary runtime.


=head2 EnvironmentVariables => L<Paws::Synthetics::EnvironmentVariablesMap>

Specifies the keys and values to use for any environment variables used
in the canary script. Use the following format:

{ "key1" : "value1", "key2" : "value2", ...}

Keys must start with a letter and be at least two characters. The total
size of your environment variables cannot exceed 4 KB. You can't
specify any Lambda reserved environment variables as the keys for your
environment variables. For more information about reserved keys, see
Runtime environment variables
(https://docs.aws.amazon.com/lambda/latest/dg/configuration-envvars.html#configuration-envvars-runtime).


=head2 MemoryInMB => Int

The maximum amount of memory available to the canary while it is
running, in MB. This value must be a multiple of 64.


=head2 TimeoutInSeconds => Int

How long the canary is allowed to run before it must stop. You can't
set this time to be longer than the frequency of the runs of this
canary.

If you omit this field, the frequency of the canary is used as this
value, up to a maximum of 14 minutes.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Synthetics>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

