# Generated by default/object.tt
package Paws::Macie2::BucketPermissionConfiguration;
  use Moose;
  has AccountLevelPermissions => (is => 'ro', isa => 'Paws::Macie2::AccountLevelPermissions', request_name => 'accountLevelPermissions', traits => ['NameInRequest']);
  has BucketLevelPermissions => (is => 'ro', isa => 'Paws::Macie2::BucketLevelPermissions', request_name => 'bucketLevelPermissions', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Macie2::BucketPermissionConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Macie2::BucketPermissionConfiguration object:

  $service_obj->Method(Att1 => { AccountLevelPermissions => $value, ..., BucketLevelPermissions => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Macie2::BucketPermissionConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AccountLevelPermissions

=head1 DESCRIPTION

Provides information about the account-level and bucket-level
permissions settings for an S3 bucket.

=head1 ATTRIBUTES


=head2 AccountLevelPermissions => L<Paws::Macie2::AccountLevelPermissions>

The account-level permissions settings that apply to the bucket.


=head2 BucketLevelPermissions => L<Paws::Macie2::BucketLevelPermissions>

The bucket-level permissions settings for the bucket.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Macie2>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

