# Generated by default/object.tt
package Paws::IoTDeviceAdvisor::SuiteRunInformation;
  use Moose;
  has CreatedAt => (is => 'ro', isa => 'Str', request_name => 'createdAt', traits => ['NameInRequest']);
  has EndAt => (is => 'ro', isa => 'Str', request_name => 'endAt', traits => ['NameInRequest']);
  has Failed => (is => 'ro', isa => 'Int', request_name => 'failed', traits => ['NameInRequest']);
  has Passed => (is => 'ro', isa => 'Int', request_name => 'passed', traits => ['NameInRequest']);
  has StartedAt => (is => 'ro', isa => 'Str', request_name => 'startedAt', traits => ['NameInRequest']);
  has Status => (is => 'ro', isa => 'Str', request_name => 'status', traits => ['NameInRequest']);
  has SuiteDefinitionId => (is => 'ro', isa => 'Str', request_name => 'suiteDefinitionId', traits => ['NameInRequest']);
  has SuiteDefinitionName => (is => 'ro', isa => 'Str', request_name => 'suiteDefinitionName', traits => ['NameInRequest']);
  has SuiteDefinitionVersion => (is => 'ro', isa => 'Str', request_name => 'suiteDefinitionVersion', traits => ['NameInRequest']);
  has SuiteRunId => (is => 'ro', isa => 'Str', request_name => 'suiteRunId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTDeviceAdvisor::SuiteRunInformation

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTDeviceAdvisor::SuiteRunInformation object:

  $service_obj->Method(Att1 => { CreatedAt => $value, ..., SuiteRunId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTDeviceAdvisor::SuiteRunInformation object:

  $result = $service_obj->Method(...);
  $result->Att1->CreatedAt

=head1 DESCRIPTION

Information about the suite run.

=head1 ATTRIBUTES


=head2 CreatedAt => Str

Date (in Unix epoch time) when the suite run was created.


=head2 EndAt => Str

Date (in Unix epoch time) when the suite run ended.


=head2 Failed => Int

Number of test cases that failed in the suite run.


=head2 Passed => Int

Number of test cases that passed in the suite run.


=head2 StartedAt => Str

Date (in Unix epoch time) when the suite run was started.


=head2 Status => Str

Status of the suite run.


=head2 SuiteDefinitionId => Str

Suite definition Id of the suite run.


=head2 SuiteDefinitionName => Str

Suite definition name of the suite run.


=head2 SuiteDefinitionVersion => Str

Suite definition version of the suite run.


=head2 SuiteRunId => Str

Suite run Id of the suite run.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTDeviceAdvisor>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

