# Generated by default/object.tt
package Paws::CostExplorer::DiskResourceUtilization;
  use Moose;
  has DiskReadBytesPerSecond => (is => 'ro', isa => 'Str');
  has DiskReadOpsPerSecond => (is => 'ro', isa => 'Str');
  has DiskWriteBytesPerSecond => (is => 'ro', isa => 'Str');
  has DiskWriteOpsPerSecond => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CostExplorer::DiskResourceUtilization

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CostExplorer::DiskResourceUtilization object:

  $service_obj->Method(Att1 => { DiskReadBytesPerSecond => $value, ..., DiskWriteOpsPerSecond => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CostExplorer::DiskResourceUtilization object:

  $result = $service_obj->Method(...);
  $result->Att1->DiskReadBytesPerSecond

=head1 DESCRIPTION

The field that contains a list of disk (local storage) metrics
associated with the current instance.

=head1 ATTRIBUTES


=head2 DiskReadBytesPerSecond => Str

The maximum read throughput operations per second.


=head2 DiskReadOpsPerSecond => Str

The maximum number of read operations per second.


=head2 DiskWriteBytesPerSecond => Str

The maximum write throughput operations per second.


=head2 DiskWriteOpsPerSecond => Str

The maximum number of write operations per second.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CostExplorer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

