# Generated by default/object.tt
package Paws::Chime::RetentionSettings;
  use Moose;
  has ConversationRetentionSettings => (is => 'ro', isa => 'Paws::Chime::ConversationRetentionSettings');
  has RoomRetentionSettings => (is => 'ro', isa => 'Paws::Chime::RoomRetentionSettings');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Chime::RetentionSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Chime::RetentionSettings object:

  $service_obj->Method(Att1 => { ConversationRetentionSettings => $value, ..., RoomRetentionSettings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Chime::RetentionSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->ConversationRetentionSettings

=head1 DESCRIPTION

The retention settings for an Amazon Chime Enterprise account that
determine how long to retain items such as chat-room messages and
chat-conversation messages.

=head1 ATTRIBUTES


=head2 ConversationRetentionSettings => L<Paws::Chime::ConversationRetentionSettings>

The chat conversation retention settings.


=head2 RoomRetentionSettings => L<Paws::Chime::RoomRetentionSettings>

The chat room retention settings.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Chime>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

