# Generated by default/object.tt
package Paws::AmplifyBackend::UpdateBackendAuthMFAConfig;
  use Moose;
  has MFAMode => (is => 'ro', isa => 'Str');
  has Settings => (is => 'ro', isa => 'Paws::AmplifyBackend::Settings', request_name => 'settings', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::AmplifyBackend::UpdateBackendAuthMFAConfig

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::AmplifyBackend::UpdateBackendAuthMFAConfig object:

  $service_obj->Method(Att1 => { MFAMode => $value, ..., Settings => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::AmplifyBackend::UpdateBackendAuthMFAConfig object:

  $result = $service_obj->Method(...);
  $result->Att1->MFAMode

=head1 DESCRIPTION

Updates the multi-factor authentication (MFA) configuration for the
backend of your Amplify project.

=head1 ATTRIBUTES


=head2 MFAMode => Str

The MFA mode for the backend of your Amplify project.


=head2 Settings => L<Paws::AmplifyBackend::Settings>

The settings of your MFA configuration for the backend of your Amplify
project.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::AmplifyBackend>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

