# Generated by default/object.tt
package Paws::SageMaker::PipelineExecutionSummary;
  use Moose;
  has PipelineExecutionArn => (is => 'ro', isa => 'Str');
  has PipelineExecutionDescription => (is => 'ro', isa => 'Str');
  has PipelineExecutionDisplayName => (is => 'ro', isa => 'Str');
  has PipelineExecutionStatus => (is => 'ro', isa => 'Str');
  has StartTime => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::SageMaker::PipelineExecutionSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::SageMaker::PipelineExecutionSummary object:

  $service_obj->Method(Att1 => { PipelineExecutionArn => $value, ..., StartTime => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::SageMaker::PipelineExecutionSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->PipelineExecutionArn

=head1 DESCRIPTION

A pipeline execution summary.

=head1 ATTRIBUTES


=head2 PipelineExecutionArn => Str

The Amazon Resource Name (ARN) of the pipeline execution.


=head2 PipelineExecutionDescription => Str

The description of the pipeline execution.


=head2 PipelineExecutionDisplayName => Str

The display name of the pipeline execution.


=head2 PipelineExecutionStatus => Str

The status of the pipeline execution.


=head2 StartTime => Str

The start time of the pipeline execution.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::SageMaker>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

