# Generated by default/object.tt
package Paws::IoTSiteWise::AssetHierarchyInfo;
  use Moose;
  has ChildAssetId => (is => 'ro', isa => 'Str', request_name => 'childAssetId', traits => ['NameInRequest']);
  has ParentAssetId => (is => 'ro', isa => 'Str', request_name => 'parentAssetId', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::IoTSiteWise::AssetHierarchyInfo

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::IoTSiteWise::AssetHierarchyInfo object:

  $service_obj->Method(Att1 => { ChildAssetId => $value, ..., ParentAssetId => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::IoTSiteWise::AssetHierarchyInfo object:

  $result = $service_obj->Method(...);
  $result->Att1->ChildAssetId

=head1 DESCRIPTION

Contains information about a parent asset and a child asset that are
related through an asset hierarchy.

=head1 ATTRIBUTES


=head2 ChildAssetId => Str

The ID of the child asset in this asset relationship.


=head2 ParentAssetId => Str

The ID of the parent asset in this asset relationship.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::IoTSiteWise>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

