# Generated by default/object.tt
package Paws::DynamoDB::ExportSummary;
  use Moose;
  has ExportArn => (is => 'ro', isa => 'Str');
  has ExportStatus => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::DynamoDB::ExportSummary

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::DynamoDB::ExportSummary object:

  $service_obj->Method(Att1 => { ExportArn => $value, ..., ExportStatus => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::DynamoDB::ExportSummary object:

  $result = $service_obj->Method(...);
  $result->Att1->ExportArn

=head1 DESCRIPTION

Summary information about an export task.

=head1 ATTRIBUTES


=head2 ExportArn => Str

The Amazon Resource Name (ARN) of the export.


=head2 ExportStatus => Str

Export can be in one of the following states: IN_PROGRESS, COMPLETED,
or FAILED.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::DynamoDB>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

