package Acme::MetaSyntactic::vim;

use 5.006001;
use utf8;
use strict;
use warnings;

use version; our $VERSION = qv('v1.0.1');

use base 'Acme::MetaSyntactic::MultiList';
__PACKAGE__->init();

1; # Magic true value required at end of module

=encoding utf8

=for stopwords Moolenaar autocmds

=head1 NAME

Acme::MetaSyntactic::vim - The Vim theme


=head1 VERSION

This document describes Acme::MetaSyntactic::vim version 1.0.1.


=head1 DESCRIPTION

This theme lists Vim options, commands, events, etc.


=head2 List of categories

This module was created by converting part the syntax/vim.vim file
from Vim 7 into Perl code, and so the categories are based upon Vim
syntax.

This theme currently includes the following types of items:

=over

=item *

C<todo>: markers in comments that Vim considers indicative of
"incomplete" code.

=item *

C<commands/full>: full names of commands.

=item *

C<commands/abbreviated>: abbreviations for commands that have them.

=item *

C<options/full>: full names of options.

=item *

C<options/abbreviated>:  abbreviations for options that have them.

=item *

C<events>: triggers that you can hook autocmds to.

=item *

C<functions>: standard functions that come with Vim.

=back

=head1 DIAGNOSTICS


None.


=head1 CONFIGURATION AND ENVIRONMENT

Acme::MetaSyntactic::vim requires no configuration files or
environment variables.


=head1 DEPENDENCIES

L<Acme::MetaSyntactic>


=head1 INCOMPATIBILITIES

None reported.


=head1 BUGS AND LIMITATIONS

No bugs have been reported.

Please report any bugs or feature requests to
C<bug-acme-metasyntactic-vim@rt.cpan.org>, or through the web
interface at L<http://rt.cpan.org>.


=head1 DEDICATION

This module is dedicated to Bram Moolenaar, of course.


=head1 AUTHOR

Elliot Shank  C<< <perl@galumph.com> >>


=head1 LICENSE AND COPYRIGHT

Copyright ©2007-2008, Elliot Shank C<< <perl@galumph.com> >>. All
rights reserved.

This module is free software; you can redistribute it and/or modify it
under the same terms as Perl itself. See L<perlartistic>.


=head1 DISCLAIMER OF WARRANTY

BECAUSE THIS SOFTWARE IS LICENSED FREE OF CHARGE, THERE IS NO WARRANTY
FOR THE SOFTWARE, TO THE EXTENT PERMITTED BY APPLICABLE LAW. EXCEPT
WHEN OTHERWISE STATED IN WRITING THE COPYRIGHT HOLDERS AND/OR OTHER
PARTIES PROVIDE THE SOFTWARE "AS IS" WITHOUT WARRANTY OF ANY KIND,
EITHER EXPRESSED OR IMPLIED, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
PURPOSE. THE ENTIRE RISK AS TO THE QUALITY AND PERFORMANCE OF THE
SOFTWARE IS WITH YOU. SHOULD THE SOFTWARE PROVE DEFECTIVE, YOU ASSUME
THE COST OF ALL NECESSARY SERVICING, REPAIR, OR CORRECTION.

IN NO EVENT UNLESS REQUIRED BY APPLICABLE LAW OR AGREED TO IN WRITING
WILL ANY COPYRIGHT HOLDER, OR ANY OTHER PARTY WHO MAY MODIFY AND/OR
REDISTRIBUTE THE SOFTWARE AS PERMITTED BY THE ABOVE LICENSE, BE LIABLE
TO YOU FOR DAMAGES, INCLUDING ANY GENERAL, SPECIAL, INCIDENTAL, OR
CONSEQUENTIAL DAMAGES ARISING OUT OF THE USE OR INABILITY TO USE THE
SOFTWARE (INCLUDING BUT NOT LIMITED TO LOSS OF DATA OR DATA BEING
RENDERED INACCURATE OR LOSSES SUSTAINED BY YOU OR THIRD PARTIES OR A
FAILURE OF THE SOFTWARE TO OPERATE WITH ANY OTHER SOFTWARE), EVEN IF
SUCH HOLDER OR OTHER PARTY HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH
DAMAGES.

=cut
__DATA__
# default
commands/full
# names todo
COMBAK
FIXME
TODO
XXX
# names commands/full
abbreviate
abclear
aboveleft
all
argadd
argdelete
argdo
argedit
argglobal
arglocal
args
argument
ascii
badd
ball
bdelete
be
belowright
bfirst
blast
bmodified
bnext
bNext
botright
bprevious
break
breakadd
breakdel
breaklist
brewind
browse
bufdo
buffer
buffers
bunload
bwipeout
cabbrev
cabclear
caddbuffer
caddexpr
caddfile
call
catch
cbuffer
cc
cclose
cd
center
cexpr
cfile
cfirst
cgetbuffer
cgetexpr
cgetfile
change
changes
chdir
checkpath
checktime
clast
clist
close
cmapclear
cnewer
cnext
cNext
cnfile
cNfile
cnoreabbrev
colder
colorscheme
comclear
compiler
confirm
continue
copen
copy
cpfile
cprevious
cquit
crewind
cunabbrev
cunmap
cwindow
debuggreedy
delcommand
delete
DeleteFirst
delfunction
delmarks
diffget
diffoff
diffpatch
diffput
diffsplit
diffthis
diffupdate
digraphs
display
djump
dlist
drop
dsearch
dsplit
earlier
echoerr
echomsg
echon
edit
else
elseif
emenu
endfor
endfunction
endif
endtry
endwhile
enew
ex
exit
Explore
exusage
file
files
filetype
finally
find
finish
first
fixdel
fold
foldclose
folddoclosed
folddoopen
foldopen
for
function
goto
grep
grepadd
hardcopy
help
helpfind
helpgrep
helptags
Hexplore
hide
history
I
iabbrev
iabclear
if
ijump
ilist
imapclear
inoreabbrev
isearch
isplit
iunabbrev
iunmap
join
jumps
k
keepalt
keepjumps
keepmarks
laddbuffer
laddexpr
laddfile
language
last
later
lbuffer
lcd
lchdir
lclose
left
leftabove
lexpr
lfile
lfirst
lgetbuffer
lgetexpr
lgetfile
lgrep
lgrepadd
lhelpgrep
list
ll
llast
llist
lmake
lmap
lmapclear
lnewer
lnext
lNext
lnfile
lNfile
lnoremap
loadview
lockmarks
lockvar
lolder
lopen
lpfile
lprevious
lrewind
ls
ltag
lunmap
lvimgrep
lvimgrepadd
lwindow
make
mark
marks
match
menutranslate
mkexrc
mksession
mkspell
mkview
mkvimrc
mode
move
mzfile
mzscheme
nbkey
NetrwSettings
new
next
Next
nmapclear
nohlsearch
noreabbrev
Nread
number
nunmap
Nw
omapclear
only
open
options
ounmap
pclose
pedit
perl
perldo
pop
popu
popup
ppop
preserve
previous
print
Print
profdel
profile
prompt
promptfind
promptrepl
psearch
ptag
ptfirst
ptjump
ptlast
ptnext
ptNext
ptprevious
ptrewind
ptselect
put
pwd
pyfile
python
qall
quit
quitall
read
recover
redir
redo
redraw
redrawstatus
registers
resize
retab
return
rewind
right
rightbelow
ruby
rubydo
rubyfile
runtime
rviminfo
sall
sandbox
sargument
saveas
sball
sbfirst
sblast
sbmodified
sbnext
sbNext
sbprevious
sbrewind
sbuffer
scriptencoding
scriptnames
set
setfiletype
setglobal
setlocal
Sexplore
sfind
sfirst
shell
sign
silent
simalt
slast
sleep
smagic
smap
smapclear
sme
smenu
snext
sNext
sniff
snomagic
snoremap
snoreme
snoremenu
sort
source
spelldump
spellgood
spellinfo
spellrepall
spellundo
spellwrong
split
sprevious
srewind
stag
startgreplace
startinsert
startreplace
stjump
stop
stopinsert
stselect
sunhide
sunmap
suspend
sview
syncbind
t
tab
tabclose
tabdo
tabedit
tabfind
tabfirst
tablast
tabmove
tabnew
tabnext
tabNext
tabonly
tabprevious
tabrewind
tabs
tag
tags
tcl
tcldo
tclfile
tearoff
tfirst
the
throw
tjump
tlast
tm
tmenu
tnext
tNext
topleft
tprevious
trewind
try
tselect
tu
tunmenu
unabbreviate
undo
undojoin
undolist
unhide
unlockvar
unmap
update
verbose
version
vertical
Vexplore
view
vimgrep
vimgrepadd
visual
viusage
vmapclear
vnew
vsplit
vunmap
wall
while
wincmd
windo
winpos
winsize
wnext
wNext
wprevious
wq
wqall
write
wsverb
wviminfo
X
xall
xit
xmap
xmapclear
xme
xmenu
XMLent
XMLns
xnoremap
xnoreme
xnoremenu
xunmap
yank
# names commands/abbreviated
ab
abc
abo
al
arga
argd
arge
argg
argl
ar
argu
as
bad
ba
bd
bel
bf
bl
bm
bn
bN
bo
bp
brea
breaka
breakd
breakl
br
bro
b
bun
bw
ca
cabc
caddb
cad
caddf
cal
cat
cb
ccl
ce
cex
cf
cfir
cgetb
cgete
cg
c
chd
che
checkt
cla
cl
clo
cmapc
cnew
cn
cN
cnf
cNf
cnorea
col
colo
comc
comp
conf
con
cope
co
cpf
cp
cq
cr
cuna
cu
cw
debugg
delc
d
delf
delm
diffg
diffpu
diffu
dig
di
dj
dl
dr
ds
dsp
echoe
echom
e
el
elsei
em
endfo
endf
en
endt
endw
ene
exi
exu
f
fina
fin
fini
fir
fix
fo
foldc
folddoc
foldd
foldo
fu
go
gr
grepa
ha
h
helpf
helpg
helpt
hid
his
ia
iabc
ij
il
imapc
inorea
is
isp
iuna
iu
j
ju
keepj
kee
laddb
lad
laddf
lan
la
lb
lc
lch
lcl
le
lefta
lex
lf
lfir
lgetb
lgete
lg
lgr
lgrepa
lh
l
lla
lli
lmak
lm
lmapc
lnew
lne
lN
lnf
lNf
ln
lo
loc
lockv
lol
lop
lpf
lp
lr
lt
lu
lv
lvimgrepa
lw
mak
ma
mat
menut
mk
mks
mksp
mkvie
mkv
mod
m
mzf
mz
n
N
nmapc
noh
norea
nu
nun
omapc
on
o
opt
ou
pc
ped
pe
perld
po
popu
pp
pre
prev
p
P
profd
prof
promptf
promptr
ps
pta
ptf
ptj
ptl
ptn
ptN
ptp
ptr
pts
pu
pw
pyf
py
qa
q
quita
r
rec
redi
red
redr
redraws
reg
res
ret
retu
rew
ri
rightb
rub
rubyd
rubyf
ru
rv
sal
san
sa
sav
sba
sbf
sbl
sbm
sbn
sbN
sbp
sbr
sb
scripte
scrip
se
setf
setg
setl
sf
sfir
sh
sil
sim
sla
sl
sm
sm
smapc
sn
sN
sni
sno
snor
sor
so
spelld
spe
spelli
spellr
spellu
spellw
sp
spr
sre
sta
startg
star
startr
stj
st
stopi
sts
sun
sunm
sus
sv
tabc
tabd
tabe
tabf
tabfir
tabl
tabn
tabN
tabo
tabp
tabr
ta
tc
tcld
tclf
te
tf
th
tj
tl
tm
tn
tN
to
tp
tr
ts
tu
una
u
undoj
undol
unh
unlo
unm
up
verb
ve
vert
vie
vim
vimgrepa
vi
viu
vmapc
vne
vs
vu
wa
wh
winc
winp
win
wn
wN
wp
wqa
w
ws
wv
xa
x
xm
xmapc
xn
xu
y
# names options/full
aleph
allowrevins
altkeymap
ambiwidth
antialias
autochdir
arabic
arabicshape
autoindent
autoread
autowrite
autowriteall
background
backspace
backup
backupcopy
backupdir
backupext
backupskip
balloondelay
ballooneval
balloonexpr
binary
bioskey
bomb
breakat
browsedir
bufhidden
buflisted
buftype
casemap
cdpath
cedit
charconvert
cindent
cinkeys
cinoptions
cinwords
clipboard
cmdheight
cmdwinheight
columns
comments
commentstring
compatible
complete
completefunc
completeopt
confirm
conskey
copyindent
cpoptions
cscopepathcomp
cscopeprg
cscopequickfix
cscopetag
cscopetagorder
cscopeverbose
cursorcolumn
cursorline
debug
define
delcombine
dictionary
diff
diffexpr
diffopt
digraph
directory
display
eadirection
edcompatible
encoding
endofline
equalalways
equalprg
errorbells
errorfile
errorformat
esckeys
eventignore
expandtab
exrc
fileencoding
fileencodings
fileformat
fileformats
filetype
fillchars
fkmap
foldclose
foldcolumn
foldenable
foldexpr
foldignore
foldlevel
foldlevelstart
foldmarker
foldmethod
foldminlines
foldnestmax
foldopen
foldtext
formatlistpat
formatoptions
formatprg
formatexpr
fsync
gdefault
grepformat
grepprg
guicursor
guifont
guifontset
guifontwide
guiheadroom
guioptions
guipty
guitablabel
guitabtooltip
helpfile
helpheight
helplang
hidden
highlight
hlsearch
history
hkmap
hkmapp
icon
iconstring
ignorecase
imactivatekey
imcmdline
imdisable
iminsert
imsearch
include
includeexpr
incsearch
indentexpr
indentkeys
infercase
insertmode
isfname
isident
iskeyword
isprint
joinspaces
key
keymap
keymodel
keywordprg
langmap
langmenu
laststatus
lazyredraw
linebreak
lines
linespace
lisp
lispwords
list
listchars
loadplugins
macatsui
magic
makeef
makeprg
matchpairs
matchtime
maxcombine
maxfuncdepth
maxmapdepth
maxmem
maxmempattern
maxmemtot
menuitems
mkspellmem
modeline
modelines
modifiable
modified
more
mouse
mousefocus
mousehide
mousemodel
mouseshape
mousetime
mzquantum
nrformats
number
numberwidth
omnifunc
operatorfunc
osfiletype
paragraphs
paste
pastetoggle
patchexpr
patchmode
path
preserveindent
previewheight
previewwindow
printdevice
printencoding
printexpr
printfont
printheader
printmbcharset
printmbfont
printoptions
pumheight
quoteescape
readonly
remap
report
restorescreen
revins
rightleft
rightleftcmd
ruler
rulerformat
runtimepath
scroll
scrollbind
scrolljump
scrolloff
scrollopt
sections
secure
selection
selectmode
sessionoptions
shell
shellcmdflag
shellpipe
shellquote
shellredir
shellslash
shelltemp
shelltype
shellxquote
shiftround
shiftwidth
shortmess
shortname
showbreak
showcmd
showfulltag
showmatch
showmode
showtabline
sidescroll
sidescrolloff
smartcase
smartindent
smarttab
softtabstop
spell
spellcapcheck
spellfile
spelllang
spellsuggest
splitbelow
splitright
startofline
statusline
suffixes
suffixesadd
swapfile
swapsync
switchbuf
synmaxcol
syntax
tabstop
tabline
tabpagemax
tagbsearch
taglength
tagrelative
tags
tagstack
term
termbidi
termencoding
terse
textauto
textmode
textwidth
thesaurus
tildeop
timeout
timeoutlen
title
titlelen
titleold
titlestring
toolbar
toolbariconsize
ttimeout
ttimeoutlen
ttybuiltin
ttyfast
ttymouse
ttyscroll
ttytype
undolevels
updatecount
updatetime
verbose
verbosefile
viewdir
viewoptions
viminfo
virtualedit
visualbell
warn
weirdinvert
whichwrap
wildchar
wildcharm
wildignore
wildmenu
wildmode
wildoptions
winaltkeys
winheight
winfixheight
winfixwidth
winminheight
winminwidth
winwidth
wrap
wrapmargin
wrapscan
write
writeany
writebackup
writedelay
# names options/abbreviated
al
ari
akm
ambw
anti
acd
arab
arshape
ai
ar
aw
awa
bg
bs
bk
bkc
bdir
bex
bsk
bdlay
beval
bexpr
bin
biosk
brk
bsdir
bh
bl
bt
cmp
cd
ccv
cin
cink
cino
cinw
cb
ch
cwh
co
com
cms
cp
cpt
cfu
cot
cf
consk
ci
cpo
cspc
csprg
csqf
cst
csto
csverb
cuc
cul
def
deco
dict
dex
dip
dg
dir
dy
ead
ed
enc
eol
ea
ep
eb
ef
efm
ek
ei
et
ex
fenc
fencs
ff
ffs
ft
fcs
fk
fcl
fdc
fen
fde
fdi
fdl
fdls
fmr
fdm
fml
fdn
fdo
fdt
flp
fo
fp
fex
fs
gd
gfm
gp
gcr
gfn
gfs
gfw
ghr
go
gtl
gtt
hf
hh
hlg
hid
hl
hls
hi
hk
hkp
ic
imak
imc
imd
imi
ims
inc
inex
is
inde
indk
inf
im
isf
isi
isk
isp
js
kmp
km
kp
lmap
lm
ls
lz
lbr
lsp
lw
lcs
lpl
mef
mp
mps
mat
mco
mfd
mmd
mm
mmp
mmt
mis
msm
ml
mls
ma
mod
mousef
mh
mousem
mouses
mouset
mzq
nf
nu
nuw
ofu
opfunc
oft
para
pt
pex
pm
pa
pi
pvh
pvw
pdev
penc
pexpr
pfn
pheader
pmbcs
pmbfn
popt
ph
qe
ro
rs
ri
rl
rlc
ru
ruf
rtp
scr
scb
sj
so
sbo
sect
sel
slm
ssop
sh
shcf
sp
shq
srr
ssl
stmp
st
sxq
sr
sw
shm
sn
sbr
sc
sft
sm
smd
stal
ss
siso
scs
si
sta
sts
spc
spf
spl
sps
sb
spr
sol
stl
su
sua
swf
sws
swb
smc
syn
ts
tal
tpm
tbs
tl
tr
tag
tgst
tbidi
tenc
ta
tx
tw
tsr
top
to
tm
tb
tbis
ttm
tbi
tf
ttym
tsl
tty
ul
uc
ut
vbs
vfile
vdir
vop
vi
ve
vb
wi
ww
wc
wcm
wig
wmnu
wim
wop
wak
wh
wfh
wfw
wmh
wmw
wiw
wm
ws
wa
wb
wd
# names events
BufAdd
BufCreate
BufDelete
BufEnter
BufFilePost
BufFilePre
BufHidden
BufLeave
BufNew
BufNewFile
BufRead
BufReadCmd
BufReadPost
BufReadPre
BufUnload
BufWinEnter
BufWinLeave
BufWipeout
BufWrite
BufWriteCmd
BufWritePost
BufWritePre
CmdwinEnter
CmdwinLeave
ColorScheme
CursorHold
CursorHoldI
CursorMoved
CursorMovedI
EncodingChanged
FileAppendCmd
FileAppendPost
FileAppendPre
FileChangedRO
FileChangedShell
FileChangedShellPost
FileEncoding
FileReadCmd
FileReadPost
FileReadPre
FileType
FileWriteCmd
FileWritePost
FileWritePre
FilterReadPost
FilterReadPre
FilterWritePost
FilterWritePre
FocusGained
FocusLost
FuncUndefined
GUIEnter
InsertChange
InsertEnter
InsertLeave
MenuPopup
QuickFixCmdPost
QuickFixCmdPre
RemoteReply
SessionLoadPost
ShellCmdPost
ShellFilterPost
SourcePre
SpellFileMissing
StdinReadPost
StdinReadPre
SwapExists
Syntax
TabEnter
TabLeave
TermChanged
TermResponse
User
UserGettingBored
VimEnter
VimLeave
VimLeavePre
VimResized
WinEnter
WinLeave
# names functions
add
append
argc
argidx
argv
browse
browsedir
bufexists
buflisted
bufloaded
bufname
bufnr
bufwinnr
byte2line
byteidx
call
changenr
char2nr
cindent
col
complete
complete_add
complete_check
confirm
copy
count
cscope_connection
cursor
deepcopy
delete
did_filetype
diff_filler
diff_hlID
empty
escape
eval
eventhandler
executable
exists
expand
expr8
extend
feedkeys
filereadable
filewritable
filter
finddir
findfile
fnamemodify
foldclosed
foldclosedend
foldlevel
foldtext
foldtextresult
foreground
function
garbagecollect
get
getbufline
getbufvar
getchar
getcharmod
getcmdline
getcmdpos
getcmdtype
getcwd
getfontname
getfperm
getfsize
getftime
getftype
getline
getloclist
getpos
getqflist
getreg
getregtype
gettabwinvar
getwinposx
getwinposy
getwinvar
glob
globpath
has
has_key
hasmapto
histadd
histdel
histget
histnr
hlexists
hlID
hostname
iconv
indent
index
input
inputdialog
inputlist
inputrestore
inputsave
inputsecret
insert
isdirectory
islocked
items
join
keys
len
libcall
libcallnr
line
line2byte
lispindent
localtime
map
maparg
mapcheck
match
matcharg
matchend
matchlist
matchstr
max
min
mkdir
mode
nextnonblank
nr2char
pathshorten
prevnonblank
printf
pumvisible
range
readfile
reltime
reltimestr
remote_expr
remote_foreground
remote_peek
remote_read
remote_send
remove
rename
repeat
resolve
reverse
search
searchdecl
searchpair
searchpairpos
searchpos
server2client
serverlist
setbufvar
setcmdpos
setline
setloclist
setpos
setqflist
setreg
settabwinvar
setwinvar
simplify
sort
soundfold
spellbadword
spellsuggest
split
str2nr
strftime
stridx
string
strlen
strpart
strridx
strtrans
submatch
substitute
synID
synIDattr
synIDtrans
system
tabpagebuflist
tabpagenr
tabpagewinnr
tagfiles
taglist
tempname
tolower
toupper
tr
type
values
virtcol
visualmode
winbufnr
wincol
winheight
winline
winnr
winrestcmd
winrestview
winsaveview
winwidth
writefile
