# automatically generated file, don't edit



# Copyright 2025 David Cantrell, derived from data from libphonenumber
# http://code.google.com/p/libphonenumber/
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.
package Number::Phone::StubCountry::DE;
use base qw(Number::Phone::StubCountry);

use strict;
use warnings;
use utf8;
our $VERSION = 1.20250605193635;

my $formatters = [
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            3[02]|
            40|
            [68]9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{2})(\\d{3,13})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            2(?:
              0[1-389]|
              12[0-8]
            )|
            3(?:
              [35-9][15]|
              4[015]
            )|
            906|
            2(?:
              [13][14]|
              2[18]
            )|
            (?:
              2[4-9]|
              4[2-9]|
              [579][1-9]|
              [68][1-8]
            )1
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{3,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            [24-6]|
            3(?:
              3(?:
                0[1-467]|
                2[127-9]|
                3[124578]|
                7[1257-9]|
                8[1256]|
                9[145]
              )|
              4(?:
                2[135]|
                4[13578]|
                9[1346]
              )|
              5(?:
                0[14]|
                2[1-3589]|
                6[1-4]|
                7[13468]|
                8[13568]
              )|
              6(?:
                2[1-489]|
                3[124-6]|
                6[13]|
                7[12579]|
                8[1-356]|
                9[135]
              )|
              7(?:
                2[1-7]|
                4[145]|
                6[1-5]|
                7[1-4]
              )|
              8(?:
                21|
                3[1468]|
                6|
                7[1467]|
                8[136]
              )|
              9(?:
                0[12479]|
                2[1358]|
                4[134679]|
                6[1-9]|
                7[136]|
                8[147]|
                9[1468]
              )
            )|
            70[2-8]|
            8(?:
              0[2-9]|
              [1-8]
            )|
            90[7-9]|
            [79][1-9]|
            3[68]4[1347]|
            3(?:
              47|
              60
            )[1356]|
            3(?:
              3[46]|
              46|
              5[49]
            )[1246]|
            3[4579]3[1357]
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2,11})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '138',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '3',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{2,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '181',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{5,11})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              3|
              80
            )|
            9
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d)(\\d{4,10})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '1[67]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '8',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{7,12})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18500',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '7',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{4})(\\d{4})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18[68]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '15[1279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{7})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '
            15(?:
              [0568]|
              31
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{5})(\\d{6})'
                },
                {
                  'format' => '$1 $2',
                  'leading_digits' => '18',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '
            1(?:
              6[023]|
              7
            )
          ',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{7,8})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15[279]',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{4})(\\d{2})(\\d{7})'
                },
                {
                  'format' => '$1 $2 $3',
                  'leading_digits' => '15',
                  'national_rule' => '0$1',
                  'pattern' => '(\\d{3})(\\d{2})(\\d{8})'
                }
              ];

my $validators = {
                'fixed_line' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'geographic' => '
          32\\d{9,11}|
          49[1-6]\\d{10}|
          322\\d{6}|
          49[0-7]\\d{3,9}|
          (?:
            [34]0|
            [68]9
          )\\d{3,13}|
          (?:
            2(?:
              0[1-689]|
              [1-3569]\\d|
              4[0-8]|
              7[1-7]|
              8[0-7]
            )|
            3(?:
              [3569]\\d|
              4[0-79]|
              7[1-7]|
              8[1-8]
            )|
            4(?:
              1[02-9]|
              [2-48]\\d|
              5[0-6]|
              6[0-8]|
              7[0-79]
            )|
            5(?:
              0[2-8]|
              [124-6]\\d|
              [38][0-8]|
              [79][0-7]
            )|
            6(?:
              0[02-9]|
              [1-358]\\d|
              [47][0-8]|
              6[1-9]
            )|
            7(?:
              0[2-8]|
              1[1-9]|
              [27][0-7]|
              3\\d|
              [4-6][0-8]|
              8[0-5]|
              9[013-7]
            )|
            8(?:
              0[2-9]|
              1[0-79]|
              2\\d|
              3[0-46-9]|
              4[0-6]|
              5[013-9]|
              6[1-8]|
              7[0-8]|
              8[0-24-6]
            )|
            9(?:
              0[6-9]|
              [1-4]\\d|
              [589][0-7]|
              6[0-8]|
              7[0-467]
            )
          )\\d{3,12}
        ',
                'mobile' => '
          1(?:
            (?:
              5(?:
                [0-25-9]\\d\\d|
                310
              )|
              7[26]\\d\\d
            )\\d{6}|
            6[023]\\d{7,8}
          )|
          17\\d{8}
        ',
                'pager' => '
          16(?:
            4\\d{1,10}|
            [89]\\d{1,11}
          )
        ',
                'personal_number' => '700\\d{8}',
                'specialrate' => '(
          180\\d{5,11}|
          13(?:
            7[1-6]\\d\\d|
            8
          )\\d{4}
        )|(
          (?:
            137[7-9]|
            900(?:
              [135]|
              9\\d
            )
          )\\d{6}
        )|(
          18(?:
            1\\d{5,11}|
            [2-9]\\d{8}
          )
        )',
                'toll_free' => '800\\d{7,12}',
                'voip' => ''
              };
my %areanames = ();
$areanames{de} = {"492339", "Sprockhövel\-Haßlinghausen",
"496364", "Nußbach\ Pfalz",
"496321", "Neustadt\ an\ der\ Weinstraße",
"499242", "Gößweinstein",
"497162", "Süßen",
"4934493", "Gößnitz\ Thüringen",
"499656", "Moosbach\ bei\ Vohenstrauß",
"497351", "Biberach\ an\ der\ Riß",
"4936705", "Oberweißbach\ Thüringer\ Wald",
"494509", "Groß\ Grönau",
"496663", "Steinau\ an\ der\ Straße",
"4936072", "Weißenborn\-Lüderode",
"4936484", "Knau\ bei\ Pößneck",
"494497", "Barßel\-Harkebrügge",
"499141", "Weißenburg\ in\ Bayern",
"4939934", "Groß\ Plasten",
"498633", "Tüßling",
"49911", "Nürnberg",
"499636", "Plößberg",
"4935240", "Tauscha\ bei\ Großenhain",
"4934901", "Roßlau\ Elbe",
"497355", "Hochdorf\ Riß",
"499567", "Seßlach\-Gemünda",
"4989", "München",
"498367", "Roßhaupten\ Forggensee",
"493647", "Pößneck",
"495384", "Seesen\-Groß\ Rhüden",
"4935938", "Großpostwitz\ OL",
"4935952", "Großröhrsdorf\ OL",
"495064", "Groß\ Düngen",
"498170", "Straßlach\-Dingharting",
"4934445", "Stößen",
"4935248", "Schönfeld\ bei\ Großenhain",
"494483", "Ovelgönne\-Großenmeer",
"498536", "Kößlarn",
"4935726", "Groß\ Särchen",
"495827", "Unterlüß",
"4939883", "Groß\ Dölln",
"498807", "Dießen\ am\ Ammersee",
"496252", "Heppenheim\ Bergstraße",
"495053", "Faßberg\-Müden",
"4935753", "Großräschen",
"49221", "Köln",
"4939976", "Groß\ Bützin",
"4935841", "Großschönau\ Sachsen",
"494684", "Langeneß\ Hallig",
"492203", "Köln\-Porz",
"4936949", "Obermaßfeld\-Grimmenthal",
"4938234", "Born\ Darß",};
$areanames{en} = {"497587", "Hosskirch",
"4935454", "Uckro",
"4939973", "Altkalen",
"498321", "Sonthofen",
"497176", "Spraitbach",
"4939881", "Ringenwalde\ bei\ Templin",
"496567", "Oberkail",
"49381", "Rostock",
"4939885", "Jakobshagen",
"499276", "Bischofsgrün",
"495282", "Schieder\-Schwalenberg",
"49561", "Kassel",
"498250", "Hilgertshausen\-Tandern",
"49906", "Donauwörth",
"496325", "Lambrecht\ Pfalz",
"4935693", "Lauschütz",
"498459", "Manching",
"4933232", "Brieselang",
"499463", "Wald\ Oberpfalz",
"492583", "Sassenberg",
"492555", "Schöppingen",
"498262", "Mittelneufnach",
"496762", "Kastellaun",
"493647", "Pössneck",
"4933638", "Rüdersdorf\ bei\ Berlin",
"4935877", "Cunewalde",
"4937382", "Geringswalde",
"496736", "Bechenheim",
"498236", "Fischach",
"492695", "Insul",
"492429", "Hürtgenwald",
"499502", "Frensdorf",
"497022", "Nürtingen",
"494284", "Selsingen",
"499852", "Feuchtwangen",
"495626", "Bad\ Zwesten",
"4933968", "Meyenburg\ Kreis\ Prignitz",
"494625", "Jübek",
"4937600", "Neumark\ Sachsen",
"494873", "Aukrug",
"498367", "Rosshaupten\ Forggensee",
"492351", "Lüdenscheid",
"494171", "Winsen\ Luhe",
"4937326", "Frauenstein\ Sachsen",
"494499", "Barssel",
"4933203", "Kleinmachnow",
"496578", "Salmtal",
"493621", "Gotha\ Thüringen",
"4939753", "Strasburg",
"494128", "Kollmar",
"496422", "Kirchhain",
"4935058", "Pretzschendorf",
"499338", "Röttingen\ Unterfranken",
"499443", "Abensberg",
"496157", "Pfungstadt",
"4936737", "Drognitz",
"492165", "Jüchen",
"495924", "Bad\ Bentheim\-Gildehaus",
"499401", "Neutraubling",
"495821", "Bad\ Bevensen",
"495123", "Schellerten",
"498347", "Friesenried",
"494922", "Borkum",
"4938295", "Satow\ bei\ Bad\ Doberan",
"4934929", "Straach",
"497937", "Dörzbach",
"4938309", "Trent",
"499394", "Esselbach",
"492677", "Lutzerath",
"4935385", "Annaburg",
"499723", "Röthlein",
"496742", "Boppard",
"499083", "Möttingen",
"4933438", "Altlandsberg",
"492992", "Marsberg",
"497825", "Kippenheim",
"497673", "Schönau\ im\ Schwarzwald",
"492933", "Sundern\ Sauerland",
"498378", "Buchenberg\ bei\ Kempten",
"498051", "Prien\ am\ Chiemsee",
"494144", "Himmelpforten",
"4937348", "Oberwiesenthal\ Kurort",
"4939080", "Kalbe\ Milde",
"494943", "Grossefehn",
"498654", "Freilassing",
"495977", "Spelle",
"494638", "Tarp",
"496394", "Bundenthal",
"494804", "Nordhastedt",
"499742", "Kalbach\ Rhön",
"496083", "Weilrod",
"495692", "Wolfhagen",
"496055", "Freigericht",
"4936083", "Uder",
"496723", "Oestrich\-Winkel",
"498223", "Ichenhausen",
"494554", "Wahlstedt",
"495948", "Itterbeck",
"498538", "Pocking\-Hartkirchen",
"497063", "Bad\ Wimpfen",
"495633", "Diemelsee",
"4933475", "Letschin",
"4933744", "Hohenseefeld",
"492253", "Bad\ Münstereifel",
"497906", "Braunsbach",
"4938871", "Mühlen\ Eichsen",
"4938875", "Schlagsdorf\ bei\ Gadebusch",
"495552", "Katlenburg",
"498405", "Stammham\ bei\ Ingolstadt",
"492859", "Wesel\-Bislich",
"499157", "Alfeld\ Mittelfranken",
"496443", "Ehringshausen\ Dill",
"497352", "Ochsenhausen",
"496338", "Hornbach\ Pfalz",
"4933362", "Liepe\ Kreis\ Barnim",
"495802", "Wrestedt",
"499422", "Bogen\ Niederbayern",
"492509", "Nottuln\-Appelhülsen",
"4937329", "Grosshartmannsdorf",
"4939296", "Welsleben",
"4933607", "Briesen\ Mark",
"499547", "Zapfendorf",
"492624", "Höhr\-Grenzhausen",
"496401", "Grünberg\ Hessen",
"495142", "Eschede",
"497257", "Bruchsal\-Untergrombach",
"497529", "Waldburg\ Württemberg",
"499762", "Saal\ an\ der\ Saale",
"4938822", "Diedrichshagen\ bei\ Grevesmühlen",
"495329", "Schulenberg\ im\ Oberharz",
"499736", "Oberthulba",
"497340", "Neenstetten",
"496502", "Schweich",
"4933671", "Lieberose",
"497043", "Maulbronn",
"497838", "Nordrach",
"496852", "Nohfelden",
"4933675", "Tauche",
"494164", "Harsefeld",
"494963", "Dörpen",
"4934342", "Neukieritzsch",
"495451", "Ibbenbüren",
"499521", "Hassfurt",
"496707", "Windesheim",
"498207", "Affing",
"4938306", "Samtens",
"4934926", "Pretzsch\ Elbe",
"499567", "Sesslach\-Gemünda",
"495136", "Burgdorf\ Kreis\ Hannover",
"4989", "Munich",
"495162", "Fallingbostel",
"498302", "Görisried",
"4934652", "Allstedt",
"499325", "Kleinlangheim",
"49291", "Meschede",
"497483", "Horb\-Mühringen",
"494135", "Kirchgellersen",
"497455", "Dornhan",
"496276", "Hesseneck",
"4938453", "Mistorf",
"4939392", "Rönnebeck\ Sachsen\-Anhalt",
"4936377", "Rastenberg",
"493921", "Burg\ bei\ Magdeburg",
"499343", "Lauda\-Königshofen",
"499438", "Fensterbach",
"496322", "Bad\ Dürkheim",
"495253", "Bad\ Driburg",
"495285", "Bad\ Pyrmont\-Kleinenberg",
"4934203", "Zwenkau",
"495509", "Rosdorf\ Kreis\ Göttingen",
"492802", "Alpen",
"497309", "Weissenhorn",
"495859", "Thomasburg",
"4938233", "Prerow\ Ostseebad",
"492552", "Steinfurt\-Borghorst",
"498234", "Bobingen",
"495021", "Nienburg\ Weser",
"496734", "Flonheim",
"498727", "Falkenberg\ Niederbayern",
"496227", "Walldorf\ Baden",
"4933200", "Bergholz\-Rehbrücke",
"494258", "Schwarme",
"4933051", "Nassenheide",
"494286", "Gyhum",
"495624", "Bad\ Emstal",
"4933055", "Kremmen",
"495067", "Bockenem",
"496261", "Mosbach\ Baden",
"498761", "Moosburg\ an\ der\ Isar",
"494622", "Taarstedt",
"4935435", "Gollmitz\ bei\ Calau",
"499274", "Hollfeld",
"492977", "Schmallenberg\-Bödefeld",
"4933929", "Gühlen\-Glienicke",
"496765", "Gemünden\ Hunsrück",
"498265", "Pfaffenhausen\ Schwaben",
"497973", "Obersontheim",
"492948", "Lippstadt\-Rebbeke",
"497174", "Mögglingen",
"499289", "Schwarzenbach\ am\ Wald",
"493967", "Oertzenhof\ bei\ Strasburg",
"492692", "Kelberg",
"499505", "Litzendorf",
"497753", "Albbruck",
"497025", "Neuffen",
"499480", "Sünching",
"499181", "Neumarkt\ in\ der\ Oberpfalz",
"4934779", "Abberode",
"499855", "Dentlein\ am\ Forst",
"492633", "Brohl\-Lützing",
"4938227", "Lüdershagen\ bei\ Barth",
"4935364", "Lebusa",
"492162", "Viersen",
"498421", "Eichstätt\ Bayern",
"49591", "Lingen\ \(Ems\)",
"4936844", "Rohr\ Thüringen",
"4938202", "Volkenshagen",
"499363", "Arnstein\ Unterfranken",
"4939723", "Krien",
"499396", "Urspringen\ bei\ Lohr",
"496670", "Ludwigsau\ Hessen",
"496425", "Rauschenberg\ Hessen",
"4935028", "Krippen",
"498245", "Türkheim\ Wertach",
"496745", "Gondershausen",
"493947", "Thale",
"498703", "Essenbach",
"497822", "Ettenheim",
"496203", "Ladenburg",
"4937603", "Wildenfels",
"494837", "Neuenkirchen\ Dithmarschen",
"4935892", "Horka\ OL",
"495926", "Engden",
"4934638", "Zöschen",
"496559", "Leidenborn",
"496809", "Grossrosseln",
"4937432", "Pausa\ Vogtland",
"496241", "Worms",
"498741", "Vilsbiburg",
"494925", "Hinte",
"498467", "Kinding",
"492150", "Meerbusch\-Lank",
"492451", "Geilenkirchen",
"496052", "Bad\ Orb",
"499745", "Wildflecken",
"495695", "Twistetal",
"4934671", "Bad\ Frankenhausen\ Kyffhäuser",
"497141", "Ludwigsburg\ Württemberg",
"497440", "Bad\ Rippoldsau",
"4939998", "Loitz\ bei\ Demmin",
"497843", "Renchen",
"499203", "Neudrossenfeld",
"492626", "Selters\ Westerwald",
"498630", "Oberneukirchen",
"495429", "Melle\-Wellingholzhausen",
"497249", "Stutensee",
"498563", "Bad\ Birnbach\ Rottal",
"497904", "Ilshofen",
"499241", "Pegnitz",
"495351", "Helmstedt",
"494663", "Süderlügum",
"497551", "Überlingen\ Bodensee",
"499149", "Weissenburg\-Suffersheim",
"493868", "Rastow",
"4933837", "Brielow",
"4937207", "Hainichen\ Sachsen",
"493605", "Leinefelde",
"494806", "Sarzbüttel",
"492387", "Drensteinfurt\-Walstedde",
"4933926", "Herzberg\ Mark",
"494556", "Ahrensbök\-Gnissau",
"4933336", "Passow\ Kreis\ Uckermark",
"4938450", "Tarnow\ bei\ Bützow",
"495145", "Beedenbostel",
"4933764", "Mittenwalde\ Mark",
"494146", "Stade\-Bützfleth",
"49261", "Koblenz\ am\ Rhein",
"4937368", "Deutschneudorf",
"4934422", "Osterfeld",
"496363", "Niederkirchen",
"4934776", "Rothenschirmbach",
"495583", "Braunlage\-Hohegeiss",
"495555", "Moringen\-Fredelsloh",
"4933652", "Neuzelle",
"498656", "Anger",
"496396", "Hinterweidenthal",
"498402", "Münchsmünster",
"4933982", "Hoppenrade\ Kreis\ Prignitz",
"495805", "Oetzen",
"497355", "Hochdorf\ Riss",
"497720", "Schwenningen\ am\ Neckar",
"497383", "Münsingen\-Buttenhausen",
"494643", "Gelting\ Angeln",
"499261", "Kronach",
"498774", "Bayerbach\ bei\ Ergoldsbach",
"496274", "Waldbrunn\ Odenwald",
"4934785", "Sandersleben",
"492867", "Heiden\ Kreis\ Borken",
"498153", "Wessling",
"498501", "Thyrnau",
"4934781", "Greifenhagen",
"494938", "Hagermarsch",
"498851", "Kochel\ am\ See",
"495677", "Calden\-Westuffeln",
"4935478", "Goyatz",
"495648", "Brakel\-Gehrden",
"497161", "Göppingen",
"499765", "Trappstadt",
"4938852", "Wittenburg",
"493877", "Wittenberge",
"4939083", "Messdorf",
"498029", "Kreuth\ bei\ Tegernsee",
"4935032", "Langenhennersdorf",
"496181", "Hanau",
"496505", "Kordel",
"498543", "Aidenbach",
"497269", "Sulzfeld\ Baden",
"495933", "Lathen",
"496855", "Freisen",
"495769", "Steyerberg\-Voigtei",
"494166", "Ahlerstedt",
"497127", "Neckartenzlingen",
"4934362", "Mügeln\ bei\ Oschatz",
"494132", "Amelinghausen",
"497452", "Nagold",
"496438", "Hünfelden",
"496343", "Bad\ Bergzabern",
"4933452", "Neulewin",
"494193", "Henstedt\-Ulzburg",
"4938423", "Bad\ Kleinen",
"496301", "Otterbach\ Pfalz",
"4934607", "Wettin",
"493902", "Diesdorf\ Altm",
"499227", "Neuenmarkt",
"499734", "Burkardroth",
"4934956", "Zörbig",
"492821", "Kleve\ Niederrhein",
"495198", "Schneverdingen\-Wintermoor",
"495165", "Rethem\ Aller",
"492924", "Möhnesee",
"4935242", "Nossen",
"494975", "Westerholt\ Ostfriesland",
"492384", "Welver",
"499431", "Schwandorf",
"494755", "Ihlienworth",
"494320", "Heidmühlen",
"493928", "Schönebeck\ Elbe",
"492066", "Duisburg\-Homberg",
"4934746", "Giersleben",
"494159", "Basthorst",
"492379", "Menden\-Asbeck",
"495028", "Pennigsehl",
"494251", "Hoya",
"495976", "Salzbergen",
"4936849", "Kleinschmalkalden",
"498649", "Schleching",
"496475", "Weilmünster\-Wolfenhausen",
"497256", "Philippsburg",
"492903", "Meschede\-Freienohl",
"4939223", "Theessen",
"496620", "Philippsthal\ Werra",
"492104", "Mettmann",
"496268", "Hüffenhardt",
"496295", "Rosenberg\ Baden",
"499546", "Burgebrach",
"4938727", "Mestlin",
"497907", "Schwäbisch\ Hall\-Sulzdorf",
"499188", "Postbauer\-Heng",
"498170", "Strasslach\-Dingharting",
"499156", "Neuhaus\ an\ der\ Pegnitz",
"4934954", "Roitzsch\ bei\ Bitterfeld",
"492844", "Rheinberg\-Orsoy",
"498291", "Zusmarshausen",
"492941", "Lippstadt",
"497124", "Trochtelfingen\ Hohenz",
"498572", "Tann\ Niederbayern",
"499653", "Eslarn",
"492835", "Issum",
"498669", "Traunreut",
"499737", "Wartmannsroth",
"4933931", "Rheinsberg\ Mark",
"494672", "Langenhorn",
"492927", "Neuengeseke",
"495071", "Schwarmstedt",
"4939005", "Kusey",
"4933924", "Rägelin",
"4939001", "Apenburg",
"495674", "Grebenstein",
"4933766", "Teupitz",
"492961", "Brilon",
"4933334", "Greiffenberg",
"492864", "Reken",
"4934445", "Stössen",
"496039", "Karben",
"496372", "Bruchmühlbach\-Miesau",
"4934774", "Röblingen\ am\ See",
"498206", "Egling\ an\ der\ Paar",
"496706", "Wallhausen\ Nahe",
"493874", "Ludwigslust",
"4934441", "Hohenmölsen",
"493971", "Anklam",
"4936253", "Georgenthal\ Thüringer\ Wald",
"499532", "Maroldsweisach",
"4939858", "Bietikow",
"4938370", "Kröslin",
"4938733", "Karbow\-Vietlübbe",
"499566", "Meeder",
"495137", "Seelze",
"492486", "Nettersheim",
"492754", "Bad\ Laasphe\-Feudingen",
"499277", "Warmensteinach",
"497634", "Sulzburg",
"499497", "Seubersdorf\ in\ der\ Oberpfalz",
"4939427", "Ströbeck",
"495064", "Gross\ Düngen",
"492871", "Bocholt",
"492974", "Schmallenberg\-Fredeburg",
"497031", "Böblingen",
"498444", "Schweitenkirchen",
"494385", "Hohenfelde\ bei\ Kiel",
"497148", "Grossbottwar",
"494353", "Ascheffel",
"495661", "Melsungen",
"492173", "Langenfeld\ Rheinland",
"493964", "Bredenfelde\ bei\ Strasburg",
"4936846", "Suhl\-Dietzhausen",
"499372", "Klingenberg\ am\ Main",
"496593", "Hillesheim\ Eifel",
"493861", "Plate",
"4939402", "Völpke",
"497586", "Herbertingen",
"497558", "Illmensee",
"496532", "Zeltingen\-Rachtig",
"4935952", "Grossröhrsdorf\ OL",
"495358", "Bahrdorf\-Mackendorf",
"497808", "Hohberg\ bei\ Offenburg",
"496566", "Körperich",
"498332", "Ottobeuren",
"4934244", "Mockrehna",
"497665", "March\ Breisgau",
"495035", "Gross\ Munzel",
"498366", "Oy\-Mittelberg",
"494105", "Seevetal",
"497942", "Neuenstein\ Württemberg",
"496653", "Burghaun",
"498393", "Holzgünz",
"495846", "Gartow\ Niedersachsen",
"498084", "Taufkirchen\ Vils",
"4936695", "Söllmnitz",
"496224", "Sandhausen\ Baden",
"498724", "Massing",
"496737", "Köngernheim",
"498237", "Aindling",
"493935", "Tangerhütte",
"4935725", "Wittichenau",
"4936691", "Eisenberg\ Thüringen",
"494845", "Ostenfeld\ Husum",
"498681", "Waging\ am\ See",
"4933978", "Segeletz",
"493841", "Wismar",
"494834", "Büsum",
"497950", "Schnelldorf",
"498858", "Kochel\-Walchensee",
"494931", "Norden",
"493944", "Blankenburg\ Harz",
"4939602", "Kleeth",
"495603", "Gudensberg",
"499295", "Töpen",
"499268", "Teuschnitz",
"4935772", "Rietschen",
"493585", "Löbau",
"496188", "Kahl\ am\ Main",
"495044", "Springe\-Eldagsen",
"494482", "Hatten",
"494608", "Handewitt",
"495641", "Warburg",
"498464", "Dietfurt\ an\ der\ Altmühl",
"497195", "Winnenden",
"493632", "Sondershausen",
"4936943", "Bettenhausen\ Thüringen",
"494865", "Osterhever",
"4933769", "Töpchin",
"495484", "Lienen\-Kattenvenne",
"493693", "Meiningen",
"496431", "Limburg\ an\ der\ Lahn",
"496130", "Schwabenheim\ an\ der\ Selz",
"497936", "Schrozberg\-Bartenstein",
"492828", "Emmerich\-Elten",
"495191", "Soltau",
"4936874", "Schönbrunn\ bei\ Hildburghaus",
"497645", "Freiamt",
"497962", "Fichtenau",
"498346", "Pforzen",
"493381", "Brandenburg\ an\ der\ Havel",
"498435", "Ehekirchen",
"495832", "Hankensbüttel",
"496308", "Olsbrücken",
"4939208", "Loitsche",
"492676", "Ulmen",
"497623", "Rheinfelden\ Baden",
"4938845", "Kaarssen",
"499773", "Unsleben",
"4935938", "Grosspostwitz\ OL",
"4938841", "Neuhaus\ Elbe",
"498328", "Balderschwang",
"499154", "Pommelsbrunn",
"499953", "Pilsting",
"494972", "Langeoog",
"4934321", "Leisnig",
"4938791", "Bad\ Wilsnack",
"4934325", "Mochau\-Lüttewitz",
"497254", "Waghäusel",
"494752", "Neuhaus\ Oste",
"492627", "Braubach",
"499544", "Baunach",
"4938304", "Garz\ Rügen",
"492064", "Dinslaken",
"4938757", "Neustadt\-Glewe",
"495754", "Extertal\-Bremke",
"492661", "Bad\ Marienberg\ Westerwald",
"495173", "Uetze",
"496397", "Leimen\ Pfalz",
"4934924", "Zahna",
"4938373", "Katzow",
"498657", "Ramsau\ bei\ Berchtesgaden",
"493671", "Saalfeld\ Saale",
"494557", "Blunk",
"496233", "Frankenthal\ Pfalz",
"498733", "Mengkofen",
"4933703", "Sperenberg",
"492358", "Meinerzhagen\-Valbert",
"494178", "Radbruch",
"496472", "Weilmünster",
"496292", "Seckach",
"4934465", "Bad\ Bibra",
"494121", "Elmshorn",
"499331", "Ochsenfurt",
"4934461", "Nebra\ Unstrut",
"498204", "Mickhausen",
"493876", "Perleberg",
"496704", "Langenlonsheim",
"494823", "Wilster",
"49711", "Stuttgart",
"496571", "Wittlich",
"493628", "Arnstadt",
"499564", "Bad\ Rodach",
"492484", "Mechernich\-Eiserfey",
"4936077", "Grossbodungen",
"499408", "Altenthann",
"495828", "Himbergen",
"492191", "Remscheid",
"495676", "Liebenau\ Hessen",
"4933746", "Werbig\ bei\ Jüterbog",
"492832", "Kevelaer",
"49921", "Bayreuth",
"499682", "Erbendorf",
"497072", "Gomaringen",
"492866", "Dorsten\-Rhade",
"496375", "Wallhalben",
"4939828", "Wustrow\ Kreis\ Mecklenburg\-Strelitz",
"4933088", "Falkenthal",
"499535", "Pfarrweisach",
"492603", "Bad\ Ems",
"4933732", "Hennickendorf\ bei\ Luckenwalde",
"497126", "Burladingen\-Melchingen",
"494167", "Apensen",
"4939294", "Gross\ Rosenburg",
"492641", "Bad\ Neuenahr\-Ahrweiler",
"494740", "Loxstedt\-Dedesdorf",
"4933397", "Wandlitz",
"499375", "Freudenberg\ Baden",
"498086", "Buchbach\ Oberbayern",
"4936602", "Ronneburg\ Thüringen",
"498726", "Schönau\ Niederbayern",
"496226", "Meckesheim",
"493644", "Apolda",
"4939383", "Sandau\ Elbe",
"494631", "Glücksburg\ Ostsee",
"496535", "Osann\-Monzel",
"499920", "Bischofsmais",
"494287", "Heeslingen\-Boitzen",
"495903", "Emsbüren",
"49340", "Dessau\ Anh",
"4939457", "Benneckenstein\ Harz",
"498364", "Seeg",
"4935797", "Schwepnitz",
"495941", "Neuenhaus\ Dinkel",
"495844", "Clenze",
"498531", "Pocking",
"494382", "Wangels",
"4935751", "Welzow",
"496331", "Pirmasens",
"493966", "Cölpin",
"495384", "Seesen\-Gross\ Rhüden",
"4935755", "Ortrand",
"499704", "Euerdorf",
"494842", "Nordstrand",
"497584", "Altshausen",
"499571", "Lichtenfels\ Bayern",
"4937464", "Schöneck\ Vogtland",
"496564", "Neuerburg\ Eifel",
"4936940", "Oepfershausen",
"498335", "Fellheim",
"495379", "Sassenburg\-Grussendorf",
"497662", "Vogtsburg\ im\ Kaiserstuhl",
"495032", "Neustadt\ am\ Rübenberge",
"497579", "Schwenningen\ Baden",
"497636", "Münstertal\ Schwarzwald",
"495066", "Sarstedt",
"497945", "Wüstenrot",
"496408", "Buseck",
"494102", "Ahrensburg",
"4936208", "Ermstedt",
"49871", "Landshut",
"496682", "Tann\ Rhön",
"49621", "Mannheim",
"498446", "Pörnbach",
"4936427", "Dornburg\ Saale",
"497934", "Weikersheim",
"497831", "Hausach",
"4935456", "Terpt",
"497133", "Lauffen\ am\ Neckar",
"494453", "Zetel",
"494485", "Elsfleth\-Huntorf",
"498344", "Westendorf\ bei\ Kaufbeuren",
"495864", "Jameln",
"495961", "Haselünne",
"492674", "Bad\ Bertrich",
"499397", "Wertheim\-Dertingen",
"497192", "Murrhardt",
"499528", "Donnersdorf",
"495458", "Hopsten",
"4936963", "Dorndorf\ Rhön",
"499233", "Arzberg\ Oberfranken",
"499472", "Hohenfels\ Oberpfalz",
"492137", "Neuss\-Norf",
"499292", "Konradsreuth",
"492689", "Dierdorf",
"4939832", "Wesenberg",
"497642", "Endingen\ Kaiserstuhl",
"4939347", "Kade",
"497965", "Ellwangen\-Röhlingen",
"498273", "Nordendorf",
"496773", "Kamp\-Bornhofen",
"496154", "Ober\-Ramstadt",
"4935975", "Hohnstein",
"4937752", "Eibenstock",
"498432", "Burgheim",
"495835", "Wahrenholz",
"498466", "Denkendorf\ Oberbayern",
"4935971", "Sebnitz",
"494836", "Hennstedt\ Dithmarschen",
"493635", "Kölleda",
"493946", "Quedlinburg",
"4934978", "Radegast\ Kreis\ Köthen",
"494862", "Garding",
"4937324", "Reinsberg\ Sachsen",
"496544", "Rhaunen",
"492388", "Hamm\-Uentrop",
"492902", "Warstein",
"496526", "Bollendorf",
"49831", "Kempten\ Allgäu",
"493821", "Ribnitz\-Damgarten",
"4938392", "Sassnitz",
"494176", "Marschacht",
"498735", "Gangkofen\-Kollbach",
"496235", "Schifferstadt",
"4934722", "Preusslitz",
"498139", "Röhrmoos",
"495175", "Lehrte\-Arpke",
"495621", "Bad\ Wildungen",
"4938750", "Malliss",
"498687", "Taching\-Tengling",
"4933972", "Breddin",
"4936257", "Luisenthal\ Thüringen",
"4938737", "Ganzlin",
"498231", "Königsbrunn\ bei\ Augsburg",
"495024", "Rohrsen\ Kreis\ Nienburg\ Weser",
"496731", "Alzey",
"499179", "Freystadt",
"4934955", "Gossa",
"496264", "Neudenau",
"498764", "Mauern\ Kreis\ Freising",
"499491", "Hemau",
"499190", "Heroldsbach",
"499271", "Thurnau\-Alladorf",
"499184", "Deining\ Oberpfalz",
"4939408", "Hadmersleben",
"499955", "Mamming",
"497625", "Zell\ im\ Wiesental",
"499775", "Schönau\ an\ der\ Brend",
"493867", "Lübstorf",
"497171", "Schwäbisch\ Gmünd",
"49651", "Trier",
"498326", "Fischen\ im\ Allgäu",
"492330", "Herdecke",
"49361", "Erfurt",
"498424", "Nassenfels",
"497128", "Sonnenbühl",
"494409", "Westerstede\-Ocholt",
"499533", "Untermerzbach",
"4938723", "Kladrum",
"492605", "Löf",
"499228", "Thurnau",
"49581", "Uelzen",
"496373", "Schönenberg\-Kübelberg",
"4939202", "Gross\ Ammensleben",
"495197", "Soltau\-Frielingen",
"498573", "Ering",
"499406", "Mintraching",
"495826", "Suderburg",
"499652", "Waidhaus",
"4939608", "Staven",
"4934444", "Lützen",
"4934775", "Wippra",
"4934771", "Querfurt",
"493847", "Sternberg",
"4935439", "Zinnitz",
"4933331", "Casekow",
"495647", "Lichtenau\-Kleinenberg",
"4933335", "Pinnow\ Kreis\ Uckermark",
"492454", "Gangelt",
"498744", "Gerzen",
"496244", "Westhofen\ Rheinhessenen",
"4939004", "Köckte\ bei\ Gardelegen",
"4933921", "Zechlinerhütte",
"494673", "Joldelund",
"4933925", "Wustrau\-Altfriesack",
"494825", "Burg\ Dithmarschen",
"496652", "Hünfeld",
"496406", "Lollar",
"498392", "Markt\ Rettenbach",
"495068", "Elze\ Leine",
"492758", "Bad\ Berleburg\-Girkhausen",
"4936947", "Jüchsen",
"498333", "Babenhausen\ Schwaben",
"497144", "Marbach\ am\ Neckar",
"497943", "Schöntal\ Jagst",
"492947", "Anröchte",
"493968", "Schönbeck",
"493329", "Stahnsdorf",
"499244", "Betzenstein",
"495354", "Jerxheim",
"497804", "Oppenau",
"497554", "Heiligenberg\ Baden",
"4935248", "Schönfeld\ bei\ Grossenhain",
"494352", "Damp",
"4936694", "Schkölen\ Thüringen",
"4935724", "Lohsa",
"4936453", "Mellingen",
"49201", "Essen",
"499099", "Kaisheim",
"496533", "Morbach\ Hunsrück",
"4939363", "Angern",
"494257", "Schweringen",
"498728", "Geratskirchen",
"496228", "Schönau\ Odenwald",
"496660", "Steinau\-Marjoss",
"495905", "Beesten",
"496592", "Daun",
"499373", "Amorbach",
"498056", "Eggstätt",
"499070", "Tapfheim",
"4934241", "Jesewitz",
"4933056", "Mühlenbeck\ Kreis\ Oberhavel",
"494340", "Achterwehr",
"498504", "Tittling",
"494838", "Tellingstedt",
"496190", "Hattersheim\ am\ Main",
"499264", "Küps",
"494529", "Süsel\-Bujendorf",
"496271", "Eberbach\ Baden",
"498771", "Ergoldsbach",
"496184", "Langenselbold",
"495131", "Garbsen",
"495833", "Brome",
"498629", "Palling",
"4939852", "Schönermark\ bei\ Prenzlau",
"497164", "Boll\ Kreis\ Göppingen",
"498468", "Altmannstein\-Pondorf",
"49951", "Bamberg",
"497963", "Adelmannsfelden",
"492599", "Ascheberg\-Herbern",
"494604", "Grossenwiehe",
"496775", "Strüth\ Taunus",
"495456", "Westerkappeln\-Velpe",
"497739", "Hilzingen",
"4936653", "Lehesten\ Thüringer\ Wald",
"495602", "Hessisch\ Lichtenau",
"4939423", "Wegeleben",
"499526", "Riedbach",
"4936875", "Straufhain\-Streufdorf",
"499235", "Thierstein",
"4936871", "Bad\ Colberg\-Heldburg",
"492824", "Kalkar",
"492921", "Soest",
"496304", "Wolfstein\ Pfalz",
"4935436", "Laasow\ bei\ Calau",
"494455", "Jade\-Schweiburg",
"497135", "Brackenheim",
"494483", "Ovelgönne\-Grossenmeer",
"495172", "Ilsede",
"49391", "Magdeburg",
"499186", "Lauterhofen\ Oberpfalz",
"4938720", "Grebbin",
"4938794", "Cumlosen",
"4934324", "Ostrau\ Sachsen",
"498324", "Hindelang",
"496337", "Grossbundenbach",
"499158", "Offenhausen\ Mittelfranken",
"496473", "Leun",
"492905", "Bestwig\-Ramsbeck",
"4933676", "Friedland\ bei\ Beeskow",
"496293", "Schefflenz",
"498766", "Gammelsdorf",
"496266", "Hassmersheim",
"4936202", "Neudietendorf",
"499548", "Mühlhausen\ Mittelfranken",
"4938844", "Gülze",
"497258", "Oberderdingen\-Flehingen",
"498732", "Frontenhausen",
"496232", "Speyer",
"4933393", "Gross\ Schönebeck\ Kreis\ Barnim",
"494281", "Zeven",
"4936608", "Seelingstädt\ bei\ Gera",
"499952", "Eichendorf",
"494637", "Sterup",
"495978", "Hörstel\-Dreierwalde",
"497622", "Schopfheim",
"499306", "Kist",
"499772", "Bischofsheim\ an\ der\ Rhön",
"495026", "Steimbke",
"494189", "Undeloh",
"4934921", "Kemberg",
"494753", "Balje",
"498537", "Bad\ Füssing\-Aigen",
"496524", "Rodershausen",
"4934925", "Bad\ Schmiedeberg",
"495947", "Laar\ Vechte",
"4938305", "Gingst",
"494973", "Wittmund\-Burhafe",
"4935389", "Holzdorf\ Elster",
"492354", "Meinerzhagen",
"494174", "Stelle\ Kreis\ Harburg",
"4938301", "Putbus",
"496708", "Bad\ Münster\ am\ Stein\-Ebernburg",
"498208", "Eurasburg\ bei\ Augsburg",
"4933476", "Neuhardenberg",
"4938753", "Wöbbelin",
"495659", "Ringgau",
"492602", "Montabaur",
"492456", "Selfkant",
"499568", "Neustadt\ bei\ Coburg",
"496246", "Eich\ Rheinhessen",
"493624", "Ohrdruf",
"4938377", "Zinnowitz",
"49841", "Ingolstadt\ Donau",
"495921", "Nordhorn",
"499404", "Nittendorf",
"495824", "Bad\ Bodenteich",
"4934464", "Freyburg\ Unstrut",
"4939889", "Boitzenburg",
"499391", "Marktheidenfeld",
"4939291", "Calbe\ Saale",
"497837", "Oberharmersbach",
"494822", "Kellinghusen",
"4939295", "Zuchau",
"499655", "Tännesberg",
"499683", "Friedenfels",
"492833", "Kerken",
"498426", "Walting\ Kreis\ Eichstätt",
"492131", "Neuss",
"497073", "Ammerbuch",
"4938876", "Roggendorf",
"498651", "Bad\ Reichenhall",
"4939343", "Jerichow",
"496391", "Dahn",
"494249", "Bassum\-Nordwohlde",
"492667", "Stein\-Neukirch",
"498054", "Breitbrunn\ am\ Chiemsee",
"494141", "Stade",
"4934261", "Kühren\ bei\ Wurzen",
"493933", "Genthin",
"494843", "Viöl",
"495108", "Gehrden\ Han",
"496683", "Ehrenberg\ Rhön",
"498368", "Halblech",
"496655", "Neuhof\ Kreis\ Fulda",
"4935268", "Stauchitz",
"498395", "Tannheim\ Württemberg",
"497663", "Eichstetten",
"495033", "Wunstorf\-Grossenheidorn",
"494551", "Bad\ Segeberg",
"493677", "Ilmenau\ Thüringen",
"495848", "Trebel",
"494103", "Wedel",
"4933679", "Wendisch\ Rietz",
"4936423", "Orlamünde",
"499708", "Bad\ Bocklet",
"4935932", "Guttau",
"495902", "Freren",
"499246", "Pegnitz\-Trockau",
"496595", "Dockweiler",
"497806", "Bad\ Peterstal\-Griesbach",
"496568", "Wolsfeld",
"492779", "Greifenstein\-Beilstein",
"495356", "Helmstedt\-Barmke",
"497556", "Uhldingen\-Mühlhofen",
"4935322", "Doberlug\-Kirchhain",
"496404", "Lich\ Hessen",
"492621", "Lahnstein",
"4936967", "Geisa",
"4937465", "Tannenbergsthal\ Vogtland",
"494383", "Grebin",
"494355", "Rieseby",
"492175", "Leichlingen\ Rheinland",
"4935386", "Prettin",
"498591", "Obernzell",
"4938296", "Rerik\ Ostseebad",
"497146", "Remseck\ am\ Neckar",
"4935754", "Klettwitz",
"498433", "Königsmoos",
"498348", "Bidingen",
"497938", "Mulfingen\ Jagst",
"492826", "Kranenburg\ Niederrhein",
"496306", "Trippstadt",
"4933082", "Menz\ Kreis\ Oberhavel",
"4939822", "Kratzeburg",
"492678", "Büchel\ bei\ Cochem",
"497643", "Herbolzheim\ Breisgau",
"4933479", "Küstrin\-Kietz",
"498272", "Wertingen",
"496772", "Nastätten",
"495454", "Hörstel\-Riesenbeck",
"4939886", "Milmersdorf",
"493695", "Bad\ Salzungen",
"492647", "Kesseling",
"499524", "Zeil\ am\ Main",
"494269", "Ahausen\-Kirchwalsede",
"494161", "Buxtehude",
"494863", "Sankt\ Peter\-Ording",
"498377", "Unterthingau",
"4937325", "Niederbobritzsch",
"496186", "Grosskrotzenburg",
"4937321", "Frankenstein\ Sachsen",
"4936450", "Kranichfeld",
"4935843", "Hirschfelde\ bei\ Zittau",
"497193", "Sulzbach\ an\ der\ Murr",
"4939387", "Havelberg",
"497166", "Adelberg",
"493583", "Zittau",
"496158", "Riedstadt",
"499337", "Gaukönigshofen",
"497132", "Neckarsulm",
"494452", "Zetel\-Neuenburg",
"494127", "Westerhorn",
"494606", "Wanderup",
"4935974", "Hinterhermsdorf",
"495605", "Kaufungen\ Hessen",
"4936623", "Berga\ Elster",
"499473", "Kallmünz",
"498506", "Bad\ Höhenstadt",
"499293", "Berg\ Oberfranken",
"4939453", "Derenburg",
"4935793", "Elstra",
"498856", "Penzberg",
"499266", "Mitwitz",
"49281", "Wesel",
"499232", "Wunsiedel",
"499503", "Oberhaid\ Oberfranken",
"497755", "Weilheim\ Kreis\ Waldshut",
"498869", "Kinsau",
"499151", "Hersbruck",
"497023", "Weilheim\ an\ der\ Teck",
"499853", "Wilburgstetten",
"495520", "Braunlage",
"492635", "Rheinbrohl",
"498296", "Villenbach",
"498263", "Breitenbrunn\ Schwaben",
"496763", "Kirchberg\ Hunsrück",
"497975", "Untergröningen",
"4933368", "Hohensaaten",
"494230", "Verden\-Walle",
"497251", "Bruchsal",
"4939884", "Hassleben\ bei\ Prenzlau",
"496407", "Rabenau\ Hessen",
"4935455", "Walddrehna",
"494872", "Hanerau\-Hademarschen",
"4935451", "Dahme\ Brandenburg",
"497159", "Renningen",
"4937342", "Cranzahl",
"492664", "Rennerod",
"494256", "Hilgermissen",
"4933207", "Gross\ Kreutz",
"495971", "Rheine",
"495874", "Soltendieck",
"495751", "Rinteln",
"498057", "Aschau\-Sachrang",
"494288", "Horstedt\ Kreis\ Rotenburg",
"499436", "Nittenau",
"4936370", "Grossenehrich",
"4936733", "Kaulsdorf",
"499462", "Falkenstein\ Oberpfalz",
"492582", "Everswinkel",
"499345", "Külsheim\ Baden",
"495255", "Altenbeken",
"495283", "Lügde\-Rischenau",
"496574", "Hasborn",
"4935873", "Herrnhut",
"499561", "Coburg",
"494124", "Glückstadt",
"499334", "Giebelstadt",
"496701", "Sprendlingen\ Rheinhessen",
"494923", "Krummhörn\-Pewsum",
"493976", "Torgelow\ bei\ Ueckermünde",
"492932", "Neheim\-Hüsten",
"4934658", "Hayn\ Harz",
"496589", "Kell\ am\ See",
"499722", "Werneck",
"498243", "Fuchstal",
"499082", "Oettingen\ in\ Bayern",
"497569", "Isny\-Eisenbach",
"496743", "Bacharach",
"492993", "Marsberg\-Canstein",
"498705", "Altfraunhofen",
"496205", "Hockenheim",
"497672", "St\ Blasien",
"4938828", "Schönberg",
"496423", "Wetter\ Hessen",
"499442", "Riedenburg",
"4939977", "Jördenstorf",
"498389", "Weissensberg",
"4935341", "Bad\ Liebenwerda",
"499398", "Birkenfeld\ bei\ Würzburg",
"4936702", "Lauscha",
"499365", "Rimpar",
"499527", "Knetzgau",
"4935384", "Steinsdorf\ bei\ Jessen",
"492644", "Linz\ am\ Rhein",
"4938220", "Wustrow\ Ostseebad",
"495457", "Hopsten\-Schale",
"4934348", "Frohburg",
"4935756", "Hosena",
"4935697", "Bagenz",
"498374", "Dietmannsried",
"492041", "Bottrop",
"4938294", "Neubukow",
"495553", "Kalefeld",
"499820", "Lehrberg",
"495585", "Herzberg\-Sieber",
"4933632", "Hangelsberg",
"498686", "Petting",
"4933741", "Niedergörsdorf",
"495101", "Pattensen",
"4933474", "Neutrebbin",
"495803", "Rosche",
"497385", "Gomadingen",
"494148", "Drochtersen\-Assel",
"497353", "Schwendi",
"496442", "Braunfels",
"499423", "Geiselhöring",
"4933745", "Petkus",
"492252", "Zülpich",
"495209", "Gütersloh\-Friedrichsdorf",
"4933962", "Heiligengrabe",
"493641", "Jena",
"496398", "Vorderweidenthal",
"494634", "Husby",
"494558", "Todesfelde",
"495944", "Hoogstede",
"496527", "Oberweis",
"495841", "Lüchow\ Wendland",
"498534", "Tettenweis",
"495143", "Winsen\ Aller",
"4936043", "Kirchheilingen",
"493603", "Bad\ Langensalza",
"494177", "Drage\ Elbe",
"492357", "Herscheid\ Westfalen",
"4934466", "Janisroda",
"498361", "Nesselwang",
"4938457", "Krakow\ am\ See",
"499574", "Marktzeuln",
"496561", "Bitburg",
"496334", "Thaleischweiler\-Fröschen",
"498327", "Rettenberg",
"495381", "Seesen",
"4937200", "Wittgensdorf\ bei\ Chemnitz",
"493866", "Cambs",
"4933830", "Ziesar",
"494665", "Emmelsbüll\-Horsbüll",
"494942", "Südbrookmerland",
"499701", "Sandberg\ Unterfranken",
"497581", "Saulgau",
"497709", "Wutach",
"497062", "Beilstein\ Württemberg",
"495632", "Willingen\ Upland",
"498565", "Dietersburg\-Baumgarten",
"496082", "Niederreifenberg",
"495693", "Volkmarsen",
"4933238", "Senzke",
"498222", "Burgau\ Schwaben",
"496722", "Rüdesheim\ am\ Rhein",
"4938874", "Lützow",
"492628", "Rhens",
"499205", "Vorbach",
"493386", "Premnitz",
"495861", "Dannenberg\ Elbe",
"494770", "Wischhafen",
"495964", "Lähden",
"495163", "Fallingbostel\-Dorfmark",
"492671", "Cochem",
"4934600", "Ostrau\ Saalkreis",
"495196", "Wietzendorf",
"497931", "Bad\ Mergentheim",
"494950", "Holtland",
"497834", "Wolfach",
"4938796", "Viesecke",
"498341", "Kaufbeuren",
"49465", "Sylt",
"496436", "Dornburg\ Hessen",
"4933432", "Müncheberg",
"4934382", "Nerchau",
"494195", "Hartenholm",
"496462", "Gladenbach",
"494168", "Neu\ Wulmstorf\-Elstorf",
"4933674", "Trebatsch",
"498303", "Waltenhofen",
"4933603", "Falkenhagen\ bei\ Seelow",
"493661", "Greiz",
"496345", "Albersweiler",
"497482", "Horb\-Dettingen",
"492449", "Blankenheim\ Ahr",
"496151", "Darmstadt",
"497042", "Vaihingen\ an\ der\ Enz",
"496503", "Hermeskeil",
"498545", "Hofkirchen\ Bayern",
"495646", "Willebadessen",
"495935", "Twist\-Schöninghsdorf",
"496853", "Marpingen",
"499763", "Sulzdorf\ an\ der\ Lederhecke",
"4935052", "Kipsdorf\ Kurort",
"4936087", "Wüstheuterode",
"495827", "Unterlüss",
"496541", "Traben\-Trarbach",
"499407", "Wenzenbach",
"494936", "Grossheide",
"494962", "Papenburg\-Aschendorf",
"499434", "Bodenwöhr",
"4937607", "Ebersbrunn\ Sachsen",
"4933054", "Liebenwalde",
"494623", "Böklund",
"494875", "Stafstedt",
"492381", "Hamm\ Westfalen",
"492666", "Freilingen\ Westerwald",
"498238", "Gessertshausen",
"4937362", "Seiffen\ Erzgebirge",
"494254", "Eystrup",
"492632", "Andernach",
"497972", "Gschwend\ bei\ Gaildorf",
"492693", "Antweiler",
"499278", "Weidenberg",
"492803", "Wesel\-Büderich",
"4939992", "Görmin",
"499465", "Neukirchen\-Balbini",
"492553", "Ochtrup",
"492585", "Warendorf\-Hoetmar",
"499498", "Laaber",
"4938223", "Saal\ Vorpom",
"497147", "Sachsenheim\ Württemberg",
"499342", "Wertheim",
"496020", "Heigenbrücken",
"495252", "Bad\ Lippspringe",
"496323", "Edenkoben",
"4939009", "Badel",
"492841", "Moers",
"492944", "Rietberg\-Mastholte",
"498294", "Horgau",
"497557", "Herdwangen\-Schönach",
"4939727", "Spantekow",
"4935434", "Altdöbern",
"497807", "Neuried\ Ortenaukreis",
"4939861", "Gramzow\ bei\ Prenzlau",
"495357", "Grasleben",
"492935", "Sundern\-Hachen",
"492646", "Königsfeld\ Eifel",
"4937422", "Markneukirchen",
"497229", "Iffezheim",
"499350", "Eussenheim\-Hundsbach",
"499725", "Poppenhausen\ Unterfranken",
"4936841", "Schleusingen",
"499085", "Alerheim",
"4933458", "Falkenberg\ Mark",
"497420", "Deisslingen",
"497121", "Reutlingen",
"498376", "Sulzberg\ Allgäu",
"498702", "Wörth\ an\ der\ Isar",
"497823", "Seelbach\ Schutter",
"496202", "Schwetzingen",
"4936845", "Gehlberg",
"4933093", "Fürstenberg\ Havel",
"497675", "Bernau\ Baden",
"492827", "Goch\-Hassum",
"499129", "Wendelstein",
"494339", "Christiansholm",
"499221", "Kulmbach",
"4935361", "Schlieben",
"496307", "Schopp",
"4935365", "Falkenberg\ Elster",
"495671", "Hofgeismar",
"4936373", "Buttstädt",
"492163", "Schwalmtal\ Niederrhein",
"4936730", "Sitzendorf",
"498857", "Benediktbeuern",
"492964", "Brilon\-Alme",
"498507", "Neuburg\ am\ Inn",
"492861", "Borken\ Westfalen",
"495074", "Rodewald",
"4934207", "Zwochau",
"4935726", "Gross\ Särchen",
"499267", "Nordhalben",
"4935472", "Schlepzig",
"492196", "Wermelskirchen",
"496639", "Ottrau",
"4938858", "Lassahn",
"496187", "Schöneck",
"499445", "Neustadt\ an\ der\ Donau",
"494126", "Horst\ Holstein",
"494607", "Janneby",
"4934222", "Arzberg\ bei\ Torgau",
"499336", "Bütthard",
"493871", "Parchim",
"492874", "Isselburg",
"492971", "Schmallenberg\-Dorlar",
"497034", "Ehningen",
"498441", "Pfaffenhofen\ an\ der\ Ilm",
"495664", "Morschen",
"492751", "Bad\ Berleburg",
"497631", "Müllheim\ Baden",
"496267", "Fahrenbach\ Baden",
"4938427", "Blowatz",
"498550", "Philippsreut",
"495582", "Sankt\ Andreasberg",
"4934603", "Nauendorf\ Sachsen\-Anhalt",
"499639", "Mähring",
"499576", "Lichtenfels\-Isling",
"498403", "Pförring",
"499187", "Altdorf\ bei\ Nürnberg",
"497382", "Römerstein",
"496445", "Schöffengrund",
"493961", "Altentreptow",
"492255", "Euskirchen\-Flamersheim",
"496336", "Dellfeld",
"496362", "Alsenz",
"495946", "Georgsdorf",
"4939398", "Gross\ Garz",
"498536", "Kösslarn",
"492520", "Wadersloh\-Diestedde",
"495635", "Vöhl",
"498679", "Burgkirchen\ an\ der\ Alz",
"498562", "Triftern",
"496053", "Wächtersbach",
"496085", "Waldsolms",
"496725", "Gau\-Algesheim",
"498225", "Jettingen\-Scheppach",
"497842", "Kappelrodeck",
"4934446", "Grosskorbetha",
"499202", "Waischenfeld",
"498684", "Fridolfing",
"4933765", "Märkisch\ Buchholz",
"4939087", "Jerchel\ Altmark",
"496129", "Schlangenbad",
"498081", "Dorfen\ Stadt",
"498721", "Eggenfelden",
"494662", "Leck",
"496221", "Heidelberg",
"495027", "Linsburg",
"499307", "Altertheim",
"494945", "Grossefehn\-Timmel",
"494636", "Langballig",
"4939006", "Miesterhorst",
"494192", "Bad\ Bramstedt",
"496465", "Breidenbach\ bei\ Biedenkopf",
"493844", "Schwaan",
"495300", "Salzgitter\-Üfingen",
"4934741", "Frose",
"494934", "Marienhafe",
"4934632", "Mücheln\ Geiseltal",
"493941", "Halberstadt",
"499323", "Iphofen",
"4934745", "Winningen\ Sachsen\-Anhalt",
"497453", "Altensteig\ Württemberg",
"497485", "Empfingen",
"4937438", "Bad\ Brambach",
"496342", "Schweigen\-Rechtenbach",
"494133", "Wittorf\ Kreis\ Lüneburg",
"495644", "Willebadessen\-Peckelsheim",
"498461", "Beilngries",
"495041", "Springe\ Deister",
"496247", "Worms\-Pfeddersheim",
"495138", "Sehnde",
"498152", "Herrsching\ am\ Ammersee",
"495481", "Lengerich\ Westfalen",
"498427", "Wellheim",
"493379", "Mahlow",
"496434", "Bad\ Camberg",
"494642", "Kappeln\ Schlei",
"494965", "Surwold",
"499738", "Rottershausen",
"497045", "Oberderdingen",
"495966", "Meppen\-Apeldorn",
"498542", "Ortenburg",
"4938208", "Kavelstorf",
"495932", "Haren\ Ems",
"492369", "Dorsten\-Wulfen",
"495194", "Bispingen",
"492928", "Soest\-Ostönnen",
"497836", "Schiltach",
"4937203", "Gersdorf\ bei\ Chemnitz",
"4933833", "Wollin\ bei\ Brandenburg",
"4935022", "Bad\ Schandau",
"4936374", "Weissensee",
"499260", "Wilhelmsthal\ Oberfranken",
"499628", "Ursensollen",
"492205", "Rösrath",
"492743", "Daaden",
"493564", "Schwarze\ Pumpe",
"4939952", "Grammentin",
"498453", "Reichertshofen\ Oberbayern",
"494344", "Schönberg\ Holstein",
"493331", "Angermünde",
"499876", "Rohr\ Mittelfranken",
"497958", "Rot\ Am\ See\-Brettheim",
"499469", "Roding\-Neubäu",
"495882", "Gorleben",
"497461", "Tuttlingen",
"493682", "Zella\-Mehlis",
"4939366", "Kehnert",
"4937601", "Mülsen\ Skt\ Jacob",
"497747", "Berau",
"495434", "Essen\ Oldenburg",
"4937605", "Hartenstein\ Sachsen",
"492574", "Saerbeck",
"493535", "Herzberg\ Elster",
"494466", "Wittmund\-Ardorf",
"4939721", "Liepen\ bei\ Anklam",
"495247", "Harsewinkel",
"497427", "Schömberg\ bei\ Balingen",
"496041", "Glauburg",
"497152", "Leonberg\ Württemberg",
"499357", "Gräfendorf\ Bayern",
"496138", "Mommenheim",
"494432", "Dötlingen\-Brettorf",
"494273", "Kirchdorf\ bei\ Sulingen",
"496644", "Grebenhain",
"494493", "Friesoythe\-Gehlenberg",
"4933094", "Löwenberg",
"49202", "Wuppertal",
"497542", "Tettnang",
"494884", "Schwabstedt",
"496003", "Rosbach\ von\ der\ Höhe",
"498045", "Lenggries\-Fall",
"499252", "Helmbrechts",
"498862", "Steingaden\ Oberbayern",
"492423", "Langerwehe",
"495278", "Höxter\-Ovenhausen",
"495465", "Neuenkirchen\ bei\ Bramsche",
"496787", "Niederbrombach",
"4939426", "Hessen",
"496027", "Stockstadt\ am\ Main",
"497441", "Freudenstadt",
"498034", "Brannenburg",
"495221", "Herford",
"4938224", "Gresenhorst",
"4939772", "Rothemühl",
"492407", "Herzogenrath\-Kohlscheid",
"498631", "Mühldorf\ am\ Inn",
"493773", "Johanngeorgenstadt",
"495129", "Söhlde",
"495053", "Fassberg\-Müden",
"495085", "Burgdorf\-Ehlershausen",
"4935602", "Drebkau",
"495725", "Lindhorst\ bei\ Stadthagen",
"498382", "Lindau\ Bodensee",
"497403", "Dunningen",
"4936847", "Steinbach\-Hallenberg",
"493544", "Luckau\ Brandenburg",
"4936332", "Ellrich",
"494531", "Bad\ Oldesloe",
"492763", "Drolshagen\-Bleche",
"4939482", "Gatersleben",
"4935433", "Vetschau",
"494364", "Dahme\ Kreis\ Ostholstein",
"496635", "Kirtorf",
"4936922", "Gerstungen",
"495336", "Semmenstedt",
"497562", "Isny\ im\ Allgäu",
"499089", "Bissingen\-Unterringingen",
"499729", "Grettstadt",
"495362", "Wolfsburg\-Fallersleben",
"4933053", "Zehlendorf\ Kreis\ Oberhavel",
"498065", "Tuntenhausen\-Schönau",
"496582", "Freudenburg",
"4935208", "Radeburg",
"497225", "Gaggenau",
"495445", "Drebber",
"494446", "Bakum\ Kreis\ Vechta",
"4934205", "Markranstädt",
"499074", "Höchstädt\ an\ der\ Donau",
"4938231", "Barth",
"49471", "Bremerhaven",
"496061", "Michelstadt",
"497684", "Glottertal",
"4938729", "Marnitz",
"499671", "Oberviechtach",
"498102", "Höhenkirchen\-Siegertsbrunn",
"494335", "Hohn\ bei\ Rendsburg",
"497721", "Villingen\ im\ Schwarzwald",
"496664", "Sinntal\-Sterbfritz",
"497081", "Bad\ Wildbad",
"494204", "Thedinghausen",
"492462", "Linnich",
"497702", "Blumberg\ Baden",
"498823", "Mittenwald",
"497376", "Langenenslingen",
"498121", "Markt\ Schwaben",
"492436", "Wegberg\-Rödgen",
"495187", "Delligsen",
"496074", "Rödermark",
"4939242", "Prödel",
"4938425", "Kirchdorf\ Poel",
"4936459", "Blankenhain\ Thüringen",
"493528", "Radeberg",
"499664", "Hahnbach",
"4933834", "Pritzerbe",
"4937204", "Lichtenstein\ Sachsen",
"495307", "Braunschweig\-Wenden",
"492541", "Coesfeld",
"4939081", "Kakerbeck\ Sachsen\-Anhalt",
"4933767", "Friedersdorf\ bei\ Berlin",
"4939085", "Zichtau",
"4933470", "Lietzen",
"4934783", "Gerbstedt",
"495202", "Oerlinghausen",
"492853", "Schermbeck",
"498167", "Zolling",
"499635", "Bärnau",
"499946", "Hohenwarth\ bei\ Kötzing",
"494371", "Burg\ auf\ Fehmarn",
"492151", "Krefeld",
"496449", "Ehringshausen\-Katzenfurt",
"496357", "Standenbühl",
"494328", "Rickling",
"4933872", "Hohennauen",
"493375", "Königs\ Wusterhausen",
"492527", "Lippetal\-Lippborg",
"499644", "Pressath",
"492365", "Marl",
"495323", "Clausthal\-Zellerfeld",
"498752", "Au\ in\ der\ Hallertau",
"496252", "Heppenheim\ Bergstrasse",
"496628", "Oberaula",
"493571", "Hoyerswerda",
"499194", "Ebermannstadt",
"492722", "Attendorn",
"499966", "Wiesenfelden",
"499932", "Osterhofen",
"496876", "Weiskirchen\ Saar",
"4938782", "Reetz\ bei\ Perleberg",
"494792", "Worpswede",
"4934604", "Niemberg",
"498178", "Icking",
"497474", "Haigerloch",
"4938726", "Spornitz",
"492334", "Hagen\-Hohenlimburg",
"492561", "Ahaus",
"494733", "Butjadingen\-Burhave",
"499180", "Pyrbaum",
"499481", "Pfatter",
"498807", "Diessen\ am\ Ammersee",
"4934673", "Heldrungen",
"498557", "Mauth",
"492307", "Kamen",
"493685", "Hildburghausen",
"4936426", "Ottendorf\ bei\ Stadtroda",
"494508", "Krummesse",
"496827", "Eppelborn",
"495541", "Hann\.\ Münden",
"494858", "Sankt\ Margarethen\ Holstein",
"492202", "Bergisch\ Gladbach",
"494464", "Wittmund\-Carolinensiel",
"4935383", "Elster\ Elbe",
"495259", "Bad\ Driburg\-Neuenheerse",
"4937298", "Oelsnitz\ Erzgebirge",
"499349", "Werbach\-Wenkheim",
"493737", "Rochlitz",
"4939922", "Dambeck\ bei\ Röbel",
"495151", "Hameln",
"495503", "Nörten\-Hardenberg",
"496646", "Grebenau",
"4936482", "Triptis",
"4938293", "Kühlungsborn\ Ostseebad",
"495853", "Neu\ Darchau",
"497303", "Illertissen",
"4935874", "Bernstadt\ an\ der\ Eigen",
"497545", "Immenstaad\ am\ Bodensee",
"499255", "Marktleugast",
"499283", "Rehau",
"498042", "Lenggries",
"4939346", "Tucheim",
"495345", "Baddeckenstedt",
"4934498", "Rositz",
"495436", "Nortrup",
"492639", "Anhausen\ Kreis\ Neuwied",
"495462", "Ankum",
"496196", "Bad\ Soden\ am\ Taunus",
"4939751", "Penkun",
"497183", "Rudersberg\ Württemberg",
"494435", "Grossenkneten",
"496861", "Merzig",
"494346", "Gettorf",
"4933205", "Michendorf",
"499874", "Neuendettelsau",
"4933201", "Gross\ Glienicke",
"499971", "Cham",
"496163", "Höchst\ im\ Odenwald",
"493431", "Döbeln",
"496693", "Neuental",
"495082", "Langlingen",
"494444", "Goldenstedt",
"498385", "Hergatz",
"4934292", "Brandis\ bei\ Wurzen",
"499076", "Wittislingen",
"495722", "Bückeburg",
"499369", "Uettingen",
"499928", "Kirchdorf\ im\ Wald",
"492738", "Netphen",
"496666", "Freiensteinau",
"495334", "Hornburg\ Kreis\ Wolfenbüttel",
"4939456", "Altenbrak",
"4935796", "Panschwitz\-Kuckau",
"496381", "Kusel",
"497534", "Reichenau\ Baden",
"4936734", "Leutenberg",
"4936626", "Auma",
"497361", "Aalen",
"495561", "Einbeck",
"4935695", "Simmersdorf",
"4935691", "Bärenklau\ NL",
"494393", "Boostedt",
"493546", "Lübben\ Spreewald",
"498581", "Waldkirchen\ Niederbayern",
"494366", "Grömitz\-Cismar",
"496841", "Homburg\ Saar",
"498105", "Gilching",
"495527", "Duderstadt",
"4938759", "Tewswoos",
"494332", "Hamdorf\ bei\ Rendsburg",
"499122", "Schwabach",
"497327", "Dischingen",
"497565", "Aichstetten\ Kreis\ Ravensburg",
"492323", "Herne",
"498036", "Stephanskirchen\ Simssee",
"494681", "Wyk\ auf\ Föhr",
"4939883", "Gross\ Dölln",
"495365", "Wolfsburg\-Neindorf",
"498062", "Bruckmühl\ Mangfall",
"498709", "Eching\ Niederbayern",
"496209", "Mörlenbach",
"496553", "Schönecken",
"496585", "Ralingen",
"498845", "Bad\ Kohlgrub",
"496400", "Mücke",
"4939971", "Gnoien",
"496101", "Bad\ Vilbel",
"495442", "Barnstorf\ Kreis\ Diepholz",
"497222", "Rastatt",
"496803", "Mandelbachtal\-Ommersheim",
"494724", "Cuxhaven\-Lüdingworth",
"4939975", "Thürkow",
"494237", "Bendingbostel",
"4938451", "Hoppenrade\ bei\ Güstrow",
"492247", "Neunkirchen\-Seelscheid",
"493475", "Lutherstadt\ Eisleben",
"4938455", "Plaaz",
"499841", "Bad\ Windsheim",
"499944", "Miltach",
"496122", "Hofheim\-Wallau",
"496457", "Burgwald\ Eder",
"499143", "Pappenheim\ Mittelfranken",
"499209", "Emtmannsberg",
"4936076", "Niederorschel",
"492465", "Inden",
"499101", "Langenzenn",
"495820", "Suhlendorf",
"499553", "Ebrach\ Oberfranken",
"4939328", "Rochau",
"497705", "Wolterdingen\ Schwarzw",
"497243", "Ettlingen",
"495423", "Versmold",
"499803", "Colmberg",
"4933747", "Marzahna",
"495743", "Espelkamp\-Gestringen",
"495205", "Bielefeld\-Sennestadt",
"4939262", "Güsten\ Anh",
"494957", "Detern",
"499632", "Waldsassen",
"4939349", "Parey\ Elbe",
"499666", "Illschwang",
"494777", "Cadenberge",
"497389", "Heroldstatt",
"499381", "Volkach",
"494748", "Stubben\ bei\ Bremerhaven",
"4933673", "Weichensdorf",
"495574", "Oberweser",
"4933604", "Lebus",
"494206", "Stuhr\-Heiligenrode",
"4933396", "Klosterfelde",
"492434", "Wegberg",
"497374", "Uttenweiler",
"492362", "Dorsten",
"498023", "Bayrischzell",
"498320", "Missen\-Wilhams",
"498783", "Rohr\ in\ Niederbayern",
"496283", "Hardheim\ Odenwald",
"496255", "Lindenfels",
"492336", "Schwelm",
"497476", "Bisingen",
"492445", "Schleiden\ Eifel",
"495939", "Sustrum",
"497263", "Waibstadt",
"498549", "Vilshofen\-Pleinting",
"492267", "Wipperfürth",
"499196", "Wiesenttal",
"498251", "Aichach",
"496751", "Bad\ Sobernheim",
"499964", "Stallwang",
"493372", "Jüterbog",
"499861", "Rothenburg\ ob\ der\ Tauber",
"499163", "Dachsbach",
"4939459", "Hasselfelde",
"4938873", "Carlow",
"496874", "Wadern\-Nunkirchen",
"494768", "Hipstedt",
"494795", "Garlstedt",
"4933473", "Zechin",
"4938756", "Grabow",
"492129", "Haan\ Rheinland",
"4936648", "Dittersdorf\ bei\ Schleiz",
"4936085", "Reinholterode",
"495407", "Wallenhorst",
"4936081", "Arenshausen",
"499827", "Lichtenau\ Mittelfranken",
"495763", "Uchte",
"496349", "Billigheim\-Ingenheim",
"492725", "Lennestadt\-Oedingen",
"494471", "Cloppenburg",
"492053", "Velbert\-Neviges",
"499935", "Stephansposching",
"4935828", "Reichenbach\ OL",
"499646", "Freihung",
"494954", "Moormerland",
"494851", "Marne",
"492373", "Menden\ Sauerland",
"497433", "Balingen",
"497348", "Beimerstetten",
"494153", "Lauenburg\ Elbe",
"494185", "Marxen\ Auetal",
"494501", "Kastorf\ Holstein",
"4962199", "Ludwigshafen",
"497272", "Rülzheim",
"494774", "Hechthausen",
"494543", "Nusse",
"495158", "Hemeringen",
"495186", "Salzhemmendorf\-Wallensen",
"499172", "Georgensgmünd",
"4936739", "Rottenbach",
"4938307", "Poseritz",
"498193", "Geltendorf",
"4938754", "Leussow\ bei\ Ludwigslust",
"492244", "Königswinter\-Oberpleis",
"496454", "Lichtenfels\-Sachsenberg",
"499947", "Neukirchen\ bei\ Hl\ Blut",
"494305", "Westensee",
"4934927", "Globig\-Bleddin",
"498166", "Allershausen\ Oberbayern",
"495306", "Cremlingen",
"4938322", "Richtenberg",
"499978", "Schönthal\ Oberpfalz",
"497506", "Wangen\-Leupolz",
"496868", "Mettlach\-Tünsdorf",
"495772", "Espelkamp",
"4934463", "Bad\ Kösen",
"495952", "Sögel",
"494563", "Scharbeutz\-Haffkrug",
"497651", "Titisee\-Neustadt",
"494630", "Barderup",
"499824", "Dietenhofen",
"4933701", "Grossbeeren",
"499921", "Regen",
"495404", "Westerkappeln",
"497054", "Wildberg\ Württemberg",
"4939000", "Beetzendorf",
"4936074", "Worbis",
"492235", "Erftstadt",
"496356", "Carlsberg\ Pfalz",
"4938371", "Karlshagen",
"497395", "Ehingen\-Dächingen",
"4938375", "Koserow",
"499659", "Leuchtenberg",
"493301", "Oranienburg",
"492526", "Sendenhorst",
"498663", "Ruhpolding",
"49251", "Münster",
"496033", "Butzbach",
"4938462", "Baumgarten",
"496848", "Homburg\-Einöd",
"496092", "Heimbuchenthal",
"495683", "Wabern\ Hessen",
"495655", "Wanfried",
"4938793", "Dergenthin",
"498556", "Haidmühle",
"493494", "Wolfen",
"498806", "Utting\ am\ Ammersee",
"493883", "Hagenow",
"496108", "Mühlheim\ am\ Main",
"494402", "Rastede",
"492264", "Marienheide",
"4939297", "Eickendorf\ Kreis\ Schönebeck",
"4938843", "Bennin",
"498146", "Moorenweis",
"4933606", "Müllrose",
"4933394", "Blumberg\ Kreis\ Barnim",
"492775", "Driedorf",
"494421", "Wilhelmshaven",
"494120", "Ellerhoop",
"496599", "Weidenbach\ bei\ Gerolstein",
"499848", "Simmershofen",
"4935844", "Oybin\ Kurort",
"49741", "Rottweil",
"4962196", "Ludwigshafen",
"499092", "Wemding",
"492955", "Büren\-Wewelsburg",
"492983", "Winterberg\-Siedlinghausen",
"497746", "Wutöschingen",
"4936028", "Kammerforst\ Thüringen",
"4936736", "Arnsgereuth",
"492271", "Bergheim\ Erft",
"4935973", "Stolpen",
"4936624", "Teichwolframsdorf",
"4939454", "Elbingerode\ Harz",
"493765", "Reichenbach\ Vogtland",
"4936742", "Uhlstädt",
"492304", "Schwerte",
"494703", "Loxstedt\-Donnern",
"4936961", "Bad\ Liebenstein",
"496824", "Ottweiler",
"4936965", "Stadtlengsfeld",
"493322", "Falkensee",
"4937467", "Klingenthal\ Sachsen",
"494245", "Neuenkirchen\ bei\ Bassum",
"498073", "Gars\ am\ Inn",
"499356", "Burgsinn",
"498370", "Wiggensbach",
"495246", "Verl",
"497426", "Gosheim",
"494467", "Wittmund\-Funnix",
"496659", "Eichenzell",
"494741", "Nordholz\ bei\ Bremerhaven",
"4936424", "Kahla\ Thüringen",
"493745", "Falkenstein\ Vogtland",
"497324", "Herbrechtingen",
"499454", "Aufhausen\ Oberpfalz",
"495524", "Bad\ Lauterberg\ im\ Harz",
"496026", "Grossostheim",
"496786", "Kempfeld",
"499868", "Schillingsfürst",
"494234", "Dörverden",
"495609", "Ahnatal",
"4939058", "Uthmöden",
"498258", "Sielenbach",
"497732", "Radolfzell\ am\ Bodensee",
"496758", "Waldböckelheim",
"4935753", "Grossräschen",
"492406", "Herzogenrath",
"492652", "Mendig",
"495266", "Lemgo\-Kirchheide",
"4939344", "Güsen",
"495232", "Lage\ Lippe",
"494447", "Vechta\-Langförden",
"4935876", "Weissenberg\ Sachsen",
"492592", "Selm",
"499605", "Weiherhammer",
"492228", "Remagen\-Rolandseck",
"495473", "Ostercappeln",
"494761", "Bremervörde",
"498622", "Tacherting\-Peterskirchen",
"492533", "Münster\-Nienberge",
"495293", "Paderborn\-Dahl",
"4933609", "Brieskow\-Finkenheerd",
"494522", "Plön",
"495337", "Kissenbrück",
"493425", "Wurzen",
"496172", "Bad\ Homburg\ von\ der\ Höhe",
"494478", "Cappeln\ Oldenburg",
"4937327", "Rechenberg\-Bienenmühle",
"494265", "Fintel",
"49375", "Zwickau",
"494298", "Lilienthal",
"495304", "Meine",
"4936255", "Goldbach\ bei\ Gotha",
"497854", "Kehl\-Goldscheuer",
"497951", "Crailsheim",
"4938735", "Plau\ am\ See",
"497504", "Horgenzell",
"4938731", "Lübz",
"493338", "Bernau\ Brandenburg",
"493443", "Weissenfels\ Sachsen\-Anhalt",
"497771", "Stockach",
"4934443", "Teuchern",
"499175", "Spalt",
"4938229", "Bad\ Sülze",
"499621", "Amberg\ Oberpfalz",
"497629", "Tegernau\ Baden",
"494182", "Tostedt",
"492246", "Lohmar\ Rheinland",
"499779", "Nordheim\ von\ der\ Rhön",
"497275", "Kandel",
"496456", "Haina\ Kloster",
"4939003", "Jübar",
"493394", "Wittstock\ Dosse",
"4938352", "Kemnitz\ bei\ Greifswald",
"495775", "Diepenau",
"496239", "Bobenheim\-Roxheim",
"495184", "Freden\ Leine",
"496048", "Büdingen\-Eckartshausen",
"496430", "Hahnstätten",
"496131", "Mainz",
"496833", "Rehlingen\-Siersburg",
"495955", "Esterwegen",
"4933933", "Lindow\ Mark",
"494207", "Oyten",
"494956", "Uplengen",
"495190", "Soltau\-Emmingen",
"495491", "Damme\ Dümmer",
"4938724", "Siggelkow",
"4934606", "Teicha\ Sachsen\-Anhalt",
"495271", "Höxter",
"493723", "Hohenstein\-Ernstthal",
"498135", "Sulzemoos",
"494776", "Osten\-Altendorf",
"494302", "Kirchbarkau",
"495592", "Gleichen\-Bremke",
"49981", "Ansbach",
"4939032", "Mahlsdorf\ bei\ Salzwedel",
"492232", "Brühl\ Rheinland",
"497392", "Laupheim",
"499197", "Egloffstein",
"498638", "Waldkraiburg",
"492266", "Lindlar",
"492293", "Nümbrecht",
"4936379", "Holzengel",
"495533", "Bodenwerder",
"498144", "Grafrath",
"497333", "Laichingen",
"497448", "Seewald",
"492473", "Simmerath",
"495228", "Vlotho\-Exter",
"492337", "Hagen\-Dahl",
"4939221", "Möckern\ bei\ Magdeburg",
"497477", "Jungingen\ bei\ Hechingen",
"493860", "Raben\ Steinfeld",
"494829", "Wewelsfleth",
"4939225", "Altengrabow",
"498554", "Schönberg\ Niederbayern",
"4937206", "Frankenberg\ Sachsen",
"4933836", "Butzow\ bei\ Brandenburg",
"493496", "Köthen\ Anhalt",
"494223", "Ganderkesee\-Bookholzberg",
"4933927", "Linum",
"494405", "Edewecht",
"498091", "Kirchseeon",
"499647", "Kirchenthumbach",
"492524", "Ennigerloh",
"4933337", "Altkünkendorf",
"497728", "Niedereschach",
"495652", "Bad\ Sooden\-Allendorf",
"499826", "Weidenbach\ Mittelfranken",
"496095", "Bessenbach",
"495406", "Belm",
"496068", "Beerfelden",
"497056", "Gechingen",
"499354", "Rieneck",
"497424", "Spaichingen",
"495244", "Rietberg",
"4938226", "Dierhagen\ Ostseebad",
"4939424", "Schwanebeck\ Sachsen\-Anhalt",
"496647", "Herbstein\-Stockhausen",
"493762", "Crimmitschau",
"492772", "Herborn\ Hessen",
"4936762", "Steinach\ Thüringen",
"496678", "Wildeck\-Hönebach",
"493521", "Meissen",
"492306", "Lünen",
"4936941", "Wasungen",
"496826", "Bexbach",
"492952", "Rüthen",
"495909", "Wettrup",
"4936945", "Henneberg",
"49681", "Saarbrücken",
"495373", "Hillerse\ Kreis\ Gifhorn",
"492548", "Dülmen\-Rorup",
"497573", "Stetten\ am\ kalten\ Markt",
"499905", "Bernried\ Niederbayern",
"494347", "Flintbek",
"492158", "Grefrath\ bei\ Krefeld",
"4934609", "Salzmünde",
"495437", "Menslage",
"497744", "Stühlingen",
"494242", "Syke",
"49731", "Ulm\ Donau",
"4936376", "Straussfurt",
"49551", "Göttingen",
"499131", "Erlangen",
"4936693", "Crossen\ an\ der\ Elster",
"497735", "Öhningen",
"494321", "Neumünster",
"4935723", "Bernsdorf\ OL",
"492655", "Weibern",
"492683", "Asbach\ Westerwald",
"499833", "Heidenheim\ Mittelfranken",
"495264", "Kalletal",
"4936454", "Magdala",
"4939364", "Dolle",
"499077", "Bachhagel",
"497139", "Neuenstadt\ am\ Kocher",
"4937209", "Einsiedel\ bei\ Chemnitz",
"4933839", "Wusterwitz",
"496667", "Steinau\-Ulmbach",
"497231", "Pforzheim",
"492391", "Plettenberg",
"4939742", "Brüssow\ bei\ Pasewalk",
"494525", "Ahrensbök",
"495731", "Bad\ Oeynhausen",
"496024", "Schöllkrippen",
"496784", "Weierbach",
"498284", "Ziemetshausen",
"496175", "Friedrichsdorf\ Taunus",
"494236", "Kirchlinteln",
"496621", "Bad\ Hersfeld",
"494262", "Visselhövede",
"492404", "Alsdorf\ Rheinland",
"493578", "Kamenz",
"497764", "Herrischried",
"4938488", "Demen",
"495235", "Blomberg\ Lippe",
"492568", "Heek",
"492595", "Olfen",
"497326", "Neresheim",
"499602", "Neustadt\ an\ der\ Waldnaab",
"498171", "Wolfratshausen",
"494367", "Grossenbrode",
"493725", "Zschopau",
"497344", "Blaubeuren",
"498133", "Haimhausen\ Oberbayern",
"495544", "Reinhardshagen",
"494958", "Jemgum",
"4938797", "Karstädt\ Kreis\ Prignitz",
"498192", "Schondorf\ am\ Ammersee",
"49345", "Halle\ Saale",
"494778", "Wingst",
"4934327", "Waldheim\ Sachsen",
"495154", "Aerzen",
"494747", "Beverstedt",
"496835", "Beckingen",
"495953", "Börger",
"4939293", "Dreileben",
"4938332", "Gross\ Bisdorf",
"494461", "Jever",
"4938847", "Boizenburg\ Elbe",
"496046", "Ortenberg\ Hessen",
"495773", "Stemwede\-Wehdem",
"497273", "Hagenbach\ Pfalz",
"492248", "Hennef\-Uckerath",
"496486", "Katzenelnbogen",
"498642", "Übersee",
"497466", "Beuron",
"497432", "Albstadt\-Tailfingen",
"494152", "Geesthacht",
"496458", "Rosenthal\ Hessen",
"492372", "Hemer",
"4936022", "Grossengottern",
"496864", "Mettlach",
"499173", "Thalmässing",
"499871", "Windsbach",
"493362", "Erkner",
"499974", "Traitsching",
"494542", "Mölln\ Lauenburg",
"4938755", "Eldena",
"4938751", "Picher",
"493445", "Naumburg\ Saale",
"498650", "Marktschellenberg",
"49521", "Bielefeld",
"496093", "Laufach",
"495682", "Borken\ Hessen",
"4938303", "Sellin\ Ostseebad",
"494767", "Bremervörde\-Bevern",
"499676", "Winklarn",
"497726", "Bad\ Dürrheim",
"4936075", "Dingelstädt\ Eichsfeld",
"494140", "Estorf\ Kreis\ Stade",
"494441", "Vechta",
"496032", "Bad\ Nauheim",
"499828", "Rügland",
"4934923", "Cobbelsdorf",
"4936071", "Teistungen",
"496066", "Michelstadt\-Vielbrunn",
"4938374", "Lassan\ bei\ Wolgast",
"497364", "Oberkochen",
"4933920", "Walsleben\ bei\ Neuruppin",
"4933704", "Baruth\ Mark",
"495564", "Dassel",
"4934467", "Eckartsberga",
"495331", "Wolfenbüttel",
"4938456", "Langhagen\ bei\ Güstrow",
"496384", "Konken",
"497531", "Konstanz",
"494550", "Bühnsdorf",
"494403", "Bad\ Zwischenahn",
"498584", "Breitenberg\ Niederbayern",
"496844", "Blieskastel\-Altheim",
"493342", "Neuenhagen\ bei\ Berlin",
"4933395", "Zerpenschleuse",
"494562", "Grömitz",
"4933209", "Caputh",
"494536", "Steinhorst\ Lauenburg",
"492295", "Ruppichteroth",
"496104", "Heusenstamm",
"498636", "Ampfing",
"492268", "Kürten",
"492620", "Neuhäusel\ Westerwald",
"495535", "Polle",
"494721", "Cuxhaven",
"498662", "Siegsdorf\ Kreis\ Traunstein",
"497335", "Wiesensteig",
"495226", "Bruchmühlen\ Westfalen",
"4939052", "Erxleben\ bei\ Haldensleben",
"497446", "Lossburg",
"494684", "Langeness\ Hallig",
"49771", "Donaueschingen",
"499844", "Obernzenn",
"494702", "Sandstedt",
"497204", "Malsch\-Völkersbach",
"499941", "Kötzting",
"492156", "Willich\-Anrath",
"4939451", "Wasserleben",
"4936625", "Langenwetzendorf",
"4939455", "Schierke",
"4936621", "Elsterberg\ bei\ Plauen",
"4935795", "Königsbrück",
"49811", "Hallbergmoos",
"4938328", "Miltzow",
"499104", "Emskirchen",
"492546", "Coesfeld\-Lette",
"499903", "Schöllnach",
"4937323", "Lichtenberg\ Erzgebirge",
"4935841", "Grossschönau\ Sachsen",
"498072", "Haag\ in\ Oberbayern",
"495375", "Müden\ Aller",
"497949", "Pfedelbach\-Untersteinbach",
"497575", "Messkirch",
"496676", "Hohenroda\ Hessen",
"4936782", "Schmiedefeld\ am\ Rennsteig",
"499093", "Polsingen",
"4939976", "Gross\ Bützin",
"492308", "Unna\-Hemmerde",
"492982", "Medebach",
"494857", "Barlt",
"495571", "Uslar",
"4936964", "Dermbach\ Rhön",
"492431", "Erkelenz",
"497371", "Riedlingen\ Württemberg",
"499384", "Schwanfeld",
"495704", "Petershagen\-Friedewalde",
"4935696", "Briesnig",
"492566", "Legden",
"495472", "Bad\ Essen",
"498623", "Kirchweidach",
"492532", "Ostbevern",
"495839", "Wittingen\-Ohrdorf",
"495292", "Lichtenau\-Atteln",
"4936870", "Masserberg",
"495528", "Gieboldehausen",
"495233", "Steinheim\ Westfalen",
"497328", "Königsbronn",
"492593", "Ascheberg\ Westfalen",
"4937463", "Bergen\ Vogtland",
"499961", "Mitterfels",
"496173", "Kronberg\ im\ Taunus",
"496871", "Wadern",
"4938459", "Laage",
"4936425", "Isserstedt",
"494523", "Malente",
"493576", "Weisswasser",
"494238", "Neddenaverbergen",
"4936421", "Camburg",
"496754", "Martinstein",
"498254", "Altomünster",
"499927", "Kirchberg\ Wald",
"4933206", "Fichtenwalde",
"4939384", "Arendsee\ Altmark",
"497657", "Eisenbach\ Hochschwarzwald",
"492737", "Netphen\-Deuz",
"492224", "Bad\ Honnef",
"494489", "Apen",
"4934263", "Hohburg",
"497733", "Engen\ Hegau",
"493307", "Zehdenick",
"492685", "Flammersfeld",
"492653", "Kaisersesch",
"499835", "Ehingen\ Mittelfranken",
"4939345", "Parchen",
"494294", "Riede\ Kreis\ Verden",
"494474", "Garrel",
"4939341", "Redekin",
"496866", "Perl\-Nennig",
"493334", "Eberswalde",
"496479", "Waldbrunn\ Westerwald",
"495308", "Lehre",
"496832", "Beckingen\-Reimsbach",
"499976", "Rötz",
"4933923", "Flecken\ Zechlin",
"4933333", "Tantow",
"493561", "Guben",
"496893", "Saarbrücken\-Ensheim",
"496484", "Beselich",
"493722", "Limbach\-Oberfrohna",
"495431", "Quakenbrück",
"495130", "Wedemark",
"4934773", "Schwittersdorf",
"494303", "Schlesen",
"4938300", "Insel\ Hiddensee",
"492571", "Greven\ Westfalen",
"4934920", "Kropstädt",
"498195", "Weil\ Kreis\ Landsberg\ am\ Lech",
"497464", "Talheim\ Kreis\ Tuttlingen",
"4936254", "Friedrichswerth",
"498168", "Attenkirchen",
"495156", "Coppenbrügge",
"496641", "Lauterbach\ Hessen",
"494545", "Seedorf\ Lauenburg",
"4938725", "Gross\ Godems",
"496044", "Schotten\ Hessen",
"4938721", "Ziegendorf",
"497346", "Illerkirchberg",
"495546", "Scheden",
"494881", "Friedrichstadt",
"492375", "Balve",
"494155", "Büchen",
"497435", "Albstadt\-Laufen",
"494183", "Jesteburg",
"4939748", "Viereck",
"49335", "Frankfurt\ \(Oder\)",
"496627", "Nentershausen\ Hessen",
"496106", "Rodgau",
"498634", "Garching\ an\ der\ Alz",
"497444", "Alpirsbach",
"495224", "Enger\ Westfalen",
"498031", "Rosenheim\ Oberbayern",
"4938426", "Neuburg\-Steinhausen",
"4937609", "Wolkenburg\ Mulde",
"4939224", "Büden",
"495685", "Knüllwald",
"495653", "Sontra",
"494361", "Oldenburg\ in\ Holstein",
"498586", "Hauzenberg",
"4938482", "Warin",
"498177", "Münsing\ Starnberger\ See",
"498808", "Pähl",
"496035", "Reichelsheim\ Wetterau",
"498558", "Hohenau\ Niederbayern",
"4934953", "Gräfenhainichen",
"493541", "Calau",
"494534", "Steinburg\ Kreis\ Storman",
"49760", "Oberried\ Breisgau",
"492292", "Windeck\ Sieg",
"492839", "Straelen\-Herongen",
"495532", "Stadtoldendorf",
"497366", "Abtsgmünd",
"494327", "Grossenaspe",
"492472", "Monschau",
"498665", "Inzell",
"497332", "Lauterstein",
"496358", "Kriegsfeld",
"495593", "Bovenden\-Lenglern",
"492233", "Hürth\ Rheinland",
"496386", "Altenkirchen\ Pfalz",
"497393", "Munderkingen",
"492528", "Ennigerloh\-Enniger",
"499674", "Schönsee",
"4939086", "Jävenitz",
"497237", "Neulingen\ Enzkreis",
"497724", "St\ Georgen\ im\ Schwarzwald",
"494222", "Ganderkesee",
"496661", "Schlüchtern",
"497084", "Schömberg\ bei\ Neuenbürg",
"499071", "Dillingen\ an\ der\ Donau",
"4939007", "Tangeln",
"493462", "Bad\ Dürrenberg",
"497681", "Waldkirch\ Breisgau",
"499358", "Gössenheim",
"4936944", "Rentwertshausen",
"498124", "Forstern\ Oberbayern",
"497428", "Rosenfeld",
"495248", "Langenberg\ Kreis\ Gütersloh",
"498075", "Amerang",
"499386", "Prosselsheim",
"495372", "Meinersen",
"497669", "St\ Märgen",
"494109", "Tangstedt\ Bz\ Hamburg",
"495706", "Porta\ Westfalica",
"497572", "Mengen\ Württemberg",
"494705", "Wremen",
"496674", "Friedewald\ Hessen",
"4936873", "Themar",
"499661", "Sulzbach\-Rosenberg",
"494243", "Twistringen",
"495277", "Höxter\-Fürstenau",
"4939421", "Osterwieck",
"496071", "Dieburg",
"4939425", "Dingelstedt\ am\ Huy",
"494849", "Hooge",
"4936651", "Lobenstein",
"499106", "Markt\ Erlbach",
"499627", "Freudenberg\ Oberpfalz",
"493763", "Glauchau",
"497777", "Sauldorf",
"4935727", "Burghammer",
"497957", "Kressberg",
"4934206", "Rötha",
"499846", "Ipsheim",
"492953", "Wünnenberg",
"492985", "Winterberg\-Niedersfeld",
"492154", "Willich",
"492773", "Haiger",
"497748", "Grafenhausen\ Hochschwarzwald",
"4934243", "Bad\ Düben",
"4937606", "Lengenfeld\ Vogtland",
"494263", "Scheessel",
"499641", "Grafenwöhr",
"4938429", "Glasin",
"494296", "Schwanewede\-Aschwarden",
"4939365", "Bellingen\ bei\ Stendal",
"4936451", "Buttelstedt",
"4937320", "Mulda\ Sachsen",
"4933848", "Raben",
"493423", "Eilenburg",
"4939361", "Lüderitz",
"499603", "Floss",
"495475", "Bohmte\-Hunteburg",
"492535", "Sendenhorst\-Albersloh",
"495295", "Lichtenau\ Westfalen",
"492226", "Rheinbach",
"498230", "Gablingen",
"496028", "Sulzbach\ am\ Main",
"496788", "Sien",
"4939038", "Henningen",
"499832", "Wassertrüdingen",
"49221", "Cologne",
"492682", "Hamm\ Sieg",
"492408", "Aachen\-Kornelimünster",
"493574", "Lauchhammer",
"499191", "Forchheim\ Oberfranken",
"499270", "Creussen",
"496756", "Winterbach\ Soonwald",
"492564", "Vreden",
"499484", "Brennberg",
"4939726", "Ducherow",
"4939089", "Bismark\ Altmark",
"497471", "Hechingen",
"492331", "Hagen\ Westfalen",
"497774", "Eigeltingen",
"494272", "Siedenburg",
"496198", "Eppstein",
"494492", "Saterland",
"4937604", "Mosel",
"492547", "Rosendahl\-Osterwick",
"499624", "Ensdorf\ Oberpfalz",
"496165", "Breuberg",
"495301", "Lehre\-Essenrode",
"494830", "Süderhastedt",
"497851", "Kehl",
"497954", "Kirchberg\ an\ der\ Jagst",
"494348", "Schönkirchen",
"497153", "Plochingen",
"494433", "Dötlingen",
"492157", "Nettetal\-Kaldenkirchen",
"492422", "Kreuzau",
"498460", "Berching\-Holnstein",
"498161", "Freising",
"4936375", "Kindelbrück",
"496002", "Ober\-Mörlen",
"497543", "Kressbronn\ am\ Bodensee",
"498269", "Unteregg\ bei\ Mindelheim",
"4936371", "Schlossvippach",
"499285", "Kirchenlamitz",
"499253", "Weissenstadt",
"495438", "Bakum\-Lüsche",
"498452", "Geisenfeld",
"495181", "Alfeld\ Leine",
"495505", "Hardegsen",
"496134", "Mainz\-Kastel",
"495883", "Lemgow",
"495855", "Nahrendorf",
"4935363", "Fermerswalde",
"497305", "Erbach\ Donau",
"4936462", "Ossmannstedt",
"493391", "Neuruppin",
"496648", "Bad\ Salzschlirf",
"492742", "Wissen",
"4936843", "Benshausen",
"4939248", "Dobritz",
"496677", "Neuenstein\ Hessen",
"4939724", "Klein\ Bünzow",
"495494", "Holdorf\ Niedersachsen",
"493683", "Schmalkalden",
"494856", "Kronprinzenkoog",
"495274", "Nieheim",
"494506", "Stockelsdorf\-Krumbeck",
"4939863", "Seehausen\ bei\ Prenzlau",
"4936946", "Erbenhausen\ Thüringen",
"496555", "Bleialf",
"496583", "Palzem",
"496805", "Kleinblittersdorf",
"498141", "Fürstenfeldbruck",
"498038", "Vogtareuth",
"497563", "Kisslegg",
"498249", "Ettringen\ Wertach",
"492750", "Diedenshausen",
"492325", "Wanne\-Eickel",
"49991", "Deggendorf",
"495363", "Wolfsburg\-Vorsfelde",
"4938788", "Gross\ Warnow",
"495060", "Bodenburg",
"498551", "Freyung",
"4936259", "Tabarz\ Thüringer\ Wald",
"498801", "Seeshaupt",
"496145", "Flörsheim\ am\ Main",
"492567", "Ahaus\-Alstätte",
"4938221", "Marlow",
"494929", "Ihlow\ Kreis\ Aurich",
"4938225", "Trinwillershagen",
"498094", "Steinhöring",
"492521", "Beckum",
"493306", "Gransee",
"493772", "Schneeberg\ Erzgebirge",
"4934204", "Schkeuditz",
"4933878", "Nennhausen",
"496351", "Eisenberg\ Pfalz",
"4938234", "Born\ Darss",
"499926", "Frauenau",
"499078", "Mertingen",
"496429", "Schweinsberg\ Hessen",
"495052", "Hermannsburg",
"496695", "Jesberg",
"492736", "Burbach\ Siegerl",
"498383", "Grünenbach\ Allgäu",
"496668", "Birstein\-Lichenroth",
"496220", "Wilhelmsfeld",
"497402", "Fluorn\-Winzeln",
"497656", "Schluchsee",
"492762", "Wenden\ Südsauerland",
"4933831", "Weseram",
"49441", "Oldenburg",
"495149", "Wienhausen",
"494746", "Hagen\ bei\ Bremerhaven",
"4933835", "Golzow\ bei\ Brandenburg",
"4939226", "Hohenziatz",
"499351", "Gemünden\ am\ Main",
"496047", "Altenstadt\ Hessen",
"495241", "Gütersloh",
"494208", "Grasberg",
"4938424", "Bobitz",
"492852", "Hamminkeln",
"499429", "Rain\ Niederbayern",
"492502", "Nottuln",
"496078", "Gross\-Umstadt",
"499220", "Kasendorf\-Azendorf",
"495745", "Stemwede\-Levern",
"495203", "Werther\ Westfalen",
"492463", "Titz",
"499555", "Schlüsselfeld\-Aschbach",
"498822", "Oberammergau",
"497703", "Bonndorf\ im\ Schwarzwald",
"493337", "Biesenthal\ Brandenburg",
"497245", "Durmersheim",
"495425", "Borgholzhausen",
"499805", "Burgoberbach",
"499749", "Oberbach\ Unterfranken",
"497741", "Tiengen\ Hochrhein",
"4934743", "Ermsleben",
"4939084", "Lindstedt",
"499145", "Solnhofen",
"494426", "Wangerland\-Horumersiel",
"493473", "Aschersleben\ Sachsen\-Anhalt",
"497467", "Neuhausen\ ob\ Eck",
"499134", "Neunkirchen\ am\ Brand",
"494324", "Brokstedt",
"499933", "Wallersdorf",
"495765", "Raddestorf",
"4935202", "Klingenberg\ Sachsen",
"499648", "Neustadt\ am\ Kulm",
"492723", "Kirchhundem",
"4936949", "Obermassfeld\-Grimmenthal",
"4933763", "Bestensee",
"494732", "Stadland\-Rodenkirchen",
"497727", "Vöhrenbach",
"497234", "Tiefenbronn",
"492394", "Neuenrade\-Affeln",
"494766", "Basdahl",
"499677", "Oberviechtach\-Pullenried",
"495261", "Lemgo",
"494793", "Hambergen",
"4936256", "Wechmar",
"4938736", "Goldberg",
"499165", "Sugenheim",
"498637", "Lohkirchen",
"496624", "Heringen\ Werra",
"492401", "Baesweiler",
"4939778", "Ferdinandshof\ bei\ Torgelow",
"497761", "Bad\ Säckingen",
"499198", "Heiligenstadt\ in\ Oberfranken",
"4934605", "Gröbers",
"496021", "Aschaffenburg",
"497447", "Baiersbronn\-Schwarzenberg",
"495734", "Bergkirchen\ Westfalen",
"4934601", "Teutschenthal",
"496781", "Idar\-Oberstein",
"498281", "Thannhausen\ Schwaben",
"496509", "Büdlich",
"497478", "Hirrlingen",
"492338", "Breckerfeld",
"4935608", "Gross\ Ossnig",
"492443", "Mechernich",
"4936338", "Bleicherode",
"497265", "Angelbachtal",
"494537", "Sülfeld\ Holstein",
"4939488", "Güntersberge",
"497522", "Wangen\ im\ Allgäu",
"498025", "Miesbach",
"4936928", "Neuenhof\ Thüringen",
"498785", "Rottenburg\-Oberroning",
"496253", "Fürth\ Odenwald",
"498753", "Elsendorf\ Niederbayern",
"496285", "Walldürn\-Altheim",
"495322", "Bad\ Harzburg",
"494771", "Hemmoor",
"496216", "Ludwigshafen",
"492425", "Nideggen\-Embken",
"4939268", "Egeln",
"4938379", "Benz\ Usedom",
"497930", "Boxberg\ Baden",
"494951", "Weener",
"494854", "Friedrichskoog",
"49961", "Weiden\ in\ der\ Oberpfalz",
"498043", "Jachenau",
"499282", "Naila",
"494504", "Ratekau",
"498340", "Baisweil",
"495276", "Marienmünster",
"496136", "Nieder\-Olm",
"494275", "Ehrenburg",
"493592", "Kirschau",
"4939887", "Gerswalde",
"494495", "Friesoythe\-Thüle",
"496162", "Reinheim\ Odenwald",
"494468", "Friedeburg\-Reepsholt",
"4935343", "Hirschfeld\ bei\ Elsterwerda",
"493533", "Elsterwerda",
"495707", "Petershagen\ Weser",
"497182", "Welzheim",
"496451", "Frankenberg\ Eder",
"496150", "Weiterstadt",
"4939386", "Seehausen\ Altmark",
"4933204", "Beelitz\ Mark",
"499847", "Ergersheim",
"4939754", "Löcknitz\ Vorpom",
"492241", "Siegburg",
"4939932", "Malchow\ bei\ Waren",
"495502", "Dransfeld",
"499107", "Trautskirchen",
"497302", "Pfaffenhofen\ an\ der\ Roth",
"495852", "Bleckede",
"499626", "Hohenburg",
"4939322", "Tangermünde",
"4935875", "Obercunnersdorf\ bei\ Löbau",
"492203", "Cologne\-Porz",
"496329", "Weidenthal\ Pfalz",
"492745", "Brachbach\ Sieg",
"495401", "Georgsmarienhütte",
"499924", "Bodenmais",
"494333", "Erfde",
"496142", "Rüsselsheim",
"497051", "Calw",
"499123", "Lauf\ an\ der\ Pegnitz",
"4936731", "Unterloquitz",
"4936642", "Harra",
"492227", "Bornheim\-Merten",
"492734", "Freudenberg\ Westfalen",
"4936735", "Probstzella",
"494392", "Nortorf\ bei\ Neumünster",
"497654", "Löffingen",
"496552", "Olzheim",
"495840", "Schnackenburg",
"493304", "Velten",
"497223", "Bühl\ Baden",
"496802", "Völklingen\-Lauterbach",
"495443", "Lemförde",
"4962195", "Ludwigshafen",
"494477", "Lastrup\-Hemmelte",
"4935822", "Hagenwerder",
"494297", "Ottersberg\-Posthausen",
"498063", "Feldkirchen\-Westerham",
"4936840", "Trusetal",
"4935453", "Drahnsdorf",
"496633", "Homberg\ Ohm",
"493491", "Lutherstadt\ Wittenberg",
"4940", "Hamburg",
"496692", "Neustadt\ Hessen",
"495055", "Fassberg",
"495083", "Hohne\ bei\ Celle",
"495723", "Bad\ Nenndorf",
"4936966", "Kaltennordheim",
"4935387", "Seyda",
"499867", "Geslau",
"496757", "Becherbach\ bei\ Kirn",
"498257", "Inchenhofen",
"4935694", "Gosda\ bei\ Klinge",
"4938297", "Moitin",
"492261", "Gummersbach",
"492855", "Voerde\ Niederrhein",
"499633", "Mitterteich",
"4933477", "Trebnitz\ bei\ Müncheberg",
"492505", "Altenberge\ Westfalen",
"499560", "Grub\ am\ Forst",
"492181", "Grevenbroich",
"4938376", "Zirchow",
"4934492", "Lucka",
"495742", "Preussisch\ Oldendorf",
"499948", "Eschlkam",
"499977", "Arnschwang",
"49351", "Dresden",
"496867", "Perl",
"492274", "Elsdorf\ Rheinland",
"4933760", "Münchehofe\ Kreis\ Dahme\-Spreewald",
"4939061", "Weferlingen",
"4938454", "Kritzkow",
"4933605", "Boossen",
"496821", "Neunkirchen\ Saar",
"496123", "Eltville\ am\ Rhein",
"4933601", "Podelzig",
"499142", "Treuchtlingen",
"497347", "Dietenheim",
"492301", "Holzwickede",
"4939389", "Schollene",
"498825", "Krün",
"499552", "Burghaslach",
"495422", "Melle",
"4937292", "Oederan",
"497242", "Rheinstetten",
"494744", "Loxstedt",
"495157", "Emmerthal\-Börry",
"499802", "Ansbach\-Katterbach",
"493731", "Freiberg\ Sachsen",
"4939928", "Möllenhagen",
"496059", "Jossgrund",
"498176", "Egling\ bei\ Wolfratshausen",
"494735", "Butjadingen\-Stollhamm",
"497321", "Heidenheim\ an\ der\ Brenz",
"499451", "Schierling",
"495521", "Herzberg\ am\ Harz",
"49431", "Kiel",
"493909", "Klötze\ Altmark",
"494231", "Verden\ Aller",
"497250", "Kraichtal",
"496626", "Wildeck\-Obersuhl",
"496107", "Kelsterbach",
"4933677", "Glienicke\ bei\ Beeskow",
"4934692", "Alsleben\ Saale",
"494139", "Hohnstorf\ Elbe",
"497459", "Nagold\-Hochdorf",
"492052", "Velbert\-Langenberg",
"4934298", "Taucha\ bei\ Leipzig",
"497236", "Keltern",
"494764", "Gnarrenburg\-Klenkendorf",
"497262", "Eppingen",
"4936041", "Bad\ Tennstedt",
"492363", "Datteln",
"497525", "Aulendorf",
"498022", "Tegernsee",
"495325", "Goslar\-Hahnenklee",
"498782", "Pfeffenhausen",
"493437", "Grimma",
"49661", "Fulda",
"496282", "Walldürn",
"494326", "Wankendorf",
"4936084", "Heuthen",
"497367", "Aalen\-Ebnat",
"499162", "Scheinfeld",
"496387", "Sankt\ Julian",
"4936969", "Merkers",
"4933743", "Blönsdorf",
"4939201", "Wolmirstedt",
"499371", "Miltenberg",
"4939037", "Pretzier",
"496364", "Nussbach\ Pfalz",
"4939205", "Langenweddingen",
"494946", "Grossefehn\-Bagband",
"494635", "Sörup",
"493836", "Wolgast",
"495584", "Hattorf\ am\ Harz",
"4939399", "Kleinau",
"496531", "Bernkastel\-Kues",
"497384", "Schelklingen\-Hütten",
"4939050", "Bartensleben",
"496086", "Grävenwiesbach",
"496726", "Lorch\ Rheingau",
"498226", "Bibertal",
"495945", "Wilsum",
"497066", "Bad\ Rappenau\-Bonfeld",
"492872", "Rhede\ Westfalen",
"498535", "Haarbach",
"495636", "Lichtenfels\-Goddelsheim",
"496058", "Gründau",
"497032", "Herrenberg",
"495662", "Felsberg\ Hessen",
"496335", "Trulben",
"497903", "Mainhardt",
"492256", "Mechernich\-Satzvey",
"494664", "Neukirchen\ bei\ Niebüll",
"4933922", "Karwesee",
"498682", "Laufen\ Salzach",
"49671", "Bad\ Kreuznach",
"49821", "Augsburg",
"495650", "Cornberg",
"499575", "Weismain",
"496446", "Hohenahr",
"4933332", "Gartz\ Oder",
"4933847", "Görzke",
"498331", "Memmingen",
"4934772", "Helbra",
"497844", "Rheinau",
"4934426", "Kayna",
"499204", "Plankenfels",
"497941", "Öhringen",
"4933656", "Bahro",
"498564", "Johanniskirchen",
"4933986", "Falkenhagen\ Kreis\ Prignitz",
"4935244", "Krögis",
"4933975", "Dannenwalde\ Kreis\ Prignitz",
"497835", "Zell\ am\ Harmersbach",
"494180", "Königsmoor",
"4933971", "Kyritz\ Brandenburg",
"494481", "Hatten\-Sandkrug",
"499733", "Münnerstadt",
"495965", "Klein\ Berssen",
"497046", "Zaberfeld",
"495642", "Warburg\-Scherfede",
"4935728", "Uhyst\ Spree",
"492923", "Lippetal\-Herzfeld",
"4934721", "Nienburg\ Saale",
"494932", "Norderney",
"496344", "Schwegenheim",
"494966", "Neubörger",
"4938391", "Altenkirchen\ Rügen",
"4938856", "Pritzier\ bei\ Hagenow",
"4936020", "Ebeleben",
"499657", "Waldthurn",
"494194", "Sievershütten",
"4938209", "Sanitz\ bei\ Rostock",
"495192", "Munster",
"497961", "Ellwangen\ Jagst",
"4937439", "Jocketa",
"493382", "Lehnin",
"495831", "Wittingen",
"498544", "Eging\ am\ See",
"495934", "Haren\-Rütenbrock",
"4933456", "Wriezen",
"493631", "Nordhausen\ Thüringen",
"494644", "Karby",
"4938483", "Brüel",
"497486", "Horb\-Altheim",
"498773", "Neufahrn\ in\ Niederbayern",
"496432", "Diez",
"497458", "Ebhausen",
"494138", "Betzendorf\ Kreis\ Lüneburg",
"496466", "Dautphetal\-Friedensdorf",
"4939855", "Parmen\-Weggun",
"497974", "Bühlerzell",
"4939396", "Neukirchen\ Altmark",
"4939851", "Göritz\ bei\ Prenzlau",
"4939604", "Wildberg\ bei\ Altentreptow",
"496597", "Jünkerath",
"497173", "Heubach",
"497754", "Görwihl",
"494252", "Bruchhausen\-Vilsen",
"492634", "Rengsdorf",
"499493", "Beratzhausen",
"492558", "Horstmar",
"4935774", "Boxberg\ Sachsen",
"499273", "Bad\ Berneck\ im\ Fichtelgebirge",
"494357", "Sehestedt\ Eider",
"496328", "Elmstein",
"4939008", "Kunrau",
"499466", "Stamsried",
"492586", "Beelen",
"4939747", "Züsedom",
"496733", "Gau\-Odernheim",
"498233", "Kissing",
"495623", "Edertal",
"495875", "Emmendorf",
"498292", "Dinkelscherben",
"492942", "Geseke",
"494469", "Wangerooge",
"494876", "Reher\ Holstein",
"4933989", "Sadenbeck",
"493675", "Sonneberg\ Thüringen",
"499344", "Gerchsheim",
"495254", "Paderborn\-Schloss\ Neuhaus",
"494260", "Visselhövede\-Wittorf",
"496657", "Hofbieber",
"494125", "Seestermühe",
"492770", "Eschenburg",
"499335", "Aub\ Kreis\ Würzburg",
"494671", "Bredstedt",
"496575", "Landscheid",
"49971", "Bad\ Kissingen",
"499446", "Altmannstein",
"4938206", "Graal\-Müritz\ Seeheilbad",
"498704", "Altdorf\-Pfettrach",
"4939404", "Ausleben",
"496204", "Viernheim",
"492195", "Radevormwald",
"498571", "Simbach\ am\ Inn",
"4938859", "Alt\ Zachun",
"495607", "Fuldatal",
"4935954", "Grossharthau",
"495126", "Algermissen",
"4934242", "Hohenpriessnitz",
"496371", "Landstuhl",
"499364", "Zellingen",
"49511", "Hannover",
"499531", "Ebern",
"4937436", "Weischlitz",
"494240", "Syke\-Heiligenfelde",
"495072", "Neustadt\-Mandelsloh",
"499726", "Euerbach",
"499086", "Fremdingen",
"498375", "Weitnau",
"495339", "Gielde",
"497676", "Feldberg\ Schwarzwald",
"492645", "Vettelschoss",
"492962", "Olsberg",
"498593", "Untergriesbach",
"499206", "Mistelgau\-Obernsees",
"495942", "Uelsen",
"4934975", "Görzig\ Kreis\ Köthen",
"498532", "Griesbach\ im\ Rottal",
"492623", "Ransbach\-Baumbach",
"499748", "Motten",
"4936023", "Horsmar",
"495665", "Guxhagen",
"494381", "Lütjenburg",
"492254", "Weilerswist",
"499777", "Ostheim\ von\ der\ Rhön",
"4933239", "Gross\ Behnitz",
"493865", "Holthusen",
"494666", "Ladelund",
"497627", "Steinen\ Kreis\ Lörrach",
"494632", "Steinbergkirche",
"496444", "Bischoffen",
"496084", "Schmitten\ Taunus",
"495148", "Steinhorst\ Niedersachsen",
"497661", "Kirchzarten",
"494803", "Pahlen",
"496724", "Stromberg\ Hunsrück",
"498224", "Offingen\ Donau",
"495031", "Wunstorf",
"496237", "Maxdorf",
"494553", "Geschendorf",
"494101", "Pinneberg",
"496681", "Hilders",
"4933366", "Chorin",
"495634", "Waldeck\-Sachsenhausen",
"494209", "Schwanewede",
"4933734", "Felgentreu",
"497358", "Eberhardzell\-Füramoos",
"496332", "Zweibrücken",
"494143", "Drochtersen",
"495808", "Gerdau",
"499428", "Kirchroth",
"494944", "Wiesmoor",
"493931", "Stendal",
"493834", "Greifswald",
"4939292", "Biederitz",
"494841", "Husum\ Nordsee",
"4938333", "Horst\ bei\ Grimmen",
"495586", "Wieda",
"498685", "Kirchanschöring",
"499572", "Burgkunstadt",
"496393", "Fischbach\ bei\ Dahn",
"497386", "Hayingen",
"495177", "Edemissen\-Abbensen",
"49211", "Düsseldorf",
"4936205", "Gräfenroda",
"494646", "Mohrkirch",
"499199", "Kunreuth",
"494935", "Juist",
"4936201", "Walschleben",
"4938826", "Dassow",
"497484", "Simmersfeld",
"499170", "Schwanstetten",
"499471", "Burglengenfeld",
"496464", "Angelburg",
"494827", "Wacken",
"496858", "Ottweiler\-Fürth",
"497832", "Haslach\ im\ Kinzigtal",
"493581", "Görlitz",
"4934346", "Narsdorf",
"492339", "Sprockhövel\-Hasslinghausen",
"496508", "Hetzerath\ Mosel",
"495962", "Herzlake",
"4939053", "Süplingen",
"498546", "Windorf\-Otterskirchen",
"495645", "Borgentreich\-Borgholz",
"495936", "Twist",
"497191", "Backnang",
"4938302", "Sagard",
"494163", "Horneburg\ Niederelbe",
"494861", "Tönning",
"494964", "Rhede\ Ems",
"496346", "Annweiler\ am\ Trifels",
"496435", "Wallmerod",
"4934922", "Mühlanger",
"495195", "Neuenkirchen\ bei\ Soltau",
"4938327", "Elmenhorst\ Vorpom",
"4935264", "Strehla",
"497641", "Emmendingen",
"495168", "Walsrode\-Stellichte",
"4934656", "Wallhausen\ Sachsen\-Anhalt",
"49385", "Schwerin",
"493385", "Rathenow",
"497044", "Mönsheim",
"492607", "Kobern\-Gondorf",
"498431", "Neuburg\ an\ der\ Donau",
"4934907", "Jeber\-Bergfrieden",
"494971", "Esens",
"4936783", "Gehren\ Thüringen",
"494874", "Todenbüttel",
"499346", "Grünsfeld",
"499435", "Schwarzenfeld",
"494751", "Otterndorf",
"4933085", "Seilershof",
"4939825", "Wokuhl",
"4939821", "Carpin",
"495907", "Geeste",
"494255", "Martfeld",
"494283", "Tarmstedt",
"493672", "Rudolstadt",
"4933369", "Oderberg",
"494349", "Dänischenhagen",
"496471", "Weilburg",
"4937754", "Zwönitz",
"499464", "Walderbach",
"492584", "Warendorf\-Milte",
"496291", "Adelsheim",
"497976", "Sulzbach\-Laufen",
"492590", "Dülmen\-Buldern",
"4937322", "Brand\-Erbisdorf",
"495439", "Bersenbrück",
"492662", "Hachenburg",
"498268", "Tussenhausen",
"492636", "Burgbrohl",
"498295", "Altenmünster\ Schwaben",
"495872", "Stoetze",
"492945", "Lippstadt\-Benninghausen",
"499724", "Stadtlauringen",
"499084", "Bissingen\ Schwaben",
"4936604", "Münchenbernsdorf",
"497674", "Todtmoos",
"492192", "Hückeswagen",
"492934", "Sundern\-Altenhellefeld",
"492831", "Geldern",
"499681", "Windischeschenbach",
"492133", "Dormagen",
"497071", "Tübingen",
"4934262", "Falkenhain\ bei\ Wurzen",
"496428", "Stadtallendorf",
"494122", "Uetersen",
"499332", "Marktbreit",
"499366", "Geroldshausen\ Unterfranken",
"499393", "Rothenfels\ Unterfranken",
"496572", "Manderscheid\ Eifel",
"499090", "Rain\ Lech",
"496669", "Neuhof\-Hauswurz",
"498039", "Rott\ am\ Inn",
"498372", "Obergünzburg",
"498706", "Vilsheim",
"496206", "Lampertheim",
"495923", "Schüttorf",
"492642", "Remagen",
"4934328", "Hartha\ bei\ Döbeln",
"498248", "Lamerdingen",
"4937462", "Rothenkirchen\ Vogtland",
"4935325", "Rückersdorf\ bei\ Finsterwalde",
"494928", "Ihlow\-Riepe",
"4935931", "Königswartha",
"4934659", "Blankenheim\ bei\ Sangerhausen",
"4938848", "Vellahn",
"4935935", "Kleinwelka",
"499444", "Siegenburg",
"495691", "Bad\ Arolsen",
"499741", "Bad\ Brückenau",
"4934297", "Liebertwolkwitz",
"494902", "Jemgum\-Ditzum",
"497145", "Markgröningen",
"4936606", "Kraftsdorf",
"492587", "Ennigerloh\-Westkirchen",
"499467", "Michelsneukirchen",
"494356", "Gross\ Wittensee",
"499245", "Obertrubach",
"498052", "Aschau\ im\ Chiemgau",
"4939933", "Vollrathsruhe",
"496596", "Üdersdorf",
"497805", "Appenweier",
"495355", "Frellstedt",
"495383", "Lutter\ am\ Barenberge",
"497555", "Deggenhausertal",
"497583", "Bad\ Schussenried",
"4939323", "Schönhausen\ Elbe",
"496630", "Schwalmtal\-Storndorf",
"493994", "Malchin",
"496563", "Kyllburg",
"497429", "Egesheim",
"493601", "Mühlhausen\ Thüringen",
"499359", "Karlstadt\-Wiesenfeld",
"494877", "Hennstedt\ bei\ Itzehoe",
"498363", "Pfronten",
"496656", "Ebersburg",
"496402", "Hungen",
"494108", "Rosengarten\ Kreis\ Harburg",
"495843", "Wustrow\ Wendland",
"495141", "Celle",
"497220", "Forbach\-Hundsbach",
"497668", "Ihringen",
"4936701", "Lichte",
"4936705", "Oberweissbach\ Thüringer\ Wald",
"493643", "Weimar\ Thüringen",
"4933678", "Storkow\ Mark",
"4935342", "Mühlberg\ Elbe",
"495551", "Northeim",
"495103", "Wennigsen\ Deister",
"494848", "Rantrum",
"497351", "Biberach\ an\ der\ Riss",
"494330", "Emkendorf",
"499421", "Straubing",
"499120", "Leinburg",
"495904", "Lengerich\ Emsl",
"4935452", "Golssen",
"499265", "Pressig",
"496789", "Heimbach\ Nahe",
"496029", "Mömbris",
"495452", "Mettingen\ Westfalen",
"495606", "Zierenberg",
"495127", "Harsum",
"498505", "Hutthurm",
"496543", "Büchenbeuren",
"499522", "Eltmann",
"492409", "Stolberg\-Gressenich",
"497165", "Göppingen\-Hohenstaufen",
"499761", "Bad\ Königshofen\ im\ Grabfeld",
"498274", "Buttenwiesen",
"496774", "Kaub",
"494605", "Medelby",
"4939927", "Nossentiner\ Hütte",
"499447", "Essing",
"496185", "Hammersbach\ Hessen",
"4933234", "Wustermark",
"496501", "Konz",
"496851", "St\ Wendel",
"493588", "Niesky",
"499087", "Marktoffingen",
"4933478", "Gross\ Neuendorf",
"493663", "Schleiz",
"4937384", "Wechselburg",
"499727", "Schonungen\-Marktsteinach",
"499234", "Neusorg",
"4936643", "Thimmendorf",
"492937", "Arnsberg\-Oeventrop",
"4937756", "Breitenbrunn\ Erzgebirge",
"497933", "Creglingen",
"496305", "Hochspeyer",
"494454", "Jade",
"497134", "Weinsberg",
"498343", "Aitrang",
"495863", "Zernien",
"4935823", "Ostritz",
"4937341", "Ehrenfriedersdorf",
"492825", "Uedem",
"492673", "Ellenz\-Poltersdorf",
"495161", "Walsrode",
"493925", "Stassfurt",
"4938824", "Mallentin",
"498734", "Reisbach\ Niederbayern",
"496234", "Mutterstadt",
"496727", "Gensingen",
"495281", "Bad\ Pyrmont",
"494758", "Nordleda",
"496087", "Waldems",
"4934385", "Mutzschen",
"4933435", "Rehfelde",
"4934381", "Colditz",
"4935388", "Klöden",
"492360", "Haltern\-Lippramsdorf",
"494947", "Aurich\-Ogenbargen",
"499305", "Estenfeld",
"4937293", "Eppendorf\ Sachsen",
"495025", "Estorf\ Weser",
"498322", "Oberstdorf",
"4934344", "Kohren\-Sahlis",
"495753", "Auetal\-Bernsen",
"495174", "Lahstedt",
"495973", "Neuenkirchen\ Kreis\ Steinfurt",
"496265", "Billigheim\ Baden",
"498765", "Bruckberg\ Niederbayern",
"495309", "Lehre\-Wendhausen",
"496298", "Möckmühl",
"492352", "Altena\ Westfalen",
"494172", "Salzhausen",
"496478", "Greifenstein\-Ulm",
"497253", "Bad\ Schönborn",
"4934493", "Gössnitz\ Thüringen",
"496522", "Mettendorf",
"499543", "Hirschaid",
"496761", "Simmern\ Hunsrück",
"498261", "Mindelheim",
"4934654", "Stolberg\ Harz",
"497624", "Grenzach\-Wyhlen",
"4935266", "Heyda\ bei\ Riesa",
"499774", "Oberelsbach",
"4935055", "Höckendorf\ bei\ Dippoldiswalde",
"492257", "Reckerscheid",
"496447", "Langgöns\-Niederkleen",
"499185", "Mühlhausen\ Oberpfalz",
"499153", "Schnaittach",
"497021", "Kirchheim\ unter\ Teck",
"499851", "Dinkelsbühl",
"4935200", "Arnsdorf\ bei\ Dresden",
"499954", "Simbach\ Niederbayern",
"494967", "Rhauderfehn\-Burlage",
"496359", "Grünstadt",
"492043", "Gladbeck",
"492838", "Sonsbeck",
"492529", "Oelde\-Stromberg",
"499402", "Regenstauf",
"498670", "Reischach\ Kreis\ Altötting",
"495822", "Ebstorf",
"499656", "Moosbach\ bei\ Vohenstrauss",
"493622", "Waltershausen\ Thüringen",
"4933965", "Herzsprung\ bei\ Wittstock",
"4933635", "Arensdorf\ Kreis\ Oder\-Spree",
"4933631", "Bad\ Saarow\-Pieskow",
"496421", "Marburg",
"496120", "Aarbergen",
"492604", "Nassau\ Lahn",
"4933742", "Oehna\ Brandenburg",
"498241", "Buchloe",
"492991", "Marsberg\-Bredelar",
"496741", "St\ Goar",
"4939267", "Schneidlingen",
"496467", "Hatzfeld\ Eder",
"4933364", "Gross\ Ziethen\ Kreis\ Barnim",
"498745", "Bodenkirchen",
"496245", "Biblis",
"498203", "Grossaitingen",
"496703", "Wöllstein\ Rheinhessen",
"4939888", "Lychen",
"494921", "Emden\ Stadt",
"49208", "Oberhausen\ Rheinland",
"494824", "Krempe",
"499563", "Rödental",
"49791", "Schwäbisch\ Hall",
"492455", "Waldfeucht",
"498809", "Wessobrunn",
"499242", "Gössweinstein",
"498083", "Isen",
"498055", "Halfing",
"495352", "Schöningen",
"498380", "Achberg",
"498723", "Arnstorf",
"497802", "Oberkirch\ Baden",
"496223", "Neckargemünd",
"492309", "Waltrop",
"4935362", "Schönewalde\ bei\ Herzberg",
"4939777", "Borkenfriede",
"497552", "Pfullendorf",
"4936463", "Gebstedt",
"4935249", "Basslitz",
"499378", "Eichenbühl\-Riedern",
"495906", "Lünne",
"496051", "Gelnhausen",
"4939406", "Harbke",
"495257", "Hövelhof",
"497142", "Bietigheim\-Bissingen",
"499347", "Wittighausen",
"4935607", "Jänschwalde",
"4936842", "Oberhof\ Thüringen",
"4938204", "Broderstorf",
"4936337", "Schiedungen",
"496654", "Gersfeld\ Rhön",
"4939487", "Friedrichsbrunn",
"4937421", "Oelsnitz\ Vogtland",
"498394", "Lautrach",
"4936927", "Unterellen",
"496594", "Birresborn",
"493963", "Woldegk",
"497977", "Oberrot\ bei\ Gaildorf",
"4934221", "Schildau\ Gneisenaustadt",
"4935894", "Hähnichen",
"4935820", "Zodel",
"492637", "Weissenthurm",
"4937434", "Bobenneukirchen",
"493996", "Teterow",
"492753", "Erndtebrück",
"4935471", "Birkenhainchen",
"497633", "Staufen\ im\ Breisgau",
"495063", "Bad\ Salzdetfurth",
"4935475", "Straupitz",
"496580", "Zemmer",
"492973", "Eslohe\ Sauerland",
"496405", "Laubach\ Hessen",
"497948", "Öhringen\-Ohrnberg",
"498338", "Böhen",
"498443", "Hohenwart\ Paar",
"4936640", "Remptendorf",
"492174", "Burscheid\ Rheinland",
"494354", "Fleckeby",
"499367", "Unterpleichfeld",
"497162", "Süssen",
"4939394", "Hohenberg\-Krusemark",
"4939606", "Glienke",
"494456", "Varel\-Altjührden",
"497136", "Bad\ Friedrichshall",
"494602", "Freienwill",
"496182", "Seligenstadt",
"4937365", "Sayda",
"494488", "Westerstede",
"4939957", "Gielow",
"4937361", "Neuhausen\ Erzgebirge",
"4939320", "Schinne",
"499262", "Wallenfels",
"499236", "Nagel",
"495455", "Tecklenburg\-Brochterbeck",
"495483", "Lienen",
"498502", "Fürstenzell",
"499525", "Königsberg\ in\ Bayern",
"4939862", "Schmölln\ bei\ Prenzlau",
"495838", "Gross\ Oesingen",
"496302", "Winnweiler",
"493901", "Salzwedel",
"495043", "Lauenau",
"496776", "Dachsenhausen",
"498276", "Baar\ Schwaben",
"498860", "Bernbeuren",
"497329", "Steinheim\ am\ Albuch",
"492822", "Emmerich",
"495529", "Rhumspringe",
"498463", "Greding",
"494833", "Wesselburen",
"493943", "Wernigerode",
"498707", "Adlkofen",
"496207", "Wald\-Michelbach",
"499321", "Kitzingen",
"497150", "Korntal\-Münchingen",
"497451", "Horb\ am\ Neckar",
"494131", "Lüneburg",
"494239", "Dörverden\-Westen",
"494892", "Schenefeld\ Mittelholstein",
"4939995", "Nossendorf",
"495604", "Grossalmerode",
"4969", "Frankfurt\ am\ Main",
"4939991", "Daberkow",
"499302", "Rottendorf\ Unterfranken",
"49234", "Bochum",
"497626", "Kandern",
"495022", "Wietzen",
"499776", "Mellrichstadt",
"4935246", "Ziegenhain\ Sachsen",
"494667", "Dagebüll",
"498325", "Oberstaufen\-Thalkirchdorf",
"4933877", "Nitzahn",
"492440", "Nettersheim\-Tondorf",
"492843", "Rheinberg",
"499956", "Eichendorf\-Aufhausen",
"499207", "Königsfeld\ Oberfranken",
"4934635", "Bad\ Lauchstädt",
"4938854", "Redefin",
"4934742", "Sylda",
"496321", "Neustadt\ an\ der\ Weinstrasse",
"492904", "Bestwig",
"492801", "Xanten",
"492103", "Hilden",
"4939409", "Eilsleben",
"492551", "Steinfurt\-Burgsteinfurt",
"4935021", "Königstein\ Sächsische\ Schweiz",
"494959", "Dollart",
"492691", "Adenau",
"4934364", "Wermsdorf",
"4935025", "Liebstadt",
"494779", "Freiburg\ Elbe",
"495176", "Edemissen",
"4933454", "Wölsickendorf\/Wollenberg",
"499182", "Velburg",
"497387", "Hohenstein\ Württemberg",
"4938787", "Glöwen",
"498762", "Wartenberg\ Oberbayern",
"494621", "Schleswig",
"496262", "Aglasterhausen",
"494175", "Egestorf\ Nordheide",
"496236", "Neuhofen\ Pfalz",
"492383", "Bönen",
"492355", "Schalksmühle",
"49761", "Freiburg\ im\ Breisgau",
"496525", "Irrel",
"494826", "Hohenlockstedt",
"495937", "Geeste\-Gross\ Hesepe",
"496887", "Schmelz\ Saar",
"498547", "Osterhofen\-Gergweis",
"492269", "Kierspe\-Rönsahl",
"4939247", "Güterglück",
"499405", "Bad\ Abbach",
"495673", "Immenhausen\ Hessen",
"492161", "Mönchengladbach",
"495825", "Wieren",
"498422", "Dollnstein",
"492863", "Velen",
"498157", "Feldafing",
"499223", "Rugendorf",
"496242", "Osthofen",
"498742", "Velden\ Vils",
"4935203", "Tharandt",
"495409", "Hilter\ am\ Teutoburger\ Wald",
"499829", "Flachslanden",
"492606", "Winningen\ Mosel",
"4933762", "Zeuthen",
"492452", "Heinsberg\ Rheinland",
"4934424", "Reuden\ bei\ Zeitz",
"496347", "Hochstadt\ Pfalz",
"497123", "Metzingen\ Württemberg",
"497821", "Lahr\ Schwarzwald",
"4933654", "Fünfeichen",
"4933984", "Blumenthal\ bei\ Pritzwalk",
"499654", "Pleystein",
"49481", "Heide\ Holstein",
"496550", "Irrhausen",
"492975", "Schmallenberg\-Oberkirchen",
"495842", "Schnega",
"496403", "Linden\ Hessen",
"498445", "Gerolsbach",
"494384", "Selent",
"492755", "Bad\ Berleburg\-Schwarzenau",
"498336", "Erkheim",
"4936647", "Saalburg\ Thüringen",
"497635", "Schliengen",
"498362", "Füssen",
"497946", "Bretzfeld",
"495065", "Sibbesse",
"4936209", "Klettbach",
"499857", "Schopfloch\ Mittelfranken",
"495102", "Laatzen",
"496441", "Wetzlar",
"492159", "Meerbusch\-Osterath",
"492251", "Euskirchen",
"493965", "Burow\ bei\ Altentreptow",
"493998", "Demmin",
"4935827", "Nieder\-Seifersdorf",
"498267", "Dirlewang",
"496684", "Hofbieber\-Schwarzbach",
"4935936", "Sohland\ Spree",
"495631", "Korbach",
"4936330", "Grossberndten",
"4935600", "Döbern\ NL",
"496081", "Usingen",
"4936920", "Grossenlupnitz",
"497664", "Freiburg\-Tiengen",
"498221", "Günzburg",
"496721", "Bingen\ am\ Rhein",
"495034", "Neustadt\-Hagen",
"494903", "Wymeer",
"4935326", "Schönborn\ Kreis\ Elbe\-Elster",
"4936704", "Steinheid",
"494104", "Aumühle\ bei\ Hamburg",
"496536", "Kleinich",
"496562", "Speicher",
"499376", "Collenberg",
"498085", "Sankt\ Wolfgang",
"4939923", "Priborn",
"498053", "Bad\ Endorf",
"495908", "Wietmarschen\-Lohne",
"495382", "Bad\ Gandersheim",
"498725", "Wurmannsquick",
"494941", "Aurich",
"4938292", "Kröpelin",
"4936483", "Ziegenrück",
"493831", "Stralsund",
"494844", "Pellworm",
"497582", "Bad\ Buchau",
"4933235", "Friesack",
"499474", "Schmidmühlen",
"499294", "Regnitzlosau",
"496461", "Biedenkopf",
"4933231", "Pausin",
"494835", "Albersdorf\ Holstein",
"493636", "Greussen",
"498247", "Bad\ Wörishofen",
"4933086", "Grieben\ Kreis\ Oberhavel",
"496747", "Emmelshausen",
"4939826", "Blankensee\ bei\ Neustrelitz",
"495862", "Hitzacker\ Elbe",
"495836", "Wittingen\-Radenbeck",
"4939882", "Gollin",
"492672", "Treis\-Karden",
"498465", "Kipfenberg",
"497194", "Spiegelberg",
"497932", "Niederstetten\ Württemberg",
"4934979", "Wulfen\ Sachsen\-Anhalt",
"494927", "Krummhörn\-Loquard",
"499280", "Selbitz\ Oberfranken",
"497966", "Unterschneidheim",
"495045", "Springe\-Bennigsen",
"498342", "Marktoberdorf",
"495453", "Recke",
"495485", "Ladbergen",
"4937344", "Crottendorf\ Sachsen",
"499238", "Röslau",
"4934293", "Naunhof\ bei\ Grimma",
"496542", "Bullay",
"497300", "Roggenburg",
"499523", "Hofheim\ in\ Unterfranken",
"495850", "Neetze",
"494864", "Oldenswort",
"494961", "Papenburg",
"497138", "Schwaigern",
"494458", "Wiefelstede\-Spohle",
"496152", "Gross\-Gerau",
"496427", "Cölbe\-Schönstadt",
"497041", "Mühlacker",
"498434", "Rennertshofen",
"4937381", "Penig",
"497644", "Kenzingen",
"4939327", "Klietz",
"49395", "Neubrandenburg",
"494486", "Edewecht\-Friedrichsfehn",
"4933748", "Treuenbrietzen",
"497252", "Bretten",
"496238", "Dirmstein",
"494754", "Bülkau",
"495147", "Uetze\-Hänigsen",
"496523", "Holsthum",
"4939263", "Unseburg",
"499542", "Schesslitz",
"494974", "Neuharlingersiel",
"4934341", "Geithain",
"494871", "Hohenwestedt",
"494173", "Wulfsen",
"492385", "Hamm\-Rhynern",
"492353", "Halver",
"4934345", "Bad\ Lausick",
"496049", "Kefenrod",
"499427", "Leiblfing",
"4933434", "Herzfelde\ bei\ Strausberg",
"495807", "Altenmedingen",
"4934384", "Grossbothen",
"499152", "Hartenstein\ Mittelfranken",
"497357", "Attenweiler",
"4933672", "Pfaffendorfb\ Beeskow",
"4938825", "Klütz",
"4938780", "Lanz\ Brandenburg",
"4936206", "Grossfahner",
"4938821", "Lüdersdorf",
"496474", "Villmar\-Aumenau",
"499461", "Roding",
"4935329", "Dollenchen",
"496294", "Krautheim\ Jagst",
"492581", "Warendorf",
"4935939", "Hochkirch",
"499747", "Geroda\ Bayern",
"4935054", "Lauenstein\ Sachsen",
"4934651", "Rossla",
"499778", "Fladungen",
"492845", "Neukirchen\-Vluyn",
"497260", "Sinsheim\-Hilsbach",
"497628", "Efringen\-Kirchen",
"4933870", "Zollchow\ bei\ Rathenow",
"498020", "Weyarn",
"495752", "Auetal\-Hattendorf",
"498323", "Immenstadt\ im\ Allgäu",
"4939829", "Blankenförde",
"4933089", "Himmelpfort",
"4933634", "Berkenbrück\ Kreis\ Oder\-Spree",
"492931", "Arnsberg",
"492834", "Straelen",
"4933472", "Golzow\ bei\ Seelow",
"499721", "Schweinfurt",
"4934497", "Langenleuba\-Niederhain",
"499081", "Nördlingen",
"497125", "Bad\ Urach",
"497671", "Todtnau",
"4933964", "Fretzdorf",
"495167", "Walsrode\-Westenholz",
"499536", "Kirchlauter",
"499562", "Sonnefeld",
"497729", "Tennenbronn",
"4934976", "Gröbzig",
"492482", "Hellenthal",
"499225", "Stadtsteinach",
"492608", "Welschneudorf",
"498202", "Althegnenberg",
"499403", "Donaustauf",
"495675", "Trendelburg",
"498639", "Neumarkt\-Sankt\ Veit",
"495823", "Bienenbüttel",
"495121", "Hildesheim",
"497240", "Pfinztal",
"492865", "Raesfeld",
"497449", "Baiersbronn\-Obertal",
"4933361", "Joachimsthal",
"496857", "Namborn",
"494828", "Lägerdorf",
"4933365", "Lüdersdorf\ Kreis\ Barnim",
"4937297", "Thum\ Sachsen",
"496507", "Neumagen\-Dhron",
"499441", "Kelheim",
"494539", "Westerau",
"4938872", "Rehna",
"493623", "Friedrichroda",
"495105", "Barsinghausen",
"496534", "Mülheim\ Mosel",
"497381", "Münsingen",
"493962", "Penzlin\ bei\ Waren",
"492697", "Blankenheim\-Ahrhütte",
"499374", "Eschau",
"4938201", "Gelbensande",
"496361", "Rockenhausen",
"494846", "Hattstedt",
"4938205", "Tessin\ bei\ Rostock",
"4933979", "Wusterhausen\ Dosse",
"495845", "Bergen\ Dumme",
"492972", "Schmallenberg",
"498442", "Wolnzach",
"492752", "Bad\ Laasphe",
"497666", "Denzlingen",
"495036", "Neustadt\-Schneeren",
"497632", "Badenweiler",
"498365", "Wertach",
"496658", "Poppenhausen\ Wasserkuppe",
"494627", "Dörpstedt",
"495062", "Holle\ bei\ Hildesheim",
"494106", "Quickborn\ Kreis\ Pinneberg",
"496565", "Dudeldorf",
"499243", "Pottenstein",
"498082", "Schwindegg",
"4939953", "Schwinkendorf",
"496222", "Wiesloch",
"498722", "Gangkofen",
"497803", "Gengenbach",
"494661", "Niebüll",
"495353", "Königslutter\ am\ Elm",
"497553", "Salem\ Baden",
"497585", "Ostrach",
"4935474", "Schönwalde\ bei\ Lübben",
"492557", "Wettringen\ Kreis\ Steinfurt",
"4937431", "Mehltheuer\ Vogtland",
"4937435", "Reuth\ bei\ Plauen",
"498561", "Pfarrkirchen\ Niederbayern",
"4934224", "Belgern\ Sachsen",
"498334", "Bad\ Grönenbach",
"49365", "Gera",
"496327", "Neustadt\-Lachen",
"4935891", "Rothenburg\ OL",
"494358", "Loose\ bei\ Eckernförde",
"497143", "Besigheim",
"497841", "Achern",
"499201", "Gesees",
"4935895", "Klitten",
"497944", "Kupferzell",
"495865", "Gusborn",
"4933052", "Leegebruch",
"492823", "Goch",
"498462", "Berching",
"492675", "Ediger\-Eller",
"496303", "Enkenbach\-Alsenborn",
"497935", "Schrozberg",
"497646", "Weisweil\ Breisgau",
"494484", "Hude\-Wüsting",
"495042", "Bad\ Münder\ am\ Deister",
"4933768", "Prieros",
"498345", "Stöttwang",
"4937364", "Reitzenhain\ Erzgebirge",
"494893", "Hohenaspe",
"494191", "Kaltenkirchen\ Holstein",
"4939209", "Wanzleben",
"4939395", "Wanzer",
"494832", "Meldorf",
"4939391", "Lückstedt",
"4939856", "Beenz\ bei\ Prenzlau",
"496341", "Landau\ in\ der\ Pfalz",
"494479", "Molbergen\-Peheim",
"496183", "Erlensee",
"496155", "Griesheim\ Hessen",
"4939994", "Metschow",
"495834", "Wittingen\-Knesebeck",
"498541", "Vilshofen\ Niederbayern",
"496881", "Lebach",
"495931", "Meppen",
"4939773", "Altwarp",
"497163", "Ebersbach\ an\ der\ Fils",
"493586", "Neugersdorf\ Sachsen",
"497964", "Stödtlen",
"494603", "Havetoft",
"498151", "Starnberg",
"498450", "Ingolstadt\-Zuchering",
"499869", "Wettringen\ Mittelfranken",
"495482", "Tecklenburg",
"4935603", "Burg\ Spreewald",
"498503", "Neuhaus\ am\ Inn",
"496545", "Blankenrath",
"4936333", "Heringen\ Helme",
"493634", "Sömmerda",
"4939483", "Ballenstedt",
"494641", "Süderbrarup",
"499263", "Ludwigsstadt",
"4936923", "Treffurt",
"498259", "Schiltberg",
"495608", "Söhrewald",
"497751", "Waldshut",
"499183", "Burgthann",
"499155", "Simmelsdorf",
"492631", "Neuwied",
"498407", "Grossmehring",
"4935207", "Moritzburg",
"4938855", "Lübtheen",
"497971", "Gaildorf",
"4938851", "Zarrentin",
"496476", "Mengerskirchen",
"4934782", "Mansfeld\ Südharz",
"497255", "Graben\-Neudorf",
"496869", "Merzig\-Silwingen",
"496296", "Ahorn\ Baden",
"499545", "Buttenheim",
"496263", "Neckargerach",
"4933976", "Wutike",
"492382", "Ahlen\ Westfalen",
"492842", "Kamp\-Lintfort",
"495975", "Rheine\-Mesum",
"492065", "Duisburg\-Rheinhausen",
"497520", "Bodnegg",
"499303", "Eibelstadt",
"495023", "Liebenau\ Kreis\ Nieburg\ Weser",
"495320", "Torfhaus",
"495755", "Kalletal\-Varenholz",
"494756", "Odisheim",
"495159", "Coppenbrügge\-Bisperode",
"4939243", "Nedlitz\ bei\ Zerbst",
"492102", "Ratingen",
"4936848", "Wernshausen",
"4933451", "Heckelberg",
"494976", "Spiekeroog",
"4934361", "Dahlen\ Sachsen",
"493923", "Zerbst",
"499341", "Tauberbischofsheim",
"495251", "Paderborn",
"4935024", "Stadt\ Wehlen",
"496057", "Flörsbachtal",
"496849", "Kirkel",
"492850", "Rees\-Haldern",
"499565", "Untersiemau",
"492485", "Schleiden\-Dreiborn",
"492453", "Heinsberg\-Randerath",
"499222", "Presseck",
"496243", "Monsheim",
"498743", "Geisenhausen",
"493907", "Gardelegen",
"498205", "Dasing",
"494674", "Ockholm",
"4938783", "Dallmin",
"496109", "Frankfurt\-Bergen\-Enkheim",
"4939859", "Fürstenwerder",
"498574", "Wittibreut",
"4939206", "Eichenbarleben",
"497457", "Rottenburg\-Ergenzingen",
"494137", "Barendorf",
"497122", "St\ Johann\ Württemberg",
"496201", "Weinheim\ Bergstr",
"4934672", "Rossleben",
"499534", "Burgpreppach",
"4933655", "Grunow\ Kreis\ Oder\-Spree",
"4933981", "Putlitz",
"4933873", "Grosswudicke",
"4934425", "Droyssig",
"496374", "Weilerbach",
"495672", "Bad\ Karlshafen",
"492836", "Wachtendonk",
"498423", "Titting",
"492862", "Südlohn",
"492045", "Bottrop\-Kirchhellen",
"499658", "Georgenberg",
"495556", "Lindau\ Harz",
"4938353", "Gützkow\ bei\ Greifswald",
"498683", "Tittmoning",
"496395", "Münchweiler\ an\ der\ Rodalb",
"495806", "Barum\ bei\ Bad\ Bevensen",
"497356", "Schemmerhofen",
"499426", "Oberschneiding",
"497388", "Pfronstetten",
"4933932", "Fehrbellin",
"496651", "Rasdorf",
"4936878", "Oberland",
"494749", "Schiffdorf\-Geestenseth",
"495146", "Wietze",
"496054", "Birstein",
"4937369", "Wolkenstein",
"493606", "Heiligenstadt\ Heilbad",
"494805", "Schafstedt",
"494555", "Seedorf\ bei\ Bad\ Segeberg",
"4939204", "Niederndodeleben",
"498404", "Oberdolling",
"494668", "Klanxbüll",
"496591", "Gerolstein",
"493863", "Crivitz",
"4939999", "Tutow",
"492873", "Isselburg\-Werth",
"499208", "Bindlach",
"492625", "Ochtendung",
"497033", "Weil\ Der\ Stadt",
"495663", "Spangenberg",
"492171", "Leverkusen\-Opladen",
"494351", "Eckernförde",
"495696", "Bad\ Arolsen\-Landau",
"499746", "Zeitlofs",
"4939002", "Oebisfelde",
"49941", "Regensburg",
"495132", "Lehrte",
"4938320", "Tribsees",
"495166", "Walsrode\-Kirchboitzen",
"494769", "Bremervörde\-Iselersheim",
"495193", "Schneverdingen",
"4934636", "Schafstädt",
"4933843", "Niemegk",
"496348", "Offenbach\ an\ der\ Queich",
"496433", "Hadamar",
"493691", "Eisenach\ Thüringen",
"4935245", "Burkhardswalde\-Munzig",
"498306", "Ronsberg",
"4933974", "Dessow",
"494165", "Hollenstedt\ Nordheide",
"4935241", "Lommatzsch",
"496272", "Hirschhorn\ Neckar",
"498772", "Mallersdorf\-Pfaffenberg",
"4939033", "Wallstawe",
"496506", "Welschbillig",
"495643", "Borgentreich",
"496856", "St\ Wendel\-Niederkirchen",
"492922", "Werl",
"498548", "Vilshofen\-Sandbach",
"496888", "Lebach\-Steinbach",
"499766", "Grosswenkheim",
"493904", "Haldensleben",
"499732", "Hammelburg",
"495601", "Schauenburg",
"493843", "Güstrow",
"4935026", "Dürrröhrsdorf\-Dittersbach",
"494933", "Dornum\ Ostfriesland",
"498158", "Tutzing",
"499324", "Dettelbach",
"497454", "Sulz\ am\ Neckar",
"494134", "Embsen\ Kreis\ Lüneburg",
"497026", "Lenningen",
"495622", "Fritzlar",
"499856", "Dürrwangen",
"492943", "Erwitte",
"498293", "Welden\ bei\ Augsburg",
"4933928", "Wildberg\ Brandenburg",
"498266", "Kirchheim\ in\ Schwaben",
"492638", "Waldbreitbach",
"496766", "Kisselbach",
"4935775", "Pechern",
"496732", "Wörrstadt",
"498232", "Schwabmünchen",
"4933338", "Stolpe\/Oder",
"4935771", "Bad\ Muskau",
"492804", "Xanten\-Marienbaum",
"4937366", "Rübenau",
"492554", "Laer\ Kreis\ Steinfurt",
"497947", "Forchtenberg",
"4939854", "Kleptow",
"4939601", "Friedland",
"4939605", "Gross\ Nemerow",
"496324", "Hassloch",
"498337", "Altenstadt\ Iller",
"494285", "Rhade\ bei\ Zeven",
"494253", "Asendorf\ Kreis\ Diepholz",
"4939996", "Törpin",
"494859", "Windbergen",
"494509", "Gross\ Grönau",
"499377", "Freudenberg\-Boxtal",
"497172", "Lorch\ Württemberg",
"492694", "Wershofen",
"499433", "Nabburg",
"499348", "Werbach\-Gamburg",
"495258", "Salzkotten",
"492680", "Mündersbach",
"494624", "Kropp",
"499492", "Parsberg",
"499272", "Fichtelberg",
"495286", "Ottenstein\ Niedersachsen",
"4939743", "Zerrenthin",
"4935951", "Neukirch\ Lausitz",
"4934639", "Wallendorf\ Luppe",
"495837", "Sprakensehl",
"4935955", "Pulsnitz",
"4939401", "Neuwegersleben",
"497967", "Jagstzell",
"4939405", "Hötensleben",
"494926", "Krummhörn\-Greetsiel",
"493973", "Pasewalk",
"495925", "Wietmarschen",
"498708", "Weihmichl\-Unterneuhausen",
"492164", "Jüchen\-Otzenrath",
"492963", "Brilon\-Messinghausen",
"495073", "Neustadt\-Esperke",
"498246", "Waal",
"496746", "Pfalzfeld",
"497570", "Sigmaringen\-Gutenstein",
"49641", "Giessen",
"499929", "Ruhmannsfelden",
"499395", "Triefenstein",
"496426", "Fronhausen",
"4936692", "Bürgel",
"492739", "Wilnsdorf",
"4935476", "Wittmannsdorf\-Bückchen",
"494487", "Grossenkneten\-Huntlosen",
"4935722", "Lauta\ bei\ Hoyerswerda",
"499651", "Vohenstrauss",
"49491", "Leer\ Ostfriesland",
"497824", "Schwanau",
"496297", "Ravenstein\ Baden",
"4933636", "Steinhöfel\ Kreis\ Oder\-Spree",
"496477", "Greifenstein\-Nenderoth",
"494802", "Wrohm",
"499744", "Zeitlofs\-Detter",
"495694", "Diemelstadt",
"4933966", "Dranse",
"494552", "Leezen",
"498652", "Berchtesgaden",
"4938323", "Prohn",
"499573", "Staffelstein\ Oberfranken",
"496392", "Hauenstein\ Pfalz",
"498406", "Böhmfeld",
"493991", "Waren\ Müritz",
"4934462", "Laucha\ Unstrut",
"496333", "Waldfischbach\-Burgalben",
"497905", "Langenburg",
"494142", "Steinkirchen\ Kreis\ Stade",
"4937328", "Grossschirma",
"4934903", "Coswig\ Anhalt",
"495943", "Emlichheim",
"492622", "Bendorf\ am\ Rhein",
"498533", "Rotthalmünster",
"494757", "Wanna",
"495144", "Wathlingen",
"496728", "Ober\-Hilbersheim",
"498592", "Wegscheid\ Niederbayern",
"4937349", "Scheibenberg",
"496056", "Bad\ Soden\-Salmünster",
"494977", "Blomberg\ Ostfriesland",
"494948", "Wiesmoor\-Marcardsmoor",
"495554", "Moringen",
"493838", "Bergen\ auf\ Rügen",
"4933731", "Trebbin",
"497354", "Erolzheim",
"495804", "Rätzlingen\ Kreis\ Uelzen",
"499424", "Strasskirchen",
"495901", "Fürstenau\ bei\ Bramsche",
"4939030", "Brunau",
"4939057", "Rätzlingen\ Sachsen\-Anhalt",
"493529", "Heidenau\ Sachsen",
"494633", "Satrup",
"496629", "Schenklengsfeld",
"4938792", "Lenzen\ \(Elbe\)",
"494162", "Jork",
"496468", "Dautphetal\-Mornshausen",
"499326", "Markt\ Einersheim",
"497456", "Haiterbach",
"4937468", "Treuen\ Vogtland",
"494136", "Scharnebeck",
"4934322", "Rosswein",
"496275", "Rothenberg\ Odenwald",
"496504", "Thalfang",
"498179", "Eurasburg\ an\ der\ Loisach",
"495135", "Burgwedel\-Fuhrberg",
"496854", "Oberthal\ Saar",
"4934386", "Dürrweitzschen\ bei\ Grimma",
"4933436", "Prötzel",
"4936204", "Stotternheim",
"4938842", "Lüttenmark",
"499764", "Höchheim",
"496771", "St\ Goarshausen",
"498271", "Meitingen",
"494329", "Langwedel\ Holstein",
"494968", "Neulehe",
"492837", "Weeze",
"498304", "Wildpoldsried",
"4935265", "Glaubitz",
"4935056", "Altenberg\ Sachsen",
"499231", "Marktredwitz",
"4936027", "Lengenfeld\ Unterm\ Stein",
"495963", "Bawinkel",
"498640", "Reit\ Im\ Winkl",
"492925", "Warstein\-Allagen",
"495164", "Hodenhagen",
"49931", "Würzburg",
"497833", "Hornberg\ Schwarzwaldbahn",
"494451", "Varel\ Jadebusen",
"497131", "Heilbronn\ Neckar",
"499735", "Massbach",
"496139", "Budenheim",
"4936743", "Teichel",
"4933969", "Stepenitz",
"4933084", "Gutengermendorf",
"4939824", "Hohenzieritz",
"494626", "Treia",
"494107", "Siek\ Kreis\ Stormarn",
"498731", "Dingolfing",
"496231", "Hochdorf\-Assenheim",
"495037", "Bad\ Rehburg",
"495284", "Schwalenberg",
"497667", "Breisach\ am\ Rhein",
"495171", "Peine",
"492663", "Westerburg\ Westerwald",
"49631", "Kaiserslautern",
"4939740", "Nechlin",
"495625", "Naumburg\ Hessen",
"495873", "Eimke",
"4939298", "Barby\ Elbe",
"494847", "Oster\-Ohrstedt",
"493937", "Osterburg\ Altmark",
"496735", "Eppelsheim",
"492696", "Nohn\ Eifel",
"4937346", "Geyer",
"492556", "Metelen",
"497959", "Frankenhardt",
"499468", "Zell\ Oberpfalz",
"499495", "Breitenbrunn\ Oberpfalz",
"492588", "Harsewinkel\-Greffen",
"499275", "Speichersdorf",
"49851", "Passau",
"496326", "Deidesheim",
"499504", "Stadelhofen",
"497024", "Wendlingen\ am\ Neckar",
"4937755", "Schönheide\ Erzgebirge",
"494282", "Sittensen",
"49461", "Flensburg",
"499854", "Wittelshofen",
"499951", "Landau\ an\ der\ Isar",
"496764", "Rheinböllen",
"497621", "Lörrach",
"4939831", "Feldberg",
"499771", "Bad\ Neustadt\ an\ der\ Saale",
"497175", "Leinzell",
"4938308", "Göhren\ Rügen",
"495922", "Bad\ Bentheim",
"492643", "Altenahr",
"499728", "Wülfershausen\ Unterfranken",
"499088", "Mönchsdeggingen",
"498373", "Altusried",
"497826", "Schuttertal",
"4934928", "Seegrehna",
"492938", "Ense",
"492601", "Nauort",
"496424", "Ebsdorfergrund",
"4933439", "Fredersdorf\-Vogelsdorf",
"4936605", "Bad\ Köstritz",
"4936601", "Hermsdorf\ Thüringen",
"492166", "Mönchengladbach\-Rheydt",
"492132", "Meerbusch\-Büderich",
"4935934", "Grossdubrau",
"495128", "Hohenhameln",
"492994", "Marsberg\-Westheim",
"496744", "Oberwesel",
"4935324", "Crinitz",
"492193", "Dabringhausen",
"499392", "Faulbach\ Unterfranken",
"496573", "Gillenfeld",
"49781", "Offenburg",
"494123", "Barmstedt",
"499448", "Hausen\ Niederbayern",
"499333", "Sommerhausen",
"494924", "Moormerland\-Oldersum",
"4935752", "Ruhland",
"494821", "Itzehoe",
"492272", "Bedburg\ Erft",
"498678", "Marktl",
"494547", "Gudow\ Lauenburg",
"49203", "Duisburg",
"4939388", "Goldbeck\ Altm",
"495573", "Uslar\-Volpriehausen",
"497373", "Zwiefalten",
"492433", "Hückelhoven",
"4939929", "Jabel\ bei\ Waren",
"4936072", "Weissenborn\-Lüderode",
"496128", "Taunusstein",
"494422", "Sande\ Kreis\ Friesl",
"492377", "Wickede\ Ruhr",
"495744", "Hüllhorst",
"493525", "Riesa",
"499091", "Monheim\ Schwaben",
"4939266", "Förderstedt",
"4939055", "Hörsingen",
"4939051", "Calvörde",
"4938464", "Bernitt",
"4939200", "Gommern",
"499554", "Untersteinbach\ Unterfranken",
"495424", "Bad\ Rothenfelde",
"499901", "Hengersberg\ Bayern",
"497244", "Weingarten\ Baden",
"494742", "Dorum",
"499804", "Aurach",
"49881", "Weilheim\ in\ Oberbayern",
"499638", "Neualbenreuth",
"492856", "Hamminkeln\-Brünen",
"4936203", "Vieselbach",
"499943", "Lam\ Oberpfalz",
"492506", "Münster\-Wolbeck",
"493321", "Nauen\ Brandenburg",
"499144", "Pleinfeld",
"495764", "Steyerberg",
"4938331", "Rakow\ Vorpom",
"493378", "Ludwigsfelde",
"492054", "Essen\-Kettwig",
"499135", "Hessdorf\ Mittelfranken",
"498667", "Seeon\-Seebruck",
"4934299", "Gaschwitz",
"497731", "Singen\ Hohentwiel",
"492651", "Mayen",
"4936968", "Rossdorf\ Rhön",
"495326", "Langelsheim",
"497235", "Unterreichenbach\ Kreis\ Calw",
"492395", "Finnentrop\-Rönkhausen",
"492368", "Oer\-Erkenschwick",
"494521", "Eutin",
"4938752", "Zierzow\ bei\ Ludwigslust",
"49751", "Ravensburg",
"499963", "Konzell",
"496171", "Oberursel\ Taunus",
"4933970", "Neustadt\ Dosse",
"496625", "Niederaula",
"499164", "Langenfeld\ Mittelfranken",
"49531", "Braunschweig",
"496873", "Nonnweiler",
"4938324", "Velgast",
"4935267", "Diesbar\-Seusslitz",
"4936021", "Schlotheim",
"4934973", "Osternienburg",
"498024", "Holzkirchen",
"495231", "Detmold",
"496284", "Mudau",
"498784", "Hohenthann",
"4936025", "Körner",
"492591", "Lüdinghausen",
"495139", "Burgwedel",
"494736", "Butjadingen\-Tossens",
"498621", "Trostberg",
"494762", "Kutenholz",
"4934904", "Oranienbaum",
"497264", "Bad\ Rappenau",
"49241", "Aachen",
"4936422", "Reinstädt\ Thüringen",
"499499", "Painten",
"497955", "Wallhausen\ Württemberg",
"4935933", "Neschwitz",
"499279", "Mistelgau",
"497184", "Kaisersbach",
"497775", "Mühlingen",
"498456", "Lenting",
"499171", "Roth\ Mittelfranken",
"493594", "Bischofswerda",
"499873", "Abenberg\-Wassermungenau",
"496164", "Reichelsheim\ Odenwald",
"492208", "Niederkassel",
"4935323", "Sonnewalde",
"499625", "Kastl\ bei\ Amberg",
"494852", "Brunsbüttel",
"499284", "Schwarzenbach\ an\ der\ Saale",
"494502", "Lübeck\-Travemünde",
"497271", "Wörth\ am\ Rhein",
"4939926", "Grabowhöfe",
"4939342", "Gladau",
"494463", "Wangerland",
"495771", "Rahden\ Westfalen",
"4937757", "Rittersgrün",
"496135", "Bodenheim\ Rhein",
"494276", "Borstel\ bei\ Sulingen",
"495504", "Friedland\ Kreis\ Göttingen",
"495951", "Werlte",
"494496", "Friesoythe\-Markhausen",
"497304", "Blaustein\ Württemberg",
"495854", "Bleckede\-Barskamp",
"4938378", "Heringsdorf\ Seebad",
"495495", "Vörden\ Kreis\ Vechta",
"495468", "Bramsche\-Engter",
"495275", "Höxter\-Ottbergen",
"498239", "Langenneufnach",
"4933708", "Rangsdorf",
"498131", "Dachau",
"492426", "Nörvenich",
"496215", "Ludwigshafen",
"494707", "Langen\-Neuenwalde",
"492324", "Hattingen\ Ruhr",
"4936607", "Niederpöllnitz",
"4935842", "Oderwitz",
"4934296", "Groitzsch\ bei\ Pegau",
"496554", "Waxweiler",
"493302", "Hennigsdorf",
"496804", "Mandelbachtal",
"494723", "Cuxhaven\-Altenwalde",
"495056", "Winsen\-Meissendorf",
"4936622", "Triebes",
"492732", "Kreuztal",
"4939452", "Ilsenburg",
"4935792", "Ossling",
"497652", "Hinterzarten",
"496638", "Schwalmtal\-Renzendorf",
"494394", "Bokhorst",
"499922", "Zwiesel",
"496144", "Bischofsheim\ bei\ Rüsselsheim",
"495448", "Barver",
"495333", "Dettum",
"497228", "Forbach",
"497660", "St\ Peter\ Schwarzwald",
"4936744", "Remda",
"497533", "Allensbach",
"494401", "Brake\ Unterweser",
"498095", "Aying",
"4933083", "Schulzendorf\ Kreis\ Oberhavel",
"4939823", "Rechlin",
"496694", "Neukirchen\ Knüll",
"494338", "Alt\ Duvenstedt",
"494443", "Dinklage",
"499128", "Feucht",
"4936785", "Gräfinau\-Angstedt",
"4936781", "Grossbreitenbach",
"494425", "Wangerland\-Hooksiel",
"4939959", "Dargun",
"492771", "Dillenburg",
"4939034", "Fleetmark",
"493522", "Grossenhain\ Sachsen",
"492951", "Büren",
"4938485", "Dabel",
"492504", "Telgte",
"4938481", "Witzin",
"499146", "Markt\ Berolzheim",
"4939246", "Lindau\ Anh",
"492275", "Kerpen\-Buir",
"493447", "Altenburg\ Thüringen",
"497708", "Geisingen\-Leipferdingen",
"499556", "Geiselwind",
"493761", "Werdau\ Sachsen",
"497246", "Malsch\ Kreis\ Karlsruhe",
"495426", "Glandorf",
"496073", "Babenhausen\ Hessen",
"495746", "Rödinghausen",
"494149", "Fredenbeck",
"49541", "Osnabrück",
"495208", "Leopoldshöhe",
"4938393", "Binz\ Ostseebad",
"499663", "Neukirchen\ bei\ Sulzbach\-Rosenberg",
"4933844", "Brück\ Brandenburg",
"493727", "Mittweida",
"494241", "Bassum",
"494559", "Wensin",
"4933973", "Zernitz\ bei\ Neustadt\ Dosse",
"494203", "Weyhe\ bei\ Bremen",
"496837", "Wallerfangen",
"498824", "Oberau\ Loisach",
"494745", "Bad\ Bederkesa",
"4935247", "Zehren\ Sachsen",
"498026", "Hausham",
"496286", "Walldürn\-Rippberg",
"492448", "Hellenthal\-Rescheid",
"492333", "Ennepetal",
"497473", "Mössingen",
"494734", "Stadland\-Seefeld",
"493741", "Plauen",
"497232", "Königsbach\-Stein",
"496258", "Gernsheim",
"4933876", "Buschow",
"492392", "Werdohl",
"4939779", "Eggesin",
"497266", "Kirchardt",
"4939489", "Strassberg\ Harz",
"499193", "Höchstadt\ an\ der\ Aisch",
"4936929", "Ruhla",
"497337", "Nellingen\ Alb",
"499132", "Herzogenaurach",
"494322", "Bordesholm",
"4935609", "Drachhausen",
"499166", "Münchsteinach",
"492297", "Wildbergerhütte",
"4938354", "Wusterhusen",
"497524", "Bad\ Waldsee",
"4936948", "Römhild",
"495324", "Vienenburg",
"494765", "Ebersdorf\ bei\ Bremervörde",
"4936200", "Elxleben\ bei\ Arnstadt",
"494169", "Sauensiek",
"499938", "Moos\ Niederbayern",
"495766", "Rehburg\-Loccum",
"4938722", "Raduhn",
"495732", "Löhne",
"492056", "Heiligenhaus",
"493421", "Torgau",
"4939203", "Barleben",
"494261", "Rotenburg\ Wümme",
"496622", "Bebra",
"499643", "Auerbach\ in\ der\ Oberpfalz",
"496004", "Lich\-Eberstadt",
"494883", "Süderstapel",
"494855", "Eddelak",
"494181", "Buchholz\ in\ der\ Nordheide",
"494480", "Ovelgönne\-Strückhausen",
"4939607", "Kotelow",
"494505", "Stockelsdorf\-Curau",
"494289", "Kirchtimke",
"492424", "Vettweiss",
"4939956", "Neukalen",
"4936452", "Berlstedt",
"497952", "Gerabronn",
"4939362", "Grieben\ bei\ Tangerhütte",
"494274", "Varrel\ bei\ Sulingen",
"495506", "Adelebsen",
"496643", "Herbstein",
"494494", "Bösel\ Oldenburg",
"499622", "Hirschau\ Oberpfalz",
"497306", "Vöhringen\ Iller",
"4939744", "Rothenklempenow",
"495492", "Steinfeld\ Oldenburg",
"498868", "Schwabsoien",
"499286", "Oberkotzau",
"495272", "Brakel\ Westfalen",
"495433", "Badbergen",
"492573", "Nordwalde",
"497577", "Veringenstadt",
"495377", "Ehra\-Lessien",
"493563", "Spremberg",
"492744", "Herdorf",
"498454", "Karlshuld",
"493596", "Neustadt\ in\ Sachsen",
"497158", "Neuhausen\ auf\ den\ Fildern",
"496132", "Ingelheim\ am\ Rhein",
"494343", "Laboe",
"4933080", "Marienthal\ Kreis\ Oberhavel",
"4939820", "Triepkendorf",
"496166", "Fischbachtal",
"496696", "Gilserberg",
"492735", "Neunkirchen\ Siegerl",
"499073", "Gundelfingen\ an\ der\ Donau",
"4939776", "Hintersee",
"4936652", "Wurzbach",
"4939422", "Badersleben",
"497683", "Simonswald",
"497655", "Feldberg\-Altglashütten",
"499925", "Bayerisch\ Eisenstein",
"49231", "Dortmund",
"498388", "Hergensweiler",
"496663", "Steinau\ an\ der\ Strasse",
"4935930", "Seitschen",
"4936336", "Klettenberg",
"497391", "Ehingen\ Donau",
"4936764", "Neuhaus\-Schierschnitz",
"4939407", "Seehausen\ Börde",
"4935606", "Briesen\ bei\ Cottbus",
"492687", "Horhausen\ Westerwald",
"4936926", "Creuzburg",
"499837", "Haundorf",
"495054", "Bergen\-Sülze",
"497404", "Epfendorf",
"492764", "Welschen\ Ennest",
"4938789", "Wolfshagen\ bei\ Perleberg",
"494363", "Lensahn",
"495651", "Eschwege",
"496146", "Hochheim\ am\ Main",
"498330", "Legau",
"493501", "Pirna",
"498033", "Oberaudorf",
"496588", "Pluwig",
"497940", "Künzelsau",
"498092", "Grafing\ bei\ München",
"495368", "Parsau",
"4939853", "Holzendorf\ bei\ Prenzlau",
"496556", "Pronsfeld",
"4936258", "Friemar",
"4938738", "Karow\ bei\ Lübz",
"497568", "Bad\ Wurzach\-Hauerz",
"496806", "Heusweiler",
"493774", "Schwarzenberg",
"493471", "Bernburg\ Saale",
"4939993", "Hohenmocker",
"492958", "Büren\-Harth",
"4939774", "Mönkebude",
"4938222", "Semlow",
"496672", "Eiterfeld",
"499845", "Oberdachstetten",
"496569", "Bickendorf",
"497743", "Ühlingen\-Birkendorf",
"492778", "Siegbach",
"4936766", "Schalkau",
"492747", "Molzhain",
"4935604", "Krieschow",
"495374", "Isenbüttel",
"4938207", "Stäbelow",
"497574", "Gammertingen",
"4936334", "Wolkramshausen",
"499105", "Grosshabersdorf",
"4939484", "Harzgerode",
"492461", "Jülich",
"4936924", "Mihla",
"498122", "Erding",
"498457", "Vohburg\ an\ der\ Donau",
"494248", "Bassum\-Neubruchhausen",
"495201", "Halle\ Westfalen",
"496007", "Rosbach\-Rodheim",
"494706", "Schiffdorf",
"495109", "Ronnenberg",
"492427", "Nideggen",
"494372", "Westfehmarn",
"4937437", "Bad\ Elster",
"492152", "Kempen",
"498076", "Pfaffing",
"499385", "Kolitzheim",
"499353", "Karlstadt",
"4937363", "Zöblitz",
"497423", "Oberndorf\ am\ Neckar",
"495705", "Petershagen\-Windheim",
"498369", "Rückholz",
"495849", "Waddeweitz",
"492542", "Gescher",
"494497", "Barssel\-Harkebrügge",
"494277", "Schwaförden",
"4936372", "Kleinneuhausen",
"4939397", "Geestgottberg",
"498751", "Mainburg",
"496251", "Bensheim",
"4939954", "Stavenhagen\ Reuterstadt",
"492441", "Kall",
"496159", "Messel",
"4939039", "Bonese",
"4935473", "Neu\ Lübbenau",
"496023", "Alzenau\ in\ Unterfranken",
"498283", "Neuburg\ an\ der\ Kammel",
"496783", "Baumholder",
"496755", "Odernheim\ am\ Glan",
"4939088", "Letzlingen",
"4934223", "Dommitzsch",
"499865", "Adelshofen\ Mittelfranken",
"492403", "Eschweiler\ Rheinland",
"497763", "Murg",
"495263", "Barntrup",
"497939", "Schrozberg\-Spielbach",
"494791", "Osterholz\-Scharmbeck",
"492225", "Meckenheim\ Rheinland",
"498349", "Stötten\ am\ Auerberg",
"4939746", "Krackow",
"499608", "Kohlberg\ Oberpfalz",
"4933849", "Wiesenburg\ Mark",
"4937423", "Adorf\ Vogtland",
"492562", "Gronau\ Westfalen",
"495476", "Ostercappeln\-Venne",
"499482", "Wörth\ an\ der\ Donau",
"492536", "Münster\-Albachten",
"4938428", "Hohenkirchen\ bei\ Wismar",
"494268", "Bötersen",
"4936465", "Oberndorf\ bei\ Apolda",
"494295", "Emtinghausen",
"494475", "Molbergen",
"4936461", "Bad\ Sulza",
"492721", "Lennestadt",
"499931", "Plattling",
"499834", "Theilenhofen",
"492684", "Puderbach\ Westerwald",
"497462", "Immendingen",
"493681", "Suhl",
"494156", "Talkau",
"497436", "Messstetten\-Oberdigisheim",
"496482", "Runkel",
"497345", "Langenau\ Württemberg",
"4934208", "Löbnitz\ bei\ Delitzsch",
"494188", "Welle\ Nordheide",
"4933874", "Stechow\ Brandenburg",
"493724", "Burgstädt",
"495545", "Hedemünden",
"4935205", "Ottendorf\-Okrilla",
"494546", "Mustin\ Lauenburg",
"4935201", "Langebrück",
"495155", "Emmerthal",
"495183", "Lamspringe",
"493332", "Schwedt\/Oder",
"496834", "Bous",
"493366", "Beeskow",
"494308", "Schwedeneck",
"498196", "Pürgen",
"497541", "Friedrichshafen",
"499251", "Münchberg",
"4938356", "Behrenhoff",
"495341", "Salzgitter",
"498861", "Schongau",
"4933457", "Altreetz",
"492507", "Havixbeck",
"4938784", "Kleinow\ Kreis\ Prignitz",
"492857", "Rees\-Mehr",
"497853", "Kehl\-Bodersweier",
"495303", "Wendeburg",
"4934602", "Landsberg\ Sachsen\-Anhalt",
"497503", "Wilhelmsdorf\ Württemberg",
"496042", "Büdingen\ Hessen",
"497151", "Waiblingen",
"494431", "Wildeshausen",
"496865", "Mettlach\-Orscholz",
"497259", "Östringen\-Odenheim",
"496898", "Völklingen",
"499549", "Lisberg",
"499975", "Waldmünchen\-Geigant",
"495327", "Bad\ Grund\ Harz",
"493435", "Oschatz",
"498381", "Lindenberg\ im\ Allgäu",
"497527", "Wolfegg",
"4939036", "Binde",
"494532", "Bargteheide",
"493346", "Seelow",
"496050", "Biebergemünd",
"496385", "Reichenbach\-Steegen",
"497442", "Baiersbronn",
"496353", "Freinsheim",
"495222", "Bad\ Salzuflen",
"4939244", "Steutz",
"4939728", "Medow\ bei\ Anklam",
"492523", "Wadersloh",
"497365", "Essingen\ Württemberg",
"495565", "Einbeck\-Wenzen",
"4937202", "Claussnitz\ bei\ Chemnitz",
"4933832", "Rogäsen",
"4935023", "Bad\ Gottleuba",
"492238", "Pulheim",
"498666", "Teisendorf",
"496036", "Wölfersheim",
"4937608", "Waldenburg\ Sachsen",
"493464", "Sangerhausen",
"495658", "Wehretal",
"496062", "Erbach\ Odenwald",
"496709", "Fürfeld\ Kreis\ Bad\ Kreuznach",
"495686", "Schwarzenborn\ Knüll",
"498585", "Grainet",
"498553", "Spiegelau",
"4939749", "Grambow\ bei\ Pasewalk",
"499672", "Neunburg\ vorm\ Wald",
"4933846", "Dippmannsdorf",
"4934633", "Braunsbedra",
"498803", "Peissenberg",
"497722", "Triberg\ im\ Schwarzwald",
"494224", "Gross\ Ippener",
"494737", "Stadland\-Schwei",
"499569", "Sesslach",
"497082", "Neuenbürg\ Württemberg",
"497561", "Leutkirch\ im\ Allgäu",
"493886", "Gadebusch",
"495361", "Wolfsburg",
"492294", "Morsbach\ Sieg",
"496581", "Saarburg",
"4933657", "Steinsdorf\ Brandenburg",
"495534", "Eschershausen\ an\ der\ Lenne",
"498841", "Murnau\ am\ Staffelsee",
"496105", "Mörfelden\-Walldorf",
"498143", "Inning\ am\ Ammersee",
"492474", "Nideggen\-Schmidt",
"497334", "Deggingen",
"4937343", "Jöhstadt",
"498074", "Schnaitsee",
"4934294", "Rackwitz",
"4935825", "Kodersdorf",
"49214", "Leverkusen",
"495857", "Bleckede\-Brackede",
"498671", "Altötting",
"499102", "Wilhermsdorf",
"497307", "Senden\ Iller",
"495507", "Ebergötzen",
"493733", "Annaberg\-Buchholz",
"496229", "Neckarsteinach",
"4936645", "Mühltroff",
"4936732", "Könitz",
"492303", "Unna",
"499842", "Uffenheim",
"496675", "Breitenbach\ am\ Herzberg",
"494704", "Drangstedt",
"497202", "Karlsbad",
"496420", "Lahntal",
"499908", "Schöfweg",
"499382", "Gerolzhofen",
"495376", "Wesendorf\ Kreis\ Gifhorn",
"492759", "Bad\ Berleburg\-Aue",
"495702", "Petershagen\-Lahde",
"495069", "Nordstemmen",
"497576", "Krauchenwies",
"496167", "Modautal",
"492545", "Rosendahl\-Darfeld",
"493328", "Teltow",
"493969", "Siedenbollentin",
"499287", "Selb",
"494920", "Wirdum",
"4934909", "Aken\ Elbe",
"499631", "Tirschenreuth",
"492984", "Hallenberg",
"492183", "Rommerskirchen",
"497738", "Steisslingen",
"498252", "Schrobenhausen",
"496752", "Kirn\ Nahe",
"493371", "Luckenwalde",
"4936703", "Gräfenthal",
"492686", "Weyerbusch",
"499836", "Gunzenhausen\-Cronheim",
"492361", "Recklinghausen",
"496697", "Willingshausen",
"495474", "Stemwede\-Dielingen",
"4939924", "Stuer",
"4933237", "Paulinenaue",
"4936484", "Knau\ bei\ Pössneck",
"492534", "Münster\-Roxel",
"495294", "Hövelhof\-Espeln",
"493949", "Oschersleben\ Bode",
"4939325", "Vinzelberg",
"494839", "Wöhrden\ Dithmarschen",
"4935872", "Neusalza\-Spremberg",
"494292", "Ritterhude",
"4937360", "Olbernhau",
"494472", "Lastrup",
"492327", "Bochum\-Wattenscheid",
"4939321", "Arneburg",
"494233", "Blender",
"4939931", "Röbel\ Müritz",
"494528", "Schönwalde\ am\ Bungsberg",
"496557", "Hallschlag",
"498628", "Kienberg\ Oberbayern",
"492222", "Bornheim\ Rheinland",
"497323", "Gerstetten",
"492565", "Gronau\-Epe",
"495238", "Nieheim\-Himmighausen",
"496147", "Trebur",
"499453", "Thalmassing",
"492598", "Senden\-Ottmarsbocholt",
"498469", "Freystadt\-Burggriesbach",
"495523", "Bad\ Sachsa",
"4938458", "Zehna",
"49371", "Chemnitz\ Sachsen",
"4938827", "Kalkhorst",
"4934691", "Könnern",
"499178", "Abenberg\ Mittelfranken",
"4939978", "Gross\ Roge",
"495152", "Hessisch\ Oldendorf",
"4935020", "Struppen",
"497247", "Linkenheim\-Hochstetten",
"493335", "Finowfurt",
"495427", "Melle\-Buer",
"497465", "Emmingen\-Liptingen",
"498194", "Vilgertshofen",
"492243", "Eitorf",
"4934347", "Oelzschau\ bei\ Borna",
"4935698", "Hornow",
"499147", "Nennslingen",
"496485", "Nentershausen\ Westerwald",
"496453", "Gemünden\ Wohra",
"496500", "Waldrach",
"495542", "Witzenhausen",
"493531", "Finsterwalde",
"4933633", "Spreenhagen",
"494544", "Berkenthin",
"49228", "Bonn",
"496045", "Gedern",
"492389", "Werne",
"496836", "Überherrn",
"493364", "Eisenhüttenstadt",
"4933963", "Wulfersdorf\ bei\ Wittstock",
"499972", "Waldmünchen",
"494953", "Bunde",
"494154", "Trittau",
"497434", "Winterlingen",
"498041", "Bad\ Tölz",
"4938326", "Grimmen",
"492374", "Iserlohn\-Letmathe",
"4936042", "Tonna",
"498138", "Schwabhausen\ bei\ Dachau",
"493726", "Flöha",
"4934906", "Raguhn",
"494773", "Lamstedt",
"495461", "Bramsche\ Hase",
"495225", "Spenge",
"4939062", "Bebertal",
"496382", "Lauterecken",
"497445", "Pfalzgrafenweiler",
"4933208", "Fahrland",
"493981", "Neustrelitz",
"492263", "Engelskirchen",
"492296", "Reichshof\-Brüchermühle",
"498635", "Pleiskirchen",
"499167", "Oberscheinfeld",
"497362", "Bopfingen",
"495536", "Holzminden\-Neuhaus",
"497336", "Lonsee",
"495562", "Dassel\-Markoldendorf",
"4935053", "Glashütte\ Sachsen",
"496287", "Limbach\ Baden",
"498027", "Dietramszell",
"4934495", "Dobitschen",
"495721", "Stadthagen",
"496034", "Wöllstadt",
"493466", "Artern\ Unstrut",
"494535", "Nahe",
"4934491", "Schmölln\ Thüringen",
"495684", "Frielendorf",
"497267", "Gemmingen",
"493493", "Bitterfeld",
"496631", "Alsfeld",
"497129", "Lichtenstein\ Württemberg",
"4938466", "Jürgenshagen",
"4939264", "Kroppenstedt",
"494682", "Amrum",
"49421", "Bremen",
"498061", "Bad\ Aibling",
"495767", "Warmsen",
"4937291", "Augustusburg",
"494408", "Hude\ Oldenburg",
"496102", "Neu\-Isenburg",
"495441", "Diepholz",
"4933367", "Friedrichswalde\ Brandenburg",
"497221", "Baden\-Baden",
"4937295", "Lugau\ Erzgebirge",
"498664", "Chieming",
"494564", "Schashagen",
"499229", "Mainleus",
"4933433", "Buckow\ Märkische\ Schweiz",
"4934383", "Trebsen\ Mulde",
"498582", "Röhrnbach",
"4933602", "Alt\ Zeschdorf",
"499823", "Leutershausen",
"495403", "Bad\ Iburg",
"496842", "Blieskastel",
"499675", "Altendorf\ am\ Nabburg",
"494331", "Rendsburg",
"497725", "Königsfeld\ im\ Schwarzwald",
"493344", "Bad\ Freienwalde",
"497053", "Bad\ Teinach\-Zavelstein",
"499420", "Feldkirchen\ Niederbayern",
"497085", "Enzklösterle",
"4936921", "Wutha\-Farnroda",
"492851", "Rees",
"4939485", "Gernrode\ Harz",
"492954", "Rüthen\-Oestereiden",
"4939481", "Hedersleben\ bei\ Aschersleben",
"492501", "Münster\-Hiltrup",
"4936925", "Marksuhl",
"492153", "Nettetal\-Lobberich",
"498867", "Rottenbuch\ Oberbayern",
"495347", "Burgdorf\ bei\ Salzgitter",
"492774", "Dietzhölztal",
"4936331", "Ilfeld",
"4935605", "Komptendorf",
"499257", "Zell\ Oberfranken",
"4935601", "Peitz",
"4936335", "Grosswechsungen",
"496409", "Biebertal",
"493764", "Meerane",
"497578", "Wald\ Hohenz",
"492543", "Billerbeck\ Westfalen",
"499906", "Mariaposching",
"495378", "Sassenburg\-Platendorf",
"497157", "Waldenbuch",
"499352", "Lohr\ am\ Main",
"497422", "Schramberg",
"495242", "Rheda\-Wiedenbrück",
"4939771", "Ueckermünde",
"4939775", "Ahlbeck\ bei\ Torgelow",
"496673", "Haunetal",
"4939393", "Werben\ Elbe",
"496825", "Illingen\ Saar",
"497742", "Klettgau",
"494244", "Harpstedt",
"4934202", "Delitzsch",
"4938232", "Zingst\ Ostseebad",
"499360", "Thüngen",
"4935477", "Rietzneuendorf\-Friedrichshof",
"492305", "Castrop\-Rauxel",
"498821", "Garmisch\-Partenkirchen",
"498123", "Moosinning",
"493735", "Marienberg\ Sachsen",
"49331", "Potsdam",
"492563", "Stadtlohn",
"497325", "Sontheim\ an\ der\ Brenz",
"494731", "Nordenham",
"493744", "Auerbach\ Vogtland",
"492630", "Mülheim\-Kärlich",
"495525", "Walkenried",
"4937602", "Kirchberg\ Sachsen",
"4935893", "Mücka",
"495262", "Extertal",
"495236", "Blomberg\-Grossenmarpe",
"492596", "Nordkirchen",
"4937433", "Gutenfürst",
"4937367", "Lengefeld\ Erzgebirge",
"4939955", "Jürgenstorf",
"494235", "Langwedel\-Etelsen",
"498847", "Obersöchering",
"4939951", "Faulenrost",
"496587", "Zerf",
"494526", "Ascheberg\ Holstein",
"495367", "Rühen",
"493573", "Senftenberg",
"497567", "Leutkirch\-Friesenhofen",
"499604", "Wernberg\-Köblitz",
"4939997", "Jarmen",
"49451", "Lübeck",
"4936464", "Wormstedt",
"498387", "Weiler\-Simmerberg",
"495321", "Goslar",
"4933230", "Börnicke\ Kreis\ Havelland",
"497736", "Tengen",
"495459", "Hörstel",
"499529", "Oberaurach",
"492402", "Stolberg\ Rheinland",
"494264", "Sottrum\ Kreis\ Rotenburg",
"497762", "Wehr\ Baden",
"492656", "Virneburg",
"4938203", "Bad\ Doberan",
"4939722", "Sarnow\ bei\ Anklam",
"492688", "Kroppach",
"499340", "Königheim\-Brehmen",
"496022", "Obernburg\ am\ Main",
"495250", "Delbrück\ Westfalen",
"498282", "Krumbach\ Schwaben",
"49861", "Traunstein",
"4937208", "Auerswalde",
"496782", "Birkenfeld\ Nahe",
"4933838", "Päwesin",
"498136", "Markt\ Indersdorf",
"492421", "Düren",
"494775", "Grossenwörden",
"494955", "Westoverledingen",
"4935204", "Wilsdruff",
"4934637", "Frankleben",
"495207", "Schloss\ Holte\-Stukenbrock",
"494184", "Hanstedt\ Nordheide",
"4933875", "Rhinow",
"4934423", "Heuckewalde",
"494271", "Sulingen",
"4930", "Berlin",
"494491", "Friesoythe",
"495956", "Rastdorf",
"495302", "Vechelde",
"4933653", "Ziltendorf",
"496838", "Saarwellingen",
"497852", "Willstätt",
"4933983", "Gross\ Pankow\ Kreis\ Prignitz",
"496043", "Nidda",
"497502", "Wolpertswende",
"496340", "Wörth\-Schaidt",
"495776", "Preussisch\ Ströhen",
"492359", "Kierspe",
"494179", "Winsen\-Tönnhausen",
"497276", "Herxheim\ bei\ Landau\ Pfalz",
"496455", "Frankenau\ Hessen",
"496483", "Selters\ Taunus",
"4938228", "Dettmannsdorf\-Kölzow",
"497463", "Mühlheim\ an\ der\ Donau",
"492245", "Much",
"495182", "Gronau\ Leine",
"493448", "Meuselwitz\ Thüringen",
"499176", "Allersberg",
"4938781", "Mellen",
"497707", "Bräunlingen",
"4938785", "Berge\ bei\ Perleberg",
"492741", "Betzdorf",
"496894", "St\ Ingbert",
"4935027", "Weesenstein",
"498552", "Grafenau\ Niederbayern",
"499825", "Herrieden",
"496096", "Wiesen\ Unterfranken",
"495405", "Hasbergen\ Kreis\ Osnabrück",
"499673", "Tiefenbach\ Oberpfalz",
"498802", "Huglfing",
"497723", "Furtwangen\ im\ Schwarzwald",
"4934363", "Cavertitz",
"497083", "Bad\ Herrenalb",
"497055", "Neuweiler\ Kreis\ Calw",
"4939241", "Leitzkau",
"4939245", "Loburg",
"4938422", "Neukloster",
"496063", "Bad\ König",
"499937", "Oberpöring",
"498142", "Olching",
"4938486", "Gustävel",
"495594", "Bovenden\-Reyershausen",
"492234", "Frechen",
"497394", "Schelklingen",
"494406", "Berne",
"495654", "Herleshausen",
"4936378", "Ostramondra",
"492447", "Dahlem\ bei\ Kall",
"496257", "Seeheim\-Jugenheim",
"495051", "Bergen\ Kreis\ Celle",
"493629", "Stadtilm",
"494533", "Reinfeld\ Holstein",
"492761", "Olpe\ Biggesee",
"495829", "Wriedel",
"492522", "Oelde",
"498633", "Tüssling",
"499409", "Pielenhofen",
"4938853", "Drönnewitz\ bei\ Hagenow",
"493771", "Aue\ Sachsen",
"4935033", "Rosenthal\ Sächsische\ Schweiz",
"4939082", "Mieste",
"493504", "Dippoldiswalde",
"495223", "Bünde",
"496352", "Kirchheimbolanden",
"497443", "Dornstetten",
"492265", "Reichshof\-Eckenhagen",
"4937383", "Lunzenau",
"499720", "Üchtelhausen",
"499383", "Wiesentheid",
"499355", "Frammersbach",
"495245", "Herzebrock\-Clarholz",
"499080", "Harburg\ Schwaben",
"4936644", "Hirschberg\ Saale",
"497425", "Trossingen",
"495703", "Hille",
"493537", "Jessen\ Elster",
"495467", "Voltlage",
"499094", "Tagmersheim",
"492182", "Grevenbroich\-Kapellen",
"494246", "Twistringen\-Heiligenloh",
"4934295", "Krensitz",
"4937430", "Eichigt",
"495741", "Lübbecke",
"494708", "Ringstedt",
"4934291", "Borsdorf",
"499103", "Cadolzburg",
"499551", "Burgwindheim",
"495421", "Dissen\ am\ Teutoburger\ Wald",
"499904", "Lalling",
"4939972", "Walkendorf",
"4936029", "Menteroda",
"492207", "Kürten\-Dürscheid",
"499843", "Burgbernheim",
"497203", "Walzbachtal",
"497745", "Jestetten",
"499141", "Weissenburg\ in\ Bayern",
"4935692", "Kerkwitz",
"492776", "Bad\ Endbach\-Hartenrod",
"4933233", "Ketzin",
"492302", "Witten",
"494232", "Langwedel\ Kreis\ Verden",
"4939925", "Wredenhagen",
"4936481", "Neustadt\ an\ der\ Orla",
"497227", "Lichtenau\ Baden",
"495447", "Lembruch",
"497734", "Gailingen",
"494266", "Brockel",
"4939921", "Ankershagen",
"492654", "Polch",
"495761", "Stolzenau",
"498067", "Tuntenhausen",
"494293", "Ottersberg\-Fischerhude",
"494473", "Emstek",
"492051", "Velbert",
"499606", "Pfreimd",
"499127", "Rosstal\ Mittelfranken",
"497322", "Giengen\ an\ der\ Brenz",
"494337", "Jevenstedt",
"499452", "Langquaid",
"495522", "Osterode\ am\ Harz",
"4933608", "Jacobsdorf\ Mark",
"492538", "Drensteinfurt\-Rinkerode",
"495265", "Dörentrup",
"492223", "Königswinter",
"498509", "Ruderting",
"4937347", "Bärenstein\ Kreis\ Annaberg",
"496174", "Königstein\ im\ Taunus",
"4933202", "Töplitz",
"492405", "Würselen",
"499161", "Neustadt\ an\ der\ Aisch",
"497765", "Rickenbach\ Hotzenwald",
"499269", "Tettau\ Kreis\ Kronach",
"493987", "Templin",
"494524", "Scharbeutz\-Pönitz",
"4939752", "Blumenhagen\ bei\ Strasburg",
"496753", "Meisenheim",
"498285", "Burtenbach",
"498253", "Pöttmes",
"496785", "Herrstein",
"4939934", "Gross\ Plasten",
"4939059", "Wegenstedt",
"49341", "Leipzig",
"496637", "Feldatal",
"4939390", "Iden",
"498624", "Obing",
"497261", "Sinsheim",
"4939324", "Kläden\ bei\ Stendal",
"494609", "Eggebek",
"498021", "Waakirchen",
"495234", "Horn\-Bad\ Meinberg",
"496281", "Buchen\ Odenwald",
"498781", "Rottenburg\ an\ der\ Laaber",
"492594", "Dülmen",
"499174", "Hilpoltstein",
"493591", "Bautzen",
"499973", "Furth\ im\ Wald",
"496161", "Brensbach",
"495305", "Sickte",
"496269", "Gundelsheim\ Württemberg",
"497505", "Fronreute",
"4933363", "Altenhof\ Kreis\ Barnim",
"497181", "Schorndorf\ Württemberg",
"499189", "Berg\ bei\ Neumarkt\ in\ der\ Oberpfalz",
"497274", "Germersheim",
"4933437", "Reichenberg\ bei\ Strausberg",
"494772", "Oberndorf\ Oste",
"499637", "Falkenberg\ Oberpfalz",
"498165", "Neufahrn\ bei\ Freising",
"494952", "Rhauderfehn",
"499281", "Hof\ Saale",
"495185", "Duingen",
"495153", "Salzhemmendorf",
"495954", "Lorup",
"498677", "Burghausen\ Salzach",
"4938850", "Gammelin",
"495851", "Dahlenburg",
"493395", "Pritzwalk",
"4936026", "Struth\ bei\ Mühlhausen",
"4935057", "Hermsdorf\ Erzgebirge",
"495774", "Wagenfeld\-Ströhen",
"497343", "Buch\ bei\ Illertissen",
"496452", "Battenberg\ Eder",
"494158", "Roseburg",
"492378", "Fröndenberg\-Langschede",
"4936082", "Ershausen",
"496127", "Niedernhausen\ Taunus",
"498134", "Odelzhausen",
"495543", "Staufenberg\ Niedersachsen",
"4936738", "Königsee",
"492242", "Hennef\ Sieg",
"494186", "Buchholz\-Trelde",
"49212", "Solingen",
"496551", "Prüm",
"4933637", "Beerfelde",
"496103", "Langen\ Hessen",
"498145", "Mammendorf",
"4934494", "Ehrenhain",
"494683", "Oldsum",
"4933967", "Freyenstein",
"495656", "Waldkappel",
"499822", "Bechhofen\ an\ der\ Heide",
"498583", "Neureichenau",
"498555", "Perlesreut",
"496843", "Gersheim",
"4934653", "Rottleberode",
"495402", "Bissendorf\ Kreis\ Osnabrück",
"496440", "Kölschhausen",
"498805", "Hohenpeissenberg",
"497052", "Bad\ Liebenzell",
"496249", "Guntersblum",
"4938452", "Lalendorf",
"4938823", "Selmsdorf",
"492525", "Beckum\-Neubeckum",
"497363", "Lauchheim",
"495563", "Kreiensen",
"493377", "Zossen\ Brandenburg",
"496383", "Glan\-Münchweiler",
"492236", "Wesseling\ Rheinland",
"496355", "Albisheim\ Pfrimm",
"492262", "Wiehl",
"494404", "Elsfleth",
"496094", "Weibersbrunn",
"4937294", "Grünhainichen",
"4934343", "Regis\-Breitingen",
"496691", "Schwalmstadt",
"493433", "Borna\ Stadt",
"4939265", "Löderburg",
"492367", "Henrichenburg",
"4939056", "Klüden",
"494205", "Ottersberg",
"495957", "Lindern\ Oldenburg",
"4939348", "Klitsche",
"494743", "Langen\ bei\ Bremerhaven",
"495777", "Diepenau\-Essern",
"498071", "Wasserburg\ am\ Inn",
"4938372", "Usedom",
"4934496", "Nöbdenitz",
"4935263", "Gröditz\ bei\ Riesa",
"4934977", "Quellendorf",
"499942", "Viechtach",
"499665", "Königstein\ Oberpfalz",
"498137", "Petershausen",
"496124", "Bad\ Schwalbach",
"4933702", "Wünsdorf",
"495206", "Bielefeld\-Jöllenbeck",
"495572", "Bodenfelde",
"4936428", "Stadtroda",
"497706", "Oberbaldingen",
"492432", "Wassenberg",
"49209", "Gelsenkirchen",
"499177", "Heideck",
"492273", "Kerpen\-Horrem",
"495428", "Melle\-Neuenkirchen",
"497248", "Marxzell",
"499634", "Wiesau",
"4937296", "Stollberg\ Erzgebirge",
"492981", "Winterberg\ Westfalen",
"4939329", "Möringen",
"497277", "Wörth\-Büchelberg",
"494423", "Fedderwarden",
"493869", "Dümmer",
"4938461", "Bützow",
"499148", "Ettenstatt",
"493476", "Hettstedt\ Sachsen\-Anhalt",
"4939054", "Flechtingen",
"499962", "Schwarzach\ Niederbayern",
"496439", "Holzappel",
"492058", "Wülfrath",
"4936649", "Gefell\ bei\ Schleiz",
"495768", "Petershagen\-Heimsen",
"499936", "Wallerfing",
"499645", "Eschenbach\ in\ der\ Oberpfalz",
"496872", "Losheim\ am\ See",
"494407", "Wardenburg",
"4933733", "Stülpe",
"495471", "Bohmte",
"494763", "Gnarrenburg",
"4935829", "Gersdorf\ bei\ Görlitz",
"4936207", "Plaue\ Thüringen",
"4938334", "Grammendorf",
"494796", "Teufelsmoor",
"492364", "Haltern\ Westfalen",
"495199", "Schneverdingen\-Heber",
"4934901", "Rosslau\ Elbe",
"4934905", "Wörlitz",
"4938325", "Rolofshagen",
"494939", "Baltrum",
"499195", "Adelsdorf\ Mittelfranken",
"4938321", "Martensdorf\ bei\ Stralsund",
"4936024", "Diedorf\ bei\ Mühlhausen",
"498028", "Fischbachau",
"4936628", "Zeulenroda",
"492446", "Heimbach\ Eifel",
"4939458", "Heudeber",
"4935240", "Tauscha\ bei\ Grossenhain",
"49271", "Siegen",
"497268", "Bad\ Rappenau\-Obergimpern",
"497620", "Schopfheim\-Gersbach",
"492335", "Wetter\ Ruhr",
"498756", "Nandlstadt",
"496256", "Lampertheim\-Hüttenfeld",
"497475", "Burladingen",
"499907", "Zenting",
"4939827", "Schwarz\ bei\ Neustrelitz",
"4933087", "Bredereiche",
"496195", "Kelkheim\ Taunus",
"494462", "Wittmund",
"492204", "Bensberg",
"497156", "Ditzingen",
"499288", "Bad\ Steben",
"493327", "Werder\ Havel",
"495435", "Berge\ bei\ Quakenbrück",
"492575", "Greven\-Reckenfeld",
"498191", "Landsberg\ am\ Lech",
"497546", "Oberteuringen",
"499256", "Stammbach",
"495346", "Liebenburg",
"4933398", "Werneuchen",
"4936603", "Weida",
"499439", "Neunburg\-Kemnath",
"496645", "Ulrichstein",
"499872", "Heilsbronn",
"4939382", "Kamern",
"493361", "Fürstenwalde\ Spree",
"494541", "Ratzeburg",
"497308", "Nersingen",
"495858", "Hitzacker\-Wietzetze",
"495508", "Gleichen\-Rittmarshausen",
"4939600", "Zwiedorf",
"499097", "Marxheim",
"498641", "Grassau\ Kreis\ Traunstein",
"495464", "Alfhausen",
"493686", "Eisfeld",
"494853", "Sankt\ Michaelisdonn",
"494885", "Bergenhusen",
"494151", "Schwarzenbek",
"497431", "Albstadt\-Ebingen",
"497130", "Löwenstein\ Württemberg",
"492371", "Iserlohn",
"494503", "Timmendorfer\ Strand",
"4939833", "Mirow\ Kreis\ Neustrelitz",
"496586", "Beuren\ Hochwald",
"498846", "Uffing\ am\ Staffelsee",
"4938758", "Dömitz",
"497566", "Argenbühl",
"495332", "Schöppenstedt",
"498035", "Raubling",
"496558", "Büdesheim\ Eifel",
"497532", "Meersburg",
"493881", "Grevesmühlen",
"495366", "Jembke",
"4936646", "Tanna\ bei\ Schleiz",
"493984", "Prenzlau",
"494527", "Bosau",
"494365", "Heringsdorf\ Holstein",
"495681", "Homberg\ Efze",
"498106", "Vaterstetten",
"496634", "Gemünden\ Felda",
"492597", "Senden\ Westfalen",
"4935826", "Königshain\ bei\ Görlitz",
"494442", "Lohne\ Oldenburg",
"495084", "Hambühren",
"495237", "Augustdorf",
"495724", "Obernkirchen",
"496031", "Friedberg\ Hessen",
"492657", "Uersfeld",
"4939400", "Wefensleben",
"4936784", "Stützerbach",
"493303", "Birkenwerder",
"4935937", "Prischwitz",
"495444", "Wagenfeld",
"497224", "Gernsbach",
"494722", "Cuxhaven\-Altenbruch",
"498661", "Grabenstätt\ Chiemsee",
"49355", "Cottbus",
"4935327", "Priessen",
"498064", "Au\ bei\ Bad\ Aibling",
"499923", "Teisnach",
"496698", "Schrecksbach",
"494334", "Bredenbek\ bei\ Rendsburg",
"493341", "Strausberg",
"4936962", "Vacha",
"496665", "Sinntal\-Altengronau",
"4936741", "Bad\ Blankenburg",
"494561", "Neustadt\ in\ Holstein",
"498386", "Oberstaufen",
"492733", "Hilchenbach",
"499075", "Glött",
"497653", "Lenzkirch",
"497685", "Gutach\-Bleibach",
"499636", "Plössberg",
"494307", "Raisdorf",
"499945", "Arnbruck",
"499662", "Vilseck",
"492508", "Drensteinfurt",
"496339", "Grosssteinhausen",
"4939222", "Möser",
"492858", "Hünxe",
"492464", "Aldenhoven\ bei\ Jülich",
"494202", "Achim\ bei\ Bremen",
"4938484", "Ventschow",
"497704", "Geisingen\ Baden",
"496897", "Sulzbach\ Saar",
"495371", "Gifhorn",
"4939035", "Kuhfelde",
"4939207", "Colbitz",
"497571", "Sigmaringen",
"4939031", "Dähre",
"49611", "Wiesbaden",
"4935243", "Weinböhla",
"496126", "Idstein",
"494187", "Holm\-Seppensen",
"495204", "Steinhagen\ Westfalen",
"494639", "Schafflund",
"493523", "Coswig\ bei\ Dresden",
"4936458", "Bad\ Berka",
"4933841", "Belzig",
"497375", "Obermarchtal",
"492435", "Erkelenz\-Lövenich",
"4933845", "Borkheide",
"492444", "Schleiden\-Gemünd",
"495657", "Meissner",
"4935206", "Kreischa\ bei\ Dresden",
"496254", "Lautertal\ Odenwald",
"498754", "Volkenschwand",
"499965", "Sankt\ Englmar",
"496623", "Rotenburg\ an\ der\ Fulda",
"496875", "Nonnweiler\-Primstal",
"499642", "Kemnath\ Stadt",
"4936252", "Tambach\-Dietharz",
"4933977", "Gumtow",
"4938732", "Gallin\ bei\ Lübz",
"495733", "Vlotho",
"497233", "Niefern\-Öschelbronn",
"495328", "Altenau\ Harz",
"4939428", "Pabstorf",
"492393", "Sundern\-Allendorf",
"497528", "Neukirch\ bei\ Tettnang",
"497839", "Schapbach",
"494794", "Worpswede\-Ostersode",
"492366", "Herten\ Westfalen",
"497472", "Rottenburg\ am\ Neckar",
"492332", "Gevelsberg",
"499133", "Baiersdorf\ Mittelfranken",
"494323", "Bornhöved",
"499831", "Gunzenhausen",
"492681", "Altenkirchen\ Westerwald",
"4938355", "Züssow",
"499192", "Gräfenberg",
"492237", "Kerpen\ Rheinland\-Türnich",
"4938351", "Mesekenhagen",
"492724", "Finnentrop\-Serkenrode",
"494247", "Affinghausen",
"493721", "Meinersdorf",
"495432", "Löningen",
"495466", "Merzen",
"496008", "Echzell",
"492572", "Emsdetten",
"495493", "Neuenkirchen\ Kreis\ Vechta",
"498046", "Bad\ Heilbrunn",
"492428", "Niederzier",
"495273", "Beverungen",
"494342", "Preetz\ Kreis\ Plön",
"496133", "Oppenheim",
"496831", "Saarlouis",
"496192", "Hofheim\ am\ Taunus",
"494498", "Saterland\-Ramsloh",
"493679", "Neuhaus\ am\ Rennweg",
"4939857", "Drense",
"494465", "Friedeburg\ Ostfriesland",
"493562", "Forst\ Lausitz",
"492957", "Wünnenberg\-Haaren",
"497544", "Markdorf",
"494882", "Lunden",
"499254", "Gefrees",
"492777", "Breitscheid\ Hessen",
"495344", "Lengede",
"497773", "Bodman\-Ludwigshafen",
"4939403", "Gröningen\ Sachsen\-Anhalt",
"499875", "Wolframs\-Eschenbach",
"496642", "Schlitz",
"4939745", "Hetzdorf\ bei\ Strasburg",
"497953", "Blaufelden",
"492206", "Overath",
"498458", "Gaimersheim",
"4939741", "Jatznick",
"4935953", "Burkau",
"493441", "Zeitz",
"494434", "Colnrade",
"497154", "Kornwestheim",
"4935209", "Mohorn",
"494362", "Heiligenhafen",
"494336", "Owschlag",
"499607", "Luhe\-Wildenau",
"499126", "Eckental",
"4936761", "Heubisch",
"494445", "Visbek\ Kreis\ Vechta",
"498384", "Röthenbach\ Allgäu",
"493542", "Lübbenau\ Spreewald",
"496650", "Hosenfeld",
"49571", "Minden\ Westfalen",
"498093", "Glonn\ Kreis\ Ebersberg",
"494267", "Lauenbrück",
"4938728", "Domsühl",
"497226", "Bühl\-Sand",
"495446", "Rehden",
"495335", "Schladen",
"498379", "Waltenhofen\-Oberdorf",
"498032", "Rohrdorf\ Kreis\ Rosenheim",
"498066", "Bad\ Feilnbach",
"496636", "Romrod",
"498104", "Sauerlach",
"494221", "Delmenhorst",
"4939603", "Burg\ Stargard",
"495086", "Celle\-Scheuen",
"499339", "Ippesheim",
"495726", "Wiedensahl",
"499072", "Lauingen\ Donau",
"494129", "Haseldorf",
"493461", "Merseburg\ Saale",
"497682", "Elzach",
"49721", "Karlsruhe",
"492291", "Waldbröl",
"496584", "Wellen\ Mosel",
"495531", "Holzminden",
"4935773", "Schleife",
"492471", "Roetgen\ Eifel",
"494725", "Helgoland",
"497331", "Geislingen\ an\ der\ Steige",
"497564", "Bad\ Wurzach",
"495364", "Velpke",
"49911", "Nuremberg",};
my $timezones = {
               '' => [
                       'Europe/Berlin'
                     ]
             };

    sub new {
      my $class = shift;
      my $number = shift;
      $number =~ s/(^\+49|\D)//g;
      my $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, timezones => $timezones, areanames => \%areanames}, $class);
      return $self if ($self->is_valid());
      $number =~ s/^(?:0)//;
      $self = bless({ country_code => '49', number => $number, formatters => $formatters, validators => $validators, areanames => \%areanames}, $class);
      return $self->is_valid() ? $self : undef;
    }
1;