# This Makefile.PL for P9Y-ProcessTable was generated by
# inc::P9YOSDeps <self>
# and Dist::Zilla::Plugin::MakeMaker::Awesome 0.35.
# Don't edit it but the dist.ini and plugins used to construct it.

use strict;
use warnings;

use 5.008008;
use ExtUtils::MakeMaker;

my %WriteMakefileArgs = (
  "ABSTRACT" => "Portably access the process table",
  "AUTHOR" => "Brendan Byrd <BBYRD\@CPAN.org>",
  "CONFIGURE_REQUIRES" => {
    "ExtUtils::MakeMaker" => "6.31"
  },
  "DISTNAME" => "P9Y-ProcessTable",
  "LICENSE" => "artistic_2",
  "MIN_PERL_VERSION" => "5.008008",
  "NAME" => "P9Y::ProcessTable",
  "PREREQ_PM" => {
    &os_deps,
    "List::AllUtils" => 0,
    "Module::Runtime" => "0.002",
    "Moo" => "0.009001",
    "Path::Class" => "0.32",
    "namespace::clean" => 0
  },
  "TEST_REQUIRES" => {
    "Devel::SimpleTrace" => "0.07",
    "ExtUtils::MakeMaker" => "6.31",
    "File::Spec" => "3.16",
    "Test::CheckDeps" => "0.010",
    "Test::More" => "0.94",
    "Test::Most" => "0.01"
  },
  "VERSION" => "1.08",
  "test" => {
    "TESTS" => "t/*.t"
  }
);

my %FallbackPrereqs = (
  "Devel::SimpleTrace" => "0.07",
  "ExtUtils::MakeMaker" => "6.31",
  "File::Spec" => "3.16",
  "List::AllUtils" => 0,
  "Module::Runtime" => "0.002",
  "Moo" => "0.009001",
  "Path::Class" => "0.32",
  "Test::CheckDeps" => "0.010",
  "Test::More" => "0.94",
  "Test::Most" => "0.01",
  "namespace::clean" => 0
);

unless ( eval { ExtUtils::MakeMaker->VERSION(6.63_03) } ) {
  delete $WriteMakefileArgs{TEST_REQUIRES};
  delete $WriteMakefileArgs{BUILD_REQUIRES};
  $WriteMakefileArgs{PREREQ_PM} = \%FallbackPrereqs;
}

delete $WriteMakefileArgs{CONFIGURE_REQUIRES}
  unless eval { ExtUtils::MakeMaker->VERSION(6.52) };

WriteMakefile(%WriteMakefileArgs);

sub os_deps {
   if ( $^O eq 'MSWin32' or $^O eq 'cygwin' ) {
      return (
         'Win32::Process'       => 0,
         'Win32::Process::Info' => 1.020,  # WMI on Cygwin
         'Path::Class'          => 0.32,   # fixes Cygwin path issue
      );
   }
   elsif ( $^O eq 'freebsd' ) {
      return ( 'BSD::Process' => 0 );
   }
   elsif ( $^O eq 'os2' ) {
      return ( 'OS2::Process' => 0 );
   }
   elsif ( $^O eq 'VMS' ) {
      return ( 'VMS::Process' => 0 );
   }
   else {
      # let's hope they have /proc
      if ( -d '/proc' and @{[ glob('/proc/*') ]} ) {
         return ();
      }
      # ...or that Proc::ProcessTable can handle it
      else {
         return ( 'Proc::ProcessTable' => 0.48 );  # ie: the one that ain't broke
      }
   }
   return ();
}
