/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.util.EccUtils;
import com.amazon.aes.webservices.client.ImportVolumeConversionTask;
import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.blockdevicelib.ImageChecker;
import com.amazon.aes.webservices.client.blockdevicelib.ImageVerificationException;
import com.amazon.aes.webservices.client.cmd.GeneralError;
import com.amazon.aes.webservices.client.cmd.InvalidArgument;
import com.amazon.aes.webservices.client.cmd.Uploadable;
import com.amazon.aes.webservices.client.vmconversion.ManifestFactory;
import com.amazon.aes.webservices.client.vmconversion.VerificationException;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.jets3t.service.S3ServiceException;

public class CreateConversionTask
extends Uploadable {
    public static final int MAX_COMMENT_LENGTH = 240;
    public static final long ONE_GIG = 0x40000000L;
    public static final String[] FORMAT_DESC = new String[]{"The file format of the disk image. Refer to the latest Developer's", "Guide for valid values. [REQUIRED]"};
    public static final String[] DESCRIPTION_DESC = new String[]{"An optional, free-form comment that will be returned verbatim during", "subsequent calls to ec2-describe-conversion-tasks.  Maximum length is 240", "characters."};
    public static final String[] OWNER_SAK_DESC_ = new String[]{"AWS Secret Access Key of the owner of BUCKET, used to sign the import", "-manifest URL. This parameter value is not sent to EC2. [REQUIRED]"};
    public static final String[] BUCKET_DESC = new String[]{"S3 destination bucket name for the manifest. [REQUIRED, unless the option", "--manifest-url is specified]"};
    public static final String[] PREFIX_DESC = new String[]{"Prefix for the manifest-file and disk-image file parts within the S3", "bucket. [OPTIONAL]"};
    public static final String[] IMPORT_URL_DESC = new String[]{"Optionally, specify the URL for an existing import-manifest file already", "uploaded to S3 [OPTIONAL]. This option cannot be specified if --bucket", "has been specified."};
    public static final String[] IGNORE_REGION_AFFINITY_DESC = new String[]{"Ignore the verification check to determine that the bucket's S3 region", "matches the EC2 region where the conversion-task is created."};
    public static final String[] BUCKET_ATTRIBUTE_ARGS = new String[]{"bucket", "manifest-url"};
    public static final String[] DONT_VERIFY_FORMAT_DESC = new String[]{"Do not verify the file format.  This is dangerous and may result in a failed", "conversion. USE AT YOUR OWN RISK."};
    public static final String[] NO_UPLOAD_DESC = new String[]{"Do not upload a disk image to S3. To complete the import task, requires", "upload using ec2-resume-import."};
    public static final String DRY_RUN_DESC = "Do not create a import task, only validate the disk image.";
    public static final String[] EXPIRES_DESC = new String[]{"Validity period for the signed S3 URLS that allow EC2 to access the manifest", "Defaults to 30 days. [OPTIONAL]"};
    protected String az;
    protected File image;
    protected String diskImageFormat;
    protected long diskImageSize;
    protected int volumeSize;
    protected String signedManifestUrl;
    protected String description;
    protected String bucket;
    protected String prefix;
    protected boolean verifyRegion;
    protected boolean noUpload;
    protected String imageInfoString;

    public CreateConversionTask(String short_form, String long_form) {
        super(short_form, long_form);
    }

    public CreateConversionTask(String short_form, String[] long_form) {
        super(short_form, long_form);
    }

    protected Options getOptions() {
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"format");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"FORMAT");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(FORMAT_DESC));
        options.addOption(OptionBuilder.create((String)"f"));
        OptionBuilder.withLongOpt((String)"description");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DESCRIPTION");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(DESCRIPTION_DESC));
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"owner-akid");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"OWNERAKID");
        OptionBuilder.withDescription((String)this.joinDescription("AWS Access Key Id of the owner of BUCKET."));
        options.addOption(OptionBuilder.create((String)"o"));
        OptionBuilder.withLongOpt((String)"owner-sak");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"SECRETKEY");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(OWNER_SAK_DESC_));
        options.addOption(OptionBuilder.create((String)"w"));
        OptionBuilder.withLongOpt((String)"bucket");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"BUCKET");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(BUCKET_DESC));
        options.addOption(OptionBuilder.create((String)"b"));
        OptionBuilder.withLongOpt((String)"prefix");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"PREFIX");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(PREFIX_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"manifest-url");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"url");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(IMPORT_URL_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"ignore-region-affinity");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(IGNORE_REGION_AFFINITY_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"expires");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"DAYS");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(EXPIRES_DESC));
        options.addOption(OptionBuilder.create((String)"x"));
        OptionBuilder.withLongOpt((String)"dont-verify-format");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(DONT_VERIFY_FORMAT_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"dry-run");
        OptionBuilder.withDescription((String)this.joinDescription(DRY_RUN_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"no-upload");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(NO_UPLOAD_DESC));
        options.addOption(OptionBuilder.create());
        OptionBuilder.withLongOpt((String)"user-threads");
        OptionBuilder.hasArgs();
        OptionBuilder.withArgName((String)"THREADS");
        OptionBuilder.withDescription((String)CreateConversionTask.joinDescription(USER_THREADS_DESC));
        options.addOption(OptionBuilder.create());
        return options;
    }

    @Override
    protected String getOptionString() {
        return "[SPECIFIC OPTIONS] disk-image";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
    }

    @Override
    public void printDescription() {
        super.printDescription();
    }

    protected void validateAndSetVolumeSize() throws ImageVerificationException {
        if (this.verifyFormat) {
            ImageChecker checker = new ImageChecker(this.image, this.diskImageFormat);
            long actualConvertedSize = checker.getBlockDeviceSize();
            this.volumeSize = (int)Math.ceil((double)actualConvertedSize / 1.073741824E9);
            this.imageInfoString = checker.getImageInfoString();
        } else {
            this.assertOptionSet("volume-size");
        }
        if (this.isOptionSet("volume-size")) {
            try {
                int requestedVolumeSize = Integer.parseInt(this.getOptionValue("volume-size"));
                if (this.verifyFormat && requestedVolumeSize < this.volumeSize) {
                    throw new GeneralError("This file requires minimum of " + this.volumeSize + " GiB EBS volume.");
                }
                this.volumeSize = requestedVolumeSize;
            }
            catch (NumberFormatException e) {
                throw new InvalidArgument("volume-size", this.getOptionValue("volume-size"));
            }
        }
        System.out.println("Requesting volume size: " + this.volumeSize + " GB");
    }

    protected String getEC2BucketLocation() throws GeneralError {
        String region = EccUtils.getRegionFromUrl(this.getURL());
        if (region == null || region.length() < 2) {
            if (this.verifyRegion) {
                throw new GeneralError("Error determining EC2 region");
            }
            return null;
        }
        if (region.toLowerCase().equals("us-east-1")) {
            return null;
        }
        return region;
    }

    protected void createSignedManifestUrl() throws GeneralError, VerificationException {
        try {
            ManifestFactory mf = new ManifestFactory(this.s3Service);
            int expires = this.isOptionSet("expires") ? Integer.parseInt(this.getOptionValue("expires")) : 30;
            String location = this.getEC2BucketLocation();
            this.signedManifestUrl = this.manifestUrl != null ? mf.createSignedManifestUrl(this.image, this.manifestUrl, location, expires, this.verifyRegion) : mf.createSignedManifestUrl(this.image, this.bucket, location, this.prefix, expires, this.verifyRegion);
        }
        catch (S3ServiceException e) {
            throw new GeneralError("ERROR: Unable to create signed manifest URL. " + e.getMessage());
        }
    }

    protected void validateImageAndFormat() {
        try {
            this.image = new File(this.getNonOptions()[0]);
            this.warnIfTooManyNonOptions();
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new GeneralError("Required argument disk-image missing (-h for usage). ");
        }
        if (!this.image.exists()) {
            throw new GeneralError("File " + this.image + " does not exist");
        }
        this.assertOptionSet("format");
        this.diskImageFormat = this.getOptionValue("format").toUpperCase();
    }

    public void getBucketParameters() throws GeneralError {
        this.assertOnlyOneOptionSet(BUCKET_ATTRIBUTE_ARGS);
        if (this.isOptionSet("bucket")) {
            this.bucket = this.getOptionValue("bucket");
            this.prefix = this.isOptionSet("prefix") ? this.getOptionValue("prefix") : null;
            this.manifestUrl = null;
        } else {
            try {
                this.manifestUrl = new URL(this.getOptionValue("manifest-url"));
            }
            catch (MalformedURLException e) {
                throw new GeneralError("The manifest-url " + this.getOptionValue("manifest-url") + " is not well formed");
            }
            this.bucket = null;
            this.prefix = "";
        }
    }

    @Override
    protected void validateParameters() throws GeneralError, VerificationException {
        super.validateParameters();
        this.verifyRegion = !this.isOptionSet("ignore-region-affinity");
        this.validateImageAndFormat();
        try {
            this.validateAndSetVolumeSize();
        }
        catch (ImageVerificationException e) {
            throw new VerificationException(e.getMessage());
        }
        this.getBucketParameters();
        this.description = this.getOptionValue("description");
        if (this.description != null && this.description.length() > 240) {
            throw new InvalidArgument("description", this.description);
        }
        this.dryRun = this.isOptionSet("dry-run");
        this.noUpload = this.isOptionSet("no-upload");
    }

    protected boolean invokeUpload(Jec2 jec2) throws Exception {
        ImportVolumeConversionTask importTask = this.retrieveImportVolumeConversionTask(this.task);
        return this.uploadDisk(importTask, jec2, this.task.getTaskId());
    }
}

