/* Driver template for the LEMON parser generator.
** The author disclaims copyright to this source code.
**
** This version of "lempar.c" is modified, slightly, for use by SQLite.
** The only modifications are the addition of a couple of NEVER()
** macros to disable tests that are needed in the case of a general
** LALR(1) grammar but which are always false in the
** specific grammar used by SQLite.
*/
/* First off, code is included that follows the "include" declaration
** in the input grammar file. */
#include <stdio.h>

#include "token.h"
#include "parsercontext.h"
#include "parser/ast/sqlitealtertable.h"
#include "parser/ast/sqliteanalyze.h"
#include "parser/ast/sqliteattach.h"
#include "parser/ast/sqlitebegintrans.h"
#include "parser/ast/sqlitecommittrans.h"
#include "parser/ast/sqlitecopy.h"
#include "parser/ast/sqlitecreateindex.h"
#include "parser/ast/sqlitecreatetable.h"
#include "parser/ast/sqlitecreatetrigger.h"
#include "parser/ast/sqlitecreateview.h"
#include "parser/ast/sqlitecreatevirtualtable.h"
#include "parser/ast/sqlitedelete.h"
#include "parser/ast/sqlitedetach.h"
#include "parser/ast/sqlitedropindex.h"
#include "parser/ast/sqlitedroptable.h"
#include "parser/ast/sqlitedroptrigger.h"
#include "parser/ast/sqlitedropview.h"
#include "parser/ast/sqliteemptyquery.h"
#include "parser/ast/sqliteinsert.h"
#include "parser/ast/sqlitepragma.h"
#include "parser/ast/sqlitereindex.h"
#include "parser/ast/sqliterelease.h"
#include "parser/ast/sqliterollback.h"
#include "parser/ast/sqlitesavepoint.h"
#include "parser/ast/sqliteselect.h"
#include "parser/ast/sqliteupdate.h"
#include "parser/ast/sqlitevacuum.h"
#include "parser/ast/sqliteexpr.h"
#include "parser/ast/sqlitecolumntype.h"
#include "parser/ast/sqliteconflictalgo.h"
#include "parser/ast/sqlitesortorder.h"
#include "parser/ast/sqliteindexedcolumn.h"
#include "parser/ast/sqliteforeignkey.h"
#include "parser_helper_stubs.h"
#include "common/utils_sql.h"
#include <QObject>
#include <QDebug>

#define assert(X) Q_ASSERT(X)
#define UNUSED_PARAMETER(X) (void)(X)
#define DONT_INHERIT_TOKENS(X) noTokenInheritanceFields << X
/* Next is all token values, in a form suitable for use by makeheaders.
** This section will be null unless lemon is run with the -m switch.
*/
/*
** These constants (all generated automatically by the parser generator)
** specify the various kinds of tokens (terminals) that the parser
** understands.
**
** Each symbol here is a terminal symbol in the grammar.
*/
/* Make sure the INTERFACE macro is defined.
*/
#ifndef INTERFACE
# define INTERFACE 1
#endif
/* The next thing included is series of defines which control
** various aspects of the generated parser.
**    YYCODETYPE         is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 terminals
**                       and nonterminals.  "int" is used otherwise.
**    YYNOCODE           is a number of type YYCODETYPE which corresponds
**                       to no legal terminal or nonterminal number.  This
**                       number is used to fill in empty slots of the hash
**                       table.
**    YYFALLBACK         If defined, this indicates that one or more tokens
**                       have fall-back values which should be used if the
**                       original value of the token will not parse.
**    YYACTIONTYPE       is the data type used for storing terminal
**                       and nonterminal numbers.  "unsigned char" is
**                       used if there are fewer than 250 rules and
**                       states combined.  "int" is used otherwise.
**    sqlite2_parseTOKENTYPE     is the data type used for minor tokens given
**                       directly to the parser from the tokenizer.
**    YYMINORTYPE        is the data type used for all minor tokens.
**                       This is typically a union of many types, one of
**                       which is sqlite2_parseTOKENTYPE.  The entry in the union
**                       for base tokens is called "yy0".
**    YYSTACKDEPTH       is the maximum depth of the parser's stack.  If
**                       zero the stack is dynamically sized using realloc()
**    sqlite2_parseARG_SDECL     A static variable declaration for the %extra_argument
**    sqlite2_parseARG_PDECL     A parameter declaration for the %extra_argument
**    sqlite2_parseARG_STORE     Code to store %extra_argument into yypParser
**    sqlite2_parseARG_FETCH     Code to extract %extra_argument from yypParser
**    YYNSTATE           the combined number of states.
**    YYNRULE            the number of rules in the grammar
**    YYERRORSYMBOL      is the code number of the error symbol.  If not
**                       defined, then do no error processing.
*/
#define YYCODETYPE unsigned char
#define YYNOCODE 241
#define YYACTIONTYPE unsigned short int
#define sqlite2_parseTOKENTYPE Token*
typedef union {
  int yyinit;
  sqlite2_parseTOKENTYPE yy0;
  ParserCreateTableConstraintList* yy13;
  SqliteSelect::Core::JoinSource* yy31;
  ParserStubAlias* yy40;
  SqliteExpr::LikeOp* yy41;
  ParserCreateTableColumnList* yy42;
  SqliteColumnType* yy57;
  ParserIndexedColumnList* yy63;
  QVariant* yy69;
  SqliteCreateTrigger::Scope* yy83;
  ParserStubExplain* yy91;
  ParserFullName* yy120;
  SqliteSelect::Core::SingleSource* yy121;
  ParserOtherSourceList* yy131;
  SqliteCreateTable::Column* yy147;
  SqliteSelect::Core* yy150;
  SqliteCreateTrigger::Event* yy151;
  SqliteSelect* yy153;
  SqliteForeignKey::Condition* yy187;
  SqliteExpr* yy192;
  ParserSetValueList* yy201;
  SqliteQuery* yy203;
  ParserStringList* yy207;
  ParserResultColumnList* yy213;
  SqliteSelect::Core::JoinOp* yy221;
  int* yy226;
  ParserExprList* yy231;
  ParserOrderByList* yy243;
  ParserFkConditionList* yy264;
  ParserQueryList* yy270;
  bool* yy291;
  SqliteCreateTable::Column::Constraint* yy304;
  SqliteInitially* yy312;
  QString* yy319;
  SqliteLimit* yy324;
  ParserDeferSubClause* yy329;
  ParserStubInsertOrReplace* yy344;
  ParserCreateTableColumnConstraintList* yy371;
  SqliteCreateTrigger::Time* yy372;
  SqliteSelect::CompoundOperator* yy382;
  SqliteSortOrder* yy389;
  ParserStubTransDetails* yy404;
  SqliteCreateTable::Constraint* yy406;
  SqliteConflictAlgo* yy418;
  SqliteForeignKey::Condition::Reaction* yy424;
  SqliteIndexedColumn* yy428;
  SqliteSelect::Core::JoinConstraint* yy455;
} YYMINORTYPE;
#ifndef YYSTACKDEPTH
#define YYSTACKDEPTH 100
#endif
#define sqlite2_parseARG_SDECL ParserContext* parserContext;
#define sqlite2_parseARG_PDECL ,ParserContext* parserContext
#define sqlite2_parseARG_FETCH ParserContext* parserContext = yypParser->parserContext
#define sqlite2_parseARG_STORE yypParser->parserContext = parserContext
#define YYNSTATE 584
#define YYNRULE 352
#define YYFALLBACK 1
#define YY_NO_ACTION      (YYNSTATE+YYNRULE+2)
#define YY_ACCEPT_ACTION  (YYNSTATE+YYNRULE+1)
#define YY_ERROR_ACTION   (YYNSTATE+YYNRULE)

#define GET_CONTEXT yyParser* yypParser = pParser; sqlite2_parseARG_FETCH

/* The yyzerominor constant is used to initialize instances of
** YYMINORTYPE objects to zero. */
static const YYMINORTYPE yyzerominor = { 0 };

/* Define the yytestcase() macro to be a no-op if is not already defined
** otherwise.
**
** Applications can choose to define yytestcase() in the %include section
** to a macro that can assist in verifying code coverage.  For production
** code the yytestcase() macro should be turned off.  But it is useful
** for testing.
*/
#ifndef yytestcase
# define yytestcase(X)
#endif


/* Next are the tables used to determine what action to take based on the
** current state and lookahead token.  These tables are used to implement
** functions that take a state number and lookahead value and return an
** action integer.
**
** Suppose the action integer is N.  Then the action is determined as
** follows
**
**   0 <= N < YYNSTATE                  Shift N.  That is, push the lookahead
**                                      token onto the stack and goto state N.
**
**   YYNSTATE <= N < YYNSTATE+YYNRULE   Reduce by rule N-YYNSTATE.
**
**   N == YYNSTATE+YYNRULE              A syntax error has occurred.
**
**   N == YYNSTATE+YYNRULE+1            The parser accepts its input.
**
**   N == YYNSTATE+YYNRULE+2            No such action.  Denotes unused
**                                      slots in the yy_action[] table.
**
** The action table is constructed as a single large table named yy_action[].
** Given state S and lookahead X, the action is computed as
**
**      yy_action[ yy_shift_ofst[S] + X ]
**
** If the index value yy_shift_ofst[S]+X is out of range or if the value
** yy_lookahead[yy_shift_ofst[S]+X] is not equal to X or if yy_shift_ofst[S]
** is equal to YY_SHIFT_USE_DFLT, it means that the action is not in the table
** and that yy_default[S] should be used instead.
**
** The formula above is for computing the action when the lookahead is
** a terminal symbol.  If the lookahead is a non-terminal (as occurs after
** a reduce action) then the yy_reduce_ofst[] array is used in place of
** the yy_shift_ofst[] array and YY_REDUCE_USE_DFLT is used in place of
** YY_SHIFT_USE_DFLT.
**
** The following are the tables generated in this section:
**
**  yy_action[]        A single table containing all actions.
**  yy_lookahead[]     A table containing the lookahead for each entry in
**                     yy_action.  Used to detect hash collisions.
**  yy_shift_ofst[]    For each state, the offset into yy_action for
**                     shifting terminals.
**  yy_reduce_ofst[]   For each state, the offset into yy_action for
**                     shifting non-terminals after a reduce.
**  yy_default[]       Default action for each state.
*/
#define YY_ACTTAB_COUNT (1737)
static const YYACTIONTYPE yy_action[] = {
 /*     0 */   338,  191,  186,  242,  476,  511,  576,  193,  332,   16,
 /*    10 */   511,  384,  189,  322,  239,  519,  518,  570,  337,  450,
 /*    20 */    15,  851,  125,   58,  575,  179,  851,  574,   63,  143,
 /*    30 */   401,  581,  328,   26,   84,  569,  114,  322,  573,  519,
 /*    40 */   518,  851,  851,   35,  851,  851,  851,  851,  851,  851,
 /*    50 */   851,  851,  851,  851,  851,  851,  851,  851,  851,   32,
 /*    60 */    33,  851,  851,  851,  851,  320,  379,   34,  240,  238,
 /*    70 */   121,  556,  291,  251,   57,    7,  217,  577,  265,  264,
 /*    80 */   523,  179,  555,  336,  335,  338,  569,  549,  548,  550,
 /*    90 */   271,  569,   10,  724,  199,  297,  203,  489,  459,  332,
 /*   100 */   568,  567,  451,  253,  158,  523,  449,  444,  443,  337,
 /*   110 */   187,  870,  266,  187,  580,  517,  168,  328,  505,  343,
 /*   120 */   143,  235,  490,  108,  101,  489,  523,  164,   35,  531,
 /*   130 */   187,   13,  523,  252,  234,  547,  236,  119,  340,  232,
 /*   140 */   339,  120,  216,  155,   32,   33,  481,  547,  322,  215,
 /*   150 */   519,  518,   34,  714,  456,  477,  320,  367,  547,  478,
 /*   160 */     7,  714,  400,  321,  251,  523,  714,  563,  336,  335,
 /*   170 */   500,  553,  549,  548,  550,  188,  465,  500,  401,  466,
 /*   180 */   366,  365,  552,  364,  293,  435,   39,   39,   39,   38,
 /*   190 */   523,  562,   60,  255,  714,  569,  714,  714,  852,  570,
 /*   200 */   271,  714,  502,  852,  500,  714,  570,  714,  714,  714,
 /*   210 */   714,  523,  569,  178,  531,  422,   13,  523,   44,   45,
 /*   220 */   330,   42,   42,  530,  530,  223,  852,  852,   43,   43,
 /*   230 */    43,   43,   41,   41,   41,   41,   40,   40,   39,   39,
 /*   240 */    39,   38,  199,  297,  203,   55,  236,   92,  340,  232,
 /*   250 */   339,  120,  216,  500,  106,  570,  268,   19,  187,  215,
 /*   260 */   500,  105,  553,   41,   41,   41,   41,   40,   40,   39,
 /*   270 */    39,   39,   38,  552,   40,   40,   39,   39,   39,   38,
 /*   280 */   852,    3,  568,  567,  187,  852,  512,  500,  219,  568,
 /*   290 */   567,   17,  496,  156,  322,  345,  519,  518,  569,  292,
 /*   300 */    44,   45,  330,   42,   42,  530,  530,  223,  852,  852,
 /*   310 */    43,   43,   43,   43,   41,   41,   41,   41,   40,   40,
 /*   320 */    39,   39,   39,   38,  547,  533,  852,  100,  308,  306,
 /*   330 */   305,  852,  448,  447,  418,  418,  316,  245,  568,  567,
 /*   340 */   304,  937,  122,  344,    1,  582,   44,   45,  330,   42,
 /*   350 */    42,  530,  530,  223,  852,  852,   43,   43,   43,   43,
 /*   360 */    41,   41,   41,   41,   40,   40,   39,   39,   39,   38,
 /*   370 */   338,  442,   44,   45,  330,   42,   42,  530,  530,  223,
 /*   380 */   524,  569,   43,   43,   43,   43,   41,   41,   41,   41,
 /*   390 */    40,   40,   39,   39,   39,   38,    5,    9,  524,  781,
 /*   400 */   220,  324,  328,  167,   44,   45,  330,   42,   42,  530,
 /*   410 */   530,  223,  781,   35,   43,   43,   43,   43,   41,   41,
 /*   420 */    41,   41,   40,   40,   39,   39,   39,   38,    8,   32,
 /*   430 */    33,  274,  387,  435,  547,  388,  237,   34,  774,  421,
 /*   440 */    60,   14,  219,  569,  250,    7,  774,  437,  441,  169,
 /*   450 */   523,  524,  569,  336,  335,  285,  781,  549,  548,  550,
 /*   460 */    43,   43,   43,   43,   41,   41,   41,   41,   40,   40,
 /*   470 */    39,   39,   39,   38,  332,  523,  332,  425,  470,  774,
 /*   480 */   560,  774,  774,  850,  337,  426,  337,  455,  850,  613,
 /*   490 */   774,  181,  774,  774,  774,  143,  523,  143,   30,  531,
 /*   500 */   614,   13,  523,  850,  850,  850,  850,  850,  850,  850,
 /*   510 */   850,  850,  850,  850,  850,  850,  850,  850,  850,  850,
 /*   520 */   850,  850,  850,  850,  850,  850,  850,  852,  500,  460,
 /*   530 */   357,  320,  852,  318,   75,  570,  401,  570,  311,  251,
 /*   540 */   569,  251,  446,  445,  570,  358,  359,   44,   45,  330,
 /*   550 */    42,   42,  530,  530,  223,  852,  852,   43,   43,   43,
 /*   560 */    43,   41,   41,   41,   41,   40,   40,   39,   39,   39,
 /*   570 */    38,  338,   44,   45,  330,   42,   42,  530,  530,  223,
 /*   580 */   615,  570,   43,   43,   43,   43,   41,   41,   41,   41,
 /*   590 */    40,   40,   39,   39,   39,   38,  185,  184,  497,  782,
 /*   600 */   199,  297,  203,  328,  360,  538,   96,  488,   97,  570,
 /*   610 */   103,  500,  782,  436,   35,  570,  187,  225,  568,  567,
 /*   620 */   568,  567,  332,  354,  540,  539,  294,  568,  567,  570,
 /*   630 */    32,   33,  337,  356,  482,  355,  569,   85,   34,  759,
 /*   640 */   532,  111,   70,   78,  487,  483,    7,  759,   90,  494,
 /*   650 */   508,  523,  493,  160,  336,  335,  782,  528,  549,  548,
 /*   660 */   550,  532,  440,  434,  568,  567,  118,   54,  332,  919,
 /*   670 */   214,  100,  308,  306,  305,   75,  523,  333,  337,  571,
 /*   680 */   759,  529,  759,  759,  304,   48,  177,  522,   31,  143,
 /*   690 */    29,  759,  568,  567,  759,  759,  159,  523,  568,  567,
 /*   700 */   531,  464,   13,  523,   44,   45,  330,   42,   42,  530,
 /*   710 */   530,  223,  568,  567,   43,   43,   43,   43,   41,   41,
 /*   720 */    41,   41,   40,   40,   39,   39,   39,   38,  463,  570,
 /*   730 */   498,  919,  570,  323,  514,  570,  222,   44,   45,  330,
 /*   740 */    42,   42,  530,  530,  223,  393,  392,   43,   43,   43,
 /*   750 */    43,   41,   41,   41,   41,   40,   40,   39,   39,   39,
 /*   760 */    38,   44,   45,  330,   42,   42,  530,  530,  223,  540,
 /*   770 */   539,   43,   43,   43,   43,   41,   41,   41,   41,   40,
 /*   780 */    40,   39,   39,   39,   38,  583,    1,   44,   45,  330,
 /*   790 */    42,   42,  530,  530,  223,  267,  475,   43,   43,   43,
 /*   800 */    43,   41,   41,   41,   41,   40,   40,   39,   39,   39,
 /*   810 */    38,  256,  568,  567,  420,  568,  567,  163,  568,  567,
 /*   820 */   110,  570,  218,   44,   45,  330,   42,   42,  530,  530,
 /*   830 */   223,   27,  468,   43,   43,   43,   43,   41,   41,   41,
 /*   840 */    41,   40,   40,   39,   39,   39,   38,  486,  547,   44,
 /*   850 */    45,  330,   42,   42,  530,  530,  223,  859,  212,   43,
 /*   860 */    43,   43,   43,   41,   41,   41,   41,   40,   40,   39,
 /*   870 */    39,   39,   38,   44,   47,  330,   42,   42,  530,  530,
 /*   880 */   223,  535,  284,   43,   43,   43,   43,   41,   41,   41,
 /*   890 */    41,   40,   40,   39,   39,   39,   38,   45,  330,   42,
 /*   900 */    42,  530,  530,  223,  568,  567,   43,   43,   43,   43,
 /*   910 */    41,   41,   41,   41,   40,   40,   39,   39,   39,   38,
 /*   920 */   330,   42,   42,  530,  530,  223,  338,  160,   43,   43,
 /*   930 */    43,   43,   41,   41,   41,   41,   40,   40,   39,   39,
 /*   940 */    39,   38,  164,  570,  527,  338,  332,  269,  544,  543,
 /*   950 */   526,  162,  561,   79,  452,   64,  337,   88,  328,  455,
 /*   960 */   570,  209,  385,  272,  205,  357,  204,  139,  525,   35,
 /*   970 */   520,  569,  395,  547,  569,  569,   23,  328,  213,  254,
 /*   980 */   358,  275,  547,   75,  182,   32,   33,  310,   35,  569,
 /*   990 */   361,   66,  164,   34,  160,  396,  398,  317,  397,  293,
 /*  1000 */   570,    7,  862,  516,   32,   33,  523,  570,  538,  336,
 /*  1010 */   335,  522,   34,  549,  548,  550,   25,    4,  289,  338,
 /*  1020 */     7,  471,  395,  547,   12,  523,  568,  567,  336,  335,
 /*  1030 */   302,  523,  549,  548,  550,   75,  570,  404,  338,  276,
 /*  1040 */   538,  104,  108,  568,  567,  396,  398,   76,  397,  293,
 /*  1050 */   523,  328,  523,  570,   65,  531,  500,   13,  523,  101,
 /*  1060 */   185,  184,   35,  570,  172,  171,  170,  197,  290,  503,
 /*  1070 */   328,  523,   75,  570,  531,  301,   13,  523,   32,   33,
 /*  1080 */   380,   35,   10,  568,  567,  479,   34,  489,  540,  539,
 /*  1090 */   568,  567,  570,  325,    7,  211,  666,   32,   33,  523,
 /*  1100 */   179,  423,  336,  335,  570,   34,  549,  548,  550,   80,
 /*  1110 */   569,  570,  490,    7,  480,  489,  391,  570,  523,  568,
 /*  1120 */   567,  336,  335,  338,  523,  549,  548,  550,  255,  497,
 /*  1130 */   570,  262,  584,  106,  215,  484,  568,  567,  380,  500,
 /*  1140 */   312,  391,  202,  523,  296,  523,  568,  567,  531,  198,
 /*  1150 */    13,  523,  569,  413,  345,  328,  568,  567,  532,  569,
 /*  1160 */   474,  570,  307,  570,  523,  495,   35,  531,   53,   13,
 /*  1170 */   523,  496,  860,  456,  473,  568,  567,  570,  413,  532,
 /*  1180 */   570,  485,   32,   33,  407,  439,   10,  568,  567,  500,
 /*  1190 */    34,  489,  730,  570,  568,  567,  431,  403,    7,   52,
 /*  1200 */   568,  567,  570,  523,  582,  234,  336,  335,  338,  407,
 /*  1210 */   549,  548,  550,  568,  567,   18,  490,  570,  303,  489,
 /*  1220 */   497,  570,  403,  389,  390,  287,  570,  502,  523,  730,
 /*  1230 */   730,  570,  201,  570,  200,  424,  187,  569,  332,   51,
 /*  1240 */   328,  376,  569,  371,  568,  567,  568,  567,  337,  523,
 /*  1250 */    99,   35,  531,  124,   13,  523,  492,  368,  497,  148,
 /*  1260 */   568,  567,  570,  568,  567,   82,  376,   32,   33,  350,
 /*  1270 */     2,  570,  568,  567,  570,   34,  568,  567,  570,   73,
 /*  1280 */   179,  259,  570,    7,  862,  568,  567,  417,  523,  338,
 /*  1290 */   569,  336,  335,   22,  491,  549,  548,  550,  416,   69,
 /*  1300 */   568,  567,  371,  522,  568,  567,  570,  415,  405,  568,
 /*  1310 */   567,  261,   21,  523,  568,  567,  568,  567,  196,  368,
 /*  1320 */   378,  328,  411,   67,  542,  544,  543,    6,  569,  350,
 /*  1330 */   258,  406,   35,  502,  523,  399,  377,  531,  394,   13,
 /*  1340 */   523,   71,  338,  569,  108,  568,  567,  409,   32,   33,
 /*  1350 */   536,  544,  543,  456,  568,  567,   34,  568,  567,   81,
 /*  1360 */   386,  568,  567,   50,    7,  568,  567,  570,  281,  523,
 /*  1370 */   374,  383,  336,  335,  328,  115,  549,  548,  550,  263,
 /*  1380 */   544,  543,  309,  544,  543,  538,  219,  286,  179,  568,
 /*  1390 */   567,  381,  278,  179,  523,  195,  569,  372,  569,  277,
 /*  1400 */   363,   32,   33,  569,  501,  569,  351,   49,  457,   34,
 /*  1410 */   373,  538,  353,  102,  352,  523,  370,    7,  531,  260,
 /*  1420 */    13,  523,  523,  569,  257,  336,  335,  174,  332,  549,
 /*  1430 */   548,  550,  408,  160,  507,  245,  579,  157,  337,  570,
 /*  1440 */   538,  241,  332,  538,  332,  515,  332,  523,  332,   77,
 /*  1450 */   568,  567,  337,  342,  337,  569,  337,  112,  337,  180,
 /*  1460 */   332,  456,  332,  147,   11,  145,  456,  151,  523,  150,
 /*  1470 */   337,  531,  337,   13,  523,  194,  332,  369,  332,  332,
 /*  1480 */    74,  152,  332,  161,  566,  569,  337,  565,  337,  337,
 /*  1490 */   564,  332,  337,  522,  559,  557,  332,  224,  558,  249,
 /*  1500 */   144,  337,  341,  149,  270,  332,  337,  522,  332,  522,
 /*  1510 */   332,  522,  146,  522,  332,  337,  554,  248,  337,  551,
 /*  1520 */   337,  434,  568,  567,  337,  522,  247,  522,  332,  246,
 /*  1530 */   332,  141,  187,  546,  229,  133,  332,   17,  337,  319,
 /*  1540 */   337,  522,  332,  522,  522,  332,  337,  522,  228,  132,
 /*  1550 */   332,  140,  337,  334,  192,  337,  522,  131,  227,  332,
 /*  1560 */   337,  522,  279,  142,  569,   24,  130,  332,  332,  337,
 /*  1570 */   522,  129,  569,  522,  362,  522,  332,  337,  337,  522,
 /*  1580 */   127,  332,  332,  226,  569,   46,  337,   59,  135,  134,
 /*  1590 */   220,  337,  337,  522,  545,  522,  346,  136,   38,  332,
 /*  1600 */    36,  522,  138,  137,  314,  521,  569,  522,  572,  337,
 /*  1610 */   522,  534,  326,  504,  337,  522,  183,  499,  569,  315,
 /*  1620 */   128,  569,  569,  569,  522,   61,  469,  569,  432,  569,
 /*  1630 */   210,   28,  522,  522,  300,  166,  569,  513,  569,  295,
 /*  1640 */   569,  522,  375,  331,  569,  569,  522,  522,  221,  569,
 /*  1650 */   208,  109,  569,  569,  510,  570,  176,   83,  569,  107,
 /*  1660 */   569,  472,  244,   56,  522,  454,  569,  430,  453,  522,
 /*  1670 */   429,  428,  427,  243,  419,   98,  207,   95,  206,  288,
 /*  1680 */   298,   20,   94,  153,   93,   91,  414,   68,  123,   72,
 /*  1690 */   283,  402,  382,  117,   89,   87,   86,  116,  175,  280,
 /*  1700 */   347,  349,  173,  233,  113,  126,  230,  509,  541,  470,
 /*  1710 */   506,  537,  458,  282,  154,  410,  273,  190,  348,  438,
 /*  1720 */   467,  462,  329,  461,  578,  231,   62,  938,   37,  412,
 /*  1730 */   165,  433,  938,  938,  938,  327,  299,
};
static const YYCODETYPE yy_lookahead[] = {
 /*     0 */     4,    8,  195,   10,   80,   25,    5,   14,  156,  202,
 /*    10 */    30,   41,   19,  113,   21,  115,  116,    4,  166,    4,
 /*    20 */    79,   25,   81,   34,   23,  156,   30,   26,   35,  177,
 /*    30 */    37,   72,   36,   53,   54,  166,   43,  113,   37,  115,
 /*    40 */   116,   45,   46,   47,   48,   49,   50,   51,   52,   53,
 /*    50 */    54,   55,   56,   57,   58,   59,   60,   61,   62,   63,
 /*    60 */    64,   65,   66,   67,   68,  213,   96,   71,   75,   76,
 /*    70 */    77,   16,  220,  221,   85,   79,  156,   76,   63,   64,
 /*    80 */    84,  156,   27,   87,   88,    4,  166,   91,   92,   93,
 /*    90 */    47,  166,   79,   80,  101,  102,  103,   84,  229,  156,
 /*   100 */    87,   88,   87,  110,  161,  109,   91,   92,   93,  166,
 /*   110 */   117,  141,  187,  117,  148,   80,  161,   36,   80,  153,
 /*   120 */   177,   93,  109,   85,   31,  112,  130,  161,   47,  133,
 /*   130 */   117,  135,  136,   90,  106,  192,   93,   94,   95,   96,
 /*   140 */    97,   98,   99,   13,   63,   64,   65,  192,  113,  106,
 /*   150 */   115,  116,   71,   72,  229,  114,  213,  191,  192,  118,
 /*   160 */    79,   80,   21,  220,  221,   84,   85,   80,   87,   88,
 /*   170 */     4,    7,   91,   92,   93,   32,   90,    4,   37,   93,
 /*   180 */   214,  215,   18,  217,  218,  156,   65,   66,   67,   68,
 /*   190 */   109,  162,  163,  100,  113,  166,  115,  116,   25,    4,
 /*   200 */    47,  120,  156,   30,    4,  124,    4,  126,  127,  128,
 /*   210 */   129,  130,  166,  184,  133,  186,  135,  136,   45,   46,
 /*   220 */    47,   48,   49,   50,   51,   52,   53,   54,   55,   56,
 /*   230 */    57,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   240 */    67,   68,  101,  102,  103,   79,   93,   85,   95,   96,
 /*   250 */    97,   98,   99,   87,   81,    4,  210,   79,  117,  106,
 /*   260 */    87,   80,    7,   59,   60,   61,   62,   63,   64,   65,
 /*   270 */    66,   67,   68,   18,   63,   64,   65,   66,   67,   68,
 /*   280 */    25,   79,   87,   88,  117,   30,   84,   87,  156,   87,
 /*   290 */    88,  129,  119,  161,  113,   22,  115,  116,  166,  132,
 /*   300 */    45,   46,   47,   48,   49,   50,   51,   52,   53,   54,
 /*   310 */    55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   320 */    65,   66,   67,   68,  192,  130,   25,   94,   95,   96,
 /*   330 */    97,   30,   91,   92,   83,   84,  204,  205,   87,   88,
 /*   340 */   107,  149,  150,  151,  152,   72,   45,   46,   47,   48,
 /*   350 */    49,   50,   51,   52,   53,   54,   55,   56,   57,   58,
 /*   360 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   370 */     4,  156,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   380 */     5,  166,   55,   56,   57,   58,   59,   60,   61,   62,
 /*   390 */    63,   64,   65,   66,   67,   68,   79,   48,   23,   72,
 /*   400 */    99,   26,   36,  161,   45,   46,   47,   48,   49,   50,
 /*   410 */    51,   52,   85,   47,   55,   56,   57,   58,   59,   60,
 /*   420 */    61,   62,   63,   64,   65,   66,   67,   68,   79,   63,
 /*   430 */    64,   82,    6,  156,  192,    9,  159,   71,   72,  162,
 /*   440 */   163,  125,  156,  166,  164,   79,   80,  167,  168,  169,
 /*   450 */    84,   76,  166,   87,   88,   29,  129,   91,   92,   93,
 /*   460 */    55,   56,   57,   58,   59,   60,   61,   62,   63,   64,
 /*   470 */    65,   66,   67,   68,  156,  109,  156,  180,  181,  113,
 /*   480 */   173,  115,  116,   25,  166,  188,  166,  180,   30,   82,
 /*   490 */   124,  205,  126,  127,  128,  177,  130,  177,  139,  133,
 /*   500 */    82,  135,  136,   45,   46,   47,   48,   49,   50,   51,
 /*   510 */    52,   53,   54,   55,   56,   57,   58,   59,   60,   61,
 /*   520 */    62,   63,   64,   65,   66,   67,   68,   25,    4,   80,
 /*   530 */   156,  213,   30,  213,   85,    4,   37,    4,  220,  221,
 /*   540 */   166,  221,   91,   92,    4,  171,  172,   45,   46,   47,
 /*   550 */    48,   49,   50,   51,   52,   53,   54,   55,   56,   57,
 /*   560 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   570 */    68,    4,   45,   46,   47,   48,   49,   50,   51,   52,
 /*   580 */    82,    4,   55,   56,   57,   58,   59,   60,   61,   62,
 /*   590 */    63,   64,   65,   66,   67,   68,   63,   64,  167,   72,
 /*   600 */   101,  102,  103,   36,  230,  231,   42,   85,   44,    4,
 /*   610 */    88,   87,   85,   89,   47,    4,  117,   85,   87,   88,
 /*   620 */    87,   88,  156,   90,   91,   92,  156,   87,   88,    4,
 /*   630 */    63,   64,  166,  100,  203,  102,  166,   82,   71,   72,
 /*   640 */   109,   82,   78,  177,  122,  123,   79,   80,   82,  109,
 /*   650 */    85,   84,  112,  222,   87,   88,  129,   21,   91,   92,
 /*   660 */    93,  130,   80,   86,   87,   88,  100,   85,  156,   10,
 /*   670 */    80,   94,   95,   96,   97,   85,  109,  211,  166,   74,
 /*   680 */   113,   93,  115,  116,  107,  120,  216,  221,  138,  177,
 /*   690 */   140,  124,   87,   88,  127,  128,   79,  130,   87,   88,
 /*   700 */   133,   11,  135,  136,   45,   46,   47,   48,   49,   50,
 /*   710 */    51,   52,   87,   88,   55,   56,   57,   58,   59,   60,
 /*   720 */    61,   62,   63,   64,   65,   66,   67,   68,   38,    4,
 /*   730 */   119,   72,    4,  221,  109,    4,  224,   45,   46,   47,
 /*   740 */    48,   49,   50,   51,   52,   39,   40,   55,   56,   57,
 /*   750 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   760 */    68,   45,   46,   47,   48,   49,   50,   51,   52,   91,
 /*   770 */    92,   55,   56,   57,   58,   59,   60,   61,   62,   63,
 /*   780 */    64,   65,   66,   67,   68,  151,  152,   45,   46,   47,
 /*   790 */    48,   49,   50,   51,   52,  105,   80,   55,   56,   57,
 /*   800 */    58,   59,   60,   61,   62,   63,   64,   65,   66,   67,
 /*   810 */    68,  157,   87,   88,   83,   87,   88,  161,   87,   88,
 /*   820 */    85,    4,   80,   45,   46,   47,   48,   49,   50,   51,
 /*   830 */    52,  139,  104,   55,   56,   57,   58,   59,   60,   61,
 /*   840 */    62,   63,   64,   65,   66,   67,   68,  122,  192,   45,
 /*   850 */    46,   47,   48,   49,   50,   51,   52,  138,   80,   55,
 /*   860 */    56,   57,   58,   59,   60,   61,   62,   63,   64,   65,
 /*   870 */    66,   67,   68,   45,   46,   47,   48,   49,   50,   51,
 /*   880 */    52,  176,  228,   55,   56,   57,   58,   59,   60,   61,
 /*   890 */    62,   63,   64,   65,   66,   67,   68,   46,   47,   48,
 /*   900 */    49,   50,   51,   52,   87,   88,   55,   56,   57,   58,
 /*   910 */    59,   60,   61,   62,   63,   64,   65,   66,   67,   68,
 /*   920 */    47,   48,   49,   50,   51,   52,    4,  222,   55,   56,
 /*   930 */    57,   58,   59,   60,   61,   62,   63,   64,   65,   66,
 /*   940 */    67,   68,  161,    4,   80,    4,  156,  170,  171,  172,
 /*   950 */    80,  161,  173,  174,  175,   42,  166,   44,   36,  180,
 /*   960 */     4,  156,  145,  158,  156,  156,  158,  177,   80,   47,
 /*   970 */   114,  166,  191,  192,  166,  166,  100,   36,   80,  156,
 /*   980 */   171,  172,  192,   85,  212,   63,   64,   65,   47,  166,
 /*   990 */   167,   78,  161,   71,  222,  214,  215,  121,  217,  218,
 /*  1000 */     4,   79,   80,   80,   63,   64,   84,    4,  231,   87,
 /*  1010 */    88,  221,   71,   91,   92,   93,   85,  236,  237,    4,
 /*  1020 */    79,   80,  191,  192,  125,   84,   87,   88,   87,   88,
 /*  1030 */    80,  109,   91,   92,   93,   85,    4,   80,    4,  230,
 /*  1040 */   231,   80,   85,   87,   88,  214,  215,   79,  217,  218,
 /*  1050 */   109,   36,  130,    4,  141,  133,    4,  135,  136,   31,
 /*  1060 */    63,   64,   47,    4,  101,  102,  103,   80,  237,  130,
 /*  1070 */    36,  130,   85,    4,  133,   47,  135,  136,   63,   64,
 /*  1080 */    84,   47,   79,   87,   88,   65,   71,   84,   91,   92,
 /*  1090 */    87,   88,    4,  137,   79,   80,   80,   63,   64,   84,
 /*  1100 */   156,   85,   87,   88,    4,   71,   91,   92,   93,   82,
 /*  1110 */   166,    4,  109,   79,   65,  112,   84,    4,   84,   87,
 /*  1120 */    88,   87,   88,    4,  109,   91,   92,   93,  100,  167,
 /*  1130 */     4,  187,    0,   81,  106,  122,   87,   88,  142,   87,
 /*  1140 */    82,  109,  156,  109,  158,  130,   87,   88,  133,  156,
 /*  1150 */   135,  136,  166,   84,   22,   36,   87,   88,  109,  166,
 /*  1160 */    80,    4,   32,    4,  130,  203,   47,  133,   79,  135,
 /*  1170 */   136,  119,  138,  229,   80,   87,   88,    4,  109,  130,
 /*  1180 */     4,  122,   63,   64,   84,   80,   79,   87,   88,    4,
 /*  1190 */    71,   84,   85,    4,   87,   88,  108,   84,   79,   79,
 /*  1200 */    87,   88,    4,   84,   72,  106,   87,   88,    4,  109,
 /*  1210 */    91,   92,   93,   87,   88,   79,  109,    4,   32,  112,
 /*  1220 */   167,    4,  109,  101,  102,  103,    4,  156,  109,  122,
 /*  1230 */   123,    4,  156,    4,  158,  109,  117,  166,  156,   79,
 /*  1240 */    36,   84,  166,   84,   87,   88,   87,   88,  166,  130,
 /*  1250 */    98,   47,  133,   81,  135,  136,  203,   84,  167,  177,
 /*  1260 */    87,   88,    4,   87,   88,  100,  109,   63,   64,   84,
 /*  1270 */    10,    4,   87,   88,    4,   71,   87,   88,    4,  105,
 /*  1280 */   156,  210,    4,   79,   80,   87,   88,  111,   84,    4,
 /*  1290 */   166,   87,   88,   48,  203,   91,   92,   93,  109,  120,
 /*  1300 */    87,   88,  143,  221,   87,   88,    4,  109,   80,   87,
 /*  1310 */    88,  187,   48,  109,   87,   88,   87,   88,  156,  146,
 /*  1320 */   158,   36,  109,  131,  170,  171,  172,   79,  166,  144,
 /*  1330 */    20,  109,   47,  156,  130,   72,  109,  133,   72,  135,
 /*  1340 */   136,   33,    4,  166,   85,   87,   88,  130,   63,   64,
 /*  1350 */   170,  171,  172,  229,   87,   88,   71,   87,   88,  141,
 /*  1360 */    33,   87,   88,   79,   79,   87,   88,    4,  100,   84,
 /*  1370 */   112,  142,   87,   88,   36,  120,   91,   92,   93,  170,
 /*  1380 */   171,  172,  170,  171,  172,  231,  156,  210,  156,   87,
 /*  1390 */    88,  109,  121,  156,  109,  156,  166,  158,  166,   17,
 /*  1400 */    87,   63,   64,  166,  130,  166,  144,  165,  130,   71,
 /*  1410 */   143,  231,   80,  156,   80,  130,  146,   79,  133,  187,
 /*  1420 */   135,  136,   84,  166,  187,   87,   88,   81,  156,   91,
 /*  1430 */    92,   93,  130,  222,  204,  205,  155,  206,  166,    4,
 /*  1440 */   231,  154,  156,  231,  156,  156,  156,  109,  156,  177,
 /*  1450 */    87,   88,  166,  100,  166,  166,  166,   73,  166,  179,
 /*  1460 */   156,  229,  156,  177,   85,  177,  229,  177,  130,  177,
 /*  1470 */   166,  133,  166,  135,  136,  156,  156,  158,  156,  156,
 /*  1480 */   179,  177,  156,  177,  154,  166,  166,  154,  166,  166,
 /*  1490 */   154,  156,  166,  221,  155,  183,  156,  177,  155,  177,
 /*  1500 */   177,  166,  160,  177,   28,  156,  166,  221,  156,  221,
 /*  1510 */   156,  221,  177,  221,  156,  166,  155,  177,  166,  155,
 /*  1520 */   166,   86,   87,   88,  166,  221,  177,  221,  156,  177,
 /*  1530 */   156,  177,  117,  192,  197,  177,  156,  129,  166,  126,
 /*  1540 */   166,  221,  156,  221,  221,  156,  166,  221,  198,  177,
 /*  1550 */   156,  177,  166,  124,  156,  166,  221,  177,  199,  156,
 /*  1560 */   166,  221,  156,  177,  166,  127,  177,  156,  156,  166,
 /*  1570 */   221,  177,  166,  221,  156,  221,  156,  166,  166,  221,
 /*  1580 */   177,  156,  156,  200,  166,  212,  166,  128,  177,  177,
 /*  1590 */    99,  166,  166,  221,  201,  221,  156,  177,   68,  156,
 /*  1600 */   222,  221,  177,  177,  156,   47,  166,  221,  156,  166,
 /*  1610 */   221,  156,  156,  156,  166,  221,  225,  156,  166,  156,
 /*  1620 */   177,  166,  166,  166,  221,  177,  156,  166,  156,  166,
 /*  1630 */   156,  138,  221,  221,  156,  156,  166,  209,  166,  156,
 /*  1640 */   166,  221,  156,  156,  166,  166,  221,  221,  156,  166,
 /*  1650 */   156,   82,  166,  166,  166,    4,  156,   82,  166,  209,
 /*  1660 */   166,  155,  178,   79,  221,  166,  166,  155,  183,  221,
 /*  1670 */   155,  155,  155,  178,  209,   82,  209,   82,  234,   24,
 /*  1680 */   235,  138,   82,   45,   82,   82,  197,  190,  219,   79,
 /*  1690 */   209,  190,  155,   82,   82,   82,   82,  190,  238,  209,
 /*  1700 */    15,  239,  121,  176,  238,  194,  196,  176,  231,  181,
 /*  1710 */   208,  231,  176,  209,  185,  197,  167,  167,  167,  167,
 /*  1720 */   182,  182,  226,  182,  189,  193,  207,  240,  223,  189,
 /*  1730 */   232,  186,  240,  240,  240,  227,  233,
};
#define YY_SHIFT_USE_DFLT (-101)
#define YY_SHIFT_COUNT (343)
#define YY_SHIFT_MIN   (-100)
#define YY_SHIFT_MAX   (1685)
static const short yy_shift_ofst[] = {
 /*     0 */   273,   -7,  499,   -4,  141,  922, 1204, 1119,  533,  533,
 /*    10 */    13,  577,  567, 1034, 1285, 1435,   81,  366, 1015,  941,
 /*    20 */  1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285,
 /*    30 */  1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285, 1285,
 /*    40 */  1285, 1285, 1285, 1285, 1285, 1285, 1285, 1338, 1107,   43,
 /*    50 */  1278, 1278, 1278, 1278,  997,  997, 1278,  997,  997,  997,
 /*    60 */   524,  173, 1003, 1185, 1173, 1159, 1157, 1113, 1100, 1069,
 /*    70 */   251, 1274, 1274, 1302, 1028, 1278, 1274,  255,  301,  153,
 /*    80 */  1049,  996, 1032,  540,  202,  531, 1270, 1267, 1258, 1227,
 /*    90 */  1229, 1222, 1217, 1213, 1198, 1189,  817, 1176,  731, 1126,
 /*   100 */  1088,  728, 1059,  725, 1052, 1052,  611, 1052,  939,  625,
 /*   110 */   956,  195,  605, 1363, 1363, 1363, 1363, 1363, 1363, 1363,
 /*   120 */  1363,  -30, 1132,  167, 1415, 1415, -101,  502,  502,  502,
 /*   130 */   502,  502,  502,  502,  527,  327,  659,  778,  742,  716,
 /*   140 */   692,  359,  828,  804,  804,  851,  873,  873,  405,  405,
 /*   150 */   405,  204,  211,    1,  233,    1,  181,  522,   35,  375,
 /*   160 */   -20,  121,  -76, -100, -100, 1122,  426, -100, -100,  166,
 /*   170 */   690,  690,  690,  200,  200,  200,  566,  162, 1016,  164,
 /*   180 */    93,  876,  164,  550,  678,  678,  565,   41,  164, 1685,
 /*   190 */  1581, 1685, 1611, 1638, 1614, 1613, 1612, 1353, 1611, 1638,
 /*   200 */  1610, 1603, 1602, 1638, 1408, 1600, 1543, 1655, 1595, 1593,
 /*   210 */  1584, 1353, 1353, 1353, 1353, 1476, 1651, 1584, 1353, 1575,
 /*   220 */  1651, 1569, 1493, 1558, 1530, 1491, 1459, 1429, 1438, 1413,
 /*   230 */  1408, 1415, 1353, 1353, 1476, 1353, 1353, 1379, 1384, 1384,
 /*   240 */  1384, 1353, 1384, -101, -101, -101, -101, -101, -101, -101,
 /*   250 */  -101,  458,   15,  913,  349,  963,  564,  987,  706,  957,
 /*   260 */   950,  898,  590,  582,  451,  241,  449,   86,   38,  -11,
 /*   270 */    55,   28,  -59, 1346, 1262, 1334, 1332, 1313, 1382, 1271,
 /*   280 */  1255, 1282, 1268, 1284, 1218, 1327, 1259, 1308, 1310, 1266,
 /*   290 */  1263, 1228, 1248, 1192, 1264, 1245, 1174, 1179, 1260, 1165,
 /*   300 */  1172, 1099, 1152, 1160, 1186, 1136, 1120, 1089, 1130, 1105,
 /*   310 */  1094, 1080, 1020, 1058, 1027, 1013,  961,  968,  931,  899,
 /*   320 */   931,  923,  856,  719,  888,  870,  864,  735,  617,  636,
 /*   330 */   588,  559,  555,  532,  316,  498,  418,  407,  317,  178,
 /*   340 */   143,   87,  130,  -41,
};
#define YY_REDUCE_USE_DFLT (-194)
#define YY_REDUCE_COUNT (250)
#define YY_REDUCE_MIN   (-193)
#define YY_REDUCE_MAX   (1552)
static const short yy_reduce_ofst[] = {
 /*     0 */   192,  -34,  781,  -57,  831,  318, -148,  790,  809,  374,
 /*    10 */   132,   29,  320,  512,  466,  277, 1448, 1443, 1426, 1425,
 /*    20 */  1420, 1412, 1411, 1403, 1394, 1389, 1386, 1380, 1374, 1372,
 /*    30 */  1358, 1354, 1352, 1349, 1340, 1335, 1326, 1323, 1322, 1320,
 /*    40 */  1306, 1304, 1292, 1290, 1288, 1286, 1272, 1082, 1230,  779,
 /*    50 */  1237, 1232, 1124,  944, 1212, 1209,  -75, 1180, 1154,  777,
 /*    60 */   280,  431,  286,  823, 1319, 1239, 1162, 1076,  986,  808,
 /*    70 */   805, 1177, 1071,  470,  297, -131,   46,  705,  772,  307,
 /*    80 */  1487, 1500, 1494, 1289, 1492, 1487, 1289, 1289, 1486, 1289,
 /*    90 */  1289, 1289, 1483, 1289, 1289, 1289, 1479, 1478, 1289, 1474,
 /*   100 */  1472, 1470, 1463, 1257, 1091, 1053, 1461,  962, 1457, 1289,
 /*   110 */  1456, 1455, 1452, 1440, 1418, 1406, 1398, 1289,  993,  215,
 /*   120 */   -80,  654,  634,  656,  242,  -45, -193, 1211, 1211, 1211,
 /*   130 */  1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211,
 /*   140 */  1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211, 1211,
 /*   150 */  1211, 1211, 1211, 1540, 1545, 1535, 1532, 1519, 1532, 1508,
 /*   160 */  1505, 1211, 1532, 1532, 1532, 1503, 1498, 1532, 1532, 1552,
 /*   170 */  1541, 1539, 1538, 1551, 1550, 1549, 1504, 1518, 1529, 1536,
 /*   180 */  1528, 1502, 1531, 1496, 1480, 1477, 1510, 1511, 1527, 1466,
 /*   190 */  1462, 1460, 1490, 1507, 1465, 1465, 1465, 1537, 1481, 1501,
 /*   200 */  1469, 1465, 1465, 1497, 1489, 1465, 1445, 1444, 1467, 1465,
 /*   210 */  1495, 1517, 1516, 1515, 1512, 1485, 1499, 1484, 1506, 1450,
 /*   220 */  1488, 1428, 1391, 1378, 1211, 1373, 1393, 1383, 1359, 1350,
 /*   230 */  1337, 1341, 1364, 1361, 1312, 1343, 1339, 1342, 1336, 1333,
 /*   240 */  1330, 1281, 1287, 1301, 1280, 1231, 1211, 1211, 1211, 1211,
 /*   250 */  1242,
};
static const YYACTIONTYPE yy_default[] = {
 /*     0 */   589,  936,  936,  862,  903,  851,  851,  851,  936,  936,
 /*    10 */   730,  936,  851,  851,  851,  936,  851,  851,  851,  851,
 /*    20 */   851,  851,  851,  851,  851,  851,  851,  851,  851,  851,
 /*    30 */   851,  851,  851,  851,  851,  851,  851,  851,  851,  851,
 /*    40 */   851,  851,  851,  851,  851,  851,  851,  841,  724,  608,
 /*    50 */   936,  936,  936,  936,  936,  936,  936,  936,  936,  936,
 /*    60 */   616,  720,  730,  936,  936,  936,  936,  790,  777,  768,
 /*    70 */   936,  800,  800,  783,  679,  936,  800,  756,  752,  936,
 /*    80 */   839,  936,  936,  731,  936,  839,  936,  936,  936,  936,
 /*    90 */   936,  791,  784,  778,  769,  936,  936,  936,  936,  936,
 /*   100 */   936,  936,  936,  936,  720,  720,  936,  720,  936,  936,
 /*   110 */   936,  840,  594,  936,  882,  936,  936,  936,  936,  936,
 /*   120 */   936,  605,  589,  936,  936,  936,  710,  736,  773,  761,
 /*   130 */   863,  856,  857,  855,  852,  852,  852,  852,  852,  852,
 /*   140 */   852,  852,  852,  852,  823,  816,  827,  815,  831,  826,
 /*   150 */   818,  817,  819,  936,  936,  936,  936,  723,  936,  936,
 /*   160 */   936,  820,  936,  789,  698,  936,  910,  693,  601,  618,
 /*   170 */   936,  936,  936,  936,  936,  936,  936,  772,  670,  756,
 /*   180 */   645,  738,  756,  858,  936,  936,  721,  708,  756,  934,
 /*   190 */   931,  934,  739,  683,  739,  739,  739,  681,  739,  683,
 /*   200 */   796,  739,  739,  683,  772,  739,  918,  915,  739,  739,
 /*   210 */   871,  681,  681,  681,  681,  662,  936,  871,  681,  739,
 /*   220 */   936,  739,  936,  852,  821,  752,  762,  748,  760,  757,
 /*   230 */   772,  936,  681,  681,  662,  681,  681,  665,  593,  593,
 /*   240 */   593,  681,  593,  649,  649,  726,  830,  829,  828,  822,
 /*   250 */   629,  864,  936,  936,  936,  936,  936,  936,  936,  936,
 /*   260 */   936,  936,  936,  936,  936,  936,  936,  936,  936,  763,
 /*   270 */   936,  936,  936,  936,  936,  936,  936,  936,  936,  881,
 /*   280 */   936,  936,  936,  936,  936,  936,  914,  913,  936,  936,
 /*   290 */   936,  936,  936,  936,  936,  936,  936,  936,  902,  936,
 /*   300 */   936,  936,  936,  936,  936,  936,  936,  936,  936,  936,
 /*   310 */   936,  936,  936,  936,  936,  936,  936,  936,  758,  936,
 /*   320 */   861,  843,  701,  850,  936,  936,  936,  936,  936,  842,
 /*   330 */   853,  810,  936,  749,  936,  809,  806,  808,  611,  936,
 /*   340 */   936,  936,  936,  936,  586,  590,  935,  933,  932,  930,
 /*   350 */   890,  889,  888,  886,  895,  894,  893,  892,  891,  887,
 /*   360 */   885,  884,  883,  880,  787,  775,  766,  697,  929,  927,
 /*   370 */   928,  879,  877,  878,  696,  695,  692,  691,  690,  869,
 /*   380 */   868,  866,  865,  867,  604,  906,  909,  908,  907,  912,
 /*   390 */   911,  904,  917,  916,  921,  925,  924,  923,  922,  920,
 /*   400 */   901,  795,  794,  792,  797,  788,  793,  780,  786,  785,
 /*   410 */   776,  779,  684,  771,  767,  770,  905,  694,  603,  741,
 /*   420 */   602,  607,  668,  669,  677,  680,  675,  678,  674,  673,
 /*   430 */   672,  676,  671,  667,  610,  609,  623,  621,  622,  620,
 /*   440 */   619,  617,  639,  638,  635,  637,  634,  636,  633,  632,
 /*   450 */   631,  630,  628,  661,  647,  646,  874,  876,  875,  873,
 /*   460 */   872,  654,  653,  659,  658,  657,  656,  652,  655,  651,
 /*   470 */   650,  648,  644,  814,  813,  807,  835,  707,  706,  715,
 /*   480 */   713,  712,  711,  747,  746,  745,  744,  743,  742,  735,
 /*   490 */   733,  729,  728,  734,  732,  727,  719,  717,  718,  716,
 /*   500 */   612,  802,  799,  801,  798,  737,  725,  722,  709,  751,
 /*   510 */   753,  854,  844,  834,  845,  740,  832,  833,  704,  703,
 /*   520 */   702,  853,  850,  846,  926,  838,  849,  837,  836,  825,
 /*   530 */   824,  812,  847,  848,  811,  750,  765,  898,  897,  900,
 /*   540 */   899,  896,  764,  625,  624,  705,  700,  699,  805,  804,
 /*   550 */   803,  643,  755,  754,  642,  664,  663,  660,  641,  640,
 /*   560 */   627,  626,  606,  600,  599,  598,  597,  615,  614,  613,
 /*   570 */   611,  596,  595,  689,  688,  687,  686,  685,  682,  592,
 /*   580 */   591,  588,  587,  585,
};

/* The next table maps tokens into fallback tokens.  If a construct
** like the following:
**
**      %fallback ID X Y Z.
**
** appears in the grammar, then ID becomes a fallback token for X, Y,
** and Z.  Whenever one of the tokens X, Y, or Z is input to the parser
** but it does not parse, the type of the token is changed to ID and
** the parse is retried before an error is thrown.
*/
#ifdef YYFALLBACK
static const YYCODETYPE yyFallback[] = {
    0,  /*          $ => nothing */
    0,  /*    ILLEGAL => nothing */
    0,  /*    COMMENT => nothing */
    0,  /*      SPACE => nothing */
    0,  /*         ID => nothing */
    4,  /*      ABORT => ID */
    4,  /*      AFTER => ID */
    4,  /*        ASC => ID */
    4,  /*     ATTACH => ID */
    4,  /*     BEFORE => ID */
    4,  /*      BEGIN => ID */
    4,  /*    CASCADE => ID */
    4,  /*    CLUSTER => ID */
    4,  /*   CONFLICT => ID */
    4,  /*       COPY => ID */
    4,  /*   DATABASE => ID */
    4,  /*   DEFERRED => ID */
    4,  /* DELIMITERS => ID */
    4,  /*       DESC => ID */
    4,  /*     DETACH => ID */
    4,  /*       EACH => ID */
    4,  /*        END => ID */
    4,  /*    EXPLAIN => ID */
    4,  /*       FAIL => ID */
    4,  /*        FOR => ID */
    4,  /*       GLOB => ID */
    4,  /*     IGNORE => ID */
    4,  /*  IMMEDIATE => ID */
    4,  /*  INITIALLY => ID */
    4,  /*    INSTEAD => ID */
    4,  /*       LIKE => ID */
    4,  /*      MATCH => ID */
    4,  /*        KEY => ID */
    4,  /*         OF => ID */
    4,  /*     OFFSET => ID */
    4,  /*     PRAGMA => ID */
    4,  /*      RAISE => ID */
    4,  /*    REPLACE => ID */
    4,  /*   RESTRICT => ID */
    4,  /*        ROW => ID */
    4,  /*  STATEMENT => ID */
    4,  /*       TEMP => ID */
    4,  /*    TRIGGER => ID */
    4,  /*     VACUUM => ID */
    4,  /*       VIEW => ID */
};
#endif /* YYFALLBACK */

/* The following structure represents a single element of the
** parser's stack.  Information stored includes:
**
**   +  The state number for the parser at this level of the stack.
**
**   +  The value of the token stored at this level of the stack.
**      (In other words, the "major" token.)
**
**   +  The semantic value stored at this level of the stack.  This is
**      the information used by the action routines in the grammar.
**      It is sometimes called the "minor" token.
*/
struct yyStackEntry {
  YYACTIONTYPE stateno;  /* The state-number */
  YYCODETYPE major;      /* The major token value.  This is the code
                         ** number for the token at this stack level */
  YYMINORTYPE minor;     /* The user-supplied minor token value.  This
                         ** is the value of the token  */
  QList<Token*>* tokens = nullptr;
};
typedef struct yyStackEntry yyStackEntry;

/* The state of the parser is completely contained in an instance of
** the following structure */
struct yyParser {
  int yyidx;                    /* Index of top element in stack */
#ifdef YYTRACKMAXSTACKDEPTH
  int yyidxMax;                 /* Maximum value of yyidx */
#endif
  int yyerrcnt;                 /* Shifts left before out of the error */
  sqlite2_parseARG_SDECL                /* A place to hold %extra_argument */
#if YYSTACKDEPTH<=0
  int yystksz;                  /* Current side of the stack */
  yyStackEntry *yystack;        /* The parser's stack */
#else
  yyStackEntry yystack[YYSTACKDEPTH];  /* The parser's stack */
#endif
};
typedef struct yyParser yyParser;

#ifndef NDEBUG
#include <stdio.h>
static FILE *yyTraceFILE = 0;
static char *yyTracePrompt = 0;
#endif /* NDEBUG */

void *sqlite2_parseCopyParserState(void* other)
{
  yyParser *pParser;
  yyParser *otherParser = (yyParser*)other;

  // Copy parser
  pParser = (yyParser*)malloc((size_t)sizeof(yyParser));
  memcpy(pParser, other, (size_t)sizeof(yyParser));

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = malloc((size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)other)->yystack, (size_t)stackSize);
#endif

  for (int i = 0; i <= pParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(otherParser->yystack[i].tokens);
  }

  return pParser;
}

void sqlite2_parseAddToken(void* other, Token* token)
{
    yyParser *otherParser = (yyParser*)other;
    if (otherParser->yyidx < 0)
        return; // Nothing on stack yet. Might happen when parsing just whitespaces, nothing else.

    otherParser->yystack[otherParser->yyidx].tokens->append(token);
}

void sqlite2_parseRestoreParserState(void* saved, void* target)
{
  yyParser *pParser = (yyParser*)target;
  yyParser *savedParser = (yyParser*)saved;

  for (int i = 0; i <= pParser->yyidx; i++)
      delete pParser->yystack[i].tokens;

  memcpy(pParser, saved, (size_t)sizeof(yyParser));

  for (int i = 0; i <= savedParser->yyidx; i++)
  {
      pParser->yystack[i].tokens = new QList<Token*>();
      *(pParser->yystack[i].tokens) = *(savedParser->yystack[i].tokens);
  }

#if YYSTACKDEPTH<=0
  // Copy stack
  int stackSize = sizeof(yyStackEntry) * pParser->yystksz;
  pParser->yystack = relloc(pParser->yystack, (size_t)stackSize);
  memcpy(pParser->yystack, ((yyParser*)saved)->yystack, (size_t)stackSize);
#endif
}

void sqlite2_parseFreeSavedState(void* other)
{
    yyParser *pParser = (yyParser*)other;
    for (int i = 0; i <= pParser->yyidx; i++)
        delete pParser->yystack[i].tokens;

#if YYSTACKDEPTH<=0
    free(pParser->yystack);
#endif
    free(other);
}

#ifndef NDEBUG
/*
** Turn parser tracing on by giving a stream to which to write the trace
** and a prompt to preface each trace message.  Tracing is turned off
** by making either argument NULL
**
** Inputs:
** <ul>
** <li> A FILE* to which trace output should be written.
**      If NULL, then tracing is turned off.
** <li> A prefix string written at the beginning of every
**      line of trace output.  If NULL, then tracing is
**      turned off.
** </ul>
**
** Outputs:
** None.
*/
void sqlite2_parseTrace(FILE *TraceFILE, char *zTracePrompt){
  yyTraceFILE = TraceFILE;
  yyTracePrompt = zTracePrompt;
  if( yyTraceFILE==0 ) yyTracePrompt = 0;
  else if( yyTracePrompt==0 ) yyTraceFILE = 0;
}
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing shifts, the names of all terminals and nonterminals
** are required.  The following table supplies these names */
static const char *const yyTokenName[] = {
  "$",             "ILLEGAL",       "COMMENT",       "SPACE",       
  "ID",            "ABORT",         "AFTER",         "ASC",         
  "ATTACH",        "BEFORE",        "BEGIN",         "CASCADE",     
  "CLUSTER",       "CONFLICT",      "COPY",          "DATABASE",    
  "DEFERRED",      "DELIMITERS",    "DESC",          "DETACH",      
  "EACH",          "END",           "EXPLAIN",       "FAIL",        
  "FOR",           "GLOB",          "IGNORE",        "IMMEDIATE",   
  "INITIALLY",     "INSTEAD",       "LIKE",          "MATCH",       
  "KEY",           "OF",            "OFFSET",        "PRAGMA",      
  "RAISE",         "REPLACE",       "RESTRICT",      "ROW",         
  "STATEMENT",     "TEMP",          "TRIGGER",       "VACUUM",      
  "VIEW",          "OR",            "AND",           "NOT",         
  "EQ",            "NE",            "ISNULL",        "NOTNULL",     
  "IS",            "BETWEEN",       "IN",            "GT",          
  "GE",            "LT",            "LE",            "BITAND",      
  "BITOR",         "LSHIFT",        "RSHIFT",        "PLUS",        
  "MINUS",         "STAR",          "SLASH",         "REM",         
  "CONCAT",        "UMINUS",        "UPLUS",         "BITNOT",      
  "SEMI",          "TRANSACTION",   "ID_TRANS",      "COMMIT",      
  "ROLLBACK",      "CREATE",        "TABLE",         "LP",          
  "RP",            "AS",            "DOT",           "ID_TAB_NEW",  
  "ID_DB",         "COMMA",         "ID_COL_NEW",    "STRING",      
  "JOIN_KW",       "ID_COL_TYPE",   "DEFAULT",       "INTEGER",     
  "FLOAT",         "NULL",          "CONSTRAINT",    "PRIMARY",     
  "UNIQUE",        "CHECK",         "REFERENCES",    "COLLATE",     
  "ON",            "INSERT",        "DELETE",        "UPDATE",      
  "ID_FK_MATCH",   "SET",           "DEFERRABLE",    "FOREIGN",     
  "ID_CONSTR",     "ID_TAB",        "DROP",          "ID_VIEW_NEW", 
  "ID_VIEW",       "UNION",         "ALL",           "EXCEPT",      
  "INTERSECT",     "SELECT",        "DISTINCT",      "ID_ALIAS",    
  "FROM",          "USING",         "JOIN",          "ID_JOIN_OPTS",
  "ORDER",         "BY",            "GROUP",         "HAVING",      
  "LIMIT",         "WHERE",         "ID_COL",        "INTO",        
  "VALUES",        "VARIABLE",      "LIKE_KW",       "CASE",        
  "ID_FN",         "ID_ERR_MSG",    "WHEN",          "THEN",        
  "ELSE",          "INDEX",         "ID_IDX_NEW",    "ID_IDX",      
  "ID_PRAGMA",     "ID_TRIG_NEW",   "ID_TRIG",       "error",       
  "cmd",           "input",         "cmdlist",       "ecmd",        
  "explain",       "cmdx",          "trans_opt",     "onconf",      
  "nm",            "temp",          "fullname",      "columnlist",  
  "conslist_opt",  "select",        "column",        "columnid",    
  "type",          "carglist",      "id",            "ids",         
  "typetoken",     "typename",      "signed",        "plus_num",    
  "minus_num",     "ccons",         "ccons_nm",      "carg",        
  "sortorder",     "expr",          "idxlist_opt",   "refargs",     
  "defer_subclause",  "refarg",        "refact",        "init_deferred_pred_opt",
  "conslist",      "tconscomma",    "tcons",         "idxlist",     
  "defer_subclause_opt",  "resolvetype",   "orconf",        "select_stmt", 
  "oneselect",     "multiselect_op",  "distinct",      "selcollist",  
  "from",          "where_opt",     "groupby_opt",   "having_opt",  
  "orderby_opt",   "limit_opt",     "sclp",          "as",          
  "joinsrc",       "singlesrc",     "seltablist",    "joinop",      
  "joinconstr_opt",  "dbnm",          "inscollist",    "sortlist",    
  "collate",       "nexprlist",     "delete_stmt",   "update_stmt", 
  "setlist",       "insert_stmt",   "insert_cmd",    "inscollist_opt",
  "exprlist",      "exprx",         "not_opt",       "likeop",      
  "case_operand",  "case_exprlist",  "case_else",     "raisetype",   
  "uniqueflag",    "idxlist_single",  "nmnum",         "number",      
  "trigger_time",  "trigger_event",  "foreach_clause",  "when_clause", 
  "trigger_cmd_list",  "trigger_cmd",   "database_kw_opt",  "key_opt",     
};
#endif /* NDEBUG */

#ifndef NDEBUG
/* For tracing reduce actions, the names of all rules are required.
*/
static const char *const yyRuleName[] = {
 /*   0 */ "input ::= cmdlist",
 /*   1 */ "cmdlist ::= cmdlist ecmd",
 /*   2 */ "cmdlist ::= ecmd",
 /*   3 */ "ecmd ::= SEMI",
 /*   4 */ "ecmd ::= explain cmdx SEMI",
 /*   5 */ "explain ::=",
 /*   6 */ "explain ::= EXPLAIN",
 /*   7 */ "cmdx ::= cmd",
 /*   8 */ "cmd ::= BEGIN trans_opt onconf",
 /*   9 */ "trans_opt ::=",
 /*  10 */ "trans_opt ::= TRANSACTION",
 /*  11 */ "trans_opt ::= TRANSACTION nm",
 /*  12 */ "trans_opt ::= TRANSACTION ID_TRANS",
 /*  13 */ "cmd ::= COMMIT trans_opt",
 /*  14 */ "cmd ::= END trans_opt",
 /*  15 */ "cmd ::= ROLLBACK trans_opt",
 /*  16 */ "cmd ::= CREATE temp TABLE fullname LP columnlist conslist_opt RP",
 /*  17 */ "cmd ::= CREATE temp TABLE fullname AS select",
 /*  18 */ "cmd ::= CREATE temp TABLE nm DOT ID_TAB_NEW",
 /*  19 */ "cmd ::= CREATE temp TABLE ID_DB|ID_TAB_NEW",
 /*  20 */ "temp ::= TEMP",
 /*  21 */ "temp ::=",
 /*  22 */ "columnlist ::= columnlist COMMA column",
 /*  23 */ "columnlist ::= column",
 /*  24 */ "column ::= columnid type carglist",
 /*  25 */ "columnid ::= nm",
 /*  26 */ "columnid ::= ID_COL_NEW",
 /*  27 */ "id ::= ID",
 /*  28 */ "ids ::= ID|STRING",
 /*  29 */ "nm ::= id",
 /*  30 */ "nm ::= STRING",
 /*  31 */ "nm ::= JOIN_KW",
 /*  32 */ "type ::=",
 /*  33 */ "type ::= typetoken",
 /*  34 */ "typetoken ::= typename",
 /*  35 */ "typetoken ::= typename LP signed RP",
 /*  36 */ "typetoken ::= typename LP signed COMMA signed RP",
 /*  37 */ "typename ::= ids",
 /*  38 */ "typename ::= typename ids",
 /*  39 */ "typename ::= ID_COL_TYPE",
 /*  40 */ "signed ::= plus_num",
 /*  41 */ "signed ::= minus_num",
 /*  42 */ "carglist ::= carglist ccons",
 /*  43 */ "carglist ::= carglist ccons_nm ccons",
 /*  44 */ "carglist ::= carglist carg",
 /*  45 */ "carglist ::=",
 /*  46 */ "carg ::= DEFAULT STRING",
 /*  47 */ "carg ::= DEFAULT ID",
 /*  48 */ "carg ::= DEFAULT INTEGER",
 /*  49 */ "carg ::= DEFAULT PLUS INTEGER",
 /*  50 */ "carg ::= DEFAULT MINUS INTEGER",
 /*  51 */ "carg ::= DEFAULT FLOAT",
 /*  52 */ "carg ::= DEFAULT PLUS FLOAT",
 /*  53 */ "carg ::= DEFAULT MINUS FLOAT",
 /*  54 */ "carg ::= DEFAULT NULL",
 /*  55 */ "ccons_nm ::= CONSTRAINT nm",
 /*  56 */ "ccons ::= NULL onconf",
 /*  57 */ "ccons ::= NOT NULL onconf",
 /*  58 */ "ccons ::= PRIMARY KEY sortorder onconf",
 /*  59 */ "ccons ::= UNIQUE onconf",
 /*  60 */ "ccons ::= CHECK LP expr RP onconf",
 /*  61 */ "ccons ::= REFERENCES nm idxlist_opt refargs",
 /*  62 */ "ccons ::= defer_subclause",
 /*  63 */ "ccons ::= COLLATE id",
 /*  64 */ "ccons ::= CHECK LP RP",
 /*  65 */ "refargs ::=",
 /*  66 */ "refargs ::= refargs refarg",
 /*  67 */ "refarg ::= MATCH nm",
 /*  68 */ "refarg ::= ON INSERT refact",
 /*  69 */ "refarg ::= ON DELETE refact",
 /*  70 */ "refarg ::= ON UPDATE refact",
 /*  71 */ "refarg ::= MATCH ID_FK_MATCH",
 /*  72 */ "refact ::= SET NULL",
 /*  73 */ "refact ::= SET DEFAULT",
 /*  74 */ "refact ::= CASCADE",
 /*  75 */ "refact ::= RESTRICT",
 /*  76 */ "defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt",
 /*  77 */ "defer_subclause ::= DEFERRABLE init_deferred_pred_opt",
 /*  78 */ "init_deferred_pred_opt ::=",
 /*  79 */ "init_deferred_pred_opt ::= INITIALLY DEFERRED",
 /*  80 */ "init_deferred_pred_opt ::= INITIALLY IMMEDIATE",
 /*  81 */ "conslist_opt ::=",
 /*  82 */ "conslist_opt ::= COMMA conslist",
 /*  83 */ "conslist ::= conslist tconscomma tcons",
 /*  84 */ "conslist ::= tcons",
 /*  85 */ "tconscomma ::= COMMA",
 /*  86 */ "tconscomma ::=",
 /*  87 */ "tcons ::= CONSTRAINT nm",
 /*  88 */ "tcons ::= PRIMARY KEY LP idxlist RP onconf",
 /*  89 */ "tcons ::= UNIQUE LP idxlist RP onconf",
 /*  90 */ "tcons ::= CHECK LP expr RP onconf",
 /*  91 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt",
 /*  92 */ "tcons ::= CONSTRAINT ID_CONSTR",
 /*  93 */ "tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB",
 /*  94 */ "tcons ::= CHECK LP RP onconf",
 /*  95 */ "defer_subclause_opt ::=",
 /*  96 */ "defer_subclause_opt ::= defer_subclause",
 /*  97 */ "onconf ::=",
 /*  98 */ "onconf ::= ON CONFLICT resolvetype",
 /*  99 */ "orconf ::=",
 /* 100 */ "orconf ::= OR resolvetype",
 /* 101 */ "resolvetype ::= ROLLBACK",
 /* 102 */ "resolvetype ::= ABORT",
 /* 103 */ "resolvetype ::= FAIL",
 /* 104 */ "resolvetype ::= IGNORE",
 /* 105 */ "resolvetype ::= REPLACE",
 /* 106 */ "cmd ::= DROP TABLE fullname",
 /* 107 */ "cmd ::= DROP TABLE nm DOT ID_TAB",
 /* 108 */ "cmd ::= DROP TABLE ID_DB|ID_TAB",
 /* 109 */ "cmd ::= CREATE temp VIEW nm AS select",
 /* 110 */ "cmd ::= CREATE temp VIEW ID_VIEW_NEW",
 /* 111 */ "cmd ::= DROP VIEW nm",
 /* 112 */ "cmd ::= DROP VIEW ID_VIEW",
 /* 113 */ "cmd ::= select_stmt",
 /* 114 */ "select_stmt ::= select",
 /* 115 */ "select ::= oneselect",
 /* 116 */ "select ::= select multiselect_op oneselect",
 /* 117 */ "multiselect_op ::= UNION",
 /* 118 */ "multiselect_op ::= UNION ALL",
 /* 119 */ "multiselect_op ::= EXCEPT",
 /* 120 */ "multiselect_op ::= INTERSECT",
 /* 121 */ "oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt",
 /* 122 */ "distinct ::= DISTINCT",
 /* 123 */ "distinct ::= ALL",
 /* 124 */ "distinct ::=",
 /* 125 */ "sclp ::= selcollist COMMA",
 /* 126 */ "sclp ::=",
 /* 127 */ "selcollist ::= sclp expr as",
 /* 128 */ "selcollist ::= sclp STAR",
 /* 129 */ "selcollist ::= sclp nm DOT STAR",
 /* 130 */ "selcollist ::= sclp",
 /* 131 */ "selcollist ::= sclp ID_TAB DOT STAR",
 /* 132 */ "as ::= AS nm",
 /* 133 */ "as ::= ids",
 /* 134 */ "as ::= AS ID_ALIAS",
 /* 135 */ "as ::= ID_ALIAS",
 /* 136 */ "as ::=",
 /* 137 */ "from ::=",
 /* 138 */ "from ::= FROM joinsrc",
 /* 139 */ "joinsrc ::= singlesrc seltablist",
 /* 140 */ "joinsrc ::=",
 /* 141 */ "seltablist ::= seltablist joinop singlesrc joinconstr_opt",
 /* 142 */ "seltablist ::=",
 /* 143 */ "singlesrc ::= nm dbnm as",
 /* 144 */ "singlesrc ::= LP select RP as",
 /* 145 */ "singlesrc ::= LP joinsrc RP as",
 /* 146 */ "singlesrc ::=",
 /* 147 */ "singlesrc ::= nm DOT",
 /* 148 */ "singlesrc ::= nm DOT ID_TAB",
 /* 149 */ "singlesrc ::= ID_DB|ID_TAB",
 /* 150 */ "singlesrc ::= nm DOT ID_VIEW",
 /* 151 */ "singlesrc ::= ID_DB|ID_VIEW",
 /* 152 */ "joinconstr_opt ::= ON expr",
 /* 153 */ "joinconstr_opt ::= USING LP inscollist RP",
 /* 154 */ "joinconstr_opt ::=",
 /* 155 */ "dbnm ::=",
 /* 156 */ "dbnm ::= DOT nm",
 /* 157 */ "fullname ::= nm dbnm",
 /* 158 */ "joinop ::= COMMA",
 /* 159 */ "joinop ::= JOIN",
 /* 160 */ "joinop ::= JOIN_KW JOIN",
 /* 161 */ "joinop ::= JOIN_KW nm JOIN",
 /* 162 */ "joinop ::= JOIN_KW nm nm JOIN",
 /* 163 */ "joinop ::= ID_JOIN_OPTS",
 /* 164 */ "orderby_opt ::=",
 /* 165 */ "orderby_opt ::= ORDER BY sortlist",
 /* 166 */ "sortlist ::= sortlist COMMA collate expr sortorder",
 /* 167 */ "sortlist ::= expr collate sortorder",
 /* 168 */ "collate ::=",
 /* 169 */ "collate ::= COLLATE id",
 /* 170 */ "sortorder ::= ASC",
 /* 171 */ "sortorder ::= DESC",
 /* 172 */ "sortorder ::=",
 /* 173 */ "groupby_opt ::=",
 /* 174 */ "groupby_opt ::= GROUP BY nexprlist",
 /* 175 */ "groupby_opt ::= GROUP BY",
 /* 176 */ "having_opt ::=",
 /* 177 */ "having_opt ::= HAVING expr",
 /* 178 */ "limit_opt ::=",
 /* 179 */ "limit_opt ::= LIMIT signed",
 /* 180 */ "limit_opt ::= LIMIT signed OFFSET signed",
 /* 181 */ "limit_opt ::= LIMIT signed COMMA signed",
 /* 182 */ "cmd ::= delete_stmt",
 /* 183 */ "delete_stmt ::= DELETE FROM fullname where_opt",
 /* 184 */ "delete_stmt ::= DELETE FROM",
 /* 185 */ "delete_stmt ::= DELETE FROM nm DOT",
 /* 186 */ "delete_stmt ::= DELETE FROM nm DOT ID_TAB",
 /* 187 */ "delete_stmt ::= DELETE FROM ID_DB|ID_TAB",
 /* 188 */ "where_opt ::=",
 /* 189 */ "where_opt ::= WHERE expr",
 /* 190 */ "where_opt ::= WHERE",
 /* 191 */ "cmd ::= update_stmt",
 /* 192 */ "update_stmt ::= UPDATE orconf fullname SET setlist where_opt",
 /* 193 */ "update_stmt ::= UPDATE orconf",
 /* 194 */ "update_stmt ::= UPDATE orconf nm DOT",
 /* 195 */ "update_stmt ::= UPDATE orconf nm DOT ID_TAB",
 /* 196 */ "update_stmt ::= UPDATE orconf ID_DB|ID_TAB",
 /* 197 */ "setlist ::= setlist COMMA nm EQ expr",
 /* 198 */ "setlist ::= nm EQ expr",
 /* 199 */ "setlist ::=",
 /* 200 */ "setlist ::= setlist COMMA",
 /* 201 */ "setlist ::= setlist COMMA ID_COL",
 /* 202 */ "setlist ::= ID_COL",
 /* 203 */ "cmd ::= insert_stmt",
 /* 204 */ "insert_stmt ::= insert_cmd INTO fullname inscollist_opt VALUES LP exprlist RP",
 /* 205 */ "insert_stmt ::= insert_cmd INTO fullname inscollist_opt select",
 /* 206 */ "insert_stmt ::= insert_cmd INTO",
 /* 207 */ "insert_stmt ::= insert_cmd INTO nm DOT",
 /* 208 */ "insert_stmt ::= insert_cmd INTO ID_DB|ID_TAB",
 /* 209 */ "insert_stmt ::= insert_cmd INTO nm DOT ID_TAB",
 /* 210 */ "insert_cmd ::= INSERT orconf",
 /* 211 */ "insert_cmd ::= REPLACE",
 /* 212 */ "inscollist_opt ::=",
 /* 213 */ "inscollist_opt ::= LP inscollist RP",
 /* 214 */ "inscollist ::= inscollist COMMA nm",
 /* 215 */ "inscollist ::= nm",
 /* 216 */ "inscollist ::=",
 /* 217 */ "inscollist ::= inscollist COMMA ID_COL",
 /* 218 */ "inscollist ::= ID_COL",
 /* 219 */ "exprx ::= NULL",
 /* 220 */ "exprx ::= INTEGER",
 /* 221 */ "exprx ::= FLOAT",
 /* 222 */ "exprx ::= STRING",
 /* 223 */ "exprx ::= LP expr RP",
 /* 224 */ "exprx ::= id",
 /* 225 */ "exprx ::= JOIN_KW",
 /* 226 */ "exprx ::= nm DOT nm",
 /* 227 */ "exprx ::= nm DOT nm DOT nm",
 /* 228 */ "exprx ::= VARIABLE",
 /* 229 */ "exprx ::= ID LP exprlist RP",
 /* 230 */ "exprx ::= ID LP STAR RP",
 /* 231 */ "exprx ::= expr AND expr",
 /* 232 */ "exprx ::= expr OR expr",
 /* 233 */ "exprx ::= expr LT|GT|GE|LE expr",
 /* 234 */ "exprx ::= expr EQ|NE expr",
 /* 235 */ "exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr",
 /* 236 */ "exprx ::= expr PLUS|MINUS expr",
 /* 237 */ "exprx ::= expr STAR|SLASH|REM expr",
 /* 238 */ "exprx ::= expr CONCAT expr",
 /* 239 */ "exprx ::= expr not_opt likeop expr",
 /* 240 */ "exprx ::= expr ISNULL|NOTNULL",
 /* 241 */ "exprx ::= expr NOT NULL",
 /* 242 */ "exprx ::= expr IS not_opt expr",
 /* 243 */ "exprx ::= NOT expr",
 /* 244 */ "exprx ::= BITNOT expr",
 /* 245 */ "exprx ::= MINUS expr",
 /* 246 */ "exprx ::= PLUS expr",
 /* 247 */ "exprx ::= expr not_opt BETWEEN expr AND expr",
 /* 248 */ "exprx ::= expr not_opt IN LP exprlist RP",
 /* 249 */ "exprx ::= expr not_opt IN LP select RP",
 /* 250 */ "exprx ::= expr not_opt IN nm dbnm",
 /* 251 */ "exprx ::= LP select RP",
 /* 252 */ "exprx ::= CASE case_operand case_exprlist case_else END",
 /* 253 */ "exprx ::= RAISE LP raisetype COMMA nm RP",
 /* 254 */ "exprx ::= RAISE LP IGNORE RP",
 /* 255 */ "exprx ::= nm DOT",
 /* 256 */ "exprx ::= nm DOT nm DOT",
 /* 257 */ "exprx ::= expr not_opt BETWEEN expr AND",
 /* 258 */ "exprx ::= CASE case_operand case_exprlist case_else",
 /* 259 */ "exprx ::= expr not_opt IN LP exprlist",
 /* 260 */ "exprx ::= expr not_opt IN ID_DB",
 /* 261 */ "exprx ::= expr not_opt IN nm DOT ID_TAB",
 /* 262 */ "exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN",
 /* 263 */ "exprx ::= nm DOT ID_TAB|ID_COL",
 /* 264 */ "exprx ::= nm DOT nm DOT ID_COL",
 /* 265 */ "exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP",
 /* 266 */ "expr ::= exprx",
 /* 267 */ "expr ::=",
 /* 268 */ "not_opt ::=",
 /* 269 */ "not_opt ::= NOT",
 /* 270 */ "likeop ::= LIKE|GLOB",
 /* 271 */ "case_exprlist ::= case_exprlist WHEN expr THEN expr",
 /* 272 */ "case_exprlist ::= WHEN expr THEN expr",
 /* 273 */ "case_else ::= ELSE expr",
 /* 274 */ "case_else ::=",
 /* 275 */ "case_operand ::= exprx",
 /* 276 */ "case_operand ::=",
 /* 277 */ "exprlist ::= nexprlist",
 /* 278 */ "exprlist ::=",
 /* 279 */ "nexprlist ::= nexprlist COMMA expr",
 /* 280 */ "nexprlist ::= exprx",
 /* 281 */ "cmd ::= CREATE uniqueflag INDEX nm ON nm dbnm LP idxlist RP onconf",
 /* 282 */ "cmd ::= CREATE uniqueflag INDEX nm dbnm ON ID_TAB",
 /* 283 */ "cmd ::= CREATE uniqueflag INDEX nm DOT ID_IDX_NEW",
 /* 284 */ "cmd ::= CREATE uniqueflag INDEX ID_DB|ID_IDX_NEW",
 /* 285 */ "uniqueflag ::= UNIQUE",
 /* 286 */ "uniqueflag ::=",
 /* 287 */ "idxlist_opt ::=",
 /* 288 */ "idxlist_opt ::= LP idxlist RP",
 /* 289 */ "idxlist ::= idxlist COMMA idxlist_single",
 /* 290 */ "idxlist ::= idxlist_single",
 /* 291 */ "idxlist_single ::= nm sortorder",
 /* 292 */ "idxlist_single ::= ID_COL",
 /* 293 */ "cmd ::= DROP INDEX fullname",
 /* 294 */ "cmd ::= DROP INDEX nm DOT ID_IDX",
 /* 295 */ "cmd ::= DROP INDEX ID_DB|ID_IDX",
 /* 296 */ "cmd ::= COPY orconf nm dbnm FROM nm USING DELIMITERS STRING",
 /* 297 */ "cmd ::= COPY orconf nm dbnm FROM nm",
 /* 298 */ "cmd ::= VACUUM",
 /* 299 */ "cmd ::= VACUUM nm",
 /* 300 */ "cmd ::= PRAGMA ids",
 /* 301 */ "cmd ::= PRAGMA nm EQ nmnum",
 /* 302 */ "cmd ::= PRAGMA nm LP nmnum RP",
 /* 303 */ "cmd ::= PRAGMA nm EQ minus_num",
 /* 304 */ "cmd ::= PRAGMA nm LP minus_num RP",
 /* 305 */ "cmd ::= PRAGMA nm DOT ID_PRAGMA",
 /* 306 */ "cmd ::= PRAGMA ID_DB|ID_PRAGMA",
 /* 307 */ "nmnum ::= plus_num",
 /* 308 */ "nmnum ::= nm",
 /* 309 */ "nmnum ::= ON",
 /* 310 */ "nmnum ::= DELETE",
 /* 311 */ "nmnum ::= DEFAULT",
 /* 312 */ "plus_num ::= PLUS number",
 /* 313 */ "plus_num ::= number",
 /* 314 */ "minus_num ::= MINUS number",
 /* 315 */ "number ::= INTEGER",
 /* 316 */ "number ::= FLOAT",
 /* 317 */ "cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause BEGIN trigger_cmd_list END",
 /* 318 */ "cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause",
 /* 319 */ "cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause BEGIN trigger_cmd_list",
 /* 320 */ "cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON ID_TAB|ID_DB",
 /* 321 */ "cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm DOT ID_TAB",
 /* 322 */ "cmd ::= CREATE temp TRIGGER ID_TRIG_NEW",
 /* 323 */ "trigger_time ::= BEFORE",
 /* 324 */ "trigger_time ::= AFTER",
 /* 325 */ "trigger_time ::= INSTEAD OF",
 /* 326 */ "trigger_time ::=",
 /* 327 */ "trigger_event ::= DELETE",
 /* 328 */ "trigger_event ::= INSERT",
 /* 329 */ "trigger_event ::= UPDATE",
 /* 330 */ "trigger_event ::= UPDATE OF inscollist",
 /* 331 */ "foreach_clause ::=",
 /* 332 */ "foreach_clause ::= FOR EACH ROW",
 /* 333 */ "foreach_clause ::= FOR EACH STATEMENT",
 /* 334 */ "when_clause ::=",
 /* 335 */ "when_clause ::= WHEN expr",
 /* 336 */ "trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI",
 /* 337 */ "trigger_cmd_list ::= trigger_cmd SEMI",
 /* 338 */ "trigger_cmd ::= update_stmt",
 /* 339 */ "trigger_cmd ::= insert_stmt",
 /* 340 */ "trigger_cmd ::= delete_stmt",
 /* 341 */ "trigger_cmd ::= select_stmt",
 /* 342 */ "raisetype ::= ROLLBACK|ABORT|FAIL",
 /* 343 */ "cmd ::= DROP TRIGGER fullname",
 /* 344 */ "cmd ::= DROP TRIGGER nm DOT ID_TRIG",
 /* 345 */ "cmd ::= DROP TRIGGER ID_DB|ID_TRIG",
 /* 346 */ "cmd ::= ATTACH database_kw_opt ids AS ids key_opt",
 /* 347 */ "key_opt ::=",
 /* 348 */ "key_opt ::= USING ids",
 /* 349 */ "database_kw_opt ::= DATABASE",
 /* 350 */ "database_kw_opt ::=",
 /* 351 */ "cmd ::= DETACH database_kw_opt nm",
};
#endif /* NDEBUG */


#if YYSTACKDEPTH<=0
/*
** Try to increase the size of the parser stack.
*/
static void yyGrowStack(yyParser *p){
  int newSize;
  yyStackEntry *pNew;

  newSize = p->yystksz*2 + 100;
  pNew = realloc(p->yystack, newSize*sizeof(pNew[0]));
  if( pNew ){
    p->yystack = pNew;
    p->yystksz = newSize;
#ifndef NDEBUG
    if( yyTraceFILE ){
      fprintf(yyTraceFILE,"%sStack grows to %d entries!\n",
              yyTracePrompt, p->yystksz);
    }
#endif
  }
}
#endif

/*
** This function allocates a new parser.
** The only argument is a pointer to a function which works like
** malloc.
**
** Inputs:
** A pointer to the function used to allocate memory.
**
** Outputs:
** A pointer to a parser.  This pointer is used in subsequent calls
** to sqlite2_parse and sqlite2_parseFree.
*/
void *sqlite2_parseAlloc(void *(*mallocProc)(size_t)){
  yyParser *pParser;
  pParser = (yyParser*)(*mallocProc)( (size_t)sizeof(yyParser) );
  if( pParser ){
    pParser->yyidx = -1;
#ifdef YYTRACKMAXSTACKDEPTH
    pParser->yyidxMax = 0;
#endif
#if YYSTACKDEPTH<=0
    pParser->yystack = NULL;
    pParser->yystksz = 0;
    yyGrowStack(pParser);
#endif
  }
  return pParser;
}

/* The following function deletes the value associated with a
** symbol.  The symbol can be either a terminal or nonterminal.
** "yymajor" is the symbol code, and "yypminor" is a pointer to
** the value.
*/
static void yy_destructor(
  yyParser *yypParser,    /* The parser */
  YYCODETYPE yymajor,     /* Type code for object to destroy */
  YYMINORTYPE *yypminor   /* The object to be destroyed */
){
  sqlite2_parseARG_FETCH;
  if (parserContext->executeRules)
  {
      switch( yymajor ){
        /* Here is inserted the actions which take place when a
        ** terminal or non-terminal is destroyed.  This can happen
        ** when the symbol is popped from the stack during a
        ** reduce or during error processing or when a parser is
        ** being destroyed before it is finished parsing.
        **
        ** Note: during a reduce, the only symbols destroyed are those
        ** which appear on the RHS of the rule, but which are not used
        ** inside the C code.
        */
    case 148: /* cmd */
    case 151: /* ecmd */
    case 153: /* cmdx */
    case 191: /* select_stmt */
    case 214: /* delete_stmt */
    case 215: /* update_stmt */
    case 217: /* insert_stmt */
    case 237: /* trigger_cmd */
{
delete (yypminor->yy203);
}
      break;
    case 152: /* explain */
{
delete (yypminor->yy91);
}
      break;
    case 154: /* trans_opt */
{
delete (yypminor->yy404);
}
      break;
    case 155: /* onconf */
    case 189: /* resolvetype */
    case 190: /* orconf */
{
delete (yypminor->yy418);
}
      break;
    case 156: /* nm */
    case 163: /* columnid */
    case 166: /* id */
    case 167: /* ids */
    case 169: /* typename */
    case 209: /* dbnm */
{
delete (yypminor->yy319);
}
      break;
    case 157: /* temp */
    case 194: /* distinct */
{
delete (yypminor->yy226);
}
      break;
    case 158: /* fullname */
{
delete (yypminor->yy120);
}
      break;
    case 159: /* columnlist */
{
delete (yypminor->yy42);
}
      break;
    case 160: /* conslist_opt */
    case 184: /* conslist */
{
delete (yypminor->yy13);
}
      break;
    case 161: /* select */
{
delete (yypminor->yy153);
}
      break;
    case 162: /* column */
{
delete (yypminor->yy147);
}
      break;
    case 164: /* type */
    case 168: /* typetoken */
{
delete (yypminor->yy57);
}
      break;
    case 165: /* carglist */
{
delete (yypminor->yy371);
}
      break;
    case 170: /* signed */
    case 171: /* plus_num */
    case 172: /* minus_num */
    case 230: /* nmnum */
    case 231: /* number */
{
delete (yypminor->yy69);
}
      break;
    case 173: /* ccons */
    case 174: /* ccons_nm */
    case 175: /* carg */
{
delete (yypminor->yy304);
}
      break;
    case 176: /* sortorder */
{
delete (yypminor->yy389);
}
      break;
    case 177: /* expr */
    case 197: /* where_opt */
    case 199: /* having_opt */
    case 221: /* exprx */
    case 224: /* case_operand */
    case 226: /* case_else */
{
delete (yypminor->yy192);
}
      break;
    case 178: /* idxlist_opt */
    case 187: /* idxlist */
{
delete (yypminor->yy63);
}
      break;
    case 179: /* refargs */
{
delete (yypminor->yy264);
}
      break;
    case 180: /* defer_subclause */
    case 188: /* defer_subclause_opt */
{
delete (yypminor->yy329);
}
      break;
    case 181: /* refarg */
{
delete (yypminor->yy187);
}
      break;
    case 182: /* refact */
{
delete (yypminor->yy424);
}
      break;
    case 183: /* init_deferred_pred_opt */
{
delete (yypminor->yy312);
}
      break;
    case 185: /* tconscomma */
    case 222: /* not_opt */
    case 228: /* uniqueflag */
    case 238: /* database_kw_opt */
{
delete (yypminor->yy291);
}
      break;
    case 186: /* tcons */
{
delete (yypminor->yy406);
}
      break;
    case 192: /* oneselect */
{
delete (yypminor->yy150);
}
      break;
    case 193: /* multiselect_op */
{
delete (yypminor->yy382);
}
      break;
    case 195: /* selcollist */
    case 202: /* sclp */
{
delete (yypminor->yy213);
}
      break;
    case 196: /* from */
    case 204: /* joinsrc */
{
delete (yypminor->yy31);
}
      break;
    case 198: /* groupby_opt */
    case 213: /* nexprlist */
    case 220: /* exprlist */
    case 225: /* case_exprlist */
{
delete (yypminor->yy231);
}
      break;
    case 200: /* orderby_opt */
    case 211: /* sortlist */
{
delete (yypminor->yy243);
}
      break;
    case 201: /* limit_opt */
{
delete (yypminor->yy324);
}
      break;
    case 203: /* as */
{
delete (yypminor->yy40);
}
      break;
    case 205: /* singlesrc */
{
delete (yypminor->yy121);
}
      break;
    case 206: /* seltablist */
{
delete (yypminor->yy131);
}
      break;
    case 207: /* joinop */
{
delete (yypminor->yy221);
}
      break;
    case 208: /* joinconstr_opt */
{
delete (yypminor->yy455);
}
      break;
    case 210: /* inscollist */
    case 219: /* inscollist_opt */
{
delete (yypminor->yy207);
}
      break;
    case 212: /* collate */
{
if ((yypminor->yy319)) delete (yypminor->yy319);
}
      break;
    case 216: /* setlist */
{
delete (yypminor->yy201);
}
      break;
    case 218: /* insert_cmd */
{
delete (yypminor->yy344);
}
      break;
    case 223: /* likeop */
{
delete (yypminor->yy41);
}
      break;
    case 229: /* idxlist_single */
{
delete (yypminor->yy428);
}
      break;
    case 232: /* trigger_time */
{
delete (yypminor->yy372);
}
      break;
    case 233: /* trigger_event */
{
delete (yypminor->yy151);
}
      break;
    case 234: /* foreach_clause */
{
delete (yypminor->yy83);
}
      break;
    case 235: /* when_clause */
    case 239: /* key_opt */
{
if ((yypminor->yy192)) delete (yypminor->yy192);
}
      break;
    case 236: /* trigger_cmd_list */
{
delete (yypminor->yy270);
}
      break;
        default:  break;   /* If no destructor action specified: do nothing */
      }
  }
}

/*
** Pop the parser's stack once.
**
** If there is a destructor routine associated with the token which
** is popped from the stack, then call it.
**
** Return the major token number for the symbol popped.
*/
static int yy_pop_parser_stack(yyParser *pParser){
  YYCODETYPE yymajor;
  yyStackEntry *yytos = &pParser->yystack[pParser->yyidx];

  /* There is no mechanism by which the parser stack can be popped below
  ** empty in SQLite.  */
  if( pParser->yyidx<0 ) return 0;
#ifndef NDEBUG
  if( yyTraceFILE && pParser->yyidx>=0 ){
    fprintf(yyTraceFILE,"%sPopping %s\n",
      yyTracePrompt,
      yyTokenName[yytos->major]);
  }
#endif
  yymajor = yytos->major;
  yy_destructor(pParser, yymajor, &yytos->minor);
  delete yytos->tokens;
  yytos->tokens = nullptr;
  pParser->yyidx--;
  return yymajor;
}

/*
** Deallocate and destroy a parser.  Destructors are all called for
** all stack elements before shutting the parser down.
**
** Inputs:
** <ul>
** <li>  A pointer to the parser.  This should be a pointer
**       obtained from sqlite2_parseAlloc.
** <li>  A pointer to a function used to reclaim memory obtained
**       from malloc.
** </ul>
*/
void sqlite2_parseFree(
  void *p,                    /* The parser to be deleted */
  void (*freeProc)(void*)     /* Function used to reclaim memory */
){
  yyParser *pParser = (yyParser*)p;
  /* In SQLite, we never try to destroy a parser that was not successfully
  ** created in the first place. */
  if( pParser==0 ) return;
  while( pParser->yyidx>=0 ) yy_pop_parser_stack(pParser);
#if YYSTACKDEPTH<=0
  free(pParser->yystack);
#endif
  (*freeProc)((void*)pParser);
}

/*
** Return the peak depth of the stack for a parser.
*/
#ifdef YYTRACKMAXSTACKDEPTH
int sqlite2_parseStackPeak(void *p){
  yyParser *pParser = (yyParser*)p;
  return pParser->yyidxMax;
}
#endif

/*
** Find the appropriate action for a parser given the terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_shift_action(
  yyParser *pParser,        /* The parser */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
  int stateno = pParser->yystack[pParser->yyidx].stateno;
  GET_CONTEXT;

  if( stateno>YY_SHIFT_COUNT
   || (i = yy_shift_ofst[stateno])==YY_SHIFT_USE_DFLT ){
    return yy_default[stateno];
  }
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    if( iLookAhead>0 ){
#ifdef YYFALLBACK
      YYCODETYPE iFallback;            /* Fallback token */
      if( iLookAhead<sizeof(yyFallback)/sizeof(yyFallback[0])
             && (iFallback = yyFallback[iLookAhead])!=0
             && parserContext->doFallbacks ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE, "%sFALLBACK %s => %s\n",
             yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[iFallback]);
        }
#endif
        return yy_find_shift_action(pParser, iFallback);
      }
#endif
#ifdef YYWILDCARD
      {
        int j = i - iLookAhead + YYWILDCARD;
        if(
#if YY_SHIFT_MIN+YYWILDCARD<0
          j>=0 &&
#endif
#if YY_SHIFT_MAX+YYWILDCARD>=YY_ACTTAB_COUNT
          j<YY_ACTTAB_COUNT &&
#endif
          yy_lookahead[j]==YYWILDCARD
        ){
#ifndef NDEBUG
          if( yyTraceFILE ){
            fprintf(yyTraceFILE, "%sWILDCARD %s => %s\n",
               yyTracePrompt, yyTokenName[iLookAhead], yyTokenName[YYWILDCARD]);
          }
#endif /* NDEBUG */
          return yy_action[j];
        }
      }
#endif /* YYWILDCARD */
    }
    return yy_default[stateno];
  }else{
    return yy_action[i];
  }
}

/*
** Find the appropriate action for a parser given the non-terminal
** look-ahead token iLookAhead.
**
** If the look-ahead token is YYNOCODE, then check to see if the action is
** independent of the look-ahead.  If it is, return the action, otherwise
** return YY_NO_ACTION.
*/
static int yy_find_reduce_action(
  int stateno,              /* Current state number */
  YYCODETYPE iLookAhead     /* The look-ahead token */
){
  int i;
#ifdef YYERRORSYMBOL
  if( stateno>YY_REDUCE_COUNT ){
    return yy_default[stateno];
  }
#else
  assert( stateno<=YY_REDUCE_COUNT );
#endif
  i = yy_reduce_ofst[stateno];
  assert( i!=YY_REDUCE_USE_DFLT );
  assert( iLookAhead!=YYNOCODE );
  i += iLookAhead;
#ifdef YYERRORSYMBOL
  if( i<0 || i>=YY_ACTTAB_COUNT || yy_lookahead[i]!=iLookAhead ){
    return yy_default[stateno];
  }
#else
  assert( i>=0 && i<YY_ACTTAB_COUNT );
  assert( yy_lookahead[i]==iLookAhead );
#endif
  return yy_action[i];
}

/*
** The following routine is called if the stack overflows.
*/
static void yyStackOverflow(yyParser *yypParser, YYMINORTYPE *yypMinor){
   sqlite2_parseARG_FETCH;
   yypParser->yyidx--;
#ifndef NDEBUG
   if( yyTraceFILE ){
     fprintf(yyTraceFILE,"%sStack Overflow!\n",yyTracePrompt);
   }
#endif
   while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
   /* Here code is inserted which will execute if the parser
   ** stack every overflows */

    UNUSED_PARAMETER(yypMinor);
    parserContext->error(QObject::tr("Parser stack overflow"));
   sqlite2_parseARG_STORE; /* Suppress warning about unused %extra_argument var */
}

/*
** Perform a shift action.
*/
static void yy_shift(
  yyParser *yypParser,          /* The parser to be shifted */
  int yyNewState,               /* The new state to shift in */
  int yyMajor,                  /* The major token to shift in */
  YYMINORTYPE *yypMinor         /* Pointer to the minor token to shift in */
){
  yyStackEntry *yytos;
  yypParser->yyidx++;
#ifdef YYTRACKMAXSTACKDEPTH
  if( yypParser->yyidx>yypParser->yyidxMax ){
    yypParser->yyidxMax = yypParser->yyidx;
  }
#endif
#if YYSTACKDEPTH>0
  if( yypParser->yyidx>=YYSTACKDEPTH ){
    yyStackOverflow(yypParser, yypMinor);
    return;
  }
#else
  if( yypParser->yyidx>=yypParser->yystksz ){
    yyGrowStack(yypParser);
    if( yypParser->yyidx>=yypParser->yystksz ){
      yyStackOverflow(yypParser, yypMinor);
      return;
    }
  }
#endif
  yytos = &yypParser->yystack[yypParser->yyidx];
  yytos->stateno = (YYACTIONTYPE)yyNewState;
  yytos->major = (YYCODETYPE)yyMajor;
  yytos->minor = *yypMinor;
  yytos->tokens = new QList<Token*>();
#ifndef NDEBUG
  if( yyTraceFILE && yypParser->yyidx>0 ){
    int i;
    fprintf(yyTraceFILE,"%sShift %d\n",yyTracePrompt,yyNewState);
    fprintf(yyTraceFILE,"%sStack:",yyTracePrompt);
    for(i=1; i<=yypParser->yyidx; i++)
      fprintf(yyTraceFILE," %s",yyTokenName[yypParser->yystack[i].major]);
    fprintf(yyTraceFILE,"\n");
  }
#endif
}

/* The following table contains information about every rule that
** is used during the reduce.
*/
static const struct {
  YYCODETYPE lhs;         /* Symbol on the left-hand side of the rule */
  unsigned char nrhs;     /* Number of right-hand side symbols in the rule */
} yyRuleInfo[] = {
  { 149, 1 },
  { 150, 2 },
  { 150, 1 },
  { 151, 1 },
  { 151, 3 },
  { 152, 0 },
  { 152, 1 },
  { 153, 1 },
  { 148, 3 },
  { 154, 0 },
  { 154, 1 },
  { 154, 2 },
  { 154, 2 },
  { 148, 2 },
  { 148, 2 },
  { 148, 2 },
  { 148, 8 },
  { 148, 6 },
  { 148, 6 },
  { 148, 4 },
  { 157, 1 },
  { 157, 0 },
  { 159, 3 },
  { 159, 1 },
  { 162, 3 },
  { 163, 1 },
  { 163, 1 },
  { 166, 1 },
  { 167, 1 },
  { 156, 1 },
  { 156, 1 },
  { 156, 1 },
  { 164, 0 },
  { 164, 1 },
  { 168, 1 },
  { 168, 4 },
  { 168, 6 },
  { 169, 1 },
  { 169, 2 },
  { 169, 1 },
  { 170, 1 },
  { 170, 1 },
  { 165, 2 },
  { 165, 3 },
  { 165, 2 },
  { 165, 0 },
  { 175, 2 },
  { 175, 2 },
  { 175, 2 },
  { 175, 3 },
  { 175, 3 },
  { 175, 2 },
  { 175, 3 },
  { 175, 3 },
  { 175, 2 },
  { 174, 2 },
  { 173, 2 },
  { 173, 3 },
  { 173, 4 },
  { 173, 2 },
  { 173, 5 },
  { 173, 4 },
  { 173, 1 },
  { 173, 2 },
  { 173, 3 },
  { 179, 0 },
  { 179, 2 },
  { 181, 2 },
  { 181, 3 },
  { 181, 3 },
  { 181, 3 },
  { 181, 2 },
  { 182, 2 },
  { 182, 2 },
  { 182, 1 },
  { 182, 1 },
  { 180, 3 },
  { 180, 2 },
  { 183, 0 },
  { 183, 2 },
  { 183, 2 },
  { 160, 0 },
  { 160, 2 },
  { 184, 3 },
  { 184, 1 },
  { 185, 1 },
  { 185, 0 },
  { 186, 2 },
  { 186, 6 },
  { 186, 5 },
  { 186, 5 },
  { 186, 10 },
  { 186, 2 },
  { 186, 7 },
  { 186, 4 },
  { 188, 0 },
  { 188, 1 },
  { 155, 0 },
  { 155, 3 },
  { 190, 0 },
  { 190, 2 },
  { 189, 1 },
  { 189, 1 },
  { 189, 1 },
  { 189, 1 },
  { 189, 1 },
  { 148, 3 },
  { 148, 5 },
  { 148, 3 },
  { 148, 6 },
  { 148, 4 },
  { 148, 3 },
  { 148, 3 },
  { 148, 1 },
  { 191, 1 },
  { 161, 1 },
  { 161, 3 },
  { 193, 1 },
  { 193, 2 },
  { 193, 1 },
  { 193, 1 },
  { 192, 9 },
  { 194, 1 },
  { 194, 1 },
  { 194, 0 },
  { 202, 2 },
  { 202, 0 },
  { 195, 3 },
  { 195, 2 },
  { 195, 4 },
  { 195, 1 },
  { 195, 4 },
  { 203, 2 },
  { 203, 1 },
  { 203, 2 },
  { 203, 1 },
  { 203, 0 },
  { 196, 0 },
  { 196, 2 },
  { 204, 2 },
  { 204, 0 },
  { 206, 4 },
  { 206, 0 },
  { 205, 3 },
  { 205, 4 },
  { 205, 4 },
  { 205, 0 },
  { 205, 2 },
  { 205, 3 },
  { 205, 1 },
  { 205, 3 },
  { 205, 1 },
  { 208, 2 },
  { 208, 4 },
  { 208, 0 },
  { 209, 0 },
  { 209, 2 },
  { 158, 2 },
  { 207, 1 },
  { 207, 1 },
  { 207, 2 },
  { 207, 3 },
  { 207, 4 },
  { 207, 1 },
  { 200, 0 },
  { 200, 3 },
  { 211, 5 },
  { 211, 3 },
  { 212, 0 },
  { 212, 2 },
  { 176, 1 },
  { 176, 1 },
  { 176, 0 },
  { 198, 0 },
  { 198, 3 },
  { 198, 2 },
  { 199, 0 },
  { 199, 2 },
  { 201, 0 },
  { 201, 2 },
  { 201, 4 },
  { 201, 4 },
  { 148, 1 },
  { 214, 4 },
  { 214, 2 },
  { 214, 4 },
  { 214, 5 },
  { 214, 3 },
  { 197, 0 },
  { 197, 2 },
  { 197, 1 },
  { 148, 1 },
  { 215, 6 },
  { 215, 2 },
  { 215, 4 },
  { 215, 5 },
  { 215, 3 },
  { 216, 5 },
  { 216, 3 },
  { 216, 0 },
  { 216, 2 },
  { 216, 3 },
  { 216, 1 },
  { 148, 1 },
  { 217, 8 },
  { 217, 5 },
  { 217, 2 },
  { 217, 4 },
  { 217, 3 },
  { 217, 5 },
  { 218, 2 },
  { 218, 1 },
  { 219, 0 },
  { 219, 3 },
  { 210, 3 },
  { 210, 1 },
  { 210, 0 },
  { 210, 3 },
  { 210, 1 },
  { 221, 1 },
  { 221, 1 },
  { 221, 1 },
  { 221, 1 },
  { 221, 3 },
  { 221, 1 },
  { 221, 1 },
  { 221, 3 },
  { 221, 5 },
  { 221, 1 },
  { 221, 4 },
  { 221, 4 },
  { 221, 3 },
  { 221, 3 },
  { 221, 3 },
  { 221, 3 },
  { 221, 3 },
  { 221, 3 },
  { 221, 3 },
  { 221, 3 },
  { 221, 4 },
  { 221, 2 },
  { 221, 3 },
  { 221, 4 },
  { 221, 2 },
  { 221, 2 },
  { 221, 2 },
  { 221, 2 },
  { 221, 6 },
  { 221, 6 },
  { 221, 6 },
  { 221, 5 },
  { 221, 3 },
  { 221, 5 },
  { 221, 6 },
  { 221, 4 },
  { 221, 2 },
  { 221, 4 },
  { 221, 5 },
  { 221, 4 },
  { 221, 5 },
  { 221, 4 },
  { 221, 6 },
  { 221, 1 },
  { 221, 3 },
  { 221, 5 },
  { 221, 6 },
  { 177, 1 },
  { 177, 0 },
  { 222, 0 },
  { 222, 1 },
  { 223, 1 },
  { 225, 5 },
  { 225, 4 },
  { 226, 2 },
  { 226, 0 },
  { 224, 1 },
  { 224, 0 },
  { 220, 1 },
  { 220, 0 },
  { 213, 3 },
  { 213, 1 },
  { 148, 11 },
  { 148, 7 },
  { 148, 6 },
  { 148, 4 },
  { 228, 1 },
  { 228, 0 },
  { 178, 0 },
  { 178, 3 },
  { 187, 3 },
  { 187, 1 },
  { 229, 2 },
  { 229, 1 },
  { 148, 3 },
  { 148, 5 },
  { 148, 3 },
  { 148, 9 },
  { 148, 6 },
  { 148, 1 },
  { 148, 2 },
  { 148, 2 },
  { 148, 4 },
  { 148, 5 },
  { 148, 4 },
  { 148, 5 },
  { 148, 4 },
  { 148, 2 },
  { 230, 1 },
  { 230, 1 },
  { 230, 1 },
  { 230, 1 },
  { 230, 1 },
  { 171, 2 },
  { 171, 1 },
  { 172, 2 },
  { 231, 1 },
  { 231, 1 },
  { 148, 14 },
  { 148, 11 },
  { 148, 13 },
  { 148, 8 },
  { 148, 10 },
  { 148, 4 },
  { 232, 1 },
  { 232, 1 },
  { 232, 2 },
  { 232, 0 },
  { 233, 1 },
  { 233, 1 },
  { 233, 1 },
  { 233, 3 },
  { 234, 0 },
  { 234, 3 },
  { 234, 3 },
  { 235, 0 },
  { 235, 2 },
  { 236, 3 },
  { 236, 2 },
  { 237, 1 },
  { 237, 1 },
  { 237, 1 },
  { 237, 1 },
  { 227, 1 },
  { 148, 3 },
  { 148, 5 },
  { 148, 3 },
  { 148, 6 },
  { 239, 0 },
  { 239, 2 },
  { 238, 1 },
  { 238, 0 },
  { 148, 3 },
};

static void yy_accept(yyParser*);  /* Forward Declaration */

/*
** Perform a reduce action and the shift that must immediately
** follow the reduce.
*/
static void yy_reduce(
  yyParser *yypParser,         /* The parser */
  int yyruleno                 /* Number of the rule by which to reduce */
){
  int yygoto;                     /* The next state */
  int yyact;                      /* The next action */
  YYMINORTYPE yygotominor;        /* The LHS of the rule reduced */
  yyStackEntry *yymsp;            /* The top of the parser's stack */
  int yysize;                     /* Amount to pop the stack */
  sqlite2_parseARG_FETCH;
  SqliteStatement* objectForTokens = 0;
  QStringList noTokenInheritanceFields;
  yymsp = &yypParser->yystack[yypParser->yyidx];
#ifndef NDEBUG
  if( yyTraceFILE && yyruleno>=0
        && yyruleno<(int)(sizeof(yyRuleName)/sizeof(yyRuleName[0])) ){
    fprintf(yyTraceFILE, "%sReduce [%s].\n", yyTracePrompt,
      yyRuleName[yyruleno]);
  }
#endif /* NDEBUG */

  /* Silence complaints from purify about yygotominor being uninitialized
  ** in some cases when it is copied into the stack after the following
  ** switch.  yygotominor is uninitialized when a rule reduces that does
  ** not set the value of its left-hand side nonterminal.  Leaving the
  ** value of the nonterminal uninitialized is utterly harmless as long
  ** as the value is never used.  So really the only thing this code
  ** accomplishes is to quieten purify.
  **
  ** 2007-01-16:  The wireshark project (www.wireshark.org) reports that
  ** without this code, their parser segfaults.  I'm not sure what there
  ** parser is doing to make this happen.  This is the second bug report
  ** from wireshark this week.  Clearly they are stressing Lemon in ways
  ** that it has not been previously stressed...  (SQLite ticket #2172)
  */
  /*memset(&yygotominor, 0, sizeof(yygotominor));*/
  yygotominor = yyzerominor;


  if (parserContext->executeRules)
  {
      switch( yyruleno ){
      /* Beginning here are the reduction cases.  A typical example
      ** follows:
      **   case 0:
      **  #line <lineno> <grammarfile>
      **     { ... }           // User supplied code
      **  #line <lineno> <thisfile>
      **     break;
      */
      case 1: /* cmdlist ::= cmdlist ecmd */
{parserContext->addQuery(yymsp[0].minor.yy203); DONT_INHERIT_TOKENS("cmdlist");}
        break;
      case 2: /* cmdlist ::= ecmd */
{parserContext->addQuery(yymsp[0].minor.yy203);}
        break;
      case 3: /* ecmd ::= SEMI */
{yygotominor.yy203 = new SqliteEmptyQuery();}
        break;
      case 4: /* ecmd ::= explain cmdx SEMI */
{
                                                yygotominor.yy203 = yymsp[-1].minor.yy203;
                                                yygotominor.yy203->explain = yymsp[-2].minor.yy91->explain;
                                                yygotominor.yy203->queryPlan = yymsp[-2].minor.yy91->queryPlan;
                                                delete yymsp[-2].minor.yy91;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 5: /* explain ::= */
{yygotominor.yy91 = new ParserStubExplain(false, false);}
        break;
      case 6: /* explain ::= EXPLAIN */
{yygotominor.yy91 = new ParserStubExplain(true, false);}
        break;
      case 7: /* cmdx ::= cmd */
      case 338: /* trigger_cmd ::= update_stmt */ yytestcase(yyruleno==338);
      case 339: /* trigger_cmd ::= insert_stmt */ yytestcase(yyruleno==339);
      case 340: /* trigger_cmd ::= delete_stmt */ yytestcase(yyruleno==340);
      case 341: /* trigger_cmd ::= select_stmt */ yytestcase(yyruleno==341);
{yygotominor.yy203 = yymsp[0].minor.yy203;}
        break;
      case 8: /* cmd ::= BEGIN trans_opt onconf */
{
                                                yygotominor.yy203 = new SqliteBeginTrans(
                                                        yymsp[-1].minor.yy404->transactionKw,
                                                        yymsp[-1].minor.yy404->name,
                                                        *(yymsp[0].minor.yy418)
                                                    );
                                                delete yymsp[-1].minor.yy404;
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 9: /* trans_opt ::= */
{yygotominor.yy404 = new ParserStubTransDetails();}
        break;
      case 10: /* trans_opt ::= TRANSACTION */
{
                                                yygotominor.yy404 = new ParserStubTransDetails();
                                                yygotominor.yy404->transactionKw = true;
                                            }
        break;
      case 11: /* trans_opt ::= TRANSACTION nm */
      case 12: /* trans_opt ::= TRANSACTION ID_TRANS */ yytestcase(yyruleno==12);
{
                                                yygotominor.yy404 = new ParserStubTransDetails();
                                                yygotominor.yy404->transactionKw = true;
                                                yygotominor.yy404->name = *(yymsp[0].minor.yy319);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 13: /* cmd ::= COMMIT trans_opt */
{
                                                yygotominor.yy203 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy404->transactionKw,
                                                        yymsp[0].minor.yy404->name,
                                                        false
                                                    );
                                                delete yymsp[0].minor.yy404;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 14: /* cmd ::= END trans_opt */
{
                                                yygotominor.yy203 = new SqliteCommitTrans(
                                                        yymsp[0].minor.yy404->transactionKw,
                                                        yymsp[0].minor.yy404->name,
                                                        true
                                                    );
                                                delete yymsp[0].minor.yy404;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 15: /* cmd ::= ROLLBACK trans_opt */
{
                                                yygotominor.yy203 = new SqliteRollback(
                                                        yymsp[0].minor.yy404->transactionKw,
                                                        yymsp[0].minor.yy404->name
                                                    );
                                                delete yymsp[0].minor.yy404;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 16: /* cmd ::= CREATE temp TABLE fullname LP columnlist conslist_opt RP */
{
                                                yygotominor.yy203 = new SqliteCreateTable(
                                                        false,
                                                        *(yymsp[-6].minor.yy226),
                                                        yymsp[-4].minor.yy120->name1,
                                                        yymsp[-4].minor.yy120->name2,
                                                        *(yymsp[-2].minor.yy42),
                                                        *(yymsp[-1].minor.yy13)
                                                    );
                                                delete yymsp[-6].minor.yy226;
                                                delete yymsp[-2].minor.yy42;
                                                delete yymsp[-1].minor.yy13;
                                                delete yymsp[-4].minor.yy120;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 17: /* cmd ::= CREATE temp TABLE fullname AS select */
{
                                                yygotominor.yy203 = new SqliteCreateTable(
                                                        false,
                                                        *(yymsp[-4].minor.yy226),
                                                        yymsp[-2].minor.yy120->name1,
                                                        yymsp[-2].minor.yy120->name2,
                                                        yymsp[0].minor.yy153
                                                    );
                                                delete yymsp[-4].minor.yy226;
                                                delete yymsp[-2].minor.yy120;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 18: /* cmd ::= CREATE temp TABLE nm DOT ID_TAB_NEW */
{  yy_destructor(yypParser,157,&yymsp[-4].minor);
  yy_destructor(yypParser,156,&yymsp[-2].minor);
}
        break;
      case 19: /* cmd ::= CREATE temp TABLE ID_DB|ID_TAB_NEW */
      case 110: /* cmd ::= CREATE temp VIEW ID_VIEW_NEW */ yytestcase(yyruleno==110);
      case 322: /* cmd ::= CREATE temp TRIGGER ID_TRIG_NEW */ yytestcase(yyruleno==322);
{  yy_destructor(yypParser,157,&yymsp[-2].minor);
}
        break;
      case 20: /* temp ::= TEMP */
{yygotominor.yy226 = new int( (yymsp[0].minor.yy0->value.length() > 4) ? 2 : 1 );}
        break;
      case 21: /* temp ::= */
      case 124: /* distinct ::= */ yytestcase(yyruleno==124);
{yygotominor.yy226 = new int(0);}
        break;
      case 22: /* columnlist ::= columnlist COMMA column */
{
                                                yymsp[-2].minor.yy42->append(yymsp[0].minor.yy147);
                                                yygotominor.yy42 = yymsp[-2].minor.yy42;
                                                DONT_INHERIT_TOKENS("columnlist");
                                            }
        break;
      case 23: /* columnlist ::= column */
{
                                                yygotominor.yy42 = new ParserCreateTableColumnList();
                                                yygotominor.yy42->append(yymsp[0].minor.yy147);
                                            }
        break;
      case 24: /* column ::= columnid type carglist */
{
                                                yygotominor.yy147 = new SqliteCreateTable::Column(*(yymsp[-2].minor.yy319), yymsp[-1].minor.yy57, *(yymsp[0].minor.yy371));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy371;
                                                objectForTokens = yygotominor.yy147;
                                            }
        break;
      case 25: /* columnid ::= nm */
      case 26: /* columnid ::= ID_COL_NEW */ yytestcase(yyruleno==26);
      case 29: /* nm ::= id */ yytestcase(yyruleno==29);
      case 37: /* typename ::= ids */ yytestcase(yyruleno==37);
      case 156: /* dbnm ::= DOT nm */ yytestcase(yyruleno==156);
      case 169: /* collate ::= COLLATE id */ yytestcase(yyruleno==169);
{yygotominor.yy319 = yymsp[0].minor.yy319;}
        break;
      case 27: /* id ::= ID */
{
                                                yygotominor.yy319 = new QString(
                                                    stripObjName(
                                                        yymsp[0].minor.yy0->value,
                                                        parserContext->dialect
                                                    )
                                                );
                                            }
        break;
      case 28: /* ids ::= ID|STRING */
      case 31: /* nm ::= JOIN_KW */ yytestcase(yyruleno==31);
{yygotominor.yy319 = new QString(yymsp[0].minor.yy0->value);}
        break;
      case 30: /* nm ::= STRING */
{yygotominor.yy319 = new QString(stripString(yymsp[0].minor.yy0->value));}
        break;
      case 32: /* type ::= */
{yygotominor.yy57 = nullptr;}
        break;
      case 33: /* type ::= typetoken */
{yygotominor.yy57 = yymsp[0].minor.yy57;}
        break;
      case 34: /* typetoken ::= typename */
{
                                                yygotominor.yy57 = new SqliteColumnType(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy57;
                                            }
        break;
      case 35: /* typetoken ::= typename LP signed RP */
{
                                                yygotominor.yy57 = new SqliteColumnType(*(yymsp[-3].minor.yy319), *(yymsp[-1].minor.yy69));
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy69;
                                                objectForTokens = yygotominor.yy57;
                                            }
        break;
      case 36: /* typetoken ::= typename LP signed COMMA signed RP */
{
                                                yygotominor.yy57 = new SqliteColumnType(*(yymsp[-5].minor.yy319), *(yymsp[-3].minor.yy69), *(yymsp[-1].minor.yy69));
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-3].minor.yy69;
                                                delete yymsp[-1].minor.yy69;
                                                objectForTokens = yygotominor.yy57;
                                            }
        break;
      case 38: /* typename ::= typename ids */
      case 39: /* typename ::= ID_COL_TYPE */ yytestcase(yyruleno==39);
{
                                                yymsp[-1].minor.yy319->append(" " + *(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                yygotominor.yy319 = yymsp[-1].minor.yy319;
                                            }
        break;
      case 40: /* signed ::= plus_num */
      case 41: /* signed ::= minus_num */ yytestcase(yyruleno==41);
      case 307: /* nmnum ::= plus_num */ yytestcase(yyruleno==307);
      case 312: /* plus_num ::= PLUS number */ yytestcase(yyruleno==312);
      case 313: /* plus_num ::= number */ yytestcase(yyruleno==313);
{yygotominor.yy69 = yymsp[0].minor.yy69;}
        break;
      case 42: /* carglist ::= carglist ccons */
      case 44: /* carglist ::= carglist carg */ yytestcase(yyruleno==44);
{
                                                yymsp[-1].minor.yy371->append(yymsp[0].minor.yy304);
                                                yygotominor.yy371 = yymsp[-1].minor.yy371;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 43: /* carglist ::= carglist ccons_nm ccons */
{
                                                yymsp[-2].minor.yy371->append(yymsp[-1].minor.yy304);
                                                yymsp[-2].minor.yy371->append(yymsp[0].minor.yy304);
                                                yygotominor.yy371 = yymsp[-2].minor.yy371;
                                                DONT_INHERIT_TOKENS("carglist");
                                            }
        break;
      case 45: /* carglist ::= */
{yygotominor.yy371 = new ParserCreateTableColumnConstraintList();}
        break;
      case 46: /* carg ::= DEFAULT STRING */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefId(stripObjName(
                                                    yymsp[0].minor.yy0->value,
                                                    parserContext->dialect
                                                ));
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 47: /* carg ::= DEFAULT ID */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefId(stripObjName(
                                                    yymsp[0].minor.yy0->value,
                                                    parserContext->dialect
                                                ));
                                                objectForTokens = yygotominor.yy304;

                                            }
        break;
      case 48: /* carg ::= DEFAULT INTEGER */
      case 49: /* carg ::= DEFAULT PLUS INTEGER */ yytestcase(yyruleno==49);
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                QVariant val = QVariant(yymsp[0].minor.yy0->value).toLongLong();
                                                yygotominor.yy304->initDefTerm(val, false);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 50: /* carg ::= DEFAULT MINUS INTEGER */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                QVariant val = QVariant(yymsp[0].minor.yy0->value).toLongLong();
                                                yygotominor.yy304->initDefTerm(val, true);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 51: /* carg ::= DEFAULT FLOAT */
      case 52: /* carg ::= DEFAULT PLUS FLOAT */ yytestcase(yyruleno==52);
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                QVariant val = QVariant(yymsp[0].minor.yy0->value).toDouble();
                                                yygotominor.yy304->initDefTerm(val, false);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 53: /* carg ::= DEFAULT MINUS FLOAT */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                QVariant val = QVariant(yymsp[0].minor.yy0->value).toDouble();
                                                yygotominor.yy304->initDefTerm(val, true);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 54: /* carg ::= DEFAULT NULL */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefTerm(QVariant(), false);
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 55: /* ccons_nm ::= CONSTRAINT nm */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefNameOnly(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 56: /* ccons ::= NULL onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initNull(*(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 57: /* ccons ::= NOT NULL onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initNotNull(*(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 58: /* ccons ::= PRIMARY KEY sortorder onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initPk(*(yymsp[-1].minor.yy389), *(yymsp[0].minor.yy418), false);
                                                delete yymsp[-1].minor.yy389;
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 59: /* ccons ::= UNIQUE onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initUnique(*(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 60: /* ccons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initCheck(yymsp[-2].minor.yy192, *(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 61: /* ccons ::= REFERENCES nm idxlist_opt refargs */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initFk(*(yymsp[-2].minor.yy319), *(yymsp[-1].minor.yy63), *(yymsp[0].minor.yy264));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy264;
                                                delete yymsp[-1].minor.yy63;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 62: /* ccons ::= defer_subclause */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initDefer(yymsp[0].minor.yy329->initially, yymsp[0].minor.yy329->deferrable);
                                                delete yymsp[0].minor.yy329;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 63: /* ccons ::= COLLATE id */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initColl(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy304;
                                            }
        break;
      case 64: /* ccons ::= CHECK LP RP */
{
                                                yygotominor.yy304 = new SqliteCreateTable::Column::Constraint();
                                                yygotominor.yy304->initCheck();
                                                objectForTokens = yygotominor.yy304;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 65: /* refargs ::= */
{yygotominor.yy264 = new ParserFkConditionList();}
        break;
      case 66: /* refargs ::= refargs refarg */
{
                                                yymsp[-1].minor.yy264->append(yymsp[0].minor.yy187);
                                                yygotominor.yy264 = yymsp[-1].minor.yy264;
                                                DONT_INHERIT_TOKENS("refargs");
                                            }
        break;
      case 67: /* refarg ::= MATCH nm */
{
                                                yygotominor.yy187 = new SqliteForeignKey::Condition(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 68: /* refarg ::= ON INSERT refact */
{yygotominor.yy187 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::INSERT, *(yymsp[0].minor.yy424)); delete yymsp[0].minor.yy424;}
        break;
      case 69: /* refarg ::= ON DELETE refact */
{yygotominor.yy187 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::DELETE, *(yymsp[0].minor.yy424)); delete yymsp[0].minor.yy424;}
        break;
      case 70: /* refarg ::= ON UPDATE refact */
      case 71: /* refarg ::= MATCH ID_FK_MATCH */ yytestcase(yyruleno==71);
{yygotominor.yy187 = new SqliteForeignKey::Condition(SqliteForeignKey::Condition::UPDATE, *(yymsp[0].minor.yy424)); delete yymsp[0].minor.yy424;}
        break;
      case 72: /* refact ::= SET NULL */
{yygotominor.yy424 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_NULL);}
        break;
      case 73: /* refact ::= SET DEFAULT */
{yygotominor.yy424 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::SET_DEFAULT);}
        break;
      case 74: /* refact ::= CASCADE */
{yygotominor.yy424 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::CASCADE);}
        break;
      case 75: /* refact ::= RESTRICT */
{yygotominor.yy424 = new SqliteForeignKey::Condition::Reaction(SqliteForeignKey::Condition::RESTRICT);}
        break;
      case 76: /* defer_subclause ::= NOT DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy329 = new ParserDeferSubClause(SqliteDeferrable::NOT_DEFERRABLE, *(yymsp[0].minor.yy312));
                                                delete yymsp[0].minor.yy312;
                                            }
        break;
      case 77: /* defer_subclause ::= DEFERRABLE init_deferred_pred_opt */
{
                                                yygotominor.yy329 = new ParserDeferSubClause(SqliteDeferrable::DEFERRABLE, *(yymsp[0].minor.yy312));
                                                delete yymsp[0].minor.yy312;
                                            }
        break;
      case 78: /* init_deferred_pred_opt ::= */
{yygotominor.yy312 = new SqliteInitially(SqliteInitially::null);}
        break;
      case 79: /* init_deferred_pred_opt ::= INITIALLY DEFERRED */
{yygotominor.yy312 = new SqliteInitially(SqliteInitially::DEFERRED);}
        break;
      case 80: /* init_deferred_pred_opt ::= INITIALLY IMMEDIATE */
{yygotominor.yy312 = new SqliteInitially(SqliteInitially::IMMEDIATE);}
        break;
      case 81: /* conslist_opt ::= */
{yygotominor.yy13 = new ParserCreateTableConstraintList();}
        break;
      case 82: /* conslist_opt ::= COMMA conslist */
{yygotominor.yy13 = yymsp[0].minor.yy13;}
        break;
      case 83: /* conslist ::= conslist tconscomma tcons */
{
                                                yymsp[0].minor.yy406->afterComma = *(yymsp[-1].minor.yy291);
                                                yymsp[-2].minor.yy13->append(yymsp[0].minor.yy406);
                                                yygotominor.yy13 = yymsp[-2].minor.yy13;
                                                delete yymsp[-1].minor.yy291;
                                                DONT_INHERIT_TOKENS("conslist");
                                            }
        break;
      case 84: /* conslist ::= tcons */
{
                                                yygotominor.yy13 = new ParserCreateTableConstraintList();
                                                yygotominor.yy13->append(yymsp[0].minor.yy406);
                                            }
        break;
      case 85: /* tconscomma ::= COMMA */
      case 269: /* not_opt ::= NOT */ yytestcase(yyruleno==269);
      case 285: /* uniqueflag ::= UNIQUE */ yytestcase(yyruleno==285);
      case 349: /* database_kw_opt ::= DATABASE */ yytestcase(yyruleno==349);
{yygotominor.yy291 = new bool(true);}
        break;
      case 86: /* tconscomma ::= */
      case 268: /* not_opt ::= */ yytestcase(yyruleno==268);
      case 286: /* uniqueflag ::= */ yytestcase(yyruleno==286);
      case 350: /* database_kw_opt ::= */ yytestcase(yyruleno==350);
{yygotominor.yy291 = new bool(false);}
        break;
      case 87: /* tcons ::= CONSTRAINT nm */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initNameOnly(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 88: /* tcons ::= PRIMARY KEY LP idxlist RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initPk(*(yymsp[-2].minor.yy63), false, *(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                delete yymsp[-2].minor.yy63;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 89: /* tcons ::= UNIQUE LP idxlist RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initUnique(*(yymsp[-2].minor.yy63), *(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                                delete yymsp[-2].minor.yy63;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 90: /* tcons ::= CHECK LP expr RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initCheck(yymsp[-2].minor.yy192, *(yymsp[0].minor.yy418));
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 91: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES nm idxlist_opt refargs defer_subclause_opt */
      case 92: /* tcons ::= CONSTRAINT ID_CONSTR */ yytestcase(yyruleno==92);
      case 93: /* tcons ::= FOREIGN KEY LP idxlist RP REFERENCES ID_TAB */ yytestcase(yyruleno==93);
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initFk(
                                                    *(yymsp[-6].minor.yy63),
                                                    *(yymsp[-3].minor.yy319),
                                                    *(yymsp[-2].minor.yy63),
                                                    *(yymsp[-1].minor.yy264),
                                                    yymsp[0].minor.yy329->initially,
                                                    yymsp[0].minor.yy329->deferrable
                                                );
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy264;
                                                delete yymsp[0].minor.yy329;
                                                delete yymsp[-2].minor.yy63;
                                                delete yymsp[-6].minor.yy63;
                                                objectForTokens = yygotominor.yy406;
                                            }
        break;
      case 94: /* tcons ::= CHECK LP RP onconf */
{
                                                yygotominor.yy406 = new SqliteCreateTable::Constraint();
                                                yygotominor.yy406->initCheck();
                                                objectForTokens = yygotominor.yy406;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                              yy_destructor(yypParser,155,&yymsp[0].minor);
}
        break;
      case 95: /* defer_subclause_opt ::= */
{yygotominor.yy329 = new ParserDeferSubClause(SqliteDeferrable::null, SqliteInitially::null);}
        break;
      case 96: /* defer_subclause_opt ::= defer_subclause */
{yygotominor.yy329 = yymsp[0].minor.yy329;}
        break;
      case 97: /* onconf ::= */
      case 99: /* orconf ::= */ yytestcase(yyruleno==99);
{yygotominor.yy418 = new SqliteConflictAlgo(SqliteConflictAlgo::null);}
        break;
      case 98: /* onconf ::= ON CONFLICT resolvetype */
      case 100: /* orconf ::= OR resolvetype */ yytestcase(yyruleno==100);
{yygotominor.yy418 = yymsp[0].minor.yy418;}
        break;
      case 101: /* resolvetype ::= ROLLBACK */
      case 102: /* resolvetype ::= ABORT */ yytestcase(yyruleno==102);
      case 103: /* resolvetype ::= FAIL */ yytestcase(yyruleno==103);
      case 104: /* resolvetype ::= IGNORE */ yytestcase(yyruleno==104);
      case 105: /* resolvetype ::= REPLACE */ yytestcase(yyruleno==105);
{yygotominor.yy418 = new SqliteConflictAlgo(sqliteConflictAlgo(yymsp[0].minor.yy0->value));}
        break;
      case 106: /* cmd ::= DROP TABLE fullname */
{
                                                yygotominor.yy203 = new SqliteDropTable(false, yymsp[0].minor.yy120->name1, yymsp[0].minor.yy120->name2);
                                                delete yymsp[0].minor.yy120;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 107: /* cmd ::= DROP TABLE nm DOT ID_TAB */
      case 108: /* cmd ::= DROP TABLE ID_DB|ID_TAB */ yytestcase(yyruleno==108);
      case 148: /* singlesrc ::= nm DOT ID_TAB */ yytestcase(yyruleno==148);
      case 149: /* singlesrc ::= ID_DB|ID_TAB */ yytestcase(yyruleno==149);
      case 150: /* singlesrc ::= nm DOT ID_VIEW */ yytestcase(yyruleno==150);
      case 151: /* singlesrc ::= ID_DB|ID_VIEW */ yytestcase(yyruleno==151);
      case 186: /* delete_stmt ::= DELETE FROM nm DOT ID_TAB */ yytestcase(yyruleno==186);
      case 187: /* delete_stmt ::= DELETE FROM ID_DB|ID_TAB */ yytestcase(yyruleno==187);
      case 195: /* update_stmt ::= UPDATE orconf nm DOT ID_TAB */ yytestcase(yyruleno==195);
      case 196: /* update_stmt ::= UPDATE orconf ID_DB|ID_TAB */ yytestcase(yyruleno==196);
      case 263: /* exprx ::= nm DOT ID_TAB|ID_COL */ yytestcase(yyruleno==263);
      case 283: /* cmd ::= CREATE uniqueflag INDEX nm DOT ID_IDX_NEW */ yytestcase(yyruleno==283);
      case 284: /* cmd ::= CREATE uniqueflag INDEX ID_DB|ID_IDX_NEW */ yytestcase(yyruleno==284);
      case 294: /* cmd ::= DROP INDEX nm DOT ID_IDX */ yytestcase(yyruleno==294);
      case 295: /* cmd ::= DROP INDEX ID_DB|ID_IDX */ yytestcase(yyruleno==295);
      case 305: /* cmd ::= PRAGMA nm DOT ID_PRAGMA */ yytestcase(yyruleno==305);
      case 306: /* cmd ::= PRAGMA ID_DB|ID_PRAGMA */ yytestcase(yyruleno==306);
      case 344: /* cmd ::= DROP TRIGGER nm DOT ID_TRIG */ yytestcase(yyruleno==344);
      case 345: /* cmd ::= DROP TRIGGER ID_DB|ID_TRIG */ yytestcase(yyruleno==345);
{  yy_destructor(yypParser,156,&yymsp[-2].minor);
}
        break;
      case 109: /* cmd ::= CREATE temp VIEW nm AS select */
{
                                                yygotominor.yy203 = new SqliteCreateView(*(yymsp[-4].minor.yy226), false, *(yymsp[-2].minor.yy319), QString::null, yymsp[0].minor.yy153);
                                                delete yymsp[-4].minor.yy226;
                                                delete yymsp[-2].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 111: /* cmd ::= DROP VIEW nm */
      case 112: /* cmd ::= DROP VIEW ID_VIEW */ yytestcase(yyruleno==112);
{
                                                yygotominor.yy203 = new SqliteDropView(false, *(yymsp[0].minor.yy319), QString::null);
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 113: /* cmd ::= select_stmt */
      case 182: /* cmd ::= delete_stmt */ yytestcase(yyruleno==182);
      case 191: /* cmd ::= update_stmt */ yytestcase(yyruleno==191);
      case 203: /* cmd ::= insert_stmt */ yytestcase(yyruleno==203);
{
                                                yygotominor.yy203 = yymsp[0].minor.yy203;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 114: /* select_stmt ::= select */
{
                                                yygotominor.yy203 = yymsp[0].minor.yy153;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 115: /* select ::= oneselect */
{
                                                yygotominor.yy153 = SqliteSelect::append(yymsp[0].minor.yy150);
                                                objectForTokens = yygotominor.yy153;
                                            }
        break;
      case 116: /* select ::= select multiselect_op oneselect */
{
                                                yygotominor.yy153 = SqliteSelect::append(yymsp[-2].minor.yy153, *(yymsp[-1].minor.yy382), yymsp[0].minor.yy150);
                                                delete yymsp[-1].minor.yy382;
                                                objectForTokens = yygotominor.yy153;
                                            }
        break;
      case 117: /* multiselect_op ::= UNION */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION);}
        break;
      case 118: /* multiselect_op ::= UNION ALL */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::UNION_ALL);}
        break;
      case 119: /* multiselect_op ::= EXCEPT */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::EXCEPT);}
        break;
      case 120: /* multiselect_op ::= INTERSECT */
{yygotominor.yy382 = new SqliteSelect::CompoundOperator(SqliteSelect::CompoundOperator::INTERSECT);}
        break;
      case 121: /* oneselect ::= SELECT distinct selcollist from where_opt groupby_opt having_opt orderby_opt limit_opt */
{
                                                yygotominor.yy150 = new SqliteSelect::Core(
                                                        *(yymsp[-7].minor.yy226),
                                                        *(yymsp[-6].minor.yy213),
                                                        yymsp[-5].minor.yy31,
                                                        yymsp[-4].minor.yy192,
                                                        *(yymsp[-3].minor.yy231),
                                                        yymsp[-2].minor.yy192,
                                                        *(yymsp[-1].minor.yy243),
                                                        yymsp[0].minor.yy324
                                                    );
                                                delete yymsp[-6].minor.yy213;
                                                delete yymsp[-7].minor.yy226;
                                                delete yymsp[-3].minor.yy231;
                                                delete yymsp[-1].minor.yy243;
                                                objectForTokens = yygotominor.yy150;
                                            }
        break;
      case 122: /* distinct ::= DISTINCT */
{yygotominor.yy226 = new int(1);}
        break;
      case 123: /* distinct ::= ALL */
{yygotominor.yy226 = new int(2);}
        break;
      case 125: /* sclp ::= selcollist COMMA */
{yygotominor.yy213 = yymsp[-1].minor.yy213;}
        break;
      case 126: /* sclp ::= */
{yygotominor.yy213 = new ParserResultColumnList();}
        break;
      case 127: /* selcollist ::= sclp expr as */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        yymsp[-1].minor.yy192,
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->asKw : false,
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->name : QString::null
                                                    );

                                                yymsp[-2].minor.yy213->append(obj);
                                                yygotominor.yy213 = yymsp[-2].minor.yy213;
                                                delete yymsp[0].minor.yy40;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 128: /* selcollist ::= sclp STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(true);

                                                yymsp[-1].minor.yy213->append(obj);
                                                yygotominor.yy213 = yymsp[-1].minor.yy213;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 129: /* selcollist ::= sclp nm DOT STAR */
{
                                                SqliteSelect::Core::ResultColumn* obj =
                                                    new SqliteSelect::Core::ResultColumn(
                                                        true,
                                                        *(yymsp[-2].minor.yy319)
                                                    );
                                                yymsp[-3].minor.yy213->append(obj);
                                                yygotominor.yy213 = yymsp[-3].minor.yy213;
                                                delete yymsp[-2].minor.yy319;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sclp");
                                            }
        break;
      case 130: /* selcollist ::= sclp */
      case 131: /* selcollist ::= sclp ID_TAB DOT STAR */ yytestcase(yyruleno==131);
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy213 = yymsp[0].minor.yy213;
                                            }
        break;
      case 132: /* as ::= AS nm */
{
                                                yygotominor.yy40 = new ParserStubAlias(*(yymsp[0].minor.yy319), true);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 133: /* as ::= ids */
      case 134: /* as ::= AS ID_ALIAS */ yytestcase(yyruleno==134);
      case 135: /* as ::= ID_ALIAS */ yytestcase(yyruleno==135);
{
                                                yygotominor.yy40 = new ParserStubAlias(*(yymsp[0].minor.yy319), false);
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 136: /* as ::= */
{yygotominor.yy40 = nullptr;}
        break;
      case 137: /* from ::= */
{yygotominor.yy31 = nullptr;}
        break;
      case 138: /* from ::= FROM joinsrc */
{yygotominor.yy31 = yymsp[0].minor.yy31;}
        break;
      case 139: /* joinsrc ::= singlesrc seltablist */
{
                                                yygotominor.yy31 = new SqliteSelect::Core::JoinSource(
                                                        yymsp[-1].minor.yy121,
                                                        *(yymsp[0].minor.yy131)
                                                    );
                                                delete yymsp[0].minor.yy131;
                                                objectForTokens = yygotominor.yy31;
                                            }
        break;
      case 140: /* joinsrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy31 = new SqliteSelect::Core::JoinSource();
                                                objectForTokens = yygotominor.yy31;
                                            }
        break;
      case 141: /* seltablist ::= seltablist joinop singlesrc joinconstr_opt */
{
                                                SqliteSelect::Core::JoinSourceOther* src =
                                                    new SqliteSelect::Core::JoinSourceOther(yymsp[-2].minor.yy221, yymsp[-1].minor.yy121, yymsp[0].minor.yy455);

                                                yymsp[-3].minor.yy131->append(src);
                                                yygotominor.yy131 = yymsp[-3].minor.yy131;
                                                objectForTokens = src;
                                                DONT_INHERIT_TOKENS("seltablist");
                                            }
        break;
      case 142: /* seltablist ::= */
{
                                                yygotominor.yy131 = new ParserOtherSourceList();
                                            }
        break;
      case 143: /* singlesrc ::= nm dbnm as */
{
                                                yygotominor.yy121 = new SqliteSelect::Core::SingleSource(
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[-1].minor.yy319),
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->asKw : false,
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->name : QString::null,
                                                        false,
                                                        QString::null
                                                    );
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy40;
                                                objectForTokens = yygotominor.yy121;
                                            }
        break;
      case 144: /* singlesrc ::= LP select RP as */
{
                                                yygotominor.yy121 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy153,
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->asKw : false,
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->name : QString::null
                                                    );
                                                delete yymsp[0].minor.yy40;
                                                objectForTokens = yygotominor.yy121;
                                            }
        break;
      case 145: /* singlesrc ::= LP joinsrc RP as */
{
                                                yygotominor.yy121 = new SqliteSelect::Core::SingleSource(
                                                        yymsp[-2].minor.yy31,
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->asKw : false,
                                                        yymsp[0].minor.yy40 ? yymsp[0].minor.yy40->name : QString::null
                                                    );
                                                delete yymsp[0].minor.yy40;
                                                objectForTokens = yygotominor.yy121;
                                            }
        break;
      case 146: /* singlesrc ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy121 = new SqliteSelect::Core::SingleSource();
                                                objectForTokens = yygotominor.yy121;
                                            }
        break;
      case 147: /* singlesrc ::= nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy121 = new SqliteSelect::Core::SingleSource();
                                                yygotominor.yy121->database = *(yymsp[-1].minor.yy319);
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy121;
                                            }
        break;
      case 152: /* joinconstr_opt ::= ON expr */
{
                                                yygotominor.yy455 = new SqliteSelect::Core::JoinConstraint(yymsp[0].minor.yy192);
                                                objectForTokens = yygotominor.yy455;
                                            }
        break;
      case 153: /* joinconstr_opt ::= USING LP inscollist RP */
{
                                                yygotominor.yy455 = new SqliteSelect::Core::JoinConstraint(*(yymsp[-1].minor.yy207));
                                                delete yymsp[-1].minor.yy207;
                                                objectForTokens = yygotominor.yy455;
                                            }
        break;
      case 154: /* joinconstr_opt ::= */
{yygotominor.yy455 = nullptr;}
        break;
      case 155: /* dbnm ::= */
{yygotominor.yy319 = new QString();}
        break;
      case 157: /* fullname ::= nm dbnm */
{
                                                yygotominor.yy120 = new ParserFullName();
                                                yygotominor.yy120->name1 = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy120->name2 = *(yymsp[0].minor.yy319);
                                                delete yymsp[-1].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 158: /* joinop ::= COMMA */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(true);
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 159: /* joinop ::= JOIN */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(false);
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 160: /* joinop ::= JOIN_KW JOIN */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 161: /* joinop ::= JOIN_KW nm JOIN */
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(yymsp[-2].minor.yy0->value, *(yymsp[-1].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 162: /* joinop ::= JOIN_KW nm nm JOIN */
      case 163: /* joinop ::= ID_JOIN_OPTS */ yytestcase(yyruleno==163);
{
                                                yygotominor.yy221 = new SqliteSelect::Core::JoinOp(yymsp[-3].minor.yy0->value, *(yymsp[-2].minor.yy319), *(yymsp[-1].minor.yy319));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                objectForTokens = yygotominor.yy221;
                                            }
        break;
      case 164: /* orderby_opt ::= */
{yygotominor.yy243 = new ParserOrderByList();}
        break;
      case 165: /* orderby_opt ::= ORDER BY sortlist */
{yygotominor.yy243 = yymsp[0].minor.yy243;}
        break;
      case 166: /* sortlist ::= sortlist COMMA collate expr sortorder */
{
                                                SqliteOrderBy* obj;
                                                if (yymsp[-2].minor.yy319)
                                                {
                                                    SqliteExpr* coll = new SqliteExpr();
                                                    coll->initCollate(yymsp[-1].minor.yy192, *(yymsp[-2].minor.yy319));
                                                    delete yymsp[-2].minor.yy319;
                                                    obj = new SqliteOrderBy(coll, *(yymsp[0].minor.yy389));
                                                }
                                                else
                                                {
                                                    obj = new SqliteOrderBy(yymsp[-1].minor.yy192, *(yymsp[0].minor.yy389));
                                                }
                                                yymsp[-4].minor.yy243->append(obj);
                                                yygotominor.yy243 = yymsp[-4].minor.yy243;
                                                delete yymsp[0].minor.yy389;
                                                objectForTokens = obj;
                                                DONT_INHERIT_TOKENS("sortlist");
                                            }
        break;
      case 167: /* sortlist ::= expr collate sortorder */
{
                                                SqliteOrderBy* obj;
                                                if (yymsp[-1].minor.yy319)
                                                {
                                                    SqliteExpr* coll = new SqliteExpr();
                                                    coll->initCollate(yymsp[-2].minor.yy192, *(yymsp[-1].minor.yy319));
                                                    delete yymsp[-1].minor.yy319;
                                                    obj = new SqliteOrderBy(coll, *(yymsp[0].minor.yy389));
                                                }
                                                else
                                                {
                                                    obj = new SqliteOrderBy(yymsp[-2].minor.yy192, *(yymsp[0].minor.yy389));
                                                }
                                                yygotominor.yy243 = new ParserOrderByList();
                                                yygotominor.yy243->append(obj);
                                                delete yymsp[0].minor.yy389;
                                                objectForTokens = obj;
                                            }
        break;
      case 168: /* collate ::= */
{yygotominor.yy319 = nullptr;}
        break;
      case 170: /* sortorder ::= ASC */
{yygotominor.yy389 = new SqliteSortOrder(SqliteSortOrder::ASC);}
        break;
      case 171: /* sortorder ::= DESC */
{yygotominor.yy389 = new SqliteSortOrder(SqliteSortOrder::DESC);}
        break;
      case 172: /* sortorder ::= */
{yygotominor.yy389 = new SqliteSortOrder(SqliteSortOrder::null);}
        break;
      case 173: /* groupby_opt ::= */
      case 278: /* exprlist ::= */ yytestcase(yyruleno==278);
{yygotominor.yy231 = new ParserExprList();}
        break;
      case 174: /* groupby_opt ::= GROUP BY nexprlist */
      case 277: /* exprlist ::= nexprlist */ yytestcase(yyruleno==277);
{yygotominor.yy231 = yymsp[0].minor.yy231;}
        break;
      case 175: /* groupby_opt ::= GROUP BY */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy231 = new ParserExprList();
                                            }
        break;
      case 176: /* having_opt ::= */
      case 188: /* where_opt ::= */ yytestcase(yyruleno==188);
      case 274: /* case_else ::= */ yytestcase(yyruleno==274);
      case 276: /* case_operand ::= */ yytestcase(yyruleno==276);
      case 334: /* when_clause ::= */ yytestcase(yyruleno==334);
      case 347: /* key_opt ::= */ yytestcase(yyruleno==347);
{yygotominor.yy192 = nullptr;}
        break;
      case 177: /* having_opt ::= HAVING expr */
      case 189: /* where_opt ::= WHERE expr */ yytestcase(yyruleno==189);
      case 266: /* expr ::= exprx */ yytestcase(yyruleno==266);
      case 273: /* case_else ::= ELSE expr */ yytestcase(yyruleno==273);
      case 275: /* case_operand ::= exprx */ yytestcase(yyruleno==275);
      case 335: /* when_clause ::= WHEN expr */ yytestcase(yyruleno==335);
{yygotominor.yy192 = yymsp[0].minor.yy192;}
        break;
      case 178: /* limit_opt ::= */
{yygotominor.yy324 = nullptr;}
        break;
      case 179: /* limit_opt ::= LIMIT signed */
{
                                                yygotominor.yy324 = new SqliteLimit(*(yymsp[0].minor.yy69));
                                                delete yymsp[0].minor.yy69;
                                                objectForTokens = yygotominor.yy324;
                                            }
        break;
      case 180: /* limit_opt ::= LIMIT signed OFFSET signed */
{
                                                SqliteExpr* expr1 = new SqliteExpr();
                                                expr1->initLiteral(*(yymsp[-2].minor.yy69));
                                                expr1->setParent(yygotominor.yy324);

                                                SqliteExpr* expr2 = new SqliteExpr();
                                                expr1->initLiteral(*(yymsp[0].minor.yy69));
                                                expr1->setParent(yygotominor.yy324);

                                                yygotominor.yy324 = new SqliteLimit(expr1, expr2, true);

                                                TokenPtr limitToken = TokenPtr::create(Token::INTEGER, yymsp[-2].minor.yy69->toString());
                                                parserContext->addManagedToken(limitToken);
                                                expr1->tokens << limitToken;
                                                expr1->tokensMap["term"] << limitToken;

                                                TokenPtr offsetToken = TokenPtr::create(Token::INTEGER, yymsp[0].minor.yy69->toString());
                                                parserContext->addManagedToken(offsetToken);
                                                expr2->tokens << offsetToken;
                                                expr2->tokensMap["term"] << offsetToken;

                                                delete yymsp[-2].minor.yy69;
                                                delete yymsp[0].minor.yy69;
                                                objectForTokens = yygotominor.yy324;
                                            }
        break;
      case 181: /* limit_opt ::= LIMIT signed COMMA signed */
{
                                                SqliteExpr* expr1 = new SqliteExpr();
                                                expr1->initLiteral(*(yymsp[-2].minor.yy69));
                                                expr1->setParent(yygotominor.yy324);

                                                SqliteExpr* expr2 = new SqliteExpr();
                                                expr1->initLiteral(*(yymsp[0].minor.yy69));
                                                expr1->setParent(yygotominor.yy324);

                                                yygotominor.yy324 = new SqliteLimit(expr1, expr2, false);

                                                TokenPtr limitToken = TokenPtr::create(Token::INTEGER, yymsp[-2].minor.yy69->toString());
                                                parserContext->addManagedToken(limitToken);
                                                expr1->tokens << limitToken;
                                                expr1->tokensMap["term"] << limitToken;

                                                TokenPtr offsetToken = TokenPtr::create(Token::INTEGER, yymsp[0].minor.yy69->toString());
                                                parserContext->addManagedToken(offsetToken);
                                                expr2->tokens << offsetToken;
                                                expr2->tokensMap["term"] << offsetToken;

                                                delete yymsp[-2].minor.yy69;
                                                delete yymsp[0].minor.yy69;
                                                objectForTokens = yygotominor.yy324;
                                            }
        break;
      case 183: /* delete_stmt ::= DELETE FROM fullname where_opt */
{
                                                yygotominor.yy203 = new SqliteDelete(
                                                        yymsp[-1].minor.yy120->name1,
                                                        yymsp[-1].minor.yy120->name2,
                                                        false,
                                                        yymsp[0].minor.yy192,
                                                        nullptr
                                                    );
                                                delete yymsp[-1].minor.yy120;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 184: /* delete_stmt ::= DELETE FROM */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                yygotominor.yy203 = q;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 185: /* delete_stmt ::= DELETE FROM nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteDelete* q = new SqliteDelete();
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy203 = q;
                                                objectForTokens = yygotominor.yy203;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 190: /* where_opt ::= WHERE */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy192 = new SqliteExpr();
                                            }
        break;
      case 192: /* update_stmt ::= UPDATE orconf fullname SET setlist where_opt */
{
                                                yygotominor.yy203 = new SqliteUpdate(
                                                        *(yymsp[-4].minor.yy418),
                                                        yymsp[-3].minor.yy120->name1,
                                                        yymsp[-3].minor.yy120->name2,
                                                        false,
                                                        QString::null,
                                                        *(yymsp[-1].minor.yy201),
                                                        yymsp[0].minor.yy192,
                                                        nullptr
                                                    );
                                                delete yymsp[-4].minor.yy418;
                                                delete yymsp[-3].minor.yy120;
                                                delete yymsp[-1].minor.yy201;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 193: /* update_stmt ::= UPDATE orconf */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy203 = new SqliteUpdate();
                                                objectForTokens = yygotominor.yy203;
                                                delete yymsp[0].minor.yy418;
                                            }
        break;
      case 194: /* update_stmt ::= UPDATE orconf nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteUpdate* q = new SqliteUpdate();
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy203 = q;
                                                objectForTokens = yygotominor.yy203;
                                                delete yymsp[-2].minor.yy418;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 197: /* setlist ::= setlist COMMA nm EQ expr */
{
                                                yymsp[-4].minor.yy201->append(ParserSetValue(*(yymsp[-2].minor.yy319), yymsp[0].minor.yy192));
                                                yygotominor.yy201 = yymsp[-4].minor.yy201;
                                                delete yymsp[-2].minor.yy319;
                                                DONT_INHERIT_TOKENS("setlist");
                                            }
        break;
      case 198: /* setlist ::= nm EQ expr */
{
                                                yygotominor.yy201 = new ParserSetValueList();
                                                yygotominor.yy201->append(ParserSetValue(*(yymsp[-2].minor.yy319), yymsp[0].minor.yy192));
                                                delete yymsp[-2].minor.yy319;
                                            }
        break;
      case 199: /* setlist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy201 = new ParserSetValueList();
                                            }
        break;
      case 200: /* setlist ::= setlist COMMA */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy201 = yymsp[-1].minor.yy201;
                                            }
        break;
      case 201: /* setlist ::= setlist COMMA ID_COL */
      case 202: /* setlist ::= ID_COL */ yytestcase(yyruleno==202);
{  yy_destructor(yypParser,216,&yymsp[-2].minor);
}
        break;
      case 204: /* insert_stmt ::= insert_cmd INTO fullname inscollist_opt VALUES LP exprlist RP */
{
                                                yygotominor.yy203 = new SqliteInsert(
                                                        yymsp[-7].minor.yy344->replace,
                                                        yymsp[-7].minor.yy344->orConflict,
                                                        yymsp[-5].minor.yy120->name1,
                                                        yymsp[-5].minor.yy120->name2,
                                                        *(yymsp[-4].minor.yy207),
                                                        *(yymsp[-1].minor.yy231),
                                                        nullptr
                                                    );
                                                delete yymsp[-5].minor.yy120;
                                                delete yymsp[-7].minor.yy344;
                                                delete yymsp[-1].minor.yy231;
                                                delete yymsp[-4].minor.yy207;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 205: /* insert_stmt ::= insert_cmd INTO fullname inscollist_opt select */
{
                                                yygotominor.yy203 = new SqliteInsert(
                                                        yymsp[-4].minor.yy344->replace,
                                                        yymsp[-4].minor.yy344->orConflict,
                                                        yymsp[-2].minor.yy120->name1,
                                                        yymsp[-2].minor.yy120->name2,
                                                        *(yymsp[-1].minor.yy207),
                                                        yymsp[0].minor.yy153,
                                                        nullptr
                                                    );
                                                delete yymsp[-2].minor.yy120;
                                                delete yymsp[-4].minor.yy344;
                                                delete yymsp[-1].minor.yy207;
                                                // since it's used in trigger:
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 206: /* insert_stmt ::= insert_cmd INTO */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-1].minor.yy344->replace;
                                                q->onConflict = yymsp[-1].minor.yy344->orConflict;
                                                yygotominor.yy203 = q;
                                                objectForTokens = yygotominor.yy203;
                                                delete yymsp[-1].minor.yy344;
                                            }
        break;
      case 207: /* insert_stmt ::= insert_cmd INTO nm DOT */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                SqliteInsert* q = new SqliteInsert();
                                                q->replaceKw = yymsp[-3].minor.yy344->replace;
                                                q->onConflict = yymsp[-3].minor.yy344->orConflict;
                                                q->database = *(yymsp[-1].minor.yy319);
                                                yygotominor.yy203 = q;
                                                objectForTokens = yygotominor.yy203;
                                                delete yymsp[-3].minor.yy344;
                                                delete yymsp[-1].minor.yy319;
                                            }
        break;
      case 208: /* insert_stmt ::= insert_cmd INTO ID_DB|ID_TAB */
{  yy_destructor(yypParser,218,&yymsp[-2].minor);
}
        break;
      case 209: /* insert_stmt ::= insert_cmd INTO nm DOT ID_TAB */
{  yy_destructor(yypParser,218,&yymsp[-4].minor);
  yy_destructor(yypParser,156,&yymsp[-2].minor);
}
        break;
      case 210: /* insert_cmd ::= INSERT orconf */
{
                                                yygotominor.yy344 = new ParserStubInsertOrReplace(false, *(yymsp[0].minor.yy418));
                                                delete yymsp[0].minor.yy418;
                                            }
        break;
      case 211: /* insert_cmd ::= REPLACE */
{yygotominor.yy344 = new ParserStubInsertOrReplace(true);}
        break;
      case 212: /* inscollist_opt ::= */
{yygotominor.yy207 = new ParserStringList();}
        break;
      case 213: /* inscollist_opt ::= LP inscollist RP */
{yygotominor.yy207 = yymsp[-1].minor.yy207;}
        break;
      case 214: /* inscollist ::= inscollist COMMA nm */
{
                                                yymsp[-2].minor.yy207->append(*(yymsp[0].minor.yy319));
                                                yygotominor.yy207 = yymsp[-2].minor.yy207;
                                                delete yymsp[0].minor.yy319;
                                                DONT_INHERIT_TOKENS("inscollist");
                                            }
        break;
      case 215: /* inscollist ::= nm */
{
                                                yygotominor.yy207 = new ParserStringList();
                                                yygotominor.yy207->append(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 216: /* inscollist ::= */
{
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                                yygotominor.yy207 = new ParserStringList();
                                            }
        break;
      case 217: /* inscollist ::= inscollist COMMA ID_COL */
      case 218: /* inscollist ::= ID_COL */ yytestcase(yyruleno==218);
{  yy_destructor(yypParser,210,&yymsp[-2].minor);
}
        break;
      case 219: /* exprx ::= NULL */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initNull();
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 220: /* exprx ::= INTEGER */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                QVariant val = QVariant(yymsp[0].minor.yy0->value).toLongLong();
                                                yygotominor.yy192->initLiteral(val);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 221: /* exprx ::= FLOAT */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                QVariant val = QVariant(yymsp[0].minor.yy0->value).toDouble();
                                                yygotominor.yy192->initLiteral(val);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 222: /* exprx ::= STRING */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initLiteral(QVariant(yymsp[0].minor.yy0->value));
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 223: /* exprx ::= LP expr RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initSubExpr(yymsp[-1].minor.yy192);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 224: /* exprx ::= id */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initId(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 225: /* exprx ::= JOIN_KW */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initId(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 226: /* exprx ::= nm DOT nm */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initId(*(yymsp[-2].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 227: /* exprx ::= nm DOT nm DOT nm */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initId(*(yymsp[-4].minor.yy319), *(yymsp[-2].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 228: /* exprx ::= VARIABLE */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initBindParam(yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 229: /* exprx ::= ID LP exprlist RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initFunction(yymsp[-3].minor.yy0->value, false, *(yymsp[-1].minor.yy231));
                                                delete yymsp[-1].minor.yy231;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 230: /* exprx ::= ID LP STAR RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initFunction(yymsp[-3].minor.yy0->value, true);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 231: /* exprx ::= expr AND expr */
      case 232: /* exprx ::= expr OR expr */ yytestcase(yyruleno==232);
      case 233: /* exprx ::= expr LT|GT|GE|LE expr */ yytestcase(yyruleno==233);
      case 234: /* exprx ::= expr EQ|NE expr */ yytestcase(yyruleno==234);
      case 235: /* exprx ::= expr BITAND|BITOR|LSHIFT|RSHIFT expr */ yytestcase(yyruleno==235);
      case 236: /* exprx ::= expr PLUS|MINUS expr */ yytestcase(yyruleno==236);
      case 237: /* exprx ::= expr STAR|SLASH|REM expr */ yytestcase(yyruleno==237);
      case 238: /* exprx ::= expr CONCAT expr */ yytestcase(yyruleno==238);
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initBinOp(yymsp[-2].minor.yy192, yymsp[-1].minor.yy0->value, yymsp[0].minor.yy192);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 239: /* exprx ::= expr not_opt likeop expr */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initLike(yymsp[-3].minor.yy192, *(yymsp[-2].minor.yy291), *(yymsp[-1].minor.yy41), yymsp[0].minor.yy192);
                                                delete yymsp[-2].minor.yy291;
                                                delete yymsp[-1].minor.yy41;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 240: /* exprx ::= expr ISNULL|NOTNULL */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initNull(yymsp[-1].minor.yy192, yymsp[0].minor.yy0->value);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 241: /* exprx ::= expr NOT NULL */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initNull(yymsp[-2].minor.yy192, "NOT NULL");
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 242: /* exprx ::= expr IS not_opt expr */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initIs(yymsp[-3].minor.yy192, *(yymsp[-1].minor.yy291), yymsp[0].minor.yy192);
                                                delete yymsp[-1].minor.yy291;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 243: /* exprx ::= NOT expr */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initUnaryOp(yymsp[0].minor.yy192, yymsp[-1].minor.yy0->value);
                                            }
        break;
      case 244: /* exprx ::= BITNOT expr */
      case 245: /* exprx ::= MINUS expr */ yytestcase(yyruleno==245);
      case 246: /* exprx ::= PLUS expr */ yytestcase(yyruleno==246);
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initUnaryOp(yymsp[0].minor.yy192, yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 247: /* exprx ::= expr not_opt BETWEEN expr AND expr */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initBetween(yymsp[-5].minor.yy192, *(yymsp[-4].minor.yy291), yymsp[-2].minor.yy192, yymsp[0].minor.yy192);
                                                delete yymsp[-4].minor.yy291;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 248: /* exprx ::= expr not_opt IN LP exprlist RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initIn(yymsp[-5].minor.yy192, *(yymsp[-4].minor.yy291), *(yymsp[-1].minor.yy231));
                                                delete yymsp[-4].minor.yy291;
                                                delete yymsp[-1].minor.yy231;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 249: /* exprx ::= expr not_opt IN LP select RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initIn(yymsp[-5].minor.yy192, *(yymsp[-4].minor.yy291), yymsp[-1].minor.yy153);
                                                delete yymsp[-4].minor.yy291;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 250: /* exprx ::= expr not_opt IN nm dbnm */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initIn(yymsp[-4].minor.yy192, *(yymsp[-3].minor.yy291), *(yymsp[-1].minor.yy319), *(yymsp[0].minor.yy319));
                                                delete yymsp[-3].minor.yy291;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 251: /* exprx ::= LP select RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initSubSelect(yymsp[-1].minor.yy153);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 252: /* exprx ::= CASE case_operand case_exprlist case_else END */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initCase(yymsp[-3].minor.yy192, *(yymsp[-2].minor.yy231), yymsp[-1].minor.yy192);
                                                delete yymsp[-2].minor.yy231;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 253: /* exprx ::= RAISE LP raisetype COMMA nm RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initRaise(yymsp[-3].minor.yy0->value, *(yymsp[-1].minor.yy319));
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 254: /* exprx ::= RAISE LP IGNORE RP */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initRaise(yymsp[-1].minor.yy0->value);
                                                objectForTokens = yygotominor.yy192;
                                            }
        break;
      case 255: /* exprx ::= nm DOT */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initId(*(yymsp[-1].minor.yy319), QString::null, QString::null);
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy192;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 256: /* exprx ::= nm DOT nm DOT */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                yygotominor.yy192->initId(*(yymsp[-3].minor.yy319), *(yymsp[-1].minor.yy319), QString::null);
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy192;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 257: /* exprx ::= expr not_opt BETWEEN expr AND */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                delete yymsp[-3].minor.yy291;
                                                delete yymsp[-4].minor.yy192;
                                                delete yymsp[-1].minor.yy192;
                                                objectForTokens = yygotominor.yy192;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 258: /* exprx ::= CASE case_operand case_exprlist case_else */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                delete yymsp[-1].minor.yy231;
                                                delete yymsp[-2].minor.yy192;
                                                delete yymsp[0].minor.yy192;
                                                objectForTokens = yygotominor.yy192;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 259: /* exprx ::= expr not_opt IN LP exprlist */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                delete yymsp[-3].minor.yy291;
                                                delete yymsp[0].minor.yy231;
                                                delete yymsp[-4].minor.yy192;
                                                objectForTokens = yygotominor.yy192;
                                                parserContext->minorErrorBeforeNextToken("Syntax error");
                                            }
        break;
      case 260: /* exprx ::= expr not_opt IN ID_DB */
{  yy_destructor(yypParser,177,&yymsp[-3].minor);
}
        break;
      case 261: /* exprx ::= expr not_opt IN nm DOT ID_TAB */
      case 262: /* exprx ::= ID_DB|ID_TAB|ID_COL|ID_FN */ yytestcase(yyruleno==262);
{  yy_destructor(yypParser,177,&yymsp[-5].minor);
  yy_destructor(yypParser,156,&yymsp[-2].minor);
}
        break;
      case 264: /* exprx ::= nm DOT nm DOT ID_COL */
      case 265: /* exprx ::= RAISE LP raisetype COMMA ID_ERR_MSG RP */ yytestcase(yyruleno==265);
{  yy_destructor(yypParser,156,&yymsp[-4].minor);
  yy_destructor(yypParser,156,&yymsp[-2].minor);
}
        break;
      case 267: /* expr ::= */
{
                                                yygotominor.yy192 = new SqliteExpr();
                                                objectForTokens = yygotominor.yy192;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 270: /* likeop ::= LIKE|GLOB */
{yygotominor.yy41 = new SqliteExpr::LikeOp(SqliteExpr::likeOp(yymsp[0].minor.yy0->value));}
        break;
      case 271: /* case_exprlist ::= case_exprlist WHEN expr THEN expr */
{
                                                yymsp[-4].minor.yy231->append(yymsp[-2].minor.yy192);
                                                yymsp[-4].minor.yy231->append(yymsp[0].minor.yy192);
                                                yygotominor.yy231 = yymsp[-4].minor.yy231;
                                            }
        break;
      case 272: /* case_exprlist ::= WHEN expr THEN expr */
{
                                                yygotominor.yy231 = new ParserExprList();
                                                yygotominor.yy231->append(yymsp[-2].minor.yy192);
                                                yygotominor.yy231->append(yymsp[0].minor.yy192);
                                            }
        break;
      case 279: /* nexprlist ::= nexprlist COMMA expr */
{
                                                yymsp[-2].minor.yy231->append(yymsp[0].minor.yy192);
                                                yygotominor.yy231 = yymsp[-2].minor.yy231;
                                                DONT_INHERIT_TOKENS("nexprlist");
                                            }
        break;
      case 280: /* nexprlist ::= exprx */
{
                                                yygotominor.yy231 = new ParserExprList();
                                                yygotominor.yy231->append(yymsp[0].minor.yy192);
                                            }
        break;
      case 281: /* cmd ::= CREATE uniqueflag INDEX nm ON nm dbnm LP idxlist RP onconf */
{
                                                yygotominor.yy203 = new SqliteCreateIndex(
                                                        *(yymsp[-9].minor.yy291),
                                                        false,
                                                        *(yymsp[-7].minor.yy319),
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-4].minor.yy319),
                                                        *(yymsp[-2].minor.yy63),
                                                        *(yymsp[0].minor.yy418)
                                                    );
                                                delete yymsp[-9].minor.yy291;
                                                delete yymsp[-7].minor.yy319;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[-2].minor.yy63;
                                                delete yymsp[0].minor.yy418;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 282: /* cmd ::= CREATE uniqueflag INDEX nm dbnm ON ID_TAB */
{  yy_destructor(yypParser,156,&yymsp[-3].minor);
}
        break;
      case 287: /* idxlist_opt ::= */
{yygotominor.yy63 = new ParserIndexedColumnList();}
        break;
      case 288: /* idxlist_opt ::= LP idxlist RP */
{yygotominor.yy63 = yymsp[-1].minor.yy63;}
        break;
      case 289: /* idxlist ::= idxlist COMMA idxlist_single */
{
                                                yymsp[-2].minor.yy63->append(yymsp[0].minor.yy428);
                                                yygotominor.yy63 = yymsp[-2].minor.yy63;
                                                DONT_INHERIT_TOKENS("idxlist");
                                            }
        break;
      case 290: /* idxlist ::= idxlist_single */
{
                                                yygotominor.yy63 = new ParserIndexedColumnList();
                                                yygotominor.yy63->append(yymsp[0].minor.yy428);
                                            }
        break;
      case 291: /* idxlist_single ::= nm sortorder */
      case 292: /* idxlist_single ::= ID_COL */ yytestcase(yyruleno==292);
{
                                                SqliteIndexedColumn* obj =
                                                    new SqliteIndexedColumn(
                                                        *(yymsp[-1].minor.yy319),
                                                        QString::null,
                                                        *(yymsp[0].minor.yy389)
                                                    );
                                                yygotominor.yy428 = obj;
                                                delete yymsp[0].minor.yy389;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy428;
                                            }
        break;
      case 293: /* cmd ::= DROP INDEX fullname */
{
                                                yygotominor.yy203 = new SqliteDropIndex(false, yymsp[0].minor.yy120->name1, yymsp[0].minor.yy120->name2);
                                                delete yymsp[0].minor.yy120;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 296: /* cmd ::= COPY orconf nm dbnm FROM nm USING DELIMITERS STRING */
{
                                                yygotominor.yy203 = new SqliteCopy(
                                                    *(yymsp[-7].minor.yy418),
                                                    *(yymsp[-6].minor.yy319),
                                                    *(yymsp[-5].minor.yy319),
                                                    *(yymsp[-3].minor.yy319),
                                                    yymsp[0].minor.yy0->value
                                                );
                                                delete yymsp[-7].minor.yy418;
                                                delete yymsp[-6].minor.yy319;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-3].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 297: /* cmd ::= COPY orconf nm dbnm FROM nm */
{
                                                yygotominor.yy203 = new SqliteCopy(
                                                    *(yymsp[-4].minor.yy418),
                                                    *(yymsp[-3].minor.yy319),
                                                    *(yymsp[-2].minor.yy319),
                                                    *(yymsp[0].minor.yy319)
                                                );
                                                delete yymsp[-4].minor.yy418;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 298: /* cmd ::= VACUUM */
{
                                                yygotominor.yy203 = new SqliteVacuum();
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 299: /* cmd ::= VACUUM nm */
{
                                                yygotominor.yy203 = new SqliteVacuum(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 300: /* cmd ::= PRAGMA ids */
{
                                                yygotominor.yy203 = new SqlitePragma(*(yymsp[0].minor.yy319), QString::null);
                                                delete yymsp[0].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 301: /* cmd ::= PRAGMA nm EQ nmnum */
      case 303: /* cmd ::= PRAGMA nm EQ minus_num */ yytestcase(yyruleno==303);
{
                                                yygotominor.yy203 = new SqlitePragma(*(yymsp[-2].minor.yy319), QString::null, *(yymsp[0].minor.yy69), true);
                                                delete yymsp[-2].minor.yy319;
                                                delete yymsp[0].minor.yy69;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 302: /* cmd ::= PRAGMA nm LP nmnum RP */
      case 304: /* cmd ::= PRAGMA nm LP minus_num RP */ yytestcase(yyruleno==304);
{
                                                yygotominor.yy203 = new SqlitePragma(*(yymsp[-3].minor.yy319), QString::null, *(yymsp[-1].minor.yy69), false);
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy69;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 308: /* nmnum ::= nm */
{
                                                yygotominor.yy69 = new QVariant(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                            }
        break;
      case 309: /* nmnum ::= ON */
      case 310: /* nmnum ::= DELETE */ yytestcase(yyruleno==310);
      case 311: /* nmnum ::= DEFAULT */ yytestcase(yyruleno==311);
{yygotominor.yy69 = new QVariant(yymsp[0].minor.yy0->value);}
        break;
      case 314: /* minus_num ::= MINUS number */
{
                                                if (yymsp[0].minor.yy69->type() == QVariant::Double)
                                                    *(yymsp[0].minor.yy69) = -(yymsp[0].minor.yy69->toDouble());
                                                else if (yymsp[0].minor.yy69->type() == QVariant::LongLong)
                                                    *(yymsp[0].minor.yy69) = -(yymsp[0].minor.yy69->toLongLong());
                                                else
                                                    Q_ASSERT_X(true, "producing minus number", "QVariant is neither of Double or LongLong.");

                                                yygotominor.yy69 = yymsp[0].minor.yy69;
                                            }
        break;
      case 315: /* number ::= INTEGER */
{yygotominor.yy69 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toLongLong());}
        break;
      case 316: /* number ::= FLOAT */
{yygotominor.yy69 = new QVariant(QVariant(yymsp[0].minor.yy0->value).toDouble());}
        break;
      case 317: /* cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause BEGIN trigger_cmd_list END */
{
                                                yygotominor.yy203 = new SqliteCreateTrigger(
                                                        *(yymsp[-12].minor.yy226),
                                                        false,
                                                        *(yymsp[-10].minor.yy319),
                                                        *(yymsp[-6].minor.yy319),
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-9].minor.yy372),
                                                        yymsp[-8].minor.yy151,
                                                        *(yymsp[-4].minor.yy83),
                                                        yymsp[-3].minor.yy192,
                                                        *(yymsp[-1].minor.yy270),
                                                        2
                                                    );
                                                delete yymsp[-12].minor.yy226;
                                                delete yymsp[-9].minor.yy372;
                                                delete yymsp[-4].minor.yy83;
                                                delete yymsp[-6].minor.yy319;
                                                delete yymsp[-10].minor.yy319;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-1].minor.yy270;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 318: /* cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause */
{
                                                QList<SqliteQuery *> CL;

                                                yygotominor.yy203 = new SqliteCreateTrigger(
                                                        *(yymsp[-9].minor.yy226),
                                                        false,
                                                        *(yymsp[-7].minor.yy319),
                                                        *(yymsp[-3].minor.yy319),
                                                        *(yymsp[-2].minor.yy319),
                                                        *(yymsp[-6].minor.yy372),
                                                        yymsp[-5].minor.yy151,
                                                        *(yymsp[-1].minor.yy83),
                                                        yymsp[0].minor.yy192,
                                                        CL,
                                                        2
                                                    );
                                                delete yymsp[-9].minor.yy226;
                                                delete yymsp[-6].minor.yy372;
                                                delete yymsp[-1].minor.yy83;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-7].minor.yy319;
                                                delete yymsp[-2].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 319: /* cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm dbnm foreach_clause when_clause BEGIN trigger_cmd_list */
{
                                                yygotominor.yy203 = new SqliteCreateTrigger(
                                                        *(yymsp[-11].minor.yy226),
                                                        false,
                                                        *(yymsp[-9].minor.yy319),
                                                        *(yymsp[-5].minor.yy319),
                                                        *(yymsp[-4].minor.yy319),
                                                        *(yymsp[-8].minor.yy372),
                                                        yymsp[-7].minor.yy151,
                                                        *(yymsp[-3].minor.yy83),
                                                        yymsp[-2].minor.yy192,
                                                        *(yymsp[0].minor.yy270),
                                                        2
                                                    );
                                                delete yymsp[-11].minor.yy226;
                                                delete yymsp[-8].minor.yy372;
                                                delete yymsp[-3].minor.yy83;
                                                delete yymsp[-5].minor.yy319;
                                                delete yymsp[-9].minor.yy319;
                                                delete yymsp[-4].minor.yy319;
                                                delete yymsp[0].minor.yy270;
                                                objectForTokens = yygotominor.yy203;
                                                parserContext->minorErrorAfterLastToken("Syntax error");
                                            }
        break;
      case 320: /* cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON ID_TAB|ID_DB */
{  yy_destructor(yypParser,157,&yymsp[-6].minor);
  yy_destructor(yypParser,156,&yymsp[-4].minor);
  yy_destructor(yypParser,232,&yymsp[-3].minor);
  yy_destructor(yypParser,233,&yymsp[-2].minor);
}
        break;
      case 321: /* cmd ::= CREATE temp TRIGGER nm trigger_time trigger_event ON nm DOT ID_TAB */
{  yy_destructor(yypParser,157,&yymsp[-8].minor);
  yy_destructor(yypParser,156,&yymsp[-6].minor);
  yy_destructor(yypParser,232,&yymsp[-5].minor);
  yy_destructor(yypParser,233,&yymsp[-4].minor);
  yy_destructor(yypParser,156,&yymsp[-2].minor);
}
        break;
      case 323: /* trigger_time ::= BEFORE */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::BEFORE);}
        break;
      case 324: /* trigger_time ::= AFTER */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::AFTER);}
        break;
      case 325: /* trigger_time ::= INSTEAD OF */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::INSTEAD_OF);}
        break;
      case 326: /* trigger_time ::= */
{yygotominor.yy372 = new SqliteCreateTrigger::Time(SqliteCreateTrigger::Time::null);}
        break;
      case 327: /* trigger_event ::= DELETE */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::DELETE);
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 328: /* trigger_event ::= INSERT */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::INSERT);
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 329: /* trigger_event ::= UPDATE */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(SqliteCreateTrigger::Event::UPDATE);
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 330: /* trigger_event ::= UPDATE OF inscollist */
{
                                                yygotominor.yy151 = new SqliteCreateTrigger::Event(*(yymsp[0].minor.yy207));
                                                delete yymsp[0].minor.yy207;
                                                objectForTokens = yygotominor.yy151;
                                            }
        break;
      case 331: /* foreach_clause ::= */
{yygotominor.yy83 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::null);}
        break;
      case 332: /* foreach_clause ::= FOR EACH ROW */
{yygotominor.yy83 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_ROW);}
        break;
      case 333: /* foreach_clause ::= FOR EACH STATEMENT */
{yygotominor.yy83 = new SqliteCreateTrigger::Scope(SqliteCreateTrigger::Scope::FOR_EACH_STATEMENT);}
        break;
      case 336: /* trigger_cmd_list ::= trigger_cmd_list trigger_cmd SEMI */
{
                                                yymsp[-2].minor.yy270->append(yymsp[-1].minor.yy203);
                                                yygotominor.yy270 = yymsp[-2].minor.yy270;
                                                DONT_INHERIT_TOKENS("trigger_cmd_list");
                                            }
        break;
      case 337: /* trigger_cmd_list ::= trigger_cmd SEMI */
{
                                                yygotominor.yy270 = new ParserQueryList();
                                                yygotominor.yy270->append(yymsp[-1].minor.yy203);
                                            }
        break;
      case 342: /* raisetype ::= ROLLBACK|ABORT|FAIL */
{yygotominor.yy0 = yymsp[0].minor.yy0;}
        break;
      case 343: /* cmd ::= DROP TRIGGER fullname */
{
                                                yygotominor.yy203 = new SqliteDropTrigger(false, yymsp[0].minor.yy120->name1, yymsp[0].minor.yy120->name2);
                                                delete yymsp[0].minor.yy120;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 346: /* cmd ::= ATTACH database_kw_opt ids AS ids key_opt */
{
                                                SqliteExpr* e1 = new SqliteExpr();
                                                SqliteExpr* e2 = new SqliteExpr();
                                                e1->initLiteral(*(yymsp[-3].minor.yy319));
                                                e2->initLiteral(*(yymsp[-1].minor.yy319));
                                                yygotominor.yy203 = new SqliteAttach(*(yymsp[-4].minor.yy291), e1, e2, yymsp[0].minor.yy192);
                                                delete yymsp[-4].minor.yy291;
                                                delete yymsp[-3].minor.yy319;
                                                delete yymsp[-1].minor.yy319;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      case 348: /* key_opt ::= USING ids */
{
                                                SqliteExpr* e = new SqliteExpr();
                                                e->initLiteral(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                yygotominor.yy192 = e;
                                            }
        break;
      case 351: /* cmd ::= DETACH database_kw_opt nm */
{
                                                SqliteExpr* e = new SqliteExpr();
                                                e->initLiteral(*(yymsp[0].minor.yy319));
                                                delete yymsp[0].minor.yy319;
                                                yygotominor.yy203 = new SqliteDetach(*(yymsp[-1].minor.yy291), e);
                                                delete yymsp[-1].minor.yy291;
                                                objectForTokens = yygotominor.yy203;
                                            }
        break;
      default:
      /* (0) input ::= cmdlist */ yytestcase(yyruleno==0);
        break;
      };
  }
  assert( yyruleno>=0 && yyruleno<(int)(sizeof(yyRuleInfo)/sizeof(yyRuleInfo[0])) );
  yygoto = yyRuleInfo[yyruleno].lhs;
  yysize = yyRuleInfo[yyruleno].nrhs;

  // Store tokens for the rule in parser context
  QList<Token*> allTokens;
  QList<Token*> allTokensWithAllInherited;
  QString keyForTokensMap;
  int tokensMapKeyCnt;
  if (parserContext->setupTokens)
  {
      if (objectForTokens)
      {
          // In case this is a list with recurrent references we need
          // to clear tokens before adding the new and extended list.
          objectForTokens->tokens.clear();
      }

      QList<Token*> tokens;
      for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
      {
          tokens.clear();
          const char* fieldName = yyTokenName[yypParser->yystack[i].major];
          if (parserContext->isManagedToken(yypParser->yystack[i].minor.yy0))
              tokens += yypParser->yystack[i].minor.yy0;

          tokens += *(yypParser->yystack[i].tokens);

          if (!noTokenInheritanceFields.contains(fieldName))
          {
              if (objectForTokens)
              {
                  keyForTokensMap = fieldName;
                  tokensMapKeyCnt = 2;
                  while (objectForTokens->tokensMap.contains(keyForTokensMap))
                      keyForTokensMap = fieldName + QString::number(tokensMapKeyCnt++);

                  objectForTokens->tokensMap[keyForTokensMap] = parserContext->getTokenPtrList(tokens);
              }

              allTokens += tokens;
          }
          else
          {
              // If field is mentioned only once, then only one occurance of it will be ignored.
              // Second one should be inherited. See "anylist" definition for explanation why.
              noTokenInheritanceFields.removeOne(fieldName);
          }
          allTokensWithAllInherited += tokens;
      }
      if (objectForTokens)
      {
          objectForTokens->tokens += parserContext->getTokenPtrList(allTokens);
      }
  }

  // Clear token lists
  for (int i = yypParser->yyidx - yysize + 1; i <= yypParser->yyidx; i++)
  {
      delete yypParser->yystack[i].tokens;
      yypParser->yystack[i].tokens = nullptr;
  }

  yypParser->yyidx -= yysize;
  yyact = yy_find_reduce_action(yymsp[-yysize].stateno,(YYCODETYPE)yygoto);
  if( yyact < YYNSTATE ){
#ifdef NDEBUG
    /* If we are not debugging and the reduce action popped at least
    ** one element off the stack, then we can push the new element back
    ** onto the stack here, and skip the stack overflow test in yy_shift().
    ** That gives a significant speed improvement. */
    if( yysize ){
      yypParser->yyidx++;
      yymsp -= yysize-1;
      yymsp->stateno = (YYACTIONTYPE)yyact;
      yymsp->major = (YYCODETYPE)yygoto;
      yymsp->minor = yygotominor;
      if (parserContext->setupTokens)
          *(yypParser->yystack[yypParser->yyidx].tokens) = allTokens;
    }else
#endif
    {
      yy_shift(yypParser,yyact,yygoto,&yygotominor);
      if (parserContext->setupTokens)
      {
          QList<Token*>* tokensPtr = yypParser->yystack[yypParser->yyidx].tokens;
          *tokensPtr = allTokensWithAllInherited + *tokensPtr;
      }
    }
  }else{
    assert( yyact == YYNSTATE + YYNRULE + 1 );
    yy_accept(yypParser);
  }
}

/*
** The following code executes when the parse fails
*/
#ifndef YYNOERRORRECOVERY
static void yy_parse_failed(
  yyParser *yypParser           /* The parser */
){
  sqlite2_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sFail!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser fails */
  sqlite2_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}
#endif /* YYNOERRORRECOVERY */

/*
** The following code executes when a syntax error first occurs.
*/
static void yy_syntax_error(
  yyParser *yypParser,           /* The parser */
  int yymajor,                   /* The major type of the error token */
  YYMINORTYPE yyminor            /* The minor type of the error token */
){
  sqlite2_parseARG_FETCH;
#define TOKEN (yyminor.yy0)

    UNUSED_PARAMETER(yymajor);
    parserContext->error(TOKEN, QObject::tr("Syntax error"));
  sqlite2_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/*
** The following is executed when the parser accepts
*/
static void yy_accept(
  yyParser *yypParser           /* The parser */
){
  sqlite2_parseARG_FETCH;
#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sAccept!\n",yyTracePrompt);
  }
#endif
  while( yypParser->yyidx>=0 ) yy_pop_parser_stack(yypParser);
  /* Here code is inserted which will be executed whenever the
  ** parser accepts */
  sqlite2_parseARG_STORE; /* Suppress warning about unused %extra_argument variable */
}

/* The main parser program.
** The first argument is a pointer to a structure obtained from
** "sqlite2_parseAlloc" which describes the current state of the parser.
** The second argument is the major token number.  The third is
** the minor token.  The fourth optional argument is whatever the
** user wants (and specified in the grammar) and is available for
** use by the action routines.
**
** Inputs:
** <ul>
** <li> A pointer to the parser (an opaque structure.)
** <li> The major token number.
** <li> The minor token number.
** <li> An option argument of a grammar-specified type.
** </ul>
**
** Outputs:
** None.
*/
void sqlite2_parse(
  void *yyp,                   /* The parser */
  int yymajor,                 /* The major token code number */
  sqlite2_parseTOKENTYPE yyminor       /* The value for the token */
  sqlite2_parseARG_PDECL               /* Optional %extra_argument parameter */
){
  YYMINORTYPE yyminorunion;
  int yyact;            /* The parser action. */
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  int yyendofinput;     /* True if we are at the end of input */
#endif
#ifdef YYERRORSYMBOL
  int yyerrorhit = 0;   /* True if yymajor has invoked an error */
#endif
  yyParser *yypParser;  /* The parser */

  /* (re)initialize the parser, if necessary */
  yypParser = (yyParser*)yyp;
  if( yypParser->yyidx<0 ){
#if YYSTACKDEPTH<=0
    if( yypParser->yystksz <=0 ){
      /*memset(&yyminorunion, 0, sizeof(yyminorunion));*/
      yyminorunion = yyzerominor;
      yyStackOverflow(yypParser, &yyminorunion);
      return;
    }
#endif
    yypParser->yyidx = 0;
    yypParser->yyerrcnt = -1;
    yypParser->yystack[0].stateno = 0;
    yypParser->yystack[0].major = 0;
    yypParser->yystack[0].tokens = new QList<Token*>();
  }
  yyminorunion.yy0 = yyminor;
#if !defined(YYERRORSYMBOL) && !defined(YYNOERRORRECOVERY)
  yyendofinput = (yymajor==0);
#endif
  sqlite2_parseARG_STORE;

#ifndef NDEBUG
  if( yyTraceFILE ){
    fprintf(yyTraceFILE,"%sInput %s [%s] (lemon type: %s)\n",
            yyTracePrompt,
            yyminor->value.toLatin1().data(),
            yyminor->typeString().toLatin1().data(),
            yyTokenName[yymajor]);  }
#endif

  do{
    yyact = yy_find_shift_action(yypParser,(YYCODETYPE)yymajor);
    if( yyact<YYNSTATE ){
      yy_shift(yypParser,yyact,yymajor,&yyminorunion);
      yypParser->yyerrcnt--;
      yymajor = YYNOCODE;
    }else if( yyact < YYNSTATE + YYNRULE ){
      yy_reduce(yypParser,yyact-YYNSTATE);
    }else{
      assert( yyact == YY_ERROR_ACTION );
#ifdef YYERRORSYMBOL
      int yymx;
#endif
#ifndef NDEBUG
      if( yyTraceFILE ){
        fprintf(yyTraceFILE,"%sSyntax Error!\n",yyTracePrompt);
      }
#endif
#ifdef YYERRORSYMBOL
      /* A syntax error has occurred.
      ** The response to an error depends upon whether or not the
      ** grammar defines an error token "ERROR".
      **
      ** This is what we do if the grammar does define ERROR:
      **
      **  * Call the %syntax_error function.
      **
      **  * Begin popping the stack until we enter a state where
      **    it is legal to shift the error symbol, then shift
      **    the error symbol.
      **
      **  * Set the error count to three.
      **
      **  * Begin accepting and shifting new tokens.  No new error
      **    processing will occur until three tokens have been
      **    shifted successfully.
      **
      */
      if( yypParser->yyerrcnt<0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yymx = yypParser->yystack[yypParser->yyidx].major;
      if( yymx==YYERRORSYMBOL || yyerrorhit ){
#ifndef NDEBUG
        if( yyTraceFILE ){
          fprintf(yyTraceFILE,"%sDiscard input token %s\n",
             yyTracePrompt,yyTokenName[yymajor]);
        }
#endif
        yy_destructor(yypParser, (YYCODETYPE)yymajor,&yyminorunion);
        yymajor = YYNOCODE;
      }else{
         while(
          yypParser->yyidx >= 0 &&
          yymx != YYERRORSYMBOL &&
          (yyact = yy_find_reduce_action(
                        yypParser->yystack[yypParser->yyidx].stateno,
                        YYERRORSYMBOL)) >= YYNSTATE
        ){
          yy_pop_parser_stack(yypParser);
        }
        if( yypParser->yyidx < 0 || yymajor==0 ){
          yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
          yy_parse_failed(yypParser);
          yymajor = YYNOCODE;
        }else if( yymx!=YYERRORSYMBOL ){
          YYMINORTYPE u2;
          u2.YYERRSYMDT = 0;
          yy_shift(yypParser,yyact,YYERRORSYMBOL,&u2);
        }
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yyerrorhit = 1;
#elif defined(YYNOERRORRECOVERY)
      /* If the YYNOERRORRECOVERY macro is defined, then do not attempt to
      ** do any kind of error recovery.  Instead, simply invoke the syntax
      ** error routine and continue going as if nothing had happened.
      **
      ** Applications can set this macro (for example inside %include) if
      ** they intend to abandon the parse upon the first syntax error seen.
      */
      yy_syntax_error(yypParser,yymajor,yyminorunion);
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      yymajor = YYNOCODE;

#else  /* YYERRORSYMBOL is not defined */
      /* This is what we do if the grammar does not define ERROR:
      **
      **  * Report an error message, and throw away the input token.
      **
      **  * If the input token is $, then fail the parse.
      **
      ** As before, subsequent error messages are suppressed until
      ** three input tokens have been successfully shifted.
      */
      if( yypParser->yyerrcnt<=0 ){
        yy_syntax_error(yypParser,yymajor,yyminorunion);
      }
      yypParser->yyerrcnt = 1; // not 3 valid tokens, but 1
      yy_destructor(yypParser,(YYCODETYPE)yymajor,&yyminorunion);
      if( yyendofinput ){
        yy_parse_failed(yypParser);
      }
      yymajor = YYNOCODE;
#endif
    }
  }while( yymajor!=YYNOCODE && yypParser->yyidx>=0 );
  return;
}
