#! /usr/bin/env bash

export MAINDIR=$(pwd)
export SVGDIR=$MAINDIR/svg
export PNGDIR=$MAINDIR/png
export CURSDIR=$MAINDIR/SharpDot/cursors
export ANIDIR=$MAINDIR/ani

mkdir $PNGDIR
mkdir $ANIDIR

if $(command -v convert >/dev/null); then export PNGBUILD="convert -background none"
elif $(command -v rsvg >/dev/null); then export PNGBUILD="rsvg -a"
else echo -e "Please install the imagemagick or librsvg2-bin\npackage before running the build script."; exit 0
fi

# Build all SVG's to the PNG directory
# and remove animated ones
echo "Building bitmaps from vector art..."
for i in $SVGDIR/*.svg
	do
		$PNGBUILD $i $PNGDIR/$(basename $i .svg).png
	done
rm $PNGDIR/wait.png
rm $PNGDIR/progress.png

mkdir -p $CURSDIR

# Make main cursors according to freedesktop spec
echo "Making main cursors..."
echo "24 2 2 $PNGDIR/alias.png" | xcursorgen - $CURSDIR/alias
echo "24 11 11 $PNGDIR/all-scroll.png" | xcursorgen - $CURSDIR/all-scroll
echo "24 11 11 $PNGDIR/cell.png" | xcursorgen - $CURSDIR/cell
echo "24 16 11 $PNGDIR/col-resize.png" | xcursorgen - $CURSDIR/col-resize
echo "24 2 2 $PNGDIR/copy.png" | xcursorgen - $CURSDIR/copy
echo "24 11 11 $PNGDIR/crosshair.png" | xcursorgen - $CURSDIR/crosshair
echo "24 2 2 $PNGDIR/default.png" | xcursorgen - $CURSDIR/default
echo "24 19 11 $PNGDIR/e-resize.png" | xcursorgen - $CURSDIR/e-resize
echo "24 2 23 $PNGDIR/help.png" | xcursorgen - $CURSDIR/help
echo "24 19 4 $PNGDIR/ne-resize.png" | xcursorgen - $CURSDIR/ne-resize
echo "24 2 2 $PNGDIR/no-drop.png" | xcursorgen - $CURSDIR/no-drop
echo "24 12 12 $PNGDIR/not-allowed.png" | xcursorgen -   $CURSDIR/not-allowed
echo "24 11 4 $PNGDIR/n-resize.png" | xcursorgen - $CURSDIR/n-resize
echo "24 4 4 $PNGDIR/nw-resize.png" | xcursorgen - $CURSDIR/nw-resize
echo "24 3 3 $PNGDIR/pointer.png" | xcursorgen - $CURSDIR/pointer
echo "24 2 2 $PNGDIR/pointer2.png" | xcursorgen - $CURSDIR/pointer2
echo "24 11 16 $PNGDIR/row-resize.png" | xcursorgen - $CURSDIR/row-resize
echo "24 19 19 $PNGDIR/se-resize.png" | xcursorgen - $CURSDIR/se-resize
echo "24 11 20 $PNGDIR/s-resize.png" | xcursorgen - $CURSDIR/s-resize
echo "24 4 19 $PNGDIR/sw-resize.png" | xcursorgen - $CURSDIR/sw-resize
echo "24 11 11 $PNGDIR/text.png" | xcursorgen - $CURSDIR/text
echo "24 11 11 $PNGDIR/vertical-text.png" | xcursorgen - $CURSDIR/vertical-text
echo "24 4 11 $PNGDIR/w-resize.png" | xcursorgen - $CURSDIR/w-resize
# This one's not in there, but I put it there for good measure
# as some desktops (Xfce, for one) use it.
# Could be symlinked to 'all-scroll' or 'copy' if you don't like it.
echo "24 1 1 $PNGDIR/move.png" | xcursorgen - $CURSDIR/move

# Cursors from "nice to have" and "up for discussion" entries
echo "24 1 1 $PNGDIR/context-menu.png" | xcursorgen - $CURSDIR/context-menu
echo "24 11 1 $PNGDIR/up-arrow.png" | xcursorgen - $CURSDIR/up-arrow
echo "24 16 12 $PNGDIR/ew-resize.png" | xcursorgen - $CURSDIR/ew-resize
echo "24 16 16 $PNGDIR/nesw-resize.png" | xcursorgen - $CURSDIR/nesw-resize
echo "24 12 16 $PNGDIR/ns-resize.png" | xcursorgen - $CURSDIR/ns-resize
echo "24 16 16 $PNGDIR/nwse-resize.png" | xcursorgen - $CURSDIR/nwse-resize

# Cursors not in the spec, but nice to have for completeness
echo "24 2 2 $PNGDIR/grabbing.png" | xcursorgen - $CURSDIR/grabbing
echo "24 2 2 $PNGDIR/pencil.png" | xcursorgen - $CURSDIR/pencil
echo "24 11 11 $PNGDIR/pirate.png" | xcursorgen - $CURSDIR/pirate
echo "24 22 2 $PNGDIR/right-arrow.png" | xcursorgen - $CURSDIR/right-arrow
echo "24 11 12 $PNGDIR/X-cursor.png" | xcursorgen - $CURSDIR/X-cursor
echo "24 9 9 $PNGDIR/zoom-in.png" | xcursorgen - $CURSDIR/zoom-in
echo "24 9 9 $PNGDIR/zoom-out.png" | xcursorgen - $CURSDIR/zoom-out

# Animated cursors
echo "Making animated cursors..."
cat > $ANIDIR/wait.conf <<EOF
24 12 12 wait1.png 300
24 12 12 wait2.png 300
24 12 12 wait3.png 300
24 12 12 wait4.png 300
24 12 12 wait5.png 300
24 12 12 wait6.png 300
24 12 12 wait7.png 300
24 12 12 wait8.png 300
24 12 12 wait9.png 300
24 12 12 wait10.png 300
24 12 12 wait11.png 300
24 12 12 wait12.png 300
EOF

cat > $ANIDIR/progress.conf <<EOF
24 12 12 wait1.png 300
24 12 12 wait2.png 300
24 12 12 wait3.png 300
24 12 12 wait4.png 300
24 12 12 wait5.png 300
24 12 12 wait6.png 300
24 12 12 wait7.png 300
24 12 12 wait8.png 300
24 12 12 wait9.png 300
24 12 12 wait10.png 300
24 12 12 wait11.png 300
24 12 12 wait12.png 300
EOF

for i in wait progress
do
	for k in {1..12}
	do
		n=$(($k*30))
		sed "s/(0)/($n)/g" $SVGDIR/$i.svg > $SVGDIR/new.svg
		convert -background none $SVGDIR/new.svg $ANIDIR/$i$k.png
	done
done
rm $SVGDIR/new.svg
cd $ANIDIR
xcursorgen $ANIDIR/wait.conf $CURSDIR/wait
xcursorgen $ANIDIR/progress.conf $CURSDIR/progress
cd $MAINDIR

# Source links for legacy and hash cursors
echo "Making legacy links..."
cd $CURSDIR
source $MAINDIR/links.txt
cd $MAINDIR

# Generate Theme file
echo "Generating theme index file..."
cat > $MAINDIR/SharpDot/index.theme <<EOF
[Icon Theme]
Name = SharpDot
Comment = Inspired by the venerable Yellowdot cursor set
EOF

rm -rf $ANIDIR
rm -rf $PNGDIR

echo -e "Building complete.\nPlease run 'install.sh'."
exit 0
