EDUCOURSE_OID = "urn:oid:1.3.6.1.4.1.5923.1.6.1."
EDUPERSON_OID = "urn:oid:1.3.6.1.4.1.5923.1.1.1."
EDUMEMBER1_OID = "urn:oid:1.3.6.1.4.1.5923.1.5.1."

# voPerson class References:
# - https://github.com/voperson/voperson/blob/2.0.0/voPerson.md#voperson-object-class-definition
VOPERSON_V2_OID = "urn:oid:1.3.6.1.4.1.25178.4.1."

# ldap.gv.at definitions as specified in:
# http://www.ref.gv.at/AG-IZ-PVP2-Version-2-1-0-2.2754.0.html
LDAPGVAT_OID = "urn:oid:1.2.40.0.10.2.1.1."

UCL_DIR_PILOT = "urn:oid:0.9.2342.19200300.100.1."
X500ATTR_OID = "urn:oid:2.5.4."
LDAPGVAT_UCL_DIR_PILOT = UCL_DIR_PILOT
LDAPGVAT_X500ATTR_OID = X500ATTR_OID
NETSCAPE_LDAP = "urn:oid:2.16.840.1.113730.3.1."
NOREDUPERSON_OID = "urn:oid:1.3.6.1.4.1.2428.90.1."
PKCS_9 = "urn:oid:1.2.840.113549.1.9.1."
SCHAC = "urn:oid:1.3.6.1.4.1.25178.1.2."
SIS = "urn:oid:1.2.752.194.10.2."
UMICH = "urn:oid:1.3.6.1.4.1.250.1.57."

# openosi-0.82.schema http://www.openosi.org/osi/display/ldap/Home
OPENOSI_OID = "urn:oid:1.3.6.1.4.1.27630.2.1.1."
SWISSEDUPERSON_OID = "urn:oid:2.16.756.1.2.5.1.1."

EIDAS_NATURALPERSON = "http://eidas.europa.eu/attributes/naturalperson/"
EIDAS_LEGALPERSON = "http://eidas.europa.eu/attributes/legalperson/"

# SAML subject id specification
# https://docs.oasis-open.org/security/saml-subject-id-attr/v1.0/cs01/saml-subject-id-attr-v1.0-cs01.html
SAML_SUBJECT_ID = "urn:oasis:names:tc:SAML:attribute:"

# umbrellaID specification - https://www.umbrellaid.org
# https://github.com/Umbrella-Commiters/UmbrellaIdP3/blob/master/schema/99-user.ldif
UMBRELLA_EAAUser_ID = "urn:oid:1.3.6.1.4.1.42750.1.1."

# PKIX specification (SMI Security for PKIX Personal Data Attributes)
# https://tools.ietf.org/html/rfc7299
PKIX_OID = "urn:oid:1.3.6.1.5.5.7.9."

# INERA specification
# Closet public spec source I could find, sadly in swedish
# https://www.sambi.se/wordpress/wp-content/uploads/2017/06/Sambi_Attributspecifikation_1.1.pdf
INERA_OID = "urn:oid:1.2.752.29.4."

# DIGG specification
# https://docs.swedenconnect.se/technical-framework/latest/ELN-0604_-_Attribute_Specification_for_the_Swedish_eID_Framework.html
DIGG_OID = "urn:oid:1.2.752.201.3."

MAP = {
    "identifier": "urn:oasis:names:tc:SAML:2.0:attrname-format:uri",
    "fro": {
        f"{DIGG_OID}1": "orgAffiliation",
        f"{DIGG_OID}2": "transactionIdentifier",
        f"{DIGG_OID}3": "authContextParams",
        f"{DIGG_OID}4": "prid",
        f"{DIGG_OID}5": "pridPersistence",
        f"{DIGG_OID}6": "personalIdentityNumberBinding",
        f"{DIGG_OID}7": "eidasPersonIdentifier",
        f"{DIGG_OID}8": "birthName",
        f"{DIGG_OID}9": "eidasNaturalPersonAddress",
        f"{DIGG_OID}10": "userCertificate",
        f"{DIGG_OID}11": "userSignature",
        f"{DIGG_OID}12": "sad",
        f"{DIGG_OID}13": "authServerSignature",
        f"{DIGG_OID}14": "signMessageDigest",
        f"{EIDAS_LEGALPERSON}LegalPersonIdentifier": "LegalPersonIdentifier",
        f"{EIDAS_LEGALPERSON}LegalPersonAddress": "LegalAddress",
        f"{EIDAS_LEGALPERSON}LegalName": "LegalName",
        f"{EIDAS_LEGALPERSON}VATRegistrationNumber": "VATRegistration",
        f"{EIDAS_LEGALPERSON}TaxReference": "TaxReference",
        f"{EIDAS_LEGALPERSON}BusinessCodes": "BusinessCodes",
        f"{EIDAS_LEGALPERSON}LEI": "LEI",
        f"{EIDAS_LEGALPERSON}EORI": "EORI",
        f"{EIDAS_LEGALPERSON}SEED": "SEED",
        f"{EIDAS_LEGALPERSON}SIC": "SIC",
        f"{EIDAS_LEGALPERSON}D-2012-17-EUIdentifier": "D-2012-17-EUIdentifier",
        f"{EIDAS_NATURALPERSON}PersonIdentifier": "PersonIdentifier",
        f"{EIDAS_NATURALPERSON}CurrentFamilyName": "FamilyName",
        f"{EIDAS_NATURALPERSON}CurrentGivenName": "FirstName",
        f"{EIDAS_NATURALPERSON}DateOfBirth": "DateOfBirth",
        f"{EIDAS_NATURALPERSON}BirthName": "BirthName",
        f"{EIDAS_NATURALPERSON}PlaceOfBirth": "PlaceOfBirth",
        f"{EIDAS_NATURALPERSON}CurrentAddress": "CurrentAddress",
        f"{EIDAS_NATURALPERSON}Gender": "Gender",
        f"{EDUCOURSE_OID}1": "eduCourseOffering",
        f"{EDUCOURSE_OID}2": "eduCourseMember",
        f"{EDUMEMBER1_OID}1": "isMemberOf",
        f"{EDUPERSON_OID}1": "eduPersonAffiliation",
        f"{EDUPERSON_OID}2": "eduPersonNickname",
        f"{EDUPERSON_OID}3": "eduPersonOrgDN",
        f"{EDUPERSON_OID}4": "eduPersonOrgUnitDN",
        f"{EDUPERSON_OID}5": "eduPersonPrimaryAffiliation",
        f"{EDUPERSON_OID}6": "eduPersonPrincipalName",
        f"{EDUPERSON_OID}7": "eduPersonEntitlement",
        f"{EDUPERSON_OID}8": "eduPersonPrimaryOrgUnitDN",
        f"{EDUPERSON_OID}9": "eduPersonScopedAffiliation",
        f"{EDUPERSON_OID}10": "eduPersonTargetedID",
        f"{EDUPERSON_OID}11": "eduPersonAssurance",
        f"{EDUPERSON_OID}12": "eduPersonPrincipalNamePrior",
        f"{EDUPERSON_OID}13": "eduPersonUniqueId",
        f"{EDUPERSON_OID}16": "eduPersonOrcid",
        f"{INERA_OID}1": "employeeHsaId",
        f"{INERA_OID}13": "personalIdentityNumber",
        f"{LDAPGVAT_OID}1": "PVP-GID",
        f"{LDAPGVAT_OID}149": "PVP-BPK",
        f"{LDAPGVAT_OID}153": "PVP-OU-OKZ",
        f"{LDAPGVAT_OID}261.10": "PVP-VERSION",
        f"{LDAPGVAT_OID}261.20": "PVP-PRINCIPAL-NAME",
        f"{LDAPGVAT_OID}261.24": "PVP-PARTICIPANT-OKZ",
        f"{LDAPGVAT_OID}261.30": "PVP-ROLES",
        f"{LDAPGVAT_OID}261.40": "PVP-INVOICE-RECPT-ID",
        f"{LDAPGVAT_OID}261.50": "PVP-COST-CENTER-ID",
        f"{LDAPGVAT_OID}261.60": "PVP-CHARGE-CODE",
        f"{LDAPGVAT_OID}3": "PVP-OU-GV-OU-ID",
        f"{LDAPGVAT_OID}33": "PVP-FUNCTION",
        f"{LDAPGVAT_OID}55": "PVP-BIRTHDATE",
        f"{LDAPGVAT_OID}71": "PVP-PARTICIPANT-ID",
        f"{LDAPGVAT_UCL_DIR_PILOT}1": "PVP-USERID",
        f"{LDAPGVAT_UCL_DIR_PILOT}3": "PVP-MAIL",
        f"{LDAPGVAT_X500ATTR_OID}11": "PVP-OU",
        f"{LDAPGVAT_X500ATTR_OID}20": "PVP-TEL",
        f"{LDAPGVAT_X500ATTR_OID}42": "PVP-GIVENNAME",
        f"{NETSCAPE_LDAP}1": "carLicense",
        f"{NETSCAPE_LDAP}2": "departmentNumber",
        f"{NETSCAPE_LDAP}3": "employeeNumber",
        f"{NETSCAPE_LDAP}4": "employeeType",
        f"{NETSCAPE_LDAP}13": "mailLocalAddress",
        f"{NETSCAPE_LDAP}39": "preferredLanguage",
        f"{NETSCAPE_LDAP}40": "userSMIMECertificate",
        f"{NETSCAPE_LDAP}216": "userPKCS12",
        f"{NETSCAPE_LDAP}241": "displayName",
        f"{NOREDUPERSON_OID}1": "norEduOrgUniqueNumber",
        f"{NOREDUPERSON_OID}2": "norEduOrgUnitUniqueNumber",
        f"{NOREDUPERSON_OID}3": "norEduPersonBirthDate",
        f"{NOREDUPERSON_OID}4": "norEduPersonLIN",
        f"{NOREDUPERSON_OID}5": "norEduPersonNIN",
        f"{NOREDUPERSON_OID}6": "norEduOrgAcronym",
        f"{NOREDUPERSON_OID}7": "norEduOrgUniqueIdentifier",
        f"{NOREDUPERSON_OID}8": "norEduOrgUnitUniqueIdentifier",
        f"{NOREDUPERSON_OID}9": "federationFeideSchemaVersion",
        f"{NOREDUPERSON_OID}10": "norEduPersonLegalName",
        f"{NOREDUPERSON_OID}11": "norEduOrgSchemaVersion",
        f"{NOREDUPERSON_OID}12": "norEduOrgNIN",
        f"{OPENOSI_OID}17": "osiHomeUrl",
        f"{OPENOSI_OID}19": "osiPreferredTZ",
        f"{OPENOSI_OID}72": "osiICardTimeLastUpdated",
        f"{OPENOSI_OID}104": "osiMiddleName",
        f"{OPENOSI_OID}107": "osiOtherEmail",
        f"{OPENOSI_OID}109": "osiOtherHomePhone",
        f"{OPENOSI_OID}120": "osiWorkURL",
        f"{PKCS_9}1": "email",
        f"{PKIX_OID}1": "dateOfBirth",
        f"{PKIX_OID}2": "placeOfBirth",
        f"{PKIX_OID}3": "gender",
        f"{PKIX_OID}4": "countryOfCitizenship",
        f"{PKIX_OID}5": "countryOfResidence",
        f"{SAML_SUBJECT_ID}subject-id": "subject-id",
        f"{SAML_SUBJECT_ID}pairwise-id": "pairwise-id",
        f"{SCHAC}1": "schacMotherTongue",
        f"{SCHAC}2": "schacGender",
        f"{SCHAC}3": "schacDateOfBirth",
        f"{SCHAC}4": "schacPlaceOfBirth",
        f"{SCHAC}5": "schacCountryOfCitizenship",
        f"{SCHAC}6": "schacSn1",
        f"{SCHAC}7": "schacSn2",
        f"{SCHAC}8": "schacPersonalTitle",
        f"{SCHAC}9": "schacHomeOrganization",
        f"{SCHAC}10": "schacHomeOrganizationType",
        f"{SCHAC}11": "schacCountryOfResidence",
        f"{SCHAC}12": "schacUserPresenceID",
        f"{SCHAC}13": "schacPersonalPosition",
        f"{SCHAC}14": "schacPersonalUniqueCode",
        f"{SCHAC}15": "schacPersonalUniqueID",
        f"{SCHAC}17": "schacExpiryDate",
        f"{SCHAC}18": "schacUserPrivateAttribute",
        f"{SCHAC}19": "schacUserStatus",
        f"{SCHAC}20": "schacProjectMembership",
        f"{SCHAC}21": "schacProjectSpecificRole",
        f"{SIS}1": "sisLegalGuardianFor",
        f"{SIS}2": "sisSchoolGrade",
        f"{UCL_DIR_PILOT}1": "uid",
        f"{UCL_DIR_PILOT}3": "mail",
        f"{UCL_DIR_PILOT}25": "dc",
        f"{UCL_DIR_PILOT}37": "associatedDomain",
        f"{UCL_DIR_PILOT}43": "co",
        f"{UCL_DIR_PILOT}60": "jpegPhoto",
        f"{UMBRELLA_EAAUser_ID}1": "EAAHash",
        f"{UMBRELLA_EAAUser_ID}3": "EAAKey",
        f"{UMICH}57": "labeledURI",
        f"{X500ATTR_OID}2": "knowledgeInformation",
        f"{X500ATTR_OID}3": "cn",
        f"{X500ATTR_OID}4": "sn",
        f"{X500ATTR_OID}5": "serialNumber",
        f"{X500ATTR_OID}6": "c",
        f"{X500ATTR_OID}7": "l",
        f"{X500ATTR_OID}8": "st",
        f"{X500ATTR_OID}9": "street",
        f"{X500ATTR_OID}10": "o",
        f"{X500ATTR_OID}11": "ou",
        f"{X500ATTR_OID}12": "title",
        f"{X500ATTR_OID}14": "searchGuide",
        f"{X500ATTR_OID}15": "businessCategory",
        f"{X500ATTR_OID}16": "postalAddress",
        f"{X500ATTR_OID}17": "postalCode",
        f"{X500ATTR_OID}18": "postOfficeBox",
        f"{X500ATTR_OID}19": "physicalDeliveryOfficeName",
        f"{X500ATTR_OID}20": "telephoneNumber",
        f"{X500ATTR_OID}21": "telexNumber",
        f"{X500ATTR_OID}22": "teletexTerminalIdentifier",
        f"{X500ATTR_OID}23": "facsimileTelephoneNumber",
        f"{X500ATTR_OID}24": "x121Address",
        f"{X500ATTR_OID}25": "internationaliSDNNumber",
        f"{X500ATTR_OID}26": "registeredAddress",
        f"{X500ATTR_OID}27": "destinationIndicator",
        f"{X500ATTR_OID}28": "preferredDeliveryMethod",
        f"{X500ATTR_OID}29": "presentationAddress",
        f"{X500ATTR_OID}30": "supportedApplicationContext",
        f"{X500ATTR_OID}31": "member",
        f"{X500ATTR_OID}32": "owner",
        f"{X500ATTR_OID}33": "roleOccupant",
        f"{X500ATTR_OID}36": "userCertificate",
        f"{X500ATTR_OID}37": "cACertificate",
        f"{X500ATTR_OID}38": "authorityRevocationList",
        f"{X500ATTR_OID}39": "certificateRevocationList",
        f"{X500ATTR_OID}40": "crossCertificatePair",
        f"{X500ATTR_OID}42": "givenName",
        f"{X500ATTR_OID}43": "initials",
        f"{X500ATTR_OID}44": "generationQualifier",
        f"{X500ATTR_OID}45": "x500UniqueIdentifier",
        f"{X500ATTR_OID}46": "dnQualifier",
        f"{X500ATTR_OID}47": "enhancedSearchGuide",
        f"{X500ATTR_OID}48": "protocolInformation",
        f"{X500ATTR_OID}50": "uniqueMember",
        f"{X500ATTR_OID}51": "houseIdentifier",
        f"{X500ATTR_OID}52": "supportedAlgorithms",
        f"{X500ATTR_OID}53": "deltaRevocationList",
        f"{X500ATTR_OID}54": "dmdName",
        f"{X500ATTR_OID}65": "pseudonym",
        f"{SWISSEDUPERSON_OID}1": "swissEduPersonUniqueID",
        f"{SWISSEDUPERSON_OID}2": "swissEduPersonDateOfBirth",
        f"{SWISSEDUPERSON_OID}3": "swissEduPersonGender",
        f"{SWISSEDUPERSON_OID}4": "swissEduPersonHomeOrganization",
        f"{SWISSEDUPERSON_OID}5": "swissEduPersonHomeOrganizationType",
        f"{SWISSEDUPERSON_OID}6": "swissEduPersonStudyBranch1",
        f"{SWISSEDUPERSON_OID}7": "swissEduPersonStudyBranch2",
        f"{SWISSEDUPERSON_OID}8": "swissEduPersonStudyBranch3",
        f"{SWISSEDUPERSON_OID}9": "swissEduPersonStudyLevel",
        f"{SWISSEDUPERSON_OID}10": "swissEduPersonStaffCategory",
        f"{SWISSEDUPERSON_OID}11": "swissEduPersonMatriculationNumber",
        f"{SWISSEDUPERSON_OID}12": "swissEduPersonCardUID",
        f"{SWISSEDUPERSON_OID}13": "swissEduID",
        f"{SWISSEDUPERSON_OID}1023": "swissLibraryPersonAffiliation",
        f"{SWISSEDUPERSON_OID}1025": "swissLibraryPersonResidence",
        f"{VOPERSON_V2_OID}1": "voPersonApplicationUID",
        f"{VOPERSON_V2_OID}2": "voPersonAuthorName",
        f"{VOPERSON_V2_OID}3": "voPersonCertificateDN",
        f"{VOPERSON_V2_OID}4": "voPersonCertificateIssuerDN",
        f"{VOPERSON_V2_OID}5": "voPersonExternalID",
        f"{VOPERSON_V2_OID}6": "voPersonID",
        f"{VOPERSON_V2_OID}7": "voPersonPolicyAgreement",
        f"{VOPERSON_V2_OID}8": "voPersonSoRID",
        f"{VOPERSON_V2_OID}9": "voPersonStatus",
        f"{VOPERSON_V2_OID}10": "voPersonAffiliation",
        f"{VOPERSON_V2_OID}11": "voPersonExternalAffiliation",
        f"{VOPERSON_V2_OID}12": "voPersonScopedAffiliation",
        f"{VOPERSON_V2_OID}13": "voPersonApplicationPassword",
        f"{VOPERSON_V2_OID}14": "voPersonVerifiedEmail",
        f"{VOPERSON_V2_OID}15": "voPersonToken",
    },
    "to": {
        "LegalPersonIdentifier": f"{EIDAS_LEGALPERSON}LegalPersonIdentifier",
        "LegalAddress": f"{EIDAS_LEGALPERSON}LegalPersonAddress",
        "LegalName": f"{EIDAS_LEGALPERSON}LegalName",
        "VATRegistration": f"{EIDAS_LEGALPERSON}VATRegistrationNumber",
        "TaxReference": f"{EIDAS_LEGALPERSON}TaxReference",
        "BusinessCodes": f"{EIDAS_LEGALPERSON}BusinessCodes",
        "LEI": f"{EIDAS_LEGALPERSON}LEI",
        "EORI": f"{EIDAS_LEGALPERSON}EORI",
        "SEED": f"{EIDAS_LEGALPERSON}SEED",
        "SIC": f"{EIDAS_LEGALPERSON}SIC",
        "D-2012-17-EUIdentifier": f"{EIDAS_LEGALPERSON}D-2012-17-EUIdentifier",
        "PersonIdentifier": f"{EIDAS_NATURALPERSON}PersonIdentifier",
        "FamilyName": f"{EIDAS_NATURALPERSON}CurrentFamilyName",
        "FirstName": f"{EIDAS_NATURALPERSON}CurrentGivenName",
        "DateOfBirth": f"{EIDAS_NATURALPERSON}DateOfBirth",
        "BirthName": f"{EIDAS_NATURALPERSON}BirthName",
        "PlaceOfBirth": f"{EIDAS_NATURALPERSON}PlaceOfBirth",
        "CurrentAddress": f"{EIDAS_NATURALPERSON}CurrentAddress",
        "Gender": f"{EIDAS_NATURALPERSON}Gender",
        "associatedDomain": f"{UCL_DIR_PILOT}37",
        "authContextParams": f"{DIGG_OID}3",
        "authorityRevocationList": f"{X500ATTR_OID}38",
        "authServerSignature": f"{DIGG_OID}13",
        "birthName": f"{DIGG_OID}8",
        "businessCategory": f"{X500ATTR_OID}15",
        "c": f"{X500ATTR_OID}6",
        "cACertificate": f"{X500ATTR_OID}37",
        "carLicense": f"{NETSCAPE_LDAP}1",
        "certificateRevocationList": f"{X500ATTR_OID}39",
        "cn": f"{X500ATTR_OID}3",
        "co": f"{UCL_DIR_PILOT}43",
        "countryOfCitizenship": f"{PKIX_OID}4",
        "countryOfResidence": f"{PKIX_OID}5",
        "crossCertificatePair": f"{X500ATTR_OID}40",
        "dateOfBirth": f"{PKIX_OID}1",
        "dc": f"{UCL_DIR_PILOT}25",
        "deltaRevocationList": f"{X500ATTR_OID}53",
        "departmentNumber": f"{NETSCAPE_LDAP}2",
        "destinationIndicator": f"{X500ATTR_OID}27",
        "displayName": f"{NETSCAPE_LDAP}241",
        "dmdName": f"{X500ATTR_OID}54",
        "dnQualifier": f"{X500ATTR_OID}46",
        "EAAHash": f"{UMBRELLA_EAAUser_ID}1",
        "EAAKey": f"{UMBRELLA_EAAUser_ID}3",
        "eduCourseMember": f"{EDUCOURSE_OID}2",
        "eduCourseOffering": f"{EDUCOURSE_OID}1",
        "eduPersonAffiliation": f"{EDUPERSON_OID}1",
        "eduPersonEntitlement": f"{EDUPERSON_OID}7",
        "eduPersonNickname": f"{EDUPERSON_OID}2",
        "eduPersonOrgDN": f"{EDUPERSON_OID}3",
        "eduPersonOrgUnitDN": f"{EDUPERSON_OID}4",
        "eduPersonPrimaryAffiliation": f"{EDUPERSON_OID}5",
        "eduPersonPrimaryOrgUnitDN": f"{EDUPERSON_OID}8",
        "eduPersonPrincipalName": f"{EDUPERSON_OID}6",
        "eduPersonPrincipalNamePrior": f"{EDUPERSON_OID}12",
        "eduPersonScopedAffiliation": f"{EDUPERSON_OID}9",
        "eduPersonTargetedID": f"{EDUPERSON_OID}10",
        "eduPersonAssurance": f"{EDUPERSON_OID}11",
        "eduPersonUniqueId": f"{EDUPERSON_OID}13",
        "eduPersonOrcid": f"{EDUPERSON_OID}16",
        "eidasNaturalPersonAddress": f"{DIGG_OID}9",
        "eidasPersonIdentifier": f"{DIGG_OID}7",
        "email": f"{PKCS_9}1",
        "employeeHsaId": f"{INERA_OID}1",
        "employeeNumber": f"{NETSCAPE_LDAP}3",
        "employeeType": f"{NETSCAPE_LDAP}4",
        "enhancedSearchGuide": f"{X500ATTR_OID}47",
        "facsimileTelephoneNumber": f"{X500ATTR_OID}23",
        "federationFeideSchemaVersion": f"{NOREDUPERSON_OID}9",
        "gender": f"{PKIX_OID}3",
        "generationQualifier": f"{X500ATTR_OID}44",
        "givenName": f"{X500ATTR_OID}42",
        "houseIdentifier": f"{X500ATTR_OID}51",
        "initials": f"{X500ATTR_OID}43",
        "internationaliSDNNumber": f"{X500ATTR_OID}25",
        "isMemberOf": f"{EDUMEMBER1_OID}1",
        "jpegPhoto": f"{UCL_DIR_PILOT}60",
        "knowledgeInformation": f"{X500ATTR_OID}2",
        "l": f"{X500ATTR_OID}7",
        "labeledURI": f"{UMICH}57",
        "mail": f"{UCL_DIR_PILOT}3",
        "mailLocalAddress": f"{NETSCAPE_LDAP}13",
        "member": f"{X500ATTR_OID}31",
        "norEduOrgAcronym": f"{NOREDUPERSON_OID}6",
        "norEduOrgNIN": f"{NOREDUPERSON_OID}12",
        "norEduOrgSchemaVersion": f"{NOREDUPERSON_OID}11",
        "norEduOrgUniqueIdentifier": f"{NOREDUPERSON_OID}7",
        "norEduOrgUniqueNumber": f"{NOREDUPERSON_OID}1",
        "norEduOrgUnitUniqueIdentifier": f"{NOREDUPERSON_OID}8",
        "norEduOrgUnitUniqueNumber": f"{NOREDUPERSON_OID}2",
        "norEduPersonBirthDate": f"{NOREDUPERSON_OID}3",
        "norEduPersonLIN": f"{NOREDUPERSON_OID}4",
        "norEduPersonLegalName": f"{NOREDUPERSON_OID}10",
        "norEduPersonNIN": f"{NOREDUPERSON_OID}5",
        "o": f"{X500ATTR_OID}10",
        "osiHomeUrl": f"{OPENOSI_OID}17",
        "osiPreferredTZ": f"{OPENOSI_OID}19",
        "osiICardTimeLastUpdated": f"{OPENOSI_OID}72",
        "osiMiddleName": f"{OPENOSI_OID}104",
        "osiOtherEmail": f"{OPENOSI_OID}107",
        "osiOtherHomePhone": f"{OPENOSI_OID}109",
        "osiWorkURL": f"{OPENOSI_OID}120",
        "ou": f"{X500ATTR_OID}11",
        "orgAffiliation": f"{DIGG_OID}1",
        "owner": f"{X500ATTR_OID}32",
        "pairwise-id": f"{SAML_SUBJECT_ID}pairwise-id",
        "personalIdentityNumber": f"{INERA_OID}13",
        "personalIdentityNumberBinding": f"{DIGG_OID}6",
        "physicalDeliveryOfficeName": f"{X500ATTR_OID}19",
        "placeOfBirth": f"{PKIX_OID}2",
        "postOfficeBox": f"{X500ATTR_OID}18",
        "postalAddress": f"{X500ATTR_OID}16",
        "postalCode": f"{X500ATTR_OID}17",
        "preferredDeliveryMethod": f"{X500ATTR_OID}28",
        "preferredLanguage": f"{NETSCAPE_LDAP}39",
        "presentationAddress": f"{X500ATTR_OID}29",
        "prid": f"{DIGG_OID}4",
        "pridPersistence": f"{DIGG_OID}5",
        "protocolInformation": f"{X500ATTR_OID}48",
        "pseudonym": f"{X500ATTR_OID}65",
        "PVP-USERID": f"{LDAPGVAT_UCL_DIR_PILOT}1",
        "PVP-MAIL": f"{LDAPGVAT_UCL_DIR_PILOT}3",
        "PVP-GID": f"{LDAPGVAT_OID}1",
        "PVP-BPK": f"{LDAPGVAT_OID}149",
        "PVP-OU-OKZ": f"{LDAPGVAT_OID}153",
        "PVP-VERSION": f"{LDAPGVAT_OID}261.10",
        "PVP-PRINCIPAL-NAME": f"{LDAPGVAT_OID}261.20",
        "PVP-PARTICIPANT-OKZ": f"{LDAPGVAT_OID}261.24",
        "PVP-ROLES": f"{LDAPGVAT_OID}261.30",
        "PVP-INVOICE-RECPT-ID": f"{LDAPGVAT_OID}261.40",
        "PVP-COST-CENTER-ID": f"{LDAPGVAT_OID}261.50",
        "PVP-CHARGE-CODE": f"{LDAPGVAT_OID}261.60",
        "PVP-OU-GV-OU-ID": f"{LDAPGVAT_OID}3",
        "PVP-FUNCTION": f"{LDAPGVAT_OID}33",
        "PVP-BIRTHDATE": f"{LDAPGVAT_OID}55",
        "PVP-PARTICIPANT-ID": f"{LDAPGVAT_OID}71",
        "PVP-OU": f"{LDAPGVAT_X500ATTR_OID}11",
        "PVP-TEL": f"{LDAPGVAT_X500ATTR_OID}20",
        "PVP-GIVENNAME": f"{LDAPGVAT_X500ATTR_OID}42",
        "registeredAddress": f"{X500ATTR_OID}26",
        "roleOccupant": f"{X500ATTR_OID}33",
        "sad": f"{DIGG_OID}12",
        "schacCountryOfCitizenship": f"{SCHAC}5",
        "schacCountryOfResidence": f"{SCHAC}11",
        "schacDateOfBirth": f"{SCHAC}3",
        "schacExpiryDate": f"{SCHAC}17",
        "schacGender": f"{SCHAC}2",
        "schacHomeOrganization": f"{SCHAC}9",
        "schacHomeOrganizationType": f"{SCHAC}10",
        "schacMotherTongue": f"{SCHAC}1",
        "schacPersonalPosition": f"{SCHAC}13",
        "schacPersonalTitle": f"{SCHAC}8",
        "schacPersonalUniqueCode": f"{SCHAC}14",
        "schacPersonalUniqueID": f"{SCHAC}15",
        "schacPlaceOfBirth": f"{SCHAC}4",
        "schacProjectMembership": f"{SCHAC}20",
        "schacProjectSpecificRole": f"{SCHAC}21",
        "schacSn1": f"{SCHAC}6",
        "schacSn2": f"{SCHAC}7",
        "schacUserPresenceID": f"{SCHAC}12",
        "schacUserPrivateAttribute": f"{SCHAC}18",
        "schacUserStatus": f"{SCHAC}19",
        "searchGuide": f"{X500ATTR_OID}14",
        "serialNumber": f"{X500ATTR_OID}5",
        "signMessageDigest": f"{DIGG_OID}14",
        "sisLegalGuardianFor": f"{SIS}1",
        "sisSchoolGrade": f"{SIS}2",
        "sn": f"{X500ATTR_OID}4",
        "st": f"{X500ATTR_OID}8",
        "street": f"{X500ATTR_OID}9",
        "subject-id": f"{SAML_SUBJECT_ID}subject-id",
        "supportedAlgorithms": f"{X500ATTR_OID}52",
        "supportedApplicationContext": f"{X500ATTR_OID}30",
        "telephoneNumber": f"{X500ATTR_OID}20",
        "teletexTerminalIdentifier": f"{X500ATTR_OID}22",
        "telexNumber": f"{X500ATTR_OID}21",
        "title": f"{X500ATTR_OID}12",
        "transactionIdentifier": f"{DIGG_OID}2",
        "uid": f"{UCL_DIR_PILOT}1",
        "uniqueMember": f"{X500ATTR_OID}50",
        "userCertificate": f"{X500ATTR_OID}36",
        #  'userCertificate': DIGG_OID+'10',
        "userPKCS12": f"{NETSCAPE_LDAP}216",
        "userSMIMECertificate": f"{NETSCAPE_LDAP}40",
        "userSignature": f"{DIGG_OID}11",
        "x121Address": f"{X500ATTR_OID}24",
        "x500UniqueIdentifier": f"{X500ATTR_OID}45",
        "swissEduPersonUniqueID": f"{SWISSEDUPERSON_OID}1",
        "swissEduPersonDateOfBirth": f"{SWISSEDUPERSON_OID}2",
        "swissEduPersonGender": f"{SWISSEDUPERSON_OID}3",
        "swissEduPersonHomeOrganization": f"{SWISSEDUPERSON_OID}4",
        "swissEduPersonHomeOrganizationType": f"{SWISSEDUPERSON_OID}5",
        "swissEduPersonStudyBranch1": f"{SWISSEDUPERSON_OID}6",
        "swissEduPersonStudyBranch2": f"{SWISSEDUPERSON_OID}7",
        "swissEduPersonStudyBranch3": f"{SWISSEDUPERSON_OID}8",
        "swissEduPersonStudyLevel": f"{SWISSEDUPERSON_OID}9",
        "swissEduPersonStaffCategory": f"{SWISSEDUPERSON_OID}10",
        "swissEduPersonMatriculationNumber": f"{SWISSEDUPERSON_OID}11",
        "swissEduPersonCardUID": f"{SWISSEDUPERSON_OID}12",
        "swissEduID": f"{SWISSEDUPERSON_OID}13",
        "swissLibraryPersonAffiliation": f"{SWISSEDUPERSON_OID}1023",
        "swissLibraryPersonResidence": f"{SWISSEDUPERSON_OID}1025",
        "voPersonAffiliation": f"{VOPERSON_V2_OID}10",
        "voPersonApplicationPassword": f"{VOPERSON_V2_OID}13",
        "voPersonApplicationUID": f"{VOPERSON_V2_OID}1",
        "voPersonAuthorName": f"{VOPERSON_V2_OID}2",
        "voPersonCertificateDN": f"{VOPERSON_V2_OID}3",
        "voPersonCertificateIssuerDN": f"{VOPERSON_V2_OID}4",
        "voPersonExternalAffiliation": f"{VOPERSON_V2_OID}11",
        "voPersonExternalID": f"{VOPERSON_V2_OID}5",
        "voPersonID": f"{VOPERSON_V2_OID}6",
        "voPersonPolicyAgreement": f"{VOPERSON_V2_OID}7",
        "voPersonScopedAffiliation": f"{VOPERSON_V2_OID}12",
        "voPersonSoRID": f"{VOPERSON_V2_OID}8",
        "voPersonStatus": f"{VOPERSON_V2_OID}9",
        "voPersonToken": f"{VOPERSON_V2_OID}15",
        "voPersonVerifiedEmail": f"{VOPERSON_V2_OID}14",
    },
}
