/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.ext.socket;

import java.io.IOException;
import java.nio.channels.SelectableChannel;
import jnr.unixsocket.UnixServerSocketChannel;
import jnr.unixsocket.UnixSocketAddress;
import jnr.unixsocket.UnixSocketChannel;
import org.jruby.Ruby;
import org.jruby.RubyClass;
import org.jruby.RubySymbol;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.ext.socket.RubyUNIXSocket;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;

@JRubyClass(name={"UNIXServer"}, parent="UNIXSocket")
public class RubyUNIXServer
extends RubyUNIXSocket {
    static void createUNIXServer(Ruby runtime2) {
        RubyClass rb_cUNIXServer = runtime2.defineClass("UNIXServer", runtime2.getClass("UNIXSocket"), RubyUNIXServer::new);
        runtime2.getObject().setConstant("UNIXserver", rb_cUNIXServer);
        rb_cUNIXServer.defineAnnotatedMethods(RubyUNIXServer.class);
    }

    public RubyUNIXServer(Ruby runtime2, RubyClass type2) {
        super(runtime2, type2);
    }

    @Override
    @JRubyMethod(visibility=Visibility.PRIVATE)
    public IRubyObject initialize(ThreadContext context, IRubyObject path2) {
        this.init_unixsock(context.runtime, path2, true);
        return this;
    }

    @JRubyMethod
    public IRubyObject accept(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        try {
            boolean ready;
            while (!(ready = context.getThread().select(this, 16))) {
                context.pollThreadEvents();
            }
            UnixSocketChannel socketChannel = this.asUnixServer().accept();
            RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, runtime2.getClass("UNIXSocket"), "allocate");
            sock.init_sock(context.runtime, socketChannel, "");
            return sock;
        }
        catch (IOException ioe) {
            throw context.runtime.newIOErrorFromException(ioe);
        }
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context) {
        return this.accept_nonblock(context, context.runtime, true);
    }

    @JRubyMethod
    public IRubyObject accept_nonblock(ThreadContext context, IRubyObject opts) {
        return this.accept_nonblock(context, context.runtime, RubyUNIXServer.extractExceptionArg(context, opts));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IRubyObject accept_nonblock(ThreadContext context, Ruby runtime2, boolean ex) {
        SelectableChannel selectable = (SelectableChannel)this.getChannel();
        Object object = selectable.blockingLock();
        synchronized (object) {
            boolean oldBlocking = selectable.isBlocking();
            try {
                selectable.configureBlocking(false);
                try {
                    UnixSocketChannel socketChannel = ((UnixServerSocketChannel)selectable).accept();
                    if (socketChannel == null) {
                        if (!ex) {
                            RubySymbol rubySymbol = runtime2.newSymbol("wait_readable");
                            return rubySymbol;
                        }
                        throw runtime2.newErrnoEAGAINReadableError("accept(2) would block");
                    }
                    RubyUNIXSocket sock = (RubyUNIXSocket)Helpers.invoke(context, runtime2.getClass("UNIXSocket"), "allocate");
                    sock.init_sock(context.runtime, socketChannel, "");
                    RubyUNIXSocket rubyUNIXSocket = sock;
                    return rubyUNIXSocket;
                }
                finally {
                    selectable.configureBlocking(oldBlocking);
                }
            }
            catch (IOException ioe) {
                if (!ioe.getMessage().equals("accept failed: Resource temporarily unavailable")) {
                    throw context.runtime.newIOErrorFromException(ioe);
                }
                if (!ex) {
                    return runtime2.newSymbol("wait_readable");
                }
                throw runtime2.newErrnoEAGAINReadableError("accept");
            }
        }
    }

    @JRubyMethod
    public IRubyObject listen(ThreadContext context, IRubyObject log3) {
        return context.runtime.newFixnum(0);
    }

    @JRubyMethod
    public IRubyObject sysaccept(ThreadContext context) {
        RubyUNIXSocket socket2 = (RubyUNIXSocket)this.accept(context);
        return context.runtime.newFixnum(((UnixSocketChannel)socket2.getChannel()).getFD());
    }

    @Override
    @JRubyMethod
    public IRubyObject path(ThreadContext context) {
        return context.runtime.newString(this.openFile.getPath());
    }

    @Override
    @JRubyMethod
    public IRubyObject addr(ThreadContext context) {
        Ruby runtime2 = context.runtime;
        return runtime2.newArray((IRubyObject)runtime2.newString("AF_UNIX"), (IRubyObject)runtime2.newString(this.openFile.getPath()));
    }

    @Override
    @JRubyMethod
    public IRubyObject peeraddr(ThreadContext context) {
        throw context.runtime.newErrnoENOTCONNError();
    }

    @Override
    protected UnixSocketAddress getUnixSocketAddress() {
        UnixSocketAddress socketAddress = ((UnixServerSocketChannel)this.getChannel()).getLocalSocketAddress();
        if (socketAddress instanceof UnixSocketAddress) {
            return socketAddress;
        }
        return null;
    }

    @Override
    protected UnixSocketAddress getUnixRemoteSocket() {
        UnixSocketAddress socketAddress = ((UnixServerSocketChannel)this.getChannel()).getLocalSocketAddress();
        if (socketAddress instanceof UnixSocketAddress) {
            return socketAddress;
        }
        return null;
    }

    private UnixServerSocketChannel asUnixServer() {
        return (UnixServerSocketChannel)this.getChannel();
    }
}

