'use strict'

const path    = require('path')
const resolve = require('rollup-plugin-node-resolve')
const common  = require('rollup-plugin-commonjs')

const BUNDLE  = process.env.BUNDLE === 'true'

let fileDest  = 'Chart.js'
const plugins = [
  resolve({
    customResolveOptions: {
      moduleDirectory: ['/usr/lib/nodejs','debian/node_modules']
    }
  }),
  common()
]
module.exports = {
  input: 'src/chart.js',
  output: {
    file: path.resolve(__dirname, `../dist/${fileDest}`),
    format: 'umd',
    name: 'Chart'
  },
  plugins
}
